/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.client.metadata;

import com.google.api.services.bigquery.model.DatasetReference;
import com.simba.googlebigquery.dsi.dataengine.filters.IFilter;
import com.simba.googlebigquery.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.simba.googlebigquery.googlebigquery.client.metadata.BQFetchColumnsTask;
import com.simba.googlebigquery.googlebigquery.client.metadata.BQMetadataExecutor;
import com.simba.googlebigquery.googlebigquery.client.metadata.BQMetadataResult;
import com.simba.googlebigquery.googlebigquery.client.metadata.BQMetadataRetryRequest;
import com.simba.googlebigquery.googlebigquery.client.metadata.BQThreadPoolExecutor;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQMetadataSource;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQMetadataUtils;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQTable;
import com.simba.googlebigquery.support.ILogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class BQFetchTablesTask
implements Callable<BQMetadataResult> {
    private BQMetadataUtils m_bqMetadataUtils;
    private final ILogger m_connLogger;
    private String m_dataset;
    private IFilter[] m_filters;
    private String m_project;
    private Map<MetadataSourceColumnTag, String> m_restrictions;
    private BQThreadPoolExecutor m_threadpool;
    private BQMetadataExecutor.FetchType m_type;

    public BQFetchTablesTask(ILogger iLogger, BQThreadPoolExecutor bQThreadPoolExecutor, BQMetadataUtils bQMetadataUtils, DatasetReference datasetReference, BQMetadataExecutor.FetchType fetchType, IFilter[] iFilterArray, Map<MetadataSourceColumnTag, String> map) {
        this.m_bqMetadataUtils = bQMetadataUtils;
        this.m_connLogger = iLogger;
        this.m_dataset = datasetReference.getDatasetId();
        this.m_project = datasetReference.getProjectId();
        this.m_threadpool = bQThreadPoolExecutor;
        this.m_type = fetchType;
        this.m_filters = iFilterArray;
        this.m_restrictions = map;
    }

    @Override
    public BQMetadataResult call() throws Exception {
        BQTable bQTable;
        Iterator iterator;
        Object object;
        BQMetadataRetryRequest<List<BQTable>> bQMetadataRetryRequest = new BQMetadataRetryRequest<List<BQTable>>(this.m_connLogger){

            @Override
            public List<BQTable> execute() throws Exception {
                return BQFetchTablesTask.this.m_bqMetadataUtils.getTables(BQFetchTablesTask.this.m_project, BQFetchTablesTask.this.m_dataset, null, null);
            }
        };
        Object object2 = (List)bQMetadataRetryRequest.executeWithRetry();
        if (null != this.m_filters[2] && object2.size() > 0) {
            object = new ArrayList();
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                bQTable = (BQTable)iterator.next();
                if (null != this.m_restrictions.get((Object)MetadataSourceColumnTag.TABLE_NAME) && bQTable.getTableName().equals(this.m_restrictions.get((Object)MetadataSourceColumnTag.TABLE_NAME))) {
                    object.add(bQTable);
                    continue;
                }
                if (!BQMetadataSource.doesMetadataPassFilter(bQTable.getTableName(), this.m_filters[2])) continue;
                object.add(bQTable);
            }
            object2 = object;
        }
        object = new BQMetadataResult();
        ((BQMetadataResult)object).addTables((List<BQTable>)object2);
        if (BQMetadataExecutor.FetchType.COLUMN == this.m_type) {
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                bQTable = (BQTable)iterator.next();
                this.m_threadpool.submit(new BQFetchColumnsTask(this.m_connLogger, this.m_bqMetadataUtils, bQTable, this.m_filters, this.m_restrictions));
            }
        }
        return object;
    }
}

