/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.client.metadata;

import com.simba.googlebigquery.googlebigquery.client.metadata.BQMetadataResult;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;

public class BQThreadPoolExecutor {
    private CompletionService<BQMetadataResult> m_completionService;
    private ExecutorService m_executorService;
    private AtomicInteger m_taskCount;

    public BQThreadPoolExecutor(int n) {
        this.m_executorService = Executors.newFixedThreadPool(n);
        this.m_completionService = new ExecutorCompletionService<BQMetadataResult>(this.m_executorService);
        this.m_taskCount = new AtomicInteger(0);
    }

    public void submit(Callable<BQMetadataResult> callable) {
        this.m_completionService.submit(callable);
        this.m_taskCount.getAndIncrement();
    }

    public BQMetadataResult take() throws ExecutionException, InterruptedException {
        Future<BQMetadataResult> future = this.m_completionService.take();
        BQMetadataResult bQMetadataResult = future.get();
        this.m_taskCount.decrementAndGet();
        return bQMetadataResult;
    }

    public int getTaskCount() {
        return this.m_taskCount.get();
    }

    public void shutdownNow() {
        this.m_executorService.shutdownNow();
    }
}

