/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.dataengine;

import com.simba.googlebigquery.dsi.dataengine.interfaces.IQueryExecutor;
import com.simba.googlebigquery.dsi.dataengine.interfaces.IResults;
import com.simba.googlebigquery.dsi.dataengine.utilities.ExecutionResult;
import com.simba.googlebigquery.dsi.dataengine.utilities.ExecutionResults;
import com.simba.googlebigquery.dsi.dataengine.utilities.ParameterInputValue;
import com.simba.googlebigquery.dsi.dataengine.utilities.ParameterMetadata;
import com.simba.googlebigquery.dsi.dataengine.utilities.TypeMetadata;
import com.simba.googlebigquery.dsi.exceptions.BadDefaultParamException;
import com.simba.googlebigquery.googlebigquery.BQExecutionContext;
import com.simba.googlebigquery.googlebigquery.client.BQClient;
import com.simba.googlebigquery.googlebigquery.client.IBQResponse;
import com.simba.googlebigquery.googlebigquery.core.BQConnection;
import com.simba.googlebigquery.googlebigquery.core.BQConnectionOptions;
import com.simba.googlebigquery.googlebigquery.core.BQDriver;
import com.simba.googlebigquery.googlebigquery.dataengine.BQResultSet;
import com.simba.googlebigquery.googlebigquery.exceptions.BQMessageKey;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class BQAbstractExecutor
implements IQueryExecutor {
    protected BQClient m_client;
    protected BQConnection m_connection;
    protected BQConnectionOptions m_connectionOptions;
    protected BQExecutionContext m_executionContext;
    protected AtomicBoolean m_isCancelledFlag = new AtomicBoolean(false);
    protected final Object m_isCancelledFlagLock = new Object();
    protected boolean m_isDirectExecute;
    protected boolean m_isParameterized;
    protected boolean m_isRowCount;
    protected ILogger m_logger;
    protected ArrayList<ParameterMetadata> m_parameters = new ArrayList();
    protected ExecutionResults m_results = new ExecutionResults();
    protected List<String> m_queries;
    protected Vector<IBQResponse> m_executedQueryInfoList = null;
    protected Vector<IBQResponse> m_preparedQueryInfoList = null;

    public BQAbstractExecutor(ILogger iLogger, BQConnection bQConnection, List<String> list) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, bQConnection, list);
        this.m_logger = iLogger;
        this.m_connection = bQConnection;
        this.m_client = bQConnection.getClient();
        this.m_queries = list;
        this.m_connectionOptions = bQConnection.getSettings();
        this.m_executionContext = new BQExecutionContext();
        this.m_executionContext.projectId = this.m_connectionOptions.m_projectId;
        this.m_executionContext.defaultDataset = this.m_connectionOptions.m_defaultDataSet;
        this.m_executionContext.queryDialect = this.m_connectionOptions.m_queryDialect;
        this.m_executionContext.KMSKeyName = this.m_connectionOptions.m_KMSKeyName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelExecute() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        Object object = this.m_isCancelledFlagLock;
        synchronized (object) {
            this.m_isCancelledFlag.set(true);
        }
        if (null != this.m_executedQueryInfoList && !this.m_executedQueryInfoList.isEmpty()) {
            this.m_client.cancelQuery(this.m_connectionOptions.m_projectId, this.m_executedQueryInfoList.get(0).getExecutedJob().getJobReference().getJobId(), this.m_executedQueryInfoList.get(0).getExecutedJob().getJobReference().getLocation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCancel() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        Object object = this.m_isCancelledFlagLock;
        synchronized (object) {
            this.m_isCancelledFlag.set(false);
        }
    }

    @Override
    public void clearPushedParamData() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (!this.m_results.getResults().isEmpty()) {
            for (ExecutionResult executionResult : this.m_results.getResults()) {
                if (null == executionResult.getResult() || !(executionResult.getResult() instanceof BQResultSet)) continue;
                ((BQResultSet)executionResult.getResult()).close();
            }
        }
    }

    public void execute() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_executedQueryInfoList.add(this.m_client.executeQuery(this.m_executionContext, this.m_isCancelledFlagLock, this.m_isCancelledFlag));
    }

    @Override
    public void finalizePushedParamData() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public int getNumParams() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_executionContext.bqParameters.size();
    }

    @Override
    public IResults getResults() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_results;
    }

    public abstract void internalPrepare() throws ErrorException;

    @Override
    public void pushMappedParamTypes(Map<Integer, TypeMetadata> map) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public void pushParamData(int n, ParameterInputValue parameterInputValue) throws BadDefaultParamException, ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.EXEC_PARAM_UNSUPPORTED_ERR.name());
    }
}

