/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.dataengine;

import com.google.api.client.util.Base64;
import com.simba.googlebigquery.dsi.dataengine.utilities.ColumnMetadata;
import com.simba.googlebigquery.dsi.dataengine.utilities.DSITypeUtilities;
import com.simba.googlebigquery.dsi.dataengine.utilities.DataWrapper;
import com.simba.googlebigquery.dsi.dataengine.utilities.TimestampTz;
import com.simba.googlebigquery.dsi.dataengine.utilities.TypeMetadata;
import com.simba.googlebigquery.googlebigquery.utils.BQCoreUtils;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.IndexedRecord;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;

public class BQHTParser {
    public static final String AVRO_SCHEMA_PRECISION = "precision";
    public static final String AVRO_SCHEMA_SCALE = "scale";
    public static final String AVRO_LOGICAL_DATE = "date";
    public static final String AVRO_LOGICAL_DECIMAL = "decimal";
    public static final String AVRO_LOGICAL_TIME_MICROS = "time-micros";
    public static final String AVRO_LOGICAL_TIME_MILLIS = "time-millis";
    public static final String AVRO_LOGICAL_TIMESTAMP_MICROS = "timestamp-micros";
    public static final String AVRO_LOGICAL_TIMESTAMP_MILLIS = "timestamp-millis";
    public static final String AVRO_PRIMITIVE_BYTES = "bytes";
    public static final String AVRO_SCHEMA_LOGICALTYPE = "logicalType";
    public static final int MILLIS_TO_NANOS_MULTIPLIER = 1000000;

    private BQHTParser() {
    }

    public static boolean getDataHTAPI(short s, TypeMetadata typeMetadata, long l, long l2, DataWrapper dataWrapper, Object object, Schema.Field field, ILogger iLogger) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        String string = typeMetadata.getTypeName();
        switch (s) {
            case 12: {
                return DSITypeUtilities.outputVarCharStringData(object.toString(), dataWrapper, l, l2);
            }
            case -5: {
                dataWrapper.setBigInt((Long)object);
                return false;
            }
            case 8: {
                dataWrapper.setDouble((Double)object);
                return false;
            }
            case 16: {
                dataWrapper.setBoolean((Boolean)object);
                return false;
            }
            case 91: {
                Date date = BQHTParser.dateToString(object);
                dataWrapper.setDate(date);
                return false;
            }
            case 92: {
                BQHTParser.timeToString(object, null, dataWrapper);
                return false;
            }
            case 93: {
                if (string.equals("TIMESTAMP")) {
                    dataWrapper.setTimestamp(BQHTParser.timetampToString(object));
                } else {
                    String string2 = object.toString().replace('T', ' ');
                    dataWrapper.setTimestamp(Timestamp.valueOf(string2));
                }
                return false;
            }
            case -3: {
                dataWrapper.setVarBinary(((ByteBuffer)object).array());
                return false;
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = BQHTParser.numDecimalToString(iLogger, object, field.schema());
                dataWrapper.setNumeric(bigDecimal);
                return false;
            }
        }
        return false;
    }

    private static <T> String avroArrayToString(ILogger iLogger, Object object, StringBuilder stringBuilder, LogicalType logicalType, int n, List<ColumnMetadata> list) throws ErrorException {
        GenericArray genericArray = (GenericArray)object;
        stringBuilder.append("[");
        int n2 = 0;
        Schema schema = genericArray.getSchema();
        Schema.Type type = schema.getElementType().getType();
        for (Object e : genericArray) {
            if (null != e) {
                BQHTParser.avroToString(iLogger, e, type, stringBuilder, logicalType, schema, n, list);
            } else {
                stringBuilder.append(object.hashCode());
            }
            if (++n2 >= genericArray.size()) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static <T> String avroToString(ILogger iLogger, T t, Schema.Type type, StringBuilder stringBuilder, LogicalType logicalType, Schema schema, int n, List<ColumnMetadata> list) throws ErrorException {
        stringBuilder.append("{");
        stringBuilder.append("\"v\":");
        if (Schema.Type.ARRAY == type) {
            BQHTParser.avroArrayToString(iLogger, (GenericArray)t, stringBuilder, logicalType, n, list);
        } else if (Schema.Type.RECORD == type) {
            BQHTParser.avroStructToString(iLogger, (IndexedRecord)t, stringBuilder, logicalType, n, list);
        } else if (null != t) {
            stringBuilder.append("\"");
            if (Schema.Type.BYTES == type && null == logicalType) {
                logicalType = new LogicalType(AVRO_PRIMITIVE_BYTES);
            }
            if (null != logicalType) {
                switch (logicalType.getName().toLowerCase()) {
                    case "timestamp-micros": 
                    case "timestamp-millis": {
                        stringBuilder.append(BQHTParser.timetampToString(t).toString());
                        break;
                    }
                    case "time-micros": 
                    case "time-millis": {
                        BQHTParser.timeToString(t, stringBuilder, null);
                        break;
                    }
                    case "decimal": {
                        BigDecimal bigDecimal = BQHTParser.numDecimalToString(iLogger, t, schema);
                        stringBuilder.append(bigDecimal.toString());
                        break;
                    }
                    case "date": {
                        Date date = BQHTParser.dateToString(t);
                        stringBuilder.append(date.toString());
                        break;
                    }
                    case "bytes": {
                        Object object;
                        boolean bl = false;
                        if (-1 != n) {
                            object = list.get(n).getName().toUpperCase();
                            boolean bl2 = bl = ((String)object).contains("NUMERIC") || ((String)object).contains("BIGNUMERIC");
                        }
                        if (bl) {
                            object = BQHTParser.numDecimalToString(iLogger, t, schema);
                            stringBuilder.append(((BigDecimal)object).toString());
                            break;
                        }
                        object = ((ByteBuffer)t).array();
                        stringBuilder.append(Base64.encodeBase64String((byte[])object));
                        break;
                    }
                    default: {
                        stringBuilder.append(t);
                        break;
                    }
                }
            } else {
                String string = null;
                if (type != null) {
                    string = type.getName();
                }
                if (type == Schema.Type.STRING && schema != null) {
                    if (Schema.Type.UNION == schema.getType() && ((Schema)schema.getTypes().get(1)).getObjectProps().size() != 0) {
                        string = (String)((Schema)schema.getTypes().get(1)).getObjectProps().get(AVRO_SCHEMA_LOGICALTYPE);
                    } else if (Schema.Type.ARRAY == schema.getType()) {
                        string = (String)schema.getElementType().getObjectProps().get(AVRO_SCHEMA_LOGICALTYPE);
                    }
                }
                if (string != null && string.equalsIgnoreCase("DATETIME")) {
                    stringBuilder.append(t.toString().replace('T', ' '));
                } else if (string != null && string.equalsIgnoreCase("boolean")) {
                    if (t.toString().equalsIgnoreCase("true")) {
                        stringBuilder.append("1");
                    } else {
                        stringBuilder.append("0");
                    }
                } else {
                    stringBuilder.append(t);
                }
            }
            stringBuilder.append("\"");
        } else {
            stringBuilder.append(t);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private static String avroStructToString(ILogger iLogger, IndexedRecord indexedRecord, StringBuilder stringBuilder, LogicalType logicalType, int n, List<ColumnMetadata> list) throws ErrorException {
        stringBuilder.append("{");
        stringBuilder.append("\"f\":[");
        int n2 = indexedRecord.getSchema().getFields().size();
        for (int i = 0; i < n2; ++i) {
            Schema.Field field = (Schema.Field)indexedRecord.getSchema().getFields().get(i);
            Schema schema = field.schema();
            if (Schema.Type.UNION == schema.getType()) {
                logicalType = ((Schema)schema.getTypes().get(1)).getLogicalType();
                for (Schema schema2 : schema.getTypes()) {
                    Schema.Type type = schema2.getType();
                    if (Schema.Type.NULL == type) continue;
                    BQHTParser.avroToString(iLogger, indexedRecord.get(i), type, stringBuilder, logicalType, schema, n, list);
                }
            } else {
                BQHTParser.avroToString(iLogger, indexedRecord.get(i), schema.getType(), stringBuilder, logicalType, null, n, list);
            }
            if (i >= n2 - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]}");
        return stringBuilder.toString();
    }

    private static <T> Date dateToString(T t) {
        Integer n = (Integer)t;
        Long l = (long)n.intValue() * 86400000L;
        Long l2 = l - (long)TimeZone.getDefault().getRawOffset();
        DateTime dateTime = new DateTime((Object)l2, (Chronology)ISOChronology.getInstance());
        Date date = new Date(dateTime.toLocalDate().toDate().getTime());
        return date;
    }

    private static <T> BigDecimal numDecimalToString(ILogger iLogger, T t, Schema schema) throws RuntimeException {
        Object object;
        Object object2;
        int n = 38;
        int n2 = 9;
        try {
            object2 = null;
            object = null;
            if (Schema.Type.UNION == schema.getType()) {
                object2 = ((Schema)schema.getTypes().get(1)).getObjectProp(AVRO_SCHEMA_PRECISION).toString();
                object = ((Schema)schema.getTypes().get(1)).getObjectProp(AVRO_SCHEMA_SCALE).toString();
            } else {
                object2 = schema.getElementType().getObjectProp(AVRO_SCHEMA_PRECISION).toString();
                object = schema.getElementType().getObjectProp(AVRO_SCHEMA_SCALE).toString();
            }
            n = Integer.valueOf((String)object2);
            n2 = Integer.valueOf((String)object);
        }
        catch (RuntimeException runtimeException) {
            LogUtilities.logError(runtimeException, iLogger);
            LogUtilities.logError("Error parsing Precision/Scale from Array or Struct. Defaulting to Numeric.", iLogger);
        }
        object2 = new Conversions.DecimalConversion();
        object = LogicalTypes.decimal((int)n, (int)n2);
        ByteBuffer byteBuffer = (ByteBuffer)t;
        byteBuffer.position(0);
        return object2.fromBytes(byteBuffer, schema, (LogicalType)object);
    }

    private static <T> void timeToString(T t, StringBuilder stringBuilder, DataWrapper dataWrapper) {
        Long l = (Long)t;
        Long l2 = l / 1000L;
        int n = (int)(l2 / 3600000L % 24L);
        int n2 = (int)(l2 / 60000L % 60L);
        int n3 = (int)(l2 / 1000L % 60L);
        int n4 = (int)(l % 1000000L * 1000L);
        if (null != dataWrapper) {
            dataWrapper.setTime(n, n2, n3, n4);
            return;
        }
        if (null != stringBuilder) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(1970, 0, 1, n, n2, n3);
            calendar.set(14, n4 / 1000000);
            Time time = new Time(calendar.getTimeInMillis());
            stringBuilder.append(time.toString());
        }
    }

    private static <T> TimestampTz timetampToString(T t) throws ErrorException {
        Double d = ((Long)t).doubleValue();
        return BQCoreUtils.convertUnixToTimestamp(d / 1000000.0);
    }
}

