/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.dataengine.metadata;

import com.simba.googlebigquery.dsi.dataengine.filters.IFilter;
import com.simba.googlebigquery.dsi.dataengine.utilities.DSITypeUtilities;
import com.simba.googlebigquery.dsi.dataengine.utilities.DataWrapper;
import com.simba.googlebigquery.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.simba.googlebigquery.dsi.dataengine.utilities.TypeMetadata;
import com.simba.googlebigquery.dsi.dataengine.utilities.TypeUtilities;
import com.simba.googlebigquery.googlebigquery.core.BQConnection;
import com.simba.googlebigquery.googlebigquery.core.BQDriver;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQFunctionColumn;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQMetadataSource;
import com.simba.googlebigquery.googlebigquery.exceptions.BQMessageKey;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.util.Map;

public class BQFunctionColumnMetadataSource
extends BQMetadataSource {
    private boolean m_isFunctionColumn = true;

    public BQFunctionColumnMetadataSource(ILogger iLogger, BQConnection bQConnection, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        super(iLogger, bQConnection, map);
        LogUtilities.logFunctionEntrance(iLogger, iLogger);
        this.m_filters = new IFilter[5];
        if (null != this.m_restrictions.get((Object)MetadataSourceColumnTag.CATALOG_NAME) && null != this.m_restrictions.get((Object)MetadataSourceColumnTag.SCHEMA_NAME) && null != this.m_restrictions.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME)) {
            this.m_haveAllRestrictions = true;
        }
    }

    public BQFunctionColumnMetadataSource(ILogger iLogger, BQConnection bQConnection, Map<MetadataSourceColumnTag, String> map, boolean bl) throws ErrorException {
        this(iLogger, bQConnection, map);
        this.m_isFunctionColumn = bl;
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.closeCursor();
    }

    @Override
    public void closeCursor() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_hasStartedFunctionColumnsFetch = false;
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        if (null != this.m_cachedException) {
            throw this.m_cachedException;
        }
        BQFunctionColumn bQFunctionColumn = (BQFunctionColumn)this.m_functionColumns.get(this.m_functionColumnIdx);
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                return DSITypeUtilities.outputVarCharStringData(bQFunctionColumn.getCatalogName(), dataWrapper, l, l2);
            }
            case SCHEMA_NAME: {
                return DSITypeUtilities.outputVarCharStringData(bQFunctionColumn.getSchemaName(), dataWrapper, l, l2);
            }
            case PROCEDURE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(bQFunctionColumn.getFunctionName(), dataWrapper, l, l2);
            }
            case COLUMN_NAME: {
                if (null != bQFunctionColumn.getName()) {
                    return DSITypeUtilities.outputVarCharStringData(bQFunctionColumn.getName(), dataWrapper, l, l2);
                }
                dataWrapper.setNull(12);
                return false;
            }
            case PROCEDURE_COLUMN_TYPE: {
                dataWrapper.setSmallInt(bQFunctionColumn.getColType());
                return false;
            }
            case DATA_TYPE: {
                int n = bQFunctionColumn.getDataType();
                if (-1 != n) {
                    dataWrapper.setSmallInt(n);
                } else {
                    dataWrapper.setNull(5);
                }
                return false;
            }
            case DATA_TYPE_NAME: {
                if (null != bQFunctionColumn.getTypeName()) {
                    return DSITypeUtilities.outputVarCharStringData(bQFunctionColumn.getTypeName(), dataWrapper, l, l2);
                }
                dataWrapper.setNull(12);
                return false;
            }
            case COLUMN_SIZE: {
                if (null != bQFunctionColumn.getTypeMetadata()) {
                    dataWrapper.setInteger((int)TypeUtilities.getColumnSize(bQFunctionColumn.getTypeMetadata(), bQFunctionColumn.getColumnLength()));
                } else {
                    dataWrapper.setNull(4);
                }
                return false;
            }
            case BUFFER_LENGTH: {
                dataWrapper.setInteger(bQFunctionColumn.getByteLength());
                return false;
            }
            case NULLABLE: {
                dataWrapper.setSmallInt(bQFunctionColumn.getNullable().ordinal());
                return false;
            }
            case IS_NULLABLE: {
                return DSITypeUtilities.outputVarCharStringData(bQFunctionColumn.getNullable().isNullable().toUpperCase(), dataWrapper, l, l2);
            }
            case CHAR_OCTET_LENGTH: {
                Long l3 = null;
                if (bQFunctionColumn.isCharacterOrBinaryType()) {
                    l3 = new Long(bQFunctionColumn.getByteLength());
                }
                dataWrapper.setInteger(l3);
                return false;
            }
            case ORDINAL_POSITION: {
                dataWrapper.setInteger(bQFunctionColumn.getColumnPosition());
                return false;
            }
            case COLUMN_DEF: 
            case REMARKS: {
                dataWrapper.setNull(12);
                return false;
            }
            case SPECIFIC_NAME: {
                return DSITypeUtilities.outputVarCharStringData(bQFunctionColumn.getFunctionName(), dataWrapper, l, l2);
            }
            case DECIMAL_DIGITS: {
                Long l4 = null;
                TypeMetadata typeMetadata = bQFunctionColumn.getTypeMetadata();
                if (null != typeMetadata) {
                    if (typeMetadata.isIntervalType() || 92 == typeMetadata.getType() || 93 == typeMetadata.getType()) {
                        l4 = new Long(typeMetadata.getPrecision());
                    } else if (typeMetadata.isExactNumericType()) {
                        l4 = new Long(typeMetadata.getScale());
                    } else if (typeMetadata.isIntegerType()) {
                        l4 = 0L;
                    }
                }
                dataWrapper.setInteger(l4);
                return false;
            }
            case NUM_PREC_RADIX: {
                TypeMetadata typeMetadata = bQFunctionColumn.getTypeMetadata();
                Long l5 = null;
                if (null != typeMetadata) {
                    if (typeMetadata.isIntegerType() || typeMetadata.isExactNumericType()) {
                        l5 = 10L;
                    } else if (typeMetadata.isApproximateNumericType()) {
                        l5 = 2L;
                    }
                }
                dataWrapper.setInteger(l5);
                return false;
            }
            case IS_RESULT_SET: {
                dataWrapper.setNull(16);
                return false;
            }
            case SQL_DATA_TYPE: 
            case SQL_DATETIME_SUB: {
                dataWrapper.setNull(4);
                return false;
            }
        }
        throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.METADATA_FUNCTION_COL_NOT_FOUND_ERR.name(), new String[]{metadataSourceColumnTag.toString()});
    }

    @Override
    public boolean hasMoreRows() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return !this.m_hasStartedFunctionColumnsFetch;
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        boolean bl = false;
        try {
            bl = this.moveToNextFunctionColumn(this.m_isFunctionColumn);
        }
        catch (ErrorException errorException) {
            this.m_cachedException = errorException;
            return true;
        }
        return bl;
    }
}

