/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.tests.unit;

import com.simba.googlebigquery.googlebigquery.tests.unit.BQTestProperties;
import com.simba.googlebigquery.jdbc.DataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import junit.framework.TestCase;
import org.junit.Test;

public class BQQueryCancellationTests
extends TestCase {
    private boolean m_successful;
    private PreparedStatement m_statement;
    private Exception m_threadException;
    private final String EXEPECTED_ERROR_MSG = "The statement was cancelled.";
    private final String CANCEL_QUERY = "SELECT * FROM `data-driver-testing.PerfTest.nyc_yellow_trips` ORDER BY pickup_datetime LIMIT 50000";

    private Connection createConnection() throws SQLException {
        DataSource dataSource = new DataSource();
        dataSource.setURL("jdbc:bigquery://googleapis.com:443");
        dataSource.setProjectId("simba-testing-jdbc");
        dataSource.setOAuthServiceAcctEmail("bqtest1@simba-testing-jdbc.iam.gserviceaccount.com");
        dataSource.setOAuthPvtKeyFilePath(BQTestProperties.SERVICE_AUTH_KEYPATH_JSON);
        dataSource.setOAuthType(0);
        dataSource.setTimeout(100L);
        dataSource.setUseQueryCache(false);
        return dataSource.getConnection();
    }

    public void setUp() throws Exception {
        this.m_successful = false;
        this.m_threadException = null;
    }

    public void tearDown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelQuery() throws SQLException, InterruptedException {
        for (int i = 0; !this.m_successful && i < 10; ++i) {
            Connection connection = this.createConnection();
            this.m_statement = connection.prepareStatement("SELECT * FROM `data-driver-testing.PerfTest.nyc_yellow_trips` ORDER BY pickup_datetime LIMIT 50000");
            ResultSet resultSet = null;
            ResultSet resultSet2 = null;
            try {
                try {
                    new CancelThread().start();
                    resultSet = this.m_statement.executeQuery();
                    resultSet.next();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    resultSet2 = this.m_statement.executeQuery();
                    resultSet2.next();
                }
                catch (Exception exception) {
                    if (null != this.m_threadException || !exception.getMessage().contains("The statement was cancelled.")) continue;
                    this.m_successful = true;
                }
                continue;
            }
            finally {
                if (null != resultSet) {
                    resultSet.close();
                }
                if (null != resultSet2) {
                    resultSet2.close();
                }
                if (null != this.m_statement) {
                    this.m_statement.close();
                }
                if (null != connection) {
                    connection.close();
                }
            }
        }
        if (!this.m_successful) {
            BQQueryCancellationTests.fail((String)"Query was not able to be cancelled after 10 tries");
        }
    }

    private class CancelThread
    extends Thread {
        private final int WAIT_TIME = 25000;

        private CancelThread() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(25000L);
            }
            catch (InterruptedException interruptedException) {
                BQQueryCancellationTests.this.m_threadException = interruptedException;
            }
            try {
                BQQueryCancellationTests.this.m_statement.cancel();
            }
            catch (SQLException sQLException) {
                BQQueryCancellationTests.this.m_threadException = sQLException;
            }
        }
    }
}

