/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.utils;

import com.google.api.client.util.Base64;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.simba.googlebigquery.dsi.dataengine.utilities.DataWrapper;
import com.simba.googlebigquery.dsi.dataengine.utilities.ParameterInputValue;
import com.simba.googlebigquery.dsi.dataengine.utilities.TimestampTz;
import com.simba.googlebigquery.dsi.exceptions.IncorrectTypeException;
import com.simba.googlebigquery.googlebigquery.core.BQConnectionOptions;
import com.simba.googlebigquery.googlebigquery.core.BQDriver;
import com.simba.googlebigquery.googlebigquery.exceptions.BQMessageKey;
import com.simba.googlebigquery.jdbc.common.CommonCoreUtils;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.util.Calendar;
import java.util.TimeZone;

public class BQCoreUtils
extends CommonCoreUtils {
    private static final int MILLIS_MULTIPLIER = 1000;
    private static final int SEC_TO_NANOS_MULTIPLIER = 1000000000;
    private static boolean s_timestampFallback = false;
    private static boolean s_timestampFallbackSet = false;
    private static final Object s_timestampFallbackLock = new Object();

    public static int bigqueryToSqlTypeConverter(String string) throws ErrorException {
        switch (string = string.toUpperCase()) {
            case "ARRAY": 
            case "INTERVAL": 
            case "RECORD": 
            case "STRING": 
            case "STRUCT": 
            case "GEOGRAPHY": {
                return 12;
            }
            case "DATE": {
                return 91;
            }
            case "TIME": {
                return 92;
            }
            case "TIMESTAMP": 
            case "DATETIME": {
                return 93;
            }
            case "BOOL": 
            case "BOOLEAN": {
                return 16;
            }
            case "INT64": 
            case "INTEGER": {
                return -5;
            }
            case "FLOAT64": 
            case "FLOAT": {
                return 8;
            }
            case "BYTES": {
                return -3;
            }
            case "NUMERIC": 
            case "BIGNUMERIC": {
                return 2;
            }
        }
        throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.METADATA_INCORRECT_TYPE_ERR.name(), string);
    }

    public static String convertSqlTypeToBigQueryType(int n) throws ErrorException {
        switch (n) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return "STRING";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: 
            case 2014: {
                return "STRING";
            }
            case -7: 
            case 16: {
                return "BOOL";
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return "INT64";
            }
            case 6: 
            case 7: 
            case 8: {
                return "FLOAT64";
            }
            case -4: 
            case -3: 
            case -2: {
                return "BYTES";
            }
            case 2: 
            case 3: {
                return "NUMERIC";
            }
        }
        throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.METADATA_INCORRECT_TYPE_ERR.name());
    }

    public static TimestampTz convertUnixToTimestamp(Double d) throws ErrorException {
        try {
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            long l = 0L;
            int n = 0;
            l = 0.0 > d ? (d % 1.0 != 0.0 ? d.longValue() - 1L : d.longValue()) : d.longValue();
            n = (int)((d - (double)l) * 1.0E9);
            n = (n + 500) / 1000 * 1000;
            return new TimestampTz(l * 1000L, n, calendar);
        }
        catch (Exception exception) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.RESULT_TIMESTAMP_PARSE_ERR.name(), exception.getMessage());
        }
    }

    public static String getBqTypeFromDialect(BQConnectionOptions.QueryDialect queryDialect, TableFieldSchema tableFieldSchema) {
        boolean bl = "REPEATED".equals(tableFieldSchema.getMode());
        if (queryDialect.equals((Object)BQConnectionOptions.QueryDialect.SQL)) {
            String string = null;
            switch (tableFieldSchema.getType()) {
                case "RECORD": {
                    string = "STRUCT";
                    break;
                }
                case "INTEGER": {
                    string = "INT64";
                    break;
                }
                case "FLOAT": {
                    string = "FLOAT64";
                    break;
                }
                default: {
                    if (bl) {
                        string = "ARRAY";
                        break;
                    }
                    if (null != string) break;
                    string = tableFieldSchema.getType();
                }
            }
            if (bl) {
                string = "ARRAY";
            }
            return string;
        }
        return tableFieldSchema.getType();
    }

    public static String getParamValueAsText(ParameterInputValue parameterInputValue) throws ErrorException {
        DataWrapper dataWrapper = null;
        try {
            dataWrapper = parameterInputValue.getData();
        }
        catch (Exception exception) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.EXEC_PARAM_REPLACE_ERR.name(), exception.getMessage());
        }
        try {
            switch (dataWrapper.getType()) {
                case -3: {
                    byte[] byArray = dataWrapper.getVarBinary();
                    return null == byArray ? null : Base64.encodeBase64String((byte[])byArray);
                }
                case 12: {
                    String string = dataWrapper.getVarChar();
                    return null == string ? null : string.toString();
                }
                case 93: 
                case 2014: {
                    TimestampTz timestampTz = dataWrapper.getTimestampTz();
                    return null == timestampTz ? null : timestampTz.getAdjustedTimestamp().toString();
                }
            }
            if (null == dataWrapper.getObject()) {
                return null;
            }
            int n = dataWrapper.toString().indexOf("|");
            return dataWrapper.toString().substring(++n);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.EXEC_PARAM_REPLACE_ERR.name(), new String[]{incorrectTypeException.toString()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getTimestampFallbackValue() {
        Object object = s_timestampFallbackLock;
        synchronized (object) {
            return s_timestampFallback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTimestampFallbackSet() {
        Object object = s_timestampFallbackLock;
        synchronized (object) {
            return s_timestampFallbackSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTimestampFallbackValue(boolean bl) {
        Object object = s_timestampFallbackLock;
        synchronized (object) {
            s_timestampFallback = bl;
            s_timestampFallbackSet = true;
        }
    }

    public static String stringConcealer(String string) {
        if (string.length() <= 4) {
            return "****";
        }
        String string2 = "******";
        for (int i = string.length() - 4; i < string.length(); ++i) {
            string2 = string2 + string.charAt(i);
        }
        return string2;
    }

    public static boolean isRepeated(TableFieldSchema tableFieldSchema) {
        return "REPEATED".equals(tableFieldSchema.getMode());
    }

    public static boolean isRecord(TableFieldSchema tableFieldSchema) {
        return "RECORD".equals(tableFieldSchema.getType());
    }

    public static short getNumericPrecision(String string) {
        return string.equalsIgnoreCase("BIGNUMERIC") ? (short)77 : 38;
    }

    public static Short getNumericScale(String string) {
        return string.equals("BIGNUMERIC") ? (short)38 : 9;
    }
}

