/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.jdbc.jdbc42;

import com.simba.googlebigquery.dsi.dataengine.interfaces.IColumn;
import com.simba.googlebigquery.dsi.dataengine.interfaces.IResultSet;
import com.simba.googlebigquery.dsi.dataengine.utilities.DataWrapper;
import com.simba.googlebigquery.dsi.dataengine.utilities.TypeMetadata;
import com.simba.googlebigquery.dsi.exceptions.IncorrectTypeException;
import com.simba.googlebigquery.exceptions.ExceptionConverter;
import com.simba.googlebigquery.exceptions.JDBCMessageKey;
import com.simba.googlebigquery.jdbc.common.SStatement;
import com.simba.googlebigquery.jdbc.jdbc41.S41UpdatableForwardResultSet;
import com.simba.googlebigquery.jdbc.jdbc42.S42ResultSetMetaData;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.IWarningListener;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ExceptionType;
import com.simba.googlebigquery.utilities.JDBCVersion;
import com.simba.googlebigquery.utilities.conversion.TypeConverter;
import java.math.BigDecimal;
import java.sql.JDBCType;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLType;
import java.util.ArrayList;

public class S42UpdatableForwardResultSet
extends S41UpdatableForwardResultSet {
    public S42UpdatableForwardResultSet(SStatement sStatement, IResultSet iResultSet, ILogger iLogger) throws SQLException {
        super(sStatement, iResultSet, iLogger);
        this.m_jdbcVersion = JDBCVersion.JDBC42;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            this.initializeColumnsIfNeeded();
            if (null == this.getResultSetMetaData()) {
                this.initializeResultSetColumns();
                this.setResultSetMetadata(new S42ResultSetMetaData(this.getResultSetColumns(), this.getLogger(), this.getWarningListener()));
            }
            return this.getResultSetMetaData();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public void updateObject(int n, Object object, SQLType sQLType) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, object, sQLType);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(n);
            this.clearStream(n);
            TypeMetadata typeMetadata = ((IColumn)((ArrayList)((IResultSet)this.m_resultSet).getSelectColumns()).get(n - 1)).getTypeMetadata();
            int n2 = sQLType.getVendorTypeNumber();
            DataWrapper dataWrapper = new DataWrapper();
            if (null == object) {
                dataWrapper.setNull(typeMetadata.getType());
            } else {
                try {
                    DataWrapper dataWrapper2 = new DataWrapper();
                    dataWrapper2.setData(TypeConverter.getSqlType(object), object);
                    dataWrapper = TypeConverter.toType(dataWrapper2, object, n2, this.m_warningListener);
                    dataWrapper = TypeConverter.toType(dataWrapper, typeMetadata, (IWarningListener)this.m_warningListener);
                }
                catch (IncorrectTypeException incorrectTypeException) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.PARAM_OBJECT_MISMATCH, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(object));
                }
            }
            this.m_updateValues.set(n - 1, dataWrapper);
            this.m_hasUpdateValues = true;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateObject(int n, Object object, SQLType sQLType, int n2) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, object, sQLType, n2);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(n);
            this.clearStream(n);
            TypeMetadata typeMetadata = ((IColumn)((ArrayList)((IResultSet)this.m_resultSet).getSelectColumns()).get(n - 1)).getTypeMetadata();
            int n3 = sQLType.getVendorTypeNumber();
            DataWrapper dataWrapper = new DataWrapper();
            if (null == object) {
                dataWrapper.setNull(typeMetadata.getType());
            } else {
                Object object2;
                try {
                    object2 = new DataWrapper();
                    ((DataWrapper)object2).setData(TypeConverter.getSqlType(object), object);
                    dataWrapper = TypeConverter.toType((DataWrapper)object2, object, n3, this.m_warningListener);
                    dataWrapper = TypeConverter.toType(dataWrapper, typeMetadata, (IWarningListener)this.m_warningListener);
                }
                catch (IncorrectTypeException incorrectTypeException) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.PARAM_OBJECT_MISMATCH, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(object));
                }
                if (JDBCType.NUMERIC.getVendorTypeNumber().intValue() == dataWrapper.getType() || JDBCType.DECIMAL.getVendorTypeNumber().intValue() == dataWrapper.getType()) {
                    object2 = (BigDecimal)dataWrapper.getObject();
                    dataWrapper.setData(dataWrapper.getType(), ((BigDecimal)object2).setScale(n2, 4));
                }
            }
            this.m_updateValues.set(n - 1, dataWrapper);
            this.m_hasUpdateValues = true;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateObject(String string, Object object, SQLType sQLType) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, object, sQLType);
        this.updateObject(this.findColumn(string), object, sQLType);
    }

    @Override
    public void updateObject(String string, Object object, SQLType sQLType, int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, object, sQLType, n);
        this.updateObject(this.findColumn(string), object, sQLType, n);
    }
}

