/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.amazonaws.services.redshift.model.transform;

import com.amazon.redshift.amazonaws.DefaultRequest;
import com.amazon.redshift.amazonaws.Request;
import com.amazon.redshift.amazonaws.SdkClientException;
import com.amazon.redshift.amazonaws.http.HttpMethodName;
import com.amazon.redshift.amazonaws.services.redshift.model.AuthorizeSnapshotAccessRequest;
import com.amazon.redshift.amazonaws.transform.Marshaller;
import com.amazon.redshift.amazonaws.util.StringUtils;

public class AuthorizeSnapshotAccessRequestMarshaller
implements Marshaller<Request<AuthorizeSnapshotAccessRequest>, AuthorizeSnapshotAccessRequest> {
    @Override
    public Request<AuthorizeSnapshotAccessRequest> marshall(AuthorizeSnapshotAccessRequest authorizeSnapshotAccessRequest) {
        if (authorizeSnapshotAccessRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AuthorizeSnapshotAccessRequest> request = new DefaultRequest<AuthorizeSnapshotAccessRequest>(authorizeSnapshotAccessRequest, "AmazonRedshift");
        request.addParameter("Action", "AuthorizeSnapshotAccess");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (authorizeSnapshotAccessRequest.getSnapshotIdentifier() != null) {
            request.addParameter("SnapshotIdentifier", StringUtils.fromString(authorizeSnapshotAccessRequest.getSnapshotIdentifier()));
        }
        if (authorizeSnapshotAccessRequest.getSnapshotClusterIdentifier() != null) {
            request.addParameter("SnapshotClusterIdentifier", StringUtils.fromString(authorizeSnapshotAccessRequest.getSnapshotClusterIdentifier()));
        }
        if (authorizeSnapshotAccessRequest.getAccountWithRestoreAccess() != null) {
            request.addParameter("AccountWithRestoreAccess", StringUtils.fromString(authorizeSnapshotAccessRequest.getAccountWithRestoreAccess()));
        }
        return request;
    }
}

