/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.amazonaws.services.redshift.model.transform;

import com.amazon.redshift.amazonaws.services.redshift.model.Event;
import com.amazon.redshift.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazon.redshift.amazonaws.transform.StaxUnmarshallerContext;
import com.amazon.redshift.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class EventStaxUnmarshaller
implements Unmarshaller<Event, StaxUnmarshallerContext> {
    private static EventStaxUnmarshaller instance;

    @Override
    public Event unmarshall(StaxUnmarshallerContext context) throws Exception {
        Event event = new Event();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return event;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("SourceIdentifier", targetDepth)) {
                    event.setSourceIdentifier(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SourceType", targetDepth)) {
                    event.setSourceType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Message", targetDepth)) {
                    event.setMessage(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EventCategories", targetDepth)) {
                    event.withEventCategories(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("EventCategories/EventCategory", targetDepth)) {
                    event.withEventCategories(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Severity", targetDepth)) {
                    event.setSeverity(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Date", targetDepth)) {
                    event.setDate(SimpleTypeStaxUnmarshallers.DateStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("EventId", targetDepth)) continue;
                event.setEventId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return event;
    }

    public static EventStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new EventStaxUnmarshaller();
        }
        return instance;
    }
}

