_have grep-status && {
_comp_dpkg_installed_packages()
{
    grep-status -P -e "^$1" -a -FStatus 'install ok installed' -n -s Package
}
} || {
_comp_dpkg_installed_packages()
{
    command grep -A 1 "Package: $1" /var/lib/dpkg/status | \
        command grep -B 1 -Ee "ok installed|half-installed|unpacked| \
            half-configured" \
            -Ee "^Essential: yes" | \
        command grep "Package: $1" | cut -d\  -f2
}
}

_have grep-status && {
_comp_dpkg_hold_packages()
{
    grep-status -P -e "^$1" -a -FStatus 'hold' -n -s Package
}
} || {
_comp_dpkg_hold_packages()
{
    command grep -B 2 'hold' /var/lib/dpkg/status | \
        command grep "Package: $1" | cut -d\  -f2
}
}

_have wajig &&
_wajig()
{
    local cur dashoptions prev special i

    COMPREPLY=()
    _get_comp_words_by_ref cur prev

    dashoptions='-h --help -V --version'

    for (( i=0; i < ${#COMP_WORDS[@]}-1; i++ )); do
        if [[ ${COMP_WORDS[i]} == \
         @(addcdrom|addrepo|aptlog|auto-alts|auto-clean|auto-download|autoremove|build|\
build-deps|changelog|clean|contents|daily-upgrade|dependents|describe|\
describe-new|details|dist-upgrade|download|editsources|extract|\
fix-configure|fix-install|fix-missing|force|hold|info|init|install|\
install-suggested|integrity|large|lastupdate|list-alternatives|\
list-cache|list-commands|list-daemons|list-files|list-hold|list-installed|\
list-log|list-names|list-packages|list-scripts|list-section|list-sections|\
list-status|madison|move|new|new-detail|news|new-upgrades|nonfree|\
orphans|policy|purge|purge-orphans|purge-removed|rbuilddeps|readme|\
rec-download|recommended|reconfigure|reinstall|reload|remove|\
remove-orphans|repackage|reportbug|restart|rpm2deb|rpminstall|\
search|searchapt|show|sizes|snapshot|source|start|status|status-match|\
stop|tasksel|todo|toupgrade|tutorial|unhold|unofficial|\
update|update-alternatives|update-pci-ids|update-usb-ids|upgrade|\
upgrade-security|verify|versions|which-package) ]];
         then special=${COMP_WORDS[i]}
        fi
    done

    if [[ -n "$special" ]]; then
       case $special in
           install|distupgrade|download|show|changelog|builddeps|dependents|describe|details|policy|recdownload|source)
               COMPREPLY=( $( apt-cache pkgnames $cur 2> /dev/null ) )
               if [[ "$special" == "install" ]]; then
                   _filedir
               fi
               return 0
               ;;
           purge|remove|reinstall|listinstalled|hold|news|readme|recommended|reconfigure|repackage|todo|verify)
               COMPREPLY=( $( _comp_dpkg_installed_packages "$cur" ) )
               return 0
               ;;
           reload|*start|status|stop)
               _services "$cur"
               return 0
               ;;
           unhold)
               COMPREPLY=( $( _comp_dpkg_hold_packages "$cur" ) )
               return 0
               ;;
           contents|extract|info|rpm2deb|rpminstall)
               _filedir
               ;;
       esac
    fi

    case $prev in
        # don't complete anything if these options are found
        autoclean|clean|search|upgrade|update)
            return 0
            ;;
        -S)
            _filedir
            return 0
            ;;
    esac

    if [[ "$cur" == -* ]]; then
        COMPREPLY=( $( compgen -W "$dashoptions" -- "$cur" ) )
    elif [[ -z "$special" ]]; then
        commands=(addcdrom addrepo aptlog auto-alts auto-clean auto-download auto-remove
            build build-deps changelog clean contents daily-upgrade dependents
            describe describe-new details dist-upgrade download editsources
            extract fix-configure fix-install fix-missing force hold info init
            install install-suggested integrity large lastupdate list-alternatives
            list-cache list-commands list-daemons list-files list-hold list-installed
            list-log list-names list-packages list-scripts
            list-section list-sections list-status
            madison move new new-detail news new-upgrades nonfree orphans
            policy purge purge-orphans purge-removed rbuilddeps readme
            rec-download recommended reconfigure reinstall reload remove
            remove-orphans repackage reportbug restart rpm2deb rpminstall
            search searchapt show sizes snapshot source start status
            status-match stop tasksel todo toupgrade tutorial unhold
            unofficial update update-alternatives update-pci-ids update-usb-ids
            upgrade upgrade-security verify versions which-package)

        local option oldNoCaseMatch=$(shopt -p nocasematch)
        shopt -s nocasematch
        COMPREPLY=( $( for command in "${commands[@]}"; do
                [[ ${command:0:${#cur}} == "$cur" ]] && printf '%s\n' $command
                done ) )
        eval "$oldNoCaseMatch" 2> /dev/null
    fi

    return 0
}
complete -F _wajig wajig

# Local variables:
# mode: shell-script
# sh-basic-offset: 4
# sh-indent-comment: t
# indent-tabs-mode: nil
# End:
# ex: ts=4 sw=4 et filetype=sh
