from __future__ import annotations

import datetime
from types import TracebackType
from typing import Any

from wrapt import ObjectProxy

from coredis import PureToken
from coredis.commands.script import Script
from coredis.pool import ClusterConnectionPool, ConnectionPool
from coredis.typing import (
    AnyStr,
    Callable,
    Dict,
    Generic,
    Iterable,
    KeyT,
    List,
    Literal,
    Mapping,
    Node,
    Optional,
    Parameters,
    Set,
    StringT,
    Tuple,
    Type,
    Union,
    ValueT,
)

class Pipeline(ObjectProxy, Generic[AnyStr]):  # type: ignore
    scripts: Set[Script[AnyStr]]
    @classmethod
    def proxy(
        cls,
        connection_pool: "ConnectionPool",
        transaction: "Optional[bool]",
        watches: "Optional[Parameters[KeyT]]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def copy(
        self,
        source: "KeyT",
        destination: "KeyT",
        db: "Optional[int]" = ...,
        replace: "Optional[bool]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def delete(self, keys: "Parameters[KeyT]") -> Pipeline[AnyStr]: ...
    async def dump(self, key: "KeyT") -> Pipeline[AnyStr]: ...
    async def exists(self, keys: "Parameters[KeyT]") -> Pipeline[AnyStr]: ...
    async def expire(
        self,
        key: "KeyT",
        seconds: "Union[int, datetime.timedelta]",
        condition: "Optional[Literal[PureToken.NX, PureToken.XX, PureToken.GT, PureToken.LT]]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def expireat(
        self,
        key: "KeyT",
        unix_time_seconds: "Union[int, datetime.datetime]",
        condition: "Optional[Literal[PureToken.NX, PureToken.XX, PureToken.GT, PureToken.LT]]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def expiretime(self, key: "KeyT") -> Pipeline[AnyStr]: ...
    async def keys(self, pattern: "StringT" = ...) -> Pipeline[AnyStr]: ...
    async def migrate(
        self,
        host: "StringT",
        port: "int",
        destination_db: "int",
        timeout: "int",
        *keys: "KeyT",
        copy: "Optional[bool]" = ...,
        replace: "Optional[bool]" = ...,
        auth: "Optional[StringT]" = ...,
        username: "Optional[StringT]" = ...,
        password: "Optional[StringT]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def move(self, key: "KeyT", db: "int") -> Pipeline[AnyStr]: ...
    async def object_encoding(self, key: "KeyT") -> Pipeline[AnyStr]: ...
    async def object_freq(self, key: "KeyT") -> Pipeline[AnyStr]: ...
    async def object_idletime(self, key: "KeyT") -> Pipeline[AnyStr]: ...
    async def object_refcount(self, key: "KeyT") -> Pipeline[AnyStr]: ...
    async def persist(self, key: "KeyT") -> Pipeline[AnyStr]: ...
    async def pexpire(
        self,
        key: "KeyT",
        milliseconds: "Union[int, datetime.timedelta]",
        condition: "Optional[Literal[PureToken.NX, PureToken.XX, PureToken.GT, PureToken.LT]]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def pexpireat(
        self,
        key: "KeyT",
        unix_time_milliseconds: "Union[int, datetime.datetime]",
        condition: "Optional[Literal[PureToken.NX, PureToken.XX, PureToken.GT, PureToken.LT]]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def pexpiretime(self, key: "KeyT") -> Pipeline[AnyStr]: ...
    async def pttl(self, key: "KeyT") -> Pipeline[AnyStr]: ...
    async def randomkey(self) -> Pipeline[AnyStr]: ...
    async def rename(self, key: "KeyT", newkey: "KeyT") -> Pipeline[AnyStr]: ...
    async def renamenx(self, key: "KeyT", newkey: "KeyT") -> Pipeline[AnyStr]: ...
    async def restore(
        self,
        key: "KeyT",
        ttl: "Union[int, datetime.timedelta, datetime.datetime]",
        serialized_value: "bytes",
        replace: "Optional[bool]" = ...,
        absttl: "Optional[bool]" = ...,
        idletime: "Optional[Union[int, datetime.timedelta]]" = ...,
        freq: "Optional[int]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def scan(
        self,
        cursor: "Optional[int]" = ...,
        match: "Optional[StringT]" = ...,
        count: "Optional[int]" = ...,
        type_: "Optional[StringT]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def sort(
        self,
        key: "KeyT",
        gets: "Optional[Parameters[KeyT]]" = ...,
        by: "Optional[StringT]" = ...,
        offset: "Optional[int]" = ...,
        count: "Optional[int]" = ...,
        order: "Optional[Literal[PureToken.ASC, PureToken.DESC]]" = ...,
        alpha: "Optional[bool]" = ...,
        store: "Optional[KeyT]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def sort_ro(
        self,
        key: "KeyT",
        gets: "Optional[Parameters[KeyT]]" = ...,
        by: "Optional[StringT]" = ...,
        offset: "Optional[int]" = ...,
        count: "Optional[int]" = ...,
        order: "Optional[Literal[PureToken.ASC, PureToken.DESC]]" = ...,
        alpha: "Optional[bool]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def touch(self, keys: "Parameters[KeyT]") -> Pipeline[AnyStr]: ...
    async def ttl(self, key: "KeyT") -> Pipeline[AnyStr]: ...
    async def type(self, key: "KeyT") -> Pipeline[AnyStr]: ...
    async def unlink(self, keys: "Parameters[KeyT]") -> Pipeline[AnyStr]: ...
    async def wait(self, numreplicas: "int", timeout: "int") -> Pipeline[AnyStr]: ...
    async def waitaof(
        self, numlocal: "int", numreplicas: "int", timeout: "int"
    ) -> Pipeline[AnyStr]: ...
    async def append(self, key: "KeyT", value: "ValueT") -> Pipeline[AnyStr]: ...
    async def decr(self, key: "KeyT") -> Pipeline[AnyStr]: ...
    async def decrby(self, key: "KeyT", decrement: "int") -> Pipeline[AnyStr]: ...
    async def get(self, key: "KeyT") -> Pipeline[AnyStr]: ...
    async def getdel(self, key: "KeyT") -> Pipeline[AnyStr]: ...
    async def getex(
        self,
        key: "KeyT",
        ex: "Optional[Union[int, datetime.timedelta]]" = ...,
        px: "Optional[Union[int, datetime.timedelta]]" = ...,
        exat: "Optional[Union[int, datetime.datetime]]" = ...,
        pxat: "Optional[Union[int, datetime.datetime]]" = ...,
        persist: "Optional[bool]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def getrange(
        self, key: "KeyT", start: "int", end: "int"
    ) -> Pipeline[AnyStr]: ...
    async def getset(self, key: "KeyT", value: "ValueT") -> Pipeline[AnyStr]: ...
    async def incr(self, key: "KeyT") -> Pipeline[AnyStr]: ...
    async def incrby(self, key: "KeyT", increment: "int") -> Pipeline[AnyStr]: ...
    async def incrbyfloat(
        self, key: "KeyT", increment: "Union[int, float]"
    ) -> Pipeline[AnyStr]: ...
    async def lcs(
        self,
        key1: "KeyT",
        key2: "KeyT",
        len_: "Optional[bool]" = ...,
        idx: "Optional[bool]" = ...,
        minmatchlen: "Optional[int]" = ...,
        withmatchlen: "Optional[bool]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def mget(self, keys: "Parameters[KeyT]") -> Pipeline[AnyStr]: ...
    async def mset(self, key_values: "Dict[KeyT, ValueT]") -> Pipeline[AnyStr]: ...
    async def msetnx(self, key_values: "Dict[KeyT, ValueT]") -> Pipeline[AnyStr]: ...
    async def psetex(
        self,
        key: "KeyT",
        milliseconds: "Union[int, datetime.timedelta]",
        value: "ValueT",
    ) -> Pipeline[AnyStr]: ...
    async def set(
        self,
        key: "KeyT",
        value: "ValueT",
        condition: "Optional[Literal[PureToken.NX, PureToken.XX]]" = ...,
        get: "Optional[bool]" = ...,
        ex: "Optional[Union[int, datetime.timedelta]]" = ...,
        px: "Optional[Union[int, datetime.timedelta]]" = ...,
        exat: "Optional[Union[int, datetime.datetime]]" = ...,
        pxat: "Optional[Union[int, datetime.datetime]]" = ...,
        keepttl: "Optional[bool]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def setex(
        self, key: "KeyT", value: "ValueT", seconds: "Union[int, datetime.timedelta]"
    ) -> Pipeline[AnyStr]: ...
    async def setnx(self, key: "KeyT", value: "ValueT") -> Pipeline[AnyStr]: ...
    async def setrange(
        self, key: "KeyT", offset: "int", value: "ValueT"
    ) -> Pipeline[AnyStr]: ...
    async def strlen(self, key: "KeyT") -> Pipeline[AnyStr]: ...
    async def substr(
        self, key: "KeyT", start: "int", end: "int"
    ) -> Pipeline[AnyStr]: ...
    async def bitcount(
        self,
        key: "KeyT",
        start: "Optional[int]" = ...,
        end: "Optional[int]" = ...,
        index_unit: "Optional[Literal[PureToken.BIT, PureToken.BYTE]]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def bitop(
        self, keys: "Parameters[KeyT]", operation: "StringT", destkey: "KeyT"
    ) -> Pipeline[AnyStr]: ...
    async def bitpos(
        self,
        key: "KeyT",
        bit: "int",
        start: "Optional[int]" = ...,
        end: "Optional[int]" = ...,
        index_unit: "Optional[Literal[PureToken.BIT, PureToken.BYTE]]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def getbit(self, key: "KeyT", offset: "int") -> Pipeline[AnyStr]: ...
    async def setbit(
        self, key: "KeyT", offset: "int", value: "int"
    ) -> Pipeline[AnyStr]: ...
    async def hdel(
        self, key: "KeyT", fields: "Parameters[StringT]"
    ) -> Pipeline[AnyStr]: ...
    async def hexists(self, key: "KeyT", field: "StringT") -> Pipeline[AnyStr]: ...
    async def hget(self, key: "KeyT", field: "StringT") -> Pipeline[AnyStr]: ...
    async def hgetall(self, key: "KeyT") -> Pipeline[AnyStr]: ...
    async def hincrby(
        self, key: "KeyT", field: "StringT", increment: "int"
    ) -> Pipeline[AnyStr]: ...
    async def hincrbyfloat(
        self, key: "KeyT", field: "StringT", increment: "Union[int, float]"
    ) -> Pipeline[AnyStr]: ...
    async def hkeys(self, key: "KeyT") -> Pipeline[AnyStr]: ...
    async def hlen(self, key: "KeyT") -> Pipeline[AnyStr]: ...
    async def hmget(
        self, key: "KeyT", fields: "Parameters[StringT]"
    ) -> Pipeline[AnyStr]: ...
    async def hmset(
        self, key: "KeyT", field_values: "Dict[StringT, ValueT]"
    ) -> Pipeline[AnyStr]: ...
    async def hrandfield(
        self,
        key: "KeyT",
        count: "Optional[int]" = ...,
        withvalues: "Optional[bool]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def hscan(
        self,
        key: "KeyT",
        cursor: "Optional[int]" = ...,
        match: "Optional[StringT]" = ...,
        count: "Optional[int]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def hset(
        self, key: "KeyT", field_values: "Dict[StringT, ValueT]"
    ) -> Pipeline[AnyStr]: ...
    async def hsetnx(
        self, key: "KeyT", field: "StringT", value: "ValueT"
    ) -> Pipeline[AnyStr]: ...
    async def hstrlen(self, key: "KeyT", field: "StringT") -> Pipeline[AnyStr]: ...
    async def hvals(self, key: "KeyT") -> Pipeline[AnyStr]: ...
    async def blmove(
        self,
        source: "KeyT",
        destination: "KeyT",
        wherefrom: "Literal[PureToken.LEFT, PureToken.RIGHT]",
        whereto: "Literal[PureToken.LEFT, PureToken.RIGHT]",
        timeout: "Union[int, float]",
    ) -> Pipeline[AnyStr]: ...
    async def blmpop(
        self,
        keys: "Parameters[KeyT]",
        timeout: "Union[int, float]",
        where: "Literal[PureToken.LEFT, PureToken.RIGHT]",
        count: "Optional[int]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def blpop(
        self, keys: "Parameters[KeyT]", timeout: "Union[int, float]"
    ) -> Pipeline[AnyStr]: ...
    async def brpop(
        self, keys: "Parameters[KeyT]", timeout: "Union[int, float]"
    ) -> Pipeline[AnyStr]: ...
    async def brpoplpush(
        self, source: "KeyT", destination: "KeyT", timeout: "Union[int, float]"
    ) -> Pipeline[AnyStr]: ...
    async def lindex(self, key: "KeyT", index: "int") -> Pipeline[AnyStr]: ...
    async def linsert(
        self,
        key: "KeyT",
        where: "Literal[PureToken.AFTER, PureToken.BEFORE]",
        pivot: "ValueT",
        element: "ValueT",
    ) -> Pipeline[AnyStr]: ...
    async def llen(self, key: "KeyT") -> Pipeline[AnyStr]: ...
    async def lmove(
        self,
        source: "KeyT",
        destination: "KeyT",
        wherefrom: "Literal[PureToken.LEFT, PureToken.RIGHT]",
        whereto: "Literal[PureToken.LEFT, PureToken.RIGHT]",
    ) -> Pipeline[AnyStr]: ...
    async def lmpop(
        self,
        keys: "Parameters[KeyT]",
        where: "Literal[PureToken.LEFT, PureToken.RIGHT]",
        count: "Optional[int]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def lpop(
        self, key: "KeyT", count: "Optional[int]" = ...
    ) -> Pipeline[AnyStr]: ...
    async def lpos(
        self,
        key: "KeyT",
        element: "ValueT",
        rank: "Optional[int]" = ...,
        count: "Optional[int]" = ...,
        maxlen: "Optional[int]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def lpush(
        self, key: "KeyT", elements: "Parameters[ValueT]"
    ) -> Pipeline[AnyStr]: ...
    async def lpushx(
        self, key: "KeyT", elements: "Parameters[ValueT]"
    ) -> Pipeline[AnyStr]: ...
    async def lrange(
        self, key: "KeyT", start: "int", stop: "int"
    ) -> Pipeline[AnyStr]: ...
    async def lrem(
        self, key: "KeyT", count: "int", element: "ValueT"
    ) -> Pipeline[AnyStr]: ...
    async def lset(
        self, key: "KeyT", index: "int", element: "ValueT"
    ) -> Pipeline[AnyStr]: ...
    async def ltrim(
        self, key: "KeyT", start: "int", stop: "int"
    ) -> Pipeline[AnyStr]: ...
    async def rpop(
        self, key: "KeyT", count: "Optional[int]" = ...
    ) -> Pipeline[AnyStr]: ...
    async def rpoplpush(
        self, source: "KeyT", destination: "KeyT"
    ) -> Pipeline[AnyStr]: ...
    async def rpush(
        self, key: "KeyT", elements: "Parameters[ValueT]"
    ) -> Pipeline[AnyStr]: ...
    async def rpushx(
        self, key: "KeyT", elements: "Parameters[ValueT]"
    ) -> Pipeline[AnyStr]: ...
    async def sadd(
        self, key: "KeyT", members: "Parameters[ValueT]"
    ) -> Pipeline[AnyStr]: ...
    async def scard(self, key: "KeyT") -> Pipeline[AnyStr]: ...
    async def sdiff(self, keys: "Parameters[KeyT]") -> Pipeline[AnyStr]: ...
    async def sdiffstore(
        self, keys: "Parameters[KeyT]", destination: "KeyT"
    ) -> Pipeline[AnyStr]: ...
    async def sinter(self, keys: "Parameters[KeyT]") -> Pipeline[AnyStr]: ...
    async def sintercard(
        self, keys: "Parameters[KeyT]", limit: "Optional[int]" = ...
    ) -> Pipeline[AnyStr]: ...
    async def sinterstore(
        self, keys: "Parameters[KeyT]", destination: "KeyT"
    ) -> Pipeline[AnyStr]: ...
    async def sismember(self, key: "KeyT", member: "ValueT") -> Pipeline[AnyStr]: ...
    async def smembers(self, key: "KeyT") -> Pipeline[AnyStr]: ...
    async def smismember(
        self, key: "KeyT", members: "Parameters[ValueT]"
    ) -> Pipeline[AnyStr]: ...
    async def smove(
        self, source: "KeyT", destination: "KeyT", member: "ValueT"
    ) -> Pipeline[AnyStr]: ...
    async def spop(
        self, key: "KeyT", count: "Optional[int]" = ...
    ) -> Pipeline[AnyStr]: ...
    async def srandmember(
        self, key: "KeyT", count: "Optional[int]" = ...
    ) -> Pipeline[AnyStr]: ...
    async def srem(
        self, key: "KeyT", members: "Parameters[ValueT]"
    ) -> Pipeline[AnyStr]: ...
    async def sscan(
        self,
        key: "KeyT",
        cursor: "Optional[int]" = ...,
        match: "Optional[StringT]" = ...,
        count: "Optional[int]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def sunion(self, keys: "Parameters[KeyT]") -> Pipeline[AnyStr]: ...
    async def sunionstore(
        self, keys: "Parameters[KeyT]", destination: "KeyT"
    ) -> Pipeline[AnyStr]: ...
    async def bzmpop(
        self,
        keys: "Parameters[KeyT]",
        timeout: "Union[int, float]",
        where: "Literal[PureToken.MAX, PureToken.MIN]",
        count: "Optional[int]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def bzpopmax(
        self, keys: "Parameters[KeyT]", timeout: "Union[int, float]"
    ) -> Pipeline[AnyStr]: ...
    async def bzpopmin(
        self, keys: "Parameters[KeyT]", timeout: "Union[int, float]"
    ) -> Pipeline[AnyStr]: ...
    async def zadd(
        self,
        key: "KeyT",
        member_scores: "Dict[StringT, float]",
        condition: "Optional[Literal[PureToken.NX, PureToken.XX]]" = ...,
        comparison: "Optional[Literal[PureToken.GT, PureToken.LT]]" = ...,
        change: "Optional[bool]" = ...,
        increment: "Optional[bool]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def zcard(self, key: "KeyT") -> Pipeline[AnyStr]: ...
    async def zcount(
        self, key: "KeyT", min_: "ValueT", max_: "ValueT"
    ) -> Pipeline[AnyStr]: ...
    async def zdiff(
        self, keys: "Parameters[KeyT]", withscores: "Optional[bool]" = ...
    ) -> Pipeline[AnyStr]: ...
    async def zdiffstore(
        self, keys: "Parameters[KeyT]", destination: "KeyT"
    ) -> Pipeline[AnyStr]: ...
    async def zincrby(
        self, key: "KeyT", member: "ValueT", increment: "int"
    ) -> Pipeline[AnyStr]: ...
    async def zinter(
        self,
        keys: "Parameters[KeyT]",
        weights: "Optional[Parameters[int]]" = ...,
        aggregate: "Optional[Literal[PureToken.MAX, PureToken.MIN, PureToken.SUM]]" = ...,
        withscores: "Optional[bool]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def zintercard(
        self, keys: "Parameters[KeyT]", limit: "Optional[int]" = ...
    ) -> Pipeline[AnyStr]: ...
    async def zinterstore(
        self,
        keys: "Parameters[KeyT]",
        destination: "KeyT",
        weights: "Optional[Parameters[int]]" = ...,
        aggregate: "Optional[Literal[PureToken.MAX, PureToken.MIN, PureToken.SUM]]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def zlexcount(
        self, key: "KeyT", min_: "ValueT", max_: "ValueT"
    ) -> Pipeline[AnyStr]: ...
    async def zmpop(
        self,
        keys: "Parameters[KeyT]",
        where: "Literal[PureToken.MAX, PureToken.MIN]",
        count: "Optional[int]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def zmscore(
        self, key: "KeyT", members: "Parameters[ValueT]"
    ) -> Pipeline[AnyStr]: ...
    async def zpopmax(
        self, key: "KeyT", count: "Optional[int]" = ...
    ) -> Pipeline[AnyStr]: ...
    async def zpopmin(
        self, key: "KeyT", count: "Optional[int]" = ...
    ) -> Pipeline[AnyStr]: ...
    async def zrandmember(
        self,
        key: "KeyT",
        count: "Optional[int]" = ...,
        withscores: "Optional[bool]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def zrange(
        self,
        key: "KeyT",
        min_: "Union[int, ValueT]",
        max_: "Union[int, ValueT]",
        sortby: "Optional[Literal[PureToken.BYSCORE, PureToken.BYLEX]]" = ...,
        rev: "Optional[bool]" = ...,
        offset: "Optional[int]" = ...,
        count: "Optional[int]" = ...,
        withscores: "Optional[bool]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def zrangebylex(
        self,
        key: "KeyT",
        min_: "ValueT",
        max_: "ValueT",
        offset: "Optional[int]" = ...,
        count: "Optional[int]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def zrangebyscore(
        self,
        key: "KeyT",
        min_: "Union[int, float]",
        max_: "Union[int, float]",
        withscores: "Optional[bool]" = ...,
        offset: "Optional[int]" = ...,
        count: "Optional[int]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def zrangestore(
        self,
        dst: "KeyT",
        src: "KeyT",
        min_: "Union[int, ValueT]",
        max_: "Union[int, ValueT]",
        sortby: "Optional[Literal[PureToken.BYSCORE, PureToken.BYLEX]]" = ...,
        rev: "Optional[bool]" = ...,
        offset: "Optional[int]" = ...,
        count: "Optional[int]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def zrank(
        self, key: "KeyT", member: "ValueT", withscore: "Optional[bool]" = ...
    ) -> Pipeline[AnyStr]: ...
    async def zrem(
        self, key: "KeyT", members: "Parameters[ValueT]"
    ) -> Pipeline[AnyStr]: ...
    async def zremrangebylex(
        self, key: "KeyT", min_: "ValueT", max_: "ValueT"
    ) -> Pipeline[AnyStr]: ...
    async def zremrangebyrank(
        self, key: "KeyT", start: "int", stop: "int"
    ) -> Pipeline[AnyStr]: ...
    async def zremrangebyscore(
        self, key: "KeyT", min_: "Union[int, float]", max_: "Union[int, float]"
    ) -> Pipeline[AnyStr]: ...
    async def zrevrange(
        self, key: "KeyT", start: "int", stop: "int", withscores: "Optional[bool]" = ...
    ) -> Pipeline[AnyStr]: ...
    async def zrevrangebylex(
        self,
        key: "KeyT",
        max_: "ValueT",
        min_: "ValueT",
        offset: "Optional[int]" = ...,
        count: "Optional[int]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def zrevrangebyscore(
        self,
        key: "KeyT",
        max_: "Union[int, float]",
        min_: "Union[int, float]",
        withscores: "Optional[bool]" = ...,
        offset: "Optional[int]" = ...,
        count: "Optional[int]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def zrevrank(
        self, key: "KeyT", member: "ValueT", withscore: "Optional[bool]" = ...
    ) -> Pipeline[AnyStr]: ...
    async def zscan(
        self,
        key: "KeyT",
        cursor: "Optional[int]" = ...,
        match: "Optional[StringT]" = ...,
        count: "Optional[int]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def zscore(self, key: "KeyT", member: "ValueT") -> Pipeline[AnyStr]: ...
    async def zunion(
        self,
        keys: "Parameters[KeyT]",
        weights: "Optional[Parameters[int]]" = ...,
        aggregate: "Optional[Literal[PureToken.SUM, PureToken.MIN, PureToken.MAX]]" = ...,
        withscores: "Optional[bool]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def zunionstore(
        self,
        keys: "Parameters[KeyT]",
        destination: "KeyT",
        weights: "Optional[Parameters[int]]" = ...,
        aggregate: "Optional[Literal[PureToken.SUM, PureToken.MIN, PureToken.MAX]]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def pfadd(self, key: "KeyT", *elements: "ValueT") -> Pipeline[AnyStr]: ...
    async def pfcount(self, keys: "Parameters[KeyT]") -> Pipeline[AnyStr]: ...
    async def pfmerge(
        self, destkey: "KeyT", sourcekeys: "Parameters[KeyT]"
    ) -> Pipeline[AnyStr]: ...
    async def geoadd(
        self,
        key: "KeyT",
        longitude_latitude_members: "Parameters[Tuple[Union[int, float], Union[int, float], ValueT]]",
        condition: "Optional[Literal[PureToken.NX, PureToken.XX]]" = ...,
        change: "Optional[bool]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def geodist(
        self,
        key: "KeyT",
        member1: "StringT",
        member2: "StringT",
        unit: "Optional[Literal[PureToken.M, PureToken.KM, PureToken.FT, PureToken.MI]]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def geohash(
        self, key: "KeyT", members: "Parameters[ValueT]"
    ) -> Pipeline[AnyStr]: ...
    async def geopos(
        self, key: "KeyT", members: "Parameters[ValueT]"
    ) -> Pipeline[AnyStr]: ...
    async def georadius(
        self,
        key: "KeyT",
        longitude: "Union[int, float]",
        latitude: "Union[int, float]",
        radius: "Union[int, float]",
        unit: "Literal[PureToken.FT, PureToken.KM, PureToken.M, PureToken.MI]",
        withcoord: "Optional[bool]" = ...,
        withdist: "Optional[bool]" = ...,
        withhash: "Optional[bool]" = ...,
        count: "Optional[int]" = ...,
        any_: "Optional[bool]" = ...,
        order: "Optional[Literal[PureToken.ASC, PureToken.DESC]]" = ...,
        store: "Optional[KeyT]" = ...,
        storedist: "Optional[KeyT]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def georadiusbymember(
        self,
        key: "KeyT",
        member: "ValueT",
        radius: "Union[int, float]",
        unit: "Literal[PureToken.FT, PureToken.KM, PureToken.M, PureToken.MI]",
        withcoord: "Optional[bool]" = ...,
        withdist: "Optional[bool]" = ...,
        withhash: "Optional[bool]" = ...,
        count: "Optional[int]" = ...,
        any_: "Optional[bool]" = ...,
        order: "Optional[Literal[PureToken.ASC, PureToken.DESC]]" = ...,
        store: "Optional[KeyT]" = ...,
        storedist: "Optional[KeyT]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def geosearch(
        self,
        key: "KeyT",
        member: "Optional[ValueT]" = ...,
        longitude: "Optional[Union[int, float]]" = ...,
        latitude: "Optional[Union[int, float]]" = ...,
        radius: "Optional[Union[int, float]]" = ...,
        circle_unit: "Optional[Literal[PureToken.M, PureToken.KM, PureToken.FT, PureToken.MI]]" = ...,
        width: "Optional[Union[int, float]]" = ...,
        height: "Optional[Union[int, float]]" = ...,
        box_unit: "Optional[Literal[PureToken.M, PureToken.KM, PureToken.FT, PureToken.MI]]" = ...,
        order: "Optional[Literal[PureToken.ASC, PureToken.DESC]]" = ...,
        count: "Optional[int]" = ...,
        any_: "Optional[bool]" = ...,
        withcoord: "Optional[bool]" = ...,
        withdist: "Optional[bool]" = ...,
        withhash: "Optional[bool]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def geosearchstore(
        self,
        destination: "KeyT",
        source: "KeyT",
        member: "Optional[ValueT]" = ...,
        longitude: "Optional[Union[int, float]]" = ...,
        latitude: "Optional[Union[int, float]]" = ...,
        radius: "Optional[Union[int, float]]" = ...,
        circle_unit: "Optional[Literal[PureToken.M, PureToken.KM, PureToken.FT, PureToken.MI]]" = ...,
        width: "Optional[Union[int, float]]" = ...,
        height: "Optional[Union[int, float]]" = ...,
        box_unit: "Optional[Literal[PureToken.M, PureToken.KM, PureToken.FT, PureToken.MI]]" = ...,
        order: "Optional[Literal[PureToken.ASC, PureToken.DESC]]" = ...,
        count: "Optional[int]" = ...,
        any_: "Optional[bool]" = ...,
        storedist: "Optional[bool]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def xack(
        self, key: "KeyT", group: "StringT", identifiers: "Parameters[ValueT]"
    ) -> Pipeline[AnyStr]: ...
    async def xadd(
        self,
        key: "KeyT",
        field_values: "Dict[StringT, ValueT]",
        identifier: "Optional[ValueT]" = ...,
        nomkstream: "Optional[bool]" = ...,
        trim_strategy: "Optional[Literal[PureToken.MAXLEN, PureToken.MINID]]" = ...,
        threshold: "Optional[int]" = ...,
        trim_operator: "Optional[Literal[PureToken.EQUAL, PureToken.APPROXIMATELY]]" = ...,
        limit: "Optional[int]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def xautoclaim(
        self,
        key: "KeyT",
        group: "StringT",
        consumer: "StringT",
        min_idle_time: "Union[int, datetime.timedelta]",
        start: "ValueT",
        count: "Optional[int]" = ...,
        justid: "Optional[bool]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def xclaim(
        self,
        key: "KeyT",
        group: "StringT",
        consumer: "StringT",
        min_idle_time: "Union[int, datetime.timedelta]",
        identifiers: "Parameters[ValueT]",
        idle: "Optional[Union[int, datetime.timedelta]]" = ...,
        time: "Optional[Union[int, datetime.datetime]]" = ...,
        retrycount: "Optional[int]" = ...,
        force: "Optional[bool]" = ...,
        justid: "Optional[bool]" = ...,
        lastid: "Optional[ValueT]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def xdel(
        self, key: "KeyT", identifiers: "Parameters[ValueT]"
    ) -> Pipeline[AnyStr]: ...
    async def xgroup_create(
        self,
        key: "KeyT",
        groupname: "StringT",
        identifier: "Optional[ValueT]" = ...,
        mkstream: "Optional[bool]" = ...,
        entriesread: "Optional[int]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def xgroup_createconsumer(
        self, key: "KeyT", groupname: "StringT", consumername: "StringT"
    ) -> Pipeline[AnyStr]: ...
    async def xgroup_delconsumer(
        self, key: "KeyT", groupname: "StringT", consumername: "StringT"
    ) -> Pipeline[AnyStr]: ...
    async def xgroup_destroy(
        self, key: "KeyT", groupname: "StringT"
    ) -> Pipeline[AnyStr]: ...
    async def xgroup_setid(
        self,
        key: "KeyT",
        groupname: "StringT",
        identifier: "Optional[ValueT]" = ...,
        entriesread: "Optional[int]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def xinfo_consumers(
        self, key: "KeyT", groupname: "StringT"
    ) -> Pipeline[AnyStr]: ...
    async def xinfo_groups(self, key: "KeyT") -> Pipeline[AnyStr]: ...
    async def xinfo_stream(
        self, key: "KeyT", full: "Optional[bool]" = ..., count: "Optional[int]" = ...
    ) -> Pipeline[AnyStr]: ...
    async def xlen(self, key: "KeyT") -> Pipeline[AnyStr]: ...
    async def xpending(
        self,
        key: "KeyT",
        group: "StringT",
        start: "Optional[ValueT]" = ...,
        end: "Optional[ValueT]" = ...,
        count: "Optional[int]" = ...,
        idle: "Optional[int]" = ...,
        consumer: "Optional[StringT]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def xrange(
        self,
        key: "KeyT",
        start: "Optional[ValueT]" = ...,
        end: "Optional[ValueT]" = ...,
        count: "Optional[int]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def xread(
        self,
        streams: "Mapping[ValueT, ValueT]",
        count: "Optional[int]" = ...,
        block: "Optional[Union[int, datetime.timedelta]]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def xreadgroup(
        self,
        group: "StringT",
        consumer: "StringT",
        streams: "Mapping[ValueT, ValueT]",
        count: "Optional[int]" = ...,
        block: "Optional[Union[int, datetime.timedelta]]" = ...,
        noack: "Optional[bool]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def xrevrange(
        self,
        key: "KeyT",
        end: "Optional[ValueT]" = ...,
        start: "Optional[ValueT]" = ...,
        count: "Optional[int]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def xtrim(
        self,
        key: "KeyT",
        trim_strategy: "Literal[PureToken.MAXLEN, PureToken.MINID]",
        threshold: "int",
        trim_operator: "Optional[Literal[PureToken.EQUAL, PureToken.APPROXIMATELY]]" = ...,
        limit: "Optional[int]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def eval(
        self,
        script: "StringT",
        keys: "Optional[Parameters[KeyT]]" = ...,
        args: "Optional[Parameters[ValueT]]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def evalsha(
        self,
        sha1: "StringT",
        keys: "Optional[Parameters[KeyT]]" = ...,
        args: "Optional[Parameters[ValueT]]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def evalsha_ro(
        self,
        sha1: "StringT",
        keys: "Optional[Parameters[KeyT]]" = ...,
        args: "Optional[Parameters[ValueT]]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def eval_ro(
        self,
        script: "StringT",
        keys: "Optional[Parameters[KeyT]]" = ...,
        args: "Optional[Parameters[ValueT]]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def fcall(
        self,
        function: "StringT",
        keys: "Optional[Parameters[KeyT]]" = ...,
        args: "Optional[Parameters[ValueT]]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def fcall_ro(
        self,
        function: "StringT",
        keys: "Optional[Parameters[KeyT]]" = ...,
        args: "Optional[Parameters[ValueT]]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def function_delete(self, library_name: "StringT") -> Pipeline[AnyStr]: ...
    async def function_dump(self) -> Pipeline[AnyStr]: ...
    async def function_flush(
        self, async_: "Optional[Literal[PureToken.ASYNC, PureToken.SYNC]]" = ...
    ) -> Pipeline[AnyStr]: ...
    async def function_kill(self) -> Pipeline[AnyStr]: ...
    async def function_list(
        self, libraryname: "Optional[StringT]" = ..., withcode: "Optional[bool]" = ...
    ) -> Pipeline[AnyStr]: ...
    async def function_load(
        self, function_code: "StringT", replace: "Optional[bool]" = ...
    ) -> Pipeline[AnyStr]: ...
    async def function_restore(
        self,
        serialized_value: "bytes",
        policy: "Optional[Literal[PureToken.FLUSH, PureToken.APPEND, PureToken.REPLACE]]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def function_stats(self) -> Pipeline[AnyStr]: ...
    async def script_debug(
        self, mode: "Literal[PureToken.NO, PureToken.SYNC, PureToken.YES]"
    ) -> Pipeline[AnyStr]: ...
    async def script_exists(self, sha1s: "Parameters[StringT]") -> Pipeline[AnyStr]: ...
    async def script_flush(
        self, sync_type: "Optional[Literal[PureToken.ASYNC, PureToken.SYNC]]" = ...
    ) -> Pipeline[AnyStr]: ...
    async def script_kill(self) -> Pipeline[AnyStr]: ...
    async def script_load(self, script: "StringT") -> Pipeline[AnyStr]: ...
    async def publish(
        self, channel: "StringT", message: "ValueT"
    ) -> Pipeline[AnyStr]: ...
    async def pubsub_channels(
        self, pattern: "Optional[StringT]" = ...
    ) -> Pipeline[AnyStr]: ...
    async def pubsub_numpat(self) -> Pipeline[AnyStr]: ...
    async def pubsub_numsub(self, *channels: "StringT") -> Pipeline[AnyStr]: ...
    async def pubsub_shardchannels(
        self, pattern: "Optional[StringT]" = ...
    ) -> Pipeline[AnyStr]: ...
    async def pubsub_shardnumsub(self, *channels: "StringT") -> Pipeline[AnyStr]: ...
    async def spublish(
        self, channel: "StringT", message: "ValueT"
    ) -> Pipeline[AnyStr]: ...
    async def acl_cat(
        self, categoryname: "Optional[StringT]" = ...
    ) -> Pipeline[AnyStr]: ...
    async def acl_deluser(
        self, usernames: "Parameters[StringT]"
    ) -> Pipeline[AnyStr]: ...
    async def acl_dryrun(
        self, username: "StringT", command: "StringT", *args: "ValueT"
    ) -> Pipeline[AnyStr]: ...
    async def acl_genpass(self, bits: "Optional[int]" = ...) -> Pipeline[AnyStr]: ...
    async def acl_getuser(self, username: "StringT") -> Pipeline[AnyStr]: ...
    async def acl_list(self) -> Pipeline[AnyStr]: ...
    async def acl_load(self) -> Pipeline[AnyStr]: ...
    async def acl_log(
        self, count: "Optional[int]" = ..., reset: "Optional[bool]" = ...
    ) -> Pipeline[AnyStr]: ...
    async def acl_save(self) -> Pipeline[AnyStr]: ...
    async def acl_setuser(
        self, username: "StringT", *rules: "StringT"
    ) -> Pipeline[AnyStr]: ...
    async def acl_users(self) -> Pipeline[AnyStr]: ...
    async def acl_whoami(self) -> Pipeline[AnyStr]: ...
    async def bgrewriteaof(self) -> Pipeline[AnyStr]: ...
    async def bgsave(self, schedule: "Optional[bool]" = ...) -> Pipeline[AnyStr]: ...
    async def command(self) -> Pipeline[AnyStr]: ...
    async def command_count(self) -> Pipeline[AnyStr]: ...
    async def command_docs(self, *command_names: "StringT") -> Pipeline[AnyStr]: ...
    async def command_getkeys(
        self, command: "StringT", arguments: "Parameters[ValueT]"
    ) -> Pipeline[AnyStr]: ...
    async def command_getkeysandflags(
        self, command: "StringT", arguments: "Parameters[ValueT]"
    ) -> Pipeline[AnyStr]: ...
    async def command_info(self, *command_names: "StringT") -> Pipeline[AnyStr]: ...
    async def command_list(
        self,
        module: "Optional[StringT]" = ...,
        aclcat: "Optional[StringT]" = ...,
        pattern: "Optional[StringT]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def config_get(
        self, parameters: "Parameters[StringT]"
    ) -> Pipeline[AnyStr]: ...
    async def config_resetstat(self) -> Pipeline[AnyStr]: ...
    async def config_rewrite(self) -> Pipeline[AnyStr]: ...
    async def config_set(
        self, parameter_values: "Dict[StringT, ValueT]"
    ) -> Pipeline[AnyStr]: ...
    async def dbsize(self) -> Pipeline[AnyStr]: ...
    async def failover(
        self,
        host: "Optional[StringT]" = ...,
        port: "Optional[int]" = ...,
        force: "Optional[bool]" = ...,
        abort: "Optional[bool]" = ...,
        timeout: "Optional[Union[int, datetime.timedelta]]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def flushall(
        self, async_: "Optional[Literal[PureToken.ASYNC, PureToken.SYNC]]" = ...
    ) -> Pipeline[AnyStr]: ...
    async def flushdb(
        self, async_: "Optional[Literal[PureToken.ASYNC, PureToken.SYNC]]" = ...
    ) -> Pipeline[AnyStr]: ...
    async def info(self, *sections: "StringT") -> Pipeline[AnyStr]: ...
    async def lastsave(self) -> Pipeline[AnyStr]: ...
    async def latency_doctor(self) -> Pipeline[AnyStr]: ...
    async def latency_graph(self, event: "StringT") -> Pipeline[AnyStr]: ...
    async def latency_histogram(self, *commands: "StringT") -> Pipeline[AnyStr]: ...
    async def latency_history(self, event: "StringT") -> Pipeline[AnyStr]: ...
    async def latency_latest(self) -> Pipeline[AnyStr]: ...
    async def latency_reset(self, *events: "StringT") -> Pipeline[AnyStr]: ...
    async def lolwut(self, version: "Optional[int]" = ...) -> Pipeline[AnyStr]: ...
    async def memory_doctor(self) -> Pipeline[AnyStr]: ...
    async def memory_malloc_stats(self) -> Pipeline[AnyStr]: ...
    async def memory_purge(self) -> Pipeline[AnyStr]: ...
    async def memory_stats(self) -> Pipeline[AnyStr]: ...
    async def memory_usage(
        self, key: "KeyT", samples: "Optional[int]" = ...
    ) -> Pipeline[AnyStr]: ...
    async def module_list(self) -> Pipeline[AnyStr]: ...
    async def module_load(
        self, path: "StringT", *args: "Union[str, bytes, int, float]"
    ) -> Pipeline[AnyStr]: ...
    async def module_loadex(
        self,
        path: "StringT",
        configs: "Optional[Dict[StringT, ValueT]]" = ...,
        args: "Optional[Parameters[ValueT]]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def module_unload(self, name: "StringT") -> Pipeline[AnyStr]: ...
    async def replicaof(
        self, host: "Optional[StringT]" = ..., port: "Optional[int]" = ...
    ) -> Pipeline[AnyStr]: ...
    async def role(self) -> Pipeline[AnyStr]: ...
    async def save(self) -> Pipeline[AnyStr]: ...
    async def shutdown(
        self,
        nosave_save: "Optional[Literal[PureToken.NOSAVE, PureToken.SAVE]]" = ...,
        now: "Optional[bool]" = ...,
        force: "Optional[bool]" = ...,
        abort: "Optional[bool]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def slaveof(
        self, host: "Optional[StringT]" = ..., port: "Optional[int]" = ...
    ) -> Pipeline[AnyStr]: ...
    async def slowlog_get(self, count: "Optional[int]" = ...) -> Pipeline[AnyStr]: ...
    async def slowlog_len(self) -> Pipeline[AnyStr]: ...
    async def slowlog_reset(self) -> Pipeline[AnyStr]: ...
    async def swapdb(self, index1: "int", index2: "int") -> Pipeline[AnyStr]: ...
    async def time(self) -> Pipeline[AnyStr]: ...
    async def auth(
        self, password: "StringT", username: "Optional[StringT]" = ...
    ) -> Pipeline[AnyStr]: ...
    async def client_caching(
        self, mode: "Literal[PureToken.NO, PureToken.YES]"
    ) -> Pipeline[AnyStr]: ...
    async def client_getname(self) -> Pipeline[AnyStr]: ...
    async def client_getredir(self) -> Pipeline[AnyStr]: ...
    async def client_id(self) -> Pipeline[AnyStr]: ...
    async def client_info(self) -> Pipeline[AnyStr]: ...
    async def client_kill(
        self,
        ip_port: "Optional[StringT]" = ...,
        identifier: "Optional[int]" = ...,
        type_: "Optional[Literal[PureToken.NORMAL, PureToken.MASTER, PureToken.SLAVE, PureToken.REPLICA, PureToken.PUBSUB]]" = ...,
        user: "Optional[StringT]" = ...,
        addr: "Optional[StringT]" = ...,
        laddr: "Optional[StringT]" = ...,
        skipme: "Optional[bool]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def client_list(
        self,
        type_: "Optional[Literal[PureToken.MASTER, PureToken.NORMAL, PureToken.PUBSUB, PureToken.REPLICA]]" = ...,
        identifiers: "Optional[Parameters[int]]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def client_no_evict(
        self, enabled: "Literal[PureToken.ON, PureToken.OFF]"
    ) -> Pipeline[AnyStr]: ...
    async def client_no_touch(
        self, enabled: "Literal[PureToken.OFF, PureToken.ON]"
    ) -> Pipeline[AnyStr]: ...
    async def client_pause(
        self,
        timeout: "int",
        mode: "Optional[Literal[PureToken.WRITE, PureToken.ALL]]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def client_reply(
        self, mode: "Literal[PureToken.OFF, PureToken.ON, PureToken.SKIP]"
    ) -> Pipeline[AnyStr]: ...
    async def client_setinfo(
        self, lib_name: "Optional[StringT]" = ..., lib_ver: "Optional[StringT]" = ...
    ) -> Pipeline[AnyStr]: ...
    async def client_setname(self, connection_name: "StringT") -> Pipeline[AnyStr]: ...
    async def client_tracking(
        self,
        status: "Literal[PureToken.OFF, PureToken.ON]",
        *prefixes: "StringT",
        redirect: "Optional[int]" = ...,
        bcast: "Optional[bool]" = ...,
        optin: "Optional[bool]" = ...,
        optout: "Optional[bool]" = ...,
        noloop: "Optional[bool]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def client_trackinginfo(self) -> Pipeline[AnyStr]: ...
    async def client_unblock(
        self,
        client_id: "int",
        timeout_error: "Optional[Literal[PureToken.TIMEOUT, PureToken.ERROR]]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def client_unpause(self) -> Pipeline[AnyStr]: ...
    async def echo(self, message: "StringT") -> Pipeline[AnyStr]: ...
    async def hello(
        self,
        protover: "Optional[int]" = ...,
        username: "Optional[StringT]" = ...,
        password: "Optional[StringT]" = ...,
        setname: "Optional[StringT]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def ping(self, message: "Optional[StringT]" = ...) -> Pipeline[AnyStr]: ...
    async def quit(self) -> Pipeline[AnyStr]: ...
    async def reset(self) -> Pipeline[AnyStr]: ...
    async def select(self, index: "int") -> Pipeline[AnyStr]: ...
    async def asking(self) -> Pipeline[AnyStr]: ...
    async def cluster_addslots(self, slots: "Parameters[int]") -> Pipeline[AnyStr]: ...
    async def cluster_addslotsrange(
        self, slots: "Parameters[Tuple[int, int]]"
    ) -> Pipeline[AnyStr]: ...
    async def cluster_bumpepoch(self) -> Pipeline[AnyStr]: ...
    async def cluster_count_failure_reports(
        self, node_id: "StringT"
    ) -> Pipeline[AnyStr]: ...
    async def cluster_countkeysinslot(self, slot: "int") -> Pipeline[AnyStr]: ...
    async def cluster_delslots(self, slots: "Parameters[int]") -> Pipeline[AnyStr]: ...
    async def cluster_delslotsrange(
        self, slots: "Parameters[Tuple[int, int]]"
    ) -> Pipeline[AnyStr]: ...
    async def cluster_failover(
        self, options: "Optional[Literal[PureToken.FORCE, PureToken.TAKEOVER]]" = ...
    ) -> Pipeline[AnyStr]: ...
    async def cluster_flushslots(self) -> Pipeline[AnyStr]: ...
    async def cluster_forget(self, node_id: "StringT") -> Pipeline[AnyStr]: ...
    async def cluster_getkeysinslot(
        self, slot: "int", count: "int"
    ) -> Pipeline[AnyStr]: ...
    async def cluster_info(self) -> Pipeline[AnyStr]: ...
    async def cluster_keyslot(self, key: "KeyT") -> Pipeline[AnyStr]: ...
    async def cluster_links(self) -> Pipeline[AnyStr]: ...
    async def cluster_meet(
        self, ip: "StringT", port: "int", cluster_bus_port: "Optional[int]" = ...
    ) -> Pipeline[AnyStr]: ...
    async def cluster_myid(self) -> Pipeline[AnyStr]: ...
    async def cluster_nodes(self) -> Pipeline[AnyStr]: ...
    async def cluster_replicas(self, node_id: "StringT") -> Pipeline[AnyStr]: ...
    async def cluster_replicate(self, node_id: "StringT") -> Pipeline[AnyStr]: ...
    async def cluster_reset(
        self, hard_soft: "Optional[Literal[PureToken.HARD, PureToken.SOFT]]" = ...
    ) -> Pipeline[AnyStr]: ...
    async def cluster_saveconfig(self) -> Pipeline[AnyStr]: ...
    async def cluster_set_config_epoch(
        self, config_epoch: "int"
    ) -> Pipeline[AnyStr]: ...
    async def cluster_setslot(
        self,
        slot: "int",
        importing: "Optional[StringT]" = ...,
        migrating: "Optional[StringT]" = ...,
        node: "Optional[StringT]" = ...,
        stable: "Optional[bool]" = ...,
    ) -> Pipeline[AnyStr]: ...
    async def cluster_shards(self) -> Pipeline[AnyStr]: ...
    async def cluster_slaves(self, node_id: "StringT") -> Pipeline[AnyStr]: ...
    async def cluster_slots(self) -> Pipeline[AnyStr]: ...
    async def readonly(self) -> Pipeline[AnyStr]: ...
    async def readwrite(self) -> Pipeline[AnyStr]: ...
    async def watch(self, *keys: "KeyT") -> bool: ...
    async def unwatch(self) -> bool: ...
    def multi(self) -> None: ...
    async def execute(self, raise_on_error: "bool" = ...) -> Tuple[Any, ...]: ...
    async def __aenter__(self) -> "Pipeline[AnyStr]": ...
    async def __aexit__(
        self,
        exc_type: Optional[Type[BaseException]],
        exc_value: Optional[BaseException],
        traceback: Optional[TracebackType],
    ) -> None: ...

class ClusterPipeline(ObjectProxy, Generic[AnyStr]):  # type: ignore
    @classmethod
    def proxy(
        cls,
        connection_pool: "ClusterConnectionPool",
        result_callbacks: "Optional[Dict[bytes, Callable[..., Any]]]" = ...,
        transaction: "Optional[bool]" = ...,
        watches: "Optional[Parameters[KeyT]]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def copy(
        self,
        source: "KeyT",
        destination: "KeyT",
        db: "Optional[int]" = ...,
        replace: "Optional[bool]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def delete(self, keys: "Parameters[KeyT]") -> ClusterPipeline[AnyStr]: ...
    async def dump(self, key: "KeyT") -> ClusterPipeline[AnyStr]: ...
    async def exists(self, keys: "Parameters[KeyT]") -> ClusterPipeline[AnyStr]: ...
    async def expire(
        self,
        key: "KeyT",
        seconds: "Union[int, datetime.timedelta]",
        condition: "Optional[Literal[PureToken.NX, PureToken.XX, PureToken.GT, PureToken.LT]]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def expireat(
        self,
        key: "KeyT",
        unix_time_seconds: "Union[int, datetime.datetime]",
        condition: "Optional[Literal[PureToken.NX, PureToken.XX, PureToken.GT, PureToken.LT]]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def expiretime(self, key: "KeyT") -> ClusterPipeline[AnyStr]: ...
    async def keys(self, pattern: "StringT" = ...) -> ClusterPipeline[AnyStr]: ...
    async def migrate(
        self,
        host: "StringT",
        port: "int",
        destination_db: "int",
        timeout: "int",
        *keys: "KeyT",
        copy: "Optional[bool]" = ...,
        replace: "Optional[bool]" = ...,
        auth: "Optional[StringT]" = ...,
        username: "Optional[StringT]" = ...,
        password: "Optional[StringT]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def move(self, key: "KeyT", db: "int") -> ClusterPipeline[AnyStr]: ...
    async def object_encoding(self, key: "KeyT") -> ClusterPipeline[AnyStr]: ...
    async def object_freq(self, key: "KeyT") -> ClusterPipeline[AnyStr]: ...
    async def object_idletime(self, key: "KeyT") -> ClusterPipeline[AnyStr]: ...
    async def object_refcount(self, key: "KeyT") -> ClusterPipeline[AnyStr]: ...
    async def persist(self, key: "KeyT") -> ClusterPipeline[AnyStr]: ...
    async def pexpire(
        self,
        key: "KeyT",
        milliseconds: "Union[int, datetime.timedelta]",
        condition: "Optional[Literal[PureToken.NX, PureToken.XX, PureToken.GT, PureToken.LT]]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def pexpireat(
        self,
        key: "KeyT",
        unix_time_milliseconds: "Union[int, datetime.datetime]",
        condition: "Optional[Literal[PureToken.NX, PureToken.XX, PureToken.GT, PureToken.LT]]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def pexpiretime(self, key: "KeyT") -> ClusterPipeline[AnyStr]: ...
    async def pttl(self, key: "KeyT") -> ClusterPipeline[AnyStr]: ...
    async def randomkey(self) -> ClusterPipeline[AnyStr]: ...
    async def rename(self, key: "KeyT", newkey: "KeyT") -> ClusterPipeline[AnyStr]: ...
    async def renamenx(
        self, key: "KeyT", newkey: "KeyT"
    ) -> ClusterPipeline[AnyStr]: ...
    async def restore(
        self,
        key: "KeyT",
        ttl: "Union[int, datetime.timedelta, datetime.datetime]",
        serialized_value: "bytes",
        replace: "Optional[bool]" = ...,
        absttl: "Optional[bool]" = ...,
        idletime: "Optional[Union[int, datetime.timedelta]]" = ...,
        freq: "Optional[int]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def scan(
        self,
        cursor: "Optional[int]" = ...,
        match: "Optional[StringT]" = ...,
        count: "Optional[int]" = ...,
        type_: "Optional[StringT]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def sort(
        self,
        key: "KeyT",
        gets: "Optional[Parameters[KeyT]]" = ...,
        by: "Optional[StringT]" = ...,
        offset: "Optional[int]" = ...,
        count: "Optional[int]" = ...,
        order: "Optional[Literal[PureToken.ASC, PureToken.DESC]]" = ...,
        alpha: "Optional[bool]" = ...,
        store: "Optional[KeyT]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def sort_ro(
        self,
        key: "KeyT",
        gets: "Optional[Parameters[KeyT]]" = ...,
        by: "Optional[StringT]" = ...,
        offset: "Optional[int]" = ...,
        count: "Optional[int]" = ...,
        order: "Optional[Literal[PureToken.ASC, PureToken.DESC]]" = ...,
        alpha: "Optional[bool]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def touch(self, keys: "Parameters[KeyT]") -> ClusterPipeline[AnyStr]: ...
    async def ttl(self, key: "KeyT") -> ClusterPipeline[AnyStr]: ...
    async def type(self, key: "KeyT") -> ClusterPipeline[AnyStr]: ...
    async def unlink(self, keys: "Parameters[KeyT]") -> ClusterPipeline[AnyStr]: ...
    async def wait(
        self, numreplicas: "int", timeout: "int"
    ) -> ClusterPipeline[AnyStr]: ...
    async def waitaof(
        self, numlocal: "int", numreplicas: "int", timeout: "int"
    ) -> ClusterPipeline[AnyStr]: ...
    async def append(self, key: "KeyT", value: "ValueT") -> ClusterPipeline[AnyStr]: ...
    async def decr(self, key: "KeyT") -> ClusterPipeline[AnyStr]: ...
    async def decrby(
        self, key: "KeyT", decrement: "int"
    ) -> ClusterPipeline[AnyStr]: ...
    async def get(self, key: "KeyT") -> ClusterPipeline[AnyStr]: ...
    async def getdel(self, key: "KeyT") -> ClusterPipeline[AnyStr]: ...
    async def getex(
        self,
        key: "KeyT",
        ex: "Optional[Union[int, datetime.timedelta]]" = ...,
        px: "Optional[Union[int, datetime.timedelta]]" = ...,
        exat: "Optional[Union[int, datetime.datetime]]" = ...,
        pxat: "Optional[Union[int, datetime.datetime]]" = ...,
        persist: "Optional[bool]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def getrange(
        self, key: "KeyT", start: "int", end: "int"
    ) -> ClusterPipeline[AnyStr]: ...
    async def getset(self, key: "KeyT", value: "ValueT") -> ClusterPipeline[AnyStr]: ...
    async def incr(self, key: "KeyT") -> ClusterPipeline[AnyStr]: ...
    async def incrby(
        self, key: "KeyT", increment: "int"
    ) -> ClusterPipeline[AnyStr]: ...
    async def incrbyfloat(
        self, key: "KeyT", increment: "Union[int, float]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def lcs(
        self,
        key1: "KeyT",
        key2: "KeyT",
        len_: "Optional[bool]" = ...,
        idx: "Optional[bool]" = ...,
        minmatchlen: "Optional[int]" = ...,
        withmatchlen: "Optional[bool]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def mget(self, keys: "Parameters[KeyT]") -> ClusterPipeline[AnyStr]: ...
    async def mset(
        self, key_values: "Dict[KeyT, ValueT]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def msetnx(
        self, key_values: "Dict[KeyT, ValueT]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def psetex(
        self,
        key: "KeyT",
        milliseconds: "Union[int, datetime.timedelta]",
        value: "ValueT",
    ) -> ClusterPipeline[AnyStr]: ...
    async def set(
        self,
        key: "KeyT",
        value: "ValueT",
        condition: "Optional[Literal[PureToken.NX, PureToken.XX]]" = ...,
        get: "Optional[bool]" = ...,
        ex: "Optional[Union[int, datetime.timedelta]]" = ...,
        px: "Optional[Union[int, datetime.timedelta]]" = ...,
        exat: "Optional[Union[int, datetime.datetime]]" = ...,
        pxat: "Optional[Union[int, datetime.datetime]]" = ...,
        keepttl: "Optional[bool]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def setex(
        self, key: "KeyT", value: "ValueT", seconds: "Union[int, datetime.timedelta]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def setnx(self, key: "KeyT", value: "ValueT") -> ClusterPipeline[AnyStr]: ...
    async def setrange(
        self, key: "KeyT", offset: "int", value: "ValueT"
    ) -> ClusterPipeline[AnyStr]: ...
    async def strlen(self, key: "KeyT") -> ClusterPipeline[AnyStr]: ...
    async def substr(
        self, key: "KeyT", start: "int", end: "int"
    ) -> ClusterPipeline[AnyStr]: ...
    async def bitcount(
        self,
        key: "KeyT",
        start: "Optional[int]" = ...,
        end: "Optional[int]" = ...,
        index_unit: "Optional[Literal[PureToken.BIT, PureToken.BYTE]]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def bitop(
        self, keys: "Parameters[KeyT]", operation: "StringT", destkey: "KeyT"
    ) -> ClusterPipeline[AnyStr]: ...
    async def bitpos(
        self,
        key: "KeyT",
        bit: "int",
        start: "Optional[int]" = ...,
        end: "Optional[int]" = ...,
        index_unit: "Optional[Literal[PureToken.BIT, PureToken.BYTE]]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def getbit(self, key: "KeyT", offset: "int") -> ClusterPipeline[AnyStr]: ...
    async def setbit(
        self, key: "KeyT", offset: "int", value: "int"
    ) -> ClusterPipeline[AnyStr]: ...
    async def hdel(
        self, key: "KeyT", fields: "Parameters[StringT]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def hexists(
        self, key: "KeyT", field: "StringT"
    ) -> ClusterPipeline[AnyStr]: ...
    async def hget(self, key: "KeyT", field: "StringT") -> ClusterPipeline[AnyStr]: ...
    async def hgetall(self, key: "KeyT") -> ClusterPipeline[AnyStr]: ...
    async def hincrby(
        self, key: "KeyT", field: "StringT", increment: "int"
    ) -> ClusterPipeline[AnyStr]: ...
    async def hincrbyfloat(
        self, key: "KeyT", field: "StringT", increment: "Union[int, float]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def hkeys(self, key: "KeyT") -> ClusterPipeline[AnyStr]: ...
    async def hlen(self, key: "KeyT") -> ClusterPipeline[AnyStr]: ...
    async def hmget(
        self, key: "KeyT", fields: "Parameters[StringT]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def hmset(
        self, key: "KeyT", field_values: "Dict[StringT, ValueT]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def hrandfield(
        self,
        key: "KeyT",
        count: "Optional[int]" = ...,
        withvalues: "Optional[bool]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def hscan(
        self,
        key: "KeyT",
        cursor: "Optional[int]" = ...,
        match: "Optional[StringT]" = ...,
        count: "Optional[int]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def hset(
        self, key: "KeyT", field_values: "Dict[StringT, ValueT]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def hsetnx(
        self, key: "KeyT", field: "StringT", value: "ValueT"
    ) -> ClusterPipeline[AnyStr]: ...
    async def hstrlen(
        self, key: "KeyT", field: "StringT"
    ) -> ClusterPipeline[AnyStr]: ...
    async def hvals(self, key: "KeyT") -> ClusterPipeline[AnyStr]: ...
    async def blmove(
        self,
        source: "KeyT",
        destination: "KeyT",
        wherefrom: "Literal[PureToken.LEFT, PureToken.RIGHT]",
        whereto: "Literal[PureToken.LEFT, PureToken.RIGHT]",
        timeout: "Union[int, float]",
    ) -> ClusterPipeline[AnyStr]: ...
    async def blmpop(
        self,
        keys: "Parameters[KeyT]",
        timeout: "Union[int, float]",
        where: "Literal[PureToken.LEFT, PureToken.RIGHT]",
        count: "Optional[int]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def blpop(
        self, keys: "Parameters[KeyT]", timeout: "Union[int, float]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def brpop(
        self, keys: "Parameters[KeyT]", timeout: "Union[int, float]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def brpoplpush(
        self, source: "KeyT", destination: "KeyT", timeout: "Union[int, float]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def lindex(self, key: "KeyT", index: "int") -> ClusterPipeline[AnyStr]: ...
    async def linsert(
        self,
        key: "KeyT",
        where: "Literal[PureToken.AFTER, PureToken.BEFORE]",
        pivot: "ValueT",
        element: "ValueT",
    ) -> ClusterPipeline[AnyStr]: ...
    async def llen(self, key: "KeyT") -> ClusterPipeline[AnyStr]: ...
    async def lmove(
        self,
        source: "KeyT",
        destination: "KeyT",
        wherefrom: "Literal[PureToken.LEFT, PureToken.RIGHT]",
        whereto: "Literal[PureToken.LEFT, PureToken.RIGHT]",
    ) -> ClusterPipeline[AnyStr]: ...
    async def lmpop(
        self,
        keys: "Parameters[KeyT]",
        where: "Literal[PureToken.LEFT, PureToken.RIGHT]",
        count: "Optional[int]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def lpop(
        self, key: "KeyT", count: "Optional[int]" = ...
    ) -> ClusterPipeline[AnyStr]: ...
    async def lpos(
        self,
        key: "KeyT",
        element: "ValueT",
        rank: "Optional[int]" = ...,
        count: "Optional[int]" = ...,
        maxlen: "Optional[int]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def lpush(
        self, key: "KeyT", elements: "Parameters[ValueT]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def lpushx(
        self, key: "KeyT", elements: "Parameters[ValueT]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def lrange(
        self, key: "KeyT", start: "int", stop: "int"
    ) -> ClusterPipeline[AnyStr]: ...
    async def lrem(
        self, key: "KeyT", count: "int", element: "ValueT"
    ) -> ClusterPipeline[AnyStr]: ...
    async def lset(
        self, key: "KeyT", index: "int", element: "ValueT"
    ) -> ClusterPipeline[AnyStr]: ...
    async def ltrim(
        self, key: "KeyT", start: "int", stop: "int"
    ) -> ClusterPipeline[AnyStr]: ...
    async def rpop(
        self, key: "KeyT", count: "Optional[int]" = ...
    ) -> ClusterPipeline[AnyStr]: ...
    async def rpoplpush(
        self, source: "KeyT", destination: "KeyT"
    ) -> ClusterPipeline[AnyStr]: ...
    async def rpush(
        self, key: "KeyT", elements: "Parameters[ValueT]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def rpushx(
        self, key: "KeyT", elements: "Parameters[ValueT]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def sadd(
        self, key: "KeyT", members: "Parameters[ValueT]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def scard(self, key: "KeyT") -> ClusterPipeline[AnyStr]: ...
    async def sdiff(self, keys: "Parameters[KeyT]") -> ClusterPipeline[AnyStr]: ...
    async def sdiffstore(
        self, keys: "Parameters[KeyT]", destination: "KeyT"
    ) -> ClusterPipeline[AnyStr]: ...
    async def sinter(self, keys: "Parameters[KeyT]") -> ClusterPipeline[AnyStr]: ...
    async def sintercard(
        self, keys: "Parameters[KeyT]", limit: "Optional[int]" = ...
    ) -> ClusterPipeline[AnyStr]: ...
    async def sinterstore(
        self, keys: "Parameters[KeyT]", destination: "KeyT"
    ) -> ClusterPipeline[AnyStr]: ...
    async def sismember(
        self, key: "KeyT", member: "ValueT"
    ) -> ClusterPipeline[AnyStr]: ...
    async def smembers(self, key: "KeyT") -> ClusterPipeline[AnyStr]: ...
    async def smismember(
        self, key: "KeyT", members: "Parameters[ValueT]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def smove(
        self, source: "KeyT", destination: "KeyT", member: "ValueT"
    ) -> ClusterPipeline[AnyStr]: ...
    async def spop(
        self, key: "KeyT", count: "Optional[int]" = ...
    ) -> ClusterPipeline[AnyStr]: ...
    async def srandmember(
        self, key: "KeyT", count: "Optional[int]" = ...
    ) -> ClusterPipeline[AnyStr]: ...
    async def srem(
        self, key: "KeyT", members: "Parameters[ValueT]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def sscan(
        self,
        key: "KeyT",
        cursor: "Optional[int]" = ...,
        match: "Optional[StringT]" = ...,
        count: "Optional[int]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def sunion(self, keys: "Parameters[KeyT]") -> ClusterPipeline[AnyStr]: ...
    async def sunionstore(
        self, keys: "Parameters[KeyT]", destination: "KeyT"
    ) -> ClusterPipeline[AnyStr]: ...
    async def bzmpop(
        self,
        keys: "Parameters[KeyT]",
        timeout: "Union[int, float]",
        where: "Literal[PureToken.MAX, PureToken.MIN]",
        count: "Optional[int]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def bzpopmax(
        self, keys: "Parameters[KeyT]", timeout: "Union[int, float]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def bzpopmin(
        self, keys: "Parameters[KeyT]", timeout: "Union[int, float]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def zadd(
        self,
        key: "KeyT",
        member_scores: "Dict[StringT, float]",
        condition: "Optional[Literal[PureToken.NX, PureToken.XX]]" = ...,
        comparison: "Optional[Literal[PureToken.GT, PureToken.LT]]" = ...,
        change: "Optional[bool]" = ...,
        increment: "Optional[bool]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def zcard(self, key: "KeyT") -> ClusterPipeline[AnyStr]: ...
    async def zcount(
        self, key: "KeyT", min_: "ValueT", max_: "ValueT"
    ) -> ClusterPipeline[AnyStr]: ...
    async def zdiff(
        self, keys: "Parameters[KeyT]", withscores: "Optional[bool]" = ...
    ) -> ClusterPipeline[AnyStr]: ...
    async def zdiffstore(
        self, keys: "Parameters[KeyT]", destination: "KeyT"
    ) -> ClusterPipeline[AnyStr]: ...
    async def zincrby(
        self, key: "KeyT", member: "ValueT", increment: "int"
    ) -> ClusterPipeline[AnyStr]: ...
    async def zinter(
        self,
        keys: "Parameters[KeyT]",
        weights: "Optional[Parameters[int]]" = ...,
        aggregate: "Optional[Literal[PureToken.MAX, PureToken.MIN, PureToken.SUM]]" = ...,
        withscores: "Optional[bool]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def zintercard(
        self, keys: "Parameters[KeyT]", limit: "Optional[int]" = ...
    ) -> ClusterPipeline[AnyStr]: ...
    async def zinterstore(
        self,
        keys: "Parameters[KeyT]",
        destination: "KeyT",
        weights: "Optional[Parameters[int]]" = ...,
        aggregate: "Optional[Literal[PureToken.MAX, PureToken.MIN, PureToken.SUM]]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def zlexcount(
        self, key: "KeyT", min_: "ValueT", max_: "ValueT"
    ) -> ClusterPipeline[AnyStr]: ...
    async def zmpop(
        self,
        keys: "Parameters[KeyT]",
        where: "Literal[PureToken.MAX, PureToken.MIN]",
        count: "Optional[int]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def zmscore(
        self, key: "KeyT", members: "Parameters[ValueT]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def zpopmax(
        self, key: "KeyT", count: "Optional[int]" = ...
    ) -> ClusterPipeline[AnyStr]: ...
    async def zpopmin(
        self, key: "KeyT", count: "Optional[int]" = ...
    ) -> ClusterPipeline[AnyStr]: ...
    async def zrandmember(
        self,
        key: "KeyT",
        count: "Optional[int]" = ...,
        withscores: "Optional[bool]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def zrange(
        self,
        key: "KeyT",
        min_: "Union[int, ValueT]",
        max_: "Union[int, ValueT]",
        sortby: "Optional[Literal[PureToken.BYSCORE, PureToken.BYLEX]]" = ...,
        rev: "Optional[bool]" = ...,
        offset: "Optional[int]" = ...,
        count: "Optional[int]" = ...,
        withscores: "Optional[bool]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def zrangebylex(
        self,
        key: "KeyT",
        min_: "ValueT",
        max_: "ValueT",
        offset: "Optional[int]" = ...,
        count: "Optional[int]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def zrangebyscore(
        self,
        key: "KeyT",
        min_: "Union[int, float]",
        max_: "Union[int, float]",
        withscores: "Optional[bool]" = ...,
        offset: "Optional[int]" = ...,
        count: "Optional[int]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def zrangestore(
        self,
        dst: "KeyT",
        src: "KeyT",
        min_: "Union[int, ValueT]",
        max_: "Union[int, ValueT]",
        sortby: "Optional[Literal[PureToken.BYSCORE, PureToken.BYLEX]]" = ...,
        rev: "Optional[bool]" = ...,
        offset: "Optional[int]" = ...,
        count: "Optional[int]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def zrank(
        self, key: "KeyT", member: "ValueT", withscore: "Optional[bool]" = ...
    ) -> ClusterPipeline[AnyStr]: ...
    async def zrem(
        self, key: "KeyT", members: "Parameters[ValueT]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def zremrangebylex(
        self, key: "KeyT", min_: "ValueT", max_: "ValueT"
    ) -> ClusterPipeline[AnyStr]: ...
    async def zremrangebyrank(
        self, key: "KeyT", start: "int", stop: "int"
    ) -> ClusterPipeline[AnyStr]: ...
    async def zremrangebyscore(
        self, key: "KeyT", min_: "Union[int, float]", max_: "Union[int, float]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def zrevrange(
        self, key: "KeyT", start: "int", stop: "int", withscores: "Optional[bool]" = ...
    ) -> ClusterPipeline[AnyStr]: ...
    async def zrevrangebylex(
        self,
        key: "KeyT",
        max_: "ValueT",
        min_: "ValueT",
        offset: "Optional[int]" = ...,
        count: "Optional[int]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def zrevrangebyscore(
        self,
        key: "KeyT",
        max_: "Union[int, float]",
        min_: "Union[int, float]",
        withscores: "Optional[bool]" = ...,
        offset: "Optional[int]" = ...,
        count: "Optional[int]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def zrevrank(
        self, key: "KeyT", member: "ValueT", withscore: "Optional[bool]" = ...
    ) -> ClusterPipeline[AnyStr]: ...
    async def zscan(
        self,
        key: "KeyT",
        cursor: "Optional[int]" = ...,
        match: "Optional[StringT]" = ...,
        count: "Optional[int]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def zscore(
        self, key: "KeyT", member: "ValueT"
    ) -> ClusterPipeline[AnyStr]: ...
    async def zunion(
        self,
        keys: "Parameters[KeyT]",
        weights: "Optional[Parameters[int]]" = ...,
        aggregate: "Optional[Literal[PureToken.SUM, PureToken.MIN, PureToken.MAX]]" = ...,
        withscores: "Optional[bool]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def zunionstore(
        self,
        keys: "Parameters[KeyT]",
        destination: "KeyT",
        weights: "Optional[Parameters[int]]" = ...,
        aggregate: "Optional[Literal[PureToken.SUM, PureToken.MIN, PureToken.MAX]]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def pfadd(
        self, key: "KeyT", *elements: "ValueT"
    ) -> ClusterPipeline[AnyStr]: ...
    async def pfcount(self, keys: "Parameters[KeyT]") -> ClusterPipeline[AnyStr]: ...
    async def pfmerge(
        self, destkey: "KeyT", sourcekeys: "Parameters[KeyT]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def geoadd(
        self,
        key: "KeyT",
        longitude_latitude_members: "Parameters[Tuple[Union[int, float], Union[int, float], ValueT]]",
        condition: "Optional[Literal[PureToken.NX, PureToken.XX]]" = ...,
        change: "Optional[bool]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def geodist(
        self,
        key: "KeyT",
        member1: "StringT",
        member2: "StringT",
        unit: "Optional[Literal[PureToken.M, PureToken.KM, PureToken.FT, PureToken.MI]]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def geohash(
        self, key: "KeyT", members: "Parameters[ValueT]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def geopos(
        self, key: "KeyT", members: "Parameters[ValueT]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def georadius(
        self,
        key: "KeyT",
        longitude: "Union[int, float]",
        latitude: "Union[int, float]",
        radius: "Union[int, float]",
        unit: "Literal[PureToken.FT, PureToken.KM, PureToken.M, PureToken.MI]",
        withcoord: "Optional[bool]" = ...,
        withdist: "Optional[bool]" = ...,
        withhash: "Optional[bool]" = ...,
        count: "Optional[int]" = ...,
        any_: "Optional[bool]" = ...,
        order: "Optional[Literal[PureToken.ASC, PureToken.DESC]]" = ...,
        store: "Optional[KeyT]" = ...,
        storedist: "Optional[KeyT]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def georadiusbymember(
        self,
        key: "KeyT",
        member: "ValueT",
        radius: "Union[int, float]",
        unit: "Literal[PureToken.FT, PureToken.KM, PureToken.M, PureToken.MI]",
        withcoord: "Optional[bool]" = ...,
        withdist: "Optional[bool]" = ...,
        withhash: "Optional[bool]" = ...,
        count: "Optional[int]" = ...,
        any_: "Optional[bool]" = ...,
        order: "Optional[Literal[PureToken.ASC, PureToken.DESC]]" = ...,
        store: "Optional[KeyT]" = ...,
        storedist: "Optional[KeyT]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def geosearch(
        self,
        key: "KeyT",
        member: "Optional[ValueT]" = ...,
        longitude: "Optional[Union[int, float]]" = ...,
        latitude: "Optional[Union[int, float]]" = ...,
        radius: "Optional[Union[int, float]]" = ...,
        circle_unit: "Optional[Literal[PureToken.M, PureToken.KM, PureToken.FT, PureToken.MI]]" = ...,
        width: "Optional[Union[int, float]]" = ...,
        height: "Optional[Union[int, float]]" = ...,
        box_unit: "Optional[Literal[PureToken.M, PureToken.KM, PureToken.FT, PureToken.MI]]" = ...,
        order: "Optional[Literal[PureToken.ASC, PureToken.DESC]]" = ...,
        count: "Optional[int]" = ...,
        any_: "Optional[bool]" = ...,
        withcoord: "Optional[bool]" = ...,
        withdist: "Optional[bool]" = ...,
        withhash: "Optional[bool]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def geosearchstore(
        self,
        destination: "KeyT",
        source: "KeyT",
        member: "Optional[ValueT]" = ...,
        longitude: "Optional[Union[int, float]]" = ...,
        latitude: "Optional[Union[int, float]]" = ...,
        radius: "Optional[Union[int, float]]" = ...,
        circle_unit: "Optional[Literal[PureToken.M, PureToken.KM, PureToken.FT, PureToken.MI]]" = ...,
        width: "Optional[Union[int, float]]" = ...,
        height: "Optional[Union[int, float]]" = ...,
        box_unit: "Optional[Literal[PureToken.M, PureToken.KM, PureToken.FT, PureToken.MI]]" = ...,
        order: "Optional[Literal[PureToken.ASC, PureToken.DESC]]" = ...,
        count: "Optional[int]" = ...,
        any_: "Optional[bool]" = ...,
        storedist: "Optional[bool]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def xack(
        self, key: "KeyT", group: "StringT", identifiers: "Parameters[ValueT]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def xadd(
        self,
        key: "KeyT",
        field_values: "Dict[StringT, ValueT]",
        identifier: "Optional[ValueT]" = ...,
        nomkstream: "Optional[bool]" = ...,
        trim_strategy: "Optional[Literal[PureToken.MAXLEN, PureToken.MINID]]" = ...,
        threshold: "Optional[int]" = ...,
        trim_operator: "Optional[Literal[PureToken.EQUAL, PureToken.APPROXIMATELY]]" = ...,
        limit: "Optional[int]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def xautoclaim(
        self,
        key: "KeyT",
        group: "StringT",
        consumer: "StringT",
        min_idle_time: "Union[int, datetime.timedelta]",
        start: "ValueT",
        count: "Optional[int]" = ...,
        justid: "Optional[bool]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def xclaim(
        self,
        key: "KeyT",
        group: "StringT",
        consumer: "StringT",
        min_idle_time: "Union[int, datetime.timedelta]",
        identifiers: "Parameters[ValueT]",
        idle: "Optional[Union[int, datetime.timedelta]]" = ...,
        time: "Optional[Union[int, datetime.datetime]]" = ...,
        retrycount: "Optional[int]" = ...,
        force: "Optional[bool]" = ...,
        justid: "Optional[bool]" = ...,
        lastid: "Optional[ValueT]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def xdel(
        self, key: "KeyT", identifiers: "Parameters[ValueT]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def xgroup_create(
        self,
        key: "KeyT",
        groupname: "StringT",
        identifier: "Optional[ValueT]" = ...,
        mkstream: "Optional[bool]" = ...,
        entriesread: "Optional[int]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def xgroup_createconsumer(
        self, key: "KeyT", groupname: "StringT", consumername: "StringT"
    ) -> ClusterPipeline[AnyStr]: ...
    async def xgroup_delconsumer(
        self, key: "KeyT", groupname: "StringT", consumername: "StringT"
    ) -> ClusterPipeline[AnyStr]: ...
    async def xgroup_destroy(
        self, key: "KeyT", groupname: "StringT"
    ) -> ClusterPipeline[AnyStr]: ...
    async def xgroup_setid(
        self,
        key: "KeyT",
        groupname: "StringT",
        identifier: "Optional[ValueT]" = ...,
        entriesread: "Optional[int]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def xinfo_consumers(
        self, key: "KeyT", groupname: "StringT"
    ) -> ClusterPipeline[AnyStr]: ...
    async def xinfo_groups(self, key: "KeyT") -> ClusterPipeline[AnyStr]: ...
    async def xinfo_stream(
        self, key: "KeyT", full: "Optional[bool]" = ..., count: "Optional[int]" = ...
    ) -> ClusterPipeline[AnyStr]: ...
    async def xlen(self, key: "KeyT") -> ClusterPipeline[AnyStr]: ...
    async def xpending(
        self,
        key: "KeyT",
        group: "StringT",
        start: "Optional[ValueT]" = ...,
        end: "Optional[ValueT]" = ...,
        count: "Optional[int]" = ...,
        idle: "Optional[int]" = ...,
        consumer: "Optional[StringT]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def xrange(
        self,
        key: "KeyT",
        start: "Optional[ValueT]" = ...,
        end: "Optional[ValueT]" = ...,
        count: "Optional[int]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def xread(
        self,
        streams: "Mapping[ValueT, ValueT]",
        count: "Optional[int]" = ...,
        block: "Optional[Union[int, datetime.timedelta]]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def xreadgroup(
        self,
        group: "StringT",
        consumer: "StringT",
        streams: "Mapping[ValueT, ValueT]",
        count: "Optional[int]" = ...,
        block: "Optional[Union[int, datetime.timedelta]]" = ...,
        noack: "Optional[bool]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def xrevrange(
        self,
        key: "KeyT",
        end: "Optional[ValueT]" = ...,
        start: "Optional[ValueT]" = ...,
        count: "Optional[int]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def xtrim(
        self,
        key: "KeyT",
        trim_strategy: "Literal[PureToken.MAXLEN, PureToken.MINID]",
        threshold: "int",
        trim_operator: "Optional[Literal[PureToken.EQUAL, PureToken.APPROXIMATELY]]" = ...,
        limit: "Optional[int]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def eval(
        self,
        script: "StringT",
        keys: "Optional[Parameters[KeyT]]" = ...,
        args: "Optional[Parameters[ValueT]]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def evalsha(
        self,
        sha1: "StringT",
        keys: "Optional[Parameters[KeyT]]" = ...,
        args: "Optional[Parameters[ValueT]]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def evalsha_ro(
        self,
        sha1: "StringT",
        keys: "Optional[Parameters[KeyT]]" = ...,
        args: "Optional[Parameters[ValueT]]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def eval_ro(
        self,
        script: "StringT",
        keys: "Optional[Parameters[KeyT]]" = ...,
        args: "Optional[Parameters[ValueT]]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def fcall(
        self,
        function: "StringT",
        keys: "Optional[Parameters[KeyT]]" = ...,
        args: "Optional[Parameters[ValueT]]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def fcall_ro(
        self,
        function: "StringT",
        keys: "Optional[Parameters[KeyT]]" = ...,
        args: "Optional[Parameters[ValueT]]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def function_delete(
        self, library_name: "StringT"
    ) -> ClusterPipeline[AnyStr]: ...
    async def function_dump(self) -> ClusterPipeline[AnyStr]: ...
    async def function_flush(
        self, async_: "Optional[Literal[PureToken.ASYNC, PureToken.SYNC]]" = ...
    ) -> ClusterPipeline[AnyStr]: ...
    async def function_kill(self) -> ClusterPipeline[AnyStr]: ...
    async def function_list(
        self, libraryname: "Optional[StringT]" = ..., withcode: "Optional[bool]" = ...
    ) -> ClusterPipeline[AnyStr]: ...
    async def function_load(
        self, function_code: "StringT", replace: "Optional[bool]" = ...
    ) -> ClusterPipeline[AnyStr]: ...
    async def function_restore(
        self,
        serialized_value: "bytes",
        policy: "Optional[Literal[PureToken.FLUSH, PureToken.APPEND, PureToken.REPLACE]]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def function_stats(self) -> ClusterPipeline[AnyStr]: ...
    async def script_debug(
        self, mode: "Literal[PureToken.NO, PureToken.SYNC, PureToken.YES]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def script_exists(
        self, sha1s: "Parameters[StringT]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def script_flush(
        self, sync_type: "Optional[Literal[PureToken.ASYNC, PureToken.SYNC]]" = ...
    ) -> ClusterPipeline[AnyStr]: ...
    async def script_kill(self) -> ClusterPipeline[AnyStr]: ...
    async def script_load(self, script: "StringT") -> ClusterPipeline[AnyStr]: ...
    async def publish(
        self, channel: "StringT", message: "ValueT"
    ) -> ClusterPipeline[AnyStr]: ...
    async def pubsub_channels(
        self, pattern: "Optional[StringT]" = ...
    ) -> ClusterPipeline[AnyStr]: ...
    async def pubsub_numpat(self) -> ClusterPipeline[AnyStr]: ...
    async def pubsub_numsub(self, *channels: "StringT") -> ClusterPipeline[AnyStr]: ...
    async def pubsub_shardchannels(
        self, pattern: "Optional[StringT]" = ...
    ) -> ClusterPipeline[AnyStr]: ...
    async def pubsub_shardnumsub(
        self, *channels: "StringT"
    ) -> ClusterPipeline[AnyStr]: ...
    async def spublish(
        self, channel: "StringT", message: "ValueT"
    ) -> ClusterPipeline[AnyStr]: ...
    async def acl_cat(
        self, categoryname: "Optional[StringT]" = ...
    ) -> ClusterPipeline[AnyStr]: ...
    async def acl_deluser(
        self, usernames: "Parameters[StringT]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def acl_dryrun(
        self, username: "StringT", command: "StringT", *args: "ValueT"
    ) -> ClusterPipeline[AnyStr]: ...
    async def acl_genpass(
        self, bits: "Optional[int]" = ...
    ) -> ClusterPipeline[AnyStr]: ...
    async def acl_getuser(self, username: "StringT") -> ClusterPipeline[AnyStr]: ...
    async def acl_list(self) -> ClusterPipeline[AnyStr]: ...
    async def acl_load(self) -> ClusterPipeline[AnyStr]: ...
    async def acl_log(
        self, count: "Optional[int]" = ..., reset: "Optional[bool]" = ...
    ) -> ClusterPipeline[AnyStr]: ...
    async def acl_save(self) -> ClusterPipeline[AnyStr]: ...
    async def acl_setuser(
        self, username: "StringT", *rules: "StringT"
    ) -> ClusterPipeline[AnyStr]: ...
    async def acl_users(self) -> ClusterPipeline[AnyStr]: ...
    async def acl_whoami(self) -> ClusterPipeline[AnyStr]: ...
    async def bgrewriteaof(self) -> ClusterPipeline[AnyStr]: ...
    async def bgsave(
        self, schedule: "Optional[bool]" = ...
    ) -> ClusterPipeline[AnyStr]: ...
    async def command(self) -> ClusterPipeline[AnyStr]: ...
    async def command_count(self) -> ClusterPipeline[AnyStr]: ...
    async def command_docs(
        self, *command_names: "StringT"
    ) -> ClusterPipeline[AnyStr]: ...
    async def command_getkeys(
        self, command: "StringT", arguments: "Parameters[ValueT]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def command_getkeysandflags(
        self, command: "StringT", arguments: "Parameters[ValueT]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def command_info(
        self, *command_names: "StringT"
    ) -> ClusterPipeline[AnyStr]: ...
    async def command_list(
        self,
        module: "Optional[StringT]" = ...,
        aclcat: "Optional[StringT]" = ...,
        pattern: "Optional[StringT]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def config_get(
        self, parameters: "Parameters[StringT]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def config_resetstat(self) -> ClusterPipeline[AnyStr]: ...
    async def config_rewrite(self) -> ClusterPipeline[AnyStr]: ...
    async def config_set(
        self, parameter_values: "Dict[StringT, ValueT]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def dbsize(self) -> ClusterPipeline[AnyStr]: ...
    async def failover(
        self,
        host: "Optional[StringT]" = ...,
        port: "Optional[int]" = ...,
        force: "Optional[bool]" = ...,
        abort: "Optional[bool]" = ...,
        timeout: "Optional[Union[int, datetime.timedelta]]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def flushall(
        self, async_: "Optional[Literal[PureToken.ASYNC, PureToken.SYNC]]" = ...
    ) -> ClusterPipeline[AnyStr]: ...
    async def flushdb(
        self, async_: "Optional[Literal[PureToken.ASYNC, PureToken.SYNC]]" = ...
    ) -> ClusterPipeline[AnyStr]: ...
    async def info(self, *sections: "StringT") -> ClusterPipeline[AnyStr]: ...
    async def lastsave(self) -> ClusterPipeline[AnyStr]: ...
    async def latency_doctor(self) -> ClusterPipeline[AnyStr]: ...
    async def latency_graph(self, event: "StringT") -> ClusterPipeline[AnyStr]: ...
    async def latency_histogram(
        self, *commands: "StringT"
    ) -> ClusterPipeline[AnyStr]: ...
    async def latency_history(self, event: "StringT") -> ClusterPipeline[AnyStr]: ...
    async def latency_latest(self) -> ClusterPipeline[AnyStr]: ...
    async def latency_reset(self, *events: "StringT") -> ClusterPipeline[AnyStr]: ...
    async def lolwut(
        self, version: "Optional[int]" = ...
    ) -> ClusterPipeline[AnyStr]: ...
    async def memory_doctor(self) -> ClusterPipeline[AnyStr]: ...
    async def memory_malloc_stats(self) -> ClusterPipeline[AnyStr]: ...
    async def memory_purge(self) -> ClusterPipeline[AnyStr]: ...
    async def memory_stats(self) -> ClusterPipeline[AnyStr]: ...
    async def memory_usage(
        self, key: "KeyT", samples: "Optional[int]" = ...
    ) -> ClusterPipeline[AnyStr]: ...
    async def module_list(self) -> ClusterPipeline[AnyStr]: ...
    async def module_load(
        self, path: "StringT", *args: "Union[str, bytes, int, float]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def module_loadex(
        self,
        path: "StringT",
        configs: "Optional[Dict[StringT, ValueT]]" = ...,
        args: "Optional[Parameters[ValueT]]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def module_unload(self, name: "StringT") -> ClusterPipeline[AnyStr]: ...
    async def replicaof(
        self, host: "Optional[StringT]" = ..., port: "Optional[int]" = ...
    ) -> ClusterPipeline[AnyStr]: ...
    async def role(self) -> ClusterPipeline[AnyStr]: ...
    async def save(self) -> ClusterPipeline[AnyStr]: ...
    async def shutdown(
        self,
        nosave_save: "Optional[Literal[PureToken.NOSAVE, PureToken.SAVE]]" = ...,
        now: "Optional[bool]" = ...,
        force: "Optional[bool]" = ...,
        abort: "Optional[bool]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def slaveof(
        self, host: "Optional[StringT]" = ..., port: "Optional[int]" = ...
    ) -> ClusterPipeline[AnyStr]: ...
    async def slowlog_get(
        self, count: "Optional[int]" = ...
    ) -> ClusterPipeline[AnyStr]: ...
    async def slowlog_len(self) -> ClusterPipeline[AnyStr]: ...
    async def slowlog_reset(self) -> ClusterPipeline[AnyStr]: ...
    async def swapdb(self, index1: "int", index2: "int") -> ClusterPipeline[AnyStr]: ...
    async def time(self) -> ClusterPipeline[AnyStr]: ...
    async def auth(
        self, password: "StringT", username: "Optional[StringT]" = ...
    ) -> ClusterPipeline[AnyStr]: ...
    async def client_caching(
        self, mode: "Literal[PureToken.NO, PureToken.YES]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def client_getname(self) -> ClusterPipeline[AnyStr]: ...
    async def client_getredir(self) -> ClusterPipeline[AnyStr]: ...
    async def client_id(self) -> ClusterPipeline[AnyStr]: ...
    async def client_info(self) -> ClusterPipeline[AnyStr]: ...
    async def client_kill(
        self,
        ip_port: "Optional[StringT]" = ...,
        identifier: "Optional[int]" = ...,
        type_: "Optional[Literal[PureToken.NORMAL, PureToken.MASTER, PureToken.SLAVE, PureToken.REPLICA, PureToken.PUBSUB]]" = ...,
        user: "Optional[StringT]" = ...,
        addr: "Optional[StringT]" = ...,
        laddr: "Optional[StringT]" = ...,
        skipme: "Optional[bool]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def client_list(
        self,
        type_: "Optional[Literal[PureToken.MASTER, PureToken.NORMAL, PureToken.PUBSUB, PureToken.REPLICA]]" = ...,
        identifiers: "Optional[Parameters[int]]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def client_no_evict(
        self, enabled: "Literal[PureToken.ON, PureToken.OFF]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def client_no_touch(
        self, enabled: "Literal[PureToken.OFF, PureToken.ON]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def client_pause(
        self,
        timeout: "int",
        mode: "Optional[Literal[PureToken.WRITE, PureToken.ALL]]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def client_reply(
        self, mode: "Literal[PureToken.OFF, PureToken.ON, PureToken.SKIP]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def client_setinfo(
        self, lib_name: "Optional[StringT]" = ..., lib_ver: "Optional[StringT]" = ...
    ) -> ClusterPipeline[AnyStr]: ...
    async def client_setname(
        self, connection_name: "StringT"
    ) -> ClusterPipeline[AnyStr]: ...
    async def client_tracking(
        self,
        status: "Literal[PureToken.OFF, PureToken.ON]",
        *prefixes: "StringT",
        redirect: "Optional[int]" = ...,
        bcast: "Optional[bool]" = ...,
        optin: "Optional[bool]" = ...,
        optout: "Optional[bool]" = ...,
        noloop: "Optional[bool]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def client_trackinginfo(self) -> ClusterPipeline[AnyStr]: ...
    async def client_unblock(
        self,
        client_id: "int",
        timeout_error: "Optional[Literal[PureToken.TIMEOUT, PureToken.ERROR]]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def client_unpause(self) -> ClusterPipeline[AnyStr]: ...
    async def echo(self, message: "StringT") -> ClusterPipeline[AnyStr]: ...
    async def hello(
        self,
        protover: "Optional[int]" = ...,
        username: "Optional[StringT]" = ...,
        password: "Optional[StringT]" = ...,
        setname: "Optional[StringT]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def ping(
        self, message: "Optional[StringT]" = ...
    ) -> ClusterPipeline[AnyStr]: ...
    async def quit(self) -> ClusterPipeline[AnyStr]: ...
    async def reset(self) -> ClusterPipeline[AnyStr]: ...
    async def select(self, index: "int") -> ClusterPipeline[AnyStr]: ...
    async def asking(self) -> ClusterPipeline[AnyStr]: ...
    async def cluster_addslots(
        self, slots: "Parameters[int]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def cluster_addslotsrange(
        self, slots: "Parameters[Tuple[int, int]]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def cluster_bumpepoch(self) -> ClusterPipeline[AnyStr]: ...
    async def cluster_count_failure_reports(
        self, node_id: "StringT"
    ) -> ClusterPipeline[AnyStr]: ...
    async def cluster_countkeysinslot(self, slot: "int") -> ClusterPipeline[AnyStr]: ...
    async def cluster_delslots(
        self, slots: "Parameters[int]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def cluster_delslotsrange(
        self, slots: "Parameters[Tuple[int, int]]"
    ) -> ClusterPipeline[AnyStr]: ...
    async def cluster_failover(
        self, options: "Optional[Literal[PureToken.FORCE, PureToken.TAKEOVER]]" = ...
    ) -> ClusterPipeline[AnyStr]: ...
    async def cluster_flushslots(self) -> ClusterPipeline[AnyStr]: ...
    async def cluster_forget(self, node_id: "StringT") -> ClusterPipeline[AnyStr]: ...
    async def cluster_getkeysinslot(
        self, slot: "int", count: "int"
    ) -> ClusterPipeline[AnyStr]: ...
    async def cluster_info(self) -> ClusterPipeline[AnyStr]: ...
    async def cluster_keyslot(self, key: "KeyT") -> ClusterPipeline[AnyStr]: ...
    async def cluster_links(self) -> ClusterPipeline[AnyStr]: ...
    async def cluster_meet(
        self, ip: "StringT", port: "int", cluster_bus_port: "Optional[int]" = ...
    ) -> ClusterPipeline[AnyStr]: ...
    async def cluster_myid(self) -> ClusterPipeline[AnyStr]: ...
    async def cluster_nodes(self) -> ClusterPipeline[AnyStr]: ...
    async def cluster_replicas(self, node_id: "StringT") -> ClusterPipeline[AnyStr]: ...
    async def cluster_replicate(
        self, node_id: "StringT"
    ) -> ClusterPipeline[AnyStr]: ...
    async def cluster_reset(
        self, hard_soft: "Optional[Literal[PureToken.HARD, PureToken.SOFT]]" = ...
    ) -> ClusterPipeline[AnyStr]: ...
    async def cluster_saveconfig(self) -> ClusterPipeline[AnyStr]: ...
    async def cluster_set_config_epoch(
        self, config_epoch: "int"
    ) -> ClusterPipeline[AnyStr]: ...
    async def cluster_setslot(
        self,
        slot: "int",
        importing: "Optional[StringT]" = ...,
        migrating: "Optional[StringT]" = ...,
        node: "Optional[StringT]" = ...,
        stable: "Optional[bool]" = ...,
    ) -> ClusterPipeline[AnyStr]: ...
    async def cluster_shards(self) -> ClusterPipeline[AnyStr]: ...
    async def cluster_slaves(self, node_id: "StringT") -> ClusterPipeline[AnyStr]: ...
    async def cluster_slots(self) -> ClusterPipeline[AnyStr]: ...
    async def readonly(self) -> ClusterPipeline[AnyStr]: ...
    async def readwrite(self) -> ClusterPipeline[AnyStr]: ...
    async def watch(self, *keys: "KeyT") -> bool: ...
    async def unwatch(self) -> bool: ...
    def multi(self) -> None: ...
    async def execute(self, raise_on_error: "bool" = ...) -> Tuple[object, ...]: ...
    async def __aenter__(self) -> "ClusterPipeline[AnyStr]": ...
    async def __aexit__(
        self,
        exc_type: Optional[Type[BaseException]],
        exc_value: Optional[BaseException],
        traceback: Optional[TracebackType],
    ) -> None: ...
