import * as cdk from '@aws-cdk/core';
import { Construct } from 'constructs';
import { ICluster } from './cluster';
import { DatabaseOptions } from './database-options';
import { IUser } from './user';
import { Construct as CoreConstruct } from '@aws-cdk/core';
/**
 * (experimental) An action that a Redshift user can be granted privilege to perform on a table.
 *
 * @experimental
 */
export declare enum TableAction {
    /**
     * (experimental) Grants privilege to select data from a table or view using a SELECT statement.
     *
     * @experimental
     */
    SELECT = 0,
    /**
     * (experimental) Grants privilege to load data into a table using an INSERT statement or a COPY statement.
     *
     * @experimental
     */
    INSERT = 1,
    /**
     * (experimental) Grants privilege to update a table column using an UPDATE statement.
     *
     * @experimental
     */
    UPDATE = 2,
    /**
     * (experimental) Grants privilege to delete a data row from a table.
     *
     * @experimental
     */
    DELETE = 3,
    /**
     * (experimental) Grants privilege to drop a table.
     *
     * @experimental
     */
    DROP = 4,
    /**
     * (experimental) Grants privilege to create a foreign key constraint.
     *
     * You need to grant this privilege on both the referenced table and the referencing table; otherwise, the user can't create the constraint.
     *
     * @experimental
     */
    REFERENCES = 5,
    /**
     * (experimental) Grants all available privileges at once to the specified user or user group.
     *
     * @experimental
     */
    ALL = 6
}
/**
 * (experimental) A column in a Redshift table.
 *
 * @experimental
 */
export interface Column {
    /**
     * (experimental) The name of the column.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) The data type of the column.
     *
     * @experimental
     */
    readonly dataType: string;
    /**
     * (experimental) Boolean value that indicates whether the column is to be configured as DISTKEY.
     *
     * @default - column is not DISTKEY
     * @experimental
     */
    readonly distKey?: boolean;
    /**
     * (experimental) Boolean value that indicates whether the column is to be configured as SORTKEY.
     *
     * @default - column is not a SORTKEY
     * @experimental
     */
    readonly sortKey?: boolean;
}
/**
 * (experimental) Properties for configuring a Redshift table.
 *
 * @experimental
 */
export interface TableProps extends DatabaseOptions {
    /**
     * (experimental) The name of the table.
     *
     * @default - a name is generated
     * @experimental
     */
    readonly tableName?: string;
    /**
     * (experimental) The columns of the table.
     *
     * @experimental
     */
    readonly tableColumns: Column[];
    /**
     * (experimental) The distribution style of the table.
     *
     * @default TableDistStyle.AUTO
     * @experimental
     */
    readonly distStyle?: TableDistStyle;
    /**
     * (experimental) The sort style of the table.
     *
     * @default TableSortStyle.AUTO if no sort key is specified, TableSortStyle.COMPOUND if a sort key is specified
     * @experimental
     */
    readonly sortStyle?: TableSortStyle;
    /**
     * (experimental) The policy to apply when this resource is removed from the application.
     *
     * @default cdk.RemovalPolicy.Retain
     * @experimental
     */
    readonly removalPolicy?: cdk.RemovalPolicy;
}
/**
 * (experimental) Represents a table in a Redshift database.
 *
 * @experimental
 */
export interface ITable extends cdk.IConstruct {
    /**
     * (experimental) Name of the table.
     *
     * @experimental
     */
    readonly tableName: string;
    /**
     * (experimental) The columns of the table.
     *
     * @experimental
     */
    readonly tableColumns: Column[];
    /**
     * (experimental) The cluster where the table is located.
     *
     * @experimental
     */
    readonly cluster: ICluster;
    /**
     * (experimental) The name of the database where the table is located.
     *
     * @experimental
     */
    readonly databaseName: string;
    /**
     * (experimental) Grant a user privilege to access this table.
     *
     * @experimental
     */
    grant(user: IUser, ...actions: TableAction[]): void;
}
/**
 * (experimental) A full specification of a Redshift table that can be used to import it fluently into the CDK application.
 *
 * @experimental
 */
export interface TableAttributes {
    /**
     * (experimental) Name of the table.
     *
     * @experimental
     */
    readonly tableName: string;
    /**
     * (experimental) The columns of the table.
     *
     * @experimental
     */
    readonly tableColumns: Column[];
    /**
     * (experimental) The cluster where the table is located.
     *
     * @experimental
     */
    readonly cluster: ICluster;
    /**
     * (experimental) The name of the database where the table is located.
     *
     * @experimental
     */
    readonly databaseName: string;
}
declare abstract class TableBase extends CoreConstruct implements ITable {
    abstract readonly tableName: string;
    abstract readonly tableColumns: Column[];
    abstract readonly cluster: ICluster;
    abstract readonly databaseName: string;
    /**
     * (experimental) Grant a user privilege to access this table.
     *
     * @experimental
     */
    grant(user: IUser, ...actions: TableAction[]): void;
}
/**
 * (experimental) A table in a Redshift cluster.
 *
 * @experimental
 */
export declare class Table extends TableBase {
    /**
     * (experimental) Specify a Redshift table using a table name and schema that already exists.
     *
     * @experimental
     */
    static fromTableAttributes(scope: Construct, id: string, attrs: TableAttributes): ITable;
    /**
     * (experimental) Name of the table.
     *
     * @experimental
     */
    readonly tableName: string;
    /**
     * (experimental) The columns of the table.
     *
     * @experimental
     */
    readonly tableColumns: Column[];
    /**
     * (experimental) The cluster where the table is located.
     *
     * @experimental
     */
    readonly cluster: ICluster;
    /**
     * (experimental) The name of the database where the table is located.
     *
     * @experimental
     */
    readonly databaseName: string;
    private resource;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: TableProps);
    /**
     * (experimental) Apply the given removal policy to this resource.
     *
     * The Removal Policy controls what happens to this resource when it stops
     * being managed by CloudFormation, either because you've removed it from the
     * CDK application or because you've made a change that requires the resource
     * to be replaced.
     *
     * The resource can be destroyed (`RemovalPolicy.DESTROY`), or left in your AWS
     * account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).
     *
     * This resource is retained by default.
     *
     * @experimental
     */
    applyRemovalPolicy(policy: cdk.RemovalPolicy): void;
    private validateDistKeyColumns;
    private validateDistStyle;
    private validateSortStyle;
    private getDefaultSortStyle;
}
/**
 * (experimental) The data distribution style of a table.
 *
 * @experimental
 */
export declare enum TableDistStyle {
    /**
     * (experimental) Amazon Redshift assigns an optimal distribution style based on the table data.
     *
     * @experimental
     */
    AUTO = "AUTO",
    /**
     * (experimental) The data in the table is spread evenly across the nodes in a cluster in a round-robin distribution.
     *
     * @experimental
     */
    EVEN = "EVEN",
    /**
     * (experimental) The data is distributed by the values in the DISTKEY column.
     *
     * @experimental
     */
    KEY = "KEY",
    /**
     * (experimental) A copy of the entire table is distributed to every node.
     *
     * @experimental
     */
    ALL = "ALL"
}
/**
 * (experimental) The sort style of a table.
 *
 * @experimental
 */
export declare enum TableSortStyle {
    /**
     * (experimental) Amazon Redshift assigns an optimal sort key based on the table data.
     *
     * @experimental
     */
    AUTO = "AUTO",
    /**
     * (experimental) Specifies that the data is sorted using a compound key made up of all of the listed columns, in the order they are listed.
     *
     * @experimental
     */
    COMPOUND = "COMPOUND",
    /**
     * (experimental) Specifies that the data is sorted using an interleaved sort key.
     *
     * @experimental
     */
    INTERLEAVED = "INTERLEAVED"
}
export {};
