import sys
import yaml

CONFIG_FILE = 'spectre.yml'

def load(spectre_path = None):
    return from_file(spectre_path)

def from_file(path):
    if not path:
        path = Config.spectre_dir
    try:
        with open(f'{path}/{CONFIG_FILE}', 'r') as config_file:
            config_dict = yaml.full_load(config_file.read())
            output = from_dict(config_dict)
            output.spectre_dir = path
            return output
    except Exception as e:
        sys.stderr.write('Could not load config file, using default config\n')
        return Config()

def from_dict(cfg):
    output = Config()
    for key, val in cfg.items():
        setattr(output, key, val)
    return output

class Config(object):
    namespace = 'com.foo.bar'
    name = 'UnnamedService'
    base_url = 'sinch.com'
    description = 'Service specification auto-generated by Spectre. User forgot the config :('
    spectre_dir = 'spectre'
    out_file = ''
    generator_options = {}
    methods = [ 'list', 'get', 'create', 'update', 'delete', ]
    debug = False