# Generated by Django 2.2.24 on 2021-07-12 10:50

from django.db import migrations, models

from aimmo.models import generate_game_auth_token
from aimmo.game_manager import GameManager


class Migration(migrations.Migration):

    dependencies = [
        ("aimmo", "0024_unique_class_per_game"),
    ]

    def generate_auth_token_for_games(apps, schema_editor):
        Game = apps.get_model("aimmo", "Game")
        for game in Game.objects.all():
            game.auth_token = generate_game_auth_token()
            game.save()
            game_manager = GameManager()
            game_manager.game_secret_manager.create_game_secret(game_id=game.id, game_name=game.name, token=game.auth_token)

    def clear_auth_token_for_games(apps, schema_editor):
        Game = apps.get_model("aimmo", "Game")
        for game in Game.objects.all():
            game.auth_token = ""
            game.save()
            game_manager = GameManager()
            game_manager.game_secret_manager.delete_game_secret(game_id=game.id)

    operations = [
        migrations.AlterField(
            model_name="game",
            name="auth_token",
            field=models.CharField(max_length=48),
        ),
        migrations.RunPython(
            generate_auth_token_for_games, reverse_code=clear_auth_token_for_games
        ),
    ]
