# -*- coding: utf-8 -*-
"""CUDU_20250224_00.ipynb

Automatically generated by Colab.

Original file is located at
    https://colab.research.google.com/drive/1L56UkZr80htFW8LwCUcbwafrAEv59yjo

# CudaUtility
 Cudaサポートユーティリティ


```
2025/02/24 0.1.0 完成
```

# CudaUtility

## 1. GDrive接続
"""

from google.colab import drive
drive.mount('/content/drive')

"""## 2. モジュール定義"""

# @title a. CudaUtility 定義
class CudaUtility:
    def __init__(self):
        pass

    def check_status( self ):
        print( "1️⃣ CUDA関連パッケージインストール状況" )
        get_ipython().system("dpkg -l | grep cuda")
        get_ipython().system("dpkg -l | grep libcudnn")

        print( "2️⃣ CUDAファイル残存状況確認" )
        get_ipython().system("ls -l /usr/local | grep cuda")
        get_ipython().system("ls -l /usr/lib | grep cuda")
        get_ipython().system("ls -l /usr/lib64 | grep cuda")

        print( "3️⃣ 環境変数の影響を確認" )
        get_ipython().system("echo $PATH")
        get_ipython().system("echo $LD_LIBRARY_PATH")

    # 旧称 get_cuda_version_symbol
    def version_symbol(self, cuda_version: str) -> str:
        """
        CUDAのバージョン番号 (例: "11.8", "12.4") を
        CUDAのシンボル (例: "CU118", "CU124") に変換する。

        :param cuda_version: CUDAのバージョン番号 (例: "11.8", "12.4")
        :return: 変換されたシンボル (例: "CU118", "CU124")
        """
        try:
            # バージョン番号を小数点で分割
            major, minor = cuda_version.split('.')
            # シンボル形式に変換
            return f"CU{major}{minor}"
        except ValueError:
            raise ValueError(f"Invalid CUDA version format: {cuda_version}")

"""## 3. 実行"""

# @title a. 実行
if __name__ == "__main__":
    cudautility = CudaUtility()
    cudautility.check_status()
    print(cudautility.version_symbol("11.8"))