"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetricFilter = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("@aws-cdk/aws-cloudwatch");
const core_1 = require("@aws-cdk/core");
const logs_generated_1 = require("./logs.generated");
/**
 * A filter that extracts information from CloudWatch Logs and emits to CloudWatch Metrics.
 *
 * @stability stable
 */
class MetricFilter extends core_1.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_logs_MetricFilterProps(props);
        this.metricName = props.metricName;
        this.metricNamespace = props.metricNamespace;
        // It looks odd to map this object to a singleton list, but that's how
        // we're supposed to do it according to the docs.
        //
        // > Currently, you can specify only one metric transformation for
        // > each metric filter. If you want to specify multiple metric
        // > transformations, you must specify multiple metric filters.
        //
        // https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-metricfilter.html
        new logs_generated_1.CfnMetricFilter(this, 'Resource', {
            logGroupName: props.logGroup.logGroupName,
            filterPattern: props.filterPattern.logPatternString,
            metricTransformations: [{
                    metricNamespace: props.metricNamespace,
                    metricName: props.metricName,
                    metricValue: (_b = props.metricValue) !== null && _b !== void 0 ? _b : '1',
                    defaultValue: props.defaultValue,
                }],
        });
    }
    /**
     * Return the given named metric for this Metric Filter.
     *
     * @default avg over 5 minutes
     * @stability stable
     */
    metric(props) {
        return new aws_cloudwatch_1.Metric({
            metricName: this.metricName,
            namespace: this.metricNamespace,
            statistic: 'avg',
            ...props,
        }).attachTo(this);
    }
}
exports.MetricFilter = MetricFilter;
_a = JSII_RTTI_SYMBOL_1;
MetricFilter[_a] = { fqn: "@aws-cdk/aws-logs.MetricFilter", version: "1.137.0" };
//# sourceMappingURL=data:application/json;base64,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