import { PolicyDocument, PolicyStatement } from '@aws-cdk/aws-iam';
import { Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
/**
 * Properties to define Cloudwatch log group resource policy.
 *
 * @stability stable
 */
export interface ResourcePolicyProps {
    /**
     * Name of the log group resource policy.
     *
     * @default - Uses a unique id based on the construct path
     * @stability stable
     */
    readonly resourcePolicyName?: string;
    /**
     * Initial statements to add to the resource policy.
     *
     * @default - No statements
     * @stability stable
     */
    readonly policyStatements?: PolicyStatement[];
}
/**
 * Creates Cloudwatch log group resource policies.
 *
 * @stability stable
 */
export declare class ResourcePolicy extends Resource {
    /**
     * The IAM policy document for this resource policy.
     *
     * @stability stable
     */
    readonly document: PolicyDocument;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: ResourcePolicyProps);
}
