# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

from aliyunsdkcore.request import RpcRequest
from aliyunsdkpolardbx.endpoint import endpoint_data

class UpdatePolarDBXInstanceNodeRequest(RpcRequest):

	def __init__(self):
		RpcRequest.__init__(self, 'polardbx', '2020-02-02', 'UpdatePolarDBXInstanceNode','polardbx')
		self.set_method('POST')

		if hasattr(self, "endpoint_map"):
			setattr(self, "endpoint_map", endpoint_data.getEndpointMap())
		if hasattr(self, "endpoint_regional"):
			setattr(self, "endpoint_regional", endpoint_data.getEndpointRegional())

	def get_AddDNSpec(self): # String
		return self.get_query_params().get('AddDNSpec')

	def set_AddDNSpec(self, AddDNSpec):  # String
		self.add_query_param('AddDNSpec', AddDNSpec)
	def get_StoragePoolName(self): # String
		return self.get_query_params().get('StoragePoolName')

	def set_StoragePoolName(self, StoragePoolName):  # String
		self.add_query_param('StoragePoolName', StoragePoolName)
	def get_DbInstanceNodeCount(self): # String
		return self.get_query_params().get('DbInstanceNodeCount')

	def set_DbInstanceNodeCount(self, DbInstanceNodeCount):  # String
		self.add_query_param('DbInstanceNodeCount', DbInstanceNodeCount)
	def get_CNNodeCount(self): # String
		return self.get_query_params().get('CNNodeCount')

	def set_CNNodeCount(self, CNNodeCount):  # String
		self.add_query_param('CNNodeCount', CNNodeCount)
	def get_DBInstanceName(self): # String
		return self.get_query_params().get('DBInstanceName')

	def set_DBInstanceName(self, DBInstanceName):  # String
		self.add_query_param('DBInstanceName', DBInstanceName)
	def get_ClientToken(self): # String
		return self.get_query_params().get('ClientToken')

	def set_ClientToken(self, ClientToken):  # String
		self.add_query_param('ClientToken', ClientToken)
	def get_DeleteDNIds(self): # String
		return self.get_query_params().get('DeleteDNIds')

	def set_DeleteDNIds(self, DeleteDNIds):  # String
		self.add_query_param('DeleteDNIds', DeleteDNIds)
	def get_DNNodeCount(self): # String
		return self.get_query_params().get('DNNodeCount')

	def set_DNNodeCount(self, DNNodeCount):  # String
		self.add_query_param('DNNodeCount', DNNodeCount)
