from .. import *
from .abstract_logs import *
from solders.pubkey import Pubkey #type: ignore
from spl.token.instructions import get_associated_token_address
from abstract_utilities import make_list,eatAll,is_number
from construct import Padding, Struct, Int64ul, Flag
import base64


PUMP_FUN_GLOBAL = Pubkey.from_string("4wTV1YmiEkRvAtNtsSGPtUrqRYQMe5SKy2uB4Jjaxnjf")
PUMP_FUN_FEE_RECIPIENT = Pubkey.from_string("CebN5WGQ4jvEPvsVU4EoHEpgzq1VV7AbicfhtW4xC9iM")
PUMP_FUN_SYSTEM_PROGRAM = Pubkey.from_string("11111111111111111111111111111111")
PUMP_FUN_TOKEN_PROGRAM = Pubkey.from_string("TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA")
PUMP_FUN_ASSOC_TOKEN_ACC_PROG = Pubkey.from_string("ATokenGPvbdGVxr1b2hvZbsiqW5xWH25efTNsLJA8knL")
PUMP_FUN_RENT = Pubkey.from_string("SysvarRent111111111111111111111111111111111")
PUMP_FUN_EVENT_AUTHORITY = Pubkey.from_string("Ce6TQqeHC9p8KetsN6JsjHK7UTZk7nasjjnr7XxXp9F1")
PUMP_FUN_PROGRAM = Pubkey.from_string("6EF8rrecthR5Dkzon8Nwu78hRvfCKubJ14M5uBEwF6P")

LAMPORTS_PER_SOL = 1_000_000_000
UNIT_PRICE =  1_000_000
UNIT_BUDGET =  100_000
def serialize_raw_instruction(instructions):
  inst_lines = []
  instructions = instructions.split('not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize')[1:-1]
  for inst_index,instruction in enumerate(instructions):
    instruction_js = {}
    addressNameSpl = instruction.split('#')
    if len(addressNameSpl)>2:
      addressName = addressNameSpl[1].split(' - ')
      if is_number(addressName[0]):
        instruction_js['instruction_number'] = addressName[0]
        if float(inst_index) - float(addressName[0]) <0:
          instruction_js['instruction_name'] = addressName[1].split(':')[0]
          token_spl = instruction.split('/token/')
          account_spl =  instruction.split('/account/')
          account_name = token_spl[1] if len(token_spl[0]) < len(account_spl[0]) else account_spl[1]
          addressAddressSpl = account_name.split('">')
          instruction_js['token_address'] = addressAddressSpl[0]
          instruction_js['token_name'] = addressAddressSpl[1].split('<')[0]
          inst_lines.append(instruction_js)
        else:
          return inst_lines
  return inst_lines
def createHtml():
  return """<div class="flex flex-col gap-3 items-stretch justify-start px-[15px] py-[10px] bg-neutral1 border border-border rounded-2xl mt-[10px]"><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Interact With</div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap w-full"><div class="not-italic font-normal text-[14px] leading-[24px] capitalize text-neutral5 break-words">Pump.fun</div><div class="not-italic font-normal text-neutral7 text-[14px] leading-[24px]">-</div><div class="break-spaces-address-link"><span class="whitespace-nowrap"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/6EF8rrecthR5Dkzon8Nwu78hRvfCKubJ14M5uBEwF6P">6EF8rrecthR5Dkzon8Nwu78hRvfCKubJ14M5uBEwF6P</a></span><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Input Accounts</div></div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="flex flex-col gap-2 items-stretch justify-start"><div class="flex flex-col gap-1 items-stretch justify-start"><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">#1 - Mint:</div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class="whitespace-nowrap"><span class="inline-flex align-middle mr-1"><div style="min-width: 16px; max-width: 16px;"><div style="min-width: 16px; max-width: 16px;"><div class="w-full aspect-square relative flex items-center justify-center flex-col"><img class="w-full h-full absolute top-0 left-0 flex items-center aspect-square z-2" alt="placeholder" src="data:image/svg+xml;base64,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"></div></div></div></span><span class="align-middle font-normal text-neutral7 text-[14px] leading-[24px] border border-dashed box-content break-all truncate border-transparent"><div class="inline" data-state="closed"><a class="text-link border-transparent" href="/token/AkAUSJg1v9xYT3HUxdALH7NsrC6owmwoZuP9MLw8fxTL">3CAT</a></div></span><span class="gap-2 align-middle ml-1"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#1890ff] text-white h-[20px] text-[10px] leading-[20px]">Writable</div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#c77aea] text-white h-[20px] text-[10px] leading-[20px]">Signer</div></div></div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">#2 - Mint Authority:</div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class=""><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/TSLvdd1pWpHVjahSpsvCXUbgwsL3JAcvokwaKt1eokM">Pump.fun Token Mint Authority</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div></div></div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">#3 - Bonding Curve:</div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class=""><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/9nhxvNxfSUaJddVco6oa6NodtsCscqCScp6UU1hZkfGm">Pump.fun (3CAT) Bonding Curve</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#1890ff] text-white h-[20px] text-[10px] leading-[20px]">Writable</div></div></div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">#4 - Associated Bonding Curve:</div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class=""><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/889XLp3qvVAHpTYQmhn6cBpYSppV8Gi8E2Rgp9RH2vRy">Pump.fun (3CAT) Vault</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#1890ff] text-white h-[20px] text-[10px] leading-[20px]">Writable</div></div></div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">#5 - Global:</div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="break-spaces-address-link"><span class=""><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/4wTV1YmiEkRvAtNtsSGPtUrqRYQMe5SKy2uB4Jjaxnjf">4wTV1YmiEkRvAtNtsSGPtUrqRYQMe5SKy2uB4Jjaxnjf</a></span><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div></div></div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">#6 - Mpl Token Metadata:</div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class=""><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/metaqbxxUerdq28cj1RbAWkYQm3ybzjb6a8bt518x1s">Metaplex Token Metadata</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#e4830c] text-white h-[20px] text-[10px] leading-[20px]">Program</div></div></div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">#7 - Metadata:</div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="break-spaces-address-link"><span class=""><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/CH41RxpjSXHqr1vfLTVYJMsfNs2fBCCWoAE13tPihXh7">CH41RxpjSXHqr1vfLTVYJMsfNs2fBCCWoAE13tPihXh7</a></span><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#1890ff] text-white h-[20px] text-[10px] leading-[20px]">Writable</div></div></div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">#8 - User:</div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="break-spaces-address-link"><span class=""><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/Fuy5MvbgzjSok1U8hH6mUY6WnLynzUextDxfEWMiTkn4">Fuy5MvbgzjSok1U8hH6mUY6WnLynzUextDxfEWMiTkn4</a></span><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#1890ff] text-white h-[20px] text-[10px] leading-[20px]">Writable</div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#c77aea] text-white h-[20px] text-[10px] leading-[20px]">Signer</div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#00c59a] text-white h-[20px] text-[10px] leading-[20px]">Fee Payer</div></div></div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">#9 - System Program:</div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class=""><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/11111111111111111111111111111111">System Program</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#e4830c] text-white h-[20px] text-[10px] leading-[20px]">Program</div></div></div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">#10 - Token Program:</div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class=""><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA">Token Program</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#e4830c] text-white h-[20px] text-[10px] leading-[20px]">Program</div></div></div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">#11 - Associated Token Program:</div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class=""><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/ATokenGPvbdGVxr1b2hvZbsiqW5xWH25efTNsLJA8knL">Associated Token Account Program</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#e4830c] text-white h-[20px] text-[10px] leading-[20px]">Program</div></div></div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">#12 - Rent:</div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class=""><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/SysvarRent111111111111111111111111111111111">Rent Program</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div></div></div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">#13 - Event Authority:</div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="break-spaces-address-link"><span class=""><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/Ce6TQqeHC9p8KetsN6JsjHK7UTZk7nasjjnr7XxXp9F1">Ce6TQqeHC9p8KetsN6JsjHK7UTZk7nasjjnr7XxXp9F1</a></span><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div></div></div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">#14 - Program:</div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class=""><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/6EF8rrecthR5Dkzon8Nwu78hRvfCKubJ14M5uBEwF6P">Pump.fun</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#e4830c] text-white h-[20px] text-[10px] leading-[20px]">Program</div></div></div></div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Instruction Data</div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="rounded-lg break-all max-h-[550px] overflow-y-auto"><div class="react-json-view" style="font-family: monospace; cursor: default; background-color: rgb(255, 255, 255); position: relative; white-space: pre-wrap; border: 1px solid rgb(234, 234, 234); border-radius: 8px; padding: 12px;"><div class="pretty-json-container object-container"><div class="object-content"><div class="object-key-val"><span><span style="display: inline-block; cursor: pointer;"><div class="icon-container" style="display: inline-block; width: 17px;"><span class="expanded-icon"><svg style="vertical-align: top; color: rgb(88, 110, 117); height: 1em; width: 1em; padding-left: 2px;" viewBox="0 0 15 15" fill="currentColor"><path d="M0 5l6 6 6-6z"></path></svg></span></div><span></span><span style="display: inline-block; cursor: pointer; font-weight: bold; color: rgb(0, 43, 54);">{</span></span><div style="display: inline-block; padding: 0px 0px 0px 10px;" class="object-meta-data"><span class="object-size" style="color: rgba(0, 0, 0, 0.3); border-radius: 3px; font-style: italic; margin: 0px 6px 0px 0px; cursor: default;">3 items</span><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div></span><div class="pushed-content object-container"><div class="object-content" style="margin-left: 6px;"><div class="object-key-val" style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);"><span><span style="display: inline-block; cursor: pointer;"><div class="icon-container" style="display: inline-block; width: 17px;"><span class="expanded-icon"><svg style="vertical-align: top; color: rgb(88, 110, 117); height: 1em; width: 1em; padding-left: 2px;" viewBox="0 0 15 15" fill="currentColor"><path d="M0 5l6 6 6-6z"></path></svg></span></div><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;"><span class="object-key"><span>name</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><span style="display: inline-block; cursor: pointer; font-weight: bold; color: rgb(0, 43, 54);">{</span></span><div style="display: inline-block; padding: 0px 0px 0px 10px;" class="object-meta-data"><span class="object-size" style="color: rgba(0, 0, 0, 0.3); border-radius: 3px; font-style: italic; margin: 0px 6px 0px 0px; cursor: default;">2 items</span><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div></span><div class="pushed-content object-container"><div class="object-content" style="margin-left: 6px;"><div style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);" class="variable-row"><span><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;" class="object-key"><span style="display: inline-block;">type</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><div class="variable-value" style="display: inline-block; padding-right: 6px; position: relative; cursor: default;"><div style="display: inline-block; color: rgb(203, 75, 22);"><span class="string-value" style="cursor: default;">"string"</span></div></div><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div><div style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);" class="variable-row"><span><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;" class="object-key"><span style="display: inline-block;">data</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><div class="variable-value" style="display: inline-block; padding-right: 6px; position: relative; cursor: default;"><div style="display: inline-block; color: rgb(203, 75, 22);"><span class="string-value" style="cursor: default;">"3D CAT"</span></div></div><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div></div></div><span class="brace-row"><span style="display: inline-block; cursor: pointer; font-weight: bold; color: rgb(0, 43, 54); padding-left: 3px;">}</span></span></div><div class="object-key-val" style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);"><span><span style="display: inline-block; cursor: pointer;"><div class="icon-container" style="display: inline-block; width: 17px;"><span class="expanded-icon"><svg style="vertical-align: top; color: rgb(88, 110, 117); height: 1em; width: 1em; padding-left: 2px;" viewBox="0 0 15 15" fill="currentColor"><path d="M0 5l6 6 6-6z"></path></svg></span></div><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;"><span class="object-key"><span>symbol</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><span style="display: inline-block; cursor: pointer; font-weight: bold; color: rgb(0, 43, 54);">{</span></span><div style="display: inline-block; padding: 0px 0px 0px 10px;" class="object-meta-data"><span class="object-size" style="color: rgba(0, 0, 0, 0.3); border-radius: 3px; font-style: italic; margin: 0px 6px 0px 0px; cursor: default;">2 items</span><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div></span><div class="pushed-content object-container"><div class="object-content" style="margin-left: 6px;"><div style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);" class="variable-row"><span><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;" class="object-key"><span style="display: inline-block;">type</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><div class="variable-value" style="display: inline-block; padding-right: 6px; position: relative; cursor: default;"><div style="display: inline-block; color: rgb(203, 75, 22);"><span class="string-value" style="cursor: default;">"string"</span></div></div><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div><div style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);" class="variable-row"><span><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;" class="object-key"><span style="display: inline-block;">data</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><div class="variable-value" style="display: inline-block; padding-right: 6px; position: relative; cursor: default;"><div style="display: inline-block; color: rgb(203, 75, 22);"><span class="string-value" style="cursor: default;">"3CAT"</span></div></div><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div></div></div><span class="brace-row"><span style="display: inline-block; cursor: pointer; font-weight: bold; color: rgb(0, 43, 54); padding-left: 3px;">}</span></span></div><div class="object-key-val" style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);"><span><span style="display: inline-block; cursor: pointer;"><div class="icon-container" style="display: inline-block; width: 17px;"><span class="expanded-icon"><svg style="vertical-align: top; color: rgb(88, 110, 117); height: 1em; width: 1em; padding-left: 2px;" viewBox="0 0 15 15" fill="currentColor"><path d="M0 5l6 6 6-6z"></path></svg></span></div><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;"><span class="object-key"><span>uri</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><span style="display: inline-block; cursor: pointer; font-weight: bold; color: rgb(0, 43, 54);">{</span></span><div style="display: inline-block; padding: 0px 0px 0px 10px;" class="object-meta-data"><span class="object-size" style="color: rgba(0, 0, 0, 0.3); border-radius: 3px; font-style: italic; margin: 0px 6px 0px 0px; cursor: default;">2 items</span><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div></span><div class="pushed-content object-container"><div class="object-content" style="margin-left: 6px;"><div style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);" class="variable-row"><span><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;" class="object-key"><span style="display: inline-block;">type</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><div class="variable-value" style="display: inline-block; padding-right: 6px; position: relative; cursor: default;"><div style="display: inline-block; color: rgb(203, 75, 22);"><span class="string-value" style="cursor: default;">"string"</span></div></div><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div><div style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);" class="variable-row"><span><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;" class="object-key"><span style="display: inline-block;">data</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><div class="variable-value" style="display: inline-block; padding-right: 6px; position: relative; cursor: default;"><div style="display: inline-block; color: rgb(203, 75, 22);"><span class="string-value" style="cursor: default;">"https://ipfs.io/ipfs/QmZXtP75xUapRcr9BtAKhtLDkD6g4aSu6mvusry4AaKj4i"</span></div></div><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div></div></div><span class="brace-row"><span style="display: inline-block; cursor: pointer; font-weight: bold; color: rgb(0, 43, 54); padding-left: 3px;">}</span></span></div></div></div><span class="brace-row"><span style="display: inline-block; cursor: pointer; font-weight: bold; color: rgb(0, 43, 54); padding-left: 3px;">}</span></span></div></div></div></div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Inner Instructions</div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="flex flex-col gap-4 items-stretch justify-start"><div><div class="flex flex-col gap-3 items-stretch justify-start px-[15px] py-[10px] bg-neutral0 rounded-lg mt-[10px]"><div><div class="flex gap-1 flex-row items-center justify-start flex-wrap" id="ins-action-3-0"><div class="flex gap-1 flex-row items-stretch justify-between flex-wrap w-full"><div class="not-italic text-neutral7 text-[14px] leading-[24px] capitalize font-bold">#4.1 - System Program: createAccount </div><button type="button" aria-pressed="false" data-state="off" class="inline-flex items-center justify-center rounded-md font-medium ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 data-[state=on]:bg-neutral4 data-[state=on]:text-white border border-neutral4 hover:bg-accent hover:text-accent-foreground h-7 py-1 text-[12px] leading-3 px-2 gap-1 bg-blue"><svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-code"><polyline points="16 18 22 12 16 6"></polyline><polyline points="8 6 2 12 8 18"></polyline></svg>Raw</button></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Interact With</div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap w-full"><div class="not-italic font-normal text-[14px] leading-[24px] capitalize text-neutral5 break-words">System Program</div><div class="not-italic font-normal text-neutral7 text-[14px] leading-[24px]">-</div><div class="break-spaces-address-link"><span class="whitespace-nowrap"><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/11111111111111111111111111111111">11111111111111111111111111111111</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Instruction Data</div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="flex flex-col gap-2 items-stretch justify-start"><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">New Account:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class="whitespace-nowrap"><span class="inline-flex align-middle mr-1"><div style="min-width: 16px; max-width: 16px;"><div style="min-width: 16px; max-width: 16px;"><div class="w-full aspect-square relative flex items-center justify-center flex-col"><img class="w-full h-full absolute top-0 left-0 flex items-center aspect-square z-2" alt="placeholder" src="data:image/svg+xml;base64,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"></div></div></div></span><span class="align-middle font-normal text-neutral7 text-[14px] leading-[24px] border border-dashed box-content break-all truncate border-transparent"><div class="inline" data-state="closed"><a class="text-link border-transparent" href="/token/AkAUSJg1v9xYT3HUxdALH7NsrC6owmwoZuP9MLw8fxTL">3CAT</a></div></span><span class="gap-2 align-middle ml-1"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#1890ff] text-white h-[20px] text-[10px] leading-[20px]">Writable</div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#c77aea] text-white h-[20px] text-[10px] leading-[20px]">Signer</div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">Source:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="break-spaces-address-link"><span class=""><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/Fuy5MvbgzjSok1U8hH6mUY6WnLynzUextDxfEWMiTkn4">Fuy5MvbgzjSok1U8hH6mUY6WnLynzUextDxfEWMiTkn4</a></span><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#1890ff] text-white h-[20px] text-[10px] leading-[20px]">Writable</div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#c77aea] text-white h-[20px] text-[10px] leading-[20px]">Signer</div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#00c59a] text-white h-[20px] text-[10px] leading-[20px]">Fee Payer</div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">Transfer Amount:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="flex gap-1 flex-row items-center justify-start flex-wrap"><div class="not-italic text-neutral7 text-[14px] leading-[24px] font-bold">0.0014616</div><span class="whitespace-nowrap"><span class="inline-flex align-middle mr-1 border-transparent"><div style="min-width: 16px; max-width: 16px; height: 16px; position: relative;" class="flex align-middle"><img alt="image" referrerpolicy="no-referrer" loading="lazy" width="16" height="16" decoding="async" data-nimg="1" style="color: transparent; border-radius: 5px; position: absolute; height: 100%; object-fit: cover; left: 0px;" src="https://statics.solscan.io/cdn/imgs/s60?ref=68747470733a2f2f7261772e67697468756275736572636f6e74656e742e636f6d2f736f6c616e612d6c6162732f746f6b656e2d6c6973742f6d61696e2f6173736574732f6d61696e6e65742f536f31313131313131313131313131313131313131313131313131313131313131313131313131313131322f6c6f676f2e706e67"></div></span><span class="align-middle font-normal text-neutral7 text-[14px] leading-[24px] border border-dashed box-content break-all truncate border-transparent">SOL</span></span></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">Program Owner:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class=""><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA">Token Program</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#e4830c] text-white h-[20px] text-[10px] leading-[20px]">Program</div></div></div></div></div></div></div></div></div><div><div class="flex flex-col gap-3 items-stretch justify-start px-[15px] py-[10px] bg-neutral0 rounded-lg mt-[10px]"><div><div class="flex gap-1 flex-row items-center justify-start flex-wrap" id="ins-action-3-1"><div class="flex gap-1 flex-row items-stretch justify-between flex-wrap w-full"><div class="not-italic text-neutral7 text-[14px] leading-[24px] capitalize font-bold">#4.2 - Token Program: initializeMint2 </div><button type="button" aria-pressed="false" data-state="off" class="inline-flex items-center justify-center rounded-md font-medium ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 data-[state=on]:bg-neutral4 data-[state=on]:text-white border border-neutral4 hover:bg-accent hover:text-accent-foreground h-7 py-1 text-[12px] leading-3 px-2 gap-1 bg-blue"><svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-code"><polyline points="16 18 22 12 16 6"></polyline><polyline points="8 6 2 12 8 18"></polyline></svg>Raw</button></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Interact With</div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap w-full"><div class="not-italic font-normal text-[14px] leading-[24px] capitalize text-neutral5 break-words">Token Program</div><div class="not-italic font-normal text-neutral7 text-[14px] leading-[24px]">-</div><div class="break-spaces-address-link"><span class="whitespace-nowrap"><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA">TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Instruction Data</div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="flex flex-col gap-2 items-stretch justify-start"><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">Decimals:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-neutral7 text-[14px] leading-[24px]">6</div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">Mint:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class="whitespace-nowrap"><span class="inline-flex align-middle mr-1"><div style="min-width: 16px; max-width: 16px;"><div style="min-width: 16px; max-width: 16px;"><div class="w-full aspect-square relative flex items-center justify-center flex-col"><img class="w-full h-full absolute top-0 left-0 flex items-center aspect-square z-2" alt="placeholder" src="data:image/svg+xml;base64,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"></div></div></div></span><span class="align-middle font-normal text-neutral7 text-[14px] leading-[24px] border border-dashed box-content break-all truncate border-transparent"><div class="inline" data-state="closed"><a class="text-link border-transparent" href="/token/AkAUSJg1v9xYT3HUxdALH7NsrC6owmwoZuP9MLw8fxTL">3CAT</a></div></span><span class="gap-2 align-middle ml-1"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#1890ff] text-white h-[20px] text-[10px] leading-[20px]">Writable</div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#c77aea] text-white h-[20px] text-[10px] leading-[20px]">Signer</div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">Mint Authority:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class=""><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/TSLvdd1pWpHVjahSpsvCXUbgwsL3JAcvokwaKt1eokM">Pump.fun Token Mint Authority</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div></div></div></div></div></div></div></div></div><div><div class="flex flex-col gap-3 items-stretch justify-start px-[15px] py-[10px] bg-neutral0 rounded-lg mt-[10px]"><div><div class="flex gap-1 flex-row items-center justify-start flex-wrap" id="ins-action-3-2"><div class="flex gap-1 flex-row items-stretch justify-between flex-wrap w-full"><div class="not-italic text-neutral7 text-[14px] leading-[24px] capitalize font-bold">#4.3 - System Program: createAccount </div><button type="button" aria-pressed="false" data-state="off" class="inline-flex items-center justify-center rounded-md font-medium ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 data-[state=on]:bg-neutral4 data-[state=on]:text-white border border-neutral4 hover:bg-accent hover:text-accent-foreground h-7 py-1 text-[12px] leading-3 px-2 gap-1 bg-blue"><svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-code"><polyline points="16 18 22 12 16 6"></polyline><polyline points="8 6 2 12 8 18"></polyline></svg>Raw</button></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Interact With</div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap w-full"><div class="not-italic font-normal text-[14px] leading-[24px] capitalize text-neutral5 break-words">System Program</div><div class="not-italic font-normal text-neutral7 text-[14px] leading-[24px]">-</div><div class="break-spaces-address-link"><span class="whitespace-nowrap"><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/11111111111111111111111111111111">11111111111111111111111111111111</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Instruction Data</div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="flex flex-col gap-2 items-stretch justify-start"><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">New Account:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class=""><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/9nhxvNxfSUaJddVco6oa6NodtsCscqCScp6UU1hZkfGm">Pump.fun (3CAT) Bonding Curve</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#1890ff] text-white h-[20px] text-[10px] leading-[20px]">Writable</div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">Source:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="break-spaces-address-link"><span class=""><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/Fuy5MvbgzjSok1U8hH6mUY6WnLynzUextDxfEWMiTkn4">Fuy5MvbgzjSok1U8hH6mUY6WnLynzUextDxfEWMiTkn4</a></span><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#1890ff] text-white h-[20px] text-[10px] leading-[20px]">Writable</div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#c77aea] text-white h-[20px] text-[10px] leading-[20px]">Signer</div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#00c59a] text-white h-[20px] text-[10px] leading-[20px]">Fee Payer</div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">Transfer Amount:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="flex gap-1 flex-row items-center justify-start flex-wrap"><div class="not-italic text-neutral7 text-[14px] leading-[24px] font-bold">0.00123192</div><span class="whitespace-nowrap"><span class="inline-flex align-middle mr-1 border-transparent"><div style="min-width: 16px; max-width: 16px; height: 16px; position: relative;" class="flex align-middle"><img alt="image" referrerpolicy="no-referrer" loading="lazy" width="16" height="16" decoding="async" data-nimg="1" style="color: transparent; border-radius: 5px; position: absolute; height: 100%; object-fit: cover; left: 0px;" src="https://statics.solscan.io/cdn/imgs/s60?ref=68747470733a2f2f7261772e67697468756275736572636f6e74656e742e636f6d2f736f6c616e612d6c6162732f746f6b656e2d6c6973742f6d61696e2f6173736574732f6d61696e6e65742f536f31313131313131313131313131313131313131313131313131313131313131313131313131313131322f6c6f676f2e706e67"></div></span><span class="align-middle font-normal text-neutral7 text-[14px] leading-[24px] border border-dashed box-content break-all truncate border-transparent">SOL</span></span></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">Program Owner:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class=""><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/6EF8rrecthR5Dkzon8Nwu78hRvfCKubJ14M5uBEwF6P">Pump.fun</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#e4830c] text-white h-[20px] text-[10px] leading-[20px]">Program</div></div></div></div></div></div></div></div></div><div><div class="flex flex-col gap-3 items-stretch justify-start px-[15px] py-[10px] bg-neutral0 rounded-lg mt-[10px]"><div><div class="flex gap-1 flex-row items-center justify-start flex-wrap" id="ins-action-3-3"><div class="flex gap-1 flex-row items-stretch justify-between flex-wrap w-full"><div class="not-italic text-neutral7 text-[14px] leading-[24px] capitalize font-bold">#4.4 - Associated Token Account Program: create </div><button type="button" aria-pressed="false" data-state="off" class="inline-flex items-center justify-center rounded-md font-medium ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 data-[state=on]:bg-neutral4 data-[state=on]:text-white border border-neutral4 hover:bg-accent hover:text-accent-foreground h-7 py-1 text-[12px] leading-3 px-2 gap-1 bg-blue"><svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-code"><polyline points="16 18 22 12 16 6"></polyline><polyline points="8 6 2 12 8 18"></polyline></svg>Raw</button></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Interact With</div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap w-full"><div class="not-italic font-normal text-[14px] leading-[24px] capitalize text-neutral5 break-words">Associated Token Account Program</div><div class="not-italic font-normal text-neutral7 text-[14px] leading-[24px]">-</div><div class="break-spaces-address-link"><span class="whitespace-nowrap"><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/ATokenGPvbdGVxr1b2hvZbsiqW5xWH25efTNsLJA8knL">ATokenGPvbdGVxr1b2hvZbsiqW5xWH25efTNsLJA8knL</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Instruction Data</div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="flex flex-col gap-2 items-stretch justify-start"><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">Account:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class=""><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/889XLp3qvVAHpTYQmhn6cBpYSppV8Gi8E2Rgp9RH2vRy">Pump.fun (3CAT) Vault</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#1890ff] text-white h-[20px] text-[10px] leading-[20px]">Writable</div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">Mint:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class="whitespace-nowrap"><span class="inline-flex align-middle mr-1"><div style="min-width: 16px; max-width: 16px;"><div style="min-width: 16px; max-width: 16px;"><div class="w-full aspect-square relative flex items-center justify-center flex-col"><img class="w-full h-full absolute top-0 left-0 flex items-center aspect-square z-2" alt="placeholder" src="data:image/svg+xml;base64,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"></div></div></div></span><span class="align-middle font-normal text-neutral7 text-[14px] leading-[24px] border border-dashed box-content break-all truncate border-transparent"><div class="inline" data-state="closed"><a class="text-link border-transparent" href="/token/AkAUSJg1v9xYT3HUxdALH7NsrC6owmwoZuP9MLw8fxTL">3CAT</a></div></span><span class="gap-2 align-middle ml-1"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#1890ff] text-white h-[20px] text-[10px] leading-[20px]">Writable</div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#c77aea] text-white h-[20px] text-[10px] leading-[20px]">Signer</div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">Source:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="break-spaces-address-link"><span class=""><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/Fuy5MvbgzjSok1U8hH6mUY6WnLynzUextDxfEWMiTkn4">Fuy5MvbgzjSok1U8hH6mUY6WnLynzUextDxfEWMiTkn4</a></span><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#1890ff] text-white h-[20px] text-[10px] leading-[20px]">Writable</div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#c77aea] text-white h-[20px] text-[10px] leading-[20px]">Signer</div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#00c59a] text-white h-[20px] text-[10px] leading-[20px]">Fee Payer</div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">System Program:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class=""><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/11111111111111111111111111111111">System Program</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#e4830c] text-white h-[20px] text-[10px] leading-[20px]">Program</div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">Token Program:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class=""><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA">Token Program</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#e4830c] text-white h-[20px] text-[10px] leading-[20px]">Program</div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">Wallet:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class=""><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/9nhxvNxfSUaJddVco6oa6NodtsCscqCScp6UU1hZkfGm">Pump.fun (3CAT) Bonding Curve</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#1890ff] text-white h-[20px] text-[10px] leading-[20px]">Writable</div></div></div></div></div></div></div></div></div><div><div class="flex flex-col gap-3 items-stretch justify-start px-[15px] py-[10px] bg-neutral0 rounded-lg mt-[10px]"><div><div class="flex gap-1 flex-row items-center justify-start flex-wrap" id="ins-action-3-4"><div class="flex gap-1 flex-row items-stretch justify-between flex-wrap w-full"><div class="not-italic text-neutral7 text-[14px] leading-[24px] capitalize font-bold">#4.5 - Token Program: getAccountDataSize </div><button type="button" aria-pressed="false" data-state="off" class="inline-flex items-center justify-center rounded-md font-medium ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 data-[state=on]:bg-neutral4 data-[state=on]:text-white border border-neutral4 hover:bg-accent hover:text-accent-foreground h-7 py-1 text-[12px] leading-3 px-2 gap-1 bg-blue"><svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-code"><polyline points="16 18 22 12 16 6"></polyline><polyline points="8 6 2 12 8 18"></polyline></svg>Raw</button></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Interact With</div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap w-full"><div class="not-italic font-normal text-[14px] leading-[24px] capitalize text-neutral5 break-words">Token Program</div><div class="not-italic font-normal text-neutral7 text-[14px] leading-[24px]">-</div><div class="break-spaces-address-link"><span class="whitespace-nowrap"><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA">TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Instruction Data</div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="flex flex-col gap-2 items-stretch justify-start"><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">Extension Types:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="rounded-lg break-all max-h-[550px] overflow-y-auto"><div class="react-json-view" style="font-family: monospace; cursor: default; background-color: rgb(255, 255, 255); position: relative; white-space: pre-wrap; border: 1px solid rgb(234, 234, 234); border-radius: 8px; padding: 12px;"><div class="pretty-json-container object-container"><div class="object-content"><div class="object-key-val"><span><span style="display: inline-block; cursor: pointer;"><div class="icon-container" style="display: inline-block; width: 17px;"><span class="expanded-icon"><svg style="vertical-align: top; color: rgb(88, 110, 117); height: 1em; width: 1em; padding-left: 2px;" viewBox="0 0 15 15" fill="currentColor"><path d="M0 5l6 6 6-6z"></path></svg></span></div><span></span><span style="display: inline-block; cursor: pointer; font-weight: bold; color: rgb(0, 43, 54);">[</span></span><div style="display: inline-block; padding: 0px 0px 0px 10px;" class="object-meta-data"><span class="object-size" style="color: rgba(0, 0, 0, 0.3); border-radius: 3px; font-style: italic; margin: 0px 6px 0px 0px; cursor: default;">1 item</span><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div></span><div class="pushed-content object-container"><div class="object-content" style="margin-left: 6px;"><div style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);" class="variable-row"><span style="display: inline-block; color: rgb(203, 75, 22); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;">0<div style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</div></span><div class="variable-value" style="display: inline-block; padding-right: 6px; position: relative; cursor: default;"><div style="display: inline-block; color: rgb(203, 75, 22);"><span class="string-value" style="cursor: default;">"immutableOwner"</span></div></div><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div></div></div><span class="brace-row"><span style="display: inline-block; cursor: pointer; font-weight: bold; color: rgb(0, 43, 54); padding-left: 3px;">]</span></span></div></div></div></div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">Mint:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class="whitespace-nowrap"><span class="inline-flex align-middle mr-1"><div style="min-width: 16px; max-width: 16px;"><div style="min-width: 16px; max-width: 16px;"><div class="w-full aspect-square relative flex items-center justify-center flex-col"><img class="w-full h-full absolute top-0 left-0 flex items-center aspect-square z-2" alt="placeholder" src="data:image/svg+xml;base64,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"></div></div></div></span><span class="align-middle font-normal text-neutral7 text-[14px] leading-[24px] border border-dashed box-content break-all truncate border-transparent"><div class="inline" data-state="closed"><a class="text-link border-transparent" href="/token/AkAUSJg1v9xYT3HUxdALH7NsrC6owmwoZuP9MLw8fxTL">3CAT</a></div></span><span class="gap-2 align-middle ml-1"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#1890ff] text-white h-[20px] text-[10px] leading-[20px]">Writable</div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#c77aea] text-white h-[20px] text-[10px] leading-[20px]">Signer</div></div></div></div></div></div></div></div></div><div><div class="flex flex-col gap-3 items-stretch justify-start px-[15px] py-[10px] bg-neutral0 rounded-lg mt-[10px]"><div><div class="flex gap-1 flex-row items-center justify-start flex-wrap" id="ins-action-3-5"><div class="flex gap-1 flex-row items-stretch justify-between flex-wrap w-full"><div class="not-italic text-neutral7 text-[14px] leading-[24px] capitalize font-bold">#4.6 - System Program: createAccount </div><button type="button" aria-pressed="false" data-state="off" class="inline-flex items-center justify-center rounded-md font-medium ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 data-[state=on]:bg-neutral4 data-[state=on]:text-white border border-neutral4 hover:bg-accent hover:text-accent-foreground h-7 py-1 text-[12px] leading-3 px-2 gap-1 bg-blue"><svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-code"><polyline points="16 18 22 12 16 6"></polyline><polyline points="8 6 2 12 8 18"></polyline></svg>Raw</button></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Interact With</div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap w-full"><div class="not-italic font-normal text-[14px] leading-[24px] capitalize text-neutral5 break-words">System Program</div><div class="not-italic font-normal text-neutral7 text-[14px] leading-[24px]">-</div><div class="break-spaces-address-link"><span class="whitespace-nowrap"><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/11111111111111111111111111111111">11111111111111111111111111111111</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Instruction Data</div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="flex flex-col gap-2 items-stretch justify-start"><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">New Account:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class=""><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/889XLp3qvVAHpTYQmhn6cBpYSppV8Gi8E2Rgp9RH2vRy">Pump.fun (3CAT) Vault</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#1890ff] text-white h-[20px] text-[10px] leading-[20px]">Writable</div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">Source:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="break-spaces-address-link"><span class=""><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/Fuy5MvbgzjSok1U8hH6mUY6WnLynzUextDxfEWMiTkn4">Fuy5MvbgzjSok1U8hH6mUY6WnLynzUextDxfEWMiTkn4</a></span><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#1890ff] text-white h-[20px] text-[10px] leading-[20px]">Writable</div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#c77aea] text-white h-[20px] text-[10px] leading-[20px]">Signer</div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#00c59a] text-white h-[20px] text-[10px] leading-[20px]">Fee Payer</div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">Transfer Amount:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="flex gap-1 flex-row items-center justify-start flex-wrap"><div class="not-italic text-neutral7 text-[14px] leading-[24px] font-bold">0.00203928</div><span class="whitespace-nowrap"><span class="inline-flex align-middle mr-1 border-transparent"><div style="min-width: 16px; max-width: 16px; height: 16px; position: relative;" class="flex align-middle"><img alt="image" referrerpolicy="no-referrer" loading="lazy" width="16" height="16" decoding="async" data-nimg="1" style="color: transparent; border-radius: 5px; position: absolute; height: 100%; object-fit: cover; left: 0px;" src="https://statics.solscan.io/cdn/imgs/s60?ref=68747470733a2f2f7261772e67697468756275736572636f6e74656e742e636f6d2f736f6c616e612d6c6162732f746f6b656e2d6c6973742f6d61696e2f6173736574732f6d61696e6e65742f536f31313131313131313131313131313131313131313131313131313131313131313131313131313131322f6c6f676f2e706e67"></div></span><span class="align-middle font-normal text-neutral7 text-[14px] leading-[24px] border border-dashed box-content break-all truncate border-transparent">SOL</span></span></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">Program Owner:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class=""><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA">Token Program</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#e4830c] text-white h-[20px] text-[10px] leading-[20px]">Program</div></div></div></div></div></div></div></div></div><div><div class="flex flex-col gap-3 items-stretch justify-start px-[15px] py-[10px] bg-neutral0 rounded-lg mt-[10px]"><div><div class="flex gap-1 flex-row items-center justify-start flex-wrap" id="ins-action-3-6"><div class="flex gap-1 flex-row items-stretch justify-between flex-wrap w-full"><div class="not-italic text-neutral7 text-[14px] leading-[24px] capitalize font-bold">#4.7 - Token Program: initializeImmutableOwner </div><button type="button" aria-pressed="false" data-state="off" class="inline-flex items-center justify-center rounded-md font-medium ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 data-[state=on]:bg-neutral4 data-[state=on]:text-white border border-neutral4 hover:bg-accent hover:text-accent-foreground h-7 py-1 text-[12px] leading-3 px-2 gap-1 bg-blue"><svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-code"><polyline points="16 18 22 12 16 6"></polyline><polyline points="8 6 2 12 8 18"></polyline></svg>Raw</button></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Interact With</div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap w-full"><div class="not-italic font-normal text-[14px] leading-[24px] capitalize text-neutral5 break-words">Token Program</div><div class="not-italic font-normal text-neutral7 text-[14px] leading-[24px]">-</div><div class="break-spaces-address-link"><span class="whitespace-nowrap"><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA">TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Instruction Data</div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="flex flex-col gap-2 items-stretch justify-start"><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">Account:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class=""><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/889XLp3qvVAHpTYQmhn6cBpYSppV8Gi8E2Rgp9RH2vRy">Pump.fun (3CAT) Vault</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#1890ff] text-white h-[20px] text-[10px] leading-[20px]">Writable</div></div></div></div></div></div></div></div></div><div><div class="flex flex-col gap-3 items-stretch justify-start px-[15px] py-[10px] bg-neutral0 rounded-lg mt-[10px]"><div><div class="flex gap-1 flex-row items-center justify-start flex-wrap" id="ins-action-3-7"><div class="flex gap-1 flex-row items-stretch justify-between flex-wrap w-full"><div class="not-italic text-neutral7 text-[14px] leading-[24px] capitalize font-bold">#4.8 - Token Program: initializeAccount3 </div><button type="button" aria-pressed="false" data-state="off" class="inline-flex items-center justify-center rounded-md font-medium ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 data-[state=on]:bg-neutral4 data-[state=on]:text-white border border-neutral4 hover:bg-accent hover:text-accent-foreground h-7 py-1 text-[12px] leading-3 px-2 gap-1 bg-blue"><svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-code"><polyline points="16 18 22 12 16 6"></polyline><polyline points="8 6 2 12 8 18"></polyline></svg>Raw</button></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Interact With</div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap w-full"><div class="not-italic font-normal text-[14px] leading-[24px] capitalize text-neutral5 break-words">Token Program</div><div class="not-italic font-normal text-neutral7 text-[14px] leading-[24px]">-</div><div class="break-spaces-address-link"><span class="whitespace-nowrap"><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA">TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Instruction Data</div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="flex flex-col gap-2 items-stretch justify-start"><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">Token Address:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class="whitespace-nowrap"><span class="inline-flex align-middle mr-1"><div style="min-width: 16px; max-width: 16px;"><div style="min-width: 16px; max-width: 16px;"><div class="w-full aspect-square relative flex items-center justify-center flex-col"><img class="w-full h-full absolute top-0 left-0 flex items-center aspect-square z-2" alt="placeholder" src="data:image/svg+xml;base64,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"></div></div></div></span><span class="align-middle font-normal text-neutral7 text-[14px] leading-[24px] border border-dashed box-content break-all truncate border-transparent"><div class="inline" data-state="closed"><a class="text-link border-transparent" href="/token/AkAUSJg1v9xYT3HUxdALH7NsrC6owmwoZuP9MLw8fxTL">3CAT</a></div></span><span class="gap-2 align-middle ml-1"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#1890ff] text-white h-[20px] text-[10px] leading-[20px]">Writable</div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#c77aea] text-white h-[20px] text-[10px] leading-[20px]">Signer</div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">Init Account:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class=""><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/889XLp3qvVAHpTYQmhn6cBpYSppV8Gi8E2Rgp9RH2vRy">Pump.fun (3CAT) Vault</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#1890ff] text-white h-[20px] text-[10px] leading-[20px]">Writable</div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">Owner:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class=""><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/9nhxvNxfSUaJddVco6oa6NodtsCscqCScp6UU1hZkfGm">Pump.fun (3CAT) Bonding Curve</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#1890ff] text-white h-[20px] text-[10px] leading-[20px]">Writable</div></div></div></div></div></div></div></div></div><div><div class="flex flex-col gap-3 items-stretch justify-start px-[15px] py-[10px] bg-neutral0 rounded-lg mt-[10px]"><div><div class="flex gap-1 flex-row items-center justify-start flex-wrap" id="ins-action-3-8"><div class="flex gap-1 flex-row items-stretch justify-between flex-wrap w-full"><div class="not-italic text-neutral7 text-[14px] leading-[24px] capitalize font-bold">#4.9 - Metaplex Token Metadata: createMetadataAccountV3 </div><button type="button" aria-pressed="false" data-state="off" class="inline-flex items-center justify-center rounded-md font-medium ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 data-[state=on]:bg-neutral4 data-[state=on]:text-white border border-neutral4 hover:bg-accent hover:text-accent-foreground h-7 py-1 text-[12px] leading-3 px-2 gap-1 bg-blue"><svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-code"><polyline points="16 18 22 12 16 6"></polyline><polyline points="8 6 2 12 8 18"></polyline></svg>Raw</button></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Interact With</div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap w-full"><div class="not-italic font-normal text-[14px] leading-[24px] capitalize text-neutral5 break-words">Metaplex Token Metadata</div><div class="not-italic font-normal text-neutral7 text-[14px] leading-[24px]">-</div><div class="break-spaces-address-link"><span class="whitespace-nowrap"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/metaqbxxUerdq28cj1RbAWkYQm3ybzjb6a8bt518x1s">metaqbxxUerdq28cj1RbAWkYQm3ybzjb6a8bt518x1s</a></span><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Input Accounts</div></div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="flex flex-col gap-2 items-stretch justify-start"><div class="flex flex-col gap-1 items-stretch justify-start"><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">#1 - Metadata:</div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="break-spaces-address-link"><span class=""><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/CH41RxpjSXHqr1vfLTVYJMsfNs2fBCCWoAE13tPihXh7">CH41RxpjSXHqr1vfLTVYJMsfNs2fBCCWoAE13tPihXh7</a></span><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#1890ff] text-white h-[20px] text-[10px] leading-[20px]">Writable</div></div></div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">#2 - Mint:</div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class="whitespace-nowrap"><span class="inline-flex align-middle mr-1"><div style="min-width: 16px; max-width: 16px;"><div style="min-width: 16px; max-width: 16px;"><div class="w-full aspect-square relative flex items-center justify-center flex-col"><img class="w-full h-full absolute top-0 left-0 flex items-center aspect-square z-2" alt="placeholder" src="data:image/svg+xml;base64,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"></div></div></div></span><span class="align-middle font-normal text-neutral7 text-[14px] leading-[24px] border border-dashed box-content break-all truncate border-transparent"><div class="inline" data-state="closed"><a class="text-link border-transparent" href="/token/AkAUSJg1v9xYT3HUxdALH7NsrC6owmwoZuP9MLw8fxTL">3CAT</a></div></span><span class="gap-2 align-middle ml-1"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#1890ff] text-white h-[20px] text-[10px] leading-[20px]">Writable</div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#c77aea] text-white h-[20px] text-[10px] leading-[20px]">Signer</div></div></div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">#3 - Mint Authority:</div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class=""><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/TSLvdd1pWpHVjahSpsvCXUbgwsL3JAcvokwaKt1eokM">Pump.fun Token Mint Authority</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div></div></div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">#4 - Payer:</div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="break-spaces-address-link"><span class=""><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/Fuy5MvbgzjSok1U8hH6mUY6WnLynzUextDxfEWMiTkn4">Fuy5MvbgzjSok1U8hH6mUY6WnLynzUextDxfEWMiTkn4</a></span><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#1890ff] text-white h-[20px] text-[10px] leading-[20px]">Writable</div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#c77aea] text-white h-[20px] text-[10px] leading-[20px]">Signer</div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#00c59a] text-white h-[20px] text-[10px] leading-[20px]">Fee Payer</div></div></div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">#5 - Update Authority:</div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class=""><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/TSLvdd1pWpHVjahSpsvCXUbgwsL3JAcvokwaKt1eokM">Pump.fun Token Mint Authority</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div></div></div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">#6 - System Program:</div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class=""><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/11111111111111111111111111111111">System Program</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#e4830c] text-white h-[20px] text-[10px] leading-[20px]">Program</div></div></div></div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Instruction Data</div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="rounded-lg break-all max-h-[550px] overflow-y-auto"><div class="react-json-view" style="font-family: monospace; cursor: default; background-color: rgb(255, 255, 255); position: relative; white-space: pre-wrap; border: 1px solid rgb(234, 234, 234); border-radius: 8px; padding: 12px;"><div class="pretty-json-container object-container"><div class="object-content"><div class="object-key-val"><span><span style="display: inline-block; cursor: pointer;"><div class="icon-container" style="display: inline-block; width: 17px;"><span class="expanded-icon"><svg style="vertical-align: top; color: rgb(88, 110, 117); height: 1em; width: 1em; padding-left: 2px;" viewBox="0 0 15 15" fill="currentColor"><path d="M0 5l6 6 6-6z"></path></svg></span></div><span></span><span style="display: inline-block; cursor: pointer; font-weight: bold; color: rgb(0, 43, 54);">{</span></span><div style="display: inline-block; padding: 0px 0px 0px 10px;" class="object-meta-data"><span class="object-size" style="color: rgba(0, 0, 0, 0.3); border-radius: 3px; font-style: italic; margin: 0px 6px 0px 0px; cursor: default;">4 items</span><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div></span><div class="pushed-content object-container"><div class="object-content" style="margin-left: 6px;"><div class="object-key-val" style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);"><span><span style="display: inline-block; cursor: pointer;"><div class="icon-container" style="display: inline-block; width: 17px;"><span class="expanded-icon"><svg style="vertical-align: top; color: rgb(88, 110, 117); height: 1em; width: 1em; padding-left: 2px;" viewBox="0 0 15 15" fill="currentColor"><path d="M0 5l6 6 6-6z"></path></svg></span></div><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;"><span class="object-key"><span>discriminator</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><span style="display: inline-block; cursor: pointer; font-weight: bold; color: rgb(0, 43, 54);">{</span></span><div style="display: inline-block; padding: 0px 0px 0px 10px;" class="object-meta-data"><span class="object-size" style="color: rgba(0, 0, 0, 0.3); border-radius: 3px; font-style: italic; margin: 0px 6px 0px 0px; cursor: default;">2 items</span><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div></span><div class="pushed-content object-container"><div class="object-content" style="margin-left: 6px;"><div style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);" class="variable-row"><span><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;" class="object-key"><span style="display: inline-block;">type</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><div class="variable-value" style="display: inline-block; padding-right: 6px; position: relative; cursor: default;"><div style="display: inline-block; color: rgb(203, 75, 22);"><span class="string-value" style="cursor: default;">"u8"</span></div></div><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div><div style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);" class="variable-row"><span><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;" class="object-key"><span style="display: inline-block;">data</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><div class="variable-value" style="display: inline-block; padding-right: 6px; position: relative; cursor: default;"><div style="display: inline-block; color: rgb(203, 75, 22);">33</div></div><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div></div></div><span class="brace-row"><span style="display: inline-block; cursor: pointer; font-weight: bold; color: rgb(0, 43, 54); padding-left: 3px;">}</span></span></div><div class="object-key-val" style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);"><span><span style="display: inline-block; cursor: pointer;"><div class="icon-container" style="display: inline-block; width: 17px;"><span class="expanded-icon"><svg style="vertical-align: top; color: rgb(88, 110, 117); height: 1em; width: 1em; padding-left: 2px;" viewBox="0 0 15 15" fill="currentColor"><path d="M0 5l6 6 6-6z"></path></svg></span></div><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;"><span class="object-key"><span>dataV2</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><span style="display: inline-block; cursor: pointer; font-weight: bold; color: rgb(0, 43, 54);">{</span></span><div style="display: inline-block; padding: 0px 0px 0px 10px;" class="object-meta-data"><span class="object-size" style="color: rgba(0, 0, 0, 0.3); border-radius: 3px; font-style: italic; margin: 0px 6px 0px 0px; cursor: default;">2 items</span><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div></span><div class="pushed-content object-container"><div class="object-content" style="margin-left: 6px;"><div style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);" class="variable-row"><span><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;" class="object-key"><span style="display: inline-block;">type</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><div class="variable-value" style="display: inline-block; padding-right: 6px; position: relative; cursor: default;"><div style="display: inline-block; color: rgb(203, 75, 22);"><span class="string-value" style="cursor: default;">"u8"</span></div></div><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div><div class="object-key-val" style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);"><span><span style="display: inline-block; cursor: pointer;"><div class="icon-container" style="display: inline-block; width: 17px;"><span class="expanded-icon"><svg style="vertical-align: top; color: rgb(88, 110, 117); height: 1em; width: 1em; padding-left: 2px;" viewBox="0 0 15 15" fill="currentColor"><path d="M0 5l6 6 6-6z"></path></svg></span></div><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;"><span class="object-key"><span>data</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><span style="display: inline-block; cursor: pointer; font-weight: bold; color: rgb(0, 43, 54);">{</span></span><div style="display: inline-block; padding: 0px 0px 0px 10px;" class="object-meta-data"><span class="object-size" style="color: rgba(0, 0, 0, 0.3); border-radius: 3px; font-style: italic; margin: 0px 6px 0px 0px; cursor: default;">7 items</span><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div></span><div class="pushed-content object-container"><div class="object-content" style="margin-left: 6px;"><div style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);" class="variable-row"><span><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;" class="object-key"><span style="display: inline-block;">name</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><div class="variable-value" style="display: inline-block; padding-right: 6px; position: relative; cursor: default;"><div style="display: inline-block; color: rgb(203, 75, 22);"><span class="string-value" style="cursor: default;">"3D CAT"</span></div></div><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div><div style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);" class="variable-row"><span><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;" class="object-key"><span style="display: inline-block;">symbol</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><div class="variable-value" style="display: inline-block; padding-right: 6px; position: relative; cursor: default;"><div style="display: inline-block; color: rgb(203, 75, 22);"><span class="string-value" style="cursor: default;">"3CAT"</span></div></div><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div><div style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);" class="variable-row"><span><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;" class="object-key"><span style="display: inline-block;">uri</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><div class="variable-value" style="display: inline-block; padding-right: 6px; position: relative; cursor: default;"><div style="display: inline-block; color: rgb(203, 75, 22);"><span class="string-value" style="cursor: default;">"https://ipfs.io/ipfs/QmZXtP75xUapRcr9BtAKhtLDkD6g4aSu6mvusry4AaKj4i"</span></div></div><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div><div style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);" class="variable-row"><span><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;" class="object-key"><span style="display: inline-block;">sellerFeeBasisPoints</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><div class="variable-value" style="display: inline-block; padding-right: 6px; position: relative; cursor: default;"><div style="display: inline-block; color: rgb(203, 75, 22);">0</div></div><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div><div style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);" class="variable-row"><span><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;" class="object-key"><span style="display: inline-block;">creators</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><div class="variable-value" style="display: inline-block; padding-right: 6px; position: relative; cursor: default;"><div style="display: inline-block; color: rgb(203, 75, 22); font-size: 11px; font-weight: bold; background-color: rgb(195, 195, 195); padding: 1px 2px; border-radius: 3px;">NULL</div></div><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div><div style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);" class="variable-row"><span><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;" class="object-key"><span style="display: inline-block;">collection</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><div class="variable-value" style="display: inline-block; padding-right: 6px; position: relative; cursor: default;"><div style="display: inline-block; color: rgb(203, 75, 22); font-size: 11px; font-weight: bold; background-color: rgb(195, 195, 195); padding: 1px 2px; border-radius: 3px;">NULL</div></div><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div><div style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);" class="variable-row"><span><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;" class="object-key"><span style="display: inline-block;">uses</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><div class="variable-value" style="display: inline-block; padding-right: 6px; position: relative; cursor: default;"><div style="display: inline-block; color: rgb(203, 75, 22); font-size: 11px; font-weight: bold; background-color: rgb(195, 195, 195); padding: 1px 2px; border-radius: 3px;">NULL</div></div><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div></div></div><span class="brace-row"><span style="display: inline-block; cursor: pointer; font-weight: bold; color: rgb(0, 43, 54); padding-left: 3px;">}</span></span></div></div></div><span class="brace-row"><span style="display: inline-block; cursor: pointer; font-weight: bold; color: rgb(0, 43, 54); padding-left: 3px;">}</span></span></div><div class="object-key-val" style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);"><span><span style="display: inline-block; cursor: pointer;"><div class="icon-container" style="display: inline-block; width: 17px;"><span class="expanded-icon"><svg style="vertical-align: top; color: rgb(88, 110, 117); height: 1em; width: 1em; padding-left: 2px;" viewBox="0 0 15 15" fill="currentColor"><path d="M0 5l6 6 6-6z"></path></svg></span></div><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;"><span class="object-key"><span>isMutable</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><span style="display: inline-block; cursor: pointer; font-weight: bold; color: rgb(0, 43, 54);">{</span></span><div style="display: inline-block; padding: 0px 0px 0px 10px;" class="object-meta-data"><span class="object-size" style="color: rgba(0, 0, 0, 0.3); border-radius: 3px; font-style: italic; margin: 0px 6px 0px 0px; cursor: default;">2 items</span><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div></span><div class="pushed-content object-container"><div class="object-content" style="margin-left: 6px;"><div style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);" class="variable-row"><span><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;" class="object-key"><span style="display: inline-block;">type</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><div class="variable-value" style="display: inline-block; padding-right: 6px; position: relative; cursor: default;"><div style="display: inline-block; color: rgb(203, 75, 22);"><span class="string-value" style="cursor: default;">"u8"</span></div></div><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div><div style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);" class="variable-row"><span><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;" class="object-key"><span style="display: inline-block;">data</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><div class="variable-value" style="display: inline-block; padding-right: 6px; position: relative; cursor: default;"><div style="display: inline-block; color: rgb(203, 75, 22);">false</div></div><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div></div></div><span class="brace-row"><span style="display: inline-block; cursor: pointer; font-weight: bold; color: rgb(0, 43, 54); padding-left: 3px;">}</span></span></div><div class="object-key-val" style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);"><span><span style="display: inline-block; cursor: pointer;"><div class="icon-container" style="display: inline-block; width: 17px;"><span class="expanded-icon"><svg style="vertical-align: top; color: rgb(88, 110, 117); height: 1em; width: 1em; padding-left: 2px;" viewBox="0 0 15 15" fill="currentColor"><path d="M0 5l6 6 6-6z"></path></svg></span></div><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;"><span class="object-key"><span>collectionDetails</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><span style="display: inline-block; cursor: pointer; font-weight: bold; color: rgb(0, 43, 54);">{</span></span><div style="display: inline-block; padding: 0px 0px 0px 10px;" class="object-meta-data"><span class="object-size" style="color: rgba(0, 0, 0, 0.3); border-radius: 3px; font-style: italic; margin: 0px 6px 0px 0px; cursor: default;">2 items</span><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div></span><div class="pushed-content object-container"><div class="object-content" style="margin-left: 6px;"><div style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);" class="variable-row"><span><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;" class="object-key"><span style="display: inline-block;">type</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><div class="variable-value" style="display: inline-block; padding-right: 6px; position: relative; cursor: default;"><div style="display: inline-block; color: rgb(203, 75, 22);"><span class="string-value" style="cursor: default;">"u8"</span></div></div><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div><div style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);" class="variable-row"><span><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;" class="object-key"><span style="display: inline-block;">data</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><div class="variable-value" style="display: inline-block; padding-right: 6px; position: relative; cursor: default;"><div style="display: inline-block; color: rgb(203, 75, 22); font-size: 11px; font-weight: bold; background-color: rgb(195, 195, 195); padding: 1px 2px; border-radius: 3px;">NULL</div></div><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div></div></div><span class="brace-row"><span style="display: inline-block; cursor: pointer; font-weight: bold; color: rgb(0, 43, 54); padding-left: 3px;">}</span></span></div></div></div><span class="brace-row"><span style="display: inline-block; cursor: pointer; font-weight: bold; color: rgb(0, 43, 54); padding-left: 3px;">}</span></span></div></div></div></div></div></div></div></div></div><div><div class="flex flex-col gap-3 items-stretch justify-start px-[15px] py-[10px] bg-neutral0 rounded-lg mt-[10px]"><div><div class="flex gap-1 flex-row items-center justify-start flex-wrap" id="ins-action-3-9"><div class="flex gap-1 flex-row items-stretch justify-between flex-wrap w-full"><div class="not-italic text-neutral7 text-[14px] leading-[24px] capitalize font-bold">#4.10 - System Program: transfer </div><button type="button" aria-pressed="false" data-state="off" class="inline-flex items-center justify-center rounded-md font-medium ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 data-[state=on]:bg-neutral4 data-[state=on]:text-white border border-neutral4 hover:bg-accent hover:text-accent-foreground h-7 py-1 text-[12px] leading-3 px-2 gap-1 bg-blue"><svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-code"><polyline points="16 18 22 12 16 6"></polyline><polyline points="8 6 2 12 8 18"></polyline></svg>Raw</button></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Interact With</div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap w-full"><div class="not-italic font-normal text-[14px] leading-[24px] capitalize text-neutral5 break-words">System Program</div><div class="not-italic font-normal text-neutral7 text-[14px] leading-[24px]">-</div><div class="break-spaces-address-link"><span class="whitespace-nowrap"><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/11111111111111111111111111111111">11111111111111111111111111111111</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Instruction Data</div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="flex flex-col gap-2 items-stretch justify-start"><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">Source:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="break-spaces-address-link"><span class=""><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/Fuy5MvbgzjSok1U8hH6mUY6WnLynzUextDxfEWMiTkn4">Fuy5MvbgzjSok1U8hH6mUY6WnLynzUextDxfEWMiTkn4</a></span><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#1890ff] text-white h-[20px] text-[10px] leading-[20px]">Writable</div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#c77aea] text-white h-[20px] text-[10px] leading-[20px]">Signer</div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#00c59a] text-white h-[20px] text-[10px] leading-[20px]">Fee Payer</div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">Destination:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="break-spaces-address-link"><span class=""><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/CH41RxpjSXHqr1vfLTVYJMsfNs2fBCCWoAE13tPihXh7">CH41RxpjSXHqr1vfLTVYJMsfNs2fBCCWoAE13tPihXh7</a></span><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#1890ff] text-white h-[20px] text-[10px] leading-[20px]">Writable</div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">Amount:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="flex gap-1 flex-row items-center justify-start flex-wrap"><div class="not-italic text-neutral7 text-[14px] leading-[24px] font-bold">0.01561672</div><span class="whitespace-nowrap"><span class="inline-flex align-middle mr-1 border-transparent"><div style="min-width: 16px; max-width: 16px; height: 16px; position: relative;" class="flex align-middle"><img alt="image" referrerpolicy="no-referrer" loading="lazy" width="16" height="16" decoding="async" data-nimg="1" style="color: transparent; border-radius: 5px; position: absolute; height: 100%; object-fit: cover; left: 0px;" src="https://statics.solscan.io/cdn/imgs/s60?ref=68747470733a2f2f7261772e67697468756275736572636f6e74656e742e636f6d2f736f6c616e612d6c6162732f746f6b656e2d6c6973742f6d61696e2f6173736574732f6d61696e6e65742f536f31313131313131313131313131313131313131313131313131313131313131313131313131313131322f6c6f676f2e706e67"></div></span><span class="align-middle font-normal text-neutral7 text-[14px] leading-[24px] border border-dashed box-content break-all truncate border-transparent">SOL</span></span></div></div></div></div></div></div></div></div><div><div class="flex flex-col gap-3 items-stretch justify-start px-[15px] py-[10px] bg-neutral0 rounded-lg mt-[10px]"><div><div class="flex gap-1 flex-row items-center justify-start flex-wrap" id="ins-action-3-10"><div class="flex gap-1 flex-row items-stretch justify-between flex-wrap w-full"><div class="not-italic text-neutral7 text-[14px] leading-[24px] capitalize font-bold">#4.11 - System Program: allocate </div><button type="button" aria-pressed="false" data-state="off" class="inline-flex items-center justify-center rounded-md font-medium ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 data-[state=on]:bg-neutral4 data-[state=on]:text-white border border-neutral4 hover:bg-accent hover:text-accent-foreground h-7 py-1 text-[12px] leading-3 px-2 gap-1 bg-blue"><svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-code"><polyline points="16 18 22 12 16 6"></polyline><polyline points="8 6 2 12 8 18"></polyline></svg>Raw</button></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Interact With</div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap w-full"><div class="not-italic font-normal text-[14px] leading-[24px] capitalize text-neutral5 break-words">System Program</div><div class="not-italic font-normal text-neutral7 text-[14px] leading-[24px]">-</div><div class="break-spaces-address-link"><span class="whitespace-nowrap"><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/11111111111111111111111111111111">11111111111111111111111111111111</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Instruction Data</div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="flex flex-col gap-2 items-stretch justify-start"><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">Account:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="break-spaces-address-link"><span class=""><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/CH41RxpjSXHqr1vfLTVYJMsfNs2fBCCWoAE13tPihXh7">CH41RxpjSXHqr1vfLTVYJMsfNs2fBCCWoAE13tPihXh7</a></span><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#1890ff] text-white h-[20px] text-[10px] leading-[20px]">Writable</div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">Space:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-neutral7 text-[14px] leading-[24px]">679</div></div></div></div></div></div></div></div><div><div class="flex flex-col gap-3 items-stretch justify-start px-[15px] py-[10px] bg-neutral0 rounded-lg mt-[10px]"><div><div class="flex gap-1 flex-row items-center justify-start flex-wrap" id="ins-action-3-11"><div class="flex gap-1 flex-row items-stretch justify-between flex-wrap w-full"><div class="not-italic text-neutral7 text-[14px] leading-[24px] capitalize font-bold">#4.12 - System Program: assign </div><button type="button" aria-pressed="false" data-state="off" class="inline-flex items-center justify-center rounded-md font-medium ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 data-[state=on]:bg-neutral4 data-[state=on]:text-white border border-neutral4 hover:bg-accent hover:text-accent-foreground h-7 py-1 text-[12px] leading-3 px-2 gap-1 bg-blue"><svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-code"><polyline points="16 18 22 12 16 6"></polyline><polyline points="8 6 2 12 8 18"></polyline></svg>Raw</button></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Interact With</div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap w-full"><div class="not-italic font-normal text-[14px] leading-[24px] capitalize text-neutral5 break-words">System Program</div><div class="not-italic font-normal text-neutral7 text-[14px] leading-[24px]">-</div><div class="break-spaces-address-link"><span class="whitespace-nowrap"><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/11111111111111111111111111111111">11111111111111111111111111111111</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Instruction Data</div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="flex flex-col gap-2 items-stretch justify-start"><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">Account:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="break-spaces-address-link"><span class=""><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/CH41RxpjSXHqr1vfLTVYJMsfNs2fBCCWoAE13tPihXh7">CH41RxpjSXHqr1vfLTVYJMsfNs2fBCCWoAE13tPihXh7</a></span><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#1890ff] text-white h-[20px] text-[10px] leading-[20px]">Writable</div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">Owner:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class=""><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/metaqbxxUerdq28cj1RbAWkYQm3ybzjb6a8bt518x1s">Metaplex Token Metadata</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#e4830c] text-white h-[20px] text-[10px] leading-[20px]">Program</div></div></div></div></div></div></div></div></div><div><div class="flex flex-col gap-3 items-stretch justify-start px-[15px] py-[10px] bg-neutral0 rounded-lg mt-[10px]"><div><div class="flex gap-1 flex-row items-center justify-start flex-wrap" id="ins-action-3-12"><div class="flex gap-1 flex-row items-stretch justify-between flex-wrap w-full"><div class="not-italic text-neutral7 text-[14px] leading-[24px] capitalize font-bold">#4.13 - Token Program: mintTo </div><button type="button" aria-pressed="false" data-state="off" class="inline-flex items-center justify-center rounded-md font-medium ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 data-[state=on]:bg-neutral4 data-[state=on]:text-white border border-neutral4 hover:bg-accent hover:text-accent-foreground h-7 py-1 text-[12px] leading-3 px-2 gap-1 bg-blue"><svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-code"><polyline points="16 18 22 12 16 6"></polyline><polyline points="8 6 2 12 8 18"></polyline></svg>Raw</button></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Action</div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="flex flex-col gap-2 items-stretch justify-start"><div class="px-3 py-1 rounded bg-neutral2 w-full"><div class="flex flex-col gap-2 items-stretch justify-start rounded-2xl border-none bg-transparent p-0"><div class="flex gap-1 flex-row items-center justify-between flex-wrap my-1"><div class="flex gap-1 flex-row items-center justify-start flex-wrap"><div class="not-italic font-normal text-neutral7 text-[14px] leading-[24px]"><span style="font-weight: bold;">Mint </span><span>to </span></div><span class="whitespace-nowrap"><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border border-dashed box-content break-all border-transparent"><a class="text-link" href="/account/9nhxvNxfSUaJddVco6oa6NodtsCscqCScp6UU1hZkfGm">Pump.fun (3CAT) Bonding Curve</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span><div class="not-italic font-normal text-neutral7 text-[14px] leading-[24px]">for</div><div class="flex gap-1 flex-row items-center justify-start flex-wrap"><div class="not-italic text-neutral7 text-[14px] leading-[24px] font-bold">1,000,000,000</div><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">($21,673.6)</div><span class="whitespace-nowrap"><span class="inline-flex align-middle mr-1"><div style="min-width: 16px; max-width: 16px;"><div style="min-width: 16px; max-width: 16px;"><div class="w-full aspect-square relative flex items-center justify-center flex-col"><img class="w-full h-full absolute top-0 left-0 flex items-center aspect-square z-2" alt="placeholder" src="data:image/svg+xml;base64,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"></div></div></div></span><span class="align-middle font-normal text-neutral7 text-[14px] leading-[24px] border border-dashed box-content break-all truncate border-transparent"><div class="inline" data-state="closed"><a class="text-link border-transparent" href="/token/AkAUSJg1v9xYT3HUxdALH7NsrC6owmwoZuP9MLw8fxTL">3CAT</a></div></span><span class="gap-2 align-middle ml-1"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div></div></div></div></div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Interact With</div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap w-full"><div class="not-italic font-normal text-[14px] leading-[24px] capitalize text-neutral5 break-words">Token Program</div><div class="not-italic font-normal text-neutral7 text-[14px] leading-[24px]">-</div><div class="break-spaces-address-link"><span class="whitespace-nowrap"><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA">TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Instruction Data</div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="flex flex-col gap-2 items-stretch justify-start"><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">Account:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class=""><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/889XLp3qvVAHpTYQmhn6cBpYSppV8Gi8E2Rgp9RH2vRy">Pump.fun (3CAT) Vault</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#1890ff] text-white h-[20px] text-[10px] leading-[20px]">Writable</div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">Amount:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="flex gap-1 flex-row items-center justify-start flex-wrap"><div class="not-italic text-neutral7 text-[14px] leading-[24px] font-bold">1,000,000,000</div><span class="whitespace-nowrap"><span class="inline-flex align-middle mr-1"><div style="min-width: 16px; max-width: 16px;"><div style="min-width: 16px; max-width: 16px;"><div class="w-full aspect-square relative flex items-center justify-center flex-col"><img class="w-full h-full absolute top-0 left-0 flex items-center aspect-square z-2" alt="placeholder" src="data:image/svg+xml;base64,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"></div></div></div></span><span class="align-middle font-normal text-neutral7 text-[14px] leading-[24px] border border-dashed box-content break-all truncate border-transparent"><div class="inline" data-state="closed"><a class="text-link border-transparent" href="/token/AkAUSJg1v9xYT3HUxdALH7NsrC6owmwoZuP9MLw8fxTL">3CAT</a></div></span><span class="gap-2 align-middle ml-1"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">Mint:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class="whitespace-nowrap"><span class="inline-flex align-middle mr-1"><div style="min-width: 16px; max-width: 16px;"><div style="min-width: 16px; max-width: 16px;"><div class="w-full aspect-square relative flex items-center justify-center flex-col"><img class="w-full h-full absolute top-0 left-0 flex items-center aspect-square z-2" alt="placeholder" src="data:image/svg+xml;base64,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"></div></div></div></span><span class="align-middle font-normal text-neutral7 text-[14px] leading-[24px] border border-dashed box-content break-all truncate border-transparent"><div class="inline" data-state="closed"><a class="text-link border-transparent" href="/token/AkAUSJg1v9xYT3HUxdALH7NsrC6owmwoZuP9MLw8fxTL">3CAT</a></div></span><span class="gap-2 align-middle ml-1"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#1890ff] text-white h-[20px] text-[10px] leading-[20px]">Writable</div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#c77aea] text-white h-[20px] text-[10px] leading-[20px]">Signer</div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">Mint Authority:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class=""><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/TSLvdd1pWpHVjahSpsvCXUbgwsL3JAcvokwaKt1eokM">Pump.fun Token Mint Authority</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div></div></div></div></div></div></div></div></div><div><div class="flex flex-col gap-3 items-stretch justify-start px-[15px] py-[10px] bg-neutral0 rounded-lg mt-[10px]"><div><div class="flex gap-1 flex-row items-center justify-start flex-wrap" id="ins-action-3-13"><div class="flex gap-1 flex-row items-stretch justify-between flex-wrap w-full"><div class="not-italic text-neutral7 text-[14px] leading-[24px] capitalize font-bold">#4.14 - Token Program: setAuthority </div><button type="button" aria-pressed="false" data-state="off" class="inline-flex items-center justify-center rounded-md font-medium ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 data-[state=on]:bg-neutral4 data-[state=on]:text-white border border-neutral4 hover:bg-accent hover:text-accent-foreground h-7 py-1 text-[12px] leading-3 px-2 gap-1 bg-blue"><svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-code"><polyline points="16 18 22 12 16 6"></polyline><polyline points="8 6 2 12 8 18"></polyline></svg>Raw</button></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Interact With</div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap w-full"><div class="not-italic font-normal text-[14px] leading-[24px] capitalize text-neutral5 break-words">Token Program</div><div class="not-italic font-normal text-neutral7 text-[14px] leading-[24px]">-</div><div class="break-spaces-address-link"><span class="whitespace-nowrap"><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA">TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Instruction Data</div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="flex flex-col gap-2 items-stretch justify-start"><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">Authority:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class=""><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/TSLvdd1pWpHVjahSpsvCXUbgwsL3JAcvokwaKt1eokM">Pump.fun Token Mint Authority</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">Authority Type:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-neutral7 text-[14px] leading-[24px]">mintTokens</div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">Mint:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class="whitespace-nowrap"><span class="inline-flex align-middle mr-1"><div style="min-width: 16px; max-width: 16px;"><div style="min-width: 16px; max-width: 16px;"><div class="w-full aspect-square relative flex items-center justify-center flex-col"><img class="w-full h-full absolute top-0 left-0 flex items-center aspect-square z-2" alt="placeholder" src="data:image/svg+xml;base64,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"></div></div></div></span><span class="align-middle font-normal text-neutral7 text-[14px] leading-[24px] border border-dashed box-content break-all truncate border-transparent"><div class="inline" data-state="closed"><a class="text-link border-transparent" href="/token/AkAUSJg1v9xYT3HUxdALH7NsrC6owmwoZuP9MLw8fxTL">3CAT</a></div></span><span class="gap-2 align-middle ml-1"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#1890ff] text-white h-[20px] text-[10px] leading-[20px]">Writable</div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#c77aea] text-white h-[20px] text-[10px] leading-[20px]">Signer</div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-2 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-5/24 flex-24/24 lg:flex-5/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">New Authority:</div></div><div class="max-w-24/24 lg:max-w-19/24 flex-24/24 lg:flex-19/24 block relative box-border my-0 px-2 lg:px-3"><div class="not-italic font-normal text-neutral7 text-[14px] leading-[24px]">none</div></div></div></div></div></div></div></div><div><div class="flex flex-col gap-3 items-stretch justify-start px-[15px] py-[10px] bg-neutral0 rounded-lg mt-[10px]"><div><div class="flex gap-1 flex-row items-center justify-start flex-wrap" id="ins-action-3-14"><div class="flex gap-1 flex-row items-stretch justify-between flex-wrap w-full"><div class="not-italic text-neutral7 text-[14px] leading-[24px] capitalize font-bold">#4.15 - Pump.fun: Unknown </div><button type="button" aria-pressed="false" data-state="off" class="inline-flex items-center justify-center rounded-md font-medium ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 data-[state=on]:bg-neutral4 data-[state=on]:text-white border border-neutral4 hover:bg-accent hover:text-accent-foreground h-7 py-1 text-[12px] leading-3 px-2 gap-1 bg-blue"><svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-code"><polyline points="16 18 22 12 16 6"></polyline><polyline points="8 6 2 12 8 18"></polyline></svg>Raw</button></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Interact With</div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="flex gap-2 flex-row items-center justify-start flex-wrap w-full"><div class="not-italic font-normal text-[14px] leading-[24px] capitalize text-neutral5 break-words">Pump.fun</div><div class="not-italic font-normal text-neutral7 text-[14px] leading-[24px]">-</div><div class="break-spaces-address-link"><span class="whitespace-nowrap"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/6EF8rrecthR5Dkzon8Nwu78hRvfCKubJ14M5uBEwF6P">6EF8rrecthR5Dkzon8Nwu78hRvfCKubJ14M5uBEwF6P</a></span><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Input Accounts</div></div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="flex flex-col gap-2 items-stretch justify-start"><div class="flex flex-col gap-1 items-stretch justify-start"><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">#1 - Account:</div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="break-spaces-address-link"><span class=""><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/Ce6TQqeHC9p8KetsN6JsjHK7UTZk7nasjjnr7XxXp9F1">Ce6TQqeHC9p8KetsN6JsjHK7UTZk7nasjjnr7XxXp9F1</a></span><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div></div></div></div></div></div></div><div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Events</div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="rounded-lg break-all max-h-[550px] overflow-y-auto"><div class="react-json-view" style="font-family: monospace; cursor: default; background-color: rgb(255, 255, 255); position: relative; white-space: pre-wrap; border: 1px solid rgb(234, 234, 234); border-radius: 8px; padding: 12px;"><div class="pretty-json-container object-container"><div class="object-content"><div class="object-key-val"><span><span style="display: inline-block; cursor: pointer;"><div class="icon-container" style="display: inline-block; width: 17px;"><span class="expanded-icon"><svg style="vertical-align: top; color: rgb(88, 110, 117); height: 1em; width: 1em; padding-left: 2px;" viewBox="0 0 15 15" fill="currentColor"><path d="M0 5l6 6 6-6z"></path></svg></span></div><span></span><span style="display: inline-block; cursor: pointer; font-weight: bold; color: rgb(0, 43, 54);">{</span></span><div style="display: inline-block; padding: 0px 0px 0px 10px;" class="object-meta-data"><span class="object-size" style="color: rgba(0, 0, 0, 0.3); border-radius: 3px; font-style: italic; margin: 0px 6px 0px 0px; cursor: default;">6 items</span><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div></span><div class="pushed-content object-container"><div class="object-content" style="margin-left: 6px;"><div class="object-key-val" style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);"><span><span style="display: inline-block; cursor: pointer;"><div class="icon-container" style="display: inline-block; width: 17px;"><span class="expanded-icon"><svg style="vertical-align: top; color: rgb(88, 110, 117); height: 1em; width: 1em; padding-left: 2px;" viewBox="0 0 15 15" fill="currentColor"><path d="M0 5l6 6 6-6z"></path></svg></span></div><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;"><span class="object-key"><span>name</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><span style="display: inline-block; cursor: pointer; font-weight: bold; color: rgb(0, 43, 54);">{</span></span><div style="display: inline-block; padding: 0px 0px 0px 10px;" class="object-meta-data"><span class="object-size" style="color: rgba(0, 0, 0, 0.3); border-radius: 3px; font-style: italic; margin: 0px 6px 0px 0px; cursor: default;">2 items</span><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div></span><div class="pushed-content object-container"><div class="object-content" style="margin-left: 6px;"><div style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);" class="variable-row"><span><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;" class="object-key"><span style="display: inline-block;">type</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><div class="variable-value" style="display: inline-block; padding-right: 6px; position: relative; cursor: default;"><div style="display: inline-block; color: rgb(203, 75, 22);"><span class="string-value" style="cursor: default;">"string"</span></div></div><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div><div style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);" class="variable-row"><span><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;" class="object-key"><span style="display: inline-block;">data</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><div class="variable-value" style="display: inline-block; padding-right: 6px; position: relative; cursor: default;"><div style="display: inline-block; color: rgb(203, 75, 22);"><span class="string-value" style="cursor: default;">"3D CAT"</span></div></div><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div></div></div><span class="brace-row"><span style="display: inline-block; cursor: pointer; font-weight: bold; color: rgb(0, 43, 54); padding-left: 3px;">}</span></span></div><div class="object-key-val" style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);"><span><span style="display: inline-block; cursor: pointer;"><div class="icon-container" style="display: inline-block; width: 17px;"><span class="expanded-icon"><svg style="vertical-align: top; color: rgb(88, 110, 117); height: 1em; width: 1em; padding-left: 2px;" viewBox="0 0 15 15" fill="currentColor"><path d="M0 5l6 6 6-6z"></path></svg></span></div><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;"><span class="object-key"><span>symbol</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><span style="display: inline-block; cursor: pointer; font-weight: bold; color: rgb(0, 43, 54);">{</span></span><div style="display: inline-block; padding: 0px 0px 0px 10px;" class="object-meta-data"><span class="object-size" style="color: rgba(0, 0, 0, 0.3); border-radius: 3px; font-style: italic; margin: 0px 6px 0px 0px; cursor: default;">2 items</span><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div></span><div class="pushed-content object-container"><div class="object-content" style="margin-left: 6px;"><div style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);" class="variable-row"><span><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;" class="object-key"><span style="display: inline-block;">type</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><div class="variable-value" style="display: inline-block; padding-right: 6px; position: relative; cursor: default;"><div style="display: inline-block; color: rgb(203, 75, 22);"><span class="string-value" style="cursor: default;">"string"</span></div></div><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div><div style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);" class="variable-row"><span><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;" class="object-key"><span style="display: inline-block;">data</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><div class="variable-value" style="display: inline-block; padding-right: 6px; position: relative; cursor: default;"><div style="display: inline-block; color: rgb(203, 75, 22);"><span class="string-value" style="cursor: default;">"3CAT"</span></div></div><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div></div></div><span class="brace-row"><span style="display: inline-block; cursor: pointer; font-weight: bold; color: rgb(0, 43, 54); padding-left: 3px;">}</span></span></div><div class="object-key-val" style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);"><span><span style="display: inline-block; cursor: pointer;"><div class="icon-container" style="display: inline-block; width: 17px;"><span class="expanded-icon"><svg style="vertical-align: top; color: rgb(88, 110, 117); height: 1em; width: 1em; padding-left: 2px;" viewBox="0 0 15 15" fill="currentColor"><path d="M0 5l6 6 6-6z"></path></svg></span></div><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;"><span class="object-key"><span>uri</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><span style="display: inline-block; cursor: pointer; font-weight: bold; color: rgb(0, 43, 54);">{</span></span><div style="display: inline-block; padding: 0px 0px 0px 10px;" class="object-meta-data"><span class="object-size" style="color: rgba(0, 0, 0, 0.3); border-radius: 3px; font-style: italic; margin: 0px 6px 0px 0px; cursor: default;">2 items</span><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div></span><div class="pushed-content object-container"><div class="object-content" style="margin-left: 6px;"><div style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);" class="variable-row"><span><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;" class="object-key"><span style="display: inline-block;">type</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><div class="variable-value" style="display: inline-block; padding-right: 6px; position: relative; cursor: default;"><div style="display: inline-block; color: rgb(203, 75, 22);"><span class="string-value" style="cursor: default;">"string"</span></div></div><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div><div style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);" class="variable-row"><span><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;" class="object-key"><span style="display: inline-block;">data</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><div class="variable-value" style="display: inline-block; padding-right: 6px; position: relative; cursor: default;"><div style="display: inline-block; color: rgb(203, 75, 22);"><span class="string-value" style="cursor: default;">"https://ipfs.io/ipfs/QmZXtP75xUapRcr9BtAKhtLDkD6g4aSu6mvusry4AaKj4i"</span></div></div><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div></div></div><span class="brace-row"><span style="display: inline-block; cursor: pointer; font-weight: bold; color: rgb(0, 43, 54); padding-left: 3px;">}</span></span></div><div class="object-key-val" style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);"><span><span style="display: inline-block; cursor: pointer;"><div class="icon-container" style="display: inline-block; width: 17px;"><span class="expanded-icon"><svg style="vertical-align: top; color: rgb(88, 110, 117); height: 1em; width: 1em; padding-left: 2px;" viewBox="0 0 15 15" fill="currentColor"><path d="M0 5l6 6 6-6z"></path></svg></span></div><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;"><span class="object-key"><span>mint</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><span style="display: inline-block; cursor: pointer; font-weight: bold; color: rgb(0, 43, 54);">{</span></span><div style="display: inline-block; padding: 0px 0px 0px 10px;" class="object-meta-data"><span class="object-size" style="color: rgba(0, 0, 0, 0.3); border-radius: 3px; font-style: italic; margin: 0px 6px 0px 0px; cursor: default;">2 items</span><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div></span><div class="pushed-content object-container"><div class="object-content" style="margin-left: 6px;"><div style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);" class="variable-row"><span><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;" class="object-key"><span style="display: inline-block;">type</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><div class="variable-value" style="display: inline-block; padding-right: 6px; position: relative; cursor: default;"><div style="display: inline-block; color: rgb(203, 75, 22);"><span class="string-value" style="cursor: default;">"publicKey"</span></div></div><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div><div style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);" class="variable-row"><span><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;" class="object-key"><span style="display: inline-block;">data</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><div class="variable-value" style="display: inline-block; padding-right: 6px; position: relative; cursor: default;"><div style="display: inline-block; color: rgb(203, 75, 22);"><span class="string-value" style="cursor: default;">"AkAUSJg1v9xYT3HUxdALH7NsrC6owmwoZuP9MLw8fxTL"</span></div></div><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div></div></div><span class="brace-row"><span style="display: inline-block; cursor: pointer; font-weight: bold; color: rgb(0, 43, 54); padding-left: 3px;">}</span></span></div><div class="object-key-val" style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);"><span><span style="display: inline-block; cursor: pointer;"><div class="icon-container" style="display: inline-block; width: 17px;"><span class="expanded-icon"><svg style="vertical-align: top; color: rgb(88, 110, 117); height: 1em; width: 1em; padding-left: 2px;" viewBox="0 0 15 15" fill="currentColor"><path d="M0 5l6 6 6-6z"></path></svg></span></div><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;"><span class="object-key"><span>bondingCurve</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><span style="display: inline-block; cursor: pointer; font-weight: bold; color: rgb(0, 43, 54);">{</span></span><div style="display: inline-block; padding: 0px 0px 0px 10px;" class="object-meta-data"><span class="object-size" style="color: rgba(0, 0, 0, 0.3); border-radius: 3px; font-style: italic; margin: 0px 6px 0px 0px; cursor: default;">2 items</span><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div></span><div class="pushed-content object-container"><div class="object-content" style="margin-left: 6px;"><div style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);" class="variable-row"><span><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;" class="object-key"><span style="display: inline-block;">type</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><div class="variable-value" style="display: inline-block; padding-right: 6px; position: relative; cursor: default;"><div style="display: inline-block; color: rgb(203, 75, 22);"><span class="string-value" style="cursor: default;">"publicKey"</span></div></div><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div><div style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);" class="variable-row"><span><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;" class="object-key"><span style="display: inline-block;">data</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><div class="variable-value" style="display: inline-block; padding-right: 6px; position: relative; cursor: default;"><div style="display: inline-block; color: rgb(203, 75, 22);"><span class="string-value" style="cursor: default;">"9nhxvNxfSUaJddVco6oa6NodtsCscqCScp6UU1hZkfGm"</span></div></div><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div></div></div><span class="brace-row"><span style="display: inline-block; cursor: pointer; font-weight: bold; color: rgb(0, 43, 54); padding-left: 3px;">}</span></span></div><div class="object-key-val" style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);"><span><span style="display: inline-block; cursor: pointer;"><div class="icon-container" style="display: inline-block; width: 17px;"><span class="expanded-icon"><svg style="vertical-align: top; color: rgb(88, 110, 117); height: 1em; width: 1em; padding-left: 2px;" viewBox="0 0 15 15" fill="currentColor"><path d="M0 5l6 6 6-6z"></path></svg></span></div><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;"><span class="object-key"><span>user</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><span style="display: inline-block; cursor: pointer; font-weight: bold; color: rgb(0, 43, 54);">{</span></span><div style="display: inline-block; padding: 0px 0px 0px 10px;" class="object-meta-data"><span class="object-size" style="color: rgba(0, 0, 0, 0.3); border-radius: 3px; font-style: italic; margin: 0px 6px 0px 0px; cursor: default;">2 items</span><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div></span><div class="pushed-content object-container"><div class="object-content" style="margin-left: 6px;"><div style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);" class="variable-row"><span><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;" class="object-key"><span style="display: inline-block;">type</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><div class="variable-value" style="display: inline-block; padding-right: 6px; position: relative; cursor: default;"><div style="display: inline-block; color: rgb(203, 75, 22);"><span class="string-value" style="cursor: default;">"publicKey"</span></div></div><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div><div style="padding: 3px 5px 3px 20px; border-left: 1px solid rgb(195, 195, 195);" class="variable-row"><span><span style="display: inline-block; color: rgb(0, 43, 54); letter-spacing: 0.5px; vertical-align: top; opacity: 0.85;" class="object-key"><span style="display: inline-block;">data</span></span><span style="display: inline-block; margin: 0px 5px; color: rgb(0, 43, 54); vertical-align: top;">:</span></span><div class="variable-value" style="display: inline-block; padding-right: 6px; position: relative; cursor: default;"><div style="display: inline-block; color: rgb(203, 75, 22);"><span class="string-value" style="cursor: default;">"Fuy5MvbgzjSok1U8hH6mUY6WnLynzUextDxfEWMiTkn4"</span></div></div><span class="copy-to-clipboard-container" title="Copy to clipboard" style="vertical-align: top; display: none;"><span style="cursor: pointer; display: inline;"><span class="copy-icon"><svg style="vertical-align: top; color: rgb(203, 75, 22); font-size: 15px; margin-right: 3px; height: 1em; width: 1em;" viewBox="0 0 40 40" fill="currentColor" preserveAspectRatio="xMidYMid meet"><g><path d="m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z"></path></g></svg></span></span></span></div></div></div><span class="brace-row"><span style="display: inline-block; cursor: pointer; font-weight: bold; color: rgb(0, 43, 54); padding-left: 3px;">}</span></span></div></div></div><span class="brace-row"><span style="display: inline-block; cursor: pointer; font-weight: bold; color: rgb(0, 43, 54); padding-left: 3px;">}</span></span></div></div></div></div></div></div></div></div></div></div></div></div></div>"""
def get_create_map():
  return [{'instruction_number': '1', 'instruction_name': 'Mint', 'token_address': 'AkAUSJg1v9xYT3HUxdALH7NsrC6owmwoZuP9MLw8fxTL', 'token_name': '3CAT'}, {'instruction_number': '2', 'instruction_name': 'Mint Authority', 'token_address': 'TSLvdd1pWpHVjahSpsvCXUbgwsL3JAcvokwaKt1eokM', 'token_name': 'Pump.fun Token Mint Authority'}, {'instruction_number': '3', 'instruction_name': 'Bonding Curve', 'token_address': '9nhxvNxfSUaJddVco6oa6NodtsCscqCScp6UU1hZkfGm', 'token_name': 'Pump.fun (3CAT) Bonding Curve'}, {'instruction_number': '4', 'instruction_name': 'Associated Bonding Curve', 'token_address': '889XLp3qvVAHpTYQmhn6cBpYSppV8Gi8E2Rgp9RH2vRy', 'token_name': 'Pump.fun (3CAT) Vault'}, {'instruction_number': '5', 'instruction_name': 'Global', 'token_address': '4wTV1YmiEkRvAtNtsSGPtUrqRYQMe5SKy2uB4Jjaxnjf', 'token_name': '4wTV1YmiEkRvAtNtsSGPtUrqRYQMe5SKy2uB4Jjaxnjf'}, {'instruction_number': '6', 'instruction_name': 'Mpl Token Metadata', 'token_address': 'metaqbxxUerdq28cj1RbAWkYQm3ybzjb6a8bt518x1s', 'token_name': 'Metaplex Token Metadata'}, {'instruction_number': '7', 'instruction_name': 'Metadata', 'token_address': 'CH41RxpjSXHqr1vfLTVYJMsfNs2fBCCWoAE13tPihXh7', 'token_name': 'CH41RxpjSXHqr1vfLTVYJMsfNs2fBCCWoAE13tPihXh7'}, {'instruction_number': '8', 'instruction_name': 'User', 'token_address': 'Fuy5MvbgzjSok1U8hH6mUY6WnLynzUextDxfEWMiTkn4', 'token_name': 'Fuy5MvbgzjSok1U8hH6mUY6WnLynzUextDxfEWMiTkn4'}, {'instruction_number': '9', 'instruction_name': 'System Program', 'token_address': '11111111111111111111111111111111', 'token_name': 'System Program'}, {'instruction_number': '10', 'instruction_name': 'Token Program', 'token_address': 'TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA', 'token_name': 'Token Program'}, {'instruction_number': '11', 'instruction_name': 'Associated Token Program', 'token_address': 'ATokenGPvbdGVxr1b2hvZbsiqW5xWH25efTNsLJA8knL', 'token_name': 'Associated Token Account Program'}, {'instruction_number': '12', 'instruction_name': 'Rent', 'token_address': 'SysvarRent111111111111111111111111111111111', 'token_name': 'Rent Program'}, {'instruction_number': '13', 'instruction_name': 'Event Authority', 'token_address': 'Ce6TQqeHC9p8KetsN6JsjHK7UTZk7nasjjnr7XxXp9F1', 'token_name': 'Ce6TQqeHC9p8KetsN6JsjHK7UTZk7nasjjnr7XxXp9F1'}, {'instruction_number': '14', 'instruction_name': 'Program', 'token_address': '6EF8rrecthR5Dkzon8Nwu78hRvfCKubJ14M5uBEwF6P', 'token_name': 'Pump.fun'}]#serialize_raw_instruction(createHtml())
def get_create_signature():
  return "dpL54KTyCPJQmm5cQmKm8nb38r9y7CGthR6D1CczTLMT5UvbxXwVy7FRzrCuHncJmGY6PqEjgiF8MTZg1YX1b7X"
def get_create_pump_map():
  return getPumpMap(signature = get_create_signature(),instruction_maps=get_create_map())
def sellHtml():
  return """<div class="flex flex-row flex-wrap justify-start grow-0 shrink-0 basis-full min-w-0 box-border -mx-4 lg:-mx-3 items-stretch gap-y-0"><div class="max-w-24/24 lg:max-w-4/24 flex-24/24 lg:flex-4/24 block relative box-border my-0 px-4 lg:px-3"><div><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5">Input Accounts</div></div></div><div class="max-w-24/24 lg:max-w-20/24 flex-24/24 lg:flex-20/24 block relative box-border my-0 px-4 lg:px-3"><div class="flex flex-col gap-2 items-stretch justify-start"><div class="flex flex-col gap-1 items-stretch justify-start"><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">#1 - Global:</div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="break-spaces-address-link"><span class=""><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/4wTV1YmiEkRvAtNtsSGPtUrqRYQMe5SKy2uB4Jjaxnjf">4wTV1YmiEkRvAtNtsSGPtUrqRYQMe5SKy2uB4Jjaxnjf</a></span><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div></div></div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">#2 - Fee Recipient:</div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class=""><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/CebN5WGQ4jvEPvsVU4EoHEpgzq1VV7AbicfhtW4xC9iM">Pump.fun Fee Account</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#1890ff] text-white h-[20px] text-[10px] leading-[20px]">Writable</div></div></div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">#3 - Mint:</div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class="whitespace-nowrap"><span class="inline-flex align-middle mr-1"><div style="min-width: 16px; max-width: 16px; height: 16px; position: relative;" class="flex align-middle"><img alt="image" referrerpolicy="no-referrer" loading="lazy" width="16" height="16" decoding="async" data-nimg="1" style="color: transparent; border-radius: 5px; position: absolute; height: 100%; object-fit: cover; left: 0px;" src="https://statics.solscan.io/cdn/imgs/s60?ref=68747470733a2f2f697066732e696f2f697066732f516d63727236556e57785866594b7951785a3469543756366161734c79686e436e433253344e5251677a4e764e72"></div></span><span class="align-middle font-normal text-neutral7 text-[14px] leading-[24px] border border-dashed box-content break-all truncate border-transparent"><div class="inline" data-state="closed"><a class="text-link border-transparent" href="/token/DwqQ44od6Jsbv3YGQvb1qq7erhSy6sD64QoURSzvfgKS">Table</a></div></span><span class="gap-2 align-middle ml-1"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div></div></div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">#4 - Bonding Curve:</div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class=""><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/B1M1LzAVvbZog4VHbLe2aS6HWR3XgDtgrwAardVRvR1t">Pump.fun (Table) Bonding Curve</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#1890ff] text-white h-[20px] text-[10px] leading-[20px]">Writable</div></div></div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">#5 - Associated Bonding Curve:</div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class=""><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/DmWgrQscSrCxQ9voAcnfgjEEvSBqfJ1SRpRM9jLXJ6Zf">Pump.fun (Table) Vault</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#1890ff] text-white h-[20px] text-[10px] leading-[20px]">Writable</div></div></div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">#6 - Associated User:</div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="break-spaces-address-link"><span class=""><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/4vpWVhicHng4EkpcxcU4vrcYKgSQNZcPugdNDEbBFHqv">4vpWVhicHng4EkpcxcU4vrcYKgSQNZcPugdNDEbBFHqv</a></span><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#1890ff] text-white h-[20px] text-[10px] leading-[20px]">Writable</div></div></div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">#7 - User:</div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="break-spaces-address-link"><span class=""><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/WjRHgtBWytAniDGzZZ7e98AUzUsBiAzDa9vHXtuKnXq">WjRHgtBWytAniDGzZZ7e98AUzUsBiAzDa9vHXtuKnXq</a></span><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#1890ff] text-white h-[20px] text-[10px] leading-[20px]">Writable</div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#c77aea] text-white h-[20px] text-[10px] leading-[20px]">Signer</div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#00c59a] text-white h-[20px] text-[10px] leading-[20px]">Fee Payer</div></div></div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">#8 - System Program:</div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class=""><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/11111111111111111111111111111111">System Program</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#e4830c] text-white h-[20px] text-[10px] leading-[20px]">Program</div></div></div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">#9 - Associated Token Program:</div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class=""><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/ATokenGPvbdGVxr1b2hvZbsiqW5xWH25efTNsLJA8knL">Associated Token Account Program</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div></div></div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">#10 - Token Program:</div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class=""><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA">Token Program</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#e4830c] text-white h-[20px] text-[10px] leading-[20px]">Program</div></div></div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">#11 - Event Authority:</div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="break-spaces-address-link"><span class=""><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/Ce6TQqeHC9p8KetsN6JsjHK7UTZk7nasjjnr7XxXp9F1">Ce6TQqeHC9p8KetsN6JsjHK7UTZk7nasjjnr7XxXp9F1</a></span><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div></div></div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class="not-italic font-normal text-[14px] leading-[24px] text-neutral5 capitalize">#12 - Program:</div><div class="flex gap-2 flex-row items-center justify-start flex-wrap"><div class=""><span class=""><div class="inline" data-state="closed"><span class="align-middle font-normal text-[14px] leading-[24px] border box-content break-all border-none"><a class="text-link" href="/account/6EF8rrecthR5Dkzon8Nwu78hRvfCKubJ14M5uBEwF6P">Pump.fun</a></span></div><span class="ml-1 gap-2 align-middle"><div class="inline-flex align-middle" data-state="closed"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 12 12" fill="none" class="cursor-pointer text-neutral5 hover:text-link"><path d="M3.5 8.5H2.25C1.91848 8.5 1.60054 8.3683 1.36612 8.13388C1.1317 7.89946 1 7.58152 1 7.25V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1H7.25C7.58152 1 7.89946 1.1317 8.13388 1.36612C8.3683 1.60054 8.5 1.91848 8.5 2.25V3.5" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.25 11H4.75C4.41848 11 4.10054 10.8683 3.86612 10.6339C3.6317 10.3995 3.5 10.0815 3.5 9.75V4.75C3.5 4.41848 3.6317 4.10054 3.86612 3.86612C4.10054 3.6317 4.41848 3.5 4.75 3.5H9.75C10.0815 3.5 10.3995 3.6317 10.6339 3.86612C10.8683 4.10054 11 4.41848 11 4.75V7.25" stroke="#8B8B8B" stroke-linecap="round" stroke-linejoin="round"></path><rect x="3.5" y="3.5" width="7.5" height="7.5" rx="1" stroke="#8B8B8B"></rect></svg></div></span></span></div><div class="flex justify-center items-center rounded-full border px-2.5 py-0.5 font-semibold transition-colors flex-nowrap w-max bg-[#e4830c] text-white h-[20px] text-[10px] leading-[20px]">Program</div></div></div></div></div></div></div>"""
def get_sell_map():
  return serialize_raw_instruction(sellHtml())#[{'instruction_number': '1', 'instruction_name': 'Global', 'token_address': '4wTV1YmiEkRvAtNtsSGPtUrqRYQMe5SKy2uB4Jjaxnjf', 'token_name': '4wTV1YmiEkRvAtNtsSGPtUrqRYQMe5SKy2uB4Jjaxnjf'}, {'instruction_number': '2', 'instruction_name': 'Fee Recipient', 'token_address': 'CebN5WGQ4jvEPvsVU4EoHEpgzq1VV7AbicfhtW4xC9iM', 'token_name': 'Pump.fun Fee Account'}, {'instruction_number': '3', 'instruction_name': 'Mint', 'token_address': 'DwqQ44od6Jsbv3YGQvb1qq7erhSy6sD64QoURSzvfgKS', 'token_name': 'Table'}, {'instruction_number': '4', 'instruction_name': 'Bonding Curve', 'token_address': 'B1M1LzAVvbZog4VHbLe2aS6HWR3XgDtgrwAardVRvR1t', 'token_name': 'Pump.fun (Table) Bonding Curve'}, {'instruction_number': '5', 'instruction_name': 'Associated Bonding Curve', 'token_address': 'DmWgrQscSrCxQ9voAcnfgjEEvSBqfJ1SRpRM9jLXJ6Zf', 'token_name': 'Pump.fun (Table) Vault'}, {'instruction_number': '6', 'instruction_name': 'Associated User', 'token_address': '5S2QhCMP3stybCMAcf8uEo8zJo9rBUDFfg77yxk9inrr', 'token_name': '5S2QhCMP3stybCMAcf8uEo8zJo9rBUDFfg77yxk9inrr'}, {'instruction_number': '7', 'instruction_name': 'User', 'token_address': '3iQoMNErFMTX36uYh1BWshXkmBBu6DnqpwnwyJsAUKMC', 'token_name': '3iQoMNErFMTX36uYh1BWshXkmBBu6DnqpwnwyJsAUKMC'}, {'instruction_number': '8', 'instruction_name': 'System Program', 'token_address': '11111111111111111111111111111111', 'token_name': 'System Program'}, {'instruction_number': '9', 'instruction_name': 'Associated Token Program', 'token_address': 'ATokenGPvbdGVxr1b2hvZbsiqW5xWH25efTNsLJA8knL', 'token_name': 'Associated Token Account Program'}, {'instruction_number': '10', 'instruction_name': 'Token Program', 'token_address': 'TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA', 'token_name': 'Token Program'}, {'instruction_number': '11', 'instruction_name': 'Event Authority', 'token_address': 'Ce6TQqeHC9p8KetsN6JsjHK7UTZk7nasjjnr7XxXp9F1', 'token_name': 'Ce6TQqeHC9p8KetsN6JsjHK7UTZk7nasjjnr7XxXp9F1'}, {'instruction_number': '12', 'instruction_name': 'Program', 'token_address': '6EF8rrecthR5Dkzon8Nwu78hRvfCKubJ14M5uBEwF6P', 'token_name': 'Pump.fun'}]
def get_sell_signature():
  return "4pE74Lb5zVXHTzkRUo9YzzA9ra24aJbxUZcAzq6Hx7hnoJGVQ2WxKnbC2HiCZgYF4qSFBwLt2PtvsQsM4XZup8sZ"
def get_sell_pump_map():
  return getPumpMap(signature = get_sell_signature(),instruction_maps=get_sell_map())
def get_buy_map():
  return [{'instruction_number': '1', 'instruction_name': 'Global', 'token_address': '4wTV1YmiEkRvAtNtsSGPtUrqRYQMe5SKy2uB4Jjaxnjf', 'token_name': '4wTV1YmiEkRvAtNtsSGPtUrqRYQMe5SKy2uB4Jjaxnjf'}, {'instruction_number': '2', 'instruction_name': 'Fee Recipient', 'token_address': 'CebN5WGQ4jvEPvsVU4EoHEpgzq1VV7AbicfhtW4xC9iM', 'token_name': 'Pump.fun Fee Account'}, {'instruction_number': '3', 'instruction_name': 'Mint', 'token_address': 'DwqQ44od6Jsbv3YGQvb1qq7erhSy6sD64QoURSzvfgKS', 'token_name': 'Table'}, {'instruction_number': '4', 'instruction_name': 'Bonding Curve', 'token_address': 'B1M1LzAVvbZog4VHbLe2aS6HWR3XgDtgrwAardVRvR1t', 'token_name': 'Pump.fun (Table) Bonding Curve'}, {'instruction_number': '5', 'instruction_name': 'Associated Bonding Curve', 'token_address': 'DmWgrQscSrCxQ9voAcnfgjEEvSBqfJ1SRpRM9jLXJ6Zf', 'token_name': 'Pump.fun (Table) Vault'}, {'instruction_number': '6', 'instruction_name': 'Associated User', 'token_address': '4vpWVhicHng4EkpcxcU4vrcYKgSQNZcPugdNDEbBFHqv', 'token_name': '4vpWVhicHng4EkpcxcU4vrcYKgSQNZcPugdNDEbBFHqv'}, {'instruction_number': '7', 'instruction_name': 'User', 'token_address': 'WjRHgtBWytAniDGzZZ7e98AUzUsBiAzDa9vHXtuKnXq', 'token_name': 'WjRHgtBWytAniDGzZZ7e98AUzUsBiAzDa9vHXtuKnXq'}, {'instruction_number': '8', 'instruction_name': 'System Program', 'token_address': '11111111111111111111111111111111', 'token_name': 'System Program'}, {'instruction_number': '9', 'instruction_name': 'Token Program', 'token_address': 'TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA', 'token_name': 'Token Program'}, {'instruction_number': '10', 'instruction_name': 'Rent', 'token_address': 'SysvarRent111111111111111111111111111111111', 'token_name': 'Rent Program'}, {'instruction_number': '11', 'instruction_name': 'Event Authority', 'token_address': 'Ce6TQqeHC9p8KetsN6JsjHK7UTZk7nasjjnr7XxXp9F1', 'token_name': 'Ce6TQqeHC9p8KetsN6JsjHK7UTZk7nasjjnr7XxXp9F1'}, {'instruction_number': '12', 'instruction_name': 'Program', 'token_address': '6EF8rrecthR5Dkzon8Nwu78hRvfCKubJ14M5uBEwF6P', 'token_name': 'Pump.fun'}]
def get_buy_signature():
  return "4pE74Lb5zVXHTzkRUo9YzzA9ra24aJbxUZcAzq6Hx7hnoJGVQ2WxKnbC2HiCZgYF4qSFBwLt2PtvsQsM4XZup8sZ"
def get_buy_pump_map():
  return getPumpMap(signature = get_buy_signature(),instruction_maps=get_buy_map())

def build_instructions_template(txnData,instruction_maps=None,printIt=False,saveIt=False):
  instruction_maps = instruction_maps or get_instruction_map()
  instructions = get_instructions_catalog(txnData,printIt=printIt,saveIt=saveIt)
  new_token_js = {}

  for j,instruction_map in enumerate(instruction_maps):
    addressType = instruction_map.get('instruction_name')
    address = instruction_map.get('token_address')
    instruction_maps[j]["catalog"]=[]
    found = False
    for instruction in instructions:
      inst_accounts = instruction.get('accounts')
      if address in inst_accounts:
        for i,inst_address in enumerate(inst_accounts):
          if inst_address == address:
            if found:
              if printIt:
                print(f"another catalog found for {address}")
            else:
              if printIt:
                print(f"#{j} - {addressType} FOUND")
            found = True
            if printIt:
              print(f"{addressType} found")
              print(f"event {instruction.get('events')}")
              print(f"accountKey {i}")
              print(f"programId {instruction.get('programId')}\n")
            instruction_maps[j]["catalog"].append({"index":i,"catalog":instruction})
    if found == False:
      print(f"#{addressType} NOT FOUND")
    j+=1
  return instruction_maps
def getPumpMap(signature = None,instruction_maps=None):
  signature = signature or get_create_signature()
  txnData = getTransaction(signature=signature)
  instruction_maps = instruction_maps or get_create_map()
  instruction_maps = build_instructions_template(txnData,instruction_maps=instruction_maps,printIt=False,saveIt=False)
  new_maps = []
  for instruction_map in instruction_maps:
    address = instruction_map.get('token_address')
    name = instruction_map.get('token_name')
    instruction_name = instruction_map.get('instruction_name')
    instruction_index = instruction_map.get('instruction_number')
    getEvent={}
    for catalogs in instruction_map.get('catalog'):
      account_index= catalogs.get('index')
      catalog = catalogs.get('catalog')
      events = catalog.get('events')
      accounts = catalog.get('accounts')
      if events:
        if accounts[account_index] == address:
          getEvent = {"event":events[0],"account":account_index,"address_type":instruction_name}
          if events[0] != 'Create':
            break
    new_maps.append(getEvent)
  return new_maps
def getTxnTypes(signature,maps=None):
  maps = maps or get_create_pump_map()
  token_types = {}
  txnData = getTransaction(signature)
  instructions = get_instructions_catalog(txnData,printIt=False,saveIt=False)
  for new_map in maps:
    for instruction in instructions:
      if new_map.get('event') in instruction.get('events'):
        account = instruction.get('accounts')[new_map.get('account')]
        token_types[new_map.get('address_type')]=account
        break
  return token_types

def get_bonding_curve(mint):
  bonding_curve_vault = derive_bonding_curve_accounts(mint)
  if bonding_curve_vault:
    return {'Bonding Curve':bonding_curve_vault[0],'Associated Bonding Curve':bonding_curve_vault[1]}
  SignaturesFromAddress = getSignaturesForAddress(mint)
  for SignatureFromAddress in SignaturesFromAddress:
    signature = SignatureFromAddress.get('signature')
    txnData = getTransaction(signature=signature)
    bonding_curve_vault=None
    try:
      instructions = get_instructions_catalog(txnData)
      for instruction in instructions:
        events = instruction.get('events')
        if 'Sell' in events or 'Buy' in events:
          bonding_curve_vault = instruction['accounts'][4]
          return bonding_curve_vault
    except:
      pass
  return bonding_curve_vault
def getTxnTypesFromMint(mint,bonding_curve_vault=None):
  bonding_curve_vault = bonding_curve_vault or get_bonding_curve(mint)
  creation_signature = getGenesisSignature(bonding_curve_vault)
  txnTypes = getTxnTypes(creation_signature,maps=get_create_pump_map())
  txnTypes['signature']=creation_signature
  return txnTypes
def get_virtual_reserves(bonding_curve: Pubkey):
    bonding_curve_struct = Struct(
        Padding(8),
        "virtualTokenReserves" / Int64ul,
        "virtualSolReserves" / Int64ul,
        "realTokenReserves" / Int64ul,
        "realSolReserves" / Int64ul,
        "tokenTotalSupply" / Int64ul,
        "complete" / Flag
    )
    account_info = getAccountInfo(str(bonding_curve))
    if not account_info or 'value' not in account_info or 'data' not in account_info['value']:
        print("Failed to retrieve account info.")
        return None
    data_base64 = account_info['value']['data'][0]
    data = base64.b64decode(data_base64)
    parsed_data = bonding_curve_struct.parse(data)
    return parsed_data
def get_pubKey(address):
    if isinstance(address,Pubkey):
        pubkey = address
    else:
        address = str(address)
    if isinstance(address,str):
        try:
            pubkey= Pubkey.from_string(str(address))
        except:
            pubkey = address
    return pubkey
def derive_associated_bonding_curve(bonding_curve,mint):
    return get_associated_token_address(bonding_curve, get_pubKey(mint))
def derive_bonding_curve(mint):
    return Pubkey.find_program_address(["bonding-curve".encode(), bytes(get_pubKey(mint))],PUMP_FUN_PROGRAM)
def change_keys_lower(dictObj):
    newDictObj={}
    for key,value in dictObj.items():
        newDictObj[key.lower().replace(' ','_')]=value
    return newDictObj
def derive_bonding_curve_accounts(mint_str: str):
    try:
        mint = get_pubKey(mint_str)
        bonding_curve, _ = derive_bonding_curve(mint)
        
    except Exception:
        bonding_curve = get_bonding_curve(mint_str)
    associated_bonding_curve = get_associated_token_address(bonding_curve, mint)
    return {'bonding_curve':bonding_curve,"associated_bonding_curve":associated_bonding_curve}


def get_pump_fun_data(mint_str: str):
    bonding_curves = derive_bonding_curve_accounts(mint_str)
    bonding_curve = bonding_curves['bonding_curve']
    associated_bonding_curve = bonding_curves['associated_bonding_curve']
    if bonding_curve is None or associated_bonding_curve is None:
        return None
    txnTypes = change_keys_lower(getTxnTypesFromMint(mint_str,bonding_curve))
    virtual_reserves = get_virtual_reserves(bonding_curve)
    if virtual_reserves is None:
        return None
    
    virtual_token_reserves = int(virtual_reserves.virtualTokenReserves)
    virtual_sol_reserves = int(virtual_reserves.virtualSolReserves)
    token_total_supply = int(virtual_reserves.tokenTotalSupply)
    complete = bool(virtual_reserves.complete)
    
    txnTypes.update({
        "mint": mint_str,
        "bonding_curve": str(bonding_curve),
        "associated_bonding_curve": str(associated_bonding_curve),
        "virtual_token_reserves": virtual_token_reserves,
        "virtual_sol_reserves": virtual_sol_reserves,
        "token_total_supply": token_total_supply,
        "complete": complete
    })
    return txnTypes
