"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsCdkConstructLibrary = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const projen_1 = require("projen");
class AwsCdkConstructLibrary extends projen_1.awscdk.AwsCdkConstructLibrary {
    /**
     * @experimental
     */
    constructor(options) {
        super({
            ...options,
            authorOrganization: true,
            license: "MIT",
            copyrightOwner: "Pepperize UG (haftungsbeschränkt)",
            autoApproveUpgrades: true,
            autoApproveOptions: {
                ...options.autoApproveOptions,
                allowedUsernames: ["pflorek", "acfo", "dependabot[bot]"],
                label: "auto-approve",
                secret: "GITHUB_TOKEN",
            },
            depsUpgradeOptions: {
                ...options.depsUpgradeOptions,
                workflowOptions: {
                    ...options.depsUpgradeOptions?.workflowOptions,
                },
            },
            dependabot: true,
            dependabotOptions: {
                labels: ["auto-approve"],
            },
            eslint: true,
            prettier: true,
            prettierOptions: {
                ...options.prettierOptions,
                settings: {
                    ...options.prettierOptions?.settings,
                    printWidth: 120,
                },
            },
            defaultReleaseBranch: "main",
            npmAccess: projen_1.javascript.NpmAccess.PUBLIC,
            release: true,
            staleOptions: {
                pullRequest: {
                    daysBeforeStale: 90,
                    daysBeforeClose: 30,
                    ...options.staleOptions?.pullRequest,
                },
                issues: {
                    daysBeforeStale: 180,
                    daysBeforeClose: 30,
                    ...options.staleOptions?.pullRequest,
                },
                ...options.staleOptions,
            },
            gitignore: [...(options.gitignore || [])],
        });
        this.addDevDeps("ts-node@^10");
        this.gitignore.exclude(".idea/", "*.iml", ".vscode/");
        this.prettier?.addIgnorePattern("API.md");
        this.formatTask = this.addTask("format", {
            description: "Format with prettier",
            exec: "prettier --write src/**/*.ts test/**/*.ts .projenrc.[jt]s README.md",
        });
        // https://editorconfig.org/#file-format-details
        new projen_1.IniFile(this, ".editorconfig", {
            obj: {
                ["root"]: true,
                ["*"]: {
                    ["end_of_line"]: "lf",
                    ["charset"]: "utf-8",
                },
                ["*.{js,ts}"]: {
                    ["indent_style"]: "space",
                    ["indent_size"]: 2,
                    ["max_line_length"]: 120,
                },
            },
            marker: true,
        });
    }
}
exports.AwsCdkConstructLibrary = AwsCdkConstructLibrary;
_a = JSII_RTTI_SYMBOL_1;
AwsCdkConstructLibrary[_a] = { fqn: "@pepperize/projen-awscdk-construct.AwsCdkConstructLibrary", version: "0.0.266" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSxtQ0FBMkQ7QUFFM0QsTUFBYSxzQkFBdUIsU0FBUSxlQUFNLENBQUMsc0JBQXNCO0lBTXZFOztPQUVHO0lBQ0gsWUFBWSxPQUE2QztRQUN2RCxLQUFLLENBQUM7WUFDSixHQUFHLE9BQU87WUFDVixrQkFBa0IsRUFBRSxJQUFJO1lBQ3hCLE9BQU8sRUFBRSxLQUFLO1lBQ2QsY0FBYyxFQUFFLG1DQUFtQztZQUNuRCxtQkFBbUIsRUFBRSxJQUFJO1lBQ3pCLGtCQUFrQixFQUFFO2dCQUNsQixHQUFHLE9BQU8sQ0FBQyxrQkFBa0I7Z0JBQzdCLGdCQUFnQixFQUFFLENBQUMsU0FBUyxFQUFFLE1BQU0sRUFBRSxpQkFBaUIsQ0FBQztnQkFDeEQsS0FBSyxFQUFFLGNBQWM7Z0JBQ3JCLE1BQU0sRUFBRSxjQUFjO2FBQ3ZCO1lBQ0Qsa0JBQWtCLEVBQUU7Z0JBQ2xCLEdBQUcsT0FBTyxDQUFDLGtCQUFrQjtnQkFDN0IsZUFBZSxFQUFFO29CQUNmLEdBQUcsT0FBTyxDQUFDLGtCQUFrQixFQUFFLGVBQWU7aUJBQy9DO2FBQ0Y7WUFDRCxVQUFVLEVBQUUsSUFBSTtZQUNoQixpQkFBaUIsRUFBRTtnQkFDakIsTUFBTSxFQUFFLENBQUMsY0FBYyxDQUFDO2FBQ3pCO1lBQ0QsTUFBTSxFQUFFLElBQUk7WUFDWixRQUFRLEVBQUUsSUFBSTtZQUNkLGVBQWUsRUFBRTtnQkFDZixHQUFHLE9BQU8sQ0FBQyxlQUFlO2dCQUMxQixRQUFRLEVBQUU7b0JBQ1IsR0FBRyxPQUFPLENBQUMsZUFBZSxFQUFFLFFBQVE7b0JBQ3BDLFVBQVUsRUFBRSxHQUFHO2lCQUNoQjthQUNGO1lBQ0Qsb0JBQW9CLEVBQUUsTUFBTTtZQUM1QixTQUFTLEVBQUUsbUJBQVUsQ0FBQyxTQUFTLENBQUMsTUFBTTtZQUN0QyxPQUFPLEVBQUUsSUFBSTtZQUNiLFlBQVksRUFBRTtnQkFDWixXQUFXLEVBQUU7b0JBQ1gsZUFBZSxFQUFFLEVBQUU7b0JBQ25CLGVBQWUsRUFBRSxFQUFFO29CQUNuQixHQUFHLE9BQU8sQ0FBQyxZQUFZLEVBQUUsV0FBVztpQkFDckM7Z0JBQ0QsTUFBTSxFQUFFO29CQUNOLGVBQWUsRUFBRSxHQUFHO29CQUNwQixlQUFlLEVBQUUsRUFBRTtvQkFDbkIsR0FBRyxPQUFPLENBQUMsWUFBWSxFQUFFLFdBQVc7aUJBQ3JDO2dCQUNELEdBQUcsT0FBTyxDQUFDLFlBQVk7YUFDeEI7WUFDRCxTQUFTLEVBQUUsQ0FBQyxHQUFHLENBQUMsT0FBTyxDQUFDLFNBQVMsSUFBSSxFQUFFLENBQUMsQ0FBQztTQUMxQyxDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQyxDQUFDO1FBRS9CLElBQUksQ0FBQyxTQUFTLENBQUMsT0FBTyxDQUFDLFFBQVEsRUFBRSxPQUFPLEVBQUUsVUFBVSxDQUFDLENBQUM7UUFFdEQsSUFBSSxDQUFDLFFBQVEsRUFBRSxnQkFBZ0IsQ0FBQyxRQUFRLENBQUMsQ0FBQztRQUUxQyxJQUFJLENBQUMsVUFBVSxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsUUFBUSxFQUFFO1lBQ3ZDLFdBQVcsRUFBRSxzQkFBc0I7WUFDbkMsSUFBSSxFQUFFLHFFQUFxRTtTQUM1RSxDQUFDLENBQUM7UUFFSCxnREFBZ0Q7UUFDaEQsSUFBSSxnQkFBTyxDQUFDLElBQUksRUFBRSxlQUFlLEVBQUU7WUFDakMsR0FBRyxFQUFFO2dCQUNILENBQUMsTUFBTSxDQUFDLEVBQUUsSUFBSTtnQkFDZCxDQUFDLEdBQUcsQ0FBQyxFQUFFO29CQUNMLENBQUMsYUFBYSxDQUFDLEVBQUUsSUFBSTtvQkFDckIsQ0FBQyxTQUFTLENBQUMsRUFBRSxPQUFPO2lCQUNyQjtnQkFDRCxDQUFDLFdBQVcsQ0FBQyxFQUFFO29CQUNiLENBQUMsY0FBYyxDQUFDLEVBQUUsT0FBTztvQkFDekIsQ0FBQyxhQUFhLENBQUMsRUFBRSxDQUFDO29CQUNsQixDQUFDLGlCQUFpQixDQUFDLEVBQUUsR0FBRztpQkFDekI7YUFDRjtZQUNELE1BQU0sRUFBRSxJQUFJO1NBQ2IsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7QUF2Rkgsd0RBd0ZDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgYXdzY2RrLCBJbmlGaWxlLCBqYXZhc2NyaXB0LCBUYXNrIH0gZnJvbSBcInByb2plblwiO1xuXG5leHBvcnQgY2xhc3MgQXdzQ2RrQ29uc3RydWN0TGlicmFyeSBleHRlbmRzIGF3c2Nkay5Bd3NDZGtDb25zdHJ1Y3RMaWJyYXJ5IHtcbiAgLyoqXG4gICAqIFRoZSBcImZvcm1hdFwiIHRhc2suXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgZm9ybWF0VGFzazogVGFzaztcblxuICAvKipcbiAgICogQGV4cGVyaW1lbnRhbFxuICAgKi9cbiAgY29uc3RydWN0b3Iob3B0aW9uczogYXdzY2RrLkF3c0Nka0NvbnN0cnVjdExpYnJhcnlPcHRpb25zKSB7XG4gICAgc3VwZXIoe1xuICAgICAgLi4ub3B0aW9ucyxcbiAgICAgIGF1dGhvck9yZ2FuaXphdGlvbjogdHJ1ZSxcbiAgICAgIGxpY2Vuc2U6IFwiTUlUXCIsXG4gICAgICBjb3B5cmlnaHRPd25lcjogXCJQZXBwZXJpemUgVUcgKGhhZnR1bmdzYmVzY2hyw6Rua3QpXCIsXG4gICAgICBhdXRvQXBwcm92ZVVwZ3JhZGVzOiB0cnVlLFxuICAgICAgYXV0b0FwcHJvdmVPcHRpb25zOiB7XG4gICAgICAgIC4uLm9wdGlvbnMuYXV0b0FwcHJvdmVPcHRpb25zLFxuICAgICAgICBhbGxvd2VkVXNlcm5hbWVzOiBbXCJwZmxvcmVrXCIsIFwiYWNmb1wiLCBcImRlcGVuZGFib3RbYm90XVwiXSxcbiAgICAgICAgbGFiZWw6IFwiYXV0by1hcHByb3ZlXCIsXG4gICAgICAgIHNlY3JldDogXCJHSVRIVUJfVE9LRU5cIixcbiAgICAgIH0sXG4gICAgICBkZXBzVXBncmFkZU9wdGlvbnM6IHtcbiAgICAgICAgLi4ub3B0aW9ucy5kZXBzVXBncmFkZU9wdGlvbnMsXG4gICAgICAgIHdvcmtmbG93T3B0aW9uczoge1xuICAgICAgICAgIC4uLm9wdGlvbnMuZGVwc1VwZ3JhZGVPcHRpb25zPy53b3JrZmxvd09wdGlvbnMsXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgICAgZGVwZW5kYWJvdDogdHJ1ZSxcbiAgICAgIGRlcGVuZGFib3RPcHRpb25zOiB7XG4gICAgICAgIGxhYmVsczogW1wiYXV0by1hcHByb3ZlXCJdLFxuICAgICAgfSxcbiAgICAgIGVzbGludDogdHJ1ZSxcbiAgICAgIHByZXR0aWVyOiB0cnVlLFxuICAgICAgcHJldHRpZXJPcHRpb25zOiB7XG4gICAgICAgIC4uLm9wdGlvbnMucHJldHRpZXJPcHRpb25zLFxuICAgICAgICBzZXR0aW5nczoge1xuICAgICAgICAgIC4uLm9wdGlvbnMucHJldHRpZXJPcHRpb25zPy5zZXR0aW5ncyxcbiAgICAgICAgICBwcmludFdpZHRoOiAxMjAsXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgICAgZGVmYXVsdFJlbGVhc2VCcmFuY2g6IFwibWFpblwiLFxuICAgICAgbnBtQWNjZXNzOiBqYXZhc2NyaXB0Lk5wbUFjY2Vzcy5QVUJMSUMsXG4gICAgICByZWxlYXNlOiB0cnVlLFxuICAgICAgc3RhbGVPcHRpb25zOiB7XG4gICAgICAgIHB1bGxSZXF1ZXN0OiB7XG4gICAgICAgICAgZGF5c0JlZm9yZVN0YWxlOiA5MCxcbiAgICAgICAgICBkYXlzQmVmb3JlQ2xvc2U6IDMwLFxuICAgICAgICAgIC4uLm9wdGlvbnMuc3RhbGVPcHRpb25zPy5wdWxsUmVxdWVzdCxcbiAgICAgICAgfSxcbiAgICAgICAgaXNzdWVzOiB7XG4gICAgICAgICAgZGF5c0JlZm9yZVN0YWxlOiAxODAsXG4gICAgICAgICAgZGF5c0JlZm9yZUNsb3NlOiAzMCxcbiAgICAgICAgICAuLi5vcHRpb25zLnN0YWxlT3B0aW9ucz8ucHVsbFJlcXVlc3QsXG4gICAgICAgIH0sXG4gICAgICAgIC4uLm9wdGlvbnMuc3RhbGVPcHRpb25zLFxuICAgICAgfSxcbiAgICAgIGdpdGlnbm9yZTogWy4uLihvcHRpb25zLmdpdGlnbm9yZSB8fCBbXSldLFxuICAgIH0pO1xuXG4gICAgdGhpcy5hZGREZXZEZXBzKFwidHMtbm9kZUBeMTBcIik7XG5cbiAgICB0aGlzLmdpdGlnbm9yZS5leGNsdWRlKFwiLmlkZWEvXCIsIFwiKi5pbWxcIiwgXCIudnNjb2RlL1wiKTtcblxuICAgIHRoaXMucHJldHRpZXI/LmFkZElnbm9yZVBhdHRlcm4oXCJBUEkubWRcIik7XG5cbiAgICB0aGlzLmZvcm1hdFRhc2sgPSB0aGlzLmFkZFRhc2soXCJmb3JtYXRcIiwge1xuICAgICAgZGVzY3JpcHRpb246IFwiRm9ybWF0IHdpdGggcHJldHRpZXJcIixcbiAgICAgIGV4ZWM6IFwicHJldHRpZXIgLS13cml0ZSBzcmMvKiovKi50cyB0ZXN0LyoqLyoudHMgLnByb2plbnJjLltqdF1zIFJFQURNRS5tZFwiLFxuICAgIH0pO1xuXG4gICAgLy8gaHR0cHM6Ly9lZGl0b3Jjb25maWcub3JnLyNmaWxlLWZvcm1hdC1kZXRhaWxzXG4gICAgbmV3IEluaUZpbGUodGhpcywgXCIuZWRpdG9yY29uZmlnXCIsIHtcbiAgICAgIG9iajoge1xuICAgICAgICBbXCJyb290XCJdOiB0cnVlLFxuICAgICAgICBbXCIqXCJdOiB7XG4gICAgICAgICAgW1wiZW5kX29mX2xpbmVcIl06IFwibGZcIixcbiAgICAgICAgICBbXCJjaGFyc2V0XCJdOiBcInV0Zi04XCIsXG4gICAgICAgIH0sXG4gICAgICAgIFtcIioue2pzLHRzfVwiXToge1xuICAgICAgICAgIFtcImluZGVudF9zdHlsZVwiXTogXCJzcGFjZVwiLFxuICAgICAgICAgIFtcImluZGVudF9zaXplXCJdOiAyLFxuICAgICAgICAgIFtcIm1heF9saW5lX2xlbmd0aFwiXTogMTIwLFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICAgIG1hcmtlcjogdHJ1ZSxcbiAgICB9KTtcbiAgfVxufVxuIl19