# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from typing import Dict
from Tea.core import TeaCore

from alibabacloud_tea_openapi.client import Client as OpenApiClient
from alibabacloud_tea_openapi import models as open_api_models
from alibabacloud_tea_util.client import Client as UtilClient
from alibabacloud_endpoint_util.client import Client as EndpointUtilClient
from alibabacloud_devops20210625 import models as devops_20210625_models
from alibabacloud_tea_util import models as util_models
from alibabacloud_openapi_util.client import Client as OpenApiUtilClient


class Client(OpenApiClient):
    """
    *\
    """
    def __init__(
        self, 
        config: open_api_models.Config,
    ):
        super().__init__(config)
        self._endpoint_rule = ''
        self.check_config(config)
        self._endpoint = self.get_endpoint('devops', self._region_id, self._endpoint_rule, self._network, self._suffix, self._endpoint_map, self._endpoint)

    def get_endpoint(
        self,
        product_id: str,
        region_id: str,
        endpoint_rule: str,
        network: str,
        suffix: str,
        endpoint_map: Dict[str, str],
        endpoint: str,
    ) -> str:
        if not UtilClient.empty(endpoint):
            return endpoint
        if not UtilClient.is_unset(endpoint_map) and not UtilClient.empty(endpoint_map.get(region_id)):
            return endpoint_map.get(region_id)
        return EndpointUtilClient.get_endpoint_rules(product_id, region_id, endpoint_rule, network, suffix)

    def add_group_member_with_options(
        self,
        group_id: str,
        request: devops_20210625_models.AddGroupMemberRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.AddGroupMemberResponse:
        """
        @summary 添加组成员
        
        @param request: AddGroupMemberRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddGroupMemberResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.access_level):
            body['accessLevel'] = request.access_level
        if not UtilClient.is_unset(request.aliyun_pks):
            body['aliyunPks'] = request.aliyun_pks
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='AddGroupMember',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/groups/{OpenApiUtilClient.get_encode_param(group_id)}/members/create',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.AddGroupMemberResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_group_member_with_options_async(
        self,
        group_id: str,
        request: devops_20210625_models.AddGroupMemberRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.AddGroupMemberResponse:
        """
        @summary 添加组成员
        
        @param request: AddGroupMemberRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddGroupMemberResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.access_level):
            body['accessLevel'] = request.access_level
        if not UtilClient.is_unset(request.aliyun_pks):
            body['aliyunPks'] = request.aliyun_pks
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='AddGroupMember',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/groups/{OpenApiUtilClient.get_encode_param(group_id)}/members/create',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.AddGroupMemberResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_group_member(
        self,
        group_id: str,
        request: devops_20210625_models.AddGroupMemberRequest,
    ) -> devops_20210625_models.AddGroupMemberResponse:
        """
        @summary 添加组成员
        
        @param request: AddGroupMemberRequest
        @return: AddGroupMemberResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.add_group_member_with_options(group_id, request, headers, runtime)

    async def add_group_member_async(
        self,
        group_id: str,
        request: devops_20210625_models.AddGroupMemberRequest,
    ) -> devops_20210625_models.AddGroupMemberResponse:
        """
        @summary 添加组成员
        
        @param request: AddGroupMemberRequest
        @return: AddGroupMemberResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.add_group_member_with_options_async(group_id, request, headers, runtime)

    def add_pipeline_relations_with_options(
        self,
        organization_id: str,
        pipeline_id: str,
        request: devops_20210625_models.AddPipelineRelationsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.AddPipelineRelationsResponse:
        """
        @summary 添加流水线关联
        
        @param request: AddPipelineRelationsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddPipelineRelationsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.rel_object_ids):
            query['relObjectIds'] = request.rel_object_ids
        if not UtilClient.is_unset(request.rel_object_type):
            query['relObjectType'] = request.rel_object_type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddPipelineRelations',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/{OpenApiUtilClient.get_encode_param(pipeline_id)}/pipelineRelations',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.AddPipelineRelationsResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_pipeline_relations_with_options_async(
        self,
        organization_id: str,
        pipeline_id: str,
        request: devops_20210625_models.AddPipelineRelationsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.AddPipelineRelationsResponse:
        """
        @summary 添加流水线关联
        
        @param request: AddPipelineRelationsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddPipelineRelationsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.rel_object_ids):
            query['relObjectIds'] = request.rel_object_ids
        if not UtilClient.is_unset(request.rel_object_type):
            query['relObjectType'] = request.rel_object_type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddPipelineRelations',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/{OpenApiUtilClient.get_encode_param(pipeline_id)}/pipelineRelations',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.AddPipelineRelationsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_pipeline_relations(
        self,
        organization_id: str,
        pipeline_id: str,
        request: devops_20210625_models.AddPipelineRelationsRequest,
    ) -> devops_20210625_models.AddPipelineRelationsResponse:
        """
        @summary 添加流水线关联
        
        @param request: AddPipelineRelationsRequest
        @return: AddPipelineRelationsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.add_pipeline_relations_with_options(organization_id, pipeline_id, request, headers, runtime)

    async def add_pipeline_relations_async(
        self,
        organization_id: str,
        pipeline_id: str,
        request: devops_20210625_models.AddPipelineRelationsRequest,
    ) -> devops_20210625_models.AddPipelineRelationsResponse:
        """
        @summary 添加流水线关联
        
        @param request: AddPipelineRelationsRequest
        @return: AddPipelineRelationsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.add_pipeline_relations_with_options_async(organization_id, pipeline_id, request, headers, runtime)

    def add_repository_member_with_options(
        self,
        repository_id: str,
        request: devops_20210625_models.AddRepositoryMemberRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.AddRepositoryMemberResponse:
        """
        @summary 添加代码库成员
        
        @param request: AddRepositoryMemberRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddRepositoryMemberResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.access_level):
            body['accessLevel'] = request.access_level
        if not UtilClient.is_unset(request.aliyun_pks):
            body['aliyunPks'] = request.aliyun_pks
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='AddRepositoryMember',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/members',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.AddRepositoryMemberResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_repository_member_with_options_async(
        self,
        repository_id: str,
        request: devops_20210625_models.AddRepositoryMemberRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.AddRepositoryMemberResponse:
        """
        @summary 添加代码库成员
        
        @param request: AddRepositoryMemberRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddRepositoryMemberResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.access_level):
            body['accessLevel'] = request.access_level
        if not UtilClient.is_unset(request.aliyun_pks):
            body['aliyunPks'] = request.aliyun_pks
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='AddRepositoryMember',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/members',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.AddRepositoryMemberResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_repository_member(
        self,
        repository_id: str,
        request: devops_20210625_models.AddRepositoryMemberRequest,
    ) -> devops_20210625_models.AddRepositoryMemberResponse:
        """
        @summary 添加代码库成员
        
        @param request: AddRepositoryMemberRequest
        @return: AddRepositoryMemberResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.add_repository_member_with_options(repository_id, request, headers, runtime)

    async def add_repository_member_async(
        self,
        repository_id: str,
        request: devops_20210625_models.AddRepositoryMemberRequest,
    ) -> devops_20210625_models.AddRepositoryMemberResponse:
        """
        @summary 添加代码库成员
        
        @param request: AddRepositoryMemberRequest
        @return: AddRepositoryMemberResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.add_repository_member_with_options_async(repository_id, request, headers, runtime)

    def add_webhook_with_options(
        self,
        repository_id: str,
        request: devops_20210625_models.AddWebhookRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.AddWebhookResponse:
        """
        @summary 添加代码库Webhook
        
        @param request: AddWebhookRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddWebhookResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.description):
            body['description'] = request.description
        if not UtilClient.is_unset(request.enable_ssl_verification):
            body['enableSslVerification'] = request.enable_ssl_verification
        if not UtilClient.is_unset(request.merge_requests_events):
            body['mergeRequestsEvents'] = request.merge_requests_events
        if not UtilClient.is_unset(request.note_events):
            body['noteEvents'] = request.note_events
        if not UtilClient.is_unset(request.push_events):
            body['pushEvents'] = request.push_events
        if not UtilClient.is_unset(request.secret_token):
            body['secretToken'] = request.secret_token
        if not UtilClient.is_unset(request.tag_push_events):
            body['tagPushEvents'] = request.tag_push_events
        if not UtilClient.is_unset(request.url):
            body['url'] = request.url
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='AddWebhook',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/webhooks/create',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.AddWebhookResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_webhook_with_options_async(
        self,
        repository_id: str,
        request: devops_20210625_models.AddWebhookRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.AddWebhookResponse:
        """
        @summary 添加代码库Webhook
        
        @param request: AddWebhookRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddWebhookResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.description):
            body['description'] = request.description
        if not UtilClient.is_unset(request.enable_ssl_verification):
            body['enableSslVerification'] = request.enable_ssl_verification
        if not UtilClient.is_unset(request.merge_requests_events):
            body['mergeRequestsEvents'] = request.merge_requests_events
        if not UtilClient.is_unset(request.note_events):
            body['noteEvents'] = request.note_events
        if not UtilClient.is_unset(request.push_events):
            body['pushEvents'] = request.push_events
        if not UtilClient.is_unset(request.secret_token):
            body['secretToken'] = request.secret_token
        if not UtilClient.is_unset(request.tag_push_events):
            body['tagPushEvents'] = request.tag_push_events
        if not UtilClient.is_unset(request.url):
            body['url'] = request.url
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='AddWebhook',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/webhooks/create',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.AddWebhookResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_webhook(
        self,
        repository_id: str,
        request: devops_20210625_models.AddWebhookRequest,
    ) -> devops_20210625_models.AddWebhookResponse:
        """
        @summary 添加代码库Webhook
        
        @param request: AddWebhookRequest
        @return: AddWebhookResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.add_webhook_with_options(repository_id, request, headers, runtime)

    async def add_webhook_async(
        self,
        repository_id: str,
        request: devops_20210625_models.AddWebhookRequest,
    ) -> devops_20210625_models.AddWebhookResponse:
        """
        @summary 添加代码库Webhook
        
        @param request: AddWebhookRequest
        @return: AddWebhookResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.add_webhook_with_options_async(repository_id, request, headers, runtime)

    def cancel_execution_release_stage_with_options(
        self,
        app_name: str,
        release_workflow_sn: str,
        release_stage_sn: str,
        execution_number: str,
        request: devops_20210625_models.CancelExecutionReleaseStageRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CancelExecutionReleaseStageResponse:
        """
        @summary 取消执行研发阶段流水线
        
        @param request: CancelExecutionReleaseStageRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelExecutionReleaseStageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelExecutionReleaseStage',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/appstack/apps/{OpenApiUtilClient.get_encode_param(app_name)}/releaseWorkflows/{OpenApiUtilClient.get_encode_param(release_workflow_sn)}/releaseStages/{OpenApiUtilClient.get_encode_param(release_stage_sn)}/executions/{OpenApiUtilClient.get_encode_param(execution_number)}%3Acancel',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CancelExecutionReleaseStageResponse(),
            self.call_api(params, req, runtime)
        )

    async def cancel_execution_release_stage_with_options_async(
        self,
        app_name: str,
        release_workflow_sn: str,
        release_stage_sn: str,
        execution_number: str,
        request: devops_20210625_models.CancelExecutionReleaseStageRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CancelExecutionReleaseStageResponse:
        """
        @summary 取消执行研发阶段流水线
        
        @param request: CancelExecutionReleaseStageRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelExecutionReleaseStageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelExecutionReleaseStage',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/appstack/apps/{OpenApiUtilClient.get_encode_param(app_name)}/releaseWorkflows/{OpenApiUtilClient.get_encode_param(release_workflow_sn)}/releaseStages/{OpenApiUtilClient.get_encode_param(release_stage_sn)}/executions/{OpenApiUtilClient.get_encode_param(execution_number)}%3Acancel',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CancelExecutionReleaseStageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def cancel_execution_release_stage(
        self,
        app_name: str,
        release_workflow_sn: str,
        release_stage_sn: str,
        execution_number: str,
        request: devops_20210625_models.CancelExecutionReleaseStageRequest,
    ) -> devops_20210625_models.CancelExecutionReleaseStageResponse:
        """
        @summary 取消执行研发阶段流水线
        
        @param request: CancelExecutionReleaseStageRequest
        @return: CancelExecutionReleaseStageResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.cancel_execution_release_stage_with_options(app_name, release_workflow_sn, release_stage_sn, execution_number, request, headers, runtime)

    async def cancel_execution_release_stage_async(
        self,
        app_name: str,
        release_workflow_sn: str,
        release_stage_sn: str,
        execution_number: str,
        request: devops_20210625_models.CancelExecutionReleaseStageRequest,
    ) -> devops_20210625_models.CancelExecutionReleaseStageResponse:
        """
        @summary 取消执行研发阶段流水线
        
        @param request: CancelExecutionReleaseStageRequest
        @return: CancelExecutionReleaseStageResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.cancel_execution_release_stage_with_options_async(app_name, release_workflow_sn, release_stage_sn, execution_number, request, headers, runtime)

    def close_merge_request_with_options(
        self,
        repository_id: str,
        local_id: str,
        request: devops_20210625_models.CloseMergeRequestRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CloseMergeRequestResponse:
        """
        @summary 关闭代码评审
        
        @param request: CloseMergeRequestRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CloseMergeRequestResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CloseMergeRequest',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/{OpenApiUtilClient.get_encode_param(repository_id)}/merge_requests/{OpenApiUtilClient.get_encode_param(local_id)}/close',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CloseMergeRequestResponse(),
            self.call_api(params, req, runtime)
        )

    async def close_merge_request_with_options_async(
        self,
        repository_id: str,
        local_id: str,
        request: devops_20210625_models.CloseMergeRequestRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CloseMergeRequestResponse:
        """
        @summary 关闭代码评审
        
        @param request: CloseMergeRequestRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CloseMergeRequestResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CloseMergeRequest',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/{OpenApiUtilClient.get_encode_param(repository_id)}/merge_requests/{OpenApiUtilClient.get_encode_param(local_id)}/close',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CloseMergeRequestResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def close_merge_request(
        self,
        repository_id: str,
        local_id: str,
        request: devops_20210625_models.CloseMergeRequestRequest,
    ) -> devops_20210625_models.CloseMergeRequestResponse:
        """
        @summary 关闭代码评审
        
        @param request: CloseMergeRequestRequest
        @return: CloseMergeRequestResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.close_merge_request_with_options(repository_id, local_id, request, headers, runtime)

    async def close_merge_request_async(
        self,
        repository_id: str,
        local_id: str,
        request: devops_20210625_models.CloseMergeRequestRequest,
    ) -> devops_20210625_models.CloseMergeRequestResponse:
        """
        @summary 关闭代码评审
        
        @param request: CloseMergeRequestRequest
        @return: CloseMergeRequestResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.close_merge_request_with_options_async(repository_id, local_id, request, headers, runtime)

    def create_app_members_with_options(
        self,
        app_name: str,
        request: devops_20210625_models.CreateAppMembersRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateAppMembersResponse:
        """
        @summary 添加应用成员
        
        @param request: CreateAppMembersRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAppMembersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.player_list):
            body['playerList'] = request.player_list
        if not UtilClient.is_unset(request.role_names):
            body['roleNames'] = request.role_names
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateAppMembers',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/appstack/apps/{OpenApiUtilClient.get_encode_param(app_name)}/members',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='string'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateAppMembersResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_app_members_with_options_async(
        self,
        app_name: str,
        request: devops_20210625_models.CreateAppMembersRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateAppMembersResponse:
        """
        @summary 添加应用成员
        
        @param request: CreateAppMembersRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAppMembersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.player_list):
            body['playerList'] = request.player_list
        if not UtilClient.is_unset(request.role_names):
            body['roleNames'] = request.role_names
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateAppMembers',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/appstack/apps/{OpenApiUtilClient.get_encode_param(app_name)}/members',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='string'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateAppMembersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_app_members(
        self,
        app_name: str,
        request: devops_20210625_models.CreateAppMembersRequest,
    ) -> devops_20210625_models.CreateAppMembersResponse:
        """
        @summary 添加应用成员
        
        @param request: CreateAppMembersRequest
        @return: CreateAppMembersResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_app_members_with_options(app_name, request, headers, runtime)

    async def create_app_members_async(
        self,
        app_name: str,
        request: devops_20210625_models.CreateAppMembersRequest,
    ) -> devops_20210625_models.CreateAppMembersResponse:
        """
        @summary 添加应用成员
        
        @param request: CreateAppMembersRequest
        @return: CreateAppMembersResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_app_members_with_options_async(app_name, request, headers, runtime)

    def create_branch_with_options(
        self,
        repository_id: str,
        request: devops_20210625_models.CreateBranchRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateBranchResponse:
        """
        @summary 创建分支
        
        @param request: CreateBranchRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateBranchResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.branch_name):
            body['branchName'] = request.branch_name
        if not UtilClient.is_unset(request.ref):
            body['ref'] = request.ref
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateBranch',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/branches',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateBranchResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_branch_with_options_async(
        self,
        repository_id: str,
        request: devops_20210625_models.CreateBranchRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateBranchResponse:
        """
        @summary 创建分支
        
        @param request: CreateBranchRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateBranchResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.branch_name):
            body['branchName'] = request.branch_name
        if not UtilClient.is_unset(request.ref):
            body['ref'] = request.ref
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateBranch',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/branches',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateBranchResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_branch(
        self,
        repository_id: str,
        request: devops_20210625_models.CreateBranchRequest,
    ) -> devops_20210625_models.CreateBranchResponse:
        """
        @summary 创建分支
        
        @param request: CreateBranchRequest
        @return: CreateBranchResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_branch_with_options(repository_id, request, headers, runtime)

    async def create_branch_async(
        self,
        repository_id: str,
        request: devops_20210625_models.CreateBranchRequest,
    ) -> devops_20210625_models.CreateBranchResponse:
        """
        @summary 创建分支
        
        @param request: CreateBranchRequest
        @return: CreateBranchResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_branch_with_options_async(repository_id, request, headers, runtime)

    def create_change_request_with_options(
        self,
        app_name: str,
        request: devops_20210625_models.CreateChangeRequestRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateChangeRequestResponse:
        """
        @summary 创建变更
        
        @param request: CreateChangeRequestRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateChangeRequestResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.app_code_repo_sn):
            body['appCodeRepoSn'] = request.app_code_repo_sn
        if not UtilClient.is_unset(request.auto_delete_branch_when_end):
            body['autoDeleteBranchWhenEnd'] = request.auto_delete_branch_when_end
        if not UtilClient.is_unset(request.branch_name):
            body['branchName'] = request.branch_name
        if not UtilClient.is_unset(request.create_branch):
            body['createBranch'] = request.create_branch
        if not UtilClient.is_unset(request.owner_account_id):
            body['ownerAccountId'] = request.owner_account_id
        if not UtilClient.is_unset(request.owner_id):
            body['ownerId'] = request.owner_id
        if not UtilClient.is_unset(request.title):
            body['title'] = request.title
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateChangeRequest',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/appstack/apps/{OpenApiUtilClient.get_encode_param(app_name)}/changeRequests',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateChangeRequestResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_change_request_with_options_async(
        self,
        app_name: str,
        request: devops_20210625_models.CreateChangeRequestRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateChangeRequestResponse:
        """
        @summary 创建变更
        
        @param request: CreateChangeRequestRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateChangeRequestResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.app_code_repo_sn):
            body['appCodeRepoSn'] = request.app_code_repo_sn
        if not UtilClient.is_unset(request.auto_delete_branch_when_end):
            body['autoDeleteBranchWhenEnd'] = request.auto_delete_branch_when_end
        if not UtilClient.is_unset(request.branch_name):
            body['branchName'] = request.branch_name
        if not UtilClient.is_unset(request.create_branch):
            body['createBranch'] = request.create_branch
        if not UtilClient.is_unset(request.owner_account_id):
            body['ownerAccountId'] = request.owner_account_id
        if not UtilClient.is_unset(request.owner_id):
            body['ownerId'] = request.owner_id
        if not UtilClient.is_unset(request.title):
            body['title'] = request.title
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateChangeRequest',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/appstack/apps/{OpenApiUtilClient.get_encode_param(app_name)}/changeRequests',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateChangeRequestResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_change_request(
        self,
        app_name: str,
        request: devops_20210625_models.CreateChangeRequestRequest,
    ) -> devops_20210625_models.CreateChangeRequestResponse:
        """
        @summary 创建变更
        
        @param request: CreateChangeRequestRequest
        @return: CreateChangeRequestResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_change_request_with_options(app_name, request, headers, runtime)

    async def create_change_request_async(
        self,
        app_name: str,
        request: devops_20210625_models.CreateChangeRequestRequest,
    ) -> devops_20210625_models.CreateChangeRequestResponse:
        """
        @summary 创建变更
        
        @param request: CreateChangeRequestRequest
        @return: CreateChangeRequestResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_change_request_with_options_async(app_name, request, headers, runtime)

    def create_check_run_with_options(
        self,
        request: devops_20210625_models.CreateCheckRunRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateCheckRunResponse:
        """
        @summary 添加检查运行记录
        
        @param request: CreateCheckRunRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCheckRunResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.repository_identity):
            query['repositoryIdentity'] = request.repository_identity
        body = {}
        if not UtilClient.is_unset(request.annotations):
            body['annotations'] = request.annotations
        if not UtilClient.is_unset(request.completed_at):
            body['completedAt'] = request.completed_at
        if not UtilClient.is_unset(request.conclusion):
            body['conclusion'] = request.conclusion
        if not UtilClient.is_unset(request.details_url):
            body['detailsUrl'] = request.details_url
        if not UtilClient.is_unset(request.external_id):
            body['externalId'] = request.external_id
        if not UtilClient.is_unset(request.head_sha):
            body['headSha'] = request.head_sha
        if not UtilClient.is_unset(request.name):
            body['name'] = request.name
        if not UtilClient.is_unset(request.output):
            body['output'] = request.output
        if not UtilClient.is_unset(request.started_at):
            body['startedAt'] = request.started_at
        if not UtilClient.is_unset(request.status):
            body['status'] = request.status
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateCheckRun',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/check_runs/create_check_run',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateCheckRunResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_check_run_with_options_async(
        self,
        request: devops_20210625_models.CreateCheckRunRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateCheckRunResponse:
        """
        @summary 添加检查运行记录
        
        @param request: CreateCheckRunRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCheckRunResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.repository_identity):
            query['repositoryIdentity'] = request.repository_identity
        body = {}
        if not UtilClient.is_unset(request.annotations):
            body['annotations'] = request.annotations
        if not UtilClient.is_unset(request.completed_at):
            body['completedAt'] = request.completed_at
        if not UtilClient.is_unset(request.conclusion):
            body['conclusion'] = request.conclusion
        if not UtilClient.is_unset(request.details_url):
            body['detailsUrl'] = request.details_url
        if not UtilClient.is_unset(request.external_id):
            body['externalId'] = request.external_id
        if not UtilClient.is_unset(request.head_sha):
            body['headSha'] = request.head_sha
        if not UtilClient.is_unset(request.name):
            body['name'] = request.name
        if not UtilClient.is_unset(request.output):
            body['output'] = request.output
        if not UtilClient.is_unset(request.started_at):
            body['startedAt'] = request.started_at
        if not UtilClient.is_unset(request.status):
            body['status'] = request.status
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateCheckRun',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/check_runs/create_check_run',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateCheckRunResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_check_run(
        self,
        request: devops_20210625_models.CreateCheckRunRequest,
    ) -> devops_20210625_models.CreateCheckRunResponse:
        """
        @summary 添加检查运行记录
        
        @param request: CreateCheckRunRequest
        @return: CreateCheckRunResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_check_run_with_options(request, headers, runtime)

    async def create_check_run_async(
        self,
        request: devops_20210625_models.CreateCheckRunRequest,
    ) -> devops_20210625_models.CreateCheckRunResponse:
        """
        @summary 添加检查运行记录
        
        @param request: CreateCheckRunRequest
        @return: CreateCheckRunResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_check_run_with_options_async(request, headers, runtime)

    def create_comment_with_options(
        self,
        request: devops_20210625_models.CreateCommentRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateCommentResponse:
        """
        @summary 创建评论
        
        @param request: CreateCommentRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCommentResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.local_id):
            query['localId'] = request.local_id
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.repository_identity):
            query['repositoryIdentity'] = request.repository_identity
        body = {}
        if not UtilClient.is_unset(request.comment_type):
            body['commentType'] = request.comment_type
        if not UtilClient.is_unset(request.content):
            body['content'] = request.content
        if not UtilClient.is_unset(request.draft):
            body['draft'] = request.draft
        if not UtilClient.is_unset(request.file_path):
            body['filePath'] = request.file_path
        if not UtilClient.is_unset(request.line_number):
            body['lineNumber'] = request.line_number
        if not UtilClient.is_unset(request.parent_comment_biz_id):
            body['parentCommentBizId'] = request.parent_comment_biz_id
        if not UtilClient.is_unset(request.patch_set_biz_id):
            body['patchSetBizId'] = request.patch_set_biz_id
        if not UtilClient.is_unset(request.resolved):
            body['resolved'] = request.resolved
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateComment',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/code_reviews/comments/create_comment',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateCommentResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_comment_with_options_async(
        self,
        request: devops_20210625_models.CreateCommentRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateCommentResponse:
        """
        @summary 创建评论
        
        @param request: CreateCommentRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCommentResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.local_id):
            query['localId'] = request.local_id
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.repository_identity):
            query['repositoryIdentity'] = request.repository_identity
        body = {}
        if not UtilClient.is_unset(request.comment_type):
            body['commentType'] = request.comment_type
        if not UtilClient.is_unset(request.content):
            body['content'] = request.content
        if not UtilClient.is_unset(request.draft):
            body['draft'] = request.draft
        if not UtilClient.is_unset(request.file_path):
            body['filePath'] = request.file_path
        if not UtilClient.is_unset(request.line_number):
            body['lineNumber'] = request.line_number
        if not UtilClient.is_unset(request.parent_comment_biz_id):
            body['parentCommentBizId'] = request.parent_comment_biz_id
        if not UtilClient.is_unset(request.patch_set_biz_id):
            body['patchSetBizId'] = request.patch_set_biz_id
        if not UtilClient.is_unset(request.resolved):
            body['resolved'] = request.resolved
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateComment',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/code_reviews/comments/create_comment',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateCommentResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_comment(
        self,
        request: devops_20210625_models.CreateCommentRequest,
    ) -> devops_20210625_models.CreateCommentResponse:
        """
        @summary 创建评论
        
        @param request: CreateCommentRequest
        @return: CreateCommentResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_comment_with_options(request, headers, runtime)

    async def create_comment_async(
        self,
        request: devops_20210625_models.CreateCommentRequest,
    ) -> devops_20210625_models.CreateCommentResponse:
        """
        @summary 创建评论
        
        @param request: CreateCommentRequest
        @return: CreateCommentResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_comment_with_options_async(request, headers, runtime)

    def create_commit_status_with_options(
        self,
        request: devops_20210625_models.CreateCommitStatusRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateCommitStatusResponse:
        """
        @summary 创建提交状态记录
        
        @param request: CreateCommitStatusRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCommitStatusResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.repository_identity):
            query['repositoryIdentity'] = request.repository_identity
        if not UtilClient.is_unset(request.sha):
            query['sha'] = request.sha
        body = {}
        if not UtilClient.is_unset(request.context):
            body['context'] = request.context
        if not UtilClient.is_unset(request.description):
            body['description'] = request.description
        if not UtilClient.is_unset(request.state):
            body['state'] = request.state
        if not UtilClient.is_unset(request.target_url):
            body['targetUrl'] = request.target_url
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateCommitStatus',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/repository/commit_statuses/create_commit_status',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateCommitStatusResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_commit_status_with_options_async(
        self,
        request: devops_20210625_models.CreateCommitStatusRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateCommitStatusResponse:
        """
        @summary 创建提交状态记录
        
        @param request: CreateCommitStatusRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCommitStatusResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.repository_identity):
            query['repositoryIdentity'] = request.repository_identity
        if not UtilClient.is_unset(request.sha):
            query['sha'] = request.sha
        body = {}
        if not UtilClient.is_unset(request.context):
            body['context'] = request.context
        if not UtilClient.is_unset(request.description):
            body['description'] = request.description
        if not UtilClient.is_unset(request.state):
            body['state'] = request.state
        if not UtilClient.is_unset(request.target_url):
            body['targetUrl'] = request.target_url
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateCommitStatus',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/repository/commit_statuses/create_commit_status',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateCommitStatusResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_commit_status(
        self,
        request: devops_20210625_models.CreateCommitStatusRequest,
    ) -> devops_20210625_models.CreateCommitStatusResponse:
        """
        @summary 创建提交状态记录
        
        @param request: CreateCommitStatusRequest
        @return: CreateCommitStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_commit_status_with_options(request, headers, runtime)

    async def create_commit_status_async(
        self,
        request: devops_20210625_models.CreateCommitStatusRequest,
    ) -> devops_20210625_models.CreateCommitStatusResponse:
        """
        @summary 创建提交状态记录
        
        @param request: CreateCommitStatusRequest
        @return: CreateCommitStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_commit_status_with_options_async(request, headers, runtime)

    def create_commit_with_multiple_files_with_options(
        self,
        request: devops_20210625_models.CreateCommitWithMultipleFilesRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateCommitWithMultipleFilesResponse:
        """
        @summary 单提交变更多个文件
        
        @param request: CreateCommitWithMultipleFilesRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCommitWithMultipleFilesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.repository_identity):
            query['repositoryIdentity'] = request.repository_identity
        body = {}
        if not UtilClient.is_unset(request.actions):
            body['actions'] = request.actions
        if not UtilClient.is_unset(request.branch):
            body['branch'] = request.branch
        if not UtilClient.is_unset(request.commit_message):
            body['commitMessage'] = request.commit_message
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateCommitWithMultipleFiles',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/repository/commits/files',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateCommitWithMultipleFilesResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_commit_with_multiple_files_with_options_async(
        self,
        request: devops_20210625_models.CreateCommitWithMultipleFilesRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateCommitWithMultipleFilesResponse:
        """
        @summary 单提交变更多个文件
        
        @param request: CreateCommitWithMultipleFilesRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCommitWithMultipleFilesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.repository_identity):
            query['repositoryIdentity'] = request.repository_identity
        body = {}
        if not UtilClient.is_unset(request.actions):
            body['actions'] = request.actions
        if not UtilClient.is_unset(request.branch):
            body['branch'] = request.branch
        if not UtilClient.is_unset(request.commit_message):
            body['commitMessage'] = request.commit_message
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateCommitWithMultipleFiles',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/repository/commits/files',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateCommitWithMultipleFilesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_commit_with_multiple_files(
        self,
        request: devops_20210625_models.CreateCommitWithMultipleFilesRequest,
    ) -> devops_20210625_models.CreateCommitWithMultipleFilesResponse:
        """
        @summary 单提交变更多个文件
        
        @param request: CreateCommitWithMultipleFilesRequest
        @return: CreateCommitWithMultipleFilesResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_commit_with_multiple_files_with_options(request, headers, runtime)

    async def create_commit_with_multiple_files_async(
        self,
        request: devops_20210625_models.CreateCommitWithMultipleFilesRequest,
    ) -> devops_20210625_models.CreateCommitWithMultipleFilesResponse:
        """
        @summary 单提交变更多个文件
        
        @param request: CreateCommitWithMultipleFilesRequest
        @return: CreateCommitWithMultipleFilesResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_commit_with_multiple_files_with_options_async(request, headers, runtime)

    def create_deploy_key_with_options(
        self,
        repository_id: str,
        request: devops_20210625_models.CreateDeployKeyRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateDeployKeyResponse:
        """
        @summary 创建部署密钥
        
        @param request: CreateDeployKeyRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDeployKeyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.key):
            body['key'] = request.key
        if not UtilClient.is_unset(request.title):
            body['title'] = request.title
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateDeployKey',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/keys/create',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateDeployKeyResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_deploy_key_with_options_async(
        self,
        repository_id: str,
        request: devops_20210625_models.CreateDeployKeyRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateDeployKeyResponse:
        """
        @summary 创建部署密钥
        
        @param request: CreateDeployKeyRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDeployKeyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.key):
            body['key'] = request.key
        if not UtilClient.is_unset(request.title):
            body['title'] = request.title
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateDeployKey',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/keys/create',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateDeployKeyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_deploy_key(
        self,
        repository_id: str,
        request: devops_20210625_models.CreateDeployKeyRequest,
    ) -> devops_20210625_models.CreateDeployKeyResponse:
        """
        @summary 创建部署密钥
        
        @param request: CreateDeployKeyRequest
        @return: CreateDeployKeyResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_deploy_key_with_options(repository_id, request, headers, runtime)

    async def create_deploy_key_async(
        self,
        repository_id: str,
        request: devops_20210625_models.CreateDeployKeyRequest,
    ) -> devops_20210625_models.CreateDeployKeyResponse:
        """
        @summary 创建部署密钥
        
        @param request: CreateDeployKeyRequest
        @return: CreateDeployKeyResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_deploy_key_with_options_async(repository_id, request, headers, runtime)

    def create_file_with_options(
        self,
        repository_id: str,
        request: devops_20210625_models.CreateFileRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateFileResponse:
        """
        @summary 创建文件
        
        @param request: CreateFileRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateFileResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.branch_name):
            body['branchName'] = request.branch_name
        if not UtilClient.is_unset(request.commit_message):
            body['commitMessage'] = request.commit_message
        if not UtilClient.is_unset(request.content):
            body['content'] = request.content
        if not UtilClient.is_unset(request.encoding):
            body['encoding'] = request.encoding
        if not UtilClient.is_unset(request.file_path):
            body['filePath'] = request.file_path
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateFile',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/files',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateFileResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_file_with_options_async(
        self,
        repository_id: str,
        request: devops_20210625_models.CreateFileRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateFileResponse:
        """
        @summary 创建文件
        
        @param request: CreateFileRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateFileResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.branch_name):
            body['branchName'] = request.branch_name
        if not UtilClient.is_unset(request.commit_message):
            body['commitMessage'] = request.commit_message
        if not UtilClient.is_unset(request.content):
            body['content'] = request.content
        if not UtilClient.is_unset(request.encoding):
            body['encoding'] = request.encoding
        if not UtilClient.is_unset(request.file_path):
            body['filePath'] = request.file_path
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateFile',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/files',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateFileResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_file(
        self,
        repository_id: str,
        request: devops_20210625_models.CreateFileRequest,
    ) -> devops_20210625_models.CreateFileResponse:
        """
        @summary 创建文件
        
        @param request: CreateFileRequest
        @return: CreateFileResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_file_with_options(repository_id, request, headers, runtime)

    async def create_file_async(
        self,
        repository_id: str,
        request: devops_20210625_models.CreateFileRequest,
    ) -> devops_20210625_models.CreateFileResponse:
        """
        @summary 创建文件
        
        @param request: CreateFileRequest
        @return: CreateFileResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_file_with_options_async(repository_id, request, headers, runtime)

    def create_flow_tag_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateFlowTagRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateFlowTagResponse:
        """
        @summary 创建标签
        
        @param request: CreateFlowTagRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateFlowTagResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.color):
            query['color'] = request.color
        if not UtilClient.is_unset(request.flow_tag_group_id):
            query['flowTagGroupId'] = request.flow_tag_group_id
        if not UtilClient.is_unset(request.name):
            query['name'] = request.name
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateFlowTag',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/flow/tags',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateFlowTagResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_flow_tag_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateFlowTagRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateFlowTagResponse:
        """
        @summary 创建标签
        
        @param request: CreateFlowTagRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateFlowTagResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.color):
            query['color'] = request.color
        if not UtilClient.is_unset(request.flow_tag_group_id):
            query['flowTagGroupId'] = request.flow_tag_group_id
        if not UtilClient.is_unset(request.name):
            query['name'] = request.name
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateFlowTag',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/flow/tags',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateFlowTagResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_flow_tag(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateFlowTagRequest,
    ) -> devops_20210625_models.CreateFlowTagResponse:
        """
        @summary 创建标签
        
        @param request: CreateFlowTagRequest
        @return: CreateFlowTagResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_flow_tag_with_options(organization_id, request, headers, runtime)

    async def create_flow_tag_async(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateFlowTagRequest,
    ) -> devops_20210625_models.CreateFlowTagResponse:
        """
        @summary 创建标签
        
        @param request: CreateFlowTagRequest
        @return: CreateFlowTagResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_flow_tag_with_options_async(organization_id, request, headers, runtime)

    def create_flow_tag_group_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateFlowTagGroupRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateFlowTagGroupResponse:
        """
        @summary 创建标签分类
        
        @param request: CreateFlowTagGroupRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateFlowTagGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.name):
            query['name'] = request.name
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateFlowTagGroup',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/flow/tagGroups',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateFlowTagGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_flow_tag_group_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateFlowTagGroupRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateFlowTagGroupResponse:
        """
        @summary 创建标签分类
        
        @param request: CreateFlowTagGroupRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateFlowTagGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.name):
            query['name'] = request.name
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateFlowTagGroup',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/flow/tagGroups',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateFlowTagGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_flow_tag_group(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateFlowTagGroupRequest,
    ) -> devops_20210625_models.CreateFlowTagGroupResponse:
        """
        @summary 创建标签分类
        
        @param request: CreateFlowTagGroupRequest
        @return: CreateFlowTagGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_flow_tag_group_with_options(organization_id, request, headers, runtime)

    async def create_flow_tag_group_async(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateFlowTagGroupRequest,
    ) -> devops_20210625_models.CreateFlowTagGroupResponse:
        """
        @summary 创建标签分类
        
        @param request: CreateFlowTagGroupRequest
        @return: CreateFlowTagGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_flow_tag_group_with_options_async(organization_id, request, headers, runtime)

    def create_host_group_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateHostGroupRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateHostGroupResponse:
        """
        @summary 创建主机组
        
        @param request: CreateHostGroupRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateHostGroupResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.aliyun_region):
            body['aliyunRegion'] = request.aliyun_region
        if not UtilClient.is_unset(request.ecs_label_key):
            body['ecsLabelKey'] = request.ecs_label_key
        if not UtilClient.is_unset(request.ecs_label_value):
            body['ecsLabelValue'] = request.ecs_label_value
        if not UtilClient.is_unset(request.ecs_type):
            body['ecsType'] = request.ecs_type
        if not UtilClient.is_unset(request.env_id):
            body['envId'] = request.env_id
        if not UtilClient.is_unset(request.machine_infos):
            body['machineInfos'] = request.machine_infos
        if not UtilClient.is_unset(request.name):
            body['name'] = request.name
        if not UtilClient.is_unset(request.service_connection_id):
            body['serviceConnectionId'] = request.service_connection_id
        if not UtilClient.is_unset(request.tag_ids):
            body['tagIds'] = request.tag_ids
        if not UtilClient.is_unset(request.type):
            body['type'] = request.type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateHostGroup',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/hostGroups',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateHostGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_host_group_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateHostGroupRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateHostGroupResponse:
        """
        @summary 创建主机组
        
        @param request: CreateHostGroupRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateHostGroupResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.aliyun_region):
            body['aliyunRegion'] = request.aliyun_region
        if not UtilClient.is_unset(request.ecs_label_key):
            body['ecsLabelKey'] = request.ecs_label_key
        if not UtilClient.is_unset(request.ecs_label_value):
            body['ecsLabelValue'] = request.ecs_label_value
        if not UtilClient.is_unset(request.ecs_type):
            body['ecsType'] = request.ecs_type
        if not UtilClient.is_unset(request.env_id):
            body['envId'] = request.env_id
        if not UtilClient.is_unset(request.machine_infos):
            body['machineInfos'] = request.machine_infos
        if not UtilClient.is_unset(request.name):
            body['name'] = request.name
        if not UtilClient.is_unset(request.service_connection_id):
            body['serviceConnectionId'] = request.service_connection_id
        if not UtilClient.is_unset(request.tag_ids):
            body['tagIds'] = request.tag_ids
        if not UtilClient.is_unset(request.type):
            body['type'] = request.type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateHostGroup',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/hostGroups',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateHostGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_host_group(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateHostGroupRequest,
    ) -> devops_20210625_models.CreateHostGroupResponse:
        """
        @summary 创建主机组
        
        @param request: CreateHostGroupRequest
        @return: CreateHostGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_host_group_with_options(organization_id, request, headers, runtime)

    async def create_host_group_async(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateHostGroupRequest,
    ) -> devops_20210625_models.CreateHostGroupResponse:
        """
        @summary 创建主机组
        
        @param request: CreateHostGroupRequest
        @return: CreateHostGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_host_group_with_options_async(organization_id, request, headers, runtime)

    def create_merge_request_with_options(
        self,
        repository_id: str,
        request: devops_20210625_models.CreateMergeRequestRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateMergeRequestResponse:
        """
        @summary 创建代码评审
        
        @param request: CreateMergeRequestRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateMergeRequestResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.create_from):
            body['createFrom'] = request.create_from
        if not UtilClient.is_unset(request.description):
            body['description'] = request.description
        if not UtilClient.is_unset(request.reviewer_ids):
            body['reviewerIds'] = request.reviewer_ids
        if not UtilClient.is_unset(request.source_branch):
            body['sourceBranch'] = request.source_branch
        if not UtilClient.is_unset(request.source_project_id):
            body['sourceProjectId'] = request.source_project_id
        if not UtilClient.is_unset(request.target_branch):
            body['targetBranch'] = request.target_branch
        if not UtilClient.is_unset(request.target_project_id):
            body['targetProjectId'] = request.target_project_id
        if not UtilClient.is_unset(request.title):
            body['title'] = request.title
        if not UtilClient.is_unset(request.work_item_ids):
            body['workItemIds'] = request.work_item_ids
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateMergeRequest',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/{OpenApiUtilClient.get_encode_param(repository_id)}/merge_requests',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateMergeRequestResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_merge_request_with_options_async(
        self,
        repository_id: str,
        request: devops_20210625_models.CreateMergeRequestRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateMergeRequestResponse:
        """
        @summary 创建代码评审
        
        @param request: CreateMergeRequestRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateMergeRequestResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.create_from):
            body['createFrom'] = request.create_from
        if not UtilClient.is_unset(request.description):
            body['description'] = request.description
        if not UtilClient.is_unset(request.reviewer_ids):
            body['reviewerIds'] = request.reviewer_ids
        if not UtilClient.is_unset(request.source_branch):
            body['sourceBranch'] = request.source_branch
        if not UtilClient.is_unset(request.source_project_id):
            body['sourceProjectId'] = request.source_project_id
        if not UtilClient.is_unset(request.target_branch):
            body['targetBranch'] = request.target_branch
        if not UtilClient.is_unset(request.target_project_id):
            body['targetProjectId'] = request.target_project_id
        if not UtilClient.is_unset(request.title):
            body['title'] = request.title
        if not UtilClient.is_unset(request.work_item_ids):
            body['workItemIds'] = request.work_item_ids
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateMergeRequest',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/{OpenApiUtilClient.get_encode_param(repository_id)}/merge_requests',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateMergeRequestResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_merge_request(
        self,
        repository_id: str,
        request: devops_20210625_models.CreateMergeRequestRequest,
    ) -> devops_20210625_models.CreateMergeRequestResponse:
        """
        @summary 创建代码评审
        
        @param request: CreateMergeRequestRequest
        @return: CreateMergeRequestResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_merge_request_with_options(repository_id, request, headers, runtime)

    async def create_merge_request_async(
        self,
        repository_id: str,
        request: devops_20210625_models.CreateMergeRequestRequest,
    ) -> devops_20210625_models.CreateMergeRequestResponse:
        """
        @summary 创建代码评审
        
        @param request: CreateMergeRequestRequest
        @return: CreateMergeRequestResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_merge_request_with_options_async(repository_id, request, headers, runtime)

    def create_oauth_token_with_options(
        self,
        request: devops_20210625_models.CreateOAuthTokenRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateOAuthTokenResponse:
        """
        @summary 创建OAuth令牌
        
        @param request: CreateOAuthTokenRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateOAuthTokenResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.client_id):
            body['clientId'] = request.client_id
        if not UtilClient.is_unset(request.client_secret):
            body['clientSecret'] = request.client_secret
        if not UtilClient.is_unset(request.code):
            body['code'] = request.code
        if not UtilClient.is_unset(request.grant_type):
            body['grantType'] = request.grant_type
        if not UtilClient.is_unset(request.login):
            body['login'] = request.login
        if not UtilClient.is_unset(request.scope):
            body['scope'] = request.scope
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateOAuthToken',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/login/oauth/create',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateOAuthTokenResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_oauth_token_with_options_async(
        self,
        request: devops_20210625_models.CreateOAuthTokenRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateOAuthTokenResponse:
        """
        @summary 创建OAuth令牌
        
        @param request: CreateOAuthTokenRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateOAuthTokenResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.client_id):
            body['clientId'] = request.client_id
        if not UtilClient.is_unset(request.client_secret):
            body['clientSecret'] = request.client_secret
        if not UtilClient.is_unset(request.code):
            body['code'] = request.code
        if not UtilClient.is_unset(request.grant_type):
            body['grantType'] = request.grant_type
        if not UtilClient.is_unset(request.login):
            body['login'] = request.login
        if not UtilClient.is_unset(request.scope):
            body['scope'] = request.scope
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateOAuthToken',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/login/oauth/create',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateOAuthTokenResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_oauth_token(
        self,
        request: devops_20210625_models.CreateOAuthTokenRequest,
    ) -> devops_20210625_models.CreateOAuthTokenResponse:
        """
        @summary 创建OAuth令牌
        
        @param request: CreateOAuthTokenRequest
        @return: CreateOAuthTokenResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_oauth_token_with_options(request, headers, runtime)

    async def create_oauth_token_async(
        self,
        request: devops_20210625_models.CreateOAuthTokenRequest,
    ) -> devops_20210625_models.CreateOAuthTokenResponse:
        """
        @summary 创建OAuth令牌
        
        @param request: CreateOAuthTokenRequest
        @return: CreateOAuthTokenResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_oauth_token_with_options_async(request, headers, runtime)

    def create_pipeline_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.CreatePipelineRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreatePipelineResponse:
        """
        @summary 创建流水线。
        
        @param request: CreatePipelineRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreatePipelineResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.content):
            body['content'] = request.content
        if not UtilClient.is_unset(request.name):
            body['name'] = request.name
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreatePipeline',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreatePipelineResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_pipeline_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.CreatePipelineRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreatePipelineResponse:
        """
        @summary 创建流水线。
        
        @param request: CreatePipelineRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreatePipelineResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.content):
            body['content'] = request.content
        if not UtilClient.is_unset(request.name):
            body['name'] = request.name
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreatePipeline',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreatePipelineResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_pipeline(
        self,
        organization_id: str,
        request: devops_20210625_models.CreatePipelineRequest,
    ) -> devops_20210625_models.CreatePipelineResponse:
        """
        @summary 创建流水线。
        
        @param request: CreatePipelineRequest
        @return: CreatePipelineResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_pipeline_with_options(organization_id, request, headers, runtime)

    async def create_pipeline_async(
        self,
        organization_id: str,
        request: devops_20210625_models.CreatePipelineRequest,
    ) -> devops_20210625_models.CreatePipelineResponse:
        """
        @summary 创建流水线。
        
        @param request: CreatePipelineRequest
        @return: CreatePipelineResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_pipeline_with_options_async(organization_id, request, headers, runtime)

    def create_pipeline_group_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.CreatePipelineGroupRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreatePipelineGroupResponse:
        """
        @summary 创建流水线分组
        
        @param request: CreatePipelineGroupRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreatePipelineGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.name):
            query['name'] = request.name
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreatePipelineGroup',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelineGroups',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreatePipelineGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_pipeline_group_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.CreatePipelineGroupRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreatePipelineGroupResponse:
        """
        @summary 创建流水线分组
        
        @param request: CreatePipelineGroupRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreatePipelineGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.name):
            query['name'] = request.name
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreatePipelineGroup',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelineGroups',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreatePipelineGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_pipeline_group(
        self,
        organization_id: str,
        request: devops_20210625_models.CreatePipelineGroupRequest,
    ) -> devops_20210625_models.CreatePipelineGroupResponse:
        """
        @summary 创建流水线分组
        
        @param request: CreatePipelineGroupRequest
        @return: CreatePipelineGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_pipeline_group_with_options(organization_id, request, headers, runtime)

    async def create_pipeline_group_async(
        self,
        organization_id: str,
        request: devops_20210625_models.CreatePipelineGroupRequest,
    ) -> devops_20210625_models.CreatePipelineGroupResponse:
        """
        @summary 创建流水线分组
        
        @param request: CreatePipelineGroupRequest
        @return: CreatePipelineGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_pipeline_group_with_options_async(organization_id, request, headers, runtime)

    def create_project_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateProjectRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateProjectResponse:
        """
        @summary 创建项目
        
        @param request: CreateProjectRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateProjectResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.custom_code):
            body['customCode'] = request.custom_code
        if not UtilClient.is_unset(request.name):
            body['name'] = request.name
        if not UtilClient.is_unset(request.scope):
            body['scope'] = request.scope
        if not UtilClient.is_unset(request.template_identifier):
            body['templateIdentifier'] = request.template_identifier
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateProject',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/projects/createProject',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateProjectResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_project_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateProjectRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateProjectResponse:
        """
        @summary 创建项目
        
        @param request: CreateProjectRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateProjectResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.custom_code):
            body['customCode'] = request.custom_code
        if not UtilClient.is_unset(request.name):
            body['name'] = request.name
        if not UtilClient.is_unset(request.scope):
            body['scope'] = request.scope
        if not UtilClient.is_unset(request.template_identifier):
            body['templateIdentifier'] = request.template_identifier
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateProject',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/projects/createProject',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateProjectResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_project(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateProjectRequest,
    ) -> devops_20210625_models.CreateProjectResponse:
        """
        @summary 创建项目
        
        @param request: CreateProjectRequest
        @return: CreateProjectResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_project_with_options(organization_id, request, headers, runtime)

    async def create_project_async(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateProjectRequest,
    ) -> devops_20210625_models.CreateProjectResponse:
        """
        @summary 创建项目
        
        @param request: CreateProjectRequest
        @return: CreateProjectResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_project_with_options_async(organization_id, request, headers, runtime)

    def create_project_label_with_options(
        self,
        request: devops_20210625_models.CreateProjectLabelRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateProjectLabelResponse:
        """
        @summary 创建代码库Label
        
        @param request: CreateProjectLabelRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateProjectLabelResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.repository_identity):
            query['repositoryIdentity'] = request.repository_identity
        body = {}
        if not UtilClient.is_unset(request.color):
            body['color'] = request.color
        if not UtilClient.is_unset(request.description):
            body['description'] = request.description
        if not UtilClient.is_unset(request.name):
            body['name'] = request.name
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateProjectLabel',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/labels',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateProjectLabelResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_project_label_with_options_async(
        self,
        request: devops_20210625_models.CreateProjectLabelRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateProjectLabelResponse:
        """
        @summary 创建代码库Label
        
        @param request: CreateProjectLabelRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateProjectLabelResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.repository_identity):
            query['repositoryIdentity'] = request.repository_identity
        body = {}
        if not UtilClient.is_unset(request.color):
            body['color'] = request.color
        if not UtilClient.is_unset(request.description):
            body['description'] = request.description
        if not UtilClient.is_unset(request.name):
            body['name'] = request.name
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateProjectLabel',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/labels',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateProjectLabelResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_project_label(
        self,
        request: devops_20210625_models.CreateProjectLabelRequest,
    ) -> devops_20210625_models.CreateProjectLabelResponse:
        """
        @summary 创建代码库Label
        
        @param request: CreateProjectLabelRequest
        @return: CreateProjectLabelResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_project_label_with_options(request, headers, runtime)

    async def create_project_label_async(
        self,
        request: devops_20210625_models.CreateProjectLabelRequest,
    ) -> devops_20210625_models.CreateProjectLabelResponse:
        """
        @summary 创建代码库Label
        
        @param request: CreateProjectLabelRequest
        @return: CreateProjectLabelResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_project_label_with_options_async(request, headers, runtime)

    def create_protectd_branch_with_options(
        self,
        repository_id: str,
        request: devops_20210625_models.CreateProtectdBranchRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateProtectdBranchResponse:
        """
        @summary 创建保护分支
        
        @param request: CreateProtectdBranchRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateProtectdBranchResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.allow_merge_roles):
            body['allowMergeRoles'] = request.allow_merge_roles
        if not UtilClient.is_unset(request.allow_merge_user_ids):
            body['allowMergeUserIds'] = request.allow_merge_user_ids
        if not UtilClient.is_unset(request.allow_push_roles):
            body['allowPushRoles'] = request.allow_push_roles
        if not UtilClient.is_unset(request.allow_push_user_ids):
            body['allowPushUserIds'] = request.allow_push_user_ids
        if not UtilClient.is_unset(request.branch):
            body['branch'] = request.branch
        if not UtilClient.is_unset(request.id):
            body['id'] = request.id
        if not UtilClient.is_unset(request.merge_request_setting):
            body['mergeRequestSetting'] = request.merge_request_setting
        if not UtilClient.is_unset(request.test_setting_dto):
            body['testSettingDTO'] = request.test_setting_dto
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateProtectdBranch',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/protect_branches',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateProtectdBranchResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_protectd_branch_with_options_async(
        self,
        repository_id: str,
        request: devops_20210625_models.CreateProtectdBranchRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateProtectdBranchResponse:
        """
        @summary 创建保护分支
        
        @param request: CreateProtectdBranchRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateProtectdBranchResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.allow_merge_roles):
            body['allowMergeRoles'] = request.allow_merge_roles
        if not UtilClient.is_unset(request.allow_merge_user_ids):
            body['allowMergeUserIds'] = request.allow_merge_user_ids
        if not UtilClient.is_unset(request.allow_push_roles):
            body['allowPushRoles'] = request.allow_push_roles
        if not UtilClient.is_unset(request.allow_push_user_ids):
            body['allowPushUserIds'] = request.allow_push_user_ids
        if not UtilClient.is_unset(request.branch):
            body['branch'] = request.branch
        if not UtilClient.is_unset(request.id):
            body['id'] = request.id
        if not UtilClient.is_unset(request.merge_request_setting):
            body['mergeRequestSetting'] = request.merge_request_setting
        if not UtilClient.is_unset(request.test_setting_dto):
            body['testSettingDTO'] = request.test_setting_dto
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateProtectdBranch',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/protect_branches',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateProtectdBranchResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_protectd_branch(
        self,
        repository_id: str,
        request: devops_20210625_models.CreateProtectdBranchRequest,
    ) -> devops_20210625_models.CreateProtectdBranchResponse:
        """
        @summary 创建保护分支
        
        @param request: CreateProtectdBranchRequest
        @return: CreateProtectdBranchResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_protectd_branch_with_options(repository_id, request, headers, runtime)

    async def create_protectd_branch_async(
        self,
        repository_id: str,
        request: devops_20210625_models.CreateProtectdBranchRequest,
    ) -> devops_20210625_models.CreateProtectdBranchResponse:
        """
        @summary 创建保护分支
        
        @param request: CreateProtectdBranchRequest
        @return: CreateProtectdBranchResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_protectd_branch_with_options_async(repository_id, request, headers, runtime)

    def create_push_rule_with_options(
        self,
        repository_id: str,
        request: devops_20210625_models.CreatePushRuleRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreatePushRuleResponse:
        """
        @summary 创建推送规则
        
        @param request: CreatePushRuleRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreatePushRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.rule_infos):
            body['ruleInfos'] = request.rule_infos
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreatePushRule',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/{OpenApiUtilClient.get_encode_param(repository_id)}/push_rule',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreatePushRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_push_rule_with_options_async(
        self,
        repository_id: str,
        request: devops_20210625_models.CreatePushRuleRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreatePushRuleResponse:
        """
        @summary 创建推送规则
        
        @param request: CreatePushRuleRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreatePushRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.rule_infos):
            body['ruleInfos'] = request.rule_infos
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreatePushRule',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/{OpenApiUtilClient.get_encode_param(repository_id)}/push_rule',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreatePushRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_push_rule(
        self,
        repository_id: str,
        request: devops_20210625_models.CreatePushRuleRequest,
    ) -> devops_20210625_models.CreatePushRuleResponse:
        """
        @summary 创建推送规则
        
        @param request: CreatePushRuleRequest
        @return: CreatePushRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_push_rule_with_options(repository_id, request, headers, runtime)

    async def create_push_rule_async(
        self,
        repository_id: str,
        request: devops_20210625_models.CreatePushRuleRequest,
    ) -> devops_20210625_models.CreatePushRuleResponse:
        """
        @summary 创建推送规则
        
        @param request: CreatePushRuleRequest
        @return: CreatePushRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_push_rule_with_options_async(repository_id, request, headers, runtime)

    def create_repository_with_options(
        self,
        request: devops_20210625_models.CreateRepositoryRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateRepositoryResponse:
        """
        @summary 创建(导入)代码库
        
        @param request: CreateRepositoryRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRepositoryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.create_parent_path):
            query['createParentPath'] = request.create_parent_path
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.sync):
            query['sync'] = request.sync
        body = {}
        if not UtilClient.is_unset(request.avatar_url):
            body['avatarUrl'] = request.avatar_url
        if not UtilClient.is_unset(request.description):
            body['description'] = request.description
        if not UtilClient.is_unset(request.gitignore_type):
            body['gitignoreType'] = request.gitignore_type
        if not UtilClient.is_unset(request.import_account):
            body['importAccount'] = request.import_account
        if not UtilClient.is_unset(request.import_demo_project):
            body['importDemoProject'] = request.import_demo_project
        if not UtilClient.is_unset(request.import_repo_type):
            body['importRepoType'] = request.import_repo_type
        if not UtilClient.is_unset(request.import_token):
            body['importToken'] = request.import_token
        if not UtilClient.is_unset(request.import_token_encrypted):
            body['importTokenEncrypted'] = request.import_token_encrypted
        if not UtilClient.is_unset(request.import_url):
            body['importUrl'] = request.import_url
        if not UtilClient.is_unset(request.init_standard_service):
            body['initStandardService'] = request.init_standard_service
        if not UtilClient.is_unset(request.is_crypto_enabled):
            body['isCryptoEnabled'] = request.is_crypto_enabled
        if not UtilClient.is_unset(request.local_import_url):
            body['localImportUrl'] = request.local_import_url
        if not UtilClient.is_unset(request.name):
            body['name'] = request.name
        if not UtilClient.is_unset(request.namespace_id):
            body['namespaceId'] = request.namespace_id
        if not UtilClient.is_unset(request.path):
            body['path'] = request.path
        if not UtilClient.is_unset(request.readme_type):
            body['readmeType'] = request.readme_type
        if not UtilClient.is_unset(request.visibility_level):
            body['visibilityLevel'] = request.visibility_level
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateRepository',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/create',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateRepositoryResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_repository_with_options_async(
        self,
        request: devops_20210625_models.CreateRepositoryRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateRepositoryResponse:
        """
        @summary 创建(导入)代码库
        
        @param request: CreateRepositoryRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRepositoryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.create_parent_path):
            query['createParentPath'] = request.create_parent_path
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.sync):
            query['sync'] = request.sync
        body = {}
        if not UtilClient.is_unset(request.avatar_url):
            body['avatarUrl'] = request.avatar_url
        if not UtilClient.is_unset(request.description):
            body['description'] = request.description
        if not UtilClient.is_unset(request.gitignore_type):
            body['gitignoreType'] = request.gitignore_type
        if not UtilClient.is_unset(request.import_account):
            body['importAccount'] = request.import_account
        if not UtilClient.is_unset(request.import_demo_project):
            body['importDemoProject'] = request.import_demo_project
        if not UtilClient.is_unset(request.import_repo_type):
            body['importRepoType'] = request.import_repo_type
        if not UtilClient.is_unset(request.import_token):
            body['importToken'] = request.import_token
        if not UtilClient.is_unset(request.import_token_encrypted):
            body['importTokenEncrypted'] = request.import_token_encrypted
        if not UtilClient.is_unset(request.import_url):
            body['importUrl'] = request.import_url
        if not UtilClient.is_unset(request.init_standard_service):
            body['initStandardService'] = request.init_standard_service
        if not UtilClient.is_unset(request.is_crypto_enabled):
            body['isCryptoEnabled'] = request.is_crypto_enabled
        if not UtilClient.is_unset(request.local_import_url):
            body['localImportUrl'] = request.local_import_url
        if not UtilClient.is_unset(request.name):
            body['name'] = request.name
        if not UtilClient.is_unset(request.namespace_id):
            body['namespaceId'] = request.namespace_id
        if not UtilClient.is_unset(request.path):
            body['path'] = request.path
        if not UtilClient.is_unset(request.readme_type):
            body['readmeType'] = request.readme_type
        if not UtilClient.is_unset(request.visibility_level):
            body['visibilityLevel'] = request.visibility_level
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateRepository',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/create',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateRepositoryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_repository(
        self,
        request: devops_20210625_models.CreateRepositoryRequest,
    ) -> devops_20210625_models.CreateRepositoryResponse:
        """
        @summary 创建(导入)代码库
        
        @param request: CreateRepositoryRequest
        @return: CreateRepositoryResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_repository_with_options(request, headers, runtime)

    async def create_repository_async(
        self,
        request: devops_20210625_models.CreateRepositoryRequest,
    ) -> devops_20210625_models.CreateRepositoryResponse:
        """
        @summary 创建(导入)代码库
        
        @param request: CreateRepositoryRequest
        @return: CreateRepositoryResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_repository_with_options_async(request, headers, runtime)

    def create_repository_group_with_options(
        self,
        request: devops_20210625_models.CreateRepositoryGroupRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateRepositoryGroupResponse:
        """
        @summary 创建代码组
        
        @param request: CreateRepositoryGroupRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRepositoryGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.avatar_url):
            body['avatarUrl'] = request.avatar_url
        if not UtilClient.is_unset(request.description):
            body['description'] = request.description
        if not UtilClient.is_unset(request.name):
            body['name'] = request.name
        if not UtilClient.is_unset(request.parent_id):
            body['parentId'] = request.parent_id
        if not UtilClient.is_unset(request.path):
            body['path'] = request.path
        if not UtilClient.is_unset(request.visibility_level):
            body['visibilityLevel'] = request.visibility_level
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateRepositoryGroup',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/groups/create',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateRepositoryGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_repository_group_with_options_async(
        self,
        request: devops_20210625_models.CreateRepositoryGroupRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateRepositoryGroupResponse:
        """
        @summary 创建代码组
        
        @param request: CreateRepositoryGroupRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRepositoryGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.avatar_url):
            body['avatarUrl'] = request.avatar_url
        if not UtilClient.is_unset(request.description):
            body['description'] = request.description
        if not UtilClient.is_unset(request.name):
            body['name'] = request.name
        if not UtilClient.is_unset(request.parent_id):
            body['parentId'] = request.parent_id
        if not UtilClient.is_unset(request.path):
            body['path'] = request.path
        if not UtilClient.is_unset(request.visibility_level):
            body['visibilityLevel'] = request.visibility_level
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateRepositoryGroup',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/groups/create',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateRepositoryGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_repository_group(
        self,
        request: devops_20210625_models.CreateRepositoryGroupRequest,
    ) -> devops_20210625_models.CreateRepositoryGroupResponse:
        """
        @summary 创建代码组
        
        @param request: CreateRepositoryGroupRequest
        @return: CreateRepositoryGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_repository_group_with_options(request, headers, runtime)

    async def create_repository_group_async(
        self,
        request: devops_20210625_models.CreateRepositoryGroupRequest,
    ) -> devops_20210625_models.CreateRepositoryGroupResponse:
        """
        @summary 创建代码组
        
        @param request: CreateRepositoryGroupRequest
        @return: CreateRepositoryGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_repository_group_with_options_async(request, headers, runtime)

    def create_resource_member_with_options(
        self,
        organization_id: str,
        resource_type: str,
        resource_id: str,
        request: devops_20210625_models.CreateResourceMemberRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateResourceMemberResponse:
        """
        @summary 插入资源成员
        
        @param request: CreateResourceMemberRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateResourceMemberResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.account_id):
            body['accountId'] = request.account_id
        if not UtilClient.is_unset(request.role_name):
            body['roleName'] = request.role_name
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateResourceMember',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/{OpenApiUtilClient.get_encode_param(resource_type)}/{OpenApiUtilClient.get_encode_param(resource_id)}/members',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateResourceMemberResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_resource_member_with_options_async(
        self,
        organization_id: str,
        resource_type: str,
        resource_id: str,
        request: devops_20210625_models.CreateResourceMemberRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateResourceMemberResponse:
        """
        @summary 插入资源成员
        
        @param request: CreateResourceMemberRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateResourceMemberResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.account_id):
            body['accountId'] = request.account_id
        if not UtilClient.is_unset(request.role_name):
            body['roleName'] = request.role_name
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateResourceMember',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/{OpenApiUtilClient.get_encode_param(resource_type)}/{OpenApiUtilClient.get_encode_param(resource_id)}/members',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateResourceMemberResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_resource_member(
        self,
        organization_id: str,
        resource_type: str,
        resource_id: str,
        request: devops_20210625_models.CreateResourceMemberRequest,
    ) -> devops_20210625_models.CreateResourceMemberResponse:
        """
        @summary 插入资源成员
        
        @param request: CreateResourceMemberRequest
        @return: CreateResourceMemberResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_resource_member_with_options(organization_id, resource_type, resource_id, request, headers, runtime)

    async def create_resource_member_async(
        self,
        organization_id: str,
        resource_type: str,
        resource_id: str,
        request: devops_20210625_models.CreateResourceMemberRequest,
    ) -> devops_20210625_models.CreateResourceMemberResponse:
        """
        @summary 插入资源成员
        
        @param request: CreateResourceMemberRequest
        @return: CreateResourceMemberResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_resource_member_with_options_async(organization_id, resource_type, resource_id, request, headers, runtime)

    def create_service_auth_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateServiceAuthRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateServiceAuthResponse:
        """
        @summary 创建服务授权
        
        @param request: CreateServiceAuthRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateServiceAuthResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.service_auth_type):
            query['serviceAuthType'] = request.service_auth_type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateServiceAuth',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/serviceAuths',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateServiceAuthResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_service_auth_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateServiceAuthRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateServiceAuthResponse:
        """
        @summary 创建服务授权
        
        @param request: CreateServiceAuthRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateServiceAuthResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.service_auth_type):
            query['serviceAuthType'] = request.service_auth_type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateServiceAuth',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/serviceAuths',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateServiceAuthResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_service_auth(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateServiceAuthRequest,
    ) -> devops_20210625_models.CreateServiceAuthResponse:
        """
        @summary 创建服务授权
        
        @param request: CreateServiceAuthRequest
        @return: CreateServiceAuthResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_service_auth_with_options(organization_id, request, headers, runtime)

    async def create_service_auth_async(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateServiceAuthRequest,
    ) -> devops_20210625_models.CreateServiceAuthResponse:
        """
        @summary 创建服务授权
        
        @param request: CreateServiceAuthRequest
        @return: CreateServiceAuthResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_service_auth_with_options_async(organization_id, request, headers, runtime)

    def create_service_connection_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateServiceConnectionRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateServiceConnectionResponse:
        """
        @summary 创建服务连接
        
        @param request: CreateServiceConnectionRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateServiceConnectionResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.auth_type):
            body['authType'] = request.auth_type
        if not UtilClient.is_unset(request.connection_name):
            body['connectionName'] = request.connection_name
        if not UtilClient.is_unset(request.connection_type):
            body['connectionType'] = request.connection_type
        if not UtilClient.is_unset(request.scope):
            body['scope'] = request.scope
        if not UtilClient.is_unset(request.service_auth_id):
            body['serviceAuthId'] = request.service_auth_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateServiceConnection',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/createServiceConnection',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateServiceConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_service_connection_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateServiceConnectionRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateServiceConnectionResponse:
        """
        @summary 创建服务连接
        
        @param request: CreateServiceConnectionRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateServiceConnectionResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.auth_type):
            body['authType'] = request.auth_type
        if not UtilClient.is_unset(request.connection_name):
            body['connectionName'] = request.connection_name
        if not UtilClient.is_unset(request.connection_type):
            body['connectionType'] = request.connection_type
        if not UtilClient.is_unset(request.scope):
            body['scope'] = request.scope
        if not UtilClient.is_unset(request.service_auth_id):
            body['serviceAuthId'] = request.service_auth_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateServiceConnection',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/createServiceConnection',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateServiceConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_service_connection(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateServiceConnectionRequest,
    ) -> devops_20210625_models.CreateServiceConnectionResponse:
        """
        @summary 创建服务连接
        
        @param request: CreateServiceConnectionRequest
        @return: CreateServiceConnectionResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_service_connection_with_options(organization_id, request, headers, runtime)

    async def create_service_connection_async(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateServiceConnectionRequest,
    ) -> devops_20210625_models.CreateServiceConnectionResponse:
        """
        @summary 创建服务连接
        
        @param request: CreateServiceConnectionRequest
        @return: CreateServiceConnectionResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_service_connection_with_options_async(organization_id, request, headers, runtime)

    def create_service_credential_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateServiceCredentialRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateServiceCredentialResponse:
        """
        @summary 创建用户名密码类型的证书
        
        @param request: CreateServiceCredentialRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateServiceCredentialResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.name):
            body['name'] = request.name
        if not UtilClient.is_unset(request.password):
            body['password'] = request.password
        if not UtilClient.is_unset(request.scope):
            body['scope'] = request.scope
        if not UtilClient.is_unset(request.type):
            body['type'] = request.type
        if not UtilClient.is_unset(request.username):
            body['username'] = request.username
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateServiceCredential',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/serviceCredentials',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateServiceCredentialResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_service_credential_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateServiceCredentialRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateServiceCredentialResponse:
        """
        @summary 创建用户名密码类型的证书
        
        @param request: CreateServiceCredentialRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateServiceCredentialResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.name):
            body['name'] = request.name
        if not UtilClient.is_unset(request.password):
            body['password'] = request.password
        if not UtilClient.is_unset(request.scope):
            body['scope'] = request.scope
        if not UtilClient.is_unset(request.type):
            body['type'] = request.type
        if not UtilClient.is_unset(request.username):
            body['username'] = request.username
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateServiceCredential',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/serviceCredentials',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateServiceCredentialResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_service_credential(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateServiceCredentialRequest,
    ) -> devops_20210625_models.CreateServiceCredentialResponse:
        """
        @summary 创建用户名密码类型的证书
        
        @param request: CreateServiceCredentialRequest
        @return: CreateServiceCredentialResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_service_credential_with_options(organization_id, request, headers, runtime)

    async def create_service_credential_async(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateServiceCredentialRequest,
    ) -> devops_20210625_models.CreateServiceCredentialResponse:
        """
        @summary 创建用户名密码类型的证书
        
        @param request: CreateServiceCredentialRequest
        @return: CreateServiceCredentialResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_service_credential_with_options_async(organization_id, request, headers, runtime)

    def create_sprint_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateSprintRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateSprintResponse:
        """
        @summary 创建迭代
        
        @param request: CreateSprintRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSprintResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.end_date):
            body['endDate'] = request.end_date
        if not UtilClient.is_unset(request.name):
            body['name'] = request.name
        if not UtilClient.is_unset(request.space_identifier):
            body['spaceIdentifier'] = request.space_identifier
        if not UtilClient.is_unset(request.staff_ids):
            body['staffIds'] = request.staff_ids
        if not UtilClient.is_unset(request.start_date):
            body['startDate'] = request.start_date
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateSprint',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/sprints/create',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateSprintResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_sprint_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateSprintRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateSprintResponse:
        """
        @summary 创建迭代
        
        @param request: CreateSprintRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSprintResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.end_date):
            body['endDate'] = request.end_date
        if not UtilClient.is_unset(request.name):
            body['name'] = request.name
        if not UtilClient.is_unset(request.space_identifier):
            body['spaceIdentifier'] = request.space_identifier
        if not UtilClient.is_unset(request.staff_ids):
            body['staffIds'] = request.staff_ids
        if not UtilClient.is_unset(request.start_date):
            body['startDate'] = request.start_date
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateSprint',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/sprints/create',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateSprintResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_sprint(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateSprintRequest,
    ) -> devops_20210625_models.CreateSprintResponse:
        """
        @summary 创建迭代
        
        @param request: CreateSprintRequest
        @return: CreateSprintResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_sprint_with_options(organization_id, request, headers, runtime)

    async def create_sprint_async(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateSprintRequest,
    ) -> devops_20210625_models.CreateSprintResponse:
        """
        @summary 创建迭代
        
        @param request: CreateSprintRequest
        @return: CreateSprintResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_sprint_with_options_async(organization_id, request, headers, runtime)

    def create_ssh_key_with_options(
        self,
        organization_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateSshKeyResponse:
        """
        @summary 创建企业公钥
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSshKeyResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='CreateSshKey',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/sshKey',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateSshKeyResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ssh_key_with_options_async(
        self,
        organization_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateSshKeyResponse:
        """
        @summary 创建企业公钥
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSshKeyResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='CreateSshKey',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/sshKey',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateSshKeyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ssh_key(
        self,
        organization_id: str,
    ) -> devops_20210625_models.CreateSshKeyResponse:
        """
        @summary 创建企业公钥
        
        @return: CreateSshKeyResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_ssh_key_with_options(organization_id, headers, runtime)

    async def create_ssh_key_async(
        self,
        organization_id: str,
    ) -> devops_20210625_models.CreateSshKeyResponse:
        """
        @summary 创建企业公钥
        
        @return: CreateSshKeyResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_ssh_key_with_options_async(organization_id, headers, runtime)

    def create_tag_with_options(
        self,
        repository_id: str,
        request: devops_20210625_models.CreateTagRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateTagResponse:
        """
        @summary 创建标签Tag
        
        @param request: CreateTagRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateTagResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.message):
            body['message'] = request.message
        if not UtilClient.is_unset(request.ref):
            body['ref'] = request.ref
        if not UtilClient.is_unset(request.tag_name):
            body['tagName'] = request.tag_name
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateTag',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/tags/create',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateTagResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_tag_with_options_async(
        self,
        repository_id: str,
        request: devops_20210625_models.CreateTagRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateTagResponse:
        """
        @summary 创建标签Tag
        
        @param request: CreateTagRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateTagResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.message):
            body['message'] = request.message
        if not UtilClient.is_unset(request.ref):
            body['ref'] = request.ref
        if not UtilClient.is_unset(request.tag_name):
            body['tagName'] = request.tag_name
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateTag',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/tags/create',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateTagResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_tag(
        self,
        repository_id: str,
        request: devops_20210625_models.CreateTagRequest,
    ) -> devops_20210625_models.CreateTagResponse:
        """
        @summary 创建标签Tag
        
        @param request: CreateTagRequest
        @return: CreateTagResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_tag_with_options(repository_id, request, headers, runtime)

    async def create_tag_async(
        self,
        repository_id: str,
        request: devops_20210625_models.CreateTagRequest,
    ) -> devops_20210625_models.CreateTagResponse:
        """
        @summary 创建标签Tag
        
        @param request: CreateTagRequest
        @return: CreateTagResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_tag_with_options_async(repository_id, request, headers, runtime)

    def create_test_case_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateTestCaseRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateTestCaseResponse:
        """
        @summary 创建测试用例
        
        @param request: CreateTestCaseRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateTestCaseResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.assigned_to):
            body['assignedTo'] = request.assigned_to
        if not UtilClient.is_unset(request.directory_identifier):
            body['directoryIdentifier'] = request.directory_identifier
        if not UtilClient.is_unset(request.field_value_list):
            body['fieldValueList'] = request.field_value_list
        if not UtilClient.is_unset(request.priority):
            body['priority'] = request.priority
        if not UtilClient.is_unset(request.space_identifier):
            body['spaceIdentifier'] = request.space_identifier
        if not UtilClient.is_unset(request.subject):
            body['subject'] = request.subject
        if not UtilClient.is_unset(request.tags):
            body['tags'] = request.tags
        if not UtilClient.is_unset(request.testcase_step_content_info):
            body['testcaseStepContentInfo'] = request.testcase_step_content_info
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateTestCase',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/testhub/testcase',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateTestCaseResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_test_case_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateTestCaseRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateTestCaseResponse:
        """
        @summary 创建测试用例
        
        @param request: CreateTestCaseRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateTestCaseResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.assigned_to):
            body['assignedTo'] = request.assigned_to
        if not UtilClient.is_unset(request.directory_identifier):
            body['directoryIdentifier'] = request.directory_identifier
        if not UtilClient.is_unset(request.field_value_list):
            body['fieldValueList'] = request.field_value_list
        if not UtilClient.is_unset(request.priority):
            body['priority'] = request.priority
        if not UtilClient.is_unset(request.space_identifier):
            body['spaceIdentifier'] = request.space_identifier
        if not UtilClient.is_unset(request.subject):
            body['subject'] = request.subject
        if not UtilClient.is_unset(request.tags):
            body['tags'] = request.tags
        if not UtilClient.is_unset(request.testcase_step_content_info):
            body['testcaseStepContentInfo'] = request.testcase_step_content_info
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateTestCase',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/testhub/testcase',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateTestCaseResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_test_case(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateTestCaseRequest,
    ) -> devops_20210625_models.CreateTestCaseResponse:
        """
        @summary 创建测试用例
        
        @param request: CreateTestCaseRequest
        @return: CreateTestCaseResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_test_case_with_options(organization_id, request, headers, runtime)

    async def create_test_case_async(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateTestCaseRequest,
    ) -> devops_20210625_models.CreateTestCaseResponse:
        """
        @summary 创建测试用例
        
        @param request: CreateTestCaseRequest
        @return: CreateTestCaseResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_test_case_with_options_async(organization_id, request, headers, runtime)

    def create_user_key_with_options(
        self,
        request: devops_20210625_models.CreateUserKeyRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateUserKeyResponse:
        """
        @summary 创建SSH Key密钥
        
        @param request: CreateUserKeyRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateUserKeyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.expire_time):
            body['expireTime'] = request.expire_time
        if not UtilClient.is_unset(request.key_scope):
            body['keyScope'] = request.key_scope
        if not UtilClient.is_unset(request.public_key):
            body['publicKey'] = request.public_key
        if not UtilClient.is_unset(request.title):
            body['title'] = request.title
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateUserKey',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v3/user/keys/create',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateUserKeyResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_user_key_with_options_async(
        self,
        request: devops_20210625_models.CreateUserKeyRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateUserKeyResponse:
        """
        @summary 创建SSH Key密钥
        
        @param request: CreateUserKeyRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateUserKeyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.expire_time):
            body['expireTime'] = request.expire_time
        if not UtilClient.is_unset(request.key_scope):
            body['keyScope'] = request.key_scope
        if not UtilClient.is_unset(request.public_key):
            body['publicKey'] = request.public_key
        if not UtilClient.is_unset(request.title):
            body['title'] = request.title
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateUserKey',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v3/user/keys/create',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateUserKeyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_user_key(
        self,
        request: devops_20210625_models.CreateUserKeyRequest,
    ) -> devops_20210625_models.CreateUserKeyResponse:
        """
        @summary 创建SSH Key密钥
        
        @param request: CreateUserKeyRequest
        @return: CreateUserKeyResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_user_key_with_options(request, headers, runtime)

    async def create_user_key_async(
        self,
        request: devops_20210625_models.CreateUserKeyRequest,
    ) -> devops_20210625_models.CreateUserKeyResponse:
        """
        @summary 创建SSH Key密钥
        
        @param request: CreateUserKeyRequest
        @return: CreateUserKeyResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_user_key_with_options_async(request, headers, runtime)

    def create_variable_group_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateVariableGroupRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateVariableGroupResponse:
        """
        @summary 创建变量组
        
        @param request: CreateVariableGroupRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVariableGroupResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.description):
            body['description'] = request.description
        if not UtilClient.is_unset(request.name):
            body['name'] = request.name
        if not UtilClient.is_unset(request.variables):
            body['variables'] = request.variables
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateVariableGroup',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/variableGroups',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateVariableGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_variable_group_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateVariableGroupRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateVariableGroupResponse:
        """
        @summary 创建变量组
        
        @param request: CreateVariableGroupRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVariableGroupResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.description):
            body['description'] = request.description
        if not UtilClient.is_unset(request.name):
            body['name'] = request.name
        if not UtilClient.is_unset(request.variables):
            body['variables'] = request.variables
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateVariableGroup',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/variableGroups',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateVariableGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_variable_group(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateVariableGroupRequest,
    ) -> devops_20210625_models.CreateVariableGroupResponse:
        """
        @summary 创建变量组
        
        @param request: CreateVariableGroupRequest
        @return: CreateVariableGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_variable_group_with_options(organization_id, request, headers, runtime)

    async def create_variable_group_async(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateVariableGroupRequest,
    ) -> devops_20210625_models.CreateVariableGroupResponse:
        """
        @summary 创建变量组
        
        @param request: CreateVariableGroupRequest
        @return: CreateVariableGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_variable_group_with_options_async(organization_id, request, headers, runtime)

    def create_workitem_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateWorkitemRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateWorkitemResponse:
        """
        @summary 新建工作项
        
        @param request: CreateWorkitemRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateWorkitemResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.assigned_to):
            body['assignedTo'] = request.assigned_to
        if not UtilClient.is_unset(request.category):
            body['category'] = request.category
        if not UtilClient.is_unset(request.description):
            body['description'] = request.description
        if not UtilClient.is_unset(request.description_format):
            body['descriptionFormat'] = request.description_format
        if not UtilClient.is_unset(request.field_value_list):
            body['fieldValueList'] = request.field_value_list
        if not UtilClient.is_unset(request.parent):
            body['parent'] = request.parent
        if not UtilClient.is_unset(request.participant):
            body['participant'] = request.participant
        if not UtilClient.is_unset(request.space):
            body['space'] = request.space
        if not UtilClient.is_unset(request.space_identifier):
            body['spaceIdentifier'] = request.space_identifier
        if not UtilClient.is_unset(request.space_type):
            body['spaceType'] = request.space_type
        if not UtilClient.is_unset(request.sprint):
            body['sprint'] = request.sprint
        if not UtilClient.is_unset(request.subject):
            body['subject'] = request.subject
        if not UtilClient.is_unset(request.tracker):
            body['tracker'] = request.tracker
        if not UtilClient.is_unset(request.verifier):
            body['verifier'] = request.verifier
        if not UtilClient.is_unset(request.workitem_type):
            body['workitemType'] = request.workitem_type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateWorkitem',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitems/create',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateWorkitemResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_workitem_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateWorkitemRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateWorkitemResponse:
        """
        @summary 新建工作项
        
        @param request: CreateWorkitemRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateWorkitemResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.assigned_to):
            body['assignedTo'] = request.assigned_to
        if not UtilClient.is_unset(request.category):
            body['category'] = request.category
        if not UtilClient.is_unset(request.description):
            body['description'] = request.description
        if not UtilClient.is_unset(request.description_format):
            body['descriptionFormat'] = request.description_format
        if not UtilClient.is_unset(request.field_value_list):
            body['fieldValueList'] = request.field_value_list
        if not UtilClient.is_unset(request.parent):
            body['parent'] = request.parent
        if not UtilClient.is_unset(request.participant):
            body['participant'] = request.participant
        if not UtilClient.is_unset(request.space):
            body['space'] = request.space
        if not UtilClient.is_unset(request.space_identifier):
            body['spaceIdentifier'] = request.space_identifier
        if not UtilClient.is_unset(request.space_type):
            body['spaceType'] = request.space_type
        if not UtilClient.is_unset(request.sprint):
            body['sprint'] = request.sprint
        if not UtilClient.is_unset(request.subject):
            body['subject'] = request.subject
        if not UtilClient.is_unset(request.tracker):
            body['tracker'] = request.tracker
        if not UtilClient.is_unset(request.verifier):
            body['verifier'] = request.verifier
        if not UtilClient.is_unset(request.workitem_type):
            body['workitemType'] = request.workitem_type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateWorkitem',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitems/create',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateWorkitemResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_workitem(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateWorkitemRequest,
    ) -> devops_20210625_models.CreateWorkitemResponse:
        """
        @summary 新建工作项
        
        @param request: CreateWorkitemRequest
        @return: CreateWorkitemResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_workitem_with_options(organization_id, request, headers, runtime)

    async def create_workitem_async(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateWorkitemRequest,
    ) -> devops_20210625_models.CreateWorkitemResponse:
        """
        @summary 新建工作项
        
        @param request: CreateWorkitemRequest
        @return: CreateWorkitemResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_workitem_with_options_async(organization_id, request, headers, runtime)

    def create_workitem_comment_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateWorkitemCommentRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateWorkitemCommentResponse:
        """
        @summary 创建一个评论
        
        @param request: CreateWorkitemCommentRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateWorkitemCommentResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.content):
            body['content'] = request.content
        if not UtilClient.is_unset(request.format_type):
            body['formatType'] = request.format_type
        if not UtilClient.is_unset(request.parent_id):
            body['parentId'] = request.parent_id
        if not UtilClient.is_unset(request.workitem_identifier):
            body['workitemIdentifier'] = request.workitem_identifier
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateWorkitemComment',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitems/comment',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateWorkitemCommentResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_workitem_comment_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateWorkitemCommentRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateWorkitemCommentResponse:
        """
        @summary 创建一个评论
        
        @param request: CreateWorkitemCommentRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateWorkitemCommentResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.content):
            body['content'] = request.content
        if not UtilClient.is_unset(request.format_type):
            body['formatType'] = request.format_type
        if not UtilClient.is_unset(request.parent_id):
            body['parentId'] = request.parent_id
        if not UtilClient.is_unset(request.workitem_identifier):
            body['workitemIdentifier'] = request.workitem_identifier
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateWorkitemComment',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitems/comment',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateWorkitemCommentResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_workitem_comment(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateWorkitemCommentRequest,
    ) -> devops_20210625_models.CreateWorkitemCommentResponse:
        """
        @summary 创建一个评论
        
        @param request: CreateWorkitemCommentRequest
        @return: CreateWorkitemCommentResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_workitem_comment_with_options(organization_id, request, headers, runtime)

    async def create_workitem_comment_async(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateWorkitemCommentRequest,
    ) -> devops_20210625_models.CreateWorkitemCommentResponse:
        """
        @summary 创建一个评论
        
        @param request: CreateWorkitemCommentRequest
        @return: CreateWorkitemCommentResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_workitem_comment_with_options_async(organization_id, request, headers, runtime)

    def create_workitem_estimate_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateWorkitemEstimateRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateWorkitemEstimateResponse:
        """
        @summary 登记预计工时
        
        @param request: CreateWorkitemEstimateRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateWorkitemEstimateResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.description):
            body['description'] = request.description
        if not UtilClient.is_unset(request.record_user_identifier):
            body['recordUserIdentifier'] = request.record_user_identifier
        if not UtilClient.is_unset(request.spent_time):
            body['spentTime'] = request.spent_time
        if not UtilClient.is_unset(request.type):
            body['type'] = request.type
        if not UtilClient.is_unset(request.workitem_identifier):
            body['workitemIdentifier'] = request.workitem_identifier
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateWorkitemEstimate',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitems/estimate',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateWorkitemEstimateResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_workitem_estimate_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateWorkitemEstimateRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateWorkitemEstimateResponse:
        """
        @summary 登记预计工时
        
        @param request: CreateWorkitemEstimateRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateWorkitemEstimateResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.description):
            body['description'] = request.description
        if not UtilClient.is_unset(request.record_user_identifier):
            body['recordUserIdentifier'] = request.record_user_identifier
        if not UtilClient.is_unset(request.spent_time):
            body['spentTime'] = request.spent_time
        if not UtilClient.is_unset(request.type):
            body['type'] = request.type
        if not UtilClient.is_unset(request.workitem_identifier):
            body['workitemIdentifier'] = request.workitem_identifier
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateWorkitemEstimate',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitems/estimate',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateWorkitemEstimateResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_workitem_estimate(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateWorkitemEstimateRequest,
    ) -> devops_20210625_models.CreateWorkitemEstimateResponse:
        """
        @summary 登记预计工时
        
        @param request: CreateWorkitemEstimateRequest
        @return: CreateWorkitemEstimateResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_workitem_estimate_with_options(organization_id, request, headers, runtime)

    async def create_workitem_estimate_async(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateWorkitemEstimateRequest,
    ) -> devops_20210625_models.CreateWorkitemEstimateResponse:
        """
        @summary 登记预计工时
        
        @param request: CreateWorkitemEstimateRequest
        @return: CreateWorkitemEstimateResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_workitem_estimate_with_options_async(organization_id, request, headers, runtime)

    def create_workitem_record_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateWorkitemRecordRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateWorkitemRecordResponse:
        """
        @summary 登记实际工时
        
        @param request: CreateWorkitemRecordRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateWorkitemRecordResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.actual_time):
            body['actualTime'] = request.actual_time
        if not UtilClient.is_unset(request.description):
            body['description'] = request.description
        if not UtilClient.is_unset(request.gmt_end):
            body['gmtEnd'] = request.gmt_end
        if not UtilClient.is_unset(request.gmt_start):
            body['gmtStart'] = request.gmt_start
        if not UtilClient.is_unset(request.record_user_identifier):
            body['recordUserIdentifier'] = request.record_user_identifier
        if not UtilClient.is_unset(request.type):
            body['type'] = request.type
        if not UtilClient.is_unset(request.workitem_identifier):
            body['workitemIdentifier'] = request.workitem_identifier
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateWorkitemRecord',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitems/record',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateWorkitemRecordResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_workitem_record_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateWorkitemRecordRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateWorkitemRecordResponse:
        """
        @summary 登记实际工时
        
        @param request: CreateWorkitemRecordRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateWorkitemRecordResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.actual_time):
            body['actualTime'] = request.actual_time
        if not UtilClient.is_unset(request.description):
            body['description'] = request.description
        if not UtilClient.is_unset(request.gmt_end):
            body['gmtEnd'] = request.gmt_end
        if not UtilClient.is_unset(request.gmt_start):
            body['gmtStart'] = request.gmt_start
        if not UtilClient.is_unset(request.record_user_identifier):
            body['recordUserIdentifier'] = request.record_user_identifier
        if not UtilClient.is_unset(request.type):
            body['type'] = request.type
        if not UtilClient.is_unset(request.workitem_identifier):
            body['workitemIdentifier'] = request.workitem_identifier
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateWorkitemRecord',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitems/record',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateWorkitemRecordResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_workitem_record(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateWorkitemRecordRequest,
    ) -> devops_20210625_models.CreateWorkitemRecordResponse:
        """
        @summary 登记实际工时
        
        @param request: CreateWorkitemRecordRequest
        @return: CreateWorkitemRecordResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_workitem_record_with_options(organization_id, request, headers, runtime)

    async def create_workitem_record_async(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateWorkitemRecordRequest,
    ) -> devops_20210625_models.CreateWorkitemRecordResponse:
        """
        @summary 登记实际工时
        
        @param request: CreateWorkitemRecordRequest
        @return: CreateWorkitemRecordResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_workitem_record_with_options_async(organization_id, request, headers, runtime)

    def create_workitem_v2with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateWorkitemV2Request,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateWorkitemV2Response:
        """
        @summary 创建工作项
        
        @param request: CreateWorkitemV2Request
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateWorkitemV2Response
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.assigned_to):
            body['assignedTo'] = request.assigned_to
        if not UtilClient.is_unset(request.category):
            body['category'] = request.category
        if not UtilClient.is_unset(request.description):
            body['description'] = request.description
        if not UtilClient.is_unset(request.field_value_list):
            body['fieldValueList'] = request.field_value_list
        if not UtilClient.is_unset(request.parent_identifier):
            body['parentIdentifier'] = request.parent_identifier
        if not UtilClient.is_unset(request.participants):
            body['participants'] = request.participants
        if not UtilClient.is_unset(request.space_identifier):
            body['spaceIdentifier'] = request.space_identifier
        if not UtilClient.is_unset(request.sprint_identifier):
            body['sprintIdentifier'] = request.sprint_identifier
        if not UtilClient.is_unset(request.subject):
            body['subject'] = request.subject
        if not UtilClient.is_unset(request.tags):
            body['tags'] = request.tags
        if not UtilClient.is_unset(request.trackers):
            body['trackers'] = request.trackers
        if not UtilClient.is_unset(request.verifier):
            body['verifier'] = request.verifier
        if not UtilClient.is_unset(request.versions):
            body['versions'] = request.versions
        if not UtilClient.is_unset(request.workitem_type_identifier):
            body['workitemTypeIdentifier'] = request.workitem_type_identifier
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateWorkitemV2',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitem',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateWorkitemV2Response(),
            self.call_api(params, req, runtime)
        )

    async def create_workitem_v2with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateWorkitemV2Request,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.CreateWorkitemV2Response:
        """
        @summary 创建工作项
        
        @param request: CreateWorkitemV2Request
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateWorkitemV2Response
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.assigned_to):
            body['assignedTo'] = request.assigned_to
        if not UtilClient.is_unset(request.category):
            body['category'] = request.category
        if not UtilClient.is_unset(request.description):
            body['description'] = request.description
        if not UtilClient.is_unset(request.field_value_list):
            body['fieldValueList'] = request.field_value_list
        if not UtilClient.is_unset(request.parent_identifier):
            body['parentIdentifier'] = request.parent_identifier
        if not UtilClient.is_unset(request.participants):
            body['participants'] = request.participants
        if not UtilClient.is_unset(request.space_identifier):
            body['spaceIdentifier'] = request.space_identifier
        if not UtilClient.is_unset(request.sprint_identifier):
            body['sprintIdentifier'] = request.sprint_identifier
        if not UtilClient.is_unset(request.subject):
            body['subject'] = request.subject
        if not UtilClient.is_unset(request.tags):
            body['tags'] = request.tags
        if not UtilClient.is_unset(request.trackers):
            body['trackers'] = request.trackers
        if not UtilClient.is_unset(request.verifier):
            body['verifier'] = request.verifier
        if not UtilClient.is_unset(request.versions):
            body['versions'] = request.versions
        if not UtilClient.is_unset(request.workitem_type_identifier):
            body['workitemTypeIdentifier'] = request.workitem_type_identifier
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateWorkitemV2',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitem',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.CreateWorkitemV2Response(),
            await self.call_api_async(params, req, runtime)
        )

    def create_workitem_v2(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateWorkitemV2Request,
    ) -> devops_20210625_models.CreateWorkitemV2Response:
        """
        @summary 创建工作项
        
        @param request: CreateWorkitemV2Request
        @return: CreateWorkitemV2Response
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.create_workitem_v2with_options(organization_id, request, headers, runtime)

    async def create_workitem_v2_async(
        self,
        organization_id: str,
        request: devops_20210625_models.CreateWorkitemV2Request,
    ) -> devops_20210625_models.CreateWorkitemV2Response:
        """
        @summary 创建工作项
        
        @param request: CreateWorkitemV2Request
        @return: CreateWorkitemV2Response
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.create_workitem_v2with_options_async(organization_id, request, headers, runtime)

    def delete_app_member_with_options(
        self,
        app_name: str,
        request: devops_20210625_models.DeleteAppMemberRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteAppMemberResponse:
        """
        @summary 删除应用成员
        
        @param request: DeleteAppMemberRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAppMemberResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.subject_id):
            query['subjectId'] = request.subject_id
        if not UtilClient.is_unset(request.subject_type):
            query['subjectType'] = request.subject_type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAppMember',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/appstack/apps/{OpenApiUtilClient.get_encode_param(app_name)}/members',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='string'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteAppMemberResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_app_member_with_options_async(
        self,
        app_name: str,
        request: devops_20210625_models.DeleteAppMemberRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteAppMemberResponse:
        """
        @summary 删除应用成员
        
        @param request: DeleteAppMemberRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAppMemberResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.subject_id):
            query['subjectId'] = request.subject_id
        if not UtilClient.is_unset(request.subject_type):
            query['subjectType'] = request.subject_type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAppMember',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/appstack/apps/{OpenApiUtilClient.get_encode_param(app_name)}/members',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='string'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteAppMemberResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_app_member(
        self,
        app_name: str,
        request: devops_20210625_models.DeleteAppMemberRequest,
    ) -> devops_20210625_models.DeleteAppMemberResponse:
        """
        @summary 删除应用成员
        
        @param request: DeleteAppMemberRequest
        @return: DeleteAppMemberResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_app_member_with_options(app_name, request, headers, runtime)

    async def delete_app_member_async(
        self,
        app_name: str,
        request: devops_20210625_models.DeleteAppMemberRequest,
    ) -> devops_20210625_models.DeleteAppMemberResponse:
        """
        @summary 删除应用成员
        
        @param request: DeleteAppMemberRequest
        @return: DeleteAppMemberResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_app_member_with_options_async(app_name, request, headers, runtime)

    def delete_branch_with_options(
        self,
        repository_id: str,
        request: devops_20210625_models.DeleteBranchRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteBranchResponse:
        """
        @summary 删除分支
        
        @param request: DeleteBranchRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteBranchResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.branch_name):
            query['branchName'] = request.branch_name
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBranch',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/branches/delete',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteBranchResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_branch_with_options_async(
        self,
        repository_id: str,
        request: devops_20210625_models.DeleteBranchRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteBranchResponse:
        """
        @summary 删除分支
        
        @param request: DeleteBranchRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteBranchResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.branch_name):
            query['branchName'] = request.branch_name
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBranch',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/branches/delete',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteBranchResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_branch(
        self,
        repository_id: str,
        request: devops_20210625_models.DeleteBranchRequest,
    ) -> devops_20210625_models.DeleteBranchResponse:
        """
        @summary 删除分支
        
        @param request: DeleteBranchRequest
        @return: DeleteBranchResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_branch_with_options(repository_id, request, headers, runtime)

    async def delete_branch_async(
        self,
        repository_id: str,
        request: devops_20210625_models.DeleteBranchRequest,
    ) -> devops_20210625_models.DeleteBranchResponse:
        """
        @summary 删除分支
        
        @param request: DeleteBranchRequest
        @return: DeleteBranchResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_branch_with_options_async(repository_id, request, headers, runtime)

    def delete_file_with_options(
        self,
        repository_id: str,
        request: devops_20210625_models.DeleteFileRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteFileResponse:
        """
        @summary 删除文件
        
        @param request: DeleteFileRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteFileResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.branch_name):
            query['branchName'] = request.branch_name
        if not UtilClient.is_unset(request.commit_message):
            query['commitMessage'] = request.commit_message
        if not UtilClient.is_unset(request.file_path):
            query['filePath'] = request.file_path
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteFile',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/files/delete',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteFileResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_file_with_options_async(
        self,
        repository_id: str,
        request: devops_20210625_models.DeleteFileRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteFileResponse:
        """
        @summary 删除文件
        
        @param request: DeleteFileRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteFileResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.branch_name):
            query['branchName'] = request.branch_name
        if not UtilClient.is_unset(request.commit_message):
            query['commitMessage'] = request.commit_message
        if not UtilClient.is_unset(request.file_path):
            query['filePath'] = request.file_path
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteFile',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/files/delete',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteFileResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_file(
        self,
        repository_id: str,
        request: devops_20210625_models.DeleteFileRequest,
    ) -> devops_20210625_models.DeleteFileResponse:
        """
        @summary 删除文件
        
        @param request: DeleteFileRequest
        @return: DeleteFileResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_file_with_options(repository_id, request, headers, runtime)

    async def delete_file_async(
        self,
        repository_id: str,
        request: devops_20210625_models.DeleteFileRequest,
    ) -> devops_20210625_models.DeleteFileResponse:
        """
        @summary 删除文件
        
        @param request: DeleteFileRequest
        @return: DeleteFileResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_file_with_options_async(repository_id, request, headers, runtime)

    def delete_flow_tag_with_options(
        self,
        organization_id: str,
        id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteFlowTagResponse:
        """
        @summary 删除标签
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteFlowTagResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='DeleteFlowTag',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/flow/tags/{OpenApiUtilClient.get_encode_param(id)}',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteFlowTagResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_flow_tag_with_options_async(
        self,
        organization_id: str,
        id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteFlowTagResponse:
        """
        @summary 删除标签
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteFlowTagResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='DeleteFlowTag',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/flow/tags/{OpenApiUtilClient.get_encode_param(id)}',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteFlowTagResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_flow_tag(
        self,
        organization_id: str,
        id: str,
    ) -> devops_20210625_models.DeleteFlowTagResponse:
        """
        @summary 删除标签
        
        @return: DeleteFlowTagResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_flow_tag_with_options(organization_id, id, headers, runtime)

    async def delete_flow_tag_async(
        self,
        organization_id: str,
        id: str,
    ) -> devops_20210625_models.DeleteFlowTagResponse:
        """
        @summary 删除标签
        
        @return: DeleteFlowTagResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_flow_tag_with_options_async(organization_id, id, headers, runtime)

    def delete_flow_tag_group_with_options(
        self,
        organization_id: str,
        id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteFlowTagGroupResponse:
        """
        @summary 删除标签分类
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteFlowTagGroupResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='DeleteFlowTagGroup',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/flow/tagGroups/{OpenApiUtilClient.get_encode_param(id)}',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteFlowTagGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_flow_tag_group_with_options_async(
        self,
        organization_id: str,
        id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteFlowTagGroupResponse:
        """
        @summary 删除标签分类
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteFlowTagGroupResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='DeleteFlowTagGroup',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/flow/tagGroups/{OpenApiUtilClient.get_encode_param(id)}',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteFlowTagGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_flow_tag_group(
        self,
        organization_id: str,
        id: str,
    ) -> devops_20210625_models.DeleteFlowTagGroupResponse:
        """
        @summary 删除标签分类
        
        @return: DeleteFlowTagGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_flow_tag_group_with_options(organization_id, id, headers, runtime)

    async def delete_flow_tag_group_async(
        self,
        organization_id: str,
        id: str,
    ) -> devops_20210625_models.DeleteFlowTagGroupResponse:
        """
        @summary 删除标签分类
        
        @return: DeleteFlowTagGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_flow_tag_group_with_options_async(organization_id, id, headers, runtime)

    def delete_group_member_with_options(
        self,
        group_id: str,
        request: devops_20210625_models.DeleteGroupMemberRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteGroupMemberResponse:
        """
        @summary 删除组成员
        
        @param request: DeleteGroupMemberRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteGroupMemberResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.aliyun_pk):
            query['aliyunPk'] = request.aliyun_pk
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.member_type):
            body['memberType'] = request.member_type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='DeleteGroupMember',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/groups/{OpenApiUtilClient.get_encode_param(group_id)}/members/remove/aliyun_pk',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteGroupMemberResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_group_member_with_options_async(
        self,
        group_id: str,
        request: devops_20210625_models.DeleteGroupMemberRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteGroupMemberResponse:
        """
        @summary 删除组成员
        
        @param request: DeleteGroupMemberRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteGroupMemberResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.aliyun_pk):
            query['aliyunPk'] = request.aliyun_pk
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.member_type):
            body['memberType'] = request.member_type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='DeleteGroupMember',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/groups/{OpenApiUtilClient.get_encode_param(group_id)}/members/remove/aliyun_pk',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteGroupMemberResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_group_member(
        self,
        group_id: str,
        request: devops_20210625_models.DeleteGroupMemberRequest,
    ) -> devops_20210625_models.DeleteGroupMemberResponse:
        """
        @summary 删除组成员
        
        @param request: DeleteGroupMemberRequest
        @return: DeleteGroupMemberResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_group_member_with_options(group_id, request, headers, runtime)

    async def delete_group_member_async(
        self,
        group_id: str,
        request: devops_20210625_models.DeleteGroupMemberRequest,
    ) -> devops_20210625_models.DeleteGroupMemberResponse:
        """
        @summary 删除组成员
        
        @param request: DeleteGroupMemberRequest
        @return: DeleteGroupMemberResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_group_member_with_options_async(group_id, request, headers, runtime)

    def delete_host_group_with_options(
        self,
        organization_id: str,
        id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteHostGroupResponse:
        """
        @summary 删除主机组
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteHostGroupResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='DeleteHostGroup',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/hostGroups/{OpenApiUtilClient.get_encode_param(id)}',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteHostGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_host_group_with_options_async(
        self,
        organization_id: str,
        id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteHostGroupResponse:
        """
        @summary 删除主机组
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteHostGroupResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='DeleteHostGroup',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/hostGroups/{OpenApiUtilClient.get_encode_param(id)}',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteHostGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_host_group(
        self,
        organization_id: str,
        id: str,
    ) -> devops_20210625_models.DeleteHostGroupResponse:
        """
        @summary 删除主机组
        
        @return: DeleteHostGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_host_group_with_options(organization_id, id, headers, runtime)

    async def delete_host_group_async(
        self,
        organization_id: str,
        id: str,
    ) -> devops_20210625_models.DeleteHostGroupResponse:
        """
        @summary 删除主机组
        
        @return: DeleteHostGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_host_group_with_options_async(organization_id, id, headers, runtime)

    def delete_pipeline_with_options(
        self,
        organization_id: str,
        pipeline_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeletePipelineResponse:
        """
        @summary 删除流水线
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePipelineResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='DeletePipeline',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines/{OpenApiUtilClient.get_encode_param(pipeline_id)}',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeletePipelineResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_pipeline_with_options_async(
        self,
        organization_id: str,
        pipeline_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeletePipelineResponse:
        """
        @summary 删除流水线
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePipelineResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='DeletePipeline',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines/{OpenApiUtilClient.get_encode_param(pipeline_id)}',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeletePipelineResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_pipeline(
        self,
        organization_id: str,
        pipeline_id: str,
    ) -> devops_20210625_models.DeletePipelineResponse:
        """
        @summary 删除流水线
        
        @return: DeletePipelineResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_pipeline_with_options(organization_id, pipeline_id, headers, runtime)

    async def delete_pipeline_async(
        self,
        organization_id: str,
        pipeline_id: str,
    ) -> devops_20210625_models.DeletePipelineResponse:
        """
        @summary 删除流水线
        
        @return: DeletePipelineResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_pipeline_with_options_async(organization_id, pipeline_id, headers, runtime)

    def delete_pipeline_group_with_options(
        self,
        organization_id: str,
        group_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeletePipelineGroupResponse:
        """
        @summary 删除流水线分组
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePipelineGroupResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='DeletePipelineGroup',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelineGroups/{OpenApiUtilClient.get_encode_param(group_id)}',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeletePipelineGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_pipeline_group_with_options_async(
        self,
        organization_id: str,
        group_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeletePipelineGroupResponse:
        """
        @summary 删除流水线分组
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePipelineGroupResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='DeletePipelineGroup',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelineGroups/{OpenApiUtilClient.get_encode_param(group_id)}',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeletePipelineGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_pipeline_group(
        self,
        organization_id: str,
        group_id: str,
    ) -> devops_20210625_models.DeletePipelineGroupResponse:
        """
        @summary 删除流水线分组
        
        @return: DeletePipelineGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_pipeline_group_with_options(organization_id, group_id, headers, runtime)

    async def delete_pipeline_group_async(
        self,
        organization_id: str,
        group_id: str,
    ) -> devops_20210625_models.DeletePipelineGroupResponse:
        """
        @summary 删除流水线分组
        
        @return: DeletePipelineGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_pipeline_group_with_options_async(organization_id, group_id, headers, runtime)

    def delete_pipeline_relations_with_options(
        self,
        organization_id: str,
        pipeline_id: str,
        request: devops_20210625_models.DeletePipelineRelationsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeletePipelineRelationsResponse:
        """
        @summary 删除流水线关联
        
        @param request: DeletePipelineRelationsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePipelineRelationsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.rel_object_id):
            query['relObjectId'] = request.rel_object_id
        if not UtilClient.is_unset(request.rel_object_type):
            query['relObjectType'] = request.rel_object_type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePipelineRelations',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/{OpenApiUtilClient.get_encode_param(pipeline_id)}/pipelineRelations',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeletePipelineRelationsResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_pipeline_relations_with_options_async(
        self,
        organization_id: str,
        pipeline_id: str,
        request: devops_20210625_models.DeletePipelineRelationsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeletePipelineRelationsResponse:
        """
        @summary 删除流水线关联
        
        @param request: DeletePipelineRelationsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePipelineRelationsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.rel_object_id):
            query['relObjectId'] = request.rel_object_id
        if not UtilClient.is_unset(request.rel_object_type):
            query['relObjectType'] = request.rel_object_type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePipelineRelations',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/{OpenApiUtilClient.get_encode_param(pipeline_id)}/pipelineRelations',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeletePipelineRelationsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_pipeline_relations(
        self,
        organization_id: str,
        pipeline_id: str,
        request: devops_20210625_models.DeletePipelineRelationsRequest,
    ) -> devops_20210625_models.DeletePipelineRelationsResponse:
        """
        @summary 删除流水线关联
        
        @param request: DeletePipelineRelationsRequest
        @return: DeletePipelineRelationsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_pipeline_relations_with_options(organization_id, pipeline_id, request, headers, runtime)

    async def delete_pipeline_relations_async(
        self,
        organization_id: str,
        pipeline_id: str,
        request: devops_20210625_models.DeletePipelineRelationsRequest,
    ) -> devops_20210625_models.DeletePipelineRelationsResponse:
        """
        @summary 删除流水线关联
        
        @param request: DeletePipelineRelationsRequest
        @return: DeletePipelineRelationsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_pipeline_relations_with_options_async(organization_id, pipeline_id, request, headers, runtime)

    def delete_project_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.DeleteProjectRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteProjectResponse:
        """
        @summary 删除项目
        
        @param request: DeleteProjectRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteProjectResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.identifier):
            query['identifier'] = request.identifier
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteProject',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/projects/delete',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteProjectResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_project_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.DeleteProjectRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteProjectResponse:
        """
        @summary 删除项目
        
        @param request: DeleteProjectRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteProjectResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.identifier):
            query['identifier'] = request.identifier
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteProject',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/projects/delete',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteProjectResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_project(
        self,
        organization_id: str,
        request: devops_20210625_models.DeleteProjectRequest,
    ) -> devops_20210625_models.DeleteProjectResponse:
        """
        @summary 删除项目
        
        @param request: DeleteProjectRequest
        @return: DeleteProjectResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_project_with_options(organization_id, request, headers, runtime)

    async def delete_project_async(
        self,
        organization_id: str,
        request: devops_20210625_models.DeleteProjectRequest,
    ) -> devops_20210625_models.DeleteProjectResponse:
        """
        @summary 删除项目
        
        @param request: DeleteProjectRequest
        @return: DeleteProjectResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_project_with_options_async(organization_id, request, headers, runtime)

    def delete_project_label_with_options(
        self,
        label_id: str,
        request: devops_20210625_models.DeleteProjectLabelRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteProjectLabelResponse:
        """
        @summary 删除代码库Label
        
        @param request: DeleteProjectLabelRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteProjectLabelResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.repository_identity):
            query['repositoryIdentity'] = request.repository_identity
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteProjectLabel',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/labels/{OpenApiUtilClient.get_encode_param(label_id)}',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteProjectLabelResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_project_label_with_options_async(
        self,
        label_id: str,
        request: devops_20210625_models.DeleteProjectLabelRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteProjectLabelResponse:
        """
        @summary 删除代码库Label
        
        @param request: DeleteProjectLabelRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteProjectLabelResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.repository_identity):
            query['repositoryIdentity'] = request.repository_identity
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteProjectLabel',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/labels/{OpenApiUtilClient.get_encode_param(label_id)}',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteProjectLabelResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_project_label(
        self,
        label_id: str,
        request: devops_20210625_models.DeleteProjectLabelRequest,
    ) -> devops_20210625_models.DeleteProjectLabelResponse:
        """
        @summary 删除代码库Label
        
        @param request: DeleteProjectLabelRequest
        @return: DeleteProjectLabelResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_project_label_with_options(label_id, request, headers, runtime)

    async def delete_project_label_async(
        self,
        label_id: str,
        request: devops_20210625_models.DeleteProjectLabelRequest,
    ) -> devops_20210625_models.DeleteProjectLabelResponse:
        """
        @summary 删除代码库Label
        
        @param request: DeleteProjectLabelRequest
        @return: DeleteProjectLabelResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_project_label_with_options_async(label_id, request, headers, runtime)

    def delete_protected_branch_with_options(
        self,
        repository_id: str,
        protected_branch_id: str,
        request: devops_20210625_models.DeleteProtectedBranchRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteProtectedBranchResponse:
        """
        @summary 删除保护分支
        
        @param request: DeleteProtectedBranchRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteProtectedBranchResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteProtectedBranch',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/protect_branches/{OpenApiUtilClient.get_encode_param(protected_branch_id)}',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteProtectedBranchResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_protected_branch_with_options_async(
        self,
        repository_id: str,
        protected_branch_id: str,
        request: devops_20210625_models.DeleteProtectedBranchRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteProtectedBranchResponse:
        """
        @summary 删除保护分支
        
        @param request: DeleteProtectedBranchRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteProtectedBranchResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteProtectedBranch',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/protect_branches/{OpenApiUtilClient.get_encode_param(protected_branch_id)}',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteProtectedBranchResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_protected_branch(
        self,
        repository_id: str,
        protected_branch_id: str,
        request: devops_20210625_models.DeleteProtectedBranchRequest,
    ) -> devops_20210625_models.DeleteProtectedBranchResponse:
        """
        @summary 删除保护分支
        
        @param request: DeleteProtectedBranchRequest
        @return: DeleteProtectedBranchResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_protected_branch_with_options(repository_id, protected_branch_id, request, headers, runtime)

    async def delete_protected_branch_async(
        self,
        repository_id: str,
        protected_branch_id: str,
        request: devops_20210625_models.DeleteProtectedBranchRequest,
    ) -> devops_20210625_models.DeleteProtectedBranchResponse:
        """
        @summary 删除保护分支
        
        @param request: DeleteProtectedBranchRequest
        @return: DeleteProtectedBranchResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_protected_branch_with_options_async(repository_id, protected_branch_id, request, headers, runtime)

    def delete_push_rule_with_options(
        self,
        repository_id: str,
        push_rule_id: str,
        request: devops_20210625_models.DeletePushRuleRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeletePushRuleResponse:
        """
        @summary 删除推送规则
        
        @param request: DeletePushRuleRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePushRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePushRule',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/{OpenApiUtilClient.get_encode_param(repository_id)}/push_rule/{OpenApiUtilClient.get_encode_param(push_rule_id)}',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeletePushRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_push_rule_with_options_async(
        self,
        repository_id: str,
        push_rule_id: str,
        request: devops_20210625_models.DeletePushRuleRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeletePushRuleResponse:
        """
        @summary 删除推送规则
        
        @param request: DeletePushRuleRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePushRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePushRule',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/{OpenApiUtilClient.get_encode_param(repository_id)}/push_rule/{OpenApiUtilClient.get_encode_param(push_rule_id)}',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeletePushRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_push_rule(
        self,
        repository_id: str,
        push_rule_id: str,
        request: devops_20210625_models.DeletePushRuleRequest,
    ) -> devops_20210625_models.DeletePushRuleResponse:
        """
        @summary 删除推送规则
        
        @param request: DeletePushRuleRequest
        @return: DeletePushRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_push_rule_with_options(repository_id, push_rule_id, request, headers, runtime)

    async def delete_push_rule_async(
        self,
        repository_id: str,
        push_rule_id: str,
        request: devops_20210625_models.DeletePushRuleRequest,
    ) -> devops_20210625_models.DeletePushRuleResponse:
        """
        @summary 删除推送规则
        
        @param request: DeletePushRuleRequest
        @return: DeletePushRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_push_rule_with_options_async(repository_id, push_rule_id, request, headers, runtime)

    def delete_repository_with_options(
        self,
        repository_id: str,
        request: devops_20210625_models.DeleteRepositoryRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteRepositoryResponse:
        """
        @summary 删除代码库
        
        @param request: DeleteRepositoryRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteRepositoryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.reason):
            body['reason'] = request.reason
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='DeleteRepository',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/remove',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteRepositoryResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_repository_with_options_async(
        self,
        repository_id: str,
        request: devops_20210625_models.DeleteRepositoryRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteRepositoryResponse:
        """
        @summary 删除代码库
        
        @param request: DeleteRepositoryRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteRepositoryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.reason):
            body['reason'] = request.reason
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='DeleteRepository',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/remove',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteRepositoryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_repository(
        self,
        repository_id: str,
        request: devops_20210625_models.DeleteRepositoryRequest,
    ) -> devops_20210625_models.DeleteRepositoryResponse:
        """
        @summary 删除代码库
        
        @param request: DeleteRepositoryRequest
        @return: DeleteRepositoryResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_repository_with_options(repository_id, request, headers, runtime)

    async def delete_repository_async(
        self,
        repository_id: str,
        request: devops_20210625_models.DeleteRepositoryRequest,
    ) -> devops_20210625_models.DeleteRepositoryResponse:
        """
        @summary 删除代码库
        
        @param request: DeleteRepositoryRequest
        @return: DeleteRepositoryResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_repository_with_options_async(repository_id, request, headers, runtime)

    def delete_repository_group_with_options(
        self,
        group_id: str,
        request: devops_20210625_models.DeleteRepositoryGroupRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteRepositoryGroupResponse:
        """
        @summary 删除代码组
        
        @param request: DeleteRepositoryGroupRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteRepositoryGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.reason):
            body['reason'] = request.reason
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='DeleteRepositoryGroup',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/groups/{OpenApiUtilClient.get_encode_param(group_id)}/remove',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteRepositoryGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_repository_group_with_options_async(
        self,
        group_id: str,
        request: devops_20210625_models.DeleteRepositoryGroupRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteRepositoryGroupResponse:
        """
        @summary 删除代码组
        
        @param request: DeleteRepositoryGroupRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteRepositoryGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.reason):
            body['reason'] = request.reason
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='DeleteRepositoryGroup',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/groups/{OpenApiUtilClient.get_encode_param(group_id)}/remove',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteRepositoryGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_repository_group(
        self,
        group_id: str,
        request: devops_20210625_models.DeleteRepositoryGroupRequest,
    ) -> devops_20210625_models.DeleteRepositoryGroupResponse:
        """
        @summary 删除代码组
        
        @param request: DeleteRepositoryGroupRequest
        @return: DeleteRepositoryGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_repository_group_with_options(group_id, request, headers, runtime)

    async def delete_repository_group_async(
        self,
        group_id: str,
        request: devops_20210625_models.DeleteRepositoryGroupRequest,
    ) -> devops_20210625_models.DeleteRepositoryGroupResponse:
        """
        @summary 删除代码组
        
        @param request: DeleteRepositoryGroupRequest
        @return: DeleteRepositoryGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_repository_group_with_options_async(group_id, request, headers, runtime)

    def delete_repository_member_with_options(
        self,
        repository_id: str,
        aliyun_pk: str,
        request: devops_20210625_models.DeleteRepositoryMemberRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteRepositoryMemberResponse:
        """
        @summary 删除代码库成员
        
        @param request: DeleteRepositoryMemberRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteRepositoryMemberResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.member_type):
            body['memberType'] = request.member_type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='DeleteRepositoryMember',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/members/delete/{OpenApiUtilClient.get_encode_param(aliyun_pk)}',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteRepositoryMemberResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_repository_member_with_options_async(
        self,
        repository_id: str,
        aliyun_pk: str,
        request: devops_20210625_models.DeleteRepositoryMemberRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteRepositoryMemberResponse:
        """
        @summary 删除代码库成员
        
        @param request: DeleteRepositoryMemberRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteRepositoryMemberResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.member_type):
            body['memberType'] = request.member_type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='DeleteRepositoryMember',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/members/delete/{OpenApiUtilClient.get_encode_param(aliyun_pk)}',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteRepositoryMemberResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_repository_member(
        self,
        repository_id: str,
        aliyun_pk: str,
        request: devops_20210625_models.DeleteRepositoryMemberRequest,
    ) -> devops_20210625_models.DeleteRepositoryMemberResponse:
        """
        @summary 删除代码库成员
        
        @param request: DeleteRepositoryMemberRequest
        @return: DeleteRepositoryMemberResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_repository_member_with_options(repository_id, aliyun_pk, request, headers, runtime)

    async def delete_repository_member_async(
        self,
        repository_id: str,
        aliyun_pk: str,
        request: devops_20210625_models.DeleteRepositoryMemberRequest,
    ) -> devops_20210625_models.DeleteRepositoryMemberResponse:
        """
        @summary 删除代码库成员
        
        @param request: DeleteRepositoryMemberRequest
        @return: DeleteRepositoryMemberResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_repository_member_with_options_async(repository_id, aliyun_pk, request, headers, runtime)

    def delete_repository_webhook_with_options(
        self,
        repository_id: str,
        hook_id: str,
        request: devops_20210625_models.DeleteRepositoryWebhookRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteRepositoryWebhookResponse:
        """
        @summary 删除代码库Webhook
        
        @param request: DeleteRepositoryWebhookRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteRepositoryWebhookResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteRepositoryWebhook',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/hooks/{OpenApiUtilClient.get_encode_param(hook_id)}',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteRepositoryWebhookResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_repository_webhook_with_options_async(
        self,
        repository_id: str,
        hook_id: str,
        request: devops_20210625_models.DeleteRepositoryWebhookRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteRepositoryWebhookResponse:
        """
        @summary 删除代码库Webhook
        
        @param request: DeleteRepositoryWebhookRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteRepositoryWebhookResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteRepositoryWebhook',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/hooks/{OpenApiUtilClient.get_encode_param(hook_id)}',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteRepositoryWebhookResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_repository_webhook(
        self,
        repository_id: str,
        hook_id: str,
        request: devops_20210625_models.DeleteRepositoryWebhookRequest,
    ) -> devops_20210625_models.DeleteRepositoryWebhookResponse:
        """
        @summary 删除代码库Webhook
        
        @param request: DeleteRepositoryWebhookRequest
        @return: DeleteRepositoryWebhookResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_repository_webhook_with_options(repository_id, hook_id, request, headers, runtime)

    async def delete_repository_webhook_async(
        self,
        repository_id: str,
        hook_id: str,
        request: devops_20210625_models.DeleteRepositoryWebhookRequest,
    ) -> devops_20210625_models.DeleteRepositoryWebhookResponse:
        """
        @summary 删除代码库Webhook
        
        @param request: DeleteRepositoryWebhookRequest
        @return: DeleteRepositoryWebhookResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_repository_webhook_with_options_async(repository_id, hook_id, request, headers, runtime)

    def delete_resource_member_with_options(
        self,
        organization_id: str,
        resource_type: str,
        resource_id: str,
        account_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteResourceMemberResponse:
        """
        @summary 删除资源成员
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteResourceMemberResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='DeleteResourceMember',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/{OpenApiUtilClient.get_encode_param(resource_type)}/{OpenApiUtilClient.get_encode_param(resource_id)}/members/{OpenApiUtilClient.get_encode_param(account_id)}',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteResourceMemberResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_resource_member_with_options_async(
        self,
        organization_id: str,
        resource_type: str,
        resource_id: str,
        account_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteResourceMemberResponse:
        """
        @summary 删除资源成员
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteResourceMemberResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='DeleteResourceMember',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/{OpenApiUtilClient.get_encode_param(resource_type)}/{OpenApiUtilClient.get_encode_param(resource_id)}/members/{OpenApiUtilClient.get_encode_param(account_id)}',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteResourceMemberResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_resource_member(
        self,
        organization_id: str,
        resource_type: str,
        resource_id: str,
        account_id: str,
    ) -> devops_20210625_models.DeleteResourceMemberResponse:
        """
        @summary 删除资源成员
        
        @return: DeleteResourceMemberResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_resource_member_with_options(organization_id, resource_type, resource_id, account_id, headers, runtime)

    async def delete_resource_member_async(
        self,
        organization_id: str,
        resource_type: str,
        resource_id: str,
        account_id: str,
    ) -> devops_20210625_models.DeleteResourceMemberResponse:
        """
        @summary 删除资源成员
        
        @return: DeleteResourceMemberResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_resource_member_with_options_async(organization_id, resource_type, resource_id, account_id, headers, runtime)

    def delete_tag_with_options(
        self,
        repository_id: str,
        request: devops_20210625_models.DeleteTagRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteTagResponse:
        """
        @summary 删除标签
        
        @param request: DeleteTagRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteTagResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.tag_name):
            query['tagName'] = request.tag_name
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteTag',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/tags/delete',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteTagResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_tag_with_options_async(
        self,
        repository_id: str,
        request: devops_20210625_models.DeleteTagRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteTagResponse:
        """
        @summary 删除标签
        
        @param request: DeleteTagRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteTagResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.tag_name):
            query['tagName'] = request.tag_name
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteTag',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/tags/delete',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteTagResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_tag(
        self,
        repository_id: str,
        request: devops_20210625_models.DeleteTagRequest,
    ) -> devops_20210625_models.DeleteTagResponse:
        """
        @summary 删除标签
        
        @param request: DeleteTagRequest
        @return: DeleteTagResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_tag_with_options(repository_id, request, headers, runtime)

    async def delete_tag_async(
        self,
        repository_id: str,
        request: devops_20210625_models.DeleteTagRequest,
    ) -> devops_20210625_models.DeleteTagResponse:
        """
        @summary 删除标签
        
        @param request: DeleteTagRequest
        @return: DeleteTagResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_tag_with_options_async(repository_id, request, headers, runtime)

    def delete_user_key_with_options(
        self,
        key_id: str,
        request: devops_20210625_models.DeleteUserKeyRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteUserKeyResponse:
        """
        @summary 删除用户的SSH Key
        
        @param request: DeleteUserKeyRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteUserKeyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteUserKey',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v3/user/keys/{OpenApiUtilClient.get_encode_param(key_id)}',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteUserKeyResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_user_key_with_options_async(
        self,
        key_id: str,
        request: devops_20210625_models.DeleteUserKeyRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteUserKeyResponse:
        """
        @summary 删除用户的SSH Key
        
        @param request: DeleteUserKeyRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteUserKeyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteUserKey',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v3/user/keys/{OpenApiUtilClient.get_encode_param(key_id)}',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteUserKeyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_user_key(
        self,
        key_id: str,
        request: devops_20210625_models.DeleteUserKeyRequest,
    ) -> devops_20210625_models.DeleteUserKeyResponse:
        """
        @summary 删除用户的SSH Key
        
        @param request: DeleteUserKeyRequest
        @return: DeleteUserKeyResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_user_key_with_options(key_id, request, headers, runtime)

    async def delete_user_key_async(
        self,
        key_id: str,
        request: devops_20210625_models.DeleteUserKeyRequest,
    ) -> devops_20210625_models.DeleteUserKeyResponse:
        """
        @summary 删除用户的SSH Key
        
        @param request: DeleteUserKeyRequest
        @return: DeleteUserKeyResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_user_key_with_options_async(key_id, request, headers, runtime)

    def delete_variable_group_with_options(
        self,
        organization_id: str,
        id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteVariableGroupResponse:
        """
        @summary 删除变量组
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVariableGroupResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='DeleteVariableGroup',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/variableGroups/{OpenApiUtilClient.get_encode_param(id)}',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteVariableGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_variable_group_with_options_async(
        self,
        organization_id: str,
        id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteVariableGroupResponse:
        """
        @summary 删除变量组
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVariableGroupResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='DeleteVariableGroup',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/variableGroups/{OpenApiUtilClient.get_encode_param(id)}',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteVariableGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_variable_group(
        self,
        organization_id: str,
        id: str,
    ) -> devops_20210625_models.DeleteVariableGroupResponse:
        """
        @summary 删除变量组
        
        @return: DeleteVariableGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_variable_group_with_options(organization_id, id, headers, runtime)

    async def delete_variable_group_async(
        self,
        organization_id: str,
        id: str,
    ) -> devops_20210625_models.DeleteVariableGroupResponse:
        """
        @summary 删除变量组
        
        @return: DeleteVariableGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_variable_group_with_options_async(organization_id, id, headers, runtime)

    def delete_workitem_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.DeleteWorkitemRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteWorkitemResponse:
        """
        @summary 删除工作项
        
        @param request: DeleteWorkitemRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteWorkitemResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.identifier):
            query['identifier'] = request.identifier
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteWorkitem',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitem/delete',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteWorkitemResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_workitem_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.DeleteWorkitemRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteWorkitemResponse:
        """
        @summary 删除工作项
        
        @param request: DeleteWorkitemRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteWorkitemResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.identifier):
            query['identifier'] = request.identifier
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteWorkitem',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitem/delete',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteWorkitemResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_workitem(
        self,
        organization_id: str,
        request: devops_20210625_models.DeleteWorkitemRequest,
    ) -> devops_20210625_models.DeleteWorkitemResponse:
        """
        @summary 删除工作项
        
        @param request: DeleteWorkitemRequest
        @return: DeleteWorkitemResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_workitem_with_options(organization_id, request, headers, runtime)

    async def delete_workitem_async(
        self,
        organization_id: str,
        request: devops_20210625_models.DeleteWorkitemRequest,
    ) -> devops_20210625_models.DeleteWorkitemResponse:
        """
        @summary 删除工作项
        
        @param request: DeleteWorkitemRequest
        @return: DeleteWorkitemResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_workitem_with_options_async(organization_id, request, headers, runtime)

    def delete_workitem_all_comment_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.DeleteWorkitemAllCommentRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteWorkitemAllCommentResponse:
        """
        @summary 删除所有评论
        
        @param request: DeleteWorkitemAllCommentRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteWorkitemAllCommentResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.identifier):
            query['identifier'] = request.identifier
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteWorkitemAllComment',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitems/deleteAllComment',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteWorkitemAllCommentResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_workitem_all_comment_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.DeleteWorkitemAllCommentRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteWorkitemAllCommentResponse:
        """
        @summary 删除所有评论
        
        @param request: DeleteWorkitemAllCommentRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteWorkitemAllCommentResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.identifier):
            query['identifier'] = request.identifier
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteWorkitemAllComment',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitems/deleteAllComment',
            method='DELETE',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteWorkitemAllCommentResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_workitem_all_comment(
        self,
        organization_id: str,
        request: devops_20210625_models.DeleteWorkitemAllCommentRequest,
    ) -> devops_20210625_models.DeleteWorkitemAllCommentResponse:
        """
        @summary 删除所有评论
        
        @param request: DeleteWorkitemAllCommentRequest
        @return: DeleteWorkitemAllCommentResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_workitem_all_comment_with_options(organization_id, request, headers, runtime)

    async def delete_workitem_all_comment_async(
        self,
        organization_id: str,
        request: devops_20210625_models.DeleteWorkitemAllCommentRequest,
    ) -> devops_20210625_models.DeleteWorkitemAllCommentResponse:
        """
        @summary 删除所有评论
        
        @param request: DeleteWorkitemAllCommentRequest
        @return: DeleteWorkitemAllCommentResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_workitem_all_comment_with_options_async(organization_id, request, headers, runtime)

    def delete_workitem_comment_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.DeleteWorkitemCommentRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteWorkitemCommentResponse:
        """
        @summary 删除单条评论
        
        @param request: DeleteWorkitemCommentRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteWorkitemCommentResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.comment_id):
            body['commentId'] = request.comment_id
        if not UtilClient.is_unset(request.identifier):
            body['identifier'] = request.identifier
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='DeleteWorkitemComment',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitems/deleteComent',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteWorkitemCommentResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_workitem_comment_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.DeleteWorkitemCommentRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.DeleteWorkitemCommentResponse:
        """
        @summary 删除单条评论
        
        @param request: DeleteWorkitemCommentRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteWorkitemCommentResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.comment_id):
            body['commentId'] = request.comment_id
        if not UtilClient.is_unset(request.identifier):
            body['identifier'] = request.identifier
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='DeleteWorkitemComment',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitems/deleteComent',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.DeleteWorkitemCommentResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_workitem_comment(
        self,
        organization_id: str,
        request: devops_20210625_models.DeleteWorkitemCommentRequest,
    ) -> devops_20210625_models.DeleteWorkitemCommentResponse:
        """
        @summary 删除单条评论
        
        @param request: DeleteWorkitemCommentRequest
        @return: DeleteWorkitemCommentResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.delete_workitem_comment_with_options(organization_id, request, headers, runtime)

    async def delete_workitem_comment_async(
        self,
        organization_id: str,
        request: devops_20210625_models.DeleteWorkitemCommentRequest,
    ) -> devops_20210625_models.DeleteWorkitemCommentResponse:
        """
        @summary 删除单条评论
        
        @param request: DeleteWorkitemCommentRequest
        @return: DeleteWorkitemCommentResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.delete_workitem_comment_with_options_async(organization_id, request, headers, runtime)

    def enable_deploy_key_with_options(
        self,
        repository_id: str,
        key_id: str,
        request: devops_20210625_models.EnableDeployKeyRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.EnableDeployKeyResponse:
        """
        @summary 启用部署密钥
        
        @param request: EnableDeployKeyRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: EnableDeployKeyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='EnableDeployKey',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/keys/{OpenApiUtilClient.get_encode_param(key_id)}/enable',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.EnableDeployKeyResponse(),
            self.call_api(params, req, runtime)
        )

    async def enable_deploy_key_with_options_async(
        self,
        repository_id: str,
        key_id: str,
        request: devops_20210625_models.EnableDeployKeyRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.EnableDeployKeyResponse:
        """
        @summary 启用部署密钥
        
        @param request: EnableDeployKeyRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: EnableDeployKeyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='EnableDeployKey',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/keys/{OpenApiUtilClient.get_encode_param(key_id)}/enable',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.EnableDeployKeyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def enable_deploy_key(
        self,
        repository_id: str,
        key_id: str,
        request: devops_20210625_models.EnableDeployKeyRequest,
    ) -> devops_20210625_models.EnableDeployKeyResponse:
        """
        @summary 启用部署密钥
        
        @param request: EnableDeployKeyRequest
        @return: EnableDeployKeyResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.enable_deploy_key_with_options(repository_id, key_id, request, headers, runtime)

    async def enable_deploy_key_async(
        self,
        repository_id: str,
        key_id: str,
        request: devops_20210625_models.EnableDeployKeyRequest,
    ) -> devops_20210625_models.EnableDeployKeyResponse:
        """
        @summary 启用部署密钥
        
        @param request: EnableDeployKeyRequest
        @return: EnableDeployKeyResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.enable_deploy_key_with_options_async(repository_id, key_id, request, headers, runtime)

    def execute_change_request_release_stage_with_options(
        self,
        app_name: str,
        release_workflow_sn: str,
        release_stage_sn: str,
        request: devops_20210625_models.ExecuteChangeRequestReleaseStageRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ExecuteChangeRequestReleaseStageResponse:
        """
        @summary 执行研发阶段流水线
        
        @param request: ExecuteChangeRequestReleaseStageRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExecuteChangeRequestReleaseStageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.params):
            body['params'] = request.params
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ExecuteChangeRequestReleaseStage',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/appstack/apps/{OpenApiUtilClient.get_encode_param(app_name)}/releaseWorkflows/{OpenApiUtilClient.get_encode_param(release_workflow_sn)}/releaseStages/{OpenApiUtilClient.get_encode_param(release_stage_sn)}%3Aexecute',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ExecuteChangeRequestReleaseStageResponse(),
            self.call_api(params, req, runtime)
        )

    async def execute_change_request_release_stage_with_options_async(
        self,
        app_name: str,
        release_workflow_sn: str,
        release_stage_sn: str,
        request: devops_20210625_models.ExecuteChangeRequestReleaseStageRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ExecuteChangeRequestReleaseStageResponse:
        """
        @summary 执行研发阶段流水线
        
        @param request: ExecuteChangeRequestReleaseStageRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExecuteChangeRequestReleaseStageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.params):
            body['params'] = request.params
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ExecuteChangeRequestReleaseStage',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/appstack/apps/{OpenApiUtilClient.get_encode_param(app_name)}/releaseWorkflows/{OpenApiUtilClient.get_encode_param(release_workflow_sn)}/releaseStages/{OpenApiUtilClient.get_encode_param(release_stage_sn)}%3Aexecute',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ExecuteChangeRequestReleaseStageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def execute_change_request_release_stage(
        self,
        app_name: str,
        release_workflow_sn: str,
        release_stage_sn: str,
        request: devops_20210625_models.ExecuteChangeRequestReleaseStageRequest,
    ) -> devops_20210625_models.ExecuteChangeRequestReleaseStageResponse:
        """
        @summary 执行研发阶段流水线
        
        @param request: ExecuteChangeRequestReleaseStageRequest
        @return: ExecuteChangeRequestReleaseStageResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.execute_change_request_release_stage_with_options(app_name, release_workflow_sn, release_stage_sn, request, headers, runtime)

    async def execute_change_request_release_stage_async(
        self,
        app_name: str,
        release_workflow_sn: str,
        release_stage_sn: str,
        request: devops_20210625_models.ExecuteChangeRequestReleaseStageRequest,
    ) -> devops_20210625_models.ExecuteChangeRequestReleaseStageResponse:
        """
        @summary 执行研发阶段流水线
        
        @param request: ExecuteChangeRequestReleaseStageRequest
        @return: ExecuteChangeRequestReleaseStageResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.execute_change_request_release_stage_with_options_async(app_name, release_workflow_sn, release_stage_sn, request, headers, runtime)

    def export_insight_custom_value_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightCustomValueRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ExportInsightCustomValueResponse:
        """
        @summary 导出Insight custom_value表
        
        @param request: ExportInsightCustomValueRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportInsightCustomValueResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.end_time):
            body['endTime'] = request.end_time
        if not UtilClient.is_unset(request.max_results):
            body['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            body['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.start_time):
            body['startTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ExportInsightCustomValue',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/data/customValues',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ExportInsightCustomValueResponse(),
            self.call_api(params, req, runtime)
        )

    async def export_insight_custom_value_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightCustomValueRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ExportInsightCustomValueResponse:
        """
        @summary 导出Insight custom_value表
        
        @param request: ExportInsightCustomValueRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportInsightCustomValueResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.end_time):
            body['endTime'] = request.end_time
        if not UtilClient.is_unset(request.max_results):
            body['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            body['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.start_time):
            body['startTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ExportInsightCustomValue',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/data/customValues',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ExportInsightCustomValueResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def export_insight_custom_value(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightCustomValueRequest,
    ) -> devops_20210625_models.ExportInsightCustomValueResponse:
        """
        @summary 导出Insight custom_value表
        
        @param request: ExportInsightCustomValueRequest
        @return: ExportInsightCustomValueResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.export_insight_custom_value_with_options(organization_id, request, headers, runtime)

    async def export_insight_custom_value_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightCustomValueRequest,
    ) -> devops_20210625_models.ExportInsightCustomValueResponse:
        """
        @summary 导出Insight custom_value表
        
        @param request: ExportInsightCustomValueRequest
        @return: ExportInsightCustomValueResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.export_insight_custom_value_with_options_async(organization_id, request, headers, runtime)

    def export_insight_expected_work_time_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightExpectedWorkTimeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ExportInsightExpectedWorkTimeResponse:
        """
        @summary 导出Insight expected_work_time表数据
        
        @param request: ExportInsightExpectedWorkTimeRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportInsightExpectedWorkTimeResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.end_time):
            body['endTime'] = request.end_time
        if not UtilClient.is_unset(request.max_results):
            body['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            body['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.start_time):
            body['startTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ExportInsightExpectedWorkTime',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/data/expectedWorkTimes',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ExportInsightExpectedWorkTimeResponse(),
            self.call_api(params, req, runtime)
        )

    async def export_insight_expected_work_time_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightExpectedWorkTimeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ExportInsightExpectedWorkTimeResponse:
        """
        @summary 导出Insight expected_work_time表数据
        
        @param request: ExportInsightExpectedWorkTimeRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportInsightExpectedWorkTimeResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.end_time):
            body['endTime'] = request.end_time
        if not UtilClient.is_unset(request.max_results):
            body['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            body['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.start_time):
            body['startTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ExportInsightExpectedWorkTime',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/data/expectedWorkTimes',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ExportInsightExpectedWorkTimeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def export_insight_expected_work_time(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightExpectedWorkTimeRequest,
    ) -> devops_20210625_models.ExportInsightExpectedWorkTimeResponse:
        """
        @summary 导出Insight expected_work_time表数据
        
        @param request: ExportInsightExpectedWorkTimeRequest
        @return: ExportInsightExpectedWorkTimeResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.export_insight_expected_work_time_with_options(organization_id, request, headers, runtime)

    async def export_insight_expected_work_time_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightExpectedWorkTimeRequest,
    ) -> devops_20210625_models.ExportInsightExpectedWorkTimeResponse:
        """
        @summary 导出Insight expected_work_time表数据
        
        @param request: ExportInsightExpectedWorkTimeRequest
        @return: ExportInsightExpectedWorkTimeResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.export_insight_expected_work_time_with_options_async(organization_id, request, headers, runtime)

    def export_insight_field_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightFieldRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ExportInsightFieldResponse:
        """
        @summary 导出Insight field表
        
        @param request: ExportInsightFieldRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportInsightFieldResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.end_time):
            body['endTime'] = request.end_time
        if not UtilClient.is_unset(request.max_results):
            body['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            body['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.start_time):
            body['startTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ExportInsightField',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/data/fields',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ExportInsightFieldResponse(),
            self.call_api(params, req, runtime)
        )

    async def export_insight_field_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightFieldRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ExportInsightFieldResponse:
        """
        @summary 导出Insight field表
        
        @param request: ExportInsightFieldRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportInsightFieldResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.end_time):
            body['endTime'] = request.end_time
        if not UtilClient.is_unset(request.max_results):
            body['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            body['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.start_time):
            body['startTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ExportInsightField',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/data/fields',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ExportInsightFieldResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def export_insight_field(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightFieldRequest,
    ) -> devops_20210625_models.ExportInsightFieldResponse:
        """
        @summary 导出Insight field表
        
        @param request: ExportInsightFieldRequest
        @return: ExportInsightFieldResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.export_insight_field_with_options(organization_id, request, headers, runtime)

    async def export_insight_field_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightFieldRequest,
    ) -> devops_20210625_models.ExportInsightFieldResponse:
        """
        @summary 导出Insight field表
        
        @param request: ExportInsightFieldRequest
        @return: ExportInsightFieldResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.export_insight_field_with_options_async(organization_id, request, headers, runtime)

    def export_insight_space_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightSpaceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ExportInsightSpaceResponse:
        """
        @summary 导出Insight space表数据
        
        @param request: ExportInsightSpaceRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportInsightSpaceResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.end_time):
            body['endTime'] = request.end_time
        if not UtilClient.is_unset(request.max_results):
            body['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            body['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.start_time):
            body['startTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ExportInsightSpace',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/data/spaces',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ExportInsightSpaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def export_insight_space_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightSpaceRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ExportInsightSpaceResponse:
        """
        @summary 导出Insight space表数据
        
        @param request: ExportInsightSpaceRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportInsightSpaceResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.end_time):
            body['endTime'] = request.end_time
        if not UtilClient.is_unset(request.max_results):
            body['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            body['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.start_time):
            body['startTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ExportInsightSpace',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/data/spaces',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ExportInsightSpaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def export_insight_space(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightSpaceRequest,
    ) -> devops_20210625_models.ExportInsightSpaceResponse:
        """
        @summary 导出Insight space表数据
        
        @param request: ExportInsightSpaceRequest
        @return: ExportInsightSpaceResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.export_insight_space_with_options(organization_id, request, headers, runtime)

    async def export_insight_space_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightSpaceRequest,
    ) -> devops_20210625_models.ExportInsightSpaceResponse:
        """
        @summary 导出Insight space表数据
        
        @param request: ExportInsightSpaceRequest
        @return: ExportInsightSpaceResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.export_insight_space_with_options_async(organization_id, request, headers, runtime)

    def export_insight_space_ref_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightSpaceRefRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ExportInsightSpaceRefResponse:
        """
        @summary 导出Insight space_ref表数据
        
        @param request: ExportInsightSpaceRefRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportInsightSpaceRefResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.end_time):
            body['endTime'] = request.end_time
        if not UtilClient.is_unset(request.max_results):
            body['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            body['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.start_time):
            body['startTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ExportInsightSpaceRef',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/data/spaceRefs',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ExportInsightSpaceRefResponse(),
            self.call_api(params, req, runtime)
        )

    async def export_insight_space_ref_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightSpaceRefRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ExportInsightSpaceRefResponse:
        """
        @summary 导出Insight space_ref表数据
        
        @param request: ExportInsightSpaceRefRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportInsightSpaceRefResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.end_time):
            body['endTime'] = request.end_time
        if not UtilClient.is_unset(request.max_results):
            body['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            body['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.start_time):
            body['startTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ExportInsightSpaceRef',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/data/spaceRefs',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ExportInsightSpaceRefResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def export_insight_space_ref(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightSpaceRefRequest,
    ) -> devops_20210625_models.ExportInsightSpaceRefResponse:
        """
        @summary 导出Insight space_ref表数据
        
        @param request: ExportInsightSpaceRefRequest
        @return: ExportInsightSpaceRefResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.export_insight_space_ref_with_options(organization_id, request, headers, runtime)

    async def export_insight_space_ref_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightSpaceRefRequest,
    ) -> devops_20210625_models.ExportInsightSpaceRefResponse:
        """
        @summary 导出Insight space_ref表数据
        
        @param request: ExportInsightSpaceRefRequest
        @return: ExportInsightSpaceRefResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.export_insight_space_ref_with_options_async(organization_id, request, headers, runtime)

    def export_insight_sprint_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightSprintRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ExportInsightSprintResponse:
        """
        @summary 导出Insight sprint表数据
        
        @param request: ExportInsightSprintRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportInsightSprintResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.end_time):
            body['endTime'] = request.end_time
        if not UtilClient.is_unset(request.max_results):
            body['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            body['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.start_time):
            body['startTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ExportInsightSprint',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/data/sprints',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ExportInsightSprintResponse(),
            self.call_api(params, req, runtime)
        )

    async def export_insight_sprint_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightSprintRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ExportInsightSprintResponse:
        """
        @summary 导出Insight sprint表数据
        
        @param request: ExportInsightSprintRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportInsightSprintResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.end_time):
            body['endTime'] = request.end_time
        if not UtilClient.is_unset(request.max_results):
            body['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            body['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.start_time):
            body['startTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ExportInsightSprint',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/data/sprints',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ExportInsightSprintResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def export_insight_sprint(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightSprintRequest,
    ) -> devops_20210625_models.ExportInsightSprintResponse:
        """
        @summary 导出Insight sprint表数据
        
        @param request: ExportInsightSprintRequest
        @return: ExportInsightSprintResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.export_insight_sprint_with_options(organization_id, request, headers, runtime)

    async def export_insight_sprint_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightSprintRequest,
    ) -> devops_20210625_models.ExportInsightSprintResponse:
        """
        @summary 导出Insight sprint表数据
        
        @param request: ExportInsightSprintRequest
        @return: ExportInsightSprintResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.export_insight_sprint_with_options_async(organization_id, request, headers, runtime)

    def export_insight_tag_ref_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightTagRefRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ExportInsightTagRefResponse:
        """
        @summary 导出Insight tag_ref表数据
        
        @param request: ExportInsightTagRefRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportInsightTagRefResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.end_time):
            body['endTime'] = request.end_time
        if not UtilClient.is_unset(request.max_results):
            body['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            body['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.start_time):
            body['startTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ExportInsightTagRef',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/data/tagRefs',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ExportInsightTagRefResponse(),
            self.call_api(params, req, runtime)
        )

    async def export_insight_tag_ref_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightTagRefRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ExportInsightTagRefResponse:
        """
        @summary 导出Insight tag_ref表数据
        
        @param request: ExportInsightTagRefRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportInsightTagRefResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.end_time):
            body['endTime'] = request.end_time
        if not UtilClient.is_unset(request.max_results):
            body['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            body['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.start_time):
            body['startTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ExportInsightTagRef',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/data/tagRefs',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ExportInsightTagRefResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def export_insight_tag_ref(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightTagRefRequest,
    ) -> devops_20210625_models.ExportInsightTagRefResponse:
        """
        @summary 导出Insight tag_ref表数据
        
        @param request: ExportInsightTagRefRequest
        @return: ExportInsightTagRefResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.export_insight_tag_ref_with_options(organization_id, request, headers, runtime)

    async def export_insight_tag_ref_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightTagRefRequest,
    ) -> devops_20210625_models.ExportInsightTagRefResponse:
        """
        @summary 导出Insight tag_ref表数据
        
        @param request: ExportInsightTagRefRequest
        @return: ExportInsightTagRefResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.export_insight_tag_ref_with_options_async(organization_id, request, headers, runtime)

    def export_insight_work_time_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightWorkTimeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ExportInsightWorkTimeResponse:
        """
        @summary 导出Insight work_time表数据
        
        @param request: ExportInsightWorkTimeRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportInsightWorkTimeResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.end_time):
            body['endTime'] = request.end_time
        if not UtilClient.is_unset(request.max_results):
            body['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            body['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.start_time):
            body['startTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ExportInsightWorkTime',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/data/workTimes',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ExportInsightWorkTimeResponse(),
            self.call_api(params, req, runtime)
        )

    async def export_insight_work_time_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightWorkTimeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ExportInsightWorkTimeResponse:
        """
        @summary 导出Insight work_time表数据
        
        @param request: ExportInsightWorkTimeRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportInsightWorkTimeResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.end_time):
            body['endTime'] = request.end_time
        if not UtilClient.is_unset(request.max_results):
            body['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            body['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.start_time):
            body['startTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ExportInsightWorkTime',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/data/workTimes',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ExportInsightWorkTimeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def export_insight_work_time(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightWorkTimeRequest,
    ) -> devops_20210625_models.ExportInsightWorkTimeResponse:
        """
        @summary 导出Insight work_time表数据
        
        @param request: ExportInsightWorkTimeRequest
        @return: ExportInsightWorkTimeResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.export_insight_work_time_with_options(organization_id, request, headers, runtime)

    async def export_insight_work_time_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightWorkTimeRequest,
    ) -> devops_20210625_models.ExportInsightWorkTimeResponse:
        """
        @summary 导出Insight work_time表数据
        
        @param request: ExportInsightWorkTimeRequest
        @return: ExportInsightWorkTimeResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.export_insight_work_time_with_options_async(organization_id, request, headers, runtime)

    def export_insight_workitem_status_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightWorkitemStatusRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ExportInsightWorkitemStatusResponse:
        """
        @summary 导出Insight workitem_stauts表数据
        
        @param request: ExportInsightWorkitemStatusRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportInsightWorkitemStatusResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.end_time):
            body['endTime'] = request.end_time
        if not UtilClient.is_unset(request.max_results):
            body['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            body['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.start_time):
            body['startTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ExportInsightWorkitemStatus',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/data/workitemStatuses',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ExportInsightWorkitemStatusResponse(),
            self.call_api(params, req, runtime)
        )

    async def export_insight_workitem_status_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightWorkitemStatusRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ExportInsightWorkitemStatusResponse:
        """
        @summary 导出Insight workitem_stauts表数据
        
        @param request: ExportInsightWorkitemStatusRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportInsightWorkitemStatusResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.end_time):
            body['endTime'] = request.end_time
        if not UtilClient.is_unset(request.max_results):
            body['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            body['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.start_time):
            body['startTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ExportInsightWorkitemStatus',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/data/workitemStatuses',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ExportInsightWorkitemStatusResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def export_insight_workitem_status(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightWorkitemStatusRequest,
    ) -> devops_20210625_models.ExportInsightWorkitemStatusResponse:
        """
        @summary 导出Insight workitem_stauts表数据
        
        @param request: ExportInsightWorkitemStatusRequest
        @return: ExportInsightWorkitemStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.export_insight_workitem_status_with_options(organization_id, request, headers, runtime)

    async def export_insight_workitem_status_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightWorkitemStatusRequest,
    ) -> devops_20210625_models.ExportInsightWorkitemStatusResponse:
        """
        @summary 导出Insight workitem_stauts表数据
        
        @param request: ExportInsightWorkitemStatusRequest
        @return: ExportInsightWorkitemStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.export_insight_workitem_status_with_options_async(organization_id, request, headers, runtime)

    def export_insight_workitem_status_join_workitem_defect_extra_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightWorkitemStatusJoinWorkitemDefectExtraRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ExportInsightWorkitemStatusJoinWorkitemDefectExtraResponse:
        """
        @summary 导出Insight workitem_stauts表 join workitem_defect_extra表表数据
        
        @param request: ExportInsightWorkitemStatusJoinWorkitemDefectExtraRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportInsightWorkitemStatusJoinWorkitemDefectExtraResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.end_time):
            body['endTime'] = request.end_time
        if not UtilClient.is_unset(request.max_results):
            body['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            body['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.start_time):
            body['startTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ExportInsightWorkitemStatusJoinWorkitemDefectExtra',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/data/workitemStatusJoinWorkitemDefectExtras',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ExportInsightWorkitemStatusJoinWorkitemDefectExtraResponse(),
            self.call_api(params, req, runtime)
        )

    async def export_insight_workitem_status_join_workitem_defect_extra_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightWorkitemStatusJoinWorkitemDefectExtraRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ExportInsightWorkitemStatusJoinWorkitemDefectExtraResponse:
        """
        @summary 导出Insight workitem_stauts表 join workitem_defect_extra表表数据
        
        @param request: ExportInsightWorkitemStatusJoinWorkitemDefectExtraRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportInsightWorkitemStatusJoinWorkitemDefectExtraResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.end_time):
            body['endTime'] = request.end_time
        if not UtilClient.is_unset(request.max_results):
            body['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            body['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.start_time):
            body['startTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ExportInsightWorkitemStatusJoinWorkitemDefectExtra',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/data/workitemStatusJoinWorkitemDefectExtras',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ExportInsightWorkitemStatusJoinWorkitemDefectExtraResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def export_insight_workitem_status_join_workitem_defect_extra(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightWorkitemStatusJoinWorkitemDefectExtraRequest,
    ) -> devops_20210625_models.ExportInsightWorkitemStatusJoinWorkitemDefectExtraResponse:
        """
        @summary 导出Insight workitem_stauts表 join workitem_defect_extra表表数据
        
        @param request: ExportInsightWorkitemStatusJoinWorkitemDefectExtraRequest
        @return: ExportInsightWorkitemStatusJoinWorkitemDefectExtraResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.export_insight_workitem_status_join_workitem_defect_extra_with_options(organization_id, request, headers, runtime)

    async def export_insight_workitem_status_join_workitem_defect_extra_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightWorkitemStatusJoinWorkitemDefectExtraRequest,
    ) -> devops_20210625_models.ExportInsightWorkitemStatusJoinWorkitemDefectExtraResponse:
        """
        @summary 导出Insight workitem_stauts表 join workitem_defect_extra表表数据
        
        @param request: ExportInsightWorkitemStatusJoinWorkitemDefectExtraRequest
        @return: ExportInsightWorkitemStatusJoinWorkitemDefectExtraResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.export_insight_workitem_status_join_workitem_defect_extra_with_options_async(organization_id, request, headers, runtime)

    def export_insight_workitem_version_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightWorkitemVersionRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ExportInsightWorkitemVersionResponse:
        """
        @summary 导出Insight workitem_version表数据
        
        @param request: ExportInsightWorkitemVersionRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportInsightWorkitemVersionResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.end_time):
            body['endTime'] = request.end_time
        if not UtilClient.is_unset(request.max_results):
            body['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            body['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.start_time):
            body['startTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ExportInsightWorkitemVersion',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/data/workitemVersions',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ExportInsightWorkitemVersionResponse(),
            self.call_api(params, req, runtime)
        )

    async def export_insight_workitem_version_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightWorkitemVersionRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ExportInsightWorkitemVersionResponse:
        """
        @summary 导出Insight workitem_version表数据
        
        @param request: ExportInsightWorkitemVersionRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportInsightWorkitemVersionResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.end_time):
            body['endTime'] = request.end_time
        if not UtilClient.is_unset(request.max_results):
            body['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            body['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.start_time):
            body['startTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ExportInsightWorkitemVersion',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/data/workitemVersions',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ExportInsightWorkitemVersionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def export_insight_workitem_version(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightWorkitemVersionRequest,
    ) -> devops_20210625_models.ExportInsightWorkitemVersionResponse:
        """
        @summary 导出Insight workitem_version表数据
        
        @param request: ExportInsightWorkitemVersionRequest
        @return: ExportInsightWorkitemVersionResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.export_insight_workitem_version_with_options(organization_id, request, headers, runtime)

    async def export_insight_workitem_version_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportInsightWorkitemVersionRequest,
    ) -> devops_20210625_models.ExportInsightWorkitemVersionResponse:
        """
        @summary 导出Insight workitem_version表数据
        
        @param request: ExportInsightWorkitemVersionRequest
        @return: ExportInsightWorkitemVersionResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.export_insight_workitem_version_with_options_async(organization_id, request, headers, runtime)

    def export_workitem_activity_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportWorkitemActivityRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ExportWorkitemActivityResponse:
        """
        @summary 导出Insight workitem_activity表数据
        
        @param request: ExportWorkitemActivityRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportWorkitemActivityResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.end_time):
            body['endTime'] = request.end_time
        if not UtilClient.is_unset(request.max_results):
            body['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            body['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.start_time):
            body['startTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ExportWorkitemActivity',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/data/workitemActivities',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ExportWorkitemActivityResponse(),
            self.call_api(params, req, runtime)
        )

    async def export_workitem_activity_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportWorkitemActivityRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ExportWorkitemActivityResponse:
        """
        @summary 导出Insight workitem_activity表数据
        
        @param request: ExportWorkitemActivityRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportWorkitemActivityResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.end_time):
            body['endTime'] = request.end_time
        if not UtilClient.is_unset(request.max_results):
            body['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            body['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.start_time):
            body['startTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ExportWorkitemActivity',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/data/workitemActivities',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ExportWorkitemActivityResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def export_workitem_activity(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportWorkitemActivityRequest,
    ) -> devops_20210625_models.ExportWorkitemActivityResponse:
        """
        @summary 导出Insight workitem_activity表数据
        
        @param request: ExportWorkitemActivityRequest
        @return: ExportWorkitemActivityResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.export_workitem_activity_with_options(organization_id, request, headers, runtime)

    async def export_workitem_activity_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ExportWorkitemActivityRequest,
    ) -> devops_20210625_models.ExportWorkitemActivityResponse:
        """
        @summary 导出Insight workitem_activity表数据
        
        @param request: ExportWorkitemActivityRequest
        @return: ExportWorkitemActivityResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.export_workitem_activity_with_options_async(organization_id, request, headers, runtime)

    def get_application_with_options(
        self,
        app_name: str,
        request: devops_20210625_models.GetApplicationRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetApplicationResponse:
        """
        @summary 查找应用详情
        
        @param request: GetApplicationRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetApplicationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetApplication',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/appstack/apps/{OpenApiUtilClient.get_encode_param(app_name)}',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetApplicationResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_application_with_options_async(
        self,
        app_name: str,
        request: devops_20210625_models.GetApplicationRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetApplicationResponse:
        """
        @summary 查找应用详情
        
        @param request: GetApplicationRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetApplicationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetApplication',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/appstack/apps/{OpenApiUtilClient.get_encode_param(app_name)}',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetApplicationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_application(
        self,
        app_name: str,
        request: devops_20210625_models.GetApplicationRequest,
    ) -> devops_20210625_models.GetApplicationResponse:
        """
        @summary 查找应用详情
        
        @param request: GetApplicationRequest
        @return: GetApplicationResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_application_with_options(app_name, request, headers, runtime)

    async def get_application_async(
        self,
        app_name: str,
        request: devops_20210625_models.GetApplicationRequest,
    ) -> devops_20210625_models.GetApplicationResponse:
        """
        @summary 查找应用详情
        
        @param request: GetApplicationRequest
        @return: GetApplicationResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_application_with_options_async(app_name, request, headers, runtime)

    def get_branch_info_with_options(
        self,
        repository_id: str,
        request: devops_20210625_models.GetBranchInfoRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetBranchInfoResponse:
        """
        @summary 查询单个分支
        
        @param request: GetBranchInfoRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetBranchInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.branch_name):
            query['branchName'] = request.branch_name
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetBranchInfo',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/branches/detail',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetBranchInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_branch_info_with_options_async(
        self,
        repository_id: str,
        request: devops_20210625_models.GetBranchInfoRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetBranchInfoResponse:
        """
        @summary 查询单个分支
        
        @param request: GetBranchInfoRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetBranchInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.branch_name):
            query['branchName'] = request.branch_name
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetBranchInfo',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/branches/detail',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetBranchInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_branch_info(
        self,
        repository_id: str,
        request: devops_20210625_models.GetBranchInfoRequest,
    ) -> devops_20210625_models.GetBranchInfoResponse:
        """
        @summary 查询单个分支
        
        @param request: GetBranchInfoRequest
        @return: GetBranchInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_branch_info_with_options(repository_id, request, headers, runtime)

    async def get_branch_info_async(
        self,
        repository_id: str,
        request: devops_20210625_models.GetBranchInfoRequest,
    ) -> devops_20210625_models.GetBranchInfoResponse:
        """
        @summary 查询单个分支
        
        @param request: GetBranchInfoRequest
        @return: GetBranchInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_branch_info_with_options_async(repository_id, request, headers, runtime)

    def get_check_run_with_options(
        self,
        request: devops_20210625_models.GetCheckRunRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetCheckRunResponse:
        """
        @summary 查询检查运行
        
        @param request: GetCheckRunRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetCheckRunResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.check_run_id):
            query['checkRunId'] = request.check_run_id
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.repository_identity):
            query['repositoryIdentity'] = request.repository_identity
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetCheckRun',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/check_runs/get_check_run',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetCheckRunResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_check_run_with_options_async(
        self,
        request: devops_20210625_models.GetCheckRunRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetCheckRunResponse:
        """
        @summary 查询检查运行
        
        @param request: GetCheckRunRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetCheckRunResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.check_run_id):
            query['checkRunId'] = request.check_run_id
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.repository_identity):
            query['repositoryIdentity'] = request.repository_identity
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetCheckRun',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/check_runs/get_check_run',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetCheckRunResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_check_run(
        self,
        request: devops_20210625_models.GetCheckRunRequest,
    ) -> devops_20210625_models.GetCheckRunResponse:
        """
        @summary 查询检查运行
        
        @param request: GetCheckRunRequest
        @return: GetCheckRunResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_check_run_with_options(request, headers, runtime)

    async def get_check_run_async(
        self,
        request: devops_20210625_models.GetCheckRunRequest,
    ) -> devops_20210625_models.GetCheckRunResponse:
        """
        @summary 查询检查运行
        
        @param request: GetCheckRunRequest
        @return: GetCheckRunResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_check_run_with_options_async(request, headers, runtime)

    def get_codeup_organization_with_options(
        self,
        identity: str,
        request: devops_20210625_models.GetCodeupOrganizationRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetCodeupOrganizationResponse:
        """
        @summary 获取企业信息
        
        @param request: GetCodeupOrganizationRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetCodeupOrganizationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetCodeupOrganization',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/organization/{OpenApiUtilClient.get_encode_param(identity)}',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetCodeupOrganizationResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_codeup_organization_with_options_async(
        self,
        identity: str,
        request: devops_20210625_models.GetCodeupOrganizationRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetCodeupOrganizationResponse:
        """
        @summary 获取企业信息
        
        @param request: GetCodeupOrganizationRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetCodeupOrganizationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetCodeupOrganization',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/organization/{OpenApiUtilClient.get_encode_param(identity)}',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetCodeupOrganizationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_codeup_organization(
        self,
        identity: str,
        request: devops_20210625_models.GetCodeupOrganizationRequest,
    ) -> devops_20210625_models.GetCodeupOrganizationResponse:
        """
        @summary 获取企业信息
        
        @param request: GetCodeupOrganizationRequest
        @return: GetCodeupOrganizationResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_codeup_organization_with_options(identity, request, headers, runtime)

    async def get_codeup_organization_async(
        self,
        identity: str,
        request: devops_20210625_models.GetCodeupOrganizationRequest,
    ) -> devops_20210625_models.GetCodeupOrganizationResponse:
        """
        @summary 获取企业信息
        
        @param request: GetCodeupOrganizationRequest
        @return: GetCodeupOrganizationResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_codeup_organization_with_options_async(identity, request, headers, runtime)

    def get_compare_detail_with_options(
        self,
        repository_id: str,
        request: devops_20210625_models.GetCompareDetailRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetCompareDetailResponse:
        """
        @summary 获取比较详情
        
        @param request: GetCompareDetailRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetCompareDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.from_):
            query['from'] = request.from_
        if not UtilClient.is_unset(request.max_diff_byte):
            query['maxDiffByte'] = request.max_diff_byte
        if not UtilClient.is_unset(request.max_diff_file):
            query['maxDiffFile'] = request.max_diff_file
        if not UtilClient.is_unset(request.merge_base):
            query['mergeBase'] = request.merge_base
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.to):
            query['to'] = request.to
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetCompareDetail',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/commits/compare/detail',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetCompareDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_compare_detail_with_options_async(
        self,
        repository_id: str,
        request: devops_20210625_models.GetCompareDetailRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetCompareDetailResponse:
        """
        @summary 获取比较详情
        
        @param request: GetCompareDetailRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetCompareDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.from_):
            query['from'] = request.from_
        if not UtilClient.is_unset(request.max_diff_byte):
            query['maxDiffByte'] = request.max_diff_byte
        if not UtilClient.is_unset(request.max_diff_file):
            query['maxDiffFile'] = request.max_diff_file
        if not UtilClient.is_unset(request.merge_base):
            query['mergeBase'] = request.merge_base
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.to):
            query['to'] = request.to
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetCompareDetail',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/commits/compare/detail',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetCompareDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_compare_detail(
        self,
        repository_id: str,
        request: devops_20210625_models.GetCompareDetailRequest,
    ) -> devops_20210625_models.GetCompareDetailResponse:
        """
        @summary 获取比较详情
        
        @param request: GetCompareDetailRequest
        @return: GetCompareDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_compare_detail_with_options(repository_id, request, headers, runtime)

    async def get_compare_detail_async(
        self,
        repository_id: str,
        request: devops_20210625_models.GetCompareDetailRequest,
    ) -> devops_20210625_models.GetCompareDetailResponse:
        """
        @summary 获取比较详情
        
        @param request: GetCompareDetailRequest
        @return: GetCompareDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_compare_detail_with_options_async(repository_id, request, headers, runtime)

    def get_custom_field_option_with_options(
        self,
        organization_id: str,
        field_id: str,
        request: devops_20210625_models.GetCustomFieldOptionRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetCustomFieldOptionResponse:
        """
        @summary 获取自定义字段的选项值
        
        @param request: GetCustomFieldOptionRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetCustomFieldOptionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.space_identifier):
            query['spaceIdentifier'] = request.space_identifier
        if not UtilClient.is_unset(request.space_type):
            query['spaceType'] = request.space_type
        if not UtilClient.is_unset(request.workitem_type_identifier):
            query['workitemTypeIdentifier'] = request.workitem_type_identifier
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetCustomFieldOption',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/fields/{OpenApiUtilClient.get_encode_param(field_id)}/getCustomOption',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetCustomFieldOptionResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_custom_field_option_with_options_async(
        self,
        organization_id: str,
        field_id: str,
        request: devops_20210625_models.GetCustomFieldOptionRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetCustomFieldOptionResponse:
        """
        @summary 获取自定义字段的选项值
        
        @param request: GetCustomFieldOptionRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetCustomFieldOptionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.space_identifier):
            query['spaceIdentifier'] = request.space_identifier
        if not UtilClient.is_unset(request.space_type):
            query['spaceType'] = request.space_type
        if not UtilClient.is_unset(request.workitem_type_identifier):
            query['workitemTypeIdentifier'] = request.workitem_type_identifier
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetCustomFieldOption',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/fields/{OpenApiUtilClient.get_encode_param(field_id)}/getCustomOption',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetCustomFieldOptionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_custom_field_option(
        self,
        organization_id: str,
        field_id: str,
        request: devops_20210625_models.GetCustomFieldOptionRequest,
    ) -> devops_20210625_models.GetCustomFieldOptionResponse:
        """
        @summary 获取自定义字段的选项值
        
        @param request: GetCustomFieldOptionRequest
        @return: GetCustomFieldOptionResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_custom_field_option_with_options(organization_id, field_id, request, headers, runtime)

    async def get_custom_field_option_async(
        self,
        organization_id: str,
        field_id: str,
        request: devops_20210625_models.GetCustomFieldOptionRequest,
    ) -> devops_20210625_models.GetCustomFieldOptionResponse:
        """
        @summary 获取自定义字段的选项值
        
        @param request: GetCustomFieldOptionRequest
        @return: GetCustomFieldOptionResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_custom_field_option_with_options_async(organization_id, field_id, request, headers, runtime)

    def get_file_blobs_with_options(
        self,
        repository_id: str,
        request: devops_20210625_models.GetFileBlobsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetFileBlobsResponse:
        """
        @summary 查询文件
        
        @param request: GetFileBlobsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetFileBlobsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.file_path):
            query['filePath'] = request.file_path
        if not UtilClient.is_unset(request.from_):
            query['from'] = request.from_
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.ref):
            query['ref'] = request.ref
        if not UtilClient.is_unset(request.to):
            query['to'] = request.to
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetFileBlobs',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/files/blobs',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetFileBlobsResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_file_blobs_with_options_async(
        self,
        repository_id: str,
        request: devops_20210625_models.GetFileBlobsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetFileBlobsResponse:
        """
        @summary 查询文件
        
        @param request: GetFileBlobsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetFileBlobsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.file_path):
            query['filePath'] = request.file_path
        if not UtilClient.is_unset(request.from_):
            query['from'] = request.from_
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.ref):
            query['ref'] = request.ref
        if not UtilClient.is_unset(request.to):
            query['to'] = request.to
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetFileBlobs',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/files/blobs',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetFileBlobsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_file_blobs(
        self,
        repository_id: str,
        request: devops_20210625_models.GetFileBlobsRequest,
    ) -> devops_20210625_models.GetFileBlobsResponse:
        """
        @summary 查询文件
        
        @param request: GetFileBlobsRequest
        @return: GetFileBlobsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_file_blobs_with_options(repository_id, request, headers, runtime)

    async def get_file_blobs_async(
        self,
        repository_id: str,
        request: devops_20210625_models.GetFileBlobsRequest,
    ) -> devops_20210625_models.GetFileBlobsResponse:
        """
        @summary 查询文件
        
        @param request: GetFileBlobsRequest
        @return: GetFileBlobsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_file_blobs_with_options_async(repository_id, request, headers, runtime)

    def get_file_last_commit_with_options(
        self,
        repository_id: str,
        request: devops_20210625_models.GetFileLastCommitRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetFileLastCommitResponse:
        """
        @summary 获取文件上一次提交信息
        
        @param request: GetFileLastCommitRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetFileLastCommitResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.file_path):
            query['filePath'] = request.file_path
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.sha):
            query['sha'] = request.sha
        if not UtilClient.is_unset(request.show_signature):
            query['showSignature'] = request.show_signature
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetFileLastCommit',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/files/lastCommit',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetFileLastCommitResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_file_last_commit_with_options_async(
        self,
        repository_id: str,
        request: devops_20210625_models.GetFileLastCommitRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetFileLastCommitResponse:
        """
        @summary 获取文件上一次提交信息
        
        @param request: GetFileLastCommitRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetFileLastCommitResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.file_path):
            query['filePath'] = request.file_path
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.sha):
            query['sha'] = request.sha
        if not UtilClient.is_unset(request.show_signature):
            query['showSignature'] = request.show_signature
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetFileLastCommit',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/files/lastCommit',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetFileLastCommitResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_file_last_commit(
        self,
        repository_id: str,
        request: devops_20210625_models.GetFileLastCommitRequest,
    ) -> devops_20210625_models.GetFileLastCommitResponse:
        """
        @summary 获取文件上一次提交信息
        
        @param request: GetFileLastCommitRequest
        @return: GetFileLastCommitResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_file_last_commit_with_options(repository_id, request, headers, runtime)

    async def get_file_last_commit_async(
        self,
        repository_id: str,
        request: devops_20210625_models.GetFileLastCommitRequest,
    ) -> devops_20210625_models.GetFileLastCommitResponse:
        """
        @summary 获取文件上一次提交信息
        
        @param request: GetFileLastCommitRequest
        @return: GetFileLastCommitResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_file_last_commit_with_options_async(repository_id, request, headers, runtime)

    def get_flow_tag_group_with_options(
        self,
        organization_id: str,
        id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetFlowTagGroupResponse:
        """
        @summary 获取标签分类
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetFlowTagGroupResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='GetFlowTagGroup',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/flow/tagGroups/{OpenApiUtilClient.get_encode_param(id)}',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetFlowTagGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_flow_tag_group_with_options_async(
        self,
        organization_id: str,
        id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetFlowTagGroupResponse:
        """
        @summary 获取标签分类
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetFlowTagGroupResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='GetFlowTagGroup',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/flow/tagGroups/{OpenApiUtilClient.get_encode_param(id)}',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetFlowTagGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_flow_tag_group(
        self,
        organization_id: str,
        id: str,
    ) -> devops_20210625_models.GetFlowTagGroupResponse:
        """
        @summary 获取标签分类
        
        @return: GetFlowTagGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_flow_tag_group_with_options(organization_id, id, headers, runtime)

    async def get_flow_tag_group_async(
        self,
        organization_id: str,
        id: str,
    ) -> devops_20210625_models.GetFlowTagGroupResponse:
        """
        @summary 获取标签分类
        
        @return: GetFlowTagGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_flow_tag_group_with_options_async(organization_id, id, headers, runtime)

    def get_group_by_path_with_options(
        self,
        request: devops_20210625_models.GetGroupByPathRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetGroupByPathResponse:
        """
        @summary 根据路径查询代码组
        
        @param request: GetGroupByPathRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetGroupByPathResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.identity):
            query['identity'] = request.identity
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetGroupByPath',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/4/groups/find_by_path',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetGroupByPathResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_group_by_path_with_options_async(
        self,
        request: devops_20210625_models.GetGroupByPathRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetGroupByPathResponse:
        """
        @summary 根据路径查询代码组
        
        @param request: GetGroupByPathRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetGroupByPathResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.identity):
            query['identity'] = request.identity
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetGroupByPath',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/4/groups/find_by_path',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetGroupByPathResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_group_by_path(
        self,
        request: devops_20210625_models.GetGroupByPathRequest,
    ) -> devops_20210625_models.GetGroupByPathResponse:
        """
        @summary 根据路径查询代码组
        
        @param request: GetGroupByPathRequest
        @return: GetGroupByPathResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_group_by_path_with_options(request, headers, runtime)

    async def get_group_by_path_async(
        self,
        request: devops_20210625_models.GetGroupByPathRequest,
    ) -> devops_20210625_models.GetGroupByPathResponse:
        """
        @summary 根据路径查询代码组
        
        @param request: GetGroupByPathRequest
        @return: GetGroupByPathResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_group_by_path_with_options_async(request, headers, runtime)

    def get_group_detail_with_options(
        self,
        request: devops_20210625_models.GetGroupDetailRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetGroupDetailResponse:
        """
        @summary 查询代码组信息
        
        @param request: GetGroupDetailRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetGroupDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.group_id):
            query['groupId'] = request.group_id
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetGroupDetail',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/groups/get_detail',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetGroupDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_group_detail_with_options_async(
        self,
        request: devops_20210625_models.GetGroupDetailRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetGroupDetailResponse:
        """
        @summary 查询代码组信息
        
        @param request: GetGroupDetailRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetGroupDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.group_id):
            query['groupId'] = request.group_id
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetGroupDetail',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/groups/get_detail',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetGroupDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_group_detail(
        self,
        request: devops_20210625_models.GetGroupDetailRequest,
    ) -> devops_20210625_models.GetGroupDetailResponse:
        """
        @summary 查询代码组信息
        
        @param request: GetGroupDetailRequest
        @return: GetGroupDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_group_detail_with_options(request, headers, runtime)

    async def get_group_detail_async(
        self,
        request: devops_20210625_models.GetGroupDetailRequest,
    ) -> devops_20210625_models.GetGroupDetailResponse:
        """
        @summary 查询代码组信息
        
        @param request: GetGroupDetailRequest
        @return: GetGroupDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_group_detail_with_options_async(request, headers, runtime)

    def get_host_group_with_options(
        self,
        organization_id: str,
        id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetHostGroupResponse:
        """
        @summary 获取主机组信息
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetHostGroupResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='GetHostGroup',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/hostGroups/{OpenApiUtilClient.get_encode_param(id)}',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetHostGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_host_group_with_options_async(
        self,
        organization_id: str,
        id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetHostGroupResponse:
        """
        @summary 获取主机组信息
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetHostGroupResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='GetHostGroup',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/hostGroups/{OpenApiUtilClient.get_encode_param(id)}',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetHostGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_host_group(
        self,
        organization_id: str,
        id: str,
    ) -> devops_20210625_models.GetHostGroupResponse:
        """
        @summary 获取主机组信息
        
        @return: GetHostGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_host_group_with_options(organization_id, id, headers, runtime)

    async def get_host_group_async(
        self,
        organization_id: str,
        id: str,
    ) -> devops_20210625_models.GetHostGroupResponse:
        """
        @summary 获取主机组信息
        
        @return: GetHostGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_host_group_with_options_async(organization_id, id, headers, runtime)

    def get_merge_request_with_options(
        self,
        repository_id: str,
        local_id: str,
        request: devops_20210625_models.GetMergeRequestRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetMergeRequestResponse:
        """
        @summary 查询合并请求详情
        
        @param request: GetMergeRequestRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetMergeRequestResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetMergeRequest',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/{OpenApiUtilClient.get_encode_param(repository_id)}/merge_requests/{OpenApiUtilClient.get_encode_param(local_id)}/detail',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetMergeRequestResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_merge_request_with_options_async(
        self,
        repository_id: str,
        local_id: str,
        request: devops_20210625_models.GetMergeRequestRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetMergeRequestResponse:
        """
        @summary 查询合并请求详情
        
        @param request: GetMergeRequestRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetMergeRequestResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetMergeRequest',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/{OpenApiUtilClient.get_encode_param(repository_id)}/merge_requests/{OpenApiUtilClient.get_encode_param(local_id)}/detail',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetMergeRequestResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_merge_request(
        self,
        repository_id: str,
        local_id: str,
        request: devops_20210625_models.GetMergeRequestRequest,
    ) -> devops_20210625_models.GetMergeRequestResponse:
        """
        @summary 查询合并请求详情
        
        @param request: GetMergeRequestRequest
        @return: GetMergeRequestResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_merge_request_with_options(repository_id, local_id, request, headers, runtime)

    async def get_merge_request_async(
        self,
        repository_id: str,
        local_id: str,
        request: devops_20210625_models.GetMergeRequestRequest,
    ) -> devops_20210625_models.GetMergeRequestResponse:
        """
        @summary 查询合并请求详情
        
        @param request: GetMergeRequestRequest
        @return: GetMergeRequestResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_merge_request_with_options_async(repository_id, local_id, request, headers, runtime)

    def get_merge_request_change_tree_with_options(
        self,
        request: devops_20210625_models.GetMergeRequestChangeTreeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetMergeRequestChangeTreeResponse:
        """
        @summary 查询合并请求的变更信息
        
        @param request: GetMergeRequestChangeTreeRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetMergeRequestChangeTreeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.from_patch_set_biz_id):
            query['fromPatchSetBizId'] = request.from_patch_set_biz_id
        if not UtilClient.is_unset(request.local_id):
            query['localId'] = request.local_id
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.repository_identity):
            query['repositoryIdentity'] = request.repository_identity
        if not UtilClient.is_unset(request.to_patch_set_biz_id):
            query['toPatchSetBizId'] = request.to_patch_set_biz_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetMergeRequestChangeTree',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/merge_requests/diffs/change_tree',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetMergeRequestChangeTreeResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_merge_request_change_tree_with_options_async(
        self,
        request: devops_20210625_models.GetMergeRequestChangeTreeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetMergeRequestChangeTreeResponse:
        """
        @summary 查询合并请求的变更信息
        
        @param request: GetMergeRequestChangeTreeRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetMergeRequestChangeTreeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.from_patch_set_biz_id):
            query['fromPatchSetBizId'] = request.from_patch_set_biz_id
        if not UtilClient.is_unset(request.local_id):
            query['localId'] = request.local_id
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.repository_identity):
            query['repositoryIdentity'] = request.repository_identity
        if not UtilClient.is_unset(request.to_patch_set_biz_id):
            query['toPatchSetBizId'] = request.to_patch_set_biz_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetMergeRequestChangeTree',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/merge_requests/diffs/change_tree',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetMergeRequestChangeTreeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_merge_request_change_tree(
        self,
        request: devops_20210625_models.GetMergeRequestChangeTreeRequest,
    ) -> devops_20210625_models.GetMergeRequestChangeTreeResponse:
        """
        @summary 查询合并请求的变更信息
        
        @param request: GetMergeRequestChangeTreeRequest
        @return: GetMergeRequestChangeTreeResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_merge_request_change_tree_with_options(request, headers, runtime)

    async def get_merge_request_change_tree_async(
        self,
        request: devops_20210625_models.GetMergeRequestChangeTreeRequest,
    ) -> devops_20210625_models.GetMergeRequestChangeTreeResponse:
        """
        @summary 查询合并请求的变更信息
        
        @param request: GetMergeRequestChangeTreeRequest
        @return: GetMergeRequestChangeTreeResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_merge_request_change_tree_with_options_async(request, headers, runtime)

    def get_organization_member_with_options(
        self,
        organization_id: str,
        account_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetOrganizationMemberResponse:
        """
        @summary 获取企业成员
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetOrganizationMemberResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='GetOrganizationMember',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/members/{OpenApiUtilClient.get_encode_param(account_id)}',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetOrganizationMemberResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_organization_member_with_options_async(
        self,
        organization_id: str,
        account_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetOrganizationMemberResponse:
        """
        @summary 获取企业成员
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetOrganizationMemberResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='GetOrganizationMember',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/members/{OpenApiUtilClient.get_encode_param(account_id)}',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetOrganizationMemberResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_organization_member(
        self,
        organization_id: str,
        account_id: str,
    ) -> devops_20210625_models.GetOrganizationMemberResponse:
        """
        @summary 获取企业成员
        
        @return: GetOrganizationMemberResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_organization_member_with_options(organization_id, account_id, headers, runtime)

    async def get_organization_member_async(
        self,
        organization_id: str,
        account_id: str,
    ) -> devops_20210625_models.GetOrganizationMemberResponse:
        """
        @summary 获取企业成员
        
        @return: GetOrganizationMemberResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_organization_member_with_options_async(organization_id, account_id, headers, runtime)

    def get_pipeline_with_options(
        self,
        organization_id: str,
        pipeline_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetPipelineResponse:
        """
        @summary 获取流水线
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetPipelineResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='GetPipeline',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines/{OpenApiUtilClient.get_encode_param(pipeline_id)}',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetPipelineResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_pipeline_with_options_async(
        self,
        organization_id: str,
        pipeline_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetPipelineResponse:
        """
        @summary 获取流水线
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetPipelineResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='GetPipeline',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines/{OpenApiUtilClient.get_encode_param(pipeline_id)}',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetPipelineResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_pipeline(
        self,
        organization_id: str,
        pipeline_id: str,
    ) -> devops_20210625_models.GetPipelineResponse:
        """
        @summary 获取流水线
        
        @return: GetPipelineResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_pipeline_with_options(organization_id, pipeline_id, headers, runtime)

    async def get_pipeline_async(
        self,
        organization_id: str,
        pipeline_id: str,
    ) -> devops_20210625_models.GetPipelineResponse:
        """
        @summary 获取流水线
        
        @return: GetPipelineResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_pipeline_with_options_async(organization_id, pipeline_id, headers, runtime)

    def get_pipeline_artifact_url_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.GetPipelineArtifactUrlRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetPipelineArtifactUrlResponse:
        """
        @summary 获取构建物下载链接
        
        @param request: GetPipelineArtifactUrlRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetPipelineArtifactUrlResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.file_name):
            query['fileName'] = request.file_name
        if not UtilClient.is_unset(request.file_path):
            query['filePath'] = request.file_path
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetPipelineArtifactUrl',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipeline/getArtifactDownloadUrl',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetPipelineArtifactUrlResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_pipeline_artifact_url_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.GetPipelineArtifactUrlRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetPipelineArtifactUrlResponse:
        """
        @summary 获取构建物下载链接
        
        @param request: GetPipelineArtifactUrlRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetPipelineArtifactUrlResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.file_name):
            query['fileName'] = request.file_name
        if not UtilClient.is_unset(request.file_path):
            query['filePath'] = request.file_path
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetPipelineArtifactUrl',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipeline/getArtifactDownloadUrl',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetPipelineArtifactUrlResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_pipeline_artifact_url(
        self,
        organization_id: str,
        request: devops_20210625_models.GetPipelineArtifactUrlRequest,
    ) -> devops_20210625_models.GetPipelineArtifactUrlResponse:
        """
        @summary 获取构建物下载链接
        
        @param request: GetPipelineArtifactUrlRequest
        @return: GetPipelineArtifactUrlResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_pipeline_artifact_url_with_options(organization_id, request, headers, runtime)

    async def get_pipeline_artifact_url_async(
        self,
        organization_id: str,
        request: devops_20210625_models.GetPipelineArtifactUrlRequest,
    ) -> devops_20210625_models.GetPipelineArtifactUrlResponse:
        """
        @summary 获取构建物下载链接
        
        @param request: GetPipelineArtifactUrlRequest
        @return: GetPipelineArtifactUrlResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_pipeline_artifact_url_with_options_async(organization_id, request, headers, runtime)

    def get_pipeline_emas_artifact_url_with_options(
        self,
        organization_id: str,
        emas_job_instance_id: str,
        md_5: str,
        pipeline_id: str,
        pipeline_run_id: str,
        request: devops_20210625_models.GetPipelineEmasArtifactUrlRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetPipelineEmasArtifactUrlResponse:
        """
        @summary 获取emase构建物下载链接
        
        @param request: GetPipelineEmasArtifactUrlRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetPipelineEmasArtifactUrlResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.service_connection_id):
            query['serviceConnectionId'] = request.service_connection_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetPipelineEmasArtifactUrl',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipeline/{OpenApiUtilClient.get_encode_param(pipeline_id)}/pipelineRun/{OpenApiUtilClient.get_encode_param(pipeline_run_id)}/emas/artifact/{OpenApiUtilClient.get_encode_param(emas_job_instance_id)}/{OpenApiUtilClient.get_encode_param(md_5)}',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetPipelineEmasArtifactUrlResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_pipeline_emas_artifact_url_with_options_async(
        self,
        organization_id: str,
        emas_job_instance_id: str,
        md_5: str,
        pipeline_id: str,
        pipeline_run_id: str,
        request: devops_20210625_models.GetPipelineEmasArtifactUrlRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetPipelineEmasArtifactUrlResponse:
        """
        @summary 获取emase构建物下载链接
        
        @param request: GetPipelineEmasArtifactUrlRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetPipelineEmasArtifactUrlResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.service_connection_id):
            query['serviceConnectionId'] = request.service_connection_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetPipelineEmasArtifactUrl',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipeline/{OpenApiUtilClient.get_encode_param(pipeline_id)}/pipelineRun/{OpenApiUtilClient.get_encode_param(pipeline_run_id)}/emas/artifact/{OpenApiUtilClient.get_encode_param(emas_job_instance_id)}/{OpenApiUtilClient.get_encode_param(md_5)}',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetPipelineEmasArtifactUrlResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_pipeline_emas_artifact_url(
        self,
        organization_id: str,
        emas_job_instance_id: str,
        md_5: str,
        pipeline_id: str,
        pipeline_run_id: str,
        request: devops_20210625_models.GetPipelineEmasArtifactUrlRequest,
    ) -> devops_20210625_models.GetPipelineEmasArtifactUrlResponse:
        """
        @summary 获取emase构建物下载链接
        
        @param request: GetPipelineEmasArtifactUrlRequest
        @return: GetPipelineEmasArtifactUrlResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_pipeline_emas_artifact_url_with_options(organization_id, emas_job_instance_id, md_5, pipeline_id, pipeline_run_id, request, headers, runtime)

    async def get_pipeline_emas_artifact_url_async(
        self,
        organization_id: str,
        emas_job_instance_id: str,
        md_5: str,
        pipeline_id: str,
        pipeline_run_id: str,
        request: devops_20210625_models.GetPipelineEmasArtifactUrlRequest,
    ) -> devops_20210625_models.GetPipelineEmasArtifactUrlResponse:
        """
        @summary 获取emase构建物下载链接
        
        @param request: GetPipelineEmasArtifactUrlRequest
        @return: GetPipelineEmasArtifactUrlResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_pipeline_emas_artifact_url_with_options_async(organization_id, emas_job_instance_id, md_5, pipeline_id, pipeline_run_id, request, headers, runtime)

    def get_pipeline_group_with_options(
        self,
        organization_id: str,
        group_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetPipelineGroupResponse:
        """
        @summary 获取流水线分组
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetPipelineGroupResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='GetPipelineGroup',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelineGroups/{OpenApiUtilClient.get_encode_param(group_id)}',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetPipelineGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_pipeline_group_with_options_async(
        self,
        organization_id: str,
        group_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetPipelineGroupResponse:
        """
        @summary 获取流水线分组
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetPipelineGroupResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='GetPipelineGroup',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelineGroups/{OpenApiUtilClient.get_encode_param(group_id)}',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetPipelineGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_pipeline_group(
        self,
        organization_id: str,
        group_id: str,
    ) -> devops_20210625_models.GetPipelineGroupResponse:
        """
        @summary 获取流水线分组
        
        @return: GetPipelineGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_pipeline_group_with_options(organization_id, group_id, headers, runtime)

    async def get_pipeline_group_async(
        self,
        organization_id: str,
        group_id: str,
    ) -> devops_20210625_models.GetPipelineGroupResponse:
        """
        @summary 获取流水线分组
        
        @return: GetPipelineGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_pipeline_group_with_options_async(organization_id, group_id, headers, runtime)

    def get_pipeline_run_with_options(
        self,
        organization_id: str,
        pipeline_id: str,
        pipeline_run_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetPipelineRunResponse:
        """
        @summary 获取流水线运行信息
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetPipelineRunResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='GetPipelineRun',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines/{OpenApiUtilClient.get_encode_param(pipeline_id)}/pipelineRuns/{OpenApiUtilClient.get_encode_param(pipeline_run_id)}',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetPipelineRunResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_pipeline_run_with_options_async(
        self,
        organization_id: str,
        pipeline_id: str,
        pipeline_run_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetPipelineRunResponse:
        """
        @summary 获取流水线运行信息
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetPipelineRunResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='GetPipelineRun',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines/{OpenApiUtilClient.get_encode_param(pipeline_id)}/pipelineRuns/{OpenApiUtilClient.get_encode_param(pipeline_run_id)}',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetPipelineRunResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_pipeline_run(
        self,
        organization_id: str,
        pipeline_id: str,
        pipeline_run_id: str,
    ) -> devops_20210625_models.GetPipelineRunResponse:
        """
        @summary 获取流水线运行信息
        
        @return: GetPipelineRunResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_pipeline_run_with_options(organization_id, pipeline_id, pipeline_run_id, headers, runtime)

    async def get_pipeline_run_async(
        self,
        organization_id: str,
        pipeline_id: str,
        pipeline_run_id: str,
    ) -> devops_20210625_models.GetPipelineRunResponse:
        """
        @summary 获取流水线运行信息
        
        @return: GetPipelineRunResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_pipeline_run_with_options_async(organization_id, pipeline_id, pipeline_run_id, headers, runtime)

    def get_pipeline_scan_report_url_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.GetPipelineScanReportUrlRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetPipelineScanReportUrlResponse:
        """
        @summary 获取扫描报告下载链接
        
        @param request: GetPipelineScanReportUrlRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetPipelineScanReportUrlResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.report_path):
            body['reportPath'] = request.report_path
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='GetPipelineScanReportUrl',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipeline/getPipelineScanReportUrl',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetPipelineScanReportUrlResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_pipeline_scan_report_url_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.GetPipelineScanReportUrlRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetPipelineScanReportUrlResponse:
        """
        @summary 获取扫描报告下载链接
        
        @param request: GetPipelineScanReportUrlRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetPipelineScanReportUrlResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.report_path):
            body['reportPath'] = request.report_path
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='GetPipelineScanReportUrl',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipeline/getPipelineScanReportUrl',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetPipelineScanReportUrlResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_pipeline_scan_report_url(
        self,
        organization_id: str,
        request: devops_20210625_models.GetPipelineScanReportUrlRequest,
    ) -> devops_20210625_models.GetPipelineScanReportUrlResponse:
        """
        @summary 获取扫描报告下载链接
        
        @param request: GetPipelineScanReportUrlRequest
        @return: GetPipelineScanReportUrlResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_pipeline_scan_report_url_with_options(organization_id, request, headers, runtime)

    async def get_pipeline_scan_report_url_async(
        self,
        organization_id: str,
        request: devops_20210625_models.GetPipelineScanReportUrlRequest,
    ) -> devops_20210625_models.GetPipelineScanReportUrlResponse:
        """
        @summary 获取扫描报告下载链接
        
        @param request: GetPipelineScanReportUrlRequest
        @return: GetPipelineScanReportUrlResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_pipeline_scan_report_url_with_options_async(organization_id, request, headers, runtime)

    def get_project_info_with_options(
        self,
        organization_id: str,
        project_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetProjectInfoResponse:
        """
        @summary 根据id获取项目详情-Projex
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetProjectInfoResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='GetProjectInfo',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/project/{OpenApiUtilClient.get_encode_param(project_id)}',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetProjectInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_project_info_with_options_async(
        self,
        organization_id: str,
        project_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetProjectInfoResponse:
        """
        @summary 根据id获取项目详情-Projex
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetProjectInfoResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='GetProjectInfo',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/project/{OpenApiUtilClient.get_encode_param(project_id)}',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetProjectInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_project_info(
        self,
        organization_id: str,
        project_id: str,
    ) -> devops_20210625_models.GetProjectInfoResponse:
        """
        @summary 根据id获取项目详情-Projex
        
        @return: GetProjectInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_project_info_with_options(organization_id, project_id, headers, runtime)

    async def get_project_info_async(
        self,
        organization_id: str,
        project_id: str,
    ) -> devops_20210625_models.GetProjectInfoResponse:
        """
        @summary 根据id获取项目详情-Projex
        
        @return: GetProjectInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_project_info_with_options_async(organization_id, project_id, headers, runtime)

    def get_project_member_with_options(
        self,
        repository_id: str,
        aliyun_pk: str,
        request: devops_20210625_models.GetProjectMemberRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetProjectMemberResponse:
        """
        @summary 查询代码库成员
        
        @param request: GetProjectMemberRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetProjectMemberResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetProjectMember',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/members/get/{OpenApiUtilClient.get_encode_param(aliyun_pk)}',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetProjectMemberResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_project_member_with_options_async(
        self,
        repository_id: str,
        aliyun_pk: str,
        request: devops_20210625_models.GetProjectMemberRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetProjectMemberResponse:
        """
        @summary 查询代码库成员
        
        @param request: GetProjectMemberRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetProjectMemberResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetProjectMember',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/members/get/{OpenApiUtilClient.get_encode_param(aliyun_pk)}',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetProjectMemberResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_project_member(
        self,
        repository_id: str,
        aliyun_pk: str,
        request: devops_20210625_models.GetProjectMemberRequest,
    ) -> devops_20210625_models.GetProjectMemberResponse:
        """
        @summary 查询代码库成员
        
        @param request: GetProjectMemberRequest
        @return: GetProjectMemberResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_project_member_with_options(repository_id, aliyun_pk, request, headers, runtime)

    async def get_project_member_async(
        self,
        repository_id: str,
        aliyun_pk: str,
        request: devops_20210625_models.GetProjectMemberRequest,
    ) -> devops_20210625_models.GetProjectMemberResponse:
        """
        @summary 查询代码库成员
        
        @param request: GetProjectMemberRequest
        @return: GetProjectMemberResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_project_member_with_options_async(repository_id, aliyun_pk, request, headers, runtime)

    def get_release_stage_pipeline_run_with_options(
        self,
        app_name: str,
        release_workflow_sn: str,
        release_stage_sn: str,
        execution_number: str,
        request: devops_20210625_models.GetReleaseStagePipelineRunRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetReleaseStagePipelineRunResponse:
        """
        @summary 获取研发阶段流水线运行实例
        
        @param request: GetReleaseStagePipelineRunRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetReleaseStagePipelineRunResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetReleaseStagePipelineRun',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/appstack/apps/{OpenApiUtilClient.get_encode_param(app_name)}/releaseWorkflows/{OpenApiUtilClient.get_encode_param(release_workflow_sn)}/releaseStages/{OpenApiUtilClient.get_encode_param(release_stage_sn)}/executions/{OpenApiUtilClient.get_encode_param(execution_number)}%3AgetPipelineRun',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetReleaseStagePipelineRunResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_release_stage_pipeline_run_with_options_async(
        self,
        app_name: str,
        release_workflow_sn: str,
        release_stage_sn: str,
        execution_number: str,
        request: devops_20210625_models.GetReleaseStagePipelineRunRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetReleaseStagePipelineRunResponse:
        """
        @summary 获取研发阶段流水线运行实例
        
        @param request: GetReleaseStagePipelineRunRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetReleaseStagePipelineRunResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetReleaseStagePipelineRun',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/appstack/apps/{OpenApiUtilClient.get_encode_param(app_name)}/releaseWorkflows/{OpenApiUtilClient.get_encode_param(release_workflow_sn)}/releaseStages/{OpenApiUtilClient.get_encode_param(release_stage_sn)}/executions/{OpenApiUtilClient.get_encode_param(execution_number)}%3AgetPipelineRun',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetReleaseStagePipelineRunResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_release_stage_pipeline_run(
        self,
        app_name: str,
        release_workflow_sn: str,
        release_stage_sn: str,
        execution_number: str,
        request: devops_20210625_models.GetReleaseStagePipelineRunRequest,
    ) -> devops_20210625_models.GetReleaseStagePipelineRunResponse:
        """
        @summary 获取研发阶段流水线运行实例
        
        @param request: GetReleaseStagePipelineRunRequest
        @return: GetReleaseStagePipelineRunResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_release_stage_pipeline_run_with_options(app_name, release_workflow_sn, release_stage_sn, execution_number, request, headers, runtime)

    async def get_release_stage_pipeline_run_async(
        self,
        app_name: str,
        release_workflow_sn: str,
        release_stage_sn: str,
        execution_number: str,
        request: devops_20210625_models.GetReleaseStagePipelineRunRequest,
    ) -> devops_20210625_models.GetReleaseStagePipelineRunResponse:
        """
        @summary 获取研发阶段流水线运行实例
        
        @param request: GetReleaseStagePipelineRunRequest
        @return: GetReleaseStagePipelineRunResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_release_stage_pipeline_run_with_options_async(app_name, release_workflow_sn, release_stage_sn, execution_number, request, headers, runtime)

    def get_repository_with_options(
        self,
        request: devops_20210625_models.GetRepositoryRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetRepositoryResponse:
        """
        @summary 使用代码库ID或路径查询代码库信息
        
        @param request: GetRepositoryRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetRepositoryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.identity):
            query['identity'] = request.identity
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetRepository',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/get',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetRepositoryResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_repository_with_options_async(
        self,
        request: devops_20210625_models.GetRepositoryRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetRepositoryResponse:
        """
        @summary 使用代码库ID或路径查询代码库信息
        
        @param request: GetRepositoryRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetRepositoryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.identity):
            query['identity'] = request.identity
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetRepository',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/get',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetRepositoryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_repository(
        self,
        request: devops_20210625_models.GetRepositoryRequest,
    ) -> devops_20210625_models.GetRepositoryResponse:
        """
        @summary 使用代码库ID或路径查询代码库信息
        
        @param request: GetRepositoryRequest
        @return: GetRepositoryResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_repository_with_options(request, headers, runtime)

    async def get_repository_async(
        self,
        request: devops_20210625_models.GetRepositoryRequest,
    ) -> devops_20210625_models.GetRepositoryResponse:
        """
        @summary 使用代码库ID或路径查询代码库信息
        
        @param request: GetRepositoryRequest
        @return: GetRepositoryResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_repository_with_options_async(request, headers, runtime)

    def get_repository_commit_with_options(
        self,
        repository_id: str,
        sha: str,
        request: devops_20210625_models.GetRepositoryCommitRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetRepositoryCommitResponse:
        """
        @summary 查询代码库提交信息
        
        @param request: GetRepositoryCommitRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetRepositoryCommitResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.show_signature):
            query['showSignature'] = request.show_signature
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetRepositoryCommit',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/commits/{OpenApiUtilClient.get_encode_param(sha)}',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetRepositoryCommitResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_repository_commit_with_options_async(
        self,
        repository_id: str,
        sha: str,
        request: devops_20210625_models.GetRepositoryCommitRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetRepositoryCommitResponse:
        """
        @summary 查询代码库提交信息
        
        @param request: GetRepositoryCommitRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetRepositoryCommitResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.show_signature):
            query['showSignature'] = request.show_signature
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetRepositoryCommit',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/commits/{OpenApiUtilClient.get_encode_param(sha)}',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetRepositoryCommitResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_repository_commit(
        self,
        repository_id: str,
        sha: str,
        request: devops_20210625_models.GetRepositoryCommitRequest,
    ) -> devops_20210625_models.GetRepositoryCommitResponse:
        """
        @summary 查询代码库提交信息
        
        @param request: GetRepositoryCommitRequest
        @return: GetRepositoryCommitResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_repository_commit_with_options(repository_id, sha, request, headers, runtime)

    async def get_repository_commit_async(
        self,
        repository_id: str,
        sha: str,
        request: devops_20210625_models.GetRepositoryCommitRequest,
    ) -> devops_20210625_models.GetRepositoryCommitResponse:
        """
        @summary 查询代码库提交信息
        
        @param request: GetRepositoryCommitRequest
        @return: GetRepositoryCommitResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_repository_commit_with_options_async(repository_id, sha, request, headers, runtime)

    def get_repository_tag_with_options(
        self,
        repository_id: str,
        request: devops_20210625_models.GetRepositoryTagRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetRepositoryTagResponse:
        """
        @summary 查询单个标签
        
        @param request: GetRepositoryTagRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetRepositoryTagResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.tag_name):
            query['tagName'] = request.tag_name
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetRepositoryTag',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/tag/info',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetRepositoryTagResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_repository_tag_with_options_async(
        self,
        repository_id: str,
        request: devops_20210625_models.GetRepositoryTagRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetRepositoryTagResponse:
        """
        @summary 查询单个标签
        
        @param request: GetRepositoryTagRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetRepositoryTagResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.tag_name):
            query['tagName'] = request.tag_name
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetRepositoryTag',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/tag/info',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetRepositoryTagResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_repository_tag(
        self,
        repository_id: str,
        request: devops_20210625_models.GetRepositoryTagRequest,
    ) -> devops_20210625_models.GetRepositoryTagResponse:
        """
        @summary 查询单个标签
        
        @param request: GetRepositoryTagRequest
        @return: GetRepositoryTagResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_repository_tag_with_options(repository_id, request, headers, runtime)

    async def get_repository_tag_async(
        self,
        repository_id: str,
        request: devops_20210625_models.GetRepositoryTagRequest,
    ) -> devops_20210625_models.GetRepositoryTagResponse:
        """
        @summary 查询单个标签
        
        @param request: GetRepositoryTagRequest
        @return: GetRepositoryTagResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_repository_tag_with_options_async(repository_id, request, headers, runtime)

    def get_search_code_preview_with_options(
        self,
        request: devops_20210625_models.GetSearchCodePreviewRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetSearchCodePreviewResponse:
        """
        @summary 预览代码片段
        
        @param request: GetSearchCodePreviewRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetSearchCodePreviewResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.doc_id):
            query['docId'] = request.doc_id
        if not UtilClient.is_unset(request.is_dsl):
            query['isDsl'] = request.is_dsl
        if not UtilClient.is_unset(request.keyword):
            query['keyword'] = request.keyword
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetSearchCodePreview',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/search/code_preview',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetSearchCodePreviewResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_search_code_preview_with_options_async(
        self,
        request: devops_20210625_models.GetSearchCodePreviewRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetSearchCodePreviewResponse:
        """
        @summary 预览代码片段
        
        @param request: GetSearchCodePreviewRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetSearchCodePreviewResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.doc_id):
            query['docId'] = request.doc_id
        if not UtilClient.is_unset(request.is_dsl):
            query['isDsl'] = request.is_dsl
        if not UtilClient.is_unset(request.keyword):
            query['keyword'] = request.keyword
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetSearchCodePreview',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/search/code_preview',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetSearchCodePreviewResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_search_code_preview(
        self,
        request: devops_20210625_models.GetSearchCodePreviewRequest,
    ) -> devops_20210625_models.GetSearchCodePreviewResponse:
        """
        @summary 预览代码片段
        
        @param request: GetSearchCodePreviewRequest
        @return: GetSearchCodePreviewResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_search_code_preview_with_options(request, headers, runtime)

    async def get_search_code_preview_async(
        self,
        request: devops_20210625_models.GetSearchCodePreviewRequest,
    ) -> devops_20210625_models.GetSearchCodePreviewResponse:
        """
        @summary 预览代码片段
        
        @param request: GetSearchCodePreviewRequest
        @return: GetSearchCodePreviewResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_search_code_preview_with_options_async(request, headers, runtime)

    def get_sprint_info_with_options(
        self,
        organization_id: str,
        sprint_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetSprintInfoResponse:
        """
        @summary 获取迭代详情
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetSprintInfoResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='GetSprintInfo',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/sprints/{OpenApiUtilClient.get_encode_param(sprint_id)}/getSprintinfo',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetSprintInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_sprint_info_with_options_async(
        self,
        organization_id: str,
        sprint_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetSprintInfoResponse:
        """
        @summary 获取迭代详情
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetSprintInfoResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='GetSprintInfo',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/sprints/{OpenApiUtilClient.get_encode_param(sprint_id)}/getSprintinfo',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetSprintInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_sprint_info(
        self,
        organization_id: str,
        sprint_id: str,
    ) -> devops_20210625_models.GetSprintInfoResponse:
        """
        @summary 获取迭代详情
        
        @return: GetSprintInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_sprint_info_with_options(organization_id, sprint_id, headers, runtime)

    async def get_sprint_info_async(
        self,
        organization_id: str,
        sprint_id: str,
    ) -> devops_20210625_models.GetSprintInfoResponse:
        """
        @summary 获取迭代详情
        
        @return: GetSprintInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_sprint_info_with_options_async(organization_id, sprint_id, headers, runtime)

    def get_test_result_list_with_options(
        self,
        organization_id: str,
        test_plan_identifier: str,
        request: devops_20210625_models.GetTestResultListRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetTestResultListResponse:
        """
        @summary 获取测试计划中的测试用例列表
        
        @param request: GetTestResultListRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetTestResultListResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.conditions):
            body['conditions'] = request.conditions
        if not UtilClient.is_unset(request.directory_identifier):
            body['directoryIdentifier'] = request.directory_identifier
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='GetTestResultList',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/testhub/testplan/{OpenApiUtilClient.get_encode_param(test_plan_identifier)}/testresults',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetTestResultListResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_test_result_list_with_options_async(
        self,
        organization_id: str,
        test_plan_identifier: str,
        request: devops_20210625_models.GetTestResultListRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetTestResultListResponse:
        """
        @summary 获取测试计划中的测试用例列表
        
        @param request: GetTestResultListRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetTestResultListResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.conditions):
            body['conditions'] = request.conditions
        if not UtilClient.is_unset(request.directory_identifier):
            body['directoryIdentifier'] = request.directory_identifier
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='GetTestResultList',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/testhub/testplan/{OpenApiUtilClient.get_encode_param(test_plan_identifier)}/testresults',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetTestResultListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_test_result_list(
        self,
        organization_id: str,
        test_plan_identifier: str,
        request: devops_20210625_models.GetTestResultListRequest,
    ) -> devops_20210625_models.GetTestResultListResponse:
        """
        @summary 获取测试计划中的测试用例列表
        
        @param request: GetTestResultListRequest
        @return: GetTestResultListResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_test_result_list_with_options(organization_id, test_plan_identifier, request, headers, runtime)

    async def get_test_result_list_async(
        self,
        organization_id: str,
        test_plan_identifier: str,
        request: devops_20210625_models.GetTestResultListRequest,
    ) -> devops_20210625_models.GetTestResultListResponse:
        """
        @summary 获取测试计划中的测试用例列表
        
        @param request: GetTestResultListRequest
        @return: GetTestResultListResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_test_result_list_with_options_async(organization_id, test_plan_identifier, request, headers, runtime)

    def get_testcase_list_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.GetTestcaseListRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetTestcaseListResponse:
        """
        @summary 获取测试用例列表
        
        @param request: GetTestcaseListRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetTestcaseListResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.conditions):
            body['conditions'] = request.conditions
        if not UtilClient.is_unset(request.directory_identifier):
            body['directoryIdentifier'] = request.directory_identifier
        if not UtilClient.is_unset(request.max_result):
            body['maxResult'] = request.max_result
        if not UtilClient.is_unset(request.next_token):
            body['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.space_identifier):
            body['spaceIdentifier'] = request.space_identifier
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='GetTestcaseList',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/testhub/testcases',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetTestcaseListResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_testcase_list_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.GetTestcaseListRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetTestcaseListResponse:
        """
        @summary 获取测试用例列表
        
        @param request: GetTestcaseListRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetTestcaseListResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.conditions):
            body['conditions'] = request.conditions
        if not UtilClient.is_unset(request.directory_identifier):
            body['directoryIdentifier'] = request.directory_identifier
        if not UtilClient.is_unset(request.max_result):
            body['maxResult'] = request.max_result
        if not UtilClient.is_unset(request.next_token):
            body['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.space_identifier):
            body['spaceIdentifier'] = request.space_identifier
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='GetTestcaseList',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/testhub/testcases',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetTestcaseListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_testcase_list(
        self,
        organization_id: str,
        request: devops_20210625_models.GetTestcaseListRequest,
    ) -> devops_20210625_models.GetTestcaseListResponse:
        """
        @summary 获取测试用例列表
        
        @param request: GetTestcaseListRequest
        @return: GetTestcaseListResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_testcase_list_with_options(organization_id, request, headers, runtime)

    async def get_testcase_list_async(
        self,
        organization_id: str,
        request: devops_20210625_models.GetTestcaseListRequest,
    ) -> devops_20210625_models.GetTestcaseListResponse:
        """
        @summary 获取测试用例列表
        
        @param request: GetTestcaseListRequest
        @return: GetTestcaseListResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_testcase_list_with_options_async(organization_id, request, headers, runtime)

    def get_user_info_with_options(
        self,
        request: devops_20210625_models.GetUserInfoRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetUserInfoResponse:
        """
        @summary 查询当前用户信息
        
        @param request: GetUserInfoRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetUserInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetUserInfo',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/users/current',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetUserInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_user_info_with_options_async(
        self,
        request: devops_20210625_models.GetUserInfoRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetUserInfoResponse:
        """
        @summary 查询当前用户信息
        
        @param request: GetUserInfoRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetUserInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetUserInfo',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/users/current',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetUserInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_user_info(
        self,
        request: devops_20210625_models.GetUserInfoRequest,
    ) -> devops_20210625_models.GetUserInfoResponse:
        """
        @summary 查询当前用户信息
        
        @param request: GetUserInfoRequest
        @return: GetUserInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_user_info_with_options(request, headers, runtime)

    async def get_user_info_async(
        self,
        request: devops_20210625_models.GetUserInfoRequest,
    ) -> devops_20210625_models.GetUserInfoResponse:
        """
        @summary 查询当前用户信息
        
        @param request: GetUserInfoRequest
        @return: GetUserInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_user_info_with_options_async(request, headers, runtime)

    def get_vmdeploy_order_with_options(
        self,
        organization_id: str,
        pipeline_id: str,
        deploy_order_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetVMDeployOrderResponse:
        """
        @summary 获取部署单信息
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetVMDeployOrderResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='GetVMDeployOrder',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines/{OpenApiUtilClient.get_encode_param(pipeline_id)}/deploy/{OpenApiUtilClient.get_encode_param(deploy_order_id)}',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetVMDeployOrderResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_vmdeploy_order_with_options_async(
        self,
        organization_id: str,
        pipeline_id: str,
        deploy_order_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetVMDeployOrderResponse:
        """
        @summary 获取部署单信息
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetVMDeployOrderResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='GetVMDeployOrder',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines/{OpenApiUtilClient.get_encode_param(pipeline_id)}/deploy/{OpenApiUtilClient.get_encode_param(deploy_order_id)}',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetVMDeployOrderResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_vmdeploy_order(
        self,
        organization_id: str,
        pipeline_id: str,
        deploy_order_id: str,
    ) -> devops_20210625_models.GetVMDeployOrderResponse:
        """
        @summary 获取部署单信息
        
        @return: GetVMDeployOrderResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_vmdeploy_order_with_options(organization_id, pipeline_id, deploy_order_id, headers, runtime)

    async def get_vmdeploy_order_async(
        self,
        organization_id: str,
        pipeline_id: str,
        deploy_order_id: str,
    ) -> devops_20210625_models.GetVMDeployOrderResponse:
        """
        @summary 获取部署单信息
        
        @return: GetVMDeployOrderResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_vmdeploy_order_with_options_async(organization_id, pipeline_id, deploy_order_id, headers, runtime)

    def get_variable_group_with_options(
        self,
        organization_id: str,
        id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetVariableGroupResponse:
        """
        @summary 获取变量组
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetVariableGroupResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='GetVariableGroup',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/variableGroups/{OpenApiUtilClient.get_encode_param(id)}',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetVariableGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_variable_group_with_options_async(
        self,
        organization_id: str,
        id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetVariableGroupResponse:
        """
        @summary 获取变量组
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetVariableGroupResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='GetVariableGroup',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/variableGroups/{OpenApiUtilClient.get_encode_param(id)}',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetVariableGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_variable_group(
        self,
        organization_id: str,
        id: str,
    ) -> devops_20210625_models.GetVariableGroupResponse:
        """
        @summary 获取变量组
        
        @return: GetVariableGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_variable_group_with_options(organization_id, id, headers, runtime)

    async def get_variable_group_async(
        self,
        organization_id: str,
        id: str,
    ) -> devops_20210625_models.GetVariableGroupResponse:
        """
        @summary 获取变量组
        
        @return: GetVariableGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_variable_group_with_options_async(organization_id, id, headers, runtime)

    def get_work_item_activity_with_options(
        self,
        organization_id: str,
        workitem_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetWorkItemActivityResponse:
        """
        @summary 获取工作项动态
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetWorkItemActivityResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='GetWorkItemActivity',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitems/{OpenApiUtilClient.get_encode_param(workitem_id)}/getActivity',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetWorkItemActivityResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_work_item_activity_with_options_async(
        self,
        organization_id: str,
        workitem_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetWorkItemActivityResponse:
        """
        @summary 获取工作项动态
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetWorkItemActivityResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='GetWorkItemActivity',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitems/{OpenApiUtilClient.get_encode_param(workitem_id)}/getActivity',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetWorkItemActivityResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_work_item_activity(
        self,
        organization_id: str,
        workitem_id: str,
    ) -> devops_20210625_models.GetWorkItemActivityResponse:
        """
        @summary 获取工作项动态
        
        @return: GetWorkItemActivityResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_work_item_activity_with_options(organization_id, workitem_id, headers, runtime)

    async def get_work_item_activity_async(
        self,
        organization_id: str,
        workitem_id: str,
    ) -> devops_20210625_models.GetWorkItemActivityResponse:
        """
        @summary 获取工作项动态
        
        @return: GetWorkItemActivityResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_work_item_activity_with_options_async(organization_id, workitem_id, headers, runtime)

    def get_work_item_info_with_options(
        self,
        organization_id: str,
        workitem_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetWorkItemInfoResponse:
        """
        @summary 根据id获取工作项详情
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetWorkItemInfoResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='GetWorkItemInfo',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitems/{OpenApiUtilClient.get_encode_param(workitem_id)}',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetWorkItemInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_work_item_info_with_options_async(
        self,
        organization_id: str,
        workitem_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetWorkItemInfoResponse:
        """
        @summary 根据id获取工作项详情
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetWorkItemInfoResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='GetWorkItemInfo',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitems/{OpenApiUtilClient.get_encode_param(workitem_id)}',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetWorkItemInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_work_item_info(
        self,
        organization_id: str,
        workitem_id: str,
    ) -> devops_20210625_models.GetWorkItemInfoResponse:
        """
        @summary 根据id获取工作项详情
        
        @return: GetWorkItemInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_work_item_info_with_options(organization_id, workitem_id, headers, runtime)

    async def get_work_item_info_async(
        self,
        organization_id: str,
        workitem_id: str,
    ) -> devops_20210625_models.GetWorkItemInfoResponse:
        """
        @summary 根据id获取工作项详情
        
        @return: GetWorkItemInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_work_item_info_with_options_async(organization_id, workitem_id, headers, runtime)

    def get_work_item_work_flow_info_with_options(
        self,
        organization_id: str,
        workitem_id: str,
        request: devops_20210625_models.GetWorkItemWorkFlowInfoRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetWorkItemWorkFlowInfoResponse:
        """
        @summary 获取工作项工作流信息
        
        @param request: GetWorkItemWorkFlowInfoRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetWorkItemWorkFlowInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.configuration_id):
            query['configurationId'] = request.configuration_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetWorkItemWorkFlowInfo',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitems/{OpenApiUtilClient.get_encode_param(workitem_id)}/getWorkflowInfo',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetWorkItemWorkFlowInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_work_item_work_flow_info_with_options_async(
        self,
        organization_id: str,
        workitem_id: str,
        request: devops_20210625_models.GetWorkItemWorkFlowInfoRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetWorkItemWorkFlowInfoResponse:
        """
        @summary 获取工作项工作流信息
        
        @param request: GetWorkItemWorkFlowInfoRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetWorkItemWorkFlowInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.configuration_id):
            query['configurationId'] = request.configuration_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetWorkItemWorkFlowInfo',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitems/{OpenApiUtilClient.get_encode_param(workitem_id)}/getWorkflowInfo',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetWorkItemWorkFlowInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_work_item_work_flow_info(
        self,
        organization_id: str,
        workitem_id: str,
        request: devops_20210625_models.GetWorkItemWorkFlowInfoRequest,
    ) -> devops_20210625_models.GetWorkItemWorkFlowInfoResponse:
        """
        @summary 获取工作项工作流信息
        
        @param request: GetWorkItemWorkFlowInfoRequest
        @return: GetWorkItemWorkFlowInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_work_item_work_flow_info_with_options(organization_id, workitem_id, request, headers, runtime)

    async def get_work_item_work_flow_info_async(
        self,
        organization_id: str,
        workitem_id: str,
        request: devops_20210625_models.GetWorkItemWorkFlowInfoRequest,
    ) -> devops_20210625_models.GetWorkItemWorkFlowInfoResponse:
        """
        @summary 获取工作项工作流信息
        
        @param request: GetWorkItemWorkFlowInfoRequest
        @return: GetWorkItemWorkFlowInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_work_item_work_flow_info_with_options_async(organization_id, workitem_id, request, headers, runtime)

    def get_workitem_attachment_createmeta_with_options(
        self,
        organization_id: str,
        workitem_identifier: str,
        request: devops_20210625_models.GetWorkitemAttachmentCreatemetaRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetWorkitemAttachmentCreatemetaResponse:
        """
        @summary 获取附件上传的元信息
        
        @param request: GetWorkitemAttachmentCreatemetaRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetWorkitemAttachmentCreatemetaResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.file_name):
            query['fileName'] = request.file_name
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetWorkitemAttachmentCreatemeta',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitem/{OpenApiUtilClient.get_encode_param(workitem_identifier)}/attachment/createmeta',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetWorkitemAttachmentCreatemetaResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_workitem_attachment_createmeta_with_options_async(
        self,
        organization_id: str,
        workitem_identifier: str,
        request: devops_20210625_models.GetWorkitemAttachmentCreatemetaRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetWorkitemAttachmentCreatemetaResponse:
        """
        @summary 获取附件上传的元信息
        
        @param request: GetWorkitemAttachmentCreatemetaRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetWorkitemAttachmentCreatemetaResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.file_name):
            query['fileName'] = request.file_name
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetWorkitemAttachmentCreatemeta',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitem/{OpenApiUtilClient.get_encode_param(workitem_identifier)}/attachment/createmeta',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetWorkitemAttachmentCreatemetaResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_workitem_attachment_createmeta(
        self,
        organization_id: str,
        workitem_identifier: str,
        request: devops_20210625_models.GetWorkitemAttachmentCreatemetaRequest,
    ) -> devops_20210625_models.GetWorkitemAttachmentCreatemetaResponse:
        """
        @summary 获取附件上传的元信息
        
        @param request: GetWorkitemAttachmentCreatemetaRequest
        @return: GetWorkitemAttachmentCreatemetaResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_workitem_attachment_createmeta_with_options(organization_id, workitem_identifier, request, headers, runtime)

    async def get_workitem_attachment_createmeta_async(
        self,
        organization_id: str,
        workitem_identifier: str,
        request: devops_20210625_models.GetWorkitemAttachmentCreatemetaRequest,
    ) -> devops_20210625_models.GetWorkitemAttachmentCreatemetaResponse:
        """
        @summary 获取附件上传的元信息
        
        @param request: GetWorkitemAttachmentCreatemetaRequest
        @return: GetWorkitemAttachmentCreatemetaResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_workitem_attachment_createmeta_with_options_async(organization_id, workitem_identifier, request, headers, runtime)

    def get_workitem_comment_list_with_options(
        self,
        organization_id: str,
        workitem_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetWorkitemCommentListResponse:
        """
        @summary 获得所有评论
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetWorkitemCommentListResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='GetWorkitemCommentList',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitems/{OpenApiUtilClient.get_encode_param(workitem_id)}/commentList',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetWorkitemCommentListResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_workitem_comment_list_with_options_async(
        self,
        organization_id: str,
        workitem_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetWorkitemCommentListResponse:
        """
        @summary 获得所有评论
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetWorkitemCommentListResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='GetWorkitemCommentList',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitems/{OpenApiUtilClient.get_encode_param(workitem_id)}/commentList',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetWorkitemCommentListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_workitem_comment_list(
        self,
        organization_id: str,
        workitem_id: str,
    ) -> devops_20210625_models.GetWorkitemCommentListResponse:
        """
        @summary 获得所有评论
        
        @return: GetWorkitemCommentListResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_workitem_comment_list_with_options(organization_id, workitem_id, headers, runtime)

    async def get_workitem_comment_list_async(
        self,
        organization_id: str,
        workitem_id: str,
    ) -> devops_20210625_models.GetWorkitemCommentListResponse:
        """
        @summary 获得所有评论
        
        @return: GetWorkitemCommentListResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_workitem_comment_list_with_options_async(organization_id, workitem_id, headers, runtime)

    def get_workitem_file_with_options(
        self,
        organization_id: str,
        workitem_identifier: str,
        file_identifier: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetWorkitemFileResponse:
        """
        @summary 获取工作项文件信息
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetWorkitemFileResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='GetWorkitemFile',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitem/{OpenApiUtilClient.get_encode_param(workitem_identifier)}/files/{OpenApiUtilClient.get_encode_param(file_identifier)}',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetWorkitemFileResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_workitem_file_with_options_async(
        self,
        organization_id: str,
        workitem_identifier: str,
        file_identifier: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetWorkitemFileResponse:
        """
        @summary 获取工作项文件信息
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetWorkitemFileResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='GetWorkitemFile',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitem/{OpenApiUtilClient.get_encode_param(workitem_identifier)}/files/{OpenApiUtilClient.get_encode_param(file_identifier)}',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetWorkitemFileResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_workitem_file(
        self,
        organization_id: str,
        workitem_identifier: str,
        file_identifier: str,
    ) -> devops_20210625_models.GetWorkitemFileResponse:
        """
        @summary 获取工作项文件信息
        
        @return: GetWorkitemFileResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_workitem_file_with_options(organization_id, workitem_identifier, file_identifier, headers, runtime)

    async def get_workitem_file_async(
        self,
        organization_id: str,
        workitem_identifier: str,
        file_identifier: str,
    ) -> devops_20210625_models.GetWorkitemFileResponse:
        """
        @summary 获取工作项文件信息
        
        @return: GetWorkitemFileResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_workitem_file_with_options_async(organization_id, workitem_identifier, file_identifier, headers, runtime)

    def get_workitem_relations_with_options(
        self,
        organization_id: str,
        workitem_id: str,
        request: devops_20210625_models.GetWorkitemRelationsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetWorkitemRelationsResponse:
        """
        @summary 获得一个工作项的指定关联项
        
        @param request: GetWorkitemRelationsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetWorkitemRelationsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.relation_type):
            query['relationType'] = request.relation_type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetWorkitemRelations',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitems/{OpenApiUtilClient.get_encode_param(workitem_id)}/getRelations',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetWorkitemRelationsResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_workitem_relations_with_options_async(
        self,
        organization_id: str,
        workitem_id: str,
        request: devops_20210625_models.GetWorkitemRelationsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetWorkitemRelationsResponse:
        """
        @summary 获得一个工作项的指定关联项
        
        @param request: GetWorkitemRelationsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetWorkitemRelationsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.relation_type):
            query['relationType'] = request.relation_type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetWorkitemRelations',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitems/{OpenApiUtilClient.get_encode_param(workitem_id)}/getRelations',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetWorkitemRelationsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_workitem_relations(
        self,
        organization_id: str,
        workitem_id: str,
        request: devops_20210625_models.GetWorkitemRelationsRequest,
    ) -> devops_20210625_models.GetWorkitemRelationsResponse:
        """
        @summary 获得一个工作项的指定关联项
        
        @param request: GetWorkitemRelationsRequest
        @return: GetWorkitemRelationsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_workitem_relations_with_options(organization_id, workitem_id, request, headers, runtime)

    async def get_workitem_relations_async(
        self,
        organization_id: str,
        workitem_id: str,
        request: devops_20210625_models.GetWorkitemRelationsRequest,
    ) -> devops_20210625_models.GetWorkitemRelationsResponse:
        """
        @summary 获得一个工作项的指定关联项
        
        @param request: GetWorkitemRelationsRequest
        @return: GetWorkitemRelationsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_workitem_relations_with_options_async(organization_id, workitem_id, request, headers, runtime)

    def get_workitem_time_type_list_with_options(
        self,
        organization_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetWorkitemTimeTypeListResponse:
        """
        @summary 获得一个企业下所有工时类型
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetWorkitemTimeTypeListResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='GetWorkitemTimeTypeList',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitems/type/list',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetWorkitemTimeTypeListResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_workitem_time_type_list_with_options_async(
        self,
        organization_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.GetWorkitemTimeTypeListResponse:
        """
        @summary 获得一个企业下所有工时类型
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetWorkitemTimeTypeListResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='GetWorkitemTimeTypeList',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitems/type/list',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.GetWorkitemTimeTypeListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_workitem_time_type_list(
        self,
        organization_id: str,
    ) -> devops_20210625_models.GetWorkitemTimeTypeListResponse:
        """
        @summary 获得一个企业下所有工时类型
        
        @return: GetWorkitemTimeTypeListResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.get_workitem_time_type_list_with_options(organization_id, headers, runtime)

    async def get_workitem_time_type_list_async(
        self,
        organization_id: str,
    ) -> devops_20210625_models.GetWorkitemTimeTypeListResponse:
        """
        @summary 获得一个企业下所有工时类型
        
        @return: GetWorkitemTimeTypeListResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.get_workitem_time_type_list_with_options_async(organization_id, headers, runtime)

    def join_pipeline_group_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.JoinPipelineGroupRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.JoinPipelineGroupResponse:
        """
        @summary 加入流水线分组
        
        @param request: JoinPipelineGroupRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: JoinPipelineGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.group_id):
            query['groupId'] = request.group_id
        if not UtilClient.is_unset(request.pipeline_ids):
            query['pipelineIds'] = request.pipeline_ids
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='JoinPipelineGroup',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelineGroups/join',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.JoinPipelineGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def join_pipeline_group_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.JoinPipelineGroupRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.JoinPipelineGroupResponse:
        """
        @summary 加入流水线分组
        
        @param request: JoinPipelineGroupRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: JoinPipelineGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.group_id):
            query['groupId'] = request.group_id
        if not UtilClient.is_unset(request.pipeline_ids):
            query['pipelineIds'] = request.pipeline_ids
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='JoinPipelineGroup',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelineGroups/join',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.JoinPipelineGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def join_pipeline_group(
        self,
        organization_id: str,
        request: devops_20210625_models.JoinPipelineGroupRequest,
    ) -> devops_20210625_models.JoinPipelineGroupResponse:
        """
        @summary 加入流水线分组
        
        @param request: JoinPipelineGroupRequest
        @return: JoinPipelineGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.join_pipeline_group_with_options(organization_id, request, headers, runtime)

    async def join_pipeline_group_async(
        self,
        organization_id: str,
        request: devops_20210625_models.JoinPipelineGroupRequest,
    ) -> devops_20210625_models.JoinPipelineGroupResponse:
        """
        @summary 加入流水线分组
        
        @param request: JoinPipelineGroupRequest
        @return: JoinPipelineGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.join_pipeline_group_with_options_async(organization_id, request, headers, runtime)

    def link_merge_request_label_with_options(
        self,
        request: devops_20210625_models.LinkMergeRequestLabelRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.LinkMergeRequestLabelResponse:
        """
        @summary 关联合并请求Label
        
        @param request: LinkMergeRequestLabelRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: LinkMergeRequestLabelResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.local_id):
            query['localId'] = request.local_id
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.repository_identity):
            query['repositoryIdentity'] = request.repository_identity
        body = {}
        if not UtilClient.is_unset(request.label_ids):
            body['labelIds'] = request.label_ids
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='LinkMergeRequestLabel',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/merge_requests/link_labels',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.LinkMergeRequestLabelResponse(),
            self.call_api(params, req, runtime)
        )

    async def link_merge_request_label_with_options_async(
        self,
        request: devops_20210625_models.LinkMergeRequestLabelRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.LinkMergeRequestLabelResponse:
        """
        @summary 关联合并请求Label
        
        @param request: LinkMergeRequestLabelRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: LinkMergeRequestLabelResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.local_id):
            query['localId'] = request.local_id
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.repository_identity):
            query['repositoryIdentity'] = request.repository_identity
        body = {}
        if not UtilClient.is_unset(request.label_ids):
            body['labelIds'] = request.label_ids
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='LinkMergeRequestLabel',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/merge_requests/link_labels',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.LinkMergeRequestLabelResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def link_merge_request_label(
        self,
        request: devops_20210625_models.LinkMergeRequestLabelRequest,
    ) -> devops_20210625_models.LinkMergeRequestLabelResponse:
        """
        @summary 关联合并请求Label
        
        @param request: LinkMergeRequestLabelRequest
        @return: LinkMergeRequestLabelResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.link_merge_request_label_with_options(request, headers, runtime)

    async def link_merge_request_label_async(
        self,
        request: devops_20210625_models.LinkMergeRequestLabelRequest,
    ) -> devops_20210625_models.LinkMergeRequestLabelResponse:
        """
        @summary 关联合并请求Label
        
        @param request: LinkMergeRequestLabelRequest
        @return: LinkMergeRequestLabelResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.link_merge_request_label_with_options_async(request, headers, runtime)

    def list_all_release_workflows_with_options(
        self,
        app_name: str,
        request: devops_20210625_models.ListAllReleaseWorkflowsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListAllReleaseWorkflowsResponse:
        """
        @summary 查找应用下所有的研发流程
        
        @param request: ListAllReleaseWorkflowsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListAllReleaseWorkflowsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListAllReleaseWorkflows',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/appstack/apps/{OpenApiUtilClient.get_encode_param(app_name)}/releaseWorkflows',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='array'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListAllReleaseWorkflowsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_all_release_workflows_with_options_async(
        self,
        app_name: str,
        request: devops_20210625_models.ListAllReleaseWorkflowsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListAllReleaseWorkflowsResponse:
        """
        @summary 查找应用下所有的研发流程
        
        @param request: ListAllReleaseWorkflowsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListAllReleaseWorkflowsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListAllReleaseWorkflows',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/appstack/apps/{OpenApiUtilClient.get_encode_param(app_name)}/releaseWorkflows',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='array'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListAllReleaseWorkflowsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_all_release_workflows(
        self,
        app_name: str,
        request: devops_20210625_models.ListAllReleaseWorkflowsRequest,
    ) -> devops_20210625_models.ListAllReleaseWorkflowsResponse:
        """
        @summary 查找应用下所有的研发流程
        
        @param request: ListAllReleaseWorkflowsRequest
        @return: ListAllReleaseWorkflowsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_all_release_workflows_with_options(app_name, request, headers, runtime)

    async def list_all_release_workflows_async(
        self,
        app_name: str,
        request: devops_20210625_models.ListAllReleaseWorkflowsRequest,
    ) -> devops_20210625_models.ListAllReleaseWorkflowsResponse:
        """
        @summary 查找应用下所有的研发流程
        
        @param request: ListAllReleaseWorkflowsRequest
        @return: ListAllReleaseWorkflowsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_all_release_workflows_with_options_async(app_name, request, headers, runtime)

    def list_app_release_stage_execution_integrated_metadata_with_options(
        self,
        app_name: str,
        release_workflow_sn: str,
        release_stage_sn: str,
        execution_number: str,
        request: devops_20210625_models.ListAppReleaseStageExecutionIntegratedMetadataRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListAppReleaseStageExecutionIntegratedMetadataResponse:
        """
        @summary 查询研发阶段执行记录集成变更信息
        
        @param request: ListAppReleaseStageExecutionIntegratedMetadataRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListAppReleaseStageExecutionIntegratedMetadataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListAppReleaseStageExecutionIntegratedMetadata',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/appstack/apps/{OpenApiUtilClient.get_encode_param(app_name)}/releaseWorkflows/{OpenApiUtilClient.get_encode_param(release_workflow_sn)}/releaseStages/{OpenApiUtilClient.get_encode_param(release_stage_sn)}/executions/{OpenApiUtilClient.get_encode_param(execution_number)}/integratedMetadata',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='array'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListAppReleaseStageExecutionIntegratedMetadataResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_app_release_stage_execution_integrated_metadata_with_options_async(
        self,
        app_name: str,
        release_workflow_sn: str,
        release_stage_sn: str,
        execution_number: str,
        request: devops_20210625_models.ListAppReleaseStageExecutionIntegratedMetadataRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListAppReleaseStageExecutionIntegratedMetadataResponse:
        """
        @summary 查询研发阶段执行记录集成变更信息
        
        @param request: ListAppReleaseStageExecutionIntegratedMetadataRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListAppReleaseStageExecutionIntegratedMetadataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListAppReleaseStageExecutionIntegratedMetadata',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/appstack/apps/{OpenApiUtilClient.get_encode_param(app_name)}/releaseWorkflows/{OpenApiUtilClient.get_encode_param(release_workflow_sn)}/releaseStages/{OpenApiUtilClient.get_encode_param(release_stage_sn)}/executions/{OpenApiUtilClient.get_encode_param(execution_number)}/integratedMetadata',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='array'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListAppReleaseStageExecutionIntegratedMetadataResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_app_release_stage_execution_integrated_metadata(
        self,
        app_name: str,
        release_workflow_sn: str,
        release_stage_sn: str,
        execution_number: str,
        request: devops_20210625_models.ListAppReleaseStageExecutionIntegratedMetadataRequest,
    ) -> devops_20210625_models.ListAppReleaseStageExecutionIntegratedMetadataResponse:
        """
        @summary 查询研发阶段执行记录集成变更信息
        
        @param request: ListAppReleaseStageExecutionIntegratedMetadataRequest
        @return: ListAppReleaseStageExecutionIntegratedMetadataResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_app_release_stage_execution_integrated_metadata_with_options(app_name, release_workflow_sn, release_stage_sn, execution_number, request, headers, runtime)

    async def list_app_release_stage_execution_integrated_metadata_async(
        self,
        app_name: str,
        release_workflow_sn: str,
        release_stage_sn: str,
        execution_number: str,
        request: devops_20210625_models.ListAppReleaseStageExecutionIntegratedMetadataRequest,
    ) -> devops_20210625_models.ListAppReleaseStageExecutionIntegratedMetadataResponse:
        """
        @summary 查询研发阶段执行记录集成变更信息
        
        @param request: ListAppReleaseStageExecutionIntegratedMetadataRequest
        @return: ListAppReleaseStageExecutionIntegratedMetadataResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_app_release_stage_execution_integrated_metadata_with_options_async(app_name, release_workflow_sn, release_stage_sn, execution_number, request, headers, runtime)

    def list_app_release_stage_executions_with_options(
        self,
        app_name: str,
        release_workflow_sn: str,
        release_stage_sn: str,
        request: devops_20210625_models.ListAppReleaseStageExecutionsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListAppReleaseStageExecutionsResponse:
        """
        @summary 批量查询研发阶段执行记录
        
        @param request: ListAppReleaseStageExecutionsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListAppReleaseStageExecutionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.next_token):
            query['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.order_by):
            query['orderBy'] = request.order_by
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.page):
            query['page'] = request.page
        if not UtilClient.is_unset(request.pagination):
            query['pagination'] = request.pagination
        if not UtilClient.is_unset(request.per_page):
            query['perPage'] = request.per_page
        if not UtilClient.is_unset(request.sort):
            query['sort'] = request.sort
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListAppReleaseStageExecutions',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/appstack/apps/{OpenApiUtilClient.get_encode_param(app_name)}/releaseWorkflows/{OpenApiUtilClient.get_encode_param(release_workflow_sn)}/releaseStages/{OpenApiUtilClient.get_encode_param(release_stage_sn)}/executions',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListAppReleaseStageExecutionsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_app_release_stage_executions_with_options_async(
        self,
        app_name: str,
        release_workflow_sn: str,
        release_stage_sn: str,
        request: devops_20210625_models.ListAppReleaseStageExecutionsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListAppReleaseStageExecutionsResponse:
        """
        @summary 批量查询研发阶段执行记录
        
        @param request: ListAppReleaseStageExecutionsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListAppReleaseStageExecutionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.next_token):
            query['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.order_by):
            query['orderBy'] = request.order_by
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.page):
            query['page'] = request.page
        if not UtilClient.is_unset(request.pagination):
            query['pagination'] = request.pagination
        if not UtilClient.is_unset(request.per_page):
            query['perPage'] = request.per_page
        if not UtilClient.is_unset(request.sort):
            query['sort'] = request.sort
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListAppReleaseStageExecutions',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/appstack/apps/{OpenApiUtilClient.get_encode_param(app_name)}/releaseWorkflows/{OpenApiUtilClient.get_encode_param(release_workflow_sn)}/releaseStages/{OpenApiUtilClient.get_encode_param(release_stage_sn)}/executions',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListAppReleaseStageExecutionsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_app_release_stage_executions(
        self,
        app_name: str,
        release_workflow_sn: str,
        release_stage_sn: str,
        request: devops_20210625_models.ListAppReleaseStageExecutionsRequest,
    ) -> devops_20210625_models.ListAppReleaseStageExecutionsResponse:
        """
        @summary 批量查询研发阶段执行记录
        
        @param request: ListAppReleaseStageExecutionsRequest
        @return: ListAppReleaseStageExecutionsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_app_release_stage_executions_with_options(app_name, release_workflow_sn, release_stage_sn, request, headers, runtime)

    async def list_app_release_stage_executions_async(
        self,
        app_name: str,
        release_workflow_sn: str,
        release_stage_sn: str,
        request: devops_20210625_models.ListAppReleaseStageExecutionsRequest,
    ) -> devops_20210625_models.ListAppReleaseStageExecutionsResponse:
        """
        @summary 批量查询研发阶段执行记录
        
        @param request: ListAppReleaseStageExecutionsRequest
        @return: ListAppReleaseStageExecutionsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_app_release_stage_executions_with_options_async(app_name, release_workflow_sn, release_stage_sn, request, headers, runtime)

    def list_application_members_with_options(
        self,
        app_name: str,
        request: devops_20210625_models.ListApplicationMembersRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListApplicationMembersResponse:
        """
        @summary 查找应用成员列表
        
        @param request: ListApplicationMembersRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListApplicationMembersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListApplicationMembers',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/appstack/apps/{OpenApiUtilClient.get_encode_param(app_name)}/members',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListApplicationMembersResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_application_members_with_options_async(
        self,
        app_name: str,
        request: devops_20210625_models.ListApplicationMembersRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListApplicationMembersResponse:
        """
        @summary 查找应用成员列表
        
        @param request: ListApplicationMembersRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListApplicationMembersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListApplicationMembers',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/appstack/apps/{OpenApiUtilClient.get_encode_param(app_name)}/members',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListApplicationMembersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_application_members(
        self,
        app_name: str,
        request: devops_20210625_models.ListApplicationMembersRequest,
    ) -> devops_20210625_models.ListApplicationMembersResponse:
        """
        @summary 查找应用成员列表
        
        @param request: ListApplicationMembersRequest
        @return: ListApplicationMembersResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_application_members_with_options(app_name, request, headers, runtime)

    async def list_application_members_async(
        self,
        app_name: str,
        request: devops_20210625_models.ListApplicationMembersRequest,
    ) -> devops_20210625_models.ListApplicationMembersResponse:
        """
        @summary 查找应用成员列表
        
        @param request: ListApplicationMembersRequest
        @return: ListApplicationMembersResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_application_members_with_options_async(app_name, request, headers, runtime)

    def list_applications_with_options(
        self,
        request: devops_20210625_models.ListApplicationsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListApplicationsResponse:
        """
        @summary 分页查找应用详情
        
        @param request: ListApplicationsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListApplicationsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.next_token):
            query['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.order_by):
            query['orderBy'] = request.order_by
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.pagination):
            query['pagination'] = request.pagination
        if not UtilClient.is_unset(request.per_page):
            query['perPage'] = request.per_page
        if not UtilClient.is_unset(request.sort):
            query['sort'] = request.sort
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListApplications',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/appstack/apps%3Asearch',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListApplicationsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_applications_with_options_async(
        self,
        request: devops_20210625_models.ListApplicationsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListApplicationsResponse:
        """
        @summary 分页查找应用详情
        
        @param request: ListApplicationsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListApplicationsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.next_token):
            query['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.order_by):
            query['orderBy'] = request.order_by
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.pagination):
            query['pagination'] = request.pagination
        if not UtilClient.is_unset(request.per_page):
            query['perPage'] = request.per_page
        if not UtilClient.is_unset(request.sort):
            query['sort'] = request.sort
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListApplications',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/appstack/apps%3Asearch',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListApplicationsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_applications(
        self,
        request: devops_20210625_models.ListApplicationsRequest,
    ) -> devops_20210625_models.ListApplicationsResponse:
        """
        @summary 分页查找应用详情
        
        @param request: ListApplicationsRequest
        @return: ListApplicationsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_applications_with_options(request, headers, runtime)

    async def list_applications_async(
        self,
        request: devops_20210625_models.ListApplicationsRequest,
    ) -> devops_20210625_models.ListApplicationsResponse:
        """
        @summary 分页查找应用详情
        
        @param request: ListApplicationsRequest
        @return: ListApplicationsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_applications_with_options_async(request, headers, runtime)

    def list_change_request_workflow_executions_with_options(
        self,
        app_name: str,
        sn: str,
        request: devops_20210625_models.ListChangeRequestWorkflowExecutionsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListChangeRequestWorkflowExecutionsResponse:
        """
        @summary 查询变更研发流程运行记录
        
        @param request: ListChangeRequestWorkflowExecutionsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListChangeRequestWorkflowExecutionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.order_by):
            query['orderBy'] = request.order_by
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.page):
            query['page'] = request.page
        if not UtilClient.is_unset(request.per_page):
            query['perPage'] = request.per_page
        if not UtilClient.is_unset(request.release_stage_sn):
            query['releaseStageSn'] = request.release_stage_sn
        if not UtilClient.is_unset(request.release_workflow_sn):
            query['releaseWorkflowSn'] = request.release_workflow_sn
        if not UtilClient.is_unset(request.sort):
            query['sort'] = request.sort
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListChangeRequestWorkflowExecutions',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/appstack/apps/{OpenApiUtilClient.get_encode_param(app_name)}/changeRequests/{OpenApiUtilClient.get_encode_param(sn)}/executions',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListChangeRequestWorkflowExecutionsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_change_request_workflow_executions_with_options_async(
        self,
        app_name: str,
        sn: str,
        request: devops_20210625_models.ListChangeRequestWorkflowExecutionsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListChangeRequestWorkflowExecutionsResponse:
        """
        @summary 查询变更研发流程运行记录
        
        @param request: ListChangeRequestWorkflowExecutionsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListChangeRequestWorkflowExecutionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.order_by):
            query['orderBy'] = request.order_by
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.page):
            query['page'] = request.page
        if not UtilClient.is_unset(request.per_page):
            query['perPage'] = request.per_page
        if not UtilClient.is_unset(request.release_stage_sn):
            query['releaseStageSn'] = request.release_stage_sn
        if not UtilClient.is_unset(request.release_workflow_sn):
            query['releaseWorkflowSn'] = request.release_workflow_sn
        if not UtilClient.is_unset(request.sort):
            query['sort'] = request.sort
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListChangeRequestWorkflowExecutions',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/appstack/apps/{OpenApiUtilClient.get_encode_param(app_name)}/changeRequests/{OpenApiUtilClient.get_encode_param(sn)}/executions',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListChangeRequestWorkflowExecutionsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_change_request_workflow_executions(
        self,
        app_name: str,
        sn: str,
        request: devops_20210625_models.ListChangeRequestWorkflowExecutionsRequest,
    ) -> devops_20210625_models.ListChangeRequestWorkflowExecutionsResponse:
        """
        @summary 查询变更研发流程运行记录
        
        @param request: ListChangeRequestWorkflowExecutionsRequest
        @return: ListChangeRequestWorkflowExecutionsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_change_request_workflow_executions_with_options(app_name, sn, request, headers, runtime)

    async def list_change_request_workflow_executions_async(
        self,
        app_name: str,
        sn: str,
        request: devops_20210625_models.ListChangeRequestWorkflowExecutionsRequest,
    ) -> devops_20210625_models.ListChangeRequestWorkflowExecutionsResponse:
        """
        @summary 查询变更研发流程运行记录
        
        @param request: ListChangeRequestWorkflowExecutionsRequest
        @return: ListChangeRequestWorkflowExecutionsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_change_request_workflow_executions_with_options_async(app_name, sn, request, headers, runtime)

    def list_change_requests_with_options(
        self,
        app_name: str,
        tmp_req: devops_20210625_models.ListChangeRequestsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListChangeRequestsResponse:
        """
        @summary 查询变更列表
        
        @param tmp_req: ListChangeRequestsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListChangeRequestsResponse
        """
        UtilClient.validate_model(tmp_req)
        request = devops_20210625_models.ListChangeRequestsShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.app_name_list):
            request.app_name_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.app_name_list, 'appNameList', 'json')
        if not UtilClient.is_unset(tmp_req.owner_id_list):
            request.owner_id_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.owner_id_list, 'ownerIdList', 'json')
        if not UtilClient.is_unset(tmp_req.state_list):
            request.state_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.state_list, 'stateList', 'json')
        query = {}
        if not UtilClient.is_unset(request.app_name_list_shrink):
            query['appNameList'] = request.app_name_list_shrink
        if not UtilClient.is_unset(request.display_name_keyword):
            query['displayNameKeyword'] = request.display_name_keyword
        if not UtilClient.is_unset(request.next_token):
            query['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.order_by):
            query['orderBy'] = request.order_by
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.owner_id_list_shrink):
            query['ownerIdList'] = request.owner_id_list_shrink
        if not UtilClient.is_unset(request.page):
            query['page'] = request.page
        if not UtilClient.is_unset(request.pagination):
            query['pagination'] = request.pagination
        if not UtilClient.is_unset(request.per_page):
            query['perPage'] = request.per_page
        if not UtilClient.is_unset(request.sort):
            query['sort'] = request.sort
        if not UtilClient.is_unset(request.state_list_shrink):
            query['stateList'] = request.state_list_shrink
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListChangeRequests',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/appstack/apps/{OpenApiUtilClient.get_encode_param(app_name)}/changeRequests',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListChangeRequestsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_change_requests_with_options_async(
        self,
        app_name: str,
        tmp_req: devops_20210625_models.ListChangeRequestsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListChangeRequestsResponse:
        """
        @summary 查询变更列表
        
        @param tmp_req: ListChangeRequestsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListChangeRequestsResponse
        """
        UtilClient.validate_model(tmp_req)
        request = devops_20210625_models.ListChangeRequestsShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.app_name_list):
            request.app_name_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.app_name_list, 'appNameList', 'json')
        if not UtilClient.is_unset(tmp_req.owner_id_list):
            request.owner_id_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.owner_id_list, 'ownerIdList', 'json')
        if not UtilClient.is_unset(tmp_req.state_list):
            request.state_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.state_list, 'stateList', 'json')
        query = {}
        if not UtilClient.is_unset(request.app_name_list_shrink):
            query['appNameList'] = request.app_name_list_shrink
        if not UtilClient.is_unset(request.display_name_keyword):
            query['displayNameKeyword'] = request.display_name_keyword
        if not UtilClient.is_unset(request.next_token):
            query['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.order_by):
            query['orderBy'] = request.order_by
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.owner_id_list_shrink):
            query['ownerIdList'] = request.owner_id_list_shrink
        if not UtilClient.is_unset(request.page):
            query['page'] = request.page
        if not UtilClient.is_unset(request.pagination):
            query['pagination'] = request.pagination
        if not UtilClient.is_unset(request.per_page):
            query['perPage'] = request.per_page
        if not UtilClient.is_unset(request.sort):
            query['sort'] = request.sort
        if not UtilClient.is_unset(request.state_list_shrink):
            query['stateList'] = request.state_list_shrink
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListChangeRequests',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/appstack/apps/{OpenApiUtilClient.get_encode_param(app_name)}/changeRequests',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListChangeRequestsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_change_requests(
        self,
        app_name: str,
        request: devops_20210625_models.ListChangeRequestsRequest,
    ) -> devops_20210625_models.ListChangeRequestsResponse:
        """
        @summary 查询变更列表
        
        @param request: ListChangeRequestsRequest
        @return: ListChangeRequestsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_change_requests_with_options(app_name, request, headers, runtime)

    async def list_change_requests_async(
        self,
        app_name: str,
        request: devops_20210625_models.ListChangeRequestsRequest,
    ) -> devops_20210625_models.ListChangeRequestsResponse:
        """
        @summary 查询变更列表
        
        @param request: ListChangeRequestsRequest
        @return: ListChangeRequestsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_change_requests_with_options_async(app_name, request, headers, runtime)

    def list_check_runs_with_options(
        self,
        request: devops_20210625_models.ListCheckRunsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListCheckRunsResponse:
        """
        @summary 查询检查运行列表
        
        @param request: ListCheckRunsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListCheckRunsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.page):
            query['page'] = request.page
        if not UtilClient.is_unset(request.page_size):
            query['pageSize'] = request.page_size
        if not UtilClient.is_unset(request.ref):
            query['ref'] = request.ref
        if not UtilClient.is_unset(request.repository_identity):
            query['repositoryIdentity'] = request.repository_identity
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListCheckRuns',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/check_runs/list_check_runs',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListCheckRunsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_check_runs_with_options_async(
        self,
        request: devops_20210625_models.ListCheckRunsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListCheckRunsResponse:
        """
        @summary 查询检查运行列表
        
        @param request: ListCheckRunsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListCheckRunsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.page):
            query['page'] = request.page
        if not UtilClient.is_unset(request.page_size):
            query['pageSize'] = request.page_size
        if not UtilClient.is_unset(request.ref):
            query['ref'] = request.ref
        if not UtilClient.is_unset(request.repository_identity):
            query['repositoryIdentity'] = request.repository_identity
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListCheckRuns',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/check_runs/list_check_runs',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListCheckRunsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_check_runs(
        self,
        request: devops_20210625_models.ListCheckRunsRequest,
    ) -> devops_20210625_models.ListCheckRunsResponse:
        """
        @summary 查询检查运行列表
        
        @param request: ListCheckRunsRequest
        @return: ListCheckRunsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_check_runs_with_options(request, headers, runtime)

    async def list_check_runs_async(
        self,
        request: devops_20210625_models.ListCheckRunsRequest,
    ) -> devops_20210625_models.ListCheckRunsResponse:
        """
        @summary 查询检查运行列表
        
        @param request: ListCheckRunsRequest
        @return: ListCheckRunsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_check_runs_with_options_async(request, headers, runtime)

    def list_commit_statuses_with_options(
        self,
        request: devops_20210625_models.ListCommitStatusesRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListCommitStatusesResponse:
        """
        @summary 查询提交状态列表
        
        @param request: ListCommitStatusesRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListCommitStatusesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.page):
            query['page'] = request.page
        if not UtilClient.is_unset(request.page_size):
            query['pageSize'] = request.page_size
        if not UtilClient.is_unset(request.repository_identity):
            query['repositoryIdentity'] = request.repository_identity
        if not UtilClient.is_unset(request.sha):
            query['sha'] = request.sha
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListCommitStatuses',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/repository/commit_statuses/list_commit_statuses',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListCommitStatusesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_commit_statuses_with_options_async(
        self,
        request: devops_20210625_models.ListCommitStatusesRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListCommitStatusesResponse:
        """
        @summary 查询提交状态列表
        
        @param request: ListCommitStatusesRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListCommitStatusesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.page):
            query['page'] = request.page
        if not UtilClient.is_unset(request.page_size):
            query['pageSize'] = request.page_size
        if not UtilClient.is_unset(request.repository_identity):
            query['repositoryIdentity'] = request.repository_identity
        if not UtilClient.is_unset(request.sha):
            query['sha'] = request.sha
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListCommitStatuses',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/repository/commit_statuses/list_commit_statuses',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListCommitStatusesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_commit_statuses(
        self,
        request: devops_20210625_models.ListCommitStatusesRequest,
    ) -> devops_20210625_models.ListCommitStatusesResponse:
        """
        @summary 查询提交状态列表
        
        @param request: ListCommitStatusesRequest
        @return: ListCommitStatusesResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_commit_statuses_with_options(request, headers, runtime)

    async def list_commit_statuses_async(
        self,
        request: devops_20210625_models.ListCommitStatusesRequest,
    ) -> devops_20210625_models.ListCommitStatusesResponse:
        """
        @summary 查询提交状态列表
        
        @param request: ListCommitStatusesRequest
        @return: ListCommitStatusesResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_commit_statuses_with_options_async(request, headers, runtime)

    def list_flow_tag_groups_with_options(
        self,
        organization_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListFlowTagGroupsResponse:
        """
        @summary 获取标签分类列表
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListFlowTagGroupsResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='ListFlowTagGroups',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/flow/tagGroups',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListFlowTagGroupsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_flow_tag_groups_with_options_async(
        self,
        organization_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListFlowTagGroupsResponse:
        """
        @summary 获取标签分类列表
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListFlowTagGroupsResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='ListFlowTagGroups',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/flow/tagGroups',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListFlowTagGroupsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_flow_tag_groups(
        self,
        organization_id: str,
    ) -> devops_20210625_models.ListFlowTagGroupsResponse:
        """
        @summary 获取标签分类列表
        
        @return: ListFlowTagGroupsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_flow_tag_groups_with_options(organization_id, headers, runtime)

    async def list_flow_tag_groups_async(
        self,
        organization_id: str,
    ) -> devops_20210625_models.ListFlowTagGroupsResponse:
        """
        @summary 获取标签分类列表
        
        @return: ListFlowTagGroupsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_flow_tag_groups_with_options_async(organization_id, headers, runtime)

    def list_group_member_with_options(
        self,
        group_id: str,
        request: devops_20210625_models.ListGroupMemberRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListGroupMemberResponse:
        """
        @summary 查询组成员列表
        
        @param request: ListGroupMemberRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListGroupMemberResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListGroupMember',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/groups/{OpenApiUtilClient.get_encode_param(group_id)}/list',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListGroupMemberResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_group_member_with_options_async(
        self,
        group_id: str,
        request: devops_20210625_models.ListGroupMemberRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListGroupMemberResponse:
        """
        @summary 查询组成员列表
        
        @param request: ListGroupMemberRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListGroupMemberResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListGroupMember',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/groups/{OpenApiUtilClient.get_encode_param(group_id)}/list',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListGroupMemberResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_group_member(
        self,
        group_id: str,
        request: devops_20210625_models.ListGroupMemberRequest,
    ) -> devops_20210625_models.ListGroupMemberResponse:
        """
        @summary 查询组成员列表
        
        @param request: ListGroupMemberRequest
        @return: ListGroupMemberResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_group_member_with_options(group_id, request, headers, runtime)

    async def list_group_member_async(
        self,
        group_id: str,
        request: devops_20210625_models.ListGroupMemberRequest,
    ) -> devops_20210625_models.ListGroupMemberResponse:
        """
        @summary 查询组成员列表
        
        @param request: ListGroupMemberRequest
        @return: ListGroupMemberResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_group_member_with_options_async(group_id, request, headers, runtime)

    def list_group_repositories_with_options(
        self,
        group_id: str,
        request: devops_20210625_models.ListGroupRepositoriesRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListGroupRepositoriesResponse:
        """
        @summary 查询代码组下的库列表
        
        @param request: ListGroupRepositoriesRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListGroupRepositoriesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.page):
            query['page'] = request.page
        if not UtilClient.is_unset(request.page_size):
            query['pageSize'] = request.page_size
        if not UtilClient.is_unset(request.search):
            query['search'] = request.search
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListGroupRepositories',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/groups/{OpenApiUtilClient.get_encode_param(group_id)}/projects',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListGroupRepositoriesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_group_repositories_with_options_async(
        self,
        group_id: str,
        request: devops_20210625_models.ListGroupRepositoriesRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListGroupRepositoriesResponse:
        """
        @summary 查询代码组下的库列表
        
        @param request: ListGroupRepositoriesRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListGroupRepositoriesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.page):
            query['page'] = request.page
        if not UtilClient.is_unset(request.page_size):
            query['pageSize'] = request.page_size
        if not UtilClient.is_unset(request.search):
            query['search'] = request.search
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListGroupRepositories',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/groups/{OpenApiUtilClient.get_encode_param(group_id)}/projects',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListGroupRepositoriesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_group_repositories(
        self,
        group_id: str,
        request: devops_20210625_models.ListGroupRepositoriesRequest,
    ) -> devops_20210625_models.ListGroupRepositoriesResponse:
        """
        @summary 查询代码组下的库列表
        
        @param request: ListGroupRepositoriesRequest
        @return: ListGroupRepositoriesResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_group_repositories_with_options(group_id, request, headers, runtime)

    async def list_group_repositories_async(
        self,
        group_id: str,
        request: devops_20210625_models.ListGroupRepositoriesRequest,
    ) -> devops_20210625_models.ListGroupRepositoriesResponse:
        """
        @summary 查询代码组下的库列表
        
        @param request: ListGroupRepositoriesRequest
        @return: ListGroupRepositoriesResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_group_repositories_with_options_async(group_id, request, headers, runtime)

    def list_host_groups_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.ListHostGroupsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListHostGroupsResponse:
        """
        @summary 获取主机组列表
        
        @param request: ListHostGroupsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListHostGroupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.create_end_time):
            query['createEndTime'] = request.create_end_time
        if not UtilClient.is_unset(request.create_start_time):
            query['createStartTime'] = request.create_start_time
        if not UtilClient.is_unset(request.creator_account_ids):
            query['creatorAccountIds'] = request.creator_account_ids
        if not UtilClient.is_unset(request.ids):
            query['ids'] = request.ids
        if not UtilClient.is_unset(request.max_results):
            query['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.name):
            query['name'] = request.name
        if not UtilClient.is_unset(request.next_token):
            query['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.page_order):
            query['pageOrder'] = request.page_order
        if not UtilClient.is_unset(request.page_sort):
            query['pageSort'] = request.page_sort
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListHostGroups',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/hostGroups',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListHostGroupsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_host_groups_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ListHostGroupsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListHostGroupsResponse:
        """
        @summary 获取主机组列表
        
        @param request: ListHostGroupsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListHostGroupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.create_end_time):
            query['createEndTime'] = request.create_end_time
        if not UtilClient.is_unset(request.create_start_time):
            query['createStartTime'] = request.create_start_time
        if not UtilClient.is_unset(request.creator_account_ids):
            query['creatorAccountIds'] = request.creator_account_ids
        if not UtilClient.is_unset(request.ids):
            query['ids'] = request.ids
        if not UtilClient.is_unset(request.max_results):
            query['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.name):
            query['name'] = request.name
        if not UtilClient.is_unset(request.next_token):
            query['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.page_order):
            query['pageOrder'] = request.page_order
        if not UtilClient.is_unset(request.page_sort):
            query['pageSort'] = request.page_sort
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListHostGroups',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/hostGroups',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListHostGroupsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_host_groups(
        self,
        organization_id: str,
        request: devops_20210625_models.ListHostGroupsRequest,
    ) -> devops_20210625_models.ListHostGroupsResponse:
        """
        @summary 获取主机组列表
        
        @param request: ListHostGroupsRequest
        @return: ListHostGroupsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_host_groups_with_options(organization_id, request, headers, runtime)

    async def list_host_groups_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ListHostGroupsRequest,
    ) -> devops_20210625_models.ListHostGroupsResponse:
        """
        @summary 获取主机组列表
        
        @param request: ListHostGroupsRequest
        @return: ListHostGroupsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_host_groups_with_options_async(organization_id, request, headers, runtime)

    def list_joined_organizations_with_options(
        self,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListJoinedOrganizationsResponse:
        """
        @summary 当前用户加入的企业列表
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListJoinedOrganizationsResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='ListJoinedOrganizations',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/users/joinedOrgs',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListJoinedOrganizationsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_joined_organizations_with_options_async(
        self,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListJoinedOrganizationsResponse:
        """
        @summary 当前用户加入的企业列表
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListJoinedOrganizationsResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='ListJoinedOrganizations',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/users/joinedOrgs',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListJoinedOrganizationsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_joined_organizations(self) -> devops_20210625_models.ListJoinedOrganizationsResponse:
        """
        @summary 当前用户加入的企业列表
        
        @return: ListJoinedOrganizationsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_joined_organizations_with_options(headers, runtime)

    async def list_joined_organizations_async(self) -> devops_20210625_models.ListJoinedOrganizationsResponse:
        """
        @summary 当前用户加入的企业列表
        
        @return: ListJoinedOrganizationsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_joined_organizations_with_options_async(headers, runtime)

    def list_merge_request_comments_with_options(
        self,
        request: devops_20210625_models.ListMergeRequestCommentsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListMergeRequestCommentsResponse:
        """
        @summary 查询合并请求评论列表
        
        @param request: ListMergeRequestCommentsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListMergeRequestCommentsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.local_id):
            query['localId'] = request.local_id
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.repository_identity):
            query['repositoryIdentity'] = request.repository_identity
        body = {}
        if not UtilClient.is_unset(request.comment_type):
            body['commentType'] = request.comment_type
        if not UtilClient.is_unset(request.file_path):
            body['filePath'] = request.file_path
        if not UtilClient.is_unset(request.patch_set_biz_ids):
            body['patchSetBizIds'] = request.patch_set_biz_ids
        if not UtilClient.is_unset(request.resolved):
            body['resolved'] = request.resolved
        if not UtilClient.is_unset(request.state):
            body['state'] = request.state
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ListMergeRequestComments',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/merge_requests/comments/list_comments',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListMergeRequestCommentsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_merge_request_comments_with_options_async(
        self,
        request: devops_20210625_models.ListMergeRequestCommentsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListMergeRequestCommentsResponse:
        """
        @summary 查询合并请求评论列表
        
        @param request: ListMergeRequestCommentsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListMergeRequestCommentsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.local_id):
            query['localId'] = request.local_id
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.repository_identity):
            query['repositoryIdentity'] = request.repository_identity
        body = {}
        if not UtilClient.is_unset(request.comment_type):
            body['commentType'] = request.comment_type
        if not UtilClient.is_unset(request.file_path):
            body['filePath'] = request.file_path
        if not UtilClient.is_unset(request.patch_set_biz_ids):
            body['patchSetBizIds'] = request.patch_set_biz_ids
        if not UtilClient.is_unset(request.resolved):
            body['resolved'] = request.resolved
        if not UtilClient.is_unset(request.state):
            body['state'] = request.state
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ListMergeRequestComments',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/merge_requests/comments/list_comments',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListMergeRequestCommentsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_merge_request_comments(
        self,
        request: devops_20210625_models.ListMergeRequestCommentsRequest,
    ) -> devops_20210625_models.ListMergeRequestCommentsResponse:
        """
        @summary 查询合并请求评论列表
        
        @param request: ListMergeRequestCommentsRequest
        @return: ListMergeRequestCommentsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_merge_request_comments_with_options(request, headers, runtime)

    async def list_merge_request_comments_async(
        self,
        request: devops_20210625_models.ListMergeRequestCommentsRequest,
    ) -> devops_20210625_models.ListMergeRequestCommentsResponse:
        """
        @summary 查询合并请求评论列表
        
        @param request: ListMergeRequestCommentsRequest
        @return: ListMergeRequestCommentsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_merge_request_comments_with_options_async(request, headers, runtime)

    def list_merge_request_files_reads_with_options(
        self,
        request: devops_20210625_models.ListMergeRequestFilesReadsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListMergeRequestFilesReadsResponse:
        """
        @summary 查询合并请求文件已读列表
        
        @param request: ListMergeRequestFilesReadsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListMergeRequestFilesReadsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.from_patch_set_biz_id):
            query['fromPatchSetBizId'] = request.from_patch_set_biz_id
        if not UtilClient.is_unset(request.local_id):
            query['localId'] = request.local_id
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.repository_identity):
            query['repositoryIdentity'] = request.repository_identity
        if not UtilClient.is_unset(request.to_patch_set_biz_id):
            query['toPatchSetBizId'] = request.to_patch_set_biz_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListMergeRequestFilesReads',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/merge_requests/diffs/files_read_infos',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListMergeRequestFilesReadsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_merge_request_files_reads_with_options_async(
        self,
        request: devops_20210625_models.ListMergeRequestFilesReadsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListMergeRequestFilesReadsResponse:
        """
        @summary 查询合并请求文件已读列表
        
        @param request: ListMergeRequestFilesReadsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListMergeRequestFilesReadsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.from_patch_set_biz_id):
            query['fromPatchSetBizId'] = request.from_patch_set_biz_id
        if not UtilClient.is_unset(request.local_id):
            query['localId'] = request.local_id
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.repository_identity):
            query['repositoryIdentity'] = request.repository_identity
        if not UtilClient.is_unset(request.to_patch_set_biz_id):
            query['toPatchSetBizId'] = request.to_patch_set_biz_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListMergeRequestFilesReads',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/merge_requests/diffs/files_read_infos',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListMergeRequestFilesReadsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_merge_request_files_reads(
        self,
        request: devops_20210625_models.ListMergeRequestFilesReadsRequest,
    ) -> devops_20210625_models.ListMergeRequestFilesReadsResponse:
        """
        @summary 查询合并请求文件已读列表
        
        @param request: ListMergeRequestFilesReadsRequest
        @return: ListMergeRequestFilesReadsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_merge_request_files_reads_with_options(request, headers, runtime)

    async def list_merge_request_files_reads_async(
        self,
        request: devops_20210625_models.ListMergeRequestFilesReadsRequest,
    ) -> devops_20210625_models.ListMergeRequestFilesReadsResponse:
        """
        @summary 查询合并请求文件已读列表
        
        @param request: ListMergeRequestFilesReadsRequest
        @return: ListMergeRequestFilesReadsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_merge_request_files_reads_with_options_async(request, headers, runtime)

    def list_merge_request_labels_with_options(
        self,
        request: devops_20210625_models.ListMergeRequestLabelsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListMergeRequestLabelsResponse:
        """
        @summary 查询合并请求Label列表
        
        @param request: ListMergeRequestLabelsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListMergeRequestLabelsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.local_id):
            query['localId'] = request.local_id
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.repository_identity):
            query['repositoryIdentity'] = request.repository_identity
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListMergeRequestLabels',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/merge_requests/labels',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListMergeRequestLabelsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_merge_request_labels_with_options_async(
        self,
        request: devops_20210625_models.ListMergeRequestLabelsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListMergeRequestLabelsResponse:
        """
        @summary 查询合并请求Label列表
        
        @param request: ListMergeRequestLabelsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListMergeRequestLabelsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.local_id):
            query['localId'] = request.local_id
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.repository_identity):
            query['repositoryIdentity'] = request.repository_identity
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListMergeRequestLabels',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/merge_requests/labels',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListMergeRequestLabelsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_merge_request_labels(
        self,
        request: devops_20210625_models.ListMergeRequestLabelsRequest,
    ) -> devops_20210625_models.ListMergeRequestLabelsResponse:
        """
        @summary 查询合并请求Label列表
        
        @param request: ListMergeRequestLabelsRequest
        @return: ListMergeRequestLabelsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_merge_request_labels_with_options(request, headers, runtime)

    async def list_merge_request_labels_async(
        self,
        request: devops_20210625_models.ListMergeRequestLabelsRequest,
    ) -> devops_20210625_models.ListMergeRequestLabelsResponse:
        """
        @summary 查询合并请求Label列表
        
        @param request: ListMergeRequestLabelsRequest
        @return: ListMergeRequestLabelsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_merge_request_labels_with_options_async(request, headers, runtime)

    def list_merge_request_patch_sets_with_options(
        self,
        request: devops_20210625_models.ListMergeRequestPatchSetsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListMergeRequestPatchSetsResponse:
        """
        @summary 查询合并请求的版本列表
        
        @param request: ListMergeRequestPatchSetsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListMergeRequestPatchSetsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.local_id):
            query['localId'] = request.local_id
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.repository_identity):
            query['repositoryIdentity'] = request.repository_identity
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListMergeRequestPatchSets',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/merge_requests/diffs/list_patchsets',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListMergeRequestPatchSetsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_merge_request_patch_sets_with_options_async(
        self,
        request: devops_20210625_models.ListMergeRequestPatchSetsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListMergeRequestPatchSetsResponse:
        """
        @summary 查询合并请求的版本列表
        
        @param request: ListMergeRequestPatchSetsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListMergeRequestPatchSetsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.local_id):
            query['localId'] = request.local_id
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.repository_identity):
            query['repositoryIdentity'] = request.repository_identity
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListMergeRequestPatchSets',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/merge_requests/diffs/list_patchsets',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListMergeRequestPatchSetsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_merge_request_patch_sets(
        self,
        request: devops_20210625_models.ListMergeRequestPatchSetsRequest,
    ) -> devops_20210625_models.ListMergeRequestPatchSetsResponse:
        """
        @summary 查询合并请求的版本列表
        
        @param request: ListMergeRequestPatchSetsRequest
        @return: ListMergeRequestPatchSetsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_merge_request_patch_sets_with_options(request, headers, runtime)

    async def list_merge_request_patch_sets_async(
        self,
        request: devops_20210625_models.ListMergeRequestPatchSetsRequest,
    ) -> devops_20210625_models.ListMergeRequestPatchSetsResponse:
        """
        @summary 查询合并请求的版本列表
        
        @param request: ListMergeRequestPatchSetsRequest
        @return: ListMergeRequestPatchSetsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_merge_request_patch_sets_with_options_async(request, headers, runtime)

    def list_merge_requests_with_options(
        self,
        request: devops_20210625_models.ListMergeRequestsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListMergeRequestsResponse:
        """
        @summary 查询代码评审列表
        
        @param request: ListMergeRequestsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListMergeRequestsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.author_ids):
            query['authorIds'] = request.author_ids
        if not UtilClient.is_unset(request.created_after):
            query['createdAfter'] = request.created_after
        if not UtilClient.is_unset(request.created_before):
            query['createdBefore'] = request.created_before
        if not UtilClient.is_unset(request.filter):
            query['filter'] = request.filter
        if not UtilClient.is_unset(request.group_ids):
            query['groupIds'] = request.group_ids
        if not UtilClient.is_unset(request.label_ids):
            query['labelIds'] = request.label_ids
        if not UtilClient.is_unset(request.order_by):
            query['orderBy'] = request.order_by
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.page):
            query['page'] = request.page
        if not UtilClient.is_unset(request.page_size):
            query['pageSize'] = request.page_size
        if not UtilClient.is_unset(request.project_ids):
            query['projectIds'] = request.project_ids
        if not UtilClient.is_unset(request.reviewer_ids):
            query['reviewerIds'] = request.reviewer_ids
        if not UtilClient.is_unset(request.search):
            query['search'] = request.search
        if not UtilClient.is_unset(request.sort):
            query['sort'] = request.sort
        if not UtilClient.is_unset(request.state):
            query['state'] = request.state
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListMergeRequests',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/merge_requests/advanced_search',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListMergeRequestsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_merge_requests_with_options_async(
        self,
        request: devops_20210625_models.ListMergeRequestsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListMergeRequestsResponse:
        """
        @summary 查询代码评审列表
        
        @param request: ListMergeRequestsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListMergeRequestsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.author_ids):
            query['authorIds'] = request.author_ids
        if not UtilClient.is_unset(request.created_after):
            query['createdAfter'] = request.created_after
        if not UtilClient.is_unset(request.created_before):
            query['createdBefore'] = request.created_before
        if not UtilClient.is_unset(request.filter):
            query['filter'] = request.filter
        if not UtilClient.is_unset(request.group_ids):
            query['groupIds'] = request.group_ids
        if not UtilClient.is_unset(request.label_ids):
            query['labelIds'] = request.label_ids
        if not UtilClient.is_unset(request.order_by):
            query['orderBy'] = request.order_by
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.page):
            query['page'] = request.page
        if not UtilClient.is_unset(request.page_size):
            query['pageSize'] = request.page_size
        if not UtilClient.is_unset(request.project_ids):
            query['projectIds'] = request.project_ids
        if not UtilClient.is_unset(request.reviewer_ids):
            query['reviewerIds'] = request.reviewer_ids
        if not UtilClient.is_unset(request.search):
            query['search'] = request.search
        if not UtilClient.is_unset(request.sort):
            query['sort'] = request.sort
        if not UtilClient.is_unset(request.state):
            query['state'] = request.state
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListMergeRequests',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/merge_requests/advanced_search',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListMergeRequestsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_merge_requests(
        self,
        request: devops_20210625_models.ListMergeRequestsRequest,
    ) -> devops_20210625_models.ListMergeRequestsResponse:
        """
        @summary 查询代码评审列表
        
        @param request: ListMergeRequestsRequest
        @return: ListMergeRequestsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_merge_requests_with_options(request, headers, runtime)

    async def list_merge_requests_async(
        self,
        request: devops_20210625_models.ListMergeRequestsRequest,
    ) -> devops_20210625_models.ListMergeRequestsResponse:
        """
        @summary 查询代码评审列表
        
        @param request: ListMergeRequestsRequest
        @return: ListMergeRequestsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_merge_requests_with_options_async(request, headers, runtime)

    def list_organization_members_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.ListOrganizationMembersRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListOrganizationMembersResponse:
        """
        @summary 获取企业成员列表
        
        @param request: ListOrganizationMembersRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListOrganizationMembersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.contains_extern_info):
            query['containsExternInfo'] = request.contains_extern_info
        if not UtilClient.is_unset(request.extern_uid):
            query['externUid'] = request.extern_uid
        if not UtilClient.is_unset(request.join_time_from):
            query['joinTimeFrom'] = request.join_time_from
        if not UtilClient.is_unset(request.join_time_to):
            query['joinTimeTo'] = request.join_time_to
        if not UtilClient.is_unset(request.max_results):
            query['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.organization_member_name):
            query['organizationMemberName'] = request.organization_member_name
        if not UtilClient.is_unset(request.provider):
            query['provider'] = request.provider
        if not UtilClient.is_unset(request.state):
            query['state'] = request.state
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListOrganizationMembers',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/members',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListOrganizationMembersResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_organization_members_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ListOrganizationMembersRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListOrganizationMembersResponse:
        """
        @summary 获取企业成员列表
        
        @param request: ListOrganizationMembersRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListOrganizationMembersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.contains_extern_info):
            query['containsExternInfo'] = request.contains_extern_info
        if not UtilClient.is_unset(request.extern_uid):
            query['externUid'] = request.extern_uid
        if not UtilClient.is_unset(request.join_time_from):
            query['joinTimeFrom'] = request.join_time_from
        if not UtilClient.is_unset(request.join_time_to):
            query['joinTimeTo'] = request.join_time_to
        if not UtilClient.is_unset(request.max_results):
            query['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.organization_member_name):
            query['organizationMemberName'] = request.organization_member_name
        if not UtilClient.is_unset(request.provider):
            query['provider'] = request.provider
        if not UtilClient.is_unset(request.state):
            query['state'] = request.state
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListOrganizationMembers',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/members',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListOrganizationMembersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_organization_members(
        self,
        organization_id: str,
        request: devops_20210625_models.ListOrganizationMembersRequest,
    ) -> devops_20210625_models.ListOrganizationMembersResponse:
        """
        @summary 获取企业成员列表
        
        @param request: ListOrganizationMembersRequest
        @return: ListOrganizationMembersResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_organization_members_with_options(organization_id, request, headers, runtime)

    async def list_organization_members_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ListOrganizationMembersRequest,
    ) -> devops_20210625_models.ListOrganizationMembersResponse:
        """
        @summary 获取企业成员列表
        
        @param request: ListOrganizationMembersRequest
        @return: ListOrganizationMembersResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_organization_members_with_options_async(organization_id, request, headers, runtime)

    def list_organizations_with_options(
        self,
        request: devops_20210625_models.ListOrganizationsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListOrganizationsResponse:
        """
        @summary 查询用户企业列表
        
        @param request: ListOrganizationsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListOrganizationsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_level):
            query['accessLevel'] = request.access_level
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.min_access_level):
            query['minAccessLevel'] = request.min_access_level
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListOrganizations',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organizations/list',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListOrganizationsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_organizations_with_options_async(
        self,
        request: devops_20210625_models.ListOrganizationsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListOrganizationsResponse:
        """
        @summary 查询用户企业列表
        
        @param request: ListOrganizationsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListOrganizationsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_level):
            query['accessLevel'] = request.access_level
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.min_access_level):
            query['minAccessLevel'] = request.min_access_level
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListOrganizations',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organizations/list',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListOrganizationsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_organizations(
        self,
        request: devops_20210625_models.ListOrganizationsRequest,
    ) -> devops_20210625_models.ListOrganizationsResponse:
        """
        @summary 查询用户企业列表
        
        @param request: ListOrganizationsRequest
        @return: ListOrganizationsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_organizations_with_options(request, headers, runtime)

    async def list_organizations_async(
        self,
        request: devops_20210625_models.ListOrganizationsRequest,
    ) -> devops_20210625_models.ListOrganizationsResponse:
        """
        @summary 查询用户企业列表
        
        @param request: ListOrganizationsRequest
        @return: ListOrganizationsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_organizations_with_options_async(request, headers, runtime)

    def list_pipeline_group_pipelines_with_options(
        self,
        organization_id: str,
        group_id: str,
        request: devops_20210625_models.ListPipelineGroupPipelinesRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListPipelineGroupPipelinesResponse:
        """
        @summary 获取流水线分组下流水线列表列表
        
        @param request: ListPipelineGroupPipelinesRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListPipelineGroupPipelinesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.create_end_time):
            query['createEndTime'] = request.create_end_time
        if not UtilClient.is_unset(request.create_start_time):
            query['createStartTime'] = request.create_start_time
        if not UtilClient.is_unset(request.execute_end_time):
            query['executeEndTime'] = request.execute_end_time
        if not UtilClient.is_unset(request.execute_start_time):
            query['executeStartTime'] = request.execute_start_time
        if not UtilClient.is_unset(request.max_results):
            query['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.pipeline_name):
            query['pipelineName'] = request.pipeline_name
        if not UtilClient.is_unset(request.result_status_list):
            query['resultStatusList'] = request.result_status_list
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListPipelineGroupPipelines',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelineGroups/{OpenApiUtilClient.get_encode_param(group_id)}/pipelines',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListPipelineGroupPipelinesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_pipeline_group_pipelines_with_options_async(
        self,
        organization_id: str,
        group_id: str,
        request: devops_20210625_models.ListPipelineGroupPipelinesRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListPipelineGroupPipelinesResponse:
        """
        @summary 获取流水线分组下流水线列表列表
        
        @param request: ListPipelineGroupPipelinesRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListPipelineGroupPipelinesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.create_end_time):
            query['createEndTime'] = request.create_end_time
        if not UtilClient.is_unset(request.create_start_time):
            query['createStartTime'] = request.create_start_time
        if not UtilClient.is_unset(request.execute_end_time):
            query['executeEndTime'] = request.execute_end_time
        if not UtilClient.is_unset(request.execute_start_time):
            query['executeStartTime'] = request.execute_start_time
        if not UtilClient.is_unset(request.max_results):
            query['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.pipeline_name):
            query['pipelineName'] = request.pipeline_name
        if not UtilClient.is_unset(request.result_status_list):
            query['resultStatusList'] = request.result_status_list
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListPipelineGroupPipelines',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelineGroups/{OpenApiUtilClient.get_encode_param(group_id)}/pipelines',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListPipelineGroupPipelinesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_pipeline_group_pipelines(
        self,
        organization_id: str,
        group_id: str,
        request: devops_20210625_models.ListPipelineGroupPipelinesRequest,
    ) -> devops_20210625_models.ListPipelineGroupPipelinesResponse:
        """
        @summary 获取流水线分组下流水线列表列表
        
        @param request: ListPipelineGroupPipelinesRequest
        @return: ListPipelineGroupPipelinesResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_pipeline_group_pipelines_with_options(organization_id, group_id, request, headers, runtime)

    async def list_pipeline_group_pipelines_async(
        self,
        organization_id: str,
        group_id: str,
        request: devops_20210625_models.ListPipelineGroupPipelinesRequest,
    ) -> devops_20210625_models.ListPipelineGroupPipelinesResponse:
        """
        @summary 获取流水线分组下流水线列表列表
        
        @param request: ListPipelineGroupPipelinesRequest
        @return: ListPipelineGroupPipelinesResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_pipeline_group_pipelines_with_options_async(organization_id, group_id, request, headers, runtime)

    def list_pipeline_groups_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.ListPipelineGroupsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListPipelineGroupsResponse:
        """
        @summary 获取流水线分组列表
        
        @param request: ListPipelineGroupsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListPipelineGroupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.max_results):
            query['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['nextToken'] = request.next_token
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListPipelineGroups',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelineGroups',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListPipelineGroupsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_pipeline_groups_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ListPipelineGroupsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListPipelineGroupsResponse:
        """
        @summary 获取流水线分组列表
        
        @param request: ListPipelineGroupsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListPipelineGroupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.max_results):
            query['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['nextToken'] = request.next_token
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListPipelineGroups',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelineGroups',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListPipelineGroupsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_pipeline_groups(
        self,
        organization_id: str,
        request: devops_20210625_models.ListPipelineGroupsRequest,
    ) -> devops_20210625_models.ListPipelineGroupsResponse:
        """
        @summary 获取流水线分组列表
        
        @param request: ListPipelineGroupsRequest
        @return: ListPipelineGroupsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_pipeline_groups_with_options(organization_id, request, headers, runtime)

    async def list_pipeline_groups_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ListPipelineGroupsRequest,
    ) -> devops_20210625_models.ListPipelineGroupsResponse:
        """
        @summary 获取流水线分组列表
        
        @param request: ListPipelineGroupsRequest
        @return: ListPipelineGroupsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_pipeline_groups_with_options_async(organization_id, request, headers, runtime)

    def list_pipeline_job_historys_with_options(
        self,
        organization_id: str,
        pipeline_id: str,
        request: devops_20210625_models.ListPipelineJobHistorysRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListPipelineJobHistorysResponse:
        """
        @summary 获取流水线运行过的任务历史
        
        @param request: ListPipelineJobHistorysRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListPipelineJobHistorysResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.category):
            query['category'] = request.category
        if not UtilClient.is_unset(request.identifier):
            query['identifier'] = request.identifier
        if not UtilClient.is_unset(request.max_results):
            query['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['nextToken'] = request.next_token
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListPipelineJobHistorys',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipeline/{OpenApiUtilClient.get_encode_param(pipeline_id)}/job/historys',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListPipelineJobHistorysResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_pipeline_job_historys_with_options_async(
        self,
        organization_id: str,
        pipeline_id: str,
        request: devops_20210625_models.ListPipelineJobHistorysRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListPipelineJobHistorysResponse:
        """
        @summary 获取流水线运行过的任务历史
        
        @param request: ListPipelineJobHistorysRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListPipelineJobHistorysResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.category):
            query['category'] = request.category
        if not UtilClient.is_unset(request.identifier):
            query['identifier'] = request.identifier
        if not UtilClient.is_unset(request.max_results):
            query['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['nextToken'] = request.next_token
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListPipelineJobHistorys',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipeline/{OpenApiUtilClient.get_encode_param(pipeline_id)}/job/historys',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListPipelineJobHistorysResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_pipeline_job_historys(
        self,
        organization_id: str,
        pipeline_id: str,
        request: devops_20210625_models.ListPipelineJobHistorysRequest,
    ) -> devops_20210625_models.ListPipelineJobHistorysResponse:
        """
        @summary 获取流水线运行过的任务历史
        
        @param request: ListPipelineJobHistorysRequest
        @return: ListPipelineJobHistorysResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_pipeline_job_historys_with_options(organization_id, pipeline_id, request, headers, runtime)

    async def list_pipeline_job_historys_async(
        self,
        organization_id: str,
        pipeline_id: str,
        request: devops_20210625_models.ListPipelineJobHistorysRequest,
    ) -> devops_20210625_models.ListPipelineJobHistorysResponse:
        """
        @summary 获取流水线运行过的任务历史
        
        @param request: ListPipelineJobHistorysRequest
        @return: ListPipelineJobHistorysResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_pipeline_job_historys_with_options_async(organization_id, pipeline_id, request, headers, runtime)

    def list_pipeline_jobs_with_options(
        self,
        organization_id: str,
        pipeline_id: str,
        request: devops_20210625_models.ListPipelineJobsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListPipelineJobsResponse:
        """
        @summary 获取流水线运行过的任务
        
        @param request: ListPipelineJobsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListPipelineJobsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.category):
            query['category'] = request.category
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListPipelineJobs',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipeline/{OpenApiUtilClient.get_encode_param(pipeline_id)}/jobs',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListPipelineJobsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_pipeline_jobs_with_options_async(
        self,
        organization_id: str,
        pipeline_id: str,
        request: devops_20210625_models.ListPipelineJobsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListPipelineJobsResponse:
        """
        @summary 获取流水线运行过的任务
        
        @param request: ListPipelineJobsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListPipelineJobsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.category):
            query['category'] = request.category
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListPipelineJobs',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipeline/{OpenApiUtilClient.get_encode_param(pipeline_id)}/jobs',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListPipelineJobsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_pipeline_jobs(
        self,
        organization_id: str,
        pipeline_id: str,
        request: devops_20210625_models.ListPipelineJobsRequest,
    ) -> devops_20210625_models.ListPipelineJobsResponse:
        """
        @summary 获取流水线运行过的任务
        
        @param request: ListPipelineJobsRequest
        @return: ListPipelineJobsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_pipeline_jobs_with_options(organization_id, pipeline_id, request, headers, runtime)

    async def list_pipeline_jobs_async(
        self,
        organization_id: str,
        pipeline_id: str,
        request: devops_20210625_models.ListPipelineJobsRequest,
    ) -> devops_20210625_models.ListPipelineJobsResponse:
        """
        @summary 获取流水线运行过的任务
        
        @param request: ListPipelineJobsRequest
        @return: ListPipelineJobsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_pipeline_jobs_with_options_async(organization_id, pipeline_id, request, headers, runtime)

    def list_pipeline_relations_with_options(
        self,
        organization_id: str,
        pipeline_id: str,
        request: devops_20210625_models.ListPipelineRelationsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListPipelineRelationsResponse:
        """
        @summary 获取流水线关联列表
        
        @param request: ListPipelineRelationsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListPipelineRelationsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.rel_object_type):
            query['relObjectType'] = request.rel_object_type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListPipelineRelations',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/{OpenApiUtilClient.get_encode_param(pipeline_id)}/pipelineRelations',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListPipelineRelationsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_pipeline_relations_with_options_async(
        self,
        organization_id: str,
        pipeline_id: str,
        request: devops_20210625_models.ListPipelineRelationsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListPipelineRelationsResponse:
        """
        @summary 获取流水线关联列表
        
        @param request: ListPipelineRelationsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListPipelineRelationsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.rel_object_type):
            query['relObjectType'] = request.rel_object_type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListPipelineRelations',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/{OpenApiUtilClient.get_encode_param(pipeline_id)}/pipelineRelations',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListPipelineRelationsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_pipeline_relations(
        self,
        organization_id: str,
        pipeline_id: str,
        request: devops_20210625_models.ListPipelineRelationsRequest,
    ) -> devops_20210625_models.ListPipelineRelationsResponse:
        """
        @summary 获取流水线关联列表
        
        @param request: ListPipelineRelationsRequest
        @return: ListPipelineRelationsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_pipeline_relations_with_options(organization_id, pipeline_id, request, headers, runtime)

    async def list_pipeline_relations_async(
        self,
        organization_id: str,
        pipeline_id: str,
        request: devops_20210625_models.ListPipelineRelationsRequest,
    ) -> devops_20210625_models.ListPipelineRelationsResponse:
        """
        @summary 获取流水线关联列表
        
        @param request: ListPipelineRelationsRequest
        @return: ListPipelineRelationsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_pipeline_relations_with_options_async(organization_id, pipeline_id, request, headers, runtime)

    def list_pipeline_runs_with_options(
        self,
        organization_id: str,
        pipeline_id: str,
        request: devops_20210625_models.ListPipelineRunsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListPipelineRunsResponse:
        """
        @summary 获取流水线运行历史
        
        @param request: ListPipelineRunsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListPipelineRunsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['endTime'] = request.end_time
        if not UtilClient.is_unset(request.max_results):
            query['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.start_time):
            query['startTime'] = request.start_time
        if not UtilClient.is_unset(request.status):
            query['status'] = request.status
        if not UtilClient.is_unset(request.trigger_mode):
            query['triggerMode'] = request.trigger_mode
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListPipelineRuns',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines/{OpenApiUtilClient.get_encode_param(pipeline_id)}/pipelineRuns',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListPipelineRunsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_pipeline_runs_with_options_async(
        self,
        organization_id: str,
        pipeline_id: str,
        request: devops_20210625_models.ListPipelineRunsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListPipelineRunsResponse:
        """
        @summary 获取流水线运行历史
        
        @param request: ListPipelineRunsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListPipelineRunsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['endTime'] = request.end_time
        if not UtilClient.is_unset(request.max_results):
            query['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.start_time):
            query['startTime'] = request.start_time
        if not UtilClient.is_unset(request.status):
            query['status'] = request.status
        if not UtilClient.is_unset(request.trigger_mode):
            query['triggerMode'] = request.trigger_mode
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListPipelineRuns',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines/{OpenApiUtilClient.get_encode_param(pipeline_id)}/pipelineRuns',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListPipelineRunsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_pipeline_runs(
        self,
        organization_id: str,
        pipeline_id: str,
        request: devops_20210625_models.ListPipelineRunsRequest,
    ) -> devops_20210625_models.ListPipelineRunsResponse:
        """
        @summary 获取流水线运行历史
        
        @param request: ListPipelineRunsRequest
        @return: ListPipelineRunsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_pipeline_runs_with_options(organization_id, pipeline_id, request, headers, runtime)

    async def list_pipeline_runs_async(
        self,
        organization_id: str,
        pipeline_id: str,
        request: devops_20210625_models.ListPipelineRunsRequest,
    ) -> devops_20210625_models.ListPipelineRunsResponse:
        """
        @summary 获取流水线运行历史
        
        @param request: ListPipelineRunsRequest
        @return: ListPipelineRunsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_pipeline_runs_with_options_async(organization_id, pipeline_id, request, headers, runtime)

    def list_pipelines_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.ListPipelinesRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListPipelinesResponse:
        """
        @summary 获取流水线列表
        
        @param request: ListPipelinesRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListPipelinesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.create_end_time):
            query['createEndTime'] = request.create_end_time
        if not UtilClient.is_unset(request.create_start_time):
            query['createStartTime'] = request.create_start_time
        if not UtilClient.is_unset(request.creator_account_ids):
            query['creatorAccountIds'] = request.creator_account_ids
        if not UtilClient.is_unset(request.execute_account_ids):
            query['executeAccountIds'] = request.execute_account_ids
        if not UtilClient.is_unset(request.execute_end_time):
            query['executeEndTime'] = request.execute_end_time
        if not UtilClient.is_unset(request.execute_start_time):
            query['executeStartTime'] = request.execute_start_time
        if not UtilClient.is_unset(request.max_results):
            query['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.pipeline_name):
            query['pipelineName'] = request.pipeline_name
        if not UtilClient.is_unset(request.status_list):
            query['statusList'] = request.status_list
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListPipelines',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListPipelinesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_pipelines_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ListPipelinesRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListPipelinesResponse:
        """
        @summary 获取流水线列表
        
        @param request: ListPipelinesRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListPipelinesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.create_end_time):
            query['createEndTime'] = request.create_end_time
        if not UtilClient.is_unset(request.create_start_time):
            query['createStartTime'] = request.create_start_time
        if not UtilClient.is_unset(request.creator_account_ids):
            query['creatorAccountIds'] = request.creator_account_ids
        if not UtilClient.is_unset(request.execute_account_ids):
            query['executeAccountIds'] = request.execute_account_ids
        if not UtilClient.is_unset(request.execute_end_time):
            query['executeEndTime'] = request.execute_end_time
        if not UtilClient.is_unset(request.execute_start_time):
            query['executeStartTime'] = request.execute_start_time
        if not UtilClient.is_unset(request.max_results):
            query['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.pipeline_name):
            query['pipelineName'] = request.pipeline_name
        if not UtilClient.is_unset(request.status_list):
            query['statusList'] = request.status_list
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListPipelines',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListPipelinesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_pipelines(
        self,
        organization_id: str,
        request: devops_20210625_models.ListPipelinesRequest,
    ) -> devops_20210625_models.ListPipelinesResponse:
        """
        @summary 获取流水线列表
        
        @param request: ListPipelinesRequest
        @return: ListPipelinesResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_pipelines_with_options(organization_id, request, headers, runtime)

    async def list_pipelines_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ListPipelinesRequest,
    ) -> devops_20210625_models.ListPipelinesResponse:
        """
        @summary 获取流水线列表
        
        @param request: ListPipelinesRequest
        @return: ListPipelinesResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_pipelines_with_options_async(organization_id, request, headers, runtime)

    def list_project_labels_with_options(
        self,
        request: devops_20210625_models.ListProjectLabelsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListProjectLabelsResponse:
        """
        @summary 查询代码库Label列表
        
        @param request: ListProjectLabelsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListProjectLabelsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.order_by):
            query['orderBy'] = request.order_by
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.page):
            query['page'] = request.page
        if not UtilClient.is_unset(request.page_size):
            query['pageSize'] = request.page_size
        if not UtilClient.is_unset(request.repository_identity):
            query['repositoryIdentity'] = request.repository_identity
        if not UtilClient.is_unset(request.search):
            query['search'] = request.search
        if not UtilClient.is_unset(request.sort):
            query['sort'] = request.sort
        if not UtilClient.is_unset(request.with_counts):
            query['withCounts'] = request.with_counts
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListProjectLabels',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/labels',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListProjectLabelsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_project_labels_with_options_async(
        self,
        request: devops_20210625_models.ListProjectLabelsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListProjectLabelsResponse:
        """
        @summary 查询代码库Label列表
        
        @param request: ListProjectLabelsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListProjectLabelsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.order_by):
            query['orderBy'] = request.order_by
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.page):
            query['page'] = request.page
        if not UtilClient.is_unset(request.page_size):
            query['pageSize'] = request.page_size
        if not UtilClient.is_unset(request.repository_identity):
            query['repositoryIdentity'] = request.repository_identity
        if not UtilClient.is_unset(request.search):
            query['search'] = request.search
        if not UtilClient.is_unset(request.sort):
            query['sort'] = request.sort
        if not UtilClient.is_unset(request.with_counts):
            query['withCounts'] = request.with_counts
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListProjectLabels',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/labels',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListProjectLabelsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_project_labels(
        self,
        request: devops_20210625_models.ListProjectLabelsRequest,
    ) -> devops_20210625_models.ListProjectLabelsResponse:
        """
        @summary 查询代码库Label列表
        
        @param request: ListProjectLabelsRequest
        @return: ListProjectLabelsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_project_labels_with_options(request, headers, runtime)

    async def list_project_labels_async(
        self,
        request: devops_20210625_models.ListProjectLabelsRequest,
    ) -> devops_20210625_models.ListProjectLabelsResponse:
        """
        @summary 查询代码库Label列表
        
        @param request: ListProjectLabelsRequest
        @return: ListProjectLabelsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_project_labels_with_options_async(request, headers, runtime)

    def list_project_members_with_options(
        self,
        organization_id: str,
        project_id: str,
        request: devops_20210625_models.ListProjectMembersRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListProjectMembersResponse:
        """
        @summary 根据项目id获取项目所以成员
        
        @param request: ListProjectMembersRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListProjectMembersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.target_type):
            query['targetType'] = request.target_type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListProjectMembers',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/projects/{OpenApiUtilClient.get_encode_param(project_id)}/listMembers',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListProjectMembersResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_project_members_with_options_async(
        self,
        organization_id: str,
        project_id: str,
        request: devops_20210625_models.ListProjectMembersRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListProjectMembersResponse:
        """
        @summary 根据项目id获取项目所以成员
        
        @param request: ListProjectMembersRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListProjectMembersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.target_type):
            query['targetType'] = request.target_type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListProjectMembers',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/projects/{OpenApiUtilClient.get_encode_param(project_id)}/listMembers',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListProjectMembersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_project_members(
        self,
        organization_id: str,
        project_id: str,
        request: devops_20210625_models.ListProjectMembersRequest,
    ) -> devops_20210625_models.ListProjectMembersResponse:
        """
        @summary 根据项目id获取项目所以成员
        
        @param request: ListProjectMembersRequest
        @return: ListProjectMembersResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_project_members_with_options(organization_id, project_id, request, headers, runtime)

    async def list_project_members_async(
        self,
        organization_id: str,
        project_id: str,
        request: devops_20210625_models.ListProjectMembersRequest,
    ) -> devops_20210625_models.ListProjectMembersResponse:
        """
        @summary 根据项目id获取项目所以成员
        
        @param request: ListProjectMembersRequest
        @return: ListProjectMembersResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_project_members_with_options_async(organization_id, project_id, request, headers, runtime)

    def list_project_templates_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.ListProjectTemplatesRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListProjectTemplatesResponse:
        """
        @summary 获取项目模板列表
        
        @param request: ListProjectTemplatesRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListProjectTemplatesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.category):
            query['category'] = request.category
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListProjectTemplates',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/projects/listTemplates',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListProjectTemplatesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_project_templates_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ListProjectTemplatesRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListProjectTemplatesResponse:
        """
        @summary 获取项目模板列表
        
        @param request: ListProjectTemplatesRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListProjectTemplatesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.category):
            query['category'] = request.category
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListProjectTemplates',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/projects/listTemplates',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListProjectTemplatesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_project_templates(
        self,
        organization_id: str,
        request: devops_20210625_models.ListProjectTemplatesRequest,
    ) -> devops_20210625_models.ListProjectTemplatesResponse:
        """
        @summary 获取项目模板列表
        
        @param request: ListProjectTemplatesRequest
        @return: ListProjectTemplatesResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_project_templates_with_options(organization_id, request, headers, runtime)

    async def list_project_templates_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ListProjectTemplatesRequest,
    ) -> devops_20210625_models.ListProjectTemplatesResponse:
        """
        @summary 获取项目模板列表
        
        @param request: ListProjectTemplatesRequest
        @return: ListProjectTemplatesResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_project_templates_with_options_async(organization_id, request, headers, runtime)

    def list_project_workitem_types_with_options(
        self,
        organization_id: str,
        project_id: str,
        request: devops_20210625_models.ListProjectWorkitemTypesRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListProjectWorkitemTypesResponse:
        """
        @summary 获取项目下开启的工作项类型
        
        @param request: ListProjectWorkitemTypesRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListProjectWorkitemTypesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.category):
            query['category'] = request.category
        if not UtilClient.is_unset(request.space_type):
            query['spaceType'] = request.space_type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListProjectWorkitemTypes',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/projects/{OpenApiUtilClient.get_encode_param(project_id)}/getWorkitemType',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListProjectWorkitemTypesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_project_workitem_types_with_options_async(
        self,
        organization_id: str,
        project_id: str,
        request: devops_20210625_models.ListProjectWorkitemTypesRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListProjectWorkitemTypesResponse:
        """
        @summary 获取项目下开启的工作项类型
        
        @param request: ListProjectWorkitemTypesRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListProjectWorkitemTypesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.category):
            query['category'] = request.category
        if not UtilClient.is_unset(request.space_type):
            query['spaceType'] = request.space_type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListProjectWorkitemTypes',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/projects/{OpenApiUtilClient.get_encode_param(project_id)}/getWorkitemType',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListProjectWorkitemTypesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_project_workitem_types(
        self,
        organization_id: str,
        project_id: str,
        request: devops_20210625_models.ListProjectWorkitemTypesRequest,
    ) -> devops_20210625_models.ListProjectWorkitemTypesResponse:
        """
        @summary 获取项目下开启的工作项类型
        
        @param request: ListProjectWorkitemTypesRequest
        @return: ListProjectWorkitemTypesResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_project_workitem_types_with_options(organization_id, project_id, request, headers, runtime)

    async def list_project_workitem_types_async(
        self,
        organization_id: str,
        project_id: str,
        request: devops_20210625_models.ListProjectWorkitemTypesRequest,
    ) -> devops_20210625_models.ListProjectWorkitemTypesResponse:
        """
        @summary 获取项目下开启的工作项类型
        
        @param request: ListProjectWorkitemTypesRequest
        @return: ListProjectWorkitemTypesResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_project_workitem_types_with_options_async(organization_id, project_id, request, headers, runtime)

    def list_projects_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.ListProjectsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListProjectsResponse:
        """
        @summary 获取项目列表
        
        @param request: ListProjectsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListProjectsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.category):
            query['category'] = request.category
        if not UtilClient.is_unset(request.conditions):
            query['conditions'] = request.conditions
        if not UtilClient.is_unset(request.extra_conditions):
            query['extraConditions'] = request.extra_conditions
        if not UtilClient.is_unset(request.max_results):
            query['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.scope):
            query['scope'] = request.scope
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListProjects',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/listProjects',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListProjectsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_projects_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ListProjectsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListProjectsResponse:
        """
        @summary 获取项目列表
        
        @param request: ListProjectsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListProjectsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.category):
            query['category'] = request.category
        if not UtilClient.is_unset(request.conditions):
            query['conditions'] = request.conditions
        if not UtilClient.is_unset(request.extra_conditions):
            query['extraConditions'] = request.extra_conditions
        if not UtilClient.is_unset(request.max_results):
            query['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.scope):
            query['scope'] = request.scope
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListProjects',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/listProjects',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListProjectsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_projects(
        self,
        organization_id: str,
        request: devops_20210625_models.ListProjectsRequest,
    ) -> devops_20210625_models.ListProjectsResponse:
        """
        @summary 获取项目列表
        
        @param request: ListProjectsRequest
        @return: ListProjectsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_projects_with_options(organization_id, request, headers, runtime)

    async def list_projects_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ListProjectsRequest,
    ) -> devops_20210625_models.ListProjectsResponse:
        """
        @summary 获取项目列表
        
        @param request: ListProjectsRequest
        @return: ListProjectsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_projects_with_options_async(organization_id, request, headers, runtime)

    def list_protected_branches_with_options(
        self,
        repository_id: str,
        request: devops_20210625_models.ListProtectedBranchesRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListProtectedBranchesResponse:
        """
        @summary 查询保护分支列表
        
        @param request: ListProtectedBranchesRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListProtectedBranchesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListProtectedBranches',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/protect_branches',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListProtectedBranchesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_protected_branches_with_options_async(
        self,
        repository_id: str,
        request: devops_20210625_models.ListProtectedBranchesRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListProtectedBranchesResponse:
        """
        @summary 查询保护分支列表
        
        @param request: ListProtectedBranchesRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListProtectedBranchesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListProtectedBranches',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/protect_branches',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListProtectedBranchesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_protected_branches(
        self,
        repository_id: str,
        request: devops_20210625_models.ListProtectedBranchesRequest,
    ) -> devops_20210625_models.ListProtectedBranchesResponse:
        """
        @summary 查询保护分支列表
        
        @param request: ListProtectedBranchesRequest
        @return: ListProtectedBranchesResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_protected_branches_with_options(repository_id, request, headers, runtime)

    async def list_protected_branches_async(
        self,
        repository_id: str,
        request: devops_20210625_models.ListProtectedBranchesRequest,
    ) -> devops_20210625_models.ListProtectedBranchesResponse:
        """
        @summary 查询保护分支列表
        
        @param request: ListProtectedBranchesRequest
        @return: ListProtectedBranchesResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_protected_branches_with_options_async(repository_id, request, headers, runtime)

    def list_push_rules_with_options(
        self,
        repository_id: str,
        request: devops_20210625_models.ListPushRulesRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListPushRulesResponse:
        """
        @summary 查询推送规则列表
        
        @param request: ListPushRulesRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListPushRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListPushRules',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/{OpenApiUtilClient.get_encode_param(repository_id)}/push_rule/push_rules/list',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListPushRulesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_push_rules_with_options_async(
        self,
        repository_id: str,
        request: devops_20210625_models.ListPushRulesRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListPushRulesResponse:
        """
        @summary 查询推送规则列表
        
        @param request: ListPushRulesRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListPushRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListPushRules',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/{OpenApiUtilClient.get_encode_param(repository_id)}/push_rule/push_rules/list',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListPushRulesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_push_rules(
        self,
        repository_id: str,
        request: devops_20210625_models.ListPushRulesRequest,
    ) -> devops_20210625_models.ListPushRulesResponse:
        """
        @summary 查询推送规则列表
        
        @param request: ListPushRulesRequest
        @return: ListPushRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_push_rules_with_options(repository_id, request, headers, runtime)

    async def list_push_rules_async(
        self,
        repository_id: str,
        request: devops_20210625_models.ListPushRulesRequest,
    ) -> devops_20210625_models.ListPushRulesResponse:
        """
        @summary 查询推送规则列表
        
        @param request: ListPushRulesRequest
        @return: ListPushRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_push_rules_with_options_async(repository_id, request, headers, runtime)

    def list_repositories_with_options(
        self,
        request: devops_20210625_models.ListRepositoriesRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListRepositoriesResponse:
        """
        @summary 查询代码库列表
        
        @param request: ListRepositoriesRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListRepositoriesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.archived):
            query['archived'] = request.archived
        if not UtilClient.is_unset(request.min_access_level):
            query['minAccessLevel'] = request.min_access_level
        if not UtilClient.is_unset(request.order_by):
            query['orderBy'] = request.order_by
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.page):
            query['page'] = request.page
        if not UtilClient.is_unset(request.per_page):
            query['perPage'] = request.per_page
        if not UtilClient.is_unset(request.search):
            query['search'] = request.search
        if not UtilClient.is_unset(request.sort):
            query['sort'] = request.sort
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListRepositories',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/list',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListRepositoriesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_repositories_with_options_async(
        self,
        request: devops_20210625_models.ListRepositoriesRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListRepositoriesResponse:
        """
        @summary 查询代码库列表
        
        @param request: ListRepositoriesRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListRepositoriesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.archived):
            query['archived'] = request.archived
        if not UtilClient.is_unset(request.min_access_level):
            query['minAccessLevel'] = request.min_access_level
        if not UtilClient.is_unset(request.order_by):
            query['orderBy'] = request.order_by
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.page):
            query['page'] = request.page
        if not UtilClient.is_unset(request.per_page):
            query['perPage'] = request.per_page
        if not UtilClient.is_unset(request.search):
            query['search'] = request.search
        if not UtilClient.is_unset(request.sort):
            query['sort'] = request.sort
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListRepositories',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/list',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListRepositoriesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_repositories(
        self,
        request: devops_20210625_models.ListRepositoriesRequest,
    ) -> devops_20210625_models.ListRepositoriesResponse:
        """
        @summary 查询代码库列表
        
        @param request: ListRepositoriesRequest
        @return: ListRepositoriesResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_repositories_with_options(request, headers, runtime)

    async def list_repositories_async(
        self,
        request: devops_20210625_models.ListRepositoriesRequest,
    ) -> devops_20210625_models.ListRepositoriesResponse:
        """
        @summary 查询代码库列表
        
        @param request: ListRepositoriesRequest
        @return: ListRepositoriesResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_repositories_with_options_async(request, headers, runtime)

    def list_repository_branches_with_options(
        self,
        repository_id: str,
        request: devops_20210625_models.ListRepositoryBranchesRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListRepositoryBranchesResponse:
        """
        @summary 查询分支列表
        
        @param request: ListRepositoryBranchesRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListRepositoryBranchesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.page):
            query['page'] = request.page
        if not UtilClient.is_unset(request.page_size):
            query['pageSize'] = request.page_size
        if not UtilClient.is_unset(request.search):
            query['search'] = request.search
        if not UtilClient.is_unset(request.sort):
            query['sort'] = request.sort
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListRepositoryBranches',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/branches',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListRepositoryBranchesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_repository_branches_with_options_async(
        self,
        repository_id: str,
        request: devops_20210625_models.ListRepositoryBranchesRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListRepositoryBranchesResponse:
        """
        @summary 查询分支列表
        
        @param request: ListRepositoryBranchesRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListRepositoryBranchesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.page):
            query['page'] = request.page
        if not UtilClient.is_unset(request.page_size):
            query['pageSize'] = request.page_size
        if not UtilClient.is_unset(request.search):
            query['search'] = request.search
        if not UtilClient.is_unset(request.sort):
            query['sort'] = request.sort
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListRepositoryBranches',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/branches',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListRepositoryBranchesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_repository_branches(
        self,
        repository_id: str,
        request: devops_20210625_models.ListRepositoryBranchesRequest,
    ) -> devops_20210625_models.ListRepositoryBranchesResponse:
        """
        @summary 查询分支列表
        
        @param request: ListRepositoryBranchesRequest
        @return: ListRepositoryBranchesResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_repository_branches_with_options(repository_id, request, headers, runtime)

    async def list_repository_branches_async(
        self,
        repository_id: str,
        request: devops_20210625_models.ListRepositoryBranchesRequest,
    ) -> devops_20210625_models.ListRepositoryBranchesResponse:
        """
        @summary 查询分支列表
        
        @param request: ListRepositoryBranchesRequest
        @return: ListRepositoryBranchesResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_repository_branches_with_options_async(repository_id, request, headers, runtime)

    def list_repository_commit_diff_with_options(
        self,
        repository_id: str,
        sha: str,
        request: devops_20210625_models.ListRepositoryCommitDiffRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListRepositoryCommitDiffResponse:
        """
        @summary 查询代码库单个提交（Commit）的提交内容
        
        @param request: ListRepositoryCommitDiffRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListRepositoryCommitDiffResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.context_line):
            query['contextLine'] = request.context_line
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListRepositoryCommitDiff',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/commits/{OpenApiUtilClient.get_encode_param(sha)}/diff',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListRepositoryCommitDiffResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_repository_commit_diff_with_options_async(
        self,
        repository_id: str,
        sha: str,
        request: devops_20210625_models.ListRepositoryCommitDiffRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListRepositoryCommitDiffResponse:
        """
        @summary 查询代码库单个提交（Commit）的提交内容
        
        @param request: ListRepositoryCommitDiffRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListRepositoryCommitDiffResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.context_line):
            query['contextLine'] = request.context_line
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListRepositoryCommitDiff',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/commits/{OpenApiUtilClient.get_encode_param(sha)}/diff',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListRepositoryCommitDiffResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_repository_commit_diff(
        self,
        repository_id: str,
        sha: str,
        request: devops_20210625_models.ListRepositoryCommitDiffRequest,
    ) -> devops_20210625_models.ListRepositoryCommitDiffResponse:
        """
        @summary 查询代码库单个提交（Commit）的提交内容
        
        @param request: ListRepositoryCommitDiffRequest
        @return: ListRepositoryCommitDiffResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_repository_commit_diff_with_options(repository_id, sha, request, headers, runtime)

    async def list_repository_commit_diff_async(
        self,
        repository_id: str,
        sha: str,
        request: devops_20210625_models.ListRepositoryCommitDiffRequest,
    ) -> devops_20210625_models.ListRepositoryCommitDiffResponse:
        """
        @summary 查询代码库单个提交（Commit）的提交内容
        
        @param request: ListRepositoryCommitDiffRequest
        @return: ListRepositoryCommitDiffResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_repository_commit_diff_with_options_async(repository_id, sha, request, headers, runtime)

    def list_repository_commits_with_options(
        self,
        repository_id: str,
        request: devops_20210625_models.ListRepositoryCommitsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListRepositoryCommitsResponse:
        """
        @summary 查询代码库提交历史
        
        @param request: ListRepositoryCommitsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListRepositoryCommitsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.end):
            query['end'] = request.end
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.page):
            query['page'] = request.page
        if not UtilClient.is_unset(request.page_size):
            query['pageSize'] = request.page_size
        if not UtilClient.is_unset(request.path):
            query['path'] = request.path
        if not UtilClient.is_unset(request.ref_name):
            query['refName'] = request.ref_name
        if not UtilClient.is_unset(request.search):
            query['search'] = request.search
        if not UtilClient.is_unset(request.show_comments_count):
            query['showCommentsCount'] = request.show_comments_count
        if not UtilClient.is_unset(request.show_signature):
            query['showSignature'] = request.show_signature
        if not UtilClient.is_unset(request.start):
            query['start'] = request.start
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListRepositoryCommits',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/commits',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListRepositoryCommitsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_repository_commits_with_options_async(
        self,
        repository_id: str,
        request: devops_20210625_models.ListRepositoryCommitsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListRepositoryCommitsResponse:
        """
        @summary 查询代码库提交历史
        
        @param request: ListRepositoryCommitsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListRepositoryCommitsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.end):
            query['end'] = request.end
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.page):
            query['page'] = request.page
        if not UtilClient.is_unset(request.page_size):
            query['pageSize'] = request.page_size
        if not UtilClient.is_unset(request.path):
            query['path'] = request.path
        if not UtilClient.is_unset(request.ref_name):
            query['refName'] = request.ref_name
        if not UtilClient.is_unset(request.search):
            query['search'] = request.search
        if not UtilClient.is_unset(request.show_comments_count):
            query['showCommentsCount'] = request.show_comments_count
        if not UtilClient.is_unset(request.show_signature):
            query['showSignature'] = request.show_signature
        if not UtilClient.is_unset(request.start):
            query['start'] = request.start
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListRepositoryCommits',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/commits',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListRepositoryCommitsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_repository_commits(
        self,
        repository_id: str,
        request: devops_20210625_models.ListRepositoryCommitsRequest,
    ) -> devops_20210625_models.ListRepositoryCommitsResponse:
        """
        @summary 查询代码库提交历史
        
        @param request: ListRepositoryCommitsRequest
        @return: ListRepositoryCommitsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_repository_commits_with_options(repository_id, request, headers, runtime)

    async def list_repository_commits_async(
        self,
        repository_id: str,
        request: devops_20210625_models.ListRepositoryCommitsRequest,
    ) -> devops_20210625_models.ListRepositoryCommitsResponse:
        """
        @summary 查询代码库提交历史
        
        @param request: ListRepositoryCommitsRequest
        @return: ListRepositoryCommitsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_repository_commits_with_options_async(repository_id, request, headers, runtime)

    def list_repository_groups_with_options(
        self,
        request: devops_20210625_models.ListRepositoryGroupsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListRepositoryGroupsResponse:
        """
        @summary 查询代码组列表
        
        @param request: ListRepositoryGroupsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListRepositoryGroupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.include_personal):
            query['includePersonal'] = request.include_personal
        if not UtilClient.is_unset(request.order_by):
            query['orderBy'] = request.order_by
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.page):
            query['page'] = request.page
        if not UtilClient.is_unset(request.page_size):
            query['pageSize'] = request.page_size
        if not UtilClient.is_unset(request.parent_id):
            query['parentId'] = request.parent_id
        if not UtilClient.is_unset(request.search):
            query['search'] = request.search
        if not UtilClient.is_unset(request.sort):
            query['sort'] = request.sort
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListRepositoryGroups',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/groups/get/all',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListRepositoryGroupsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_repository_groups_with_options_async(
        self,
        request: devops_20210625_models.ListRepositoryGroupsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListRepositoryGroupsResponse:
        """
        @summary 查询代码组列表
        
        @param request: ListRepositoryGroupsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListRepositoryGroupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.include_personal):
            query['includePersonal'] = request.include_personal
        if not UtilClient.is_unset(request.order_by):
            query['orderBy'] = request.order_by
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.page):
            query['page'] = request.page
        if not UtilClient.is_unset(request.page_size):
            query['pageSize'] = request.page_size
        if not UtilClient.is_unset(request.parent_id):
            query['parentId'] = request.parent_id
        if not UtilClient.is_unset(request.search):
            query['search'] = request.search
        if not UtilClient.is_unset(request.sort):
            query['sort'] = request.sort
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListRepositoryGroups',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/groups/get/all',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListRepositoryGroupsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_repository_groups(
        self,
        request: devops_20210625_models.ListRepositoryGroupsRequest,
    ) -> devops_20210625_models.ListRepositoryGroupsResponse:
        """
        @summary 查询代码组列表
        
        @param request: ListRepositoryGroupsRequest
        @return: ListRepositoryGroupsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_repository_groups_with_options(request, headers, runtime)

    async def list_repository_groups_async(
        self,
        request: devops_20210625_models.ListRepositoryGroupsRequest,
    ) -> devops_20210625_models.ListRepositoryGroupsResponse:
        """
        @summary 查询代码组列表
        
        @param request: ListRepositoryGroupsRequest
        @return: ListRepositoryGroupsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_repository_groups_with_options_async(request, headers, runtime)

    def list_repository_member_with_inherited_with_options(
        self,
        repository_id: str,
        request: devops_20210625_models.ListRepositoryMemberWithInheritedRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListRepositoryMemberWithInheritedResponse:
        """
        @summary 查询代码库成员列表
        
        @param request: ListRepositoryMemberWithInheritedRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListRepositoryMemberWithInheritedResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListRepositoryMemberWithInherited',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/members/list',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListRepositoryMemberWithInheritedResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_repository_member_with_inherited_with_options_async(
        self,
        repository_id: str,
        request: devops_20210625_models.ListRepositoryMemberWithInheritedRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListRepositoryMemberWithInheritedResponse:
        """
        @summary 查询代码库成员列表
        
        @param request: ListRepositoryMemberWithInheritedRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListRepositoryMemberWithInheritedResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListRepositoryMemberWithInherited',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/members/list',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListRepositoryMemberWithInheritedResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_repository_member_with_inherited(
        self,
        repository_id: str,
        request: devops_20210625_models.ListRepositoryMemberWithInheritedRequest,
    ) -> devops_20210625_models.ListRepositoryMemberWithInheritedResponse:
        """
        @summary 查询代码库成员列表
        
        @param request: ListRepositoryMemberWithInheritedRequest
        @return: ListRepositoryMemberWithInheritedResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_repository_member_with_inherited_with_options(repository_id, request, headers, runtime)

    async def list_repository_member_with_inherited_async(
        self,
        repository_id: str,
        request: devops_20210625_models.ListRepositoryMemberWithInheritedRequest,
    ) -> devops_20210625_models.ListRepositoryMemberWithInheritedResponse:
        """
        @summary 查询代码库成员列表
        
        @param request: ListRepositoryMemberWithInheritedRequest
        @return: ListRepositoryMemberWithInheritedResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_repository_member_with_inherited_with_options_async(repository_id, request, headers, runtime)

    def list_repository_tags_with_options(
        self,
        repository_id: str,
        request: devops_20210625_models.ListRepositoryTagsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListRepositoryTagsResponse:
        """
        @summary 查询标签列表
        
        @param request: ListRepositoryTagsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListRepositoryTagsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.page):
            query['page'] = request.page
        if not UtilClient.is_unset(request.page_size):
            query['pageSize'] = request.page_size
        if not UtilClient.is_unset(request.search):
            query['search'] = request.search
        if not UtilClient.is_unset(request.sort):
            query['sort'] = request.sort
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListRepositoryTags',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/tag/list',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListRepositoryTagsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_repository_tags_with_options_async(
        self,
        repository_id: str,
        request: devops_20210625_models.ListRepositoryTagsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListRepositoryTagsResponse:
        """
        @summary 查询标签列表
        
        @param request: ListRepositoryTagsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListRepositoryTagsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.page):
            query['page'] = request.page
        if not UtilClient.is_unset(request.page_size):
            query['pageSize'] = request.page_size
        if not UtilClient.is_unset(request.search):
            query['search'] = request.search
        if not UtilClient.is_unset(request.sort):
            query['sort'] = request.sort
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListRepositoryTags',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/tag/list',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListRepositoryTagsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_repository_tags(
        self,
        repository_id: str,
        request: devops_20210625_models.ListRepositoryTagsRequest,
    ) -> devops_20210625_models.ListRepositoryTagsResponse:
        """
        @summary 查询标签列表
        
        @param request: ListRepositoryTagsRequest
        @return: ListRepositoryTagsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_repository_tags_with_options(repository_id, request, headers, runtime)

    async def list_repository_tags_async(
        self,
        repository_id: str,
        request: devops_20210625_models.ListRepositoryTagsRequest,
    ) -> devops_20210625_models.ListRepositoryTagsResponse:
        """
        @summary 查询标签列表
        
        @param request: ListRepositoryTagsRequest
        @return: ListRepositoryTagsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_repository_tags_with_options_async(repository_id, request, headers, runtime)

    def list_repository_tree_with_options(
        self,
        repository_id: str,
        request: devops_20210625_models.ListRepositoryTreeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListRepositoryTreeResponse:
        """
        @summary 查询代码库文件树
        
        @param request: ListRepositoryTreeRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListRepositoryTreeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.path):
            query['path'] = request.path
        if not UtilClient.is_unset(request.ref_name):
            query['refName'] = request.ref_name
        if not UtilClient.is_unset(request.type):
            query['type'] = request.type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListRepositoryTree',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/files/tree',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListRepositoryTreeResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_repository_tree_with_options_async(
        self,
        repository_id: str,
        request: devops_20210625_models.ListRepositoryTreeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListRepositoryTreeResponse:
        """
        @summary 查询代码库文件树
        
        @param request: ListRepositoryTreeRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListRepositoryTreeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.path):
            query['path'] = request.path
        if not UtilClient.is_unset(request.ref_name):
            query['refName'] = request.ref_name
        if not UtilClient.is_unset(request.type):
            query['type'] = request.type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListRepositoryTree',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/files/tree',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListRepositoryTreeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_repository_tree(
        self,
        repository_id: str,
        request: devops_20210625_models.ListRepositoryTreeRequest,
    ) -> devops_20210625_models.ListRepositoryTreeResponse:
        """
        @summary 查询代码库文件树
        
        @param request: ListRepositoryTreeRequest
        @return: ListRepositoryTreeResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_repository_tree_with_options(repository_id, request, headers, runtime)

    async def list_repository_tree_async(
        self,
        repository_id: str,
        request: devops_20210625_models.ListRepositoryTreeRequest,
    ) -> devops_20210625_models.ListRepositoryTreeResponse:
        """
        @summary 查询代码库文件树
        
        @param request: ListRepositoryTreeRequest
        @return: ListRepositoryTreeResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_repository_tree_with_options_async(repository_id, request, headers, runtime)

    def list_repository_webhook_with_options(
        self,
        repository_id: str,
        request: devops_20210625_models.ListRepositoryWebhookRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListRepositoryWebhookResponse:
        """
        @summary 查询代码库Webhook列表
        
        @param request: ListRepositoryWebhookRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListRepositoryWebhookResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.page):
            query['page'] = request.page
        if not UtilClient.is_unset(request.page_size):
            query['pageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListRepositoryWebhook',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/webhooks/list',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListRepositoryWebhookResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_repository_webhook_with_options_async(
        self,
        repository_id: str,
        request: devops_20210625_models.ListRepositoryWebhookRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListRepositoryWebhookResponse:
        """
        @summary 查询代码库Webhook列表
        
        @param request: ListRepositoryWebhookRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListRepositoryWebhookResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.page):
            query['page'] = request.page
        if not UtilClient.is_unset(request.page_size):
            query['pageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListRepositoryWebhook',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/webhooks/list',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListRepositoryWebhookResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_repository_webhook(
        self,
        repository_id: str,
        request: devops_20210625_models.ListRepositoryWebhookRequest,
    ) -> devops_20210625_models.ListRepositoryWebhookResponse:
        """
        @summary 查询代码库Webhook列表
        
        @param request: ListRepositoryWebhookRequest
        @return: ListRepositoryWebhookResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_repository_webhook_with_options(repository_id, request, headers, runtime)

    async def list_repository_webhook_async(
        self,
        repository_id: str,
        request: devops_20210625_models.ListRepositoryWebhookRequest,
    ) -> devops_20210625_models.ListRepositoryWebhookResponse:
        """
        @summary 查询代码库Webhook列表
        
        @param request: ListRepositoryWebhookRequest
        @return: ListRepositoryWebhookResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_repository_webhook_with_options_async(repository_id, request, headers, runtime)

    def list_resource_members_with_options(
        self,
        organization_id: str,
        resource_type: str,
        resource_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListResourceMembersResponse:
        """
        @summary 获取资源成员列表
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListResourceMembersResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='ListResourceMembers',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/{OpenApiUtilClient.get_encode_param(resource_type)}/{OpenApiUtilClient.get_encode_param(resource_id)}/members',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListResourceMembersResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_resource_members_with_options_async(
        self,
        organization_id: str,
        resource_type: str,
        resource_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListResourceMembersResponse:
        """
        @summary 获取资源成员列表
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListResourceMembersResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='ListResourceMembers',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/{OpenApiUtilClient.get_encode_param(resource_type)}/{OpenApiUtilClient.get_encode_param(resource_id)}/members',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListResourceMembersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_resource_members(
        self,
        organization_id: str,
        resource_type: str,
        resource_id: str,
    ) -> devops_20210625_models.ListResourceMembersResponse:
        """
        @summary 获取资源成员列表
        
        @return: ListResourceMembersResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_resource_members_with_options(organization_id, resource_type, resource_id, headers, runtime)

    async def list_resource_members_async(
        self,
        organization_id: str,
        resource_type: str,
        resource_id: str,
    ) -> devops_20210625_models.ListResourceMembersResponse:
        """
        @summary 获取资源成员列表
        
        @return: ListResourceMembersResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_resource_members_with_options_async(organization_id, resource_type, resource_id, headers, runtime)

    def list_search_commit_with_options(
        self,
        request: devops_20210625_models.ListSearchCommitRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListSearchCommitResponse:
        """
        @summary 搜索代码提交数据
        
        @param request: ListSearchCommitRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListSearchCommitResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.keyword):
            body['keyword'] = request.keyword
        if not UtilClient.is_unset(request.order):
            body['order'] = request.order
        if not UtilClient.is_unset(request.page):
            body['page'] = request.page
        if not UtilClient.is_unset(request.page_size):
            body['pageSize'] = request.page_size
        if not UtilClient.is_unset(request.repo_path):
            body['repoPath'] = request.repo_path
        if not UtilClient.is_unset(request.scope):
            body['scope'] = request.scope
        if not UtilClient.is_unset(request.sort):
            body['sort'] = request.sort
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ListSearchCommit',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/search/commit',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListSearchCommitResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_search_commit_with_options_async(
        self,
        request: devops_20210625_models.ListSearchCommitRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListSearchCommitResponse:
        """
        @summary 搜索代码提交数据
        
        @param request: ListSearchCommitRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListSearchCommitResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.keyword):
            body['keyword'] = request.keyword
        if not UtilClient.is_unset(request.order):
            body['order'] = request.order
        if not UtilClient.is_unset(request.page):
            body['page'] = request.page
        if not UtilClient.is_unset(request.page_size):
            body['pageSize'] = request.page_size
        if not UtilClient.is_unset(request.repo_path):
            body['repoPath'] = request.repo_path
        if not UtilClient.is_unset(request.scope):
            body['scope'] = request.scope
        if not UtilClient.is_unset(request.sort):
            body['sort'] = request.sort
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ListSearchCommit',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/search/commit',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListSearchCommitResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_search_commit(
        self,
        request: devops_20210625_models.ListSearchCommitRequest,
    ) -> devops_20210625_models.ListSearchCommitResponse:
        """
        @summary 搜索代码提交数据
        
        @param request: ListSearchCommitRequest
        @return: ListSearchCommitResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_search_commit_with_options(request, headers, runtime)

    async def list_search_commit_async(
        self,
        request: devops_20210625_models.ListSearchCommitRequest,
    ) -> devops_20210625_models.ListSearchCommitResponse:
        """
        @summary 搜索代码提交数据
        
        @param request: ListSearchCommitRequest
        @return: ListSearchCommitResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_search_commit_with_options_async(request, headers, runtime)

    def list_search_repository_with_options(
        self,
        request: devops_20210625_models.ListSearchRepositoryRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListSearchRepositoryResponse:
        """
        @summary 搜索代码仓库数据
        
        @param request: ListSearchRepositoryRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListSearchRepositoryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.aliyun_pk):
            body['aliyunPk'] = request.aliyun_pk
        if not UtilClient.is_unset(request.keyword):
            body['keyword'] = request.keyword
        if not UtilClient.is_unset(request.order):
            body['order'] = request.order
        if not UtilClient.is_unset(request.page):
            body['page'] = request.page
        if not UtilClient.is_unset(request.page_size):
            body['pageSize'] = request.page_size
        if not UtilClient.is_unset(request.repo_path):
            body['repoPath'] = request.repo_path
        if not UtilClient.is_unset(request.scope):
            body['scope'] = request.scope
        if not UtilClient.is_unset(request.sort):
            body['sort'] = request.sort
        if not UtilClient.is_unset(request.visibility_level):
            body['visibilityLevel'] = request.visibility_level
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ListSearchRepository',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/search/repo',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListSearchRepositoryResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_search_repository_with_options_async(
        self,
        request: devops_20210625_models.ListSearchRepositoryRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListSearchRepositoryResponse:
        """
        @summary 搜索代码仓库数据
        
        @param request: ListSearchRepositoryRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListSearchRepositoryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.aliyun_pk):
            body['aliyunPk'] = request.aliyun_pk
        if not UtilClient.is_unset(request.keyword):
            body['keyword'] = request.keyword
        if not UtilClient.is_unset(request.order):
            body['order'] = request.order
        if not UtilClient.is_unset(request.page):
            body['page'] = request.page
        if not UtilClient.is_unset(request.page_size):
            body['pageSize'] = request.page_size
        if not UtilClient.is_unset(request.repo_path):
            body['repoPath'] = request.repo_path
        if not UtilClient.is_unset(request.scope):
            body['scope'] = request.scope
        if not UtilClient.is_unset(request.sort):
            body['sort'] = request.sort
        if not UtilClient.is_unset(request.visibility_level):
            body['visibilityLevel'] = request.visibility_level
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ListSearchRepository',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/search/repo',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListSearchRepositoryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_search_repository(
        self,
        request: devops_20210625_models.ListSearchRepositoryRequest,
    ) -> devops_20210625_models.ListSearchRepositoryResponse:
        """
        @summary 搜索代码仓库数据
        
        @param request: ListSearchRepositoryRequest
        @return: ListSearchRepositoryResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_search_repository_with_options(request, headers, runtime)

    async def list_search_repository_async(
        self,
        request: devops_20210625_models.ListSearchRepositoryRequest,
    ) -> devops_20210625_models.ListSearchRepositoryResponse:
        """
        @summary 搜索代码仓库数据
        
        @param request: ListSearchRepositoryRequest
        @return: ListSearchRepositoryResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_search_repository_with_options_async(request, headers, runtime)

    def list_search_source_code_with_options(
        self,
        request: devops_20210625_models.ListSearchSourceCodeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListSearchSourceCodeResponse:
        """
        @summary 搜索代码片段
        
        @param request: ListSearchSourceCodeRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListSearchSourceCodeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.file_path):
            body['filePath'] = request.file_path
        if not UtilClient.is_unset(request.is_code_block):
            body['isCodeBlock'] = request.is_code_block
        if not UtilClient.is_unset(request.keyword):
            body['keyword'] = request.keyword
        if not UtilClient.is_unset(request.language):
            body['language'] = request.language
        if not UtilClient.is_unset(request.order):
            body['order'] = request.order
        if not UtilClient.is_unset(request.page):
            body['page'] = request.page
        if not UtilClient.is_unset(request.page_size):
            body['pageSize'] = request.page_size
        if not UtilClient.is_unset(request.repo_path):
            body['repoPath'] = request.repo_path
        if not UtilClient.is_unset(request.scope):
            body['scope'] = request.scope
        if not UtilClient.is_unset(request.sort):
            body['sort'] = request.sort
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ListSearchSourceCode',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/search/code',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListSearchSourceCodeResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_search_source_code_with_options_async(
        self,
        request: devops_20210625_models.ListSearchSourceCodeRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListSearchSourceCodeResponse:
        """
        @summary 搜索代码片段
        
        @param request: ListSearchSourceCodeRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListSearchSourceCodeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.file_path):
            body['filePath'] = request.file_path
        if not UtilClient.is_unset(request.is_code_block):
            body['isCodeBlock'] = request.is_code_block
        if not UtilClient.is_unset(request.keyword):
            body['keyword'] = request.keyword
        if not UtilClient.is_unset(request.language):
            body['language'] = request.language
        if not UtilClient.is_unset(request.order):
            body['order'] = request.order
        if not UtilClient.is_unset(request.page):
            body['page'] = request.page
        if not UtilClient.is_unset(request.page_size):
            body['pageSize'] = request.page_size
        if not UtilClient.is_unset(request.repo_path):
            body['repoPath'] = request.repo_path
        if not UtilClient.is_unset(request.scope):
            body['scope'] = request.scope
        if not UtilClient.is_unset(request.sort):
            body['sort'] = request.sort
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ListSearchSourceCode',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/search/code',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListSearchSourceCodeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_search_source_code(
        self,
        request: devops_20210625_models.ListSearchSourceCodeRequest,
    ) -> devops_20210625_models.ListSearchSourceCodeResponse:
        """
        @summary 搜索代码片段
        
        @param request: ListSearchSourceCodeRequest
        @return: ListSearchSourceCodeResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_search_source_code_with_options(request, headers, runtime)

    async def list_search_source_code_async(
        self,
        request: devops_20210625_models.ListSearchSourceCodeRequest,
    ) -> devops_20210625_models.ListSearchSourceCodeResponse:
        """
        @summary 搜索代码片段
        
        @param request: ListSearchSourceCodeRequest
        @return: ListSearchSourceCodeResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_search_source_code_with_options_async(request, headers, runtime)

    def list_service_auths_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.ListServiceAuthsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListServiceAuthsResponse:
        """
        @summary 获取服务授权列表
        
        @param request: ListServiceAuthsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListServiceAuthsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.service_auth_type):
            query['serviceAuthType'] = request.service_auth_type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListServiceAuths',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/serviceAuths',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListServiceAuthsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_service_auths_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ListServiceAuthsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListServiceAuthsResponse:
        """
        @summary 获取服务授权列表
        
        @param request: ListServiceAuthsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListServiceAuthsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.service_auth_type):
            query['serviceAuthType'] = request.service_auth_type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListServiceAuths',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/serviceAuths',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListServiceAuthsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_service_auths(
        self,
        organization_id: str,
        request: devops_20210625_models.ListServiceAuthsRequest,
    ) -> devops_20210625_models.ListServiceAuthsResponse:
        """
        @summary 获取服务授权列表
        
        @param request: ListServiceAuthsRequest
        @return: ListServiceAuthsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_service_auths_with_options(organization_id, request, headers, runtime)

    async def list_service_auths_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ListServiceAuthsRequest,
    ) -> devops_20210625_models.ListServiceAuthsResponse:
        """
        @summary 获取服务授权列表
        
        @param request: ListServiceAuthsRequest
        @return: ListServiceAuthsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_service_auths_with_options_async(organization_id, request, headers, runtime)

    def list_service_connections_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.ListServiceConnectionsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListServiceConnectionsResponse:
        """
        @summary 获取服务连接列表
        
        @param request: ListServiceConnectionsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListServiceConnectionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.serice_connection_type):
            query['sericeConnectionType'] = request.serice_connection_type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListServiceConnections',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/serviceConnections',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListServiceConnectionsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_service_connections_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ListServiceConnectionsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListServiceConnectionsResponse:
        """
        @summary 获取服务连接列表
        
        @param request: ListServiceConnectionsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListServiceConnectionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.serice_connection_type):
            query['sericeConnectionType'] = request.serice_connection_type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListServiceConnections',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/serviceConnections',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListServiceConnectionsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_service_connections(
        self,
        organization_id: str,
        request: devops_20210625_models.ListServiceConnectionsRequest,
    ) -> devops_20210625_models.ListServiceConnectionsResponse:
        """
        @summary 获取服务连接列表
        
        @param request: ListServiceConnectionsRequest
        @return: ListServiceConnectionsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_service_connections_with_options(organization_id, request, headers, runtime)

    async def list_service_connections_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ListServiceConnectionsRequest,
    ) -> devops_20210625_models.ListServiceConnectionsResponse:
        """
        @summary 获取服务连接列表
        
        @param request: ListServiceConnectionsRequest
        @return: ListServiceConnectionsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_service_connections_with_options_async(organization_id, request, headers, runtime)

    def list_service_credentials_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.ListServiceCredentialsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListServiceCredentialsResponse:
        """
        @summary 获取服务证书列表
        
        @param request: ListServiceCredentialsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListServiceCredentialsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.service_credential_type):
            query['serviceCredentialType'] = request.service_credential_type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListServiceCredentials',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/serviceCredentials',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListServiceCredentialsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_service_credentials_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ListServiceCredentialsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListServiceCredentialsResponse:
        """
        @summary 获取服务证书列表
        
        @param request: ListServiceCredentialsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListServiceCredentialsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.service_credential_type):
            query['serviceCredentialType'] = request.service_credential_type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListServiceCredentials',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/serviceCredentials',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListServiceCredentialsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_service_credentials(
        self,
        organization_id: str,
        request: devops_20210625_models.ListServiceCredentialsRequest,
    ) -> devops_20210625_models.ListServiceCredentialsResponse:
        """
        @summary 获取服务证书列表
        
        @param request: ListServiceCredentialsRequest
        @return: ListServiceCredentialsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_service_credentials_with_options(organization_id, request, headers, runtime)

    async def list_service_credentials_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ListServiceCredentialsRequest,
    ) -> devops_20210625_models.ListServiceCredentialsResponse:
        """
        @summary 获取服务证书列表
        
        @param request: ListServiceCredentialsRequest
        @return: ListServiceCredentialsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_service_credentials_with_options_async(organization_id, request, headers, runtime)

    def list_sprints_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.ListSprintsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListSprintsResponse:
        """
        @summary 获取迭代列表
        
        @param request: ListSprintsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListSprintsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.max_results):
            query['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.space_identifier):
            query['spaceIdentifier'] = request.space_identifier
        if not UtilClient.is_unset(request.space_type):
            query['spaceType'] = request.space_type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListSprints',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/sprints/list',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListSprintsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_sprints_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ListSprintsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListSprintsResponse:
        """
        @summary 获取迭代列表
        
        @param request: ListSprintsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListSprintsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.max_results):
            query['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.space_identifier):
            query['spaceIdentifier'] = request.space_identifier
        if not UtilClient.is_unset(request.space_type):
            query['spaceType'] = request.space_type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListSprints',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/sprints/list',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListSprintsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_sprints(
        self,
        organization_id: str,
        request: devops_20210625_models.ListSprintsRequest,
    ) -> devops_20210625_models.ListSprintsResponse:
        """
        @summary 获取迭代列表
        
        @param request: ListSprintsRequest
        @return: ListSprintsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_sprints_with_options(organization_id, request, headers, runtime)

    async def list_sprints_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ListSprintsRequest,
    ) -> devops_20210625_models.ListSprintsResponse:
        """
        @summary 获取迭代列表
        
        @param request: ListSprintsRequest
        @return: ListSprintsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_sprints_with_options_async(organization_id, request, headers, runtime)

    def list_test_case_fields_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.ListTestCaseFieldsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListTestCaseFieldsResponse:
        """
        @summary 获取测试用例全部字段
        
        @param request: ListTestCaseFieldsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListTestCaseFieldsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.space_identifier):
            query['spaceIdentifier'] = request.space_identifier
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListTestCaseFields',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/testhub/testcase/fields',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListTestCaseFieldsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_test_case_fields_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ListTestCaseFieldsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListTestCaseFieldsResponse:
        """
        @summary 获取测试用例全部字段
        
        @param request: ListTestCaseFieldsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListTestCaseFieldsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.space_identifier):
            query['spaceIdentifier'] = request.space_identifier
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListTestCaseFields',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/testhub/testcase/fields',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListTestCaseFieldsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_test_case_fields(
        self,
        organization_id: str,
        request: devops_20210625_models.ListTestCaseFieldsRequest,
    ) -> devops_20210625_models.ListTestCaseFieldsResponse:
        """
        @summary 获取测试用例全部字段
        
        @param request: ListTestCaseFieldsRequest
        @return: ListTestCaseFieldsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_test_case_fields_with_options(organization_id, request, headers, runtime)

    async def list_test_case_fields_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ListTestCaseFieldsRequest,
    ) -> devops_20210625_models.ListTestCaseFieldsResponse:
        """
        @summary 获取测试用例全部字段
        
        @param request: ListTestCaseFieldsRequest
        @return: ListTestCaseFieldsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_test_case_fields_with_options_async(organization_id, request, headers, runtime)

    def list_user_draw_record_by_pk_with_options(
        self,
        request: devops_20210625_models.ListUserDrawRecordByPkRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListUserDrawRecordByPkResponse:
        """
        @summary 测试DrawService
        
        @param request: ListUserDrawRecordByPkRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListUserDrawRecordByPkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.aliyun_pk):
            query['aliyunPk'] = request.aliyun_pk
        if not UtilClient.is_unset(request.draw_group):
            query['drawGroup'] = request.draw_group
        if not UtilClient.is_unset(request.draw_pool_name):
            query['drawPoolName'] = request.draw_pool_name
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListUserDrawRecordByPk',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/listUserDrawRecords',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListUserDrawRecordByPkResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_user_draw_record_by_pk_with_options_async(
        self,
        request: devops_20210625_models.ListUserDrawRecordByPkRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListUserDrawRecordByPkResponse:
        """
        @summary 测试DrawService
        
        @param request: ListUserDrawRecordByPkRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListUserDrawRecordByPkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.aliyun_pk):
            query['aliyunPk'] = request.aliyun_pk
        if not UtilClient.is_unset(request.draw_group):
            query['drawGroup'] = request.draw_group
        if not UtilClient.is_unset(request.draw_pool_name):
            query['drawPoolName'] = request.draw_pool_name
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListUserDrawRecordByPk',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/listUserDrawRecords',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListUserDrawRecordByPkResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_user_draw_record_by_pk(
        self,
        request: devops_20210625_models.ListUserDrawRecordByPkRequest,
    ) -> devops_20210625_models.ListUserDrawRecordByPkResponse:
        """
        @summary 测试DrawService
        
        @param request: ListUserDrawRecordByPkRequest
        @return: ListUserDrawRecordByPkResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_user_draw_record_by_pk_with_options(request, headers, runtime)

    async def list_user_draw_record_by_pk_async(
        self,
        request: devops_20210625_models.ListUserDrawRecordByPkRequest,
    ) -> devops_20210625_models.ListUserDrawRecordByPkResponse:
        """
        @summary 测试DrawService
        
        @param request: ListUserDrawRecordByPkRequest
        @return: ListUserDrawRecordByPkResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_user_draw_record_by_pk_with_options_async(request, headers, runtime)

    def list_user_keys_with_options(
        self,
        request: devops_20210625_models.ListUserKeysRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListUserKeysResponse:
        """
        @summary 查询当前用户的SSH Key列表
        
        @param request: ListUserKeysRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListUserKeysResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.order_by):
            query['orderBy'] = request.order_by
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.page):
            query['page'] = request.page
        if not UtilClient.is_unset(request.page_size):
            query['pageSize'] = request.page_size
        if not UtilClient.is_unset(request.sort):
            query['sort'] = request.sort
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListUserKeys',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v3/user/keys',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListUserKeysResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_user_keys_with_options_async(
        self,
        request: devops_20210625_models.ListUserKeysRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListUserKeysResponse:
        """
        @summary 查询当前用户的SSH Key列表
        
        @param request: ListUserKeysRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListUserKeysResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.order_by):
            query['orderBy'] = request.order_by
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.page):
            query['page'] = request.page
        if not UtilClient.is_unset(request.page_size):
            query['pageSize'] = request.page_size
        if not UtilClient.is_unset(request.sort):
            query['sort'] = request.sort
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListUserKeys',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v3/user/keys',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListUserKeysResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_user_keys(
        self,
        request: devops_20210625_models.ListUserKeysRequest,
    ) -> devops_20210625_models.ListUserKeysResponse:
        """
        @summary 查询当前用户的SSH Key列表
        
        @param request: ListUserKeysRequest
        @return: ListUserKeysResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_user_keys_with_options(request, headers, runtime)

    async def list_user_keys_async(
        self,
        request: devops_20210625_models.ListUserKeysRequest,
    ) -> devops_20210625_models.ListUserKeysResponse:
        """
        @summary 查询当前用户的SSH Key列表
        
        @param request: ListUserKeysRequest
        @return: ListUserKeysResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_user_keys_with_options_async(request, headers, runtime)

    def list_user_resources_with_options(
        self,
        request: devops_20210625_models.ListUserResourcesRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListUserResourcesResponse:
        """
        @summary 查询用户有权限的资源（代码库、组）
        
        @param request: ListUserResourcesRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListUserResourcesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.page):
            query['page'] = request.page
        if not UtilClient.is_unset(request.page_size):
            query['pageSize'] = request.page_size
        if not UtilClient.is_unset(request.user_ids):
            query['userIds'] = request.user_ids
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListUserResources',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/user/vision/user_resources',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListUserResourcesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_user_resources_with_options_async(
        self,
        request: devops_20210625_models.ListUserResourcesRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListUserResourcesResponse:
        """
        @summary 查询用户有权限的资源（代码库、组）
        
        @param request: ListUserResourcesRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListUserResourcesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.page):
            query['page'] = request.page
        if not UtilClient.is_unset(request.page_size):
            query['pageSize'] = request.page_size
        if not UtilClient.is_unset(request.user_ids):
            query['userIds'] = request.user_ids
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListUserResources',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/user/vision/user_resources',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListUserResourcesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_user_resources(
        self,
        request: devops_20210625_models.ListUserResourcesRequest,
    ) -> devops_20210625_models.ListUserResourcesResponse:
        """
        @summary 查询用户有权限的资源（代码库、组）
        
        @param request: ListUserResourcesRequest
        @return: ListUserResourcesResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_user_resources_with_options(request, headers, runtime)

    async def list_user_resources_async(
        self,
        request: devops_20210625_models.ListUserResourcesRequest,
    ) -> devops_20210625_models.ListUserResourcesResponse:
        """
        @summary 查询用户有权限的资源（代码库、组）
        
        @param request: ListUserResourcesRequest
        @return: ListUserResourcesResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_user_resources_with_options_async(request, headers, runtime)

    def list_variable_groups_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.ListVariableGroupsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListVariableGroupsResponse:
        """
        @summary 获取变量组列表
        
        @param request: ListVariableGroupsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListVariableGroupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.max_results):
            query['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.page_order):
            query['pageOrder'] = request.page_order
        if not UtilClient.is_unset(request.page_sort):
            query['pageSort'] = request.page_sort
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListVariableGroups',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/variableGroups',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListVariableGroupsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_variable_groups_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ListVariableGroupsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListVariableGroupsResponse:
        """
        @summary 获取变量组列表
        
        @param request: ListVariableGroupsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListVariableGroupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.max_results):
            query['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.page_order):
            query['pageOrder'] = request.page_order
        if not UtilClient.is_unset(request.page_sort):
            query['pageSort'] = request.page_sort
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListVariableGroups',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/variableGroups',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListVariableGroupsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_variable_groups(
        self,
        organization_id: str,
        request: devops_20210625_models.ListVariableGroupsRequest,
    ) -> devops_20210625_models.ListVariableGroupsResponse:
        """
        @summary 获取变量组列表
        
        @param request: ListVariableGroupsRequest
        @return: ListVariableGroupsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_variable_groups_with_options(organization_id, request, headers, runtime)

    async def list_variable_groups_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ListVariableGroupsRequest,
    ) -> devops_20210625_models.ListVariableGroupsResponse:
        """
        @summary 获取变量组列表
        
        @param request: ListVariableGroupsRequest
        @return: ListVariableGroupsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_variable_groups_with_options_async(organization_id, request, headers, runtime)

    def list_work_item_all_fields_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.ListWorkItemAllFieldsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListWorkItemAllFieldsResponse:
        """
        @summary 获取项目下工作项的所有字段
        
        @param request: ListWorkItemAllFieldsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListWorkItemAllFieldsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.space_identifier):
            query['spaceIdentifier'] = request.space_identifier
        if not UtilClient.is_unset(request.space_type):
            query['spaceType'] = request.space_type
        if not UtilClient.is_unset(request.workitem_type_identifier):
            query['workitemTypeIdentifier'] = request.workitem_type_identifier
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListWorkItemAllFields',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitems/fields/listAll',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListWorkItemAllFieldsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_work_item_all_fields_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ListWorkItemAllFieldsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListWorkItemAllFieldsResponse:
        """
        @summary 获取项目下工作项的所有字段
        
        @param request: ListWorkItemAllFieldsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListWorkItemAllFieldsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.space_identifier):
            query['spaceIdentifier'] = request.space_identifier
        if not UtilClient.is_unset(request.space_type):
            query['spaceType'] = request.space_type
        if not UtilClient.is_unset(request.workitem_type_identifier):
            query['workitemTypeIdentifier'] = request.workitem_type_identifier
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListWorkItemAllFields',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitems/fields/listAll',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListWorkItemAllFieldsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_work_item_all_fields(
        self,
        organization_id: str,
        request: devops_20210625_models.ListWorkItemAllFieldsRequest,
    ) -> devops_20210625_models.ListWorkItemAllFieldsResponse:
        """
        @summary 获取项目下工作项的所有字段
        
        @param request: ListWorkItemAllFieldsRequest
        @return: ListWorkItemAllFieldsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_work_item_all_fields_with_options(organization_id, request, headers, runtime)

    async def list_work_item_all_fields_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ListWorkItemAllFieldsRequest,
    ) -> devops_20210625_models.ListWorkItemAllFieldsResponse:
        """
        @summary 获取项目下工作项的所有字段
        
        @param request: ListWorkItemAllFieldsRequest
        @return: ListWorkItemAllFieldsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_work_item_all_fields_with_options_async(organization_id, request, headers, runtime)

    def list_work_item_work_flow_status_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.ListWorkItemWorkFlowStatusRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListWorkItemWorkFlowStatusResponse:
        """
        @summary 查询工作项工作流的所有状态
        
        @param request: ListWorkItemWorkFlowStatusRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListWorkItemWorkFlowStatusResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.space_identifier):
            query['spaceIdentifier'] = request.space_identifier
        if not UtilClient.is_unset(request.space_type):
            query['spaceType'] = request.space_type
        if not UtilClient.is_unset(request.workitem_category_identifier):
            query['workitemCategoryIdentifier'] = request.workitem_category_identifier
        if not UtilClient.is_unset(request.workitem_type_identifier):
            query['workitemTypeIdentifier'] = request.workitem_type_identifier
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListWorkItemWorkFlowStatus',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitems/workflow/listWorkflowStatus',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListWorkItemWorkFlowStatusResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_work_item_work_flow_status_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ListWorkItemWorkFlowStatusRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListWorkItemWorkFlowStatusResponse:
        """
        @summary 查询工作项工作流的所有状态
        
        @param request: ListWorkItemWorkFlowStatusRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListWorkItemWorkFlowStatusResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.space_identifier):
            query['spaceIdentifier'] = request.space_identifier
        if not UtilClient.is_unset(request.space_type):
            query['spaceType'] = request.space_type
        if not UtilClient.is_unset(request.workitem_category_identifier):
            query['workitemCategoryIdentifier'] = request.workitem_category_identifier
        if not UtilClient.is_unset(request.workitem_type_identifier):
            query['workitemTypeIdentifier'] = request.workitem_type_identifier
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListWorkItemWorkFlowStatus',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitems/workflow/listWorkflowStatus',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListWorkItemWorkFlowStatusResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_work_item_work_flow_status(
        self,
        organization_id: str,
        request: devops_20210625_models.ListWorkItemWorkFlowStatusRequest,
    ) -> devops_20210625_models.ListWorkItemWorkFlowStatusResponse:
        """
        @summary 查询工作项工作流的所有状态
        
        @param request: ListWorkItemWorkFlowStatusRequest
        @return: ListWorkItemWorkFlowStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_work_item_work_flow_status_with_options(organization_id, request, headers, runtime)

    async def list_work_item_work_flow_status_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ListWorkItemWorkFlowStatusRequest,
    ) -> devops_20210625_models.ListWorkItemWorkFlowStatusResponse:
        """
        @summary 查询工作项工作流的所有状态
        
        @param request: ListWorkItemWorkFlowStatusRequest
        @return: ListWorkItemWorkFlowStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_work_item_work_flow_status_with_options_async(organization_id, request, headers, runtime)

    def list_workitem_attachments_with_options(
        self,
        organization_id: str,
        workitem_identifier: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListWorkitemAttachmentsResponse:
        """
        @summary 获取工作项的附件列表
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListWorkitemAttachmentsResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='ListWorkitemAttachments',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitem/{OpenApiUtilClient.get_encode_param(workitem_identifier)}/attachments',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListWorkitemAttachmentsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_workitem_attachments_with_options_async(
        self,
        organization_id: str,
        workitem_identifier: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListWorkitemAttachmentsResponse:
        """
        @summary 获取工作项的附件列表
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListWorkitemAttachmentsResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='ListWorkitemAttachments',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitem/{OpenApiUtilClient.get_encode_param(workitem_identifier)}/attachments',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListWorkitemAttachmentsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_workitem_attachments(
        self,
        organization_id: str,
        workitem_identifier: str,
    ) -> devops_20210625_models.ListWorkitemAttachmentsResponse:
        """
        @summary 获取工作项的附件列表
        
        @return: ListWorkitemAttachmentsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_workitem_attachments_with_options(organization_id, workitem_identifier, headers, runtime)

    async def list_workitem_attachments_async(
        self,
        organization_id: str,
        workitem_identifier: str,
    ) -> devops_20210625_models.ListWorkitemAttachmentsResponse:
        """
        @summary 获取工作项的附件列表
        
        @return: ListWorkitemAttachmentsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_workitem_attachments_with_options_async(organization_id, workitem_identifier, headers, runtime)

    def list_workitem_estimate_with_options(
        self,
        organization_id: str,
        workitem_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListWorkitemEstimateResponse:
        """
        @summary 获取工作项预计工时明细列表
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListWorkitemEstimateResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='ListWorkitemEstimate',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitems/{OpenApiUtilClient.get_encode_param(workitem_id)}/estimate/list',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListWorkitemEstimateResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_workitem_estimate_with_options_async(
        self,
        organization_id: str,
        workitem_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListWorkitemEstimateResponse:
        """
        @summary 获取工作项预计工时明细列表
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListWorkitemEstimateResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='ListWorkitemEstimate',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitems/{OpenApiUtilClient.get_encode_param(workitem_id)}/estimate/list',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListWorkitemEstimateResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_workitem_estimate(
        self,
        organization_id: str,
        workitem_id: str,
    ) -> devops_20210625_models.ListWorkitemEstimateResponse:
        """
        @summary 获取工作项预计工时明细列表
        
        @return: ListWorkitemEstimateResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_workitem_estimate_with_options(organization_id, workitem_id, headers, runtime)

    async def list_workitem_estimate_async(
        self,
        organization_id: str,
        workitem_id: str,
    ) -> devops_20210625_models.ListWorkitemEstimateResponse:
        """
        @summary 获取工作项预计工时明细列表
        
        @return: ListWorkitemEstimateResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_workitem_estimate_with_options_async(organization_id, workitem_id, headers, runtime)

    def list_workitem_time_with_options(
        self,
        organization_id: str,
        workitem_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListWorkitemTimeResponse:
        """
        @summary 获取工作项工时明细列表
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListWorkitemTimeResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='ListWorkitemTime',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitems/{OpenApiUtilClient.get_encode_param(workitem_id)}/time/list',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListWorkitemTimeResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_workitem_time_with_options_async(
        self,
        organization_id: str,
        workitem_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListWorkitemTimeResponse:
        """
        @summary 获取工作项工时明细列表
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListWorkitemTimeResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='ListWorkitemTime',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/workitems/{OpenApiUtilClient.get_encode_param(workitem_id)}/time/list',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListWorkitemTimeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_workitem_time(
        self,
        organization_id: str,
        workitem_id: str,
    ) -> devops_20210625_models.ListWorkitemTimeResponse:
        """
        @summary 获取工作项工时明细列表
        
        @return: ListWorkitemTimeResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_workitem_time_with_options(organization_id, workitem_id, headers, runtime)

    async def list_workitem_time_async(
        self,
        organization_id: str,
        workitem_id: str,
    ) -> devops_20210625_models.ListWorkitemTimeResponse:
        """
        @summary 获取工作项工时明细列表
        
        @return: ListWorkitemTimeResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_workitem_time_with_options_async(organization_id, workitem_id, headers, runtime)

    def list_workitems_with_options(
        self,
        organization_id: str,
        request: devops_20210625_models.ListWorkitemsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListWorkitemsResponse:
        """
        @summary 获取工作项列表
        
        @param request: ListWorkitemsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListWorkitemsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.category):
            query['category'] = request.category
        if not UtilClient.is_unset(request.conditions):
            query['conditions'] = request.conditions
        if not UtilClient.is_unset(request.extra_conditions):
            query['extraConditions'] = request.extra_conditions
        if not UtilClient.is_unset(request.group_condition):
            query['groupCondition'] = request.group_condition
        if not UtilClient.is_unset(request.max_results):
            query['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.order_by):
            query['orderBy'] = request.order_by
        if not UtilClient.is_unset(request.search_type):
            query['searchType'] = request.search_type
        if not UtilClient.is_unset(request.space_identifier):
            query['spaceIdentifier'] = request.space_identifier
        if not UtilClient.is_unset(request.space_type):
            query['spaceType'] = request.space_type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListWorkitems',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/listWorkitems',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListWorkitemsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_workitems_with_options_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ListWorkitemsRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ListWorkitemsResponse:
        """
        @summary 获取工作项列表
        
        @param request: ListWorkitemsRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListWorkitemsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.category):
            query['category'] = request.category
        if not UtilClient.is_unset(request.conditions):
            query['conditions'] = request.conditions
        if not UtilClient.is_unset(request.extra_conditions):
            query['extraConditions'] = request.extra_conditions
        if not UtilClient.is_unset(request.group_condition):
            query['groupCondition'] = request.group_condition
        if not UtilClient.is_unset(request.max_results):
            query['maxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['nextToken'] = request.next_token
        if not UtilClient.is_unset(request.order_by):
            query['orderBy'] = request.order_by
        if not UtilClient.is_unset(request.search_type):
            query['searchType'] = request.search_type
        if not UtilClient.is_unset(request.space_identifier):
            query['spaceIdentifier'] = request.space_identifier
        if not UtilClient.is_unset(request.space_type):
            query['spaceType'] = request.space_type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListWorkitems',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/listWorkitems',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ListWorkitemsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_workitems(
        self,
        organization_id: str,
        request: devops_20210625_models.ListWorkitemsRequest,
    ) -> devops_20210625_models.ListWorkitemsResponse:
        """
        @summary 获取工作项列表
        
        @param request: ListWorkitemsRequest
        @return: ListWorkitemsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.list_workitems_with_options(organization_id, request, headers, runtime)

    async def list_workitems_async(
        self,
        organization_id: str,
        request: devops_20210625_models.ListWorkitemsRequest,
    ) -> devops_20210625_models.ListWorkitemsResponse:
        """
        @summary 获取工作项列表
        
        @param request: ListWorkitemsRequest
        @return: ListWorkitemsResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.list_workitems_with_options_async(organization_id, request, headers, runtime)

    def log_pipeline_job_run_with_options(
        self,
        organization_id: str,
        pipeline_id: str,
        job_id: str,
        pipeline_run_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.LogPipelineJobRunResponse:
        """
        @summary 获取流水线运行任务日志
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: LogPipelineJobRunResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='LogPipelineJobRun',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipeline/{OpenApiUtilClient.get_encode_param(pipeline_id)}/pipelineRun/{OpenApiUtilClient.get_encode_param(pipeline_run_id)}/job/{OpenApiUtilClient.get_encode_param(job_id)}/logs',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.LogPipelineJobRunResponse(),
            self.call_api(params, req, runtime)
        )

    async def log_pipeline_job_run_with_options_async(
        self,
        organization_id: str,
        pipeline_id: str,
        job_id: str,
        pipeline_run_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.LogPipelineJobRunResponse:
        """
        @summary 获取流水线运行任务日志
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: LogPipelineJobRunResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='LogPipelineJobRun',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipeline/{OpenApiUtilClient.get_encode_param(pipeline_id)}/pipelineRun/{OpenApiUtilClient.get_encode_param(pipeline_run_id)}/job/{OpenApiUtilClient.get_encode_param(job_id)}/logs',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.LogPipelineJobRunResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def log_pipeline_job_run(
        self,
        organization_id: str,
        pipeline_id: str,
        job_id: str,
        pipeline_run_id: str,
    ) -> devops_20210625_models.LogPipelineJobRunResponse:
        """
        @summary 获取流水线运行任务日志
        
        @return: LogPipelineJobRunResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.log_pipeline_job_run_with_options(organization_id, pipeline_id, job_id, pipeline_run_id, headers, runtime)

    async def log_pipeline_job_run_async(
        self,
        organization_id: str,
        pipeline_id: str,
        job_id: str,
        pipeline_run_id: str,
    ) -> devops_20210625_models.LogPipelineJobRunResponse:
        """
        @summary 获取流水线运行任务日志
        
        @return: LogPipelineJobRunResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.log_pipeline_job_run_with_options_async(organization_id, pipeline_id, job_id, pipeline_run_id, headers, runtime)

    def log_vmdeploy_machine_with_options(
        self,
        organization_id: str,
        pipeline_id: str,
        deploy_order_id: str,
        machine_sn: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.LogVMDeployMachineResponse:
        """
        @summary 获取机器部署日志
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: LogVMDeployMachineResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='LogVMDeployMachine',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines/{OpenApiUtilClient.get_encode_param(pipeline_id)}/deploy/{OpenApiUtilClient.get_encode_param(deploy_order_id)}/machine/{OpenApiUtilClient.get_encode_param(machine_sn)}/log',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.LogVMDeployMachineResponse(),
            self.call_api(params, req, runtime)
        )

    async def log_vmdeploy_machine_with_options_async(
        self,
        organization_id: str,
        pipeline_id: str,
        deploy_order_id: str,
        machine_sn: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.LogVMDeployMachineResponse:
        """
        @summary 获取机器部署日志
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: LogVMDeployMachineResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='LogVMDeployMachine',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines/{OpenApiUtilClient.get_encode_param(pipeline_id)}/deploy/{OpenApiUtilClient.get_encode_param(deploy_order_id)}/machine/{OpenApiUtilClient.get_encode_param(machine_sn)}/log',
            method='GET',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.LogVMDeployMachineResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def log_vmdeploy_machine(
        self,
        organization_id: str,
        pipeline_id: str,
        deploy_order_id: str,
        machine_sn: str,
    ) -> devops_20210625_models.LogVMDeployMachineResponse:
        """
        @summary 获取机器部署日志
        
        @return: LogVMDeployMachineResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.log_vmdeploy_machine_with_options(organization_id, pipeline_id, deploy_order_id, machine_sn, headers, runtime)

    async def log_vmdeploy_machine_async(
        self,
        organization_id: str,
        pipeline_id: str,
        deploy_order_id: str,
        machine_sn: str,
    ) -> devops_20210625_models.LogVMDeployMachineResponse:
        """
        @summary 获取机器部署日志
        
        @return: LogVMDeployMachineResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.log_vmdeploy_machine_with_options_async(organization_id, pipeline_id, deploy_order_id, machine_sn, headers, runtime)

    def merge_merge_request_with_options(
        self,
        repository_id: str,
        local_id: str,
        request: devops_20210625_models.MergeMergeRequestRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.MergeMergeRequestResponse:
        """
        @summary 合并代码评审
        
        @param request: MergeMergeRequestRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: MergeMergeRequestResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.merge_message):
            body['mergeMessage'] = request.merge_message
        if not UtilClient.is_unset(request.merge_type):
            body['mergeType'] = request.merge_type
        if not UtilClient.is_unset(request.remove_source_branch):
            body['removeSourceBranch'] = request.remove_source_branch
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='MergeMergeRequest',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/{OpenApiUtilClient.get_encode_param(repository_id)}/merge_requests/{OpenApiUtilClient.get_encode_param(local_id)}/merge',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.MergeMergeRequestResponse(),
            self.call_api(params, req, runtime)
        )

    async def merge_merge_request_with_options_async(
        self,
        repository_id: str,
        local_id: str,
        request: devops_20210625_models.MergeMergeRequestRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.MergeMergeRequestResponse:
        """
        @summary 合并代码评审
        
        @param request: MergeMergeRequestRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: MergeMergeRequestResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.merge_message):
            body['mergeMessage'] = request.merge_message
        if not UtilClient.is_unset(request.merge_type):
            body['mergeType'] = request.merge_type
        if not UtilClient.is_unset(request.remove_source_branch):
            body['removeSourceBranch'] = request.remove_source_branch
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='MergeMergeRequest',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/{OpenApiUtilClient.get_encode_param(repository_id)}/merge_requests/{OpenApiUtilClient.get_encode_param(local_id)}/merge',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.MergeMergeRequestResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def merge_merge_request(
        self,
        repository_id: str,
        local_id: str,
        request: devops_20210625_models.MergeMergeRequestRequest,
    ) -> devops_20210625_models.MergeMergeRequestResponse:
        """
        @summary 合并代码评审
        
        @param request: MergeMergeRequestRequest
        @return: MergeMergeRequestResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.merge_merge_request_with_options(repository_id, local_id, request, headers, runtime)

    async def merge_merge_request_async(
        self,
        repository_id: str,
        local_id: str,
        request: devops_20210625_models.MergeMergeRequestRequest,
    ) -> devops_20210625_models.MergeMergeRequestResponse:
        """
        @summary 合并代码评审
        
        @param request: MergeMergeRequestRequest
        @return: MergeMergeRequestResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.merge_merge_request_with_options_async(repository_id, local_id, request, headers, runtime)

    def pass_pipeline_validate_with_options(
        self,
        organization_id: str,
        pipeline_id: str,
        pipeline_run_id: str,
        job_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.PassPipelineValidateResponse:
        """
        @summary 通过人工卡点
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: PassPipelineValidateResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='PassPipelineValidate',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines/{OpenApiUtilClient.get_encode_param(pipeline_id)}/pipelineRuns/{OpenApiUtilClient.get_encode_param(pipeline_run_id)}/jobs/{OpenApiUtilClient.get_encode_param(job_id)}/pass',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.PassPipelineValidateResponse(),
            self.call_api(params, req, runtime)
        )

    async def pass_pipeline_validate_with_options_async(
        self,
        organization_id: str,
        pipeline_id: str,
        pipeline_run_id: str,
        job_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.PassPipelineValidateResponse:
        """
        @summary 通过人工卡点
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: PassPipelineValidateResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='PassPipelineValidate',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines/{OpenApiUtilClient.get_encode_param(pipeline_id)}/pipelineRuns/{OpenApiUtilClient.get_encode_param(pipeline_run_id)}/jobs/{OpenApiUtilClient.get_encode_param(job_id)}/pass',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.PassPipelineValidateResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def pass_pipeline_validate(
        self,
        organization_id: str,
        pipeline_id: str,
        pipeline_run_id: str,
        job_id: str,
    ) -> devops_20210625_models.PassPipelineValidateResponse:
        """
        @summary 通过人工卡点
        
        @return: PassPipelineValidateResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.pass_pipeline_validate_with_options(organization_id, pipeline_id, pipeline_run_id, job_id, headers, runtime)

    async def pass_pipeline_validate_async(
        self,
        organization_id: str,
        pipeline_id: str,
        pipeline_run_id: str,
        job_id: str,
    ) -> devops_20210625_models.PassPipelineValidateResponse:
        """
        @summary 通过人工卡点
        
        @return: PassPipelineValidateResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.pass_pipeline_validate_with_options_async(organization_id, pipeline_id, pipeline_run_id, job_id, headers, runtime)

    def pass_release_stage_pipeline_validate_with_options(
        self,
        app_name: str,
        release_workflow_sn: str,
        release_stage_sn: str,
        execution_number: str,
        request: devops_20210625_models.PassReleaseStagePipelineValidateRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.PassReleaseStagePipelineValidateResponse:
        """
        @summary 通过人工卡点
        
        @param request: PassReleaseStagePipelineValidateRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: PassReleaseStagePipelineValidateResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['jobId'] = request.job_id
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='PassReleaseStagePipelineValidate',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/appstack/apps/{OpenApiUtilClient.get_encode_param(app_name)}/releaseWorkflows/{OpenApiUtilClient.get_encode_param(release_workflow_sn)}/releaseStages/{OpenApiUtilClient.get_encode_param(release_stage_sn)}/executions/{OpenApiUtilClient.get_encode_param(execution_number)}%3ApassPipelineValidate',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.PassReleaseStagePipelineValidateResponse(),
            self.call_api(params, req, runtime)
        )

    async def pass_release_stage_pipeline_validate_with_options_async(
        self,
        app_name: str,
        release_workflow_sn: str,
        release_stage_sn: str,
        execution_number: str,
        request: devops_20210625_models.PassReleaseStagePipelineValidateRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.PassReleaseStagePipelineValidateResponse:
        """
        @summary 通过人工卡点
        
        @param request: PassReleaseStagePipelineValidateRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: PassReleaseStagePipelineValidateResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['jobId'] = request.job_id
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='PassReleaseStagePipelineValidate',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/appstack/apps/{OpenApiUtilClient.get_encode_param(app_name)}/releaseWorkflows/{OpenApiUtilClient.get_encode_param(release_workflow_sn)}/releaseStages/{OpenApiUtilClient.get_encode_param(release_stage_sn)}/executions/{OpenApiUtilClient.get_encode_param(execution_number)}%3ApassPipelineValidate',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.PassReleaseStagePipelineValidateResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def pass_release_stage_pipeline_validate(
        self,
        app_name: str,
        release_workflow_sn: str,
        release_stage_sn: str,
        execution_number: str,
        request: devops_20210625_models.PassReleaseStagePipelineValidateRequest,
    ) -> devops_20210625_models.PassReleaseStagePipelineValidateResponse:
        """
        @summary 通过人工卡点
        
        @param request: PassReleaseStagePipelineValidateRequest
        @return: PassReleaseStagePipelineValidateResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.pass_release_stage_pipeline_validate_with_options(app_name, release_workflow_sn, release_stage_sn, execution_number, request, headers, runtime)

    async def pass_release_stage_pipeline_validate_async(
        self,
        app_name: str,
        release_workflow_sn: str,
        release_stage_sn: str,
        execution_number: str,
        request: devops_20210625_models.PassReleaseStagePipelineValidateRequest,
    ) -> devops_20210625_models.PassReleaseStagePipelineValidateResponse:
        """
        @summary 通过人工卡点
        
        @param request: PassReleaseStagePipelineValidateRequest
        @return: PassReleaseStagePipelineValidateResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.pass_release_stage_pipeline_validate_with_options_async(app_name, release_workflow_sn, release_stage_sn, execution_number, request, headers, runtime)

    def refuse_pipeline_validate_with_options(
        self,
        organization_id: str,
        pipeline_id: str,
        pipeline_run_id: str,
        job_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.RefusePipelineValidateResponse:
        """
        @summary 拒绝人工卡点
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: RefusePipelineValidateResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='RefusePipelineValidate',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines/{OpenApiUtilClient.get_encode_param(pipeline_id)}/pipelineRuns/{OpenApiUtilClient.get_encode_param(pipeline_run_id)}/jobs/{OpenApiUtilClient.get_encode_param(job_id)}/refuse',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.RefusePipelineValidateResponse(),
            self.call_api(params, req, runtime)
        )

    async def refuse_pipeline_validate_with_options_async(
        self,
        organization_id: str,
        pipeline_id: str,
        pipeline_run_id: str,
        job_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.RefusePipelineValidateResponse:
        """
        @summary 拒绝人工卡点
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: RefusePipelineValidateResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='RefusePipelineValidate',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines/{OpenApiUtilClient.get_encode_param(pipeline_id)}/pipelineRuns/{OpenApiUtilClient.get_encode_param(pipeline_run_id)}/jobs/{OpenApiUtilClient.get_encode_param(job_id)}/refuse',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.RefusePipelineValidateResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def refuse_pipeline_validate(
        self,
        organization_id: str,
        pipeline_id: str,
        pipeline_run_id: str,
        job_id: str,
    ) -> devops_20210625_models.RefusePipelineValidateResponse:
        """
        @summary 拒绝人工卡点
        
        @return: RefusePipelineValidateResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.refuse_pipeline_validate_with_options(organization_id, pipeline_id, pipeline_run_id, job_id, headers, runtime)

    async def refuse_pipeline_validate_async(
        self,
        organization_id: str,
        pipeline_id: str,
        pipeline_run_id: str,
        job_id: str,
    ) -> devops_20210625_models.RefusePipelineValidateResponse:
        """
        @summary 拒绝人工卡点
        
        @return: RefusePipelineValidateResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.refuse_pipeline_validate_with_options_async(organization_id, pipeline_id, pipeline_run_id, job_id, headers, runtime)

    def refuse_release_stage_pipeline_validate_with_options(
        self,
        app_name: str,
        release_workflow_sn: str,
        release_stage_sn: str,
        execution_number: str,
        request: devops_20210625_models.RefuseReleaseStagePipelineValidateRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.RefuseReleaseStagePipelineValidateResponse:
        """
        @summary 拒绝人工卡点
        
        @param request: RefuseReleaseStagePipelineValidateRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: RefuseReleaseStagePipelineValidateResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['jobId'] = request.job_id
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='RefuseReleaseStagePipelineValidate',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/appstack/apps/{OpenApiUtilClient.get_encode_param(app_name)}/releaseWorkflows/{OpenApiUtilClient.get_encode_param(release_workflow_sn)}/releaseStages/{OpenApiUtilClient.get_encode_param(release_stage_sn)}/executions/{OpenApiUtilClient.get_encode_param(execution_number)}%3ArefusePipelineValidate',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.RefuseReleaseStagePipelineValidateResponse(),
            self.call_api(params, req, runtime)
        )

    async def refuse_release_stage_pipeline_validate_with_options_async(
        self,
        app_name: str,
        release_workflow_sn: str,
        release_stage_sn: str,
        execution_number: str,
        request: devops_20210625_models.RefuseReleaseStagePipelineValidateRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.RefuseReleaseStagePipelineValidateResponse:
        """
        @summary 拒绝人工卡点
        
        @param request: RefuseReleaseStagePipelineValidateRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: RefuseReleaseStagePipelineValidateResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.job_id):
            query['jobId'] = request.job_id
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='RefuseReleaseStagePipelineValidate',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/appstack/apps/{OpenApiUtilClient.get_encode_param(app_name)}/releaseWorkflows/{OpenApiUtilClient.get_encode_param(release_workflow_sn)}/releaseStages/{OpenApiUtilClient.get_encode_param(release_stage_sn)}/executions/{OpenApiUtilClient.get_encode_param(execution_number)}%3ArefusePipelineValidate',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.RefuseReleaseStagePipelineValidateResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def refuse_release_stage_pipeline_validate(
        self,
        app_name: str,
        release_workflow_sn: str,
        release_stage_sn: str,
        execution_number: str,
        request: devops_20210625_models.RefuseReleaseStagePipelineValidateRequest,
    ) -> devops_20210625_models.RefuseReleaseStagePipelineValidateResponse:
        """
        @summary 拒绝人工卡点
        
        @param request: RefuseReleaseStagePipelineValidateRequest
        @return: RefuseReleaseStagePipelineValidateResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.refuse_release_stage_pipeline_validate_with_options(app_name, release_workflow_sn, release_stage_sn, execution_number, request, headers, runtime)

    async def refuse_release_stage_pipeline_validate_async(
        self,
        app_name: str,
        release_workflow_sn: str,
        release_stage_sn: str,
        execution_number: str,
        request: devops_20210625_models.RefuseReleaseStagePipelineValidateRequest,
    ) -> devops_20210625_models.RefuseReleaseStagePipelineValidateResponse:
        """
        @summary 拒绝人工卡点
        
        @param request: RefuseReleaseStagePipelineValidateRequest
        @return: RefuseReleaseStagePipelineValidateResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.refuse_release_stage_pipeline_validate_with_options_async(app_name, release_workflow_sn, release_stage_sn, execution_number, request, headers, runtime)

    def reopen_merge_request_with_options(
        self,
        repository_id: str,
        local_id: str,
        request: devops_20210625_models.ReopenMergeRequestRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ReopenMergeRequestResponse:
        """
        @summary 重新打开代码评审
        
        @param request: ReopenMergeRequestRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ReopenMergeRequestResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ReopenMergeRequest',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/{OpenApiUtilClient.get_encode_param(repository_id)}/merge_requests/{OpenApiUtilClient.get_encode_param(local_id)}/reopen',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ReopenMergeRequestResponse(),
            self.call_api(params, req, runtime)
        )

    async def reopen_merge_request_with_options_async(
        self,
        repository_id: str,
        local_id: str,
        request: devops_20210625_models.ReopenMergeRequestRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ReopenMergeRequestResponse:
        """
        @summary 重新打开代码评审
        
        @param request: ReopenMergeRequestRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ReopenMergeRequestResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ReopenMergeRequest',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/{OpenApiUtilClient.get_encode_param(repository_id)}/merge_requests/{OpenApiUtilClient.get_encode_param(local_id)}/reopen',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ReopenMergeRequestResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def reopen_merge_request(
        self,
        repository_id: str,
        local_id: str,
        request: devops_20210625_models.ReopenMergeRequestRequest,
    ) -> devops_20210625_models.ReopenMergeRequestResponse:
        """
        @summary 重新打开代码评审
        
        @param request: ReopenMergeRequestRequest
        @return: ReopenMergeRequestResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.reopen_merge_request_with_options(repository_id, local_id, request, headers, runtime)

    async def reopen_merge_request_async(
        self,
        repository_id: str,
        local_id: str,
        request: devops_20210625_models.ReopenMergeRequestRequest,
    ) -> devops_20210625_models.ReopenMergeRequestResponse:
        """
        @summary 重新打开代码评审
        
        @param request: ReopenMergeRequestRequest
        @return: ReopenMergeRequestResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.reopen_merge_request_with_options_async(repository_id, local_id, request, headers, runtime)

    def reset_ssh_key_with_options(
        self,
        organization_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ResetSshKeyResponse:
        """
        @summary 重置企业公钥
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ResetSshKeyResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='ResetSshKey',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/sshKey',
            method='PUT',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ResetSshKeyResponse(),
            self.call_api(params, req, runtime)
        )

    async def reset_ssh_key_with_options_async(
        self,
        organization_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ResetSshKeyResponse:
        """
        @summary 重置企业公钥
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ResetSshKeyResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='ResetSshKey',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/sshKey',
            method='PUT',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ResetSshKeyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def reset_ssh_key(
        self,
        organization_id: str,
    ) -> devops_20210625_models.ResetSshKeyResponse:
        """
        @summary 重置企业公钥
        
        @return: ResetSshKeyResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.reset_ssh_key_with_options(organization_id, headers, runtime)

    async def reset_ssh_key_async(
        self,
        organization_id: str,
    ) -> devops_20210625_models.ResetSshKeyResponse:
        """
        @summary 重置企业公钥
        
        @return: ResetSshKeyResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.reset_ssh_key_with_options_async(organization_id, headers, runtime)

    def resume_vmdeploy_order_with_options(
        self,
        organization_id: str,
        pipeline_id: str,
        deploy_order_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ResumeVMDeployOrderResponse:
        """
        @summary 继续部署
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ResumeVMDeployOrderResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='ResumeVMDeployOrder',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines/{OpenApiUtilClient.get_encode_param(pipeline_id)}/deploy/{OpenApiUtilClient.get_encode_param(deploy_order_id)}/resume',
            method='PUT',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ResumeVMDeployOrderResponse(),
            self.call_api(params, req, runtime)
        )

    async def resume_vmdeploy_order_with_options_async(
        self,
        organization_id: str,
        pipeline_id: str,
        deploy_order_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ResumeVMDeployOrderResponse:
        """
        @summary 继续部署
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ResumeVMDeployOrderResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='ResumeVMDeployOrder',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines/{OpenApiUtilClient.get_encode_param(pipeline_id)}/deploy/{OpenApiUtilClient.get_encode_param(deploy_order_id)}/resume',
            method='PUT',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ResumeVMDeployOrderResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def resume_vmdeploy_order(
        self,
        organization_id: str,
        pipeline_id: str,
        deploy_order_id: str,
    ) -> devops_20210625_models.ResumeVMDeployOrderResponse:
        """
        @summary 继续部署
        
        @return: ResumeVMDeployOrderResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.resume_vmdeploy_order_with_options(organization_id, pipeline_id, deploy_order_id, headers, runtime)

    async def resume_vmdeploy_order_async(
        self,
        organization_id: str,
        pipeline_id: str,
        deploy_order_id: str,
    ) -> devops_20210625_models.ResumeVMDeployOrderResponse:
        """
        @summary 继续部署
        
        @return: ResumeVMDeployOrderResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.resume_vmdeploy_order_with_options_async(organization_id, pipeline_id, deploy_order_id, headers, runtime)

    def retry_pipeline_job_run_with_options(
        self,
        organization_id: str,
        pipeline_id: str,
        pipeline_run_id: str,
        job_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.RetryPipelineJobRunResponse:
        """
        @summary 重试流水线运行
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: RetryPipelineJobRunResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='RetryPipelineJobRun',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines/{OpenApiUtilClient.get_encode_param(pipeline_id)}/pipelineRuns/{OpenApiUtilClient.get_encode_param(pipeline_run_id)}/jobs/{OpenApiUtilClient.get_encode_param(job_id)}',
            method='PUT',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.RetryPipelineJobRunResponse(),
            self.call_api(params, req, runtime)
        )

    async def retry_pipeline_job_run_with_options_async(
        self,
        organization_id: str,
        pipeline_id: str,
        pipeline_run_id: str,
        job_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.RetryPipelineJobRunResponse:
        """
        @summary 重试流水线运行
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: RetryPipelineJobRunResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='RetryPipelineJobRun',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines/{OpenApiUtilClient.get_encode_param(pipeline_id)}/pipelineRuns/{OpenApiUtilClient.get_encode_param(pipeline_run_id)}/jobs/{OpenApiUtilClient.get_encode_param(job_id)}',
            method='PUT',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.RetryPipelineJobRunResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def retry_pipeline_job_run(
        self,
        organization_id: str,
        pipeline_id: str,
        pipeline_run_id: str,
        job_id: str,
    ) -> devops_20210625_models.RetryPipelineJobRunResponse:
        """
        @summary 重试流水线运行
        
        @return: RetryPipelineJobRunResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.retry_pipeline_job_run_with_options(organization_id, pipeline_id, pipeline_run_id, job_id, headers, runtime)

    async def retry_pipeline_job_run_async(
        self,
        organization_id: str,
        pipeline_id: str,
        pipeline_run_id: str,
        job_id: str,
    ) -> devops_20210625_models.RetryPipelineJobRunResponse:
        """
        @summary 重试流水线运行
        
        @return: RetryPipelineJobRunResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.retry_pipeline_job_run_with_options_async(organization_id, pipeline_id, pipeline_run_id, job_id, headers, runtime)

    def retry_vmdeploy_machine_with_options(
        self,
        organization_id: str,
        pipeline_id: str,
        deploy_order_id: str,
        machine_sn: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.RetryVMDeployMachineResponse:
        """
        @summary 重试机器部署
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: RetryVMDeployMachineResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='RetryVMDeployMachine',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines/{OpenApiUtilClient.get_encode_param(pipeline_id)}/deploy/{OpenApiUtilClient.get_encode_param(deploy_order_id)}/machine/{OpenApiUtilClient.get_encode_param(machine_sn)}/retry',
            method='PUT',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.RetryVMDeployMachineResponse(),
            self.call_api(params, req, runtime)
        )

    async def retry_vmdeploy_machine_with_options_async(
        self,
        organization_id: str,
        pipeline_id: str,
        deploy_order_id: str,
        machine_sn: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.RetryVMDeployMachineResponse:
        """
        @summary 重试机器部署
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: RetryVMDeployMachineResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='RetryVMDeployMachine',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines/{OpenApiUtilClient.get_encode_param(pipeline_id)}/deploy/{OpenApiUtilClient.get_encode_param(deploy_order_id)}/machine/{OpenApiUtilClient.get_encode_param(machine_sn)}/retry',
            method='PUT',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.RetryVMDeployMachineResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def retry_vmdeploy_machine(
        self,
        organization_id: str,
        pipeline_id: str,
        deploy_order_id: str,
        machine_sn: str,
    ) -> devops_20210625_models.RetryVMDeployMachineResponse:
        """
        @summary 重试机器部署
        
        @return: RetryVMDeployMachineResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.retry_vmdeploy_machine_with_options(organization_id, pipeline_id, deploy_order_id, machine_sn, headers, runtime)

    async def retry_vmdeploy_machine_async(
        self,
        organization_id: str,
        pipeline_id: str,
        deploy_order_id: str,
        machine_sn: str,
    ) -> devops_20210625_models.RetryVMDeployMachineResponse:
        """
        @summary 重试机器部署
        
        @return: RetryVMDeployMachineResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.retry_vmdeploy_machine_with_options_async(organization_id, pipeline_id, deploy_order_id, machine_sn, headers, runtime)

    def review_merge_request_with_options(
        self,
        repository_id: str,
        local_id: str,
        request: devops_20210625_models.ReviewMergeRequestRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ReviewMergeRequestResponse:
        """
        @summary 提交变更请求的评审意见
        
        @param request: ReviewMergeRequestRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ReviewMergeRequestResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.draft_comment_ids):
            body['draftCommentIds'] = request.draft_comment_ids
        if not UtilClient.is_unset(request.review_comment):
            body['reviewComment'] = request.review_comment
        if not UtilClient.is_unset(request.review_opinion):
            body['reviewOpinion'] = request.review_opinion
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ReviewMergeRequest',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/{OpenApiUtilClient.get_encode_param(repository_id)}/merge_requests/{OpenApiUtilClient.get_encode_param(local_id)}/submit_review_opinion',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ReviewMergeRequestResponse(),
            self.call_api(params, req, runtime)
        )

    async def review_merge_request_with_options_async(
        self,
        repository_id: str,
        local_id: str,
        request: devops_20210625_models.ReviewMergeRequestRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.ReviewMergeRequestResponse:
        """
        @summary 提交变更请求的评审意见
        
        @param request: ReviewMergeRequestRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: ReviewMergeRequestResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.draft_comment_ids):
            body['draftCommentIds'] = request.draft_comment_ids
        if not UtilClient.is_unset(request.review_comment):
            body['reviewComment'] = request.review_comment
        if not UtilClient.is_unset(request.review_opinion):
            body['reviewOpinion'] = request.review_opinion
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ReviewMergeRequest',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/{OpenApiUtilClient.get_encode_param(repository_id)}/merge_requests/{OpenApiUtilClient.get_encode_param(local_id)}/submit_review_opinion',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.ReviewMergeRequestResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def review_merge_request(
        self,
        repository_id: str,
        local_id: str,
        request: devops_20210625_models.ReviewMergeRequestRequest,
    ) -> devops_20210625_models.ReviewMergeRequestResponse:
        """
        @summary 提交变更请求的评审意见
        
        @param request: ReviewMergeRequestRequest
        @return: ReviewMergeRequestResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.review_merge_request_with_options(repository_id, local_id, request, headers, runtime)

    async def review_merge_request_async(
        self,
        repository_id: str,
        local_id: str,
        request: devops_20210625_models.ReviewMergeRequestRequest,
    ) -> devops_20210625_models.ReviewMergeRequestResponse:
        """
        @summary 提交变更请求的评审意见
        
        @param request: ReviewMergeRequestRequest
        @return: ReviewMergeRequestResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.review_merge_request_with_options_async(repository_id, local_id, request, headers, runtime)

    def skip_pipeline_job_run_with_options(
        self,
        organization_id: str,
        pipeline_id: str,
        pipeline_run_id: str,
        job_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.SkipPipelineJobRunResponse:
        """
        @summary 跳过流水线任务运行
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: SkipPipelineJobRunResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='SkipPipelineJobRun',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines/{OpenApiUtilClient.get_encode_param(pipeline_id)}/pipelineRuns/{OpenApiUtilClient.get_encode_param(pipeline_run_id)}/jobs/{OpenApiUtilClient.get_encode_param(job_id)}/skip',
            method='PUT',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.SkipPipelineJobRunResponse(),
            self.call_api(params, req, runtime)
        )

    async def skip_pipeline_job_run_with_options_async(
        self,
        organization_id: str,
        pipeline_id: str,
        pipeline_run_id: str,
        job_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.SkipPipelineJobRunResponse:
        """
        @summary 跳过流水线任务运行
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: SkipPipelineJobRunResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='SkipPipelineJobRun',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines/{OpenApiUtilClient.get_encode_param(pipeline_id)}/pipelineRuns/{OpenApiUtilClient.get_encode_param(pipeline_run_id)}/jobs/{OpenApiUtilClient.get_encode_param(job_id)}/skip',
            method='PUT',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.SkipPipelineJobRunResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def skip_pipeline_job_run(
        self,
        organization_id: str,
        pipeline_id: str,
        pipeline_run_id: str,
        job_id: str,
    ) -> devops_20210625_models.SkipPipelineJobRunResponse:
        """
        @summary 跳过流水线任务运行
        
        @return: SkipPipelineJobRunResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.skip_pipeline_job_run_with_options(organization_id, pipeline_id, pipeline_run_id, job_id, headers, runtime)

    async def skip_pipeline_job_run_async(
        self,
        organization_id: str,
        pipeline_id: str,
        pipeline_run_id: str,
        job_id: str,
    ) -> devops_20210625_models.SkipPipelineJobRunResponse:
        """
        @summary 跳过流水线任务运行
        
        @return: SkipPipelineJobRunResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.skip_pipeline_job_run_with_options_async(organization_id, pipeline_id, pipeline_run_id, job_id, headers, runtime)

    def skip_vmdeploy_machine_with_options(
        self,
        organization_id: str,
        pipeline_id: str,
        deploy_order_id: str,
        machine_sn: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.SkipVMDeployMachineResponse:
        """
        @summary 跳过机器部署
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: SkipVMDeployMachineResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='SkipVMDeployMachine',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines/{OpenApiUtilClient.get_encode_param(pipeline_id)}/deploy/{OpenApiUtilClient.get_encode_param(deploy_order_id)}/machine/{OpenApiUtilClient.get_encode_param(machine_sn)}/skip',
            method='PUT',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.SkipVMDeployMachineResponse(),
            self.call_api(params, req, runtime)
        )

    async def skip_vmdeploy_machine_with_options_async(
        self,
        organization_id: str,
        pipeline_id: str,
        deploy_order_id: str,
        machine_sn: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.SkipVMDeployMachineResponse:
        """
        @summary 跳过机器部署
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: SkipVMDeployMachineResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='SkipVMDeployMachine',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines/{OpenApiUtilClient.get_encode_param(pipeline_id)}/deploy/{OpenApiUtilClient.get_encode_param(deploy_order_id)}/machine/{OpenApiUtilClient.get_encode_param(machine_sn)}/skip',
            method='PUT',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.SkipVMDeployMachineResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def skip_vmdeploy_machine(
        self,
        organization_id: str,
        pipeline_id: str,
        deploy_order_id: str,
        machine_sn: str,
    ) -> devops_20210625_models.SkipVMDeployMachineResponse:
        """
        @summary 跳过机器部署
        
        @return: SkipVMDeployMachineResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.skip_vmdeploy_machine_with_options(organization_id, pipeline_id, deploy_order_id, machine_sn, headers, runtime)

    async def skip_vmdeploy_machine_async(
        self,
        organization_id: str,
        pipeline_id: str,
        deploy_order_id: str,
        machine_sn: str,
    ) -> devops_20210625_models.SkipVMDeployMachineResponse:
        """
        @summary 跳过机器部署
        
        @return: SkipVMDeployMachineResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.skip_vmdeploy_machine_with_options_async(organization_id, pipeline_id, deploy_order_id, machine_sn, headers, runtime)

    def start_pipeline_run_with_options(
        self,
        organization_id: str,
        pipeline_id: str,
        request: devops_20210625_models.StartPipelineRunRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.StartPipelineRunResponse:
        """
        @summary 运行流水线
        
        @param request: StartPipelineRunRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: StartPipelineRunResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.params):
            body['params'] = request.params
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='StartPipelineRun',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organizations/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines/{OpenApiUtilClient.get_encode_param(pipeline_id)}/run',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.StartPipelineRunResponse(),
            self.call_api(params, req, runtime)
        )

    async def start_pipeline_run_with_options_async(
        self,
        organization_id: str,
        pipeline_id: str,
        request: devops_20210625_models.StartPipelineRunRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.StartPipelineRunResponse:
        """
        @summary 运行流水线
        
        @param request: StartPipelineRunRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: StartPipelineRunResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.params):
            body['params'] = request.params
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='StartPipelineRun',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organizations/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines/{OpenApiUtilClient.get_encode_param(pipeline_id)}/run',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.StartPipelineRunResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def start_pipeline_run(
        self,
        organization_id: str,
        pipeline_id: str,
        request: devops_20210625_models.StartPipelineRunRequest,
    ) -> devops_20210625_models.StartPipelineRunResponse:
        """
        @summary 运行流水线
        
        @param request: StartPipelineRunRequest
        @return: StartPipelineRunResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.start_pipeline_run_with_options(organization_id, pipeline_id, request, headers, runtime)

    async def start_pipeline_run_async(
        self,
        organization_id: str,
        pipeline_id: str,
        request: devops_20210625_models.StartPipelineRunRequest,
    ) -> devops_20210625_models.StartPipelineRunResponse:
        """
        @summary 运行流水线
        
        @param request: StartPipelineRunRequest
        @return: StartPipelineRunResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.start_pipeline_run_with_options_async(organization_id, pipeline_id, request, headers, runtime)

    def stop_pipeline_job_run_with_options(
        self,
        organization_id: str,
        pipeline_id: str,
        pipeline_run_id: str,
        job_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.StopPipelineJobRunResponse:
        """
        @summary 终止流水线任务运行
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: StopPipelineJobRunResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='StopPipelineJobRun',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines/{OpenApiUtilClient.get_encode_param(pipeline_id)}/pipelineRuns/{OpenApiUtilClient.get_encode_param(pipeline_run_id)}/jobs/{OpenApiUtilClient.get_encode_param(job_id)}/stop',
            method='PUT',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.StopPipelineJobRunResponse(),
            self.call_api(params, req, runtime)
        )

    async def stop_pipeline_job_run_with_options_async(
        self,
        organization_id: str,
        pipeline_id: str,
        pipeline_run_id: str,
        job_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.StopPipelineJobRunResponse:
        """
        @summary 终止流水线任务运行
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: StopPipelineJobRunResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='StopPipelineJobRun',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines/{OpenApiUtilClient.get_encode_param(pipeline_id)}/pipelineRuns/{OpenApiUtilClient.get_encode_param(pipeline_run_id)}/jobs/{OpenApiUtilClient.get_encode_param(job_id)}/stop',
            method='PUT',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.StopPipelineJobRunResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def stop_pipeline_job_run(
        self,
        organization_id: str,
        pipeline_id: str,
        pipeline_run_id: str,
        job_id: str,
    ) -> devops_20210625_models.StopPipelineJobRunResponse:
        """
        @summary 终止流水线任务运行
        
        @return: StopPipelineJobRunResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.stop_pipeline_job_run_with_options(organization_id, pipeline_id, pipeline_run_id, job_id, headers, runtime)

    async def stop_pipeline_job_run_async(
        self,
        organization_id: str,
        pipeline_id: str,
        pipeline_run_id: str,
        job_id: str,
    ) -> devops_20210625_models.StopPipelineJobRunResponse:
        """
        @summary 终止流水线任务运行
        
        @return: StopPipelineJobRunResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.stop_pipeline_job_run_with_options_async(organization_id, pipeline_id, pipeline_run_id, job_id, headers, runtime)

    def stop_pipeline_run_with_options(
        self,
        organization_id: str,
        pipeline_id: str,
        pipeline_run_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.StopPipelineRunResponse:
        """
        @summary 终止流水线运行
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: StopPipelineRunResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='StopPipelineRun',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines/{OpenApiUtilClient.get_encode_param(pipeline_id)}/pipelineRuns/{OpenApiUtilClient.get_encode_param(pipeline_run_id)}/stop',
            method='PUT',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.StopPipelineRunResponse(),
            self.call_api(params, req, runtime)
        )

    async def stop_pipeline_run_with_options_async(
        self,
        organization_id: str,
        pipeline_id: str,
        pipeline_run_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.StopPipelineRunResponse:
        """
        @summary 终止流水线运行
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: StopPipelineRunResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='StopPipelineRun',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines/{OpenApiUtilClient.get_encode_param(pipeline_id)}/pipelineRuns/{OpenApiUtilClient.get_encode_param(pipeline_run_id)}/stop',
            method='PUT',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.StopPipelineRunResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def stop_pipeline_run(
        self,
        organization_id: str,
        pipeline_id: str,
        pipeline_run_id: str,
    ) -> devops_20210625_models.StopPipelineRunResponse:
        """
        @summary 终止流水线运行
        
        @return: StopPipelineRunResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.stop_pipeline_run_with_options(organization_id, pipeline_id, pipeline_run_id, headers, runtime)

    async def stop_pipeline_run_async(
        self,
        organization_id: str,
        pipeline_id: str,
        pipeline_run_id: str,
    ) -> devops_20210625_models.StopPipelineRunResponse:
        """
        @summary 终止流水线运行
        
        @return: StopPipelineRunResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.stop_pipeline_run_with_options_async(organization_id, pipeline_id, pipeline_run_id, headers, runtime)

    def stop_vmdeploy_order_with_options(
        self,
        organization_id: str,
        pipeline_id: str,
        deploy_order_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.StopVMDeployOrderResponse:
        """
        @summary 取消部署单
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: StopVMDeployOrderResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='StopVMDeployOrder',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines/{OpenApiUtilClient.get_encode_param(pipeline_id)}/deploy/{OpenApiUtilClient.get_encode_param(deploy_order_id)}/stop',
            method='PUT',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.StopVMDeployOrderResponse(),
            self.call_api(params, req, runtime)
        )

    async def stop_vmdeploy_order_with_options_async(
        self,
        organization_id: str,
        pipeline_id: str,
        deploy_order_id: str,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.StopVMDeployOrderResponse:
        """
        @summary 取消部署单
        
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: StopVMDeployOrderResponse
        """
        req = open_api_models.OpenApiRequest(
            headers=headers
        )
        params = open_api_models.Params(
            action='StopVMDeployOrder',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/pipelines/{OpenApiUtilClient.get_encode_param(pipeline_id)}/deploy/{OpenApiUtilClient.get_encode_param(deploy_order_id)}/stop',
            method='PUT',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.StopVMDeployOrderResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def stop_vmdeploy_order(
        self,
        organization_id: str,
        pipeline_id: str,
        deploy_order_id: str,
    ) -> devops_20210625_models.StopVMDeployOrderResponse:
        """
        @summary 取消部署单
        
        @return: StopVMDeployOrderResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.stop_vmdeploy_order_with_options(organization_id, pipeline_id, deploy_order_id, headers, runtime)

    async def stop_vmdeploy_order_async(
        self,
        organization_id: str,
        pipeline_id: str,
        deploy_order_id: str,
    ) -> devops_20210625_models.StopVMDeployOrderResponse:
        """
        @summary 取消部署单
        
        @return: StopVMDeployOrderResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.stop_vmdeploy_order_with_options_async(organization_id, pipeline_id, deploy_order_id, headers, runtime)

    def transfer_repository_with_options(
        self,
        request: devops_20210625_models.TransferRepositoryRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.TransferRepositoryResponse:
        """
        @summary 转移代码库
        
        @param request: TransferRepositoryRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: TransferRepositoryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.group_id):
            query['groupId'] = request.group_id
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.repository_id):
            query['repositoryId'] = request.repository_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='TransferRepository',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/repository/transfer',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.TransferRepositoryResponse(),
            self.call_api(params, req, runtime)
        )

    async def transfer_repository_with_options_async(
        self,
        request: devops_20210625_models.TransferRepositoryRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.TransferRepositoryResponse:
        """
        @summary 转移代码库
        
        @param request: TransferRepositoryRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: TransferRepositoryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.group_id):
            query['groupId'] = request.group_id
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.repository_id):
            query['repositoryId'] = request.repository_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='TransferRepository',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/repository/transfer',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.TransferRepositoryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def transfer_repository(
        self,
        request: devops_20210625_models.TransferRepositoryRequest,
    ) -> devops_20210625_models.TransferRepositoryResponse:
        """
        @summary 转移代码库
        
        @param request: TransferRepositoryRequest
        @return: TransferRepositoryResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.transfer_repository_with_options(request, headers, runtime)

    async def transfer_repository_async(
        self,
        request: devops_20210625_models.TransferRepositoryRequest,
    ) -> devops_20210625_models.TransferRepositoryResponse:
        """
        @summary 转移代码库
        
        @param request: TransferRepositoryRequest
        @return: TransferRepositoryResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.transfer_repository_with_options_async(request, headers, runtime)

    def trigger_repository_mirror_sync_with_options(
        self,
        repository_id: str,
        request: devops_20210625_models.TriggerRepositoryMirrorSyncRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.TriggerRepositoryMirrorSyncResponse:
        """
        @summary 触发仓库同步
        
        @param request: TriggerRepositoryMirrorSyncRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: TriggerRepositoryMirrorSyncResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.account):
            query['account'] = request.account
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.token):
            query['token'] = request.token
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='TriggerRepositoryMirrorSync',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/mirror',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.TriggerRepositoryMirrorSyncResponse(),
            self.call_api(params, req, runtime)
        )

    async def trigger_repository_mirror_sync_with_options_async(
        self,
        repository_id: str,
        request: devops_20210625_models.TriggerRepositoryMirrorSyncRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.TriggerRepositoryMirrorSyncResponse:
        """
        @summary 触发仓库同步
        
        @param request: TriggerRepositoryMirrorSyncRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: TriggerRepositoryMirrorSyncResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.account):
            query['account'] = request.account
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.token):
            query['token'] = request.token
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='TriggerRepositoryMirrorSync',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/mirror',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.TriggerRepositoryMirrorSyncResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def trigger_repository_mirror_sync(
        self,
        repository_id: str,
        request: devops_20210625_models.TriggerRepositoryMirrorSyncRequest,
    ) -> devops_20210625_models.TriggerRepositoryMirrorSyncResponse:
        """
        @summary 触发仓库同步
        
        @param request: TriggerRepositoryMirrorSyncRequest
        @return: TriggerRepositoryMirrorSyncResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.trigger_repository_mirror_sync_with_options(repository_id, request, headers, runtime)

    async def trigger_repository_mirror_sync_async(
        self,
        repository_id: str,
        request: devops_20210625_models.TriggerRepositoryMirrorSyncRequest,
    ) -> devops_20210625_models.TriggerRepositoryMirrorSyncResponse:
        """
        @summary 触发仓库同步
        
        @param request: TriggerRepositoryMirrorSyncRequest
        @return: TriggerRepositoryMirrorSyncResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.trigger_repository_mirror_sync_with_options_async(repository_id, request, headers, runtime)

    def update_app_member_with_options(
        self,
        app_name: str,
        request: devops_20210625_models.UpdateAppMemberRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.UpdateAppMemberResponse:
        """
        @summary 更新应用成员
        
        @param request: UpdateAppMemberRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateAppMemberResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.player):
            body['player'] = request.player
        if not UtilClient.is_unset(request.role_names):
            body['roleNames'] = request.role_names
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='UpdateAppMember',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/appstack/apps/{OpenApiUtilClient.get_encode_param(app_name)}/members',
            method='PUT',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='string'
        )
        return TeaCore.from_map(
            devops_20210625_models.UpdateAppMemberResponse(),
            self.call_api(params, req, runtime)
        )

    async def update_app_member_with_options_async(
        self,
        app_name: str,
        request: devops_20210625_models.UpdateAppMemberRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.UpdateAppMemberResponse:
        """
        @summary 更新应用成员
        
        @param request: UpdateAppMemberRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateAppMemberResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.player):
            body['player'] = request.player
        if not UtilClient.is_unset(request.role_names):
            body['roleNames'] = request.role_names
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='UpdateAppMember',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/appstack/apps/{OpenApiUtilClient.get_encode_param(app_name)}/members',
            method='PUT',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='string'
        )
        return TeaCore.from_map(
            devops_20210625_models.UpdateAppMemberResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def update_app_member(
        self,
        app_name: str,
        request: devops_20210625_models.UpdateAppMemberRequest,
    ) -> devops_20210625_models.UpdateAppMemberResponse:
        """
        @summary 更新应用成员
        
        @param request: UpdateAppMemberRequest
        @return: UpdateAppMemberResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.update_app_member_with_options(app_name, request, headers, runtime)

    async def update_app_member_async(
        self,
        app_name: str,
        request: devops_20210625_models.UpdateAppMemberRequest,
    ) -> devops_20210625_models.UpdateAppMemberResponse:
        """
        @summary 更新应用成员
        
        @param request: UpdateAppMemberRequest
        @return: UpdateAppMemberResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.update_app_member_with_options_async(app_name, request, headers, runtime)

    def update_application_with_options(
        self,
        app_name: str,
        request: devops_20210625_models.UpdateApplicationRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.UpdateApplicationResponse:
        """
        @summary 更新应用
        
        @param request: UpdateApplicationRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateApplicationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.owner_account_id):
            body['ownerAccountId'] = request.owner_account_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='UpdateApplication',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/appstack/apps/{OpenApiUtilClient.get_encode_param(app_name)}',
            method='PUT',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.UpdateApplicationResponse(),
            self.call_api(params, req, runtime)
        )

    async def update_application_with_options_async(
        self,
        app_name: str,
        request: devops_20210625_models.UpdateApplicationRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.UpdateApplicationResponse:
        """
        @summary 更新应用
        
        @param request: UpdateApplicationRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateApplicationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.owner_account_id):
            body['ownerAccountId'] = request.owner_account_id
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='UpdateApplication',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/appstack/apps/{OpenApiUtilClient.get_encode_param(app_name)}',
            method='PUT',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.UpdateApplicationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def update_application(
        self,
        app_name: str,
        request: devops_20210625_models.UpdateApplicationRequest,
    ) -> devops_20210625_models.UpdateApplicationResponse:
        """
        @summary 更新应用
        
        @param request: UpdateApplicationRequest
        @return: UpdateApplicationResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.update_application_with_options(app_name, request, headers, runtime)

    async def update_application_async(
        self,
        app_name: str,
        request: devops_20210625_models.UpdateApplicationRequest,
    ) -> devops_20210625_models.UpdateApplicationResponse:
        """
        @summary 更新应用
        
        @param request: UpdateApplicationRequest
        @return: UpdateApplicationResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.update_application_with_options_async(app_name, request, headers, runtime)

    def update_check_run_with_options(
        self,
        request: devops_20210625_models.UpdateCheckRunRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.UpdateCheckRunResponse:
        """
        @summary 更新检查运行记录
        
        @param request: UpdateCheckRunRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateCheckRunResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.check_run_id):
            query['checkRunId'] = request.check_run_id
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.repository_identity):
            query['repositoryIdentity'] = request.repository_identity
        body = {}
        if not UtilClient.is_unset(request.annotations):
            body['annotations'] = request.annotations
        if not UtilClient.is_unset(request.completed_at):
            body['completedAt'] = request.completed_at
        if not UtilClient.is_unset(request.conclusion):
            body['conclusion'] = request.conclusion
        if not UtilClient.is_unset(request.details_url):
            body['detailsUrl'] = request.details_url
        if not UtilClient.is_unset(request.external_id):
            body['externalId'] = request.external_id
        if not UtilClient.is_unset(request.name):
            body['name'] = request.name
        if not UtilClient.is_unset(request.output):
            body['output'] = request.output
        if not UtilClient.is_unset(request.started_at):
            body['startedAt'] = request.started_at
        if not UtilClient.is_unset(request.status):
            body['status'] = request.status
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='UpdateCheckRun',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/check_runs/update_check_run',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.UpdateCheckRunResponse(),
            self.call_api(params, req, runtime)
        )

    async def update_check_run_with_options_async(
        self,
        request: devops_20210625_models.UpdateCheckRunRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.UpdateCheckRunResponse:
        """
        @summary 更新检查运行记录
        
        @param request: UpdateCheckRunRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateCheckRunResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.check_run_id):
            query['checkRunId'] = request.check_run_id
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        if not UtilClient.is_unset(request.repository_identity):
            query['repositoryIdentity'] = request.repository_identity
        body = {}
        if not UtilClient.is_unset(request.annotations):
            body['annotations'] = request.annotations
        if not UtilClient.is_unset(request.completed_at):
            body['completedAt'] = request.completed_at
        if not UtilClient.is_unset(request.conclusion):
            body['conclusion'] = request.conclusion
        if not UtilClient.is_unset(request.details_url):
            body['detailsUrl'] = request.details_url
        if not UtilClient.is_unset(request.external_id):
            body['externalId'] = request.external_id
        if not UtilClient.is_unset(request.name):
            body['name'] = request.name
        if not UtilClient.is_unset(request.output):
            body['output'] = request.output
        if not UtilClient.is_unset(request.started_at):
            body['startedAt'] = request.started_at
        if not UtilClient.is_unset(request.status):
            body['status'] = request.status
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='UpdateCheckRun',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/check_runs/update_check_run',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.UpdateCheckRunResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def update_check_run(
        self,
        request: devops_20210625_models.UpdateCheckRunRequest,
    ) -> devops_20210625_models.UpdateCheckRunResponse:
        """
        @summary 更新检查运行记录
        
        @param request: UpdateCheckRunRequest
        @return: UpdateCheckRunResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.update_check_run_with_options(request, headers, runtime)

    async def update_check_run_async(
        self,
        request: devops_20210625_models.UpdateCheckRunRequest,
    ) -> devops_20210625_models.UpdateCheckRunResponse:
        """
        @summary 更新检查运行记录
        
        @param request: UpdateCheckRunRequest
        @return: UpdateCheckRunResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.update_check_run_with_options_async(request, headers, runtime)

    def update_file_with_options(
        self,
        repository_id: str,
        request: devops_20210625_models.UpdateFileRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.UpdateFileResponse:
        """
        @summary 更新代码库文件
        
        @param request: UpdateFileRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateFileResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.branch_name):
            body['branchName'] = request.branch_name
        if not UtilClient.is_unset(request.commit_message):
            body['commitMessage'] = request.commit_message
        if not UtilClient.is_unset(request.content):
            body['content'] = request.content
        if not UtilClient.is_unset(request.encoding):
            body['encoding'] = request.encoding
        if not UtilClient.is_unset(request.new_path):
            body['newPath'] = request.new_path
        if not UtilClient.is_unset(request.old_path):
            body['oldPath'] = request.old_path
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='UpdateFile',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/files/update',
            method='PUT',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.UpdateFileResponse(),
            self.call_api(params, req, runtime)
        )

    async def update_file_with_options_async(
        self,
        repository_id: str,
        request: devops_20210625_models.UpdateFileRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.UpdateFileResponse:
        """
        @summary 更新代码库文件
        
        @param request: UpdateFileRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateFileResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.branch_name):
            body['branchName'] = request.branch_name
        if not UtilClient.is_unset(request.commit_message):
            body['commitMessage'] = request.commit_message
        if not UtilClient.is_unset(request.content):
            body['content'] = request.content
        if not UtilClient.is_unset(request.encoding):
            body['encoding'] = request.encoding
        if not UtilClient.is_unset(request.new_path):
            body['newPath'] = request.new_path
        if not UtilClient.is_unset(request.old_path):
            body['oldPath'] = request.old_path
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='UpdateFile',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/{OpenApiUtilClient.get_encode_param(repository_id)}/files/update',
            method='PUT',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.UpdateFileResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def update_file(
        self,
        repository_id: str,
        request: devops_20210625_models.UpdateFileRequest,
    ) -> devops_20210625_models.UpdateFileResponse:
        """
        @summary 更新代码库文件
        
        @param request: UpdateFileRequest
        @return: UpdateFileResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.update_file_with_options(repository_id, request, headers, runtime)

    async def update_file_async(
        self,
        repository_id: str,
        request: devops_20210625_models.UpdateFileRequest,
    ) -> devops_20210625_models.UpdateFileResponse:
        """
        @summary 更新代码库文件
        
        @param request: UpdateFileRequest
        @return: UpdateFileResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.update_file_with_options_async(repository_id, request, headers, runtime)

    def update_flow_tag_with_options(
        self,
        organization_id: str,
        id: str,
        request: devops_20210625_models.UpdateFlowTagRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.UpdateFlowTagResponse:
        """
        @summary 更新标签
        
        @param request: UpdateFlowTagRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateFlowTagResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.color):
            query['color'] = request.color
        if not UtilClient.is_unset(request.flow_tag_group_id):
            query['flowTagGroupId'] = request.flow_tag_group_id
        if not UtilClient.is_unset(request.name):
            query['name'] = request.name
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='UpdateFlowTag',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/flow/tags/{OpenApiUtilClient.get_encode_param(id)}',
            method='PUT',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.UpdateFlowTagResponse(),
            self.call_api(params, req, runtime)
        )

    async def update_flow_tag_with_options_async(
        self,
        organization_id: str,
        id: str,
        request: devops_20210625_models.UpdateFlowTagRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.UpdateFlowTagResponse:
        """
        @summary 更新标签
        
        @param request: UpdateFlowTagRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateFlowTagResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.color):
            query['color'] = request.color
        if not UtilClient.is_unset(request.flow_tag_group_id):
            query['flowTagGroupId'] = request.flow_tag_group_id
        if not UtilClient.is_unset(request.name):
            query['name'] = request.name
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='UpdateFlowTag',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/flow/tags/{OpenApiUtilClient.get_encode_param(id)}',
            method='PUT',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.UpdateFlowTagResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def update_flow_tag(
        self,
        organization_id: str,
        id: str,
        request: devops_20210625_models.UpdateFlowTagRequest,
    ) -> devops_20210625_models.UpdateFlowTagResponse:
        """
        @summary 更新标签
        
        @param request: UpdateFlowTagRequest
        @return: UpdateFlowTagResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.update_flow_tag_with_options(organization_id, id, request, headers, runtime)

    async def update_flow_tag_async(
        self,
        organization_id: str,
        id: str,
        request: devops_20210625_models.UpdateFlowTagRequest,
    ) -> devops_20210625_models.UpdateFlowTagResponse:
        """
        @summary 更新标签
        
        @param request: UpdateFlowTagRequest
        @return: UpdateFlowTagResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.update_flow_tag_with_options_async(organization_id, id, request, headers, runtime)

    def update_flow_tag_group_with_options(
        self,
        organization_id: str,
        id: str,
        request: devops_20210625_models.UpdateFlowTagGroupRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.UpdateFlowTagGroupResponse:
        """
        @summary 标签分类
        
        @param request: UpdateFlowTagGroupRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateFlowTagGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.name):
            query['name'] = request.name
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='UpdateFlowTagGroup',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/flow/tagGroups/{OpenApiUtilClient.get_encode_param(id)}',
            method='PUT',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.UpdateFlowTagGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def update_flow_tag_group_with_options_async(
        self,
        organization_id: str,
        id: str,
        request: devops_20210625_models.UpdateFlowTagGroupRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.UpdateFlowTagGroupResponse:
        """
        @summary 标签分类
        
        @param request: UpdateFlowTagGroupRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateFlowTagGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.name):
            query['name'] = request.name
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='UpdateFlowTagGroup',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/flow/tagGroups/{OpenApiUtilClient.get_encode_param(id)}',
            method='PUT',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.UpdateFlowTagGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def update_flow_tag_group(
        self,
        organization_id: str,
        id: str,
        request: devops_20210625_models.UpdateFlowTagGroupRequest,
    ) -> devops_20210625_models.UpdateFlowTagGroupResponse:
        """
        @summary 标签分类
        
        @param request: UpdateFlowTagGroupRequest
        @return: UpdateFlowTagGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.update_flow_tag_group_with_options(organization_id, id, request, headers, runtime)

    async def update_flow_tag_group_async(
        self,
        organization_id: str,
        id: str,
        request: devops_20210625_models.UpdateFlowTagGroupRequest,
    ) -> devops_20210625_models.UpdateFlowTagGroupResponse:
        """
        @summary 标签分类
        
        @param request: UpdateFlowTagGroupRequest
        @return: UpdateFlowTagGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.update_flow_tag_group_with_options_async(organization_id, id, request, headers, runtime)

    def update_group_with_options(
        self,
        request: devops_20210625_models.UpdateGroupRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.UpdateGroupResponse:
        """
        @summary 更新单个代码组信息
        
        @param request: UpdateGroupRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.avatar_url):
            body['avatarUrl'] = request.avatar_url
        if not UtilClient.is_unset(request.description):
            body['description'] = request.description
        if not UtilClient.is_unset(request.name):
            body['name'] = request.name
        if not UtilClient.is_unset(request.path):
            body['path'] = request.path
        if not UtilClient.is_unset(request.path_with_namespace):
            body['pathWithNamespace'] = request.path_with_namespace
        if not UtilClient.is_unset(request.visibility_level):
            body['visibilityLevel'] = request.visibility_level
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='UpdateGroup',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/groups/modify',
            method='PUT',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.UpdateGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def update_group_with_options_async(
        self,
        request: devops_20210625_models.UpdateGroupRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.UpdateGroupResponse:
        """
        @summary 更新单个代码组信息
        
        @param request: UpdateGroupRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.avatar_url):
            body['avatarUrl'] = request.avatar_url
        if not UtilClient.is_unset(request.description):
            body['description'] = request.description
        if not UtilClient.is_unset(request.name):
            body['name'] = request.name
        if not UtilClient.is_unset(request.path):
            body['path'] = request.path
        if not UtilClient.is_unset(request.path_with_namespace):
            body['pathWithNamespace'] = request.path_with_namespace
        if not UtilClient.is_unset(request.visibility_level):
            body['visibilityLevel'] = request.visibility_level
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='UpdateGroup',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/groups/modify',
            method='PUT',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.UpdateGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def update_group(
        self,
        request: devops_20210625_models.UpdateGroupRequest,
    ) -> devops_20210625_models.UpdateGroupResponse:
        """
        @summary 更新单个代码组信息
        
        @param request: UpdateGroupRequest
        @return: UpdateGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.update_group_with_options(request, headers, runtime)

    async def update_group_async(
        self,
        request: devops_20210625_models.UpdateGroupRequest,
    ) -> devops_20210625_models.UpdateGroupResponse:
        """
        @summary 更新单个代码组信息
        
        @param request: UpdateGroupRequest
        @return: UpdateGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.update_group_with_options_async(request, headers, runtime)

    def update_group_member_with_options(
        self,
        group_id: str,
        request: devops_20210625_models.UpdateGroupMemberRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.UpdateGroupMemberResponse:
        """
        @summary 修改组成员
        
        @param request: UpdateGroupMemberRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateGroupMemberResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.aliyun_pk):
            query['aliyunPk'] = request.aliyun_pk
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.access_level):
            body['accessLevel'] = request.access_level
        if not UtilClient.is_unset(request.member_type):
            body['memberType'] = request.member_type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='UpdateGroupMember',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/groups/{OpenApiUtilClient.get_encode_param(group_id)}/members/update/aliyun_pk',
            method='PUT',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.UpdateGroupMemberResponse(),
            self.call_api(params, req, runtime)
        )

    async def update_group_member_with_options_async(
        self,
        group_id: str,
        request: devops_20210625_models.UpdateGroupMemberRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.UpdateGroupMemberResponse:
        """
        @summary 修改组成员
        
        @param request: UpdateGroupMemberRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateGroupMemberResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.aliyun_pk):
            query['aliyunPk'] = request.aliyun_pk
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.access_level):
            body['accessLevel'] = request.access_level
        if not UtilClient.is_unset(request.member_type):
            body['memberType'] = request.member_type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='UpdateGroupMember',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/repository/groups/{OpenApiUtilClient.get_encode_param(group_id)}/members/update/aliyun_pk',
            method='PUT',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.UpdateGroupMemberResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def update_group_member(
        self,
        group_id: str,
        request: devops_20210625_models.UpdateGroupMemberRequest,
    ) -> devops_20210625_models.UpdateGroupMemberResponse:
        """
        @summary 修改组成员
        
        @param request: UpdateGroupMemberRequest
        @return: UpdateGroupMemberResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.update_group_member_with_options(group_id, request, headers, runtime)

    async def update_group_member_async(
        self,
        group_id: str,
        request: devops_20210625_models.UpdateGroupMemberRequest,
    ) -> devops_20210625_models.UpdateGroupMemberResponse:
        """
        @summary 修改组成员
        
        @param request: UpdateGroupMemberRequest
        @return: UpdateGroupMemberResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.update_group_member_with_options_async(group_id, request, headers, runtime)

    def update_host_group_with_options(
        self,
        organization_id: str,
        id: str,
        request: devops_20210625_models.UpdateHostGroupRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.UpdateHostGroupResponse:
        """
        @summary 更新主机组
        
        @param request: UpdateHostGroupRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateHostGroupResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.aliyun_region):
            body['aliyunRegion'] = request.aliyun_region
        if not UtilClient.is_unset(request.ecs_label_key):
            body['ecsLabelKey'] = request.ecs_label_key
        if not UtilClient.is_unset(request.ecs_label_value):
            body['ecsLabelValue'] = request.ecs_label_value
        if not UtilClient.is_unset(request.ecs_type):
            body['ecsType'] = request.ecs_type
        if not UtilClient.is_unset(request.env_id):
            body['envId'] = request.env_id
        if not UtilClient.is_unset(request.machine_infos):
            body['machineInfos'] = request.machine_infos
        if not UtilClient.is_unset(request.name):
            body['name'] = request.name
        if not UtilClient.is_unset(request.service_connection_id):
            body['serviceConnectionId'] = request.service_connection_id
        if not UtilClient.is_unset(request.tag_ids):
            body['tagIds'] = request.tag_ids
        if not UtilClient.is_unset(request.type):
            body['type'] = request.type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='UpdateHostGroup',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/hostGroups/{OpenApiUtilClient.get_encode_param(id)}',
            method='PUT',
            auth_type='AK',
            style='ROA',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.UpdateHostGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def update_host_group_with_options_async(
        self,
        organization_id: str,
        id: str,
        request: devops_20210625_models.UpdateHostGroupRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.UpdateHostGroupResponse:
        """
        @summary 更新主机组
        
        @param request: UpdateHostGroupRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateHostGroupResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.aliyun_region):
            body['aliyunRegion'] = request.aliyun_region
        if not UtilClient.is_unset(request.ecs_label_key):
            body['ecsLabelKey'] = request.ecs_label_key
        if not UtilClient.is_unset(request.ecs_label_value):
            body['ecsLabelValue'] = request.ecs_label_value
        if not UtilClient.is_unset(request.ecs_type):
            body['ecsType'] = request.ecs_type
        if not UtilClient.is_unset(request.env_id):
            body['envId'] = request.env_id
        if not UtilClient.is_unset(request.machine_infos):
            body['machineInfos'] = request.machine_infos
        if not UtilClient.is_unset(request.name):
            body['name'] = request.name
        if not UtilClient.is_unset(request.service_connection_id):
            body['serviceConnectionId'] = request.service_connection_id
        if not UtilClient.is_unset(request.tag_ids):
            body['tagIds'] = request.tag_ids
        if not UtilClient.is_unset(request.type):
            body['type'] = request.type
        req = open_api_models.OpenApiRequest(
            headers=headers,
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='UpdateHostGroup',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/organization/{OpenApiUtilClient.get_encode_param(organization_id)}/hostGroups/{OpenApiUtilClient.get_encode_param(id)}',
            method='PUT',
            auth_type='AK',
            style='ROA',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.UpdateHostGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def update_host_group(
        self,
        organization_id: str,
        id: str,
        request: devops_20210625_models.UpdateHostGroupRequest,
    ) -> devops_20210625_models.UpdateHostGroupResponse:
        """
        @summary 更新主机组
        
        @param request: UpdateHostGroupRequest
        @return: UpdateHostGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.update_host_group_with_options(organization_id, id, request, headers, runtime)

    async def update_host_group_async(
        self,
        organization_id: str,
        id: str,
        request: devops_20210625_models.UpdateHostGroupRequest,
    ) -> devops_20210625_models.UpdateHostGroupResponse:
        """
        @summary 更新主机组
        
        @param request: UpdateHostGroupRequest
        @return: UpdateHostGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.update_host_group_with_options_async(organization_id, id, request, headers, runtime)

    def update_merge_request_with_options(
        self,
        repository_id: str,
        local_id: str,
        request: devops_20210625_models.UpdateMergeRequestRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.UpdateMergeRequestResponse:
        """
        @summary 更新代码评审的标题和描述
        
        @param request: UpdateMergeRequestRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateMergeRequestResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.description):
            body['description'] = request.description
        if not UtilClient.is_unset(request.title):
            body['title'] = request.title
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='UpdateMergeRequest',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/{OpenApiUtilClient.get_encode_param(repository_id)}/merge_requests/{OpenApiUtilClient.get_encode_param(local_id)}',
            method='PUT',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.UpdateMergeRequestResponse(),
            self.call_api(params, req, runtime)
        )

    async def update_merge_request_with_options_async(
        self,
        repository_id: str,
        local_id: str,
        request: devops_20210625_models.UpdateMergeRequestRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.UpdateMergeRequestResponse:
        """
        @summary 更新代码评审的标题和描述
        
        @param request: UpdateMergeRequestRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateMergeRequestResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.description):
            body['description'] = request.description
        if not UtilClient.is_unset(request.title):
            body['title'] = request.title
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='UpdateMergeRequest',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/{OpenApiUtilClient.get_encode_param(repository_id)}/merge_requests/{OpenApiUtilClient.get_encode_param(local_id)}',
            method='PUT',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.UpdateMergeRequestResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def update_merge_request(
        self,
        repository_id: str,
        local_id: str,
        request: devops_20210625_models.UpdateMergeRequestRequest,
    ) -> devops_20210625_models.UpdateMergeRequestResponse:
        """
        @summary 更新代码评审的标题和描述
        
        @param request: UpdateMergeRequestRequest
        @return: UpdateMergeRequestResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return self.update_merge_request_with_options(repository_id, local_id, request, headers, runtime)

    async def update_merge_request_async(
        self,
        repository_id: str,
        local_id: str,
        request: devops_20210625_models.UpdateMergeRequestRequest,
    ) -> devops_20210625_models.UpdateMergeRequestResponse:
        """
        @summary 更新代码评审的标题和描述
        
        @param request: UpdateMergeRequestRequest
        @return: UpdateMergeRequestResponse
        """
        runtime = util_models.RuntimeOptions()
        headers = {}
        return await self.update_merge_request_with_options_async(repository_id, local_id, request, headers, runtime)

    def update_merge_request_personnel_with_options(
        self,
        repository_id: str,
        local_id: str,
        person_type: str,
        request: devops_20210625_models.UpdateMergeRequestPersonnelRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.UpdateMergeRequestPersonnelResponse:
        """
        @summary 更新代码评审的干系人
        
        @param request: UpdateMergeRequestPersonnelRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateMergeRequestPersonnelResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.new_user_id_list):
            body['newUserIdList'] = request.new_user_id_list
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='UpdateMergeRequestPersonnel',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/{OpenApiUtilClient.get_encode_param(repository_id)}/merge_requests/{OpenApiUtilClient.get_encode_param(local_id)}/person/{OpenApiUtilClient.get_encode_param(person_type)}',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            devops_20210625_models.UpdateMergeRequestPersonnelResponse(),
            self.call_api(params, req, runtime)
        )

    async def update_merge_request_personnel_with_options_async(
        self,
        repository_id: str,
        local_id: str,
        person_type: str,
        request: devops_20210625_models.UpdateMergeRequestPersonnelRequest,
        headers: Dict[str, str],
        runtime: util_models.RuntimeOptions,
    ) -> devops_20210625_models.UpdateMergeRequestPersonnelResponse:
        """
        @summary 更新代码评审的干系人
        
        @param request: UpdateMergeRequestPersonnelRequest
        @param headers: map
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateMergeRequestPersonnelResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_token):
            query['accessToken'] = request.access_token
        if not UtilClient.is_unset(request.organization_id):
            query['organizationId'] = request.organization_id
        body = {}
        if not UtilClient.is_unset(request.new_user_id_list):
            body['newUserIdList'] = request.new_user_id_list
        req = open_api_models.OpenApiRequest(
            headers=headers,
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='UpdateMergeRequestPersonnel',
            version='2021-06-25',
            protocol='HTTPS',
            pathname=f'/api/v4/projects/{OpenApiUtilClient.get_encode_param(repository_id)}/merge_requests/{OpenApiUtilClient.get_encode_param(local_id)}/person/{OpenApiUtilClient.get_encode_param(person_type)}',
            method='POST',
            auth_type='AK',
            style='ROA',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map