# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### AlbLogsBucket <a name="AlbLogsBucket" id="cdk-extensions.s3_buckets.AlbLogsBucket"></a>

#### Initializers <a name="Initializers" id="cdk-extensions.s3_buckets.AlbLogsBucket.Initializer"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

new s3_buckets.AlbLogsBucket(scope: Construct, id: string, props?: AlbLogsBucketProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | A CDK Construct that will serve as this stack's parent in the construct tree. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.Initializer.parameter.id">id</a></code> | <code>string</code> | A name to be associated with the stack and used in resource naming. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.Initializer.parameter.props">props</a></code> | <code>cdk-extensions.s3_buckets.AlbLogsBucketProps</code> | Arguments related to the configuration of the resource. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.s3_buckets.AlbLogsBucket.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

A CDK Construct that will serve as this stack's parent in the construct tree.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.s3_buckets.AlbLogsBucket.Initializer.parameter.id"></a>

- *Type:* string

A name to be associated with the stack and used in resource naming.

Must be unique
within the context of 'scope'.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk-extensions.s3_buckets.AlbLogsBucket.Initializer.parameter.props"></a>

- *Type:* cdk-extensions.s3_buckets.AlbLogsBucketProps

Arguments related to the configuration of the resource.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.addEventNotification">addEventNotification</a></code> | Adds a bucket notification event destination. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.addObjectCreatedNotification">addObjectCreatedNotification</a></code> | Subscribes a destination to receive notifications when an object is created in the bucket. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.addObjectRemovedNotification">addObjectRemovedNotification</a></code> | Subscribes a destination to receive notifications when an object is removed from the bucket. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.addToResourcePolicy">addToResourcePolicy</a></code> | Adds a statement to the resource policy for a principal (i.e. account/role/service) to perform actions on this bucket and/or its contents. Use `bucketArn` and `arnForObjects(keys)` to obtain ARNs for this bucket or objects. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.arnForObjects">arnForObjects</a></code> | Returns an ARN that represents all objects within the bucket that match the key pattern specified. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.enableEventBridgeNotification">enableEventBridgeNotification</a></code> | Enables event bridge notification, causing all events below to be sent to EventBridge:. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.grantDelete">grantDelete</a></code> | Grants s3:DeleteObject* permission to an IAM principal for objects in this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.grantPublicAccess">grantPublicAccess</a></code> | Allows unrestricted access to objects from this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.grantPut">grantPut</a></code> | Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.grantPutAcl">grantPutAcl</a></code> | Grant the given IAM identity permissions to modify the ACLs of objects in the given Bucket. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.grantRead">grantRead</a></code> | Grant read permissions for this bucket and it's contents to an IAM principal (Role/Group/User). |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.grantReadWrite">grantReadWrite</a></code> | Grants read/write permissions for this bucket and it's contents to an IAM principal (Role/Group/User). |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.grantWrite">grantWrite</a></code> | Grant write permissions to this bucket to an IAM principal. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.onCloudTrailEvent">onCloudTrailEvent</a></code> | Defines a CloudWatch event that triggers when something happens to this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.onCloudTrailPutObject">onCloudTrailPutObject</a></code> | Defines an AWS CloudWatch event that triggers when an object is uploaded to the specified paths (keys) in this bucket using the PutObject API call. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.onCloudTrailWriteObject">onCloudTrailWriteObject</a></code> | Defines an AWS CloudWatch event that triggers when an object at the specified paths (keys) in this bucket are written to. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.s3UrlForObject">s3UrlForObject</a></code> | The S3 URL of an S3 object. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.transferAccelerationUrlForObject">transferAccelerationUrlForObject</a></code> | The https Transfer Acceleration URL of an S3 object. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.urlForObject">urlForObject</a></code> | The https URL of an S3 object. For example:. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.virtualHostedUrlForObject">virtualHostedUrlForObject</a></code> | The virtual hosted-style URL of an S3 object. Specify `regional: false` at the options for non-regional URL. For example:. |

---

##### `toString` <a name="toString" id="cdk-extensions.s3_buckets.AlbLogsBucket.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="cdk-extensions.s3_buckets.AlbLogsBucket.applyRemovalPolicy"></a>

```typescript
public applyRemovalPolicy(policy: RemovalPolicy): void
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="cdk-extensions.s3_buckets.AlbLogsBucket.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.RemovalPolicy

---

##### `addEventNotification` <a name="addEventNotification" id="cdk-extensions.s3_buckets.AlbLogsBucket.addEventNotification"></a>

```typescript
public addEventNotification(_event: EventType, _dest: IBucketNotificationDestination, _filters: NotificationKeyFilter): void
```

Adds a bucket notification event destination.

###### `_event`<sup>Required</sup> <a name="_event" id="cdk-extensions.s3_buckets.AlbLogsBucket.addEventNotification.parameter._event"></a>

- *Type:* aws-cdk-lib.aws_s3.EventType

---

###### `_dest`<sup>Required</sup> <a name="_dest" id="cdk-extensions.s3_buckets.AlbLogsBucket.addEventNotification.parameter._dest"></a>

- *Type:* aws-cdk-lib.aws_s3.IBucketNotificationDestination

---

###### `_filters`<sup>Required</sup> <a name="_filters" id="cdk-extensions.s3_buckets.AlbLogsBucket.addEventNotification.parameter._filters"></a>

- *Type:* aws-cdk-lib.aws_s3.NotificationKeyFilter

---

##### `addObjectCreatedNotification` <a name="addObjectCreatedNotification" id="cdk-extensions.s3_buckets.AlbLogsBucket.addObjectCreatedNotification"></a>

```typescript
public addObjectCreatedNotification(_dest: IBucketNotificationDestination, _filters: NotificationKeyFilter): void
```

Subscribes a destination to receive notifications when an object is created in the bucket.

This is identical to calling
`onEvent(s3.EventType.OBJECT_CREATED)`.

###### `_dest`<sup>Required</sup> <a name="_dest" id="cdk-extensions.s3_buckets.AlbLogsBucket.addObjectCreatedNotification.parameter._dest"></a>

- *Type:* aws-cdk-lib.aws_s3.IBucketNotificationDestination

---

###### `_filters`<sup>Required</sup> <a name="_filters" id="cdk-extensions.s3_buckets.AlbLogsBucket.addObjectCreatedNotification.parameter._filters"></a>

- *Type:* aws-cdk-lib.aws_s3.NotificationKeyFilter

---

##### `addObjectRemovedNotification` <a name="addObjectRemovedNotification" id="cdk-extensions.s3_buckets.AlbLogsBucket.addObjectRemovedNotification"></a>

```typescript
public addObjectRemovedNotification(_dest: IBucketNotificationDestination, _filters: NotificationKeyFilter): void
```

Subscribes a destination to receive notifications when an object is removed from the bucket.

This is identical to calling
`onEvent(EventType.OBJECT_REMOVED)`.

###### `_dest`<sup>Required</sup> <a name="_dest" id="cdk-extensions.s3_buckets.AlbLogsBucket.addObjectRemovedNotification.parameter._dest"></a>

- *Type:* aws-cdk-lib.aws_s3.IBucketNotificationDestination

---

###### `_filters`<sup>Required</sup> <a name="_filters" id="cdk-extensions.s3_buckets.AlbLogsBucket.addObjectRemovedNotification.parameter._filters"></a>

- *Type:* aws-cdk-lib.aws_s3.NotificationKeyFilter

---

##### `addToResourcePolicy` <a name="addToResourcePolicy" id="cdk-extensions.s3_buckets.AlbLogsBucket.addToResourcePolicy"></a>

```typescript
public addToResourcePolicy(permission: PolicyStatement): AddToResourcePolicyResult
```

Adds a statement to the resource policy for a principal (i.e. account/role/service) to perform actions on this bucket and/or its contents. Use `bucketArn` and `arnForObjects(keys)` to obtain ARNs for this bucket or objects.

Note that the policy statement may or may not be added to the policy.
For example, when an `IBucket` is created from an existing bucket,
it's not possible to tell whether the bucket already has a policy
attached, let alone to re-use that policy to add more statements to it.
So it's safest to do nothing in these cases.

###### `permission`<sup>Required</sup> <a name="permission" id="cdk-extensions.s3_buckets.AlbLogsBucket.addToResourcePolicy.parameter.permission"></a>

- *Type:* aws-cdk-lib.aws_iam.PolicyStatement

---

##### `arnForObjects` <a name="arnForObjects" id="cdk-extensions.s3_buckets.AlbLogsBucket.arnForObjects"></a>

```typescript
public arnForObjects(_keyPattern: string): string
```

Returns an ARN that represents all objects within the bucket that match the key pattern specified.

To represent all keys, specify ``"*"``.

###### `_keyPattern`<sup>Required</sup> <a name="_keyPattern" id="cdk-extensions.s3_buckets.AlbLogsBucket.arnForObjects.parameter._keyPattern"></a>

- *Type:* string

---

##### `enableEventBridgeNotification` <a name="enableEventBridgeNotification" id="cdk-extensions.s3_buckets.AlbLogsBucket.enableEventBridgeNotification"></a>

```typescript
public enableEventBridgeNotification(): void
```

Enables event bridge notification, causing all events below to be sent to EventBridge:.

Object Deleted (DeleteObject)
- Object Deleted (Lifecycle expiration)
- Object Restore Initiated
- Object Restore Completed
- Object Restore Expired
- Object Storage Class Changed
- Object Access Tier Changed
- Object ACL Updated
- Object Tags Added
- Object Tags Deleted

##### `grantDelete` <a name="grantDelete" id="cdk-extensions.s3_buckets.AlbLogsBucket.grantDelete"></a>

```typescript
public grantDelete(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grants s3:DeleteObject* permission to an IAM principal for objects in this bucket.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.AlbLogsBucket.grantDelete.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.AlbLogsBucket.grantDelete.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `grantPublicAccess` <a name="grantPublicAccess" id="cdk-extensions.s3_buckets.AlbLogsBucket.grantPublicAccess"></a>

```typescript
public grantPublicAccess(_allowedActions: string, _keyPrefix?: string): Grant
```

Allows unrestricted access to objects from this bucket.

IMPORTANT: This permission allows anyone to perform actions on S3 objects
in this bucket, which is useful for when you configure your bucket as a
website and want everyone to be able to read objects in the bucket without
needing to authenticate.

Without arguments, this method will grant read ("s3:GetObject") access to
all objects ("*") in the bucket.

The method returns the `iam.Grant` object, which can then be modified
as needed. For example, you can add a condition that will restrict access only
to an IPv4 range like this:

     const grant = bucket.grantPublicAccess();
     grant.resourceStatement!.addCondition(‘IpAddress’, { “aws:SourceIp”: “54.240.143.0/24” });

###### `_allowedActions`<sup>Required</sup> <a name="_allowedActions" id="cdk-extensions.s3_buckets.AlbLogsBucket.grantPublicAccess.parameter._allowedActions"></a>

- *Type:* string

---

###### `_keyPrefix`<sup>Optional</sup> <a name="_keyPrefix" id="cdk-extensions.s3_buckets.AlbLogsBucket.grantPublicAccess.parameter._keyPrefix"></a>

- *Type:* string

---

##### `grantPut` <a name="grantPut" id="cdk-extensions.s3_buckets.AlbLogsBucket.grantPut"></a>

```typescript
public grantPut(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal.

If encryption is used, permission to use the key to encrypt the contents
of written files will also be granted to the same principal.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.AlbLogsBucket.grantPut.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.AlbLogsBucket.grantPut.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `grantPutAcl` <a name="grantPutAcl" id="cdk-extensions.s3_buckets.AlbLogsBucket.grantPutAcl"></a>

```typescript
public grantPutAcl(_identity: IGrantable, _objectsKeyPattern?: string): Grant
```

Grant the given IAM identity permissions to modify the ACLs of objects in the given Bucket.

If your application has the '@aws-cdk/aws-s3:grantWriteWithoutAcl' feature flag set,
calling {@link grantWrite} or {@link grantReadWrite} no longer grants permissions to modify the ACLs of the objects;
in this case, if you need to modify object ACLs, call this method explicitly.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.AlbLogsBucket.grantPutAcl.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.AlbLogsBucket.grantPutAcl.parameter._objectsKeyPattern"></a>

- *Type:* string

---

##### `grantRead` <a name="grantRead" id="cdk-extensions.s3_buckets.AlbLogsBucket.grantRead"></a>

```typescript
public grantRead(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grant read permissions for this bucket and it's contents to an IAM principal (Role/Group/User).

If encryption is used, permission to use the key to decrypt the contents
of the bucket will also be granted to the same principal.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.AlbLogsBucket.grantRead.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.AlbLogsBucket.grantRead.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `grantReadWrite` <a name="grantReadWrite" id="cdk-extensions.s3_buckets.AlbLogsBucket.grantReadWrite"></a>

```typescript
public grantReadWrite(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grants read/write permissions for this bucket and it's contents to an IAM principal (Role/Group/User).

If an encryption key is used, permission to use the key for
encrypt/decrypt will also be granted.

Before CDK version 1.85.0, this method granted the `s3:PutObject*` permission that included `s3:PutObjectAcl`,
which could be used to grant read/write object access to IAM principals in other accounts.
If you want to get rid of that behavior, update your CDK version to 1.85.0 or later,
and make sure the `@aws-cdk/aws-s3:grantWriteWithoutAcl` feature flag is set to `true`
in the `context` key of your cdk.json file.
If you've already updated, but still need the principal to have permissions to modify the ACLs,
use the {@link grantPutAcl} method.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.AlbLogsBucket.grantReadWrite.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.AlbLogsBucket.grantReadWrite.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `grantWrite` <a name="grantWrite" id="cdk-extensions.s3_buckets.AlbLogsBucket.grantWrite"></a>

```typescript
public grantWrite(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grant write permissions to this bucket to an IAM principal.

If encryption is used, permission to use the key to encrypt the contents
of written files will also be granted to the same principal.

Before CDK version 1.85.0, this method granted the `s3:PutObject*` permission that included `s3:PutObjectAcl`,
which could be used to grant read/write object access to IAM principals in other accounts.
If you want to get rid of that behavior, update your CDK version to 1.85.0 or later,
and make sure the `@aws-cdk/aws-s3:grantWriteWithoutAcl` feature flag is set to `true`
in the `context` key of your cdk.json file.
If you've already updated, but still need the principal to have permissions to modify the ACLs,
use the {@link grantPutAcl} method.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.AlbLogsBucket.grantWrite.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.AlbLogsBucket.grantWrite.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `onCloudTrailEvent` <a name="onCloudTrailEvent" id="cdk-extensions.s3_buckets.AlbLogsBucket.onCloudTrailEvent"></a>

```typescript
public onCloudTrailEvent(_id: string, _options?: OnCloudTrailBucketEventOptions): Rule
```

Defines a CloudWatch event that triggers when something happens to this bucket.

Requires that there exists at least one CloudTrail Trail in your account
that captures the event. This method will not create the Trail.

###### `_id`<sup>Required</sup> <a name="_id" id="cdk-extensions.s3_buckets.AlbLogsBucket.onCloudTrailEvent.parameter._id"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.AlbLogsBucket.onCloudTrailEvent.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.OnCloudTrailBucketEventOptions

---

##### `onCloudTrailPutObject` <a name="onCloudTrailPutObject" id="cdk-extensions.s3_buckets.AlbLogsBucket.onCloudTrailPutObject"></a>

```typescript
public onCloudTrailPutObject(_id: string, _options?: OnCloudTrailBucketEventOptions): Rule
```

Defines an AWS CloudWatch event that triggers when an object is uploaded to the specified paths (keys) in this bucket using the PutObject API call.

Note that some tools like `aws s3 cp` will automatically use either
PutObject or the multipart upload API depending on the file size,
so using `onCloudTrailWriteObject` may be preferable.

Requires that there exists at least one CloudTrail Trail in your account
that captures the event. This method will not create the Trail.

###### `_id`<sup>Required</sup> <a name="_id" id="cdk-extensions.s3_buckets.AlbLogsBucket.onCloudTrailPutObject.parameter._id"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.AlbLogsBucket.onCloudTrailPutObject.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.OnCloudTrailBucketEventOptions

---

##### `onCloudTrailWriteObject` <a name="onCloudTrailWriteObject" id="cdk-extensions.s3_buckets.AlbLogsBucket.onCloudTrailWriteObject"></a>

```typescript
public onCloudTrailWriteObject(_id: string, _options?: OnCloudTrailBucketEventOptions): Rule
```

Defines an AWS CloudWatch event that triggers when an object at the specified paths (keys) in this bucket are written to.

This includes
the events PutObject, CopyObject, and CompleteMultipartUpload.

Note that some tools like `aws s3 cp` will automatically use either
PutObject or the multipart upload API depending on the file size,
so using this method may be preferable to `onCloudTrailPutObject`.

Requires that there exists at least one CloudTrail Trail in your account
that captures the event. This method will not create the Trail.

###### `_id`<sup>Required</sup> <a name="_id" id="cdk-extensions.s3_buckets.AlbLogsBucket.onCloudTrailWriteObject.parameter._id"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.AlbLogsBucket.onCloudTrailWriteObject.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.OnCloudTrailBucketEventOptions

---

##### `s3UrlForObject` <a name="s3UrlForObject" id="cdk-extensions.s3_buckets.AlbLogsBucket.s3UrlForObject"></a>

```typescript
public s3UrlForObject(_key?: string): string
```

The S3 URL of an S3 object.

For example:
- `s3://onlybucket`
- `s3://bucket/key`

###### `_key`<sup>Optional</sup> <a name="_key" id="cdk-extensions.s3_buckets.AlbLogsBucket.s3UrlForObject.parameter._key"></a>

- *Type:* string

---

##### `transferAccelerationUrlForObject` <a name="transferAccelerationUrlForObject" id="cdk-extensions.s3_buckets.AlbLogsBucket.transferAccelerationUrlForObject"></a>

```typescript
public transferAccelerationUrlForObject(_key?: string, _options?: TransferAccelerationUrlOptions): string
```

The https Transfer Acceleration URL of an S3 object.

Specify `dualStack: true` at the options
for dual-stack endpoint (connect to the bucket over IPv6). For example:

- `https://bucket.s3-accelerate.amazonaws.com`
- `https://bucket.s3-accelerate.amazonaws.com/key`

###### `_key`<sup>Optional</sup> <a name="_key" id="cdk-extensions.s3_buckets.AlbLogsBucket.transferAccelerationUrlForObject.parameter._key"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.AlbLogsBucket.transferAccelerationUrlForObject.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.TransferAccelerationUrlOptions

---

##### `urlForObject` <a name="urlForObject" id="cdk-extensions.s3_buckets.AlbLogsBucket.urlForObject"></a>

```typescript
public urlForObject(_key?: string): string
```

The https URL of an S3 object. For example:.

`https://s3.us-west-1.amazonaws.com/onlybucket`
- `https://s3.us-west-1.amazonaws.com/bucket/key`
- `https://s3.cn-north-1.amazonaws.com.cn/china-bucket/mykey`

###### `_key`<sup>Optional</sup> <a name="_key" id="cdk-extensions.s3_buckets.AlbLogsBucket.urlForObject.parameter._key"></a>

- *Type:* string

---

##### `virtualHostedUrlForObject` <a name="virtualHostedUrlForObject" id="cdk-extensions.s3_buckets.AlbLogsBucket.virtualHostedUrlForObject"></a>

```typescript
public virtualHostedUrlForObject(_key?: string, _options?: VirtualHostedStyleUrlOptions): string
```

The virtual hosted-style URL of an S3 object. Specify `regional: false` at the options for non-regional URL. For example:.

`https://only-bucket.s3.us-west-1.amazonaws.com`
- `https://bucket.s3.us-west-1.amazonaws.com/key`
- `https://bucket.s3.amazonaws.com/key`
- `https://china-bucket.s3.cn-north-1.amazonaws.com.cn/mykey`

###### `_key`<sup>Optional</sup> <a name="_key" id="cdk-extensions.s3_buckets.AlbLogsBucket.virtualHostedUrlForObject.parameter._key"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.AlbLogsBucket.virtualHostedUrlForObject.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.VirtualHostedStyleUrlOptions

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.isOwnedResource">isOwnedResource</a></code> | Returns true if the construct was created by CDK, and false otherwise. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.isResource">isResource</a></code> | Check whether the given construct is a Resource. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-extensions.s3_buckets.AlbLogsBucket.isConstruct"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

s3_buckets.AlbLogsBucket.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-extensions.s3_buckets.AlbLogsBucket.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isOwnedResource` <a name="isOwnedResource" id="cdk-extensions.s3_buckets.AlbLogsBucket.isOwnedResource"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

s3_buckets.AlbLogsBucket.isOwnedResource(construct: IConstruct)
```

Returns true if the construct was created by CDK, and false otherwise.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.s3_buckets.AlbLogsBucket.isOwnedResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `isResource` <a name="isResource" id="cdk-extensions.s3_buckets.AlbLogsBucket.isResource"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

s3_buckets.AlbLogsBucket.isResource(construct: IConstruct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.s3_buckets.AlbLogsBucket.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.property.env">env</a></code> | <code>aws-cdk-lib.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.property.stack">stack</a></code> | <code>aws-cdk-lib.Stack</code> | The stack in which this resource is defined. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.property.bucketArn">bucketArn</a></code> | <code>string</code> | The ARN of the bucket. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.property.bucketDomainName">bucketDomainName</a></code> | <code>string</code> | The IPv4 DNS name of the specified bucket. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.property.bucketDualStackDomainName">bucketDualStackDomainName</a></code> | <code>string</code> | The IPv6 DNS name of the specified bucket. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.property.bucketName">bucketName</a></code> | <code>string</code> | The name of the bucket. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.property.bucketRegionalDomainName">bucketRegionalDomainName</a></code> | <code>string</code> | The regional domain name of the specified bucket. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.property.bucketWebsiteDomainName">bucketWebsiteDomainName</a></code> | <code>string</code> | The Domain name of the static website. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.property.bucketWebsiteUrl">bucketWebsiteUrl</a></code> | <code>string</code> | The URL of the static website. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.property.resource">resource</a></code> | <code>aws-cdk-lib.aws_s3.CfnBucket</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.property.encryptionKey">encryptionKey</a></code> | <code>aws-cdk-lib.aws_kms.IKey</code> | Optional KMS encryption key associated with this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.property.isWebsite">isWebsite</a></code> | <code>boolean</code> | If this bucket has been configured for static website hosting. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.property.policy">policy</a></code> | <code>aws-cdk-lib.aws_s3.BucketPolicy</code> | The resource policy associated with this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.property.database">database</a></code> | <code>cdk-extensions.glue.Database</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.property.table">table</a></code> | <code>cdk-extensions.glue_tables.AlbLogsTable</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.property.createQueries">createQueries</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucket.property.friendlyQueryNames">friendlyQueryNames</a></code> | <code>boolean</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-extensions.s3_buckets.AlbLogsBucket.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="cdk-extensions.s3_buckets.AlbLogsBucket.property.env"></a>

```typescript
public readonly env: ResourceEnvironment;
```

- *Type:* aws-cdk-lib.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="cdk-extensions.s3_buckets.AlbLogsBucket.property.stack"></a>

```typescript
public readonly stack: Stack;
```

- *Type:* aws-cdk-lib.Stack

The stack in which this resource is defined.

---

##### `bucketArn`<sup>Required</sup> <a name="bucketArn" id="cdk-extensions.s3_buckets.AlbLogsBucket.property.bucketArn"></a>

```typescript
public readonly bucketArn: string;
```

- *Type:* string

The ARN of the bucket.

---

##### `bucketDomainName`<sup>Required</sup> <a name="bucketDomainName" id="cdk-extensions.s3_buckets.AlbLogsBucket.property.bucketDomainName"></a>

```typescript
public readonly bucketDomainName: string;
```

- *Type:* string

The IPv4 DNS name of the specified bucket.

---

##### `bucketDualStackDomainName`<sup>Required</sup> <a name="bucketDualStackDomainName" id="cdk-extensions.s3_buckets.AlbLogsBucket.property.bucketDualStackDomainName"></a>

```typescript
public readonly bucketDualStackDomainName: string;
```

- *Type:* string

The IPv6 DNS name of the specified bucket.

---

##### `bucketName`<sup>Required</sup> <a name="bucketName" id="cdk-extensions.s3_buckets.AlbLogsBucket.property.bucketName"></a>

```typescript
public readonly bucketName: string;
```

- *Type:* string

The name of the bucket.

---

##### `bucketRegionalDomainName`<sup>Required</sup> <a name="bucketRegionalDomainName" id="cdk-extensions.s3_buckets.AlbLogsBucket.property.bucketRegionalDomainName"></a>

```typescript
public readonly bucketRegionalDomainName: string;
```

- *Type:* string

The regional domain name of the specified bucket.

---

##### `bucketWebsiteDomainName`<sup>Required</sup> <a name="bucketWebsiteDomainName" id="cdk-extensions.s3_buckets.AlbLogsBucket.property.bucketWebsiteDomainName"></a>

```typescript
public readonly bucketWebsiteDomainName: string;
```

- *Type:* string

The Domain name of the static website.

---

##### `bucketWebsiteUrl`<sup>Required</sup> <a name="bucketWebsiteUrl" id="cdk-extensions.s3_buckets.AlbLogsBucket.property.bucketWebsiteUrl"></a>

```typescript
public readonly bucketWebsiteUrl: string;
```

- *Type:* string

The URL of the static website.

---

##### `resource`<sup>Required</sup> <a name="resource" id="cdk-extensions.s3_buckets.AlbLogsBucket.property.resource"></a>

```typescript
public readonly resource: CfnBucket;
```

- *Type:* aws-cdk-lib.aws_s3.CfnBucket

---

##### `encryptionKey`<sup>Optional</sup> <a name="encryptionKey" id="cdk-extensions.s3_buckets.AlbLogsBucket.property.encryptionKey"></a>

```typescript
public readonly encryptionKey: IKey;
```

- *Type:* aws-cdk-lib.aws_kms.IKey

Optional KMS encryption key associated with this bucket.

---

##### `isWebsite`<sup>Optional</sup> <a name="isWebsite" id="cdk-extensions.s3_buckets.AlbLogsBucket.property.isWebsite"></a>

```typescript
public readonly isWebsite: boolean;
```

- *Type:* boolean

If this bucket has been configured for static website hosting.

---

##### `policy`<sup>Optional</sup> <a name="policy" id="cdk-extensions.s3_buckets.AlbLogsBucket.property.policy"></a>

```typescript
public readonly policy: BucketPolicy;
```

- *Type:* aws-cdk-lib.aws_s3.BucketPolicy

The resource policy associated with this bucket.

If `autoCreatePolicy` is true, a `BucketPolicy` will be created upon the
first call to addToResourcePolicy(s).

---

##### `database`<sup>Required</sup> <a name="database" id="cdk-extensions.s3_buckets.AlbLogsBucket.property.database"></a>

```typescript
public readonly database: Database;
```

- *Type:* cdk-extensions.glue.Database

---

##### `table`<sup>Required</sup> <a name="table" id="cdk-extensions.s3_buckets.AlbLogsBucket.property.table"></a>

```typescript
public readonly table: AlbLogsTable;
```

- *Type:* cdk-extensions.glue_tables.AlbLogsTable

---

##### `createQueries`<sup>Optional</sup> <a name="createQueries" id="cdk-extensions.s3_buckets.AlbLogsBucket.property.createQueries"></a>

```typescript
public readonly createQueries: boolean;
```

- *Type:* boolean

---

##### `friendlyQueryNames`<sup>Optional</sup> <a name="friendlyQueryNames" id="cdk-extensions.s3_buckets.AlbLogsBucket.property.friendlyQueryNames"></a>

```typescript
public readonly friendlyQueryNames: boolean;
```

- *Type:* boolean

---


### AlbLogsTable <a name="AlbLogsTable" id="cdk-extensions.glue_tables.AlbLogsTable"></a>

#### Initializers <a name="Initializers" id="cdk-extensions.glue_tables.AlbLogsTable.Initializer"></a>

```typescript
import { glue_tables } from 'cdk-extensions'

new glue_tables.AlbLogsTable(scope: Construct, id: string, props: AlbLogsTableProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTable.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | A CDK Construct that will serve as this stack's parent in the construct tree. |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTable.Initializer.parameter.id">id</a></code> | <code>string</code> | A name to be associated with the stack and used in resource naming. |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTable.Initializer.parameter.props">props</a></code> | <code>cdk-extensions.glue_tables.AlbLogsTableProps</code> | Arguments related to the configuration of the resource. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.glue_tables.AlbLogsTable.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

A CDK Construct that will serve as this stack's parent in the construct tree.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.glue_tables.AlbLogsTable.Initializer.parameter.id"></a>

- *Type:* string

A name to be associated with the stack and used in resource naming.

Must be unique
within the context of 'scope'.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk-extensions.glue_tables.AlbLogsTable.Initializer.parameter.props"></a>

- *Type:* cdk-extensions.glue_tables.AlbLogsTableProps

Arguments related to the configuration of the resource.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTable.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTable.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTable.addColumn">addColumn</a></code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTable.addParameter">addParameter</a></code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTable.addPartitionKey">addPartitionKey</a></code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTable.addSerdeParameter">addSerdeParameter</a></code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTable.addStorageParameter">addStorageParameter</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="cdk-extensions.glue_tables.AlbLogsTable.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="cdk-extensions.glue_tables.AlbLogsTable.applyRemovalPolicy"></a>

```typescript
public applyRemovalPolicy(policy: RemovalPolicy): void
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="cdk-extensions.glue_tables.AlbLogsTable.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.RemovalPolicy

---

##### `addColumn` <a name="addColumn" id="cdk-extensions.glue_tables.AlbLogsTable.addColumn"></a>

```typescript
public addColumn(column: Column): void
```

###### `column`<sup>Required</sup> <a name="column" id="cdk-extensions.glue_tables.AlbLogsTable.addColumn.parameter.column"></a>

- *Type:* cdk-extensions.glue.Column

---

##### `addParameter` <a name="addParameter" id="cdk-extensions.glue_tables.AlbLogsTable.addParameter"></a>

```typescript
public addParameter(key: string, value: string): void
```

###### `key`<sup>Required</sup> <a name="key" id="cdk-extensions.glue_tables.AlbLogsTable.addParameter.parameter.key"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="cdk-extensions.glue_tables.AlbLogsTable.addParameter.parameter.value"></a>

- *Type:* string

---

##### `addPartitionKey` <a name="addPartitionKey" id="cdk-extensions.glue_tables.AlbLogsTable.addPartitionKey"></a>

```typescript
public addPartitionKey(column: Column): void
```

###### `column`<sup>Required</sup> <a name="column" id="cdk-extensions.glue_tables.AlbLogsTable.addPartitionKey.parameter.column"></a>

- *Type:* cdk-extensions.glue.Column

---

##### `addSerdeParameter` <a name="addSerdeParameter" id="cdk-extensions.glue_tables.AlbLogsTable.addSerdeParameter"></a>

```typescript
public addSerdeParameter(key: string, value: string): void
```

###### `key`<sup>Required</sup> <a name="key" id="cdk-extensions.glue_tables.AlbLogsTable.addSerdeParameter.parameter.key"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="cdk-extensions.glue_tables.AlbLogsTable.addSerdeParameter.parameter.value"></a>

- *Type:* string

---

##### `addStorageParameter` <a name="addStorageParameter" id="cdk-extensions.glue_tables.AlbLogsTable.addStorageParameter"></a>

```typescript
public addStorageParameter(key: string, value: string): void
```

###### `key`<sup>Required</sup> <a name="key" id="cdk-extensions.glue_tables.AlbLogsTable.addStorageParameter.parameter.key"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="cdk-extensions.glue_tables.AlbLogsTable.addStorageParameter.parameter.value"></a>

- *Type:* string

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTable.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTable.isOwnedResource">isOwnedResource</a></code> | Returns true if the construct was created by CDK, and false otherwise. |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTable.isResource">isResource</a></code> | Check whether the given construct is a Resource. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-extensions.glue_tables.AlbLogsTable.isConstruct"></a>

```typescript
import { glue_tables } from 'cdk-extensions'

glue_tables.AlbLogsTable.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-extensions.glue_tables.AlbLogsTable.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isOwnedResource` <a name="isOwnedResource" id="cdk-extensions.glue_tables.AlbLogsTable.isOwnedResource"></a>

```typescript
import { glue_tables } from 'cdk-extensions'

glue_tables.AlbLogsTable.isOwnedResource(construct: IConstruct)
```

Returns true if the construct was created by CDK, and false otherwise.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.glue_tables.AlbLogsTable.isOwnedResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `isResource` <a name="isResource" id="cdk-extensions.glue_tables.AlbLogsTable.isResource"></a>

```typescript
import { glue_tables } from 'cdk-extensions'

glue_tables.AlbLogsTable.isResource(construct: IConstruct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.glue_tables.AlbLogsTable.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTable.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTable.property.env">env</a></code> | <code>aws-cdk-lib.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTable.property.stack">stack</a></code> | <code>aws-cdk-lib.Stack</code> | The stack in which this resource is defined. |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTable.property.database">database</a></code> | <code>cdk-extensions.glue.Database</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTable.property.resource">resource</a></code> | <code>aws-cdk-lib.aws_glue.CfnTable</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTable.property.tableArn">tableArn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTable.property.tableName">tableName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTable.property.compressed">compressed</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTable.property.dataFormat">dataFormat</a></code> | <code>cdk-extensions.glue.DataFormat</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTable.property.description">description</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTable.property.location">location</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTable.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTable.property.owner">owner</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTable.property.retention">retention</a></code> | <code>aws-cdk-lib.Duration</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTable.property.serdeName">serdeName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTable.property.storedAsSubDirectories">storedAsSubDirectories</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTable.property.tableType">tableType</a></code> | <code>cdk-extensions.glue.TableType</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTable.property.targetTable">targetTable</a></code> | <code>cdk-extensions.glue.Table</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTable.property.viewExpandedText">viewExpandedText</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTable.property.viewOriginalText">viewOriginalText</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTable.property.createQueries">createQueries</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTable.property.friendlyQueryNames">friendlyQueryNames</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTable.property.status5xxNamedQuery">status5xxNamedQuery</a></code> | <code>cdk-extensions.athena.NamedQuery</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTable.property.topIpsNamedQuery">topIpsNamedQuery</a></code> | <code>cdk-extensions.athena.NamedQuery</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-extensions.glue_tables.AlbLogsTable.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="cdk-extensions.glue_tables.AlbLogsTable.property.env"></a>

```typescript
public readonly env: ResourceEnvironment;
```

- *Type:* aws-cdk-lib.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="cdk-extensions.glue_tables.AlbLogsTable.property.stack"></a>

```typescript
public readonly stack: Stack;
```

- *Type:* aws-cdk-lib.Stack

The stack in which this resource is defined.

---

##### `database`<sup>Required</sup> <a name="database" id="cdk-extensions.glue_tables.AlbLogsTable.property.database"></a>

```typescript
public readonly database: Database;
```

- *Type:* cdk-extensions.glue.Database

---

##### `resource`<sup>Required</sup> <a name="resource" id="cdk-extensions.glue_tables.AlbLogsTable.property.resource"></a>

```typescript
public readonly resource: CfnTable;
```

- *Type:* aws-cdk-lib.aws_glue.CfnTable

---

##### `tableArn`<sup>Required</sup> <a name="tableArn" id="cdk-extensions.glue_tables.AlbLogsTable.property.tableArn"></a>

```typescript
public readonly tableArn: string;
```

- *Type:* string

---

##### `tableName`<sup>Required</sup> <a name="tableName" id="cdk-extensions.glue_tables.AlbLogsTable.property.tableName"></a>

```typescript
public readonly tableName: string;
```

- *Type:* string

---

##### `compressed`<sup>Optional</sup> <a name="compressed" id="cdk-extensions.glue_tables.AlbLogsTable.property.compressed"></a>

```typescript
public readonly compressed: boolean;
```

- *Type:* boolean

---

##### `dataFormat`<sup>Optional</sup> <a name="dataFormat" id="cdk-extensions.glue_tables.AlbLogsTable.property.dataFormat"></a>

```typescript
public readonly dataFormat: DataFormat;
```

- *Type:* cdk-extensions.glue.DataFormat

---

##### `description`<sup>Optional</sup> <a name="description" id="cdk-extensions.glue_tables.AlbLogsTable.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

---

##### `location`<sup>Optional</sup> <a name="location" id="cdk-extensions.glue_tables.AlbLogsTable.property.location"></a>

```typescript
public readonly location: string;
```

- *Type:* string

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.glue_tables.AlbLogsTable.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `owner`<sup>Optional</sup> <a name="owner" id="cdk-extensions.glue_tables.AlbLogsTable.property.owner"></a>

```typescript
public readonly owner: string;
```

- *Type:* string

---

##### `retention`<sup>Optional</sup> <a name="retention" id="cdk-extensions.glue_tables.AlbLogsTable.property.retention"></a>

```typescript
public readonly retention: Duration;
```

- *Type:* aws-cdk-lib.Duration

---

##### `serdeName`<sup>Optional</sup> <a name="serdeName" id="cdk-extensions.glue_tables.AlbLogsTable.property.serdeName"></a>

```typescript
public readonly serdeName: string;
```

- *Type:* string

---

##### `storedAsSubDirectories`<sup>Optional</sup> <a name="storedAsSubDirectories" id="cdk-extensions.glue_tables.AlbLogsTable.property.storedAsSubDirectories"></a>

```typescript
public readonly storedAsSubDirectories: boolean;
```

- *Type:* boolean

---

##### `tableType`<sup>Optional</sup> <a name="tableType" id="cdk-extensions.glue_tables.AlbLogsTable.property.tableType"></a>

```typescript
public readonly tableType: TableType;
```

- *Type:* cdk-extensions.glue.TableType

---

##### `targetTable`<sup>Optional</sup> <a name="targetTable" id="cdk-extensions.glue_tables.AlbLogsTable.property.targetTable"></a>

```typescript
public readonly targetTable: Table;
```

- *Type:* cdk-extensions.glue.Table

---

##### `viewExpandedText`<sup>Optional</sup> <a name="viewExpandedText" id="cdk-extensions.glue_tables.AlbLogsTable.property.viewExpandedText"></a>

```typescript
public readonly viewExpandedText: string;
```

- *Type:* string

---

##### `viewOriginalText`<sup>Optional</sup> <a name="viewOriginalText" id="cdk-extensions.glue_tables.AlbLogsTable.property.viewOriginalText"></a>

```typescript
public readonly viewOriginalText: string;
```

- *Type:* string

---

##### `createQueries`<sup>Required</sup> <a name="createQueries" id="cdk-extensions.glue_tables.AlbLogsTable.property.createQueries"></a>

```typescript
public readonly createQueries: boolean;
```

- *Type:* boolean

---

##### `friendlyQueryNames`<sup>Required</sup> <a name="friendlyQueryNames" id="cdk-extensions.glue_tables.AlbLogsTable.property.friendlyQueryNames"></a>

```typescript
public readonly friendlyQueryNames: boolean;
```

- *Type:* boolean

---

##### `status5xxNamedQuery`<sup>Optional</sup> <a name="status5xxNamedQuery" id="cdk-extensions.glue_tables.AlbLogsTable.property.status5xxNamedQuery"></a>

```typescript
public readonly status5xxNamedQuery: NamedQuery;
```

- *Type:* cdk-extensions.athena.NamedQuery

---

##### `topIpsNamedQuery`<sup>Optional</sup> <a name="topIpsNamedQuery" id="cdk-extensions.glue_tables.AlbLogsTable.property.topIpsNamedQuery"></a>

```typescript
public readonly topIpsNamedQuery: NamedQuery;
```

- *Type:* cdk-extensions.athena.NamedQuery

---


### Assignment <a name="Assignment" id="cdk-extensions.sso.Assignment"></a>

Assigns access to a Principal for a specified AWS account using a specified permission set.

#### Initializers <a name="Initializers" id="cdk-extensions.sso.Assignment.Initializer"></a>

```typescript
import { sso } from 'cdk-extensions'

new sso.Assignment(scope: Construct, id: string, props: AssignmentProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.sso.Assignment.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | A CDK Construct that will serve as this stack's parent in the construct tree. |
| <code><a href="#cdk-extensions.sso.Assignment.Initializer.parameter.id">id</a></code> | <code>string</code> | A name to be associated with the stack and used in resource naming. |
| <code><a href="#cdk-extensions.sso.Assignment.Initializer.parameter.props">props</a></code> | <code>cdk-extensions.sso.AssignmentProps</code> | Arguments related to the configuration of the resource. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.sso.Assignment.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

A CDK Construct that will serve as this stack's parent in the construct tree.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.sso.Assignment.Initializer.parameter.id"></a>

- *Type:* string

A name to be associated with the stack and used in resource naming.

Must be unique within the context of 'scope'.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk-extensions.sso.Assignment.Initializer.parameter.props"></a>

- *Type:* cdk-extensions.sso.AssignmentProps

Arguments related to the configuration of the resource.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.sso.Assignment.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-extensions.sso.Assignment.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |

---

##### `toString` <a name="toString" id="cdk-extensions.sso.Assignment.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="cdk-extensions.sso.Assignment.applyRemovalPolicy"></a>

```typescript
public applyRemovalPolicy(policy: RemovalPolicy): void
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="cdk-extensions.sso.Assignment.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.RemovalPolicy

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.sso.Assignment.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-extensions.sso.Assignment.isOwnedResource">isOwnedResource</a></code> | Returns true if the construct was created by CDK, and false otherwise. |
| <code><a href="#cdk-extensions.sso.Assignment.isResource">isResource</a></code> | Check whether the given construct is a Resource. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-extensions.sso.Assignment.isConstruct"></a>

```typescript
import { sso } from 'cdk-extensions'

sso.Assignment.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-extensions.sso.Assignment.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isOwnedResource` <a name="isOwnedResource" id="cdk-extensions.sso.Assignment.isOwnedResource"></a>

```typescript
import { sso } from 'cdk-extensions'

sso.Assignment.isOwnedResource(construct: IConstruct)
```

Returns true if the construct was created by CDK, and false otherwise.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.sso.Assignment.isOwnedResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `isResource` <a name="isResource" id="cdk-extensions.sso.Assignment.isResource"></a>

```typescript
import { sso } from 'cdk-extensions'

sso.Assignment.isResource(construct: IConstruct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.sso.Assignment.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.sso.Assignment.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-extensions.sso.Assignment.property.env">env</a></code> | <code>aws-cdk-lib.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#cdk-extensions.sso.Assignment.property.stack">stack</a></code> | <code>aws-cdk-lib.Stack</code> | The stack in which this resource is defined. |
| <code><a href="#cdk-extensions.sso.Assignment.property.instance">instance</a></code> | <code>cdk-extensions.sso.IInstance</code> | The IAM Identity Center instance under which the operation will be executed. |
| <code><a href="#cdk-extensions.sso.Assignment.property.permissionSet">permissionSet</a></code> | <code>cdk-extensions.sso.IPermissionSet</code> | The permission set which governs the access being assigned. |
| <code><a href="#cdk-extensions.sso.Assignment.property.principal">principal</a></code> | <code>cdk-extensions.sso.IIdentityCenterPrincipal</code> | The IAM Identity Center principal you wish to grant permissions to. |
| <code><a href="#cdk-extensions.sso.Assignment.property.resource">resource</a></code> | <code>aws-cdk-lib.aws_sso.CfnAssignment</code> | The underlying Assignment CloudFormation resource. |
| <code><a href="#cdk-extensions.sso.Assignment.property.target">target</a></code> | <code>cdk-extensions.sso.AssignmentTarget</code> | The resource you wish to grant the {@link principal} entity access to using the permissions defined in the {@link permissionSet}. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-extensions.sso.Assignment.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="cdk-extensions.sso.Assignment.property.env"></a>

```typescript
public readonly env: ResourceEnvironment;
```

- *Type:* aws-cdk-lib.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="cdk-extensions.sso.Assignment.property.stack"></a>

```typescript
public readonly stack: Stack;
```

- *Type:* aws-cdk-lib.Stack

The stack in which this resource is defined.

---

##### `instance`<sup>Required</sup> <a name="instance" id="cdk-extensions.sso.Assignment.property.instance"></a>

```typescript
public readonly instance: IInstance;
```

- *Type:* cdk-extensions.sso.IInstance

The IAM Identity Center instance under which the operation will be executed.

---

##### `permissionSet`<sup>Required</sup> <a name="permissionSet" id="cdk-extensions.sso.Assignment.property.permissionSet"></a>

```typescript
public readonly permissionSet: IPermissionSet;
```

- *Type:* cdk-extensions.sso.IPermissionSet

The permission set which governs the access being assigned.

The
permission set grants the {@link principal} permissions on
{@link target}.

---

##### `principal`<sup>Required</sup> <a name="principal" id="cdk-extensions.sso.Assignment.property.principal"></a>

```typescript
public readonly principal: IIdentityCenterPrincipal;
```

- *Type:* cdk-extensions.sso.IIdentityCenterPrincipal

The IAM Identity Center principal you wish to grant permissions to.

---

##### `resource`<sup>Required</sup> <a name="resource" id="cdk-extensions.sso.Assignment.property.resource"></a>

```typescript
public readonly resource: CfnAssignment;
```

- *Type:* aws-cdk-lib.aws_sso.CfnAssignment

The underlying Assignment CloudFormation resource.

---

##### `target`<sup>Required</sup> <a name="target" id="cdk-extensions.sso.Assignment.property.target"></a>

```typescript
public readonly target: AssignmentTarget;
```

- *Type:* cdk-extensions.sso.AssignmentTarget

The resource you wish to grant the {@link principal} entity access to using the permissions defined in the {@link permissionSet}.

For example,
an AWS account.

---


### AwsLoggingStack <a name="AwsLoggingStack" id="cdk-extensions.stacks.AwsLoggingStack"></a>

Creates a demo web service running in Fargate that is accessible through an application load balancer.

The demo service serves a generic "Welcome to nginx" page.

The service can be accessed remotely using ECS Exec. For details see the documentation at:
https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-exec.html#ecs-exec-running-commands

#### Initializers <a name="Initializers" id="cdk-extensions.stacks.AwsLoggingStack.Initializer"></a>

```typescript
import { stacks } from 'cdk-extensions'

new stacks.AwsLoggingStack(scope: Construct, id: string, props?: AwsLoggingStackProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.Initializer.parameter.props">props</a></code> | <code>cdk-extensions.stacks.AwsLoggingStackProps</code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.stacks.AwsLoggingStack.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.stacks.AwsLoggingStack.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk-extensions.stacks.AwsLoggingStack.Initializer.parameter.props"></a>

- *Type:* cdk-extensions.stacks.AwsLoggingStackProps

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.addDependency">addDependency</a></code> | Add a dependency between this stack and another stack. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.addMetadata">addMetadata</a></code> | Adds an arbitary key-value pair, with information you want to record about the stack. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.addTransform">addTransform</a></code> | Add a Transform to this stack. A Transform is a macro that AWS CloudFormation uses to process your template. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.exportValue">exportValue</a></code> | Create a CloudFormation Export for a value. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.formatArn">formatArn</a></code> | Creates an ARN from components. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.getLogicalId">getLogicalId</a></code> | Allocates a stack-unique CloudFormation-compatible logical identity for a specific resource. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.regionalFact">regionalFact</a></code> | Look up a fact value for the given fact for the region of this stack. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.renameLogicalId">renameLogicalId</a></code> | Rename a generated logical identities. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.reportMissingContextKey">reportMissingContextKey</a></code> | Indicate that a context key was expected. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.resolve">resolve</a></code> | Resolve a tokenized value in the context of the current stack. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.splitArn">splitArn</a></code> | Splits the provided ARN into its components. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.toJsonString">toJsonString</a></code> | Convert an object, potentially containing tokens, to a JSON string. |

---

##### `toString` <a name="toString" id="cdk-extensions.stacks.AwsLoggingStack.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk-extensions.stacks.AwsLoggingStack.addDependency"></a>

```typescript
public addDependency(target: Stack, reason?: string): void
```

Add a dependency between this stack and another stack.

This can be used to define dependencies between any two stacks within an
app, and also supports nested stacks.

###### `target`<sup>Required</sup> <a name="target" id="cdk-extensions.stacks.AwsLoggingStack.addDependency.parameter.target"></a>

- *Type:* aws-cdk-lib.Stack

---

###### `reason`<sup>Optional</sup> <a name="reason" id="cdk-extensions.stacks.AwsLoggingStack.addDependency.parameter.reason"></a>

- *Type:* string

---

##### `addMetadata` <a name="addMetadata" id="cdk-extensions.stacks.AwsLoggingStack.addMetadata"></a>

```typescript
public addMetadata(key: string, value: any): void
```

Adds an arbitary key-value pair, with information you want to record about the stack.

These get translated to the Metadata section of the generated template.

> [https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/metadata-section-structure.html](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/metadata-section-structure.html)

###### `key`<sup>Required</sup> <a name="key" id="cdk-extensions.stacks.AwsLoggingStack.addMetadata.parameter.key"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="cdk-extensions.stacks.AwsLoggingStack.addMetadata.parameter.value"></a>

- *Type:* any

---

##### `addTransform` <a name="addTransform" id="cdk-extensions.stacks.AwsLoggingStack.addTransform"></a>

```typescript
public addTransform(transform: string): void
```

Add a Transform to this stack. A Transform is a macro that AWS CloudFormation uses to process your template.

Duplicate values are removed when stack is synthesized.

> [https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-section-structure.html](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-section-structure.html)

*Example*

```typescript
declare const stack: Stack;

stack.addTransform('AWS::Serverless-2016-10-31')
```


###### `transform`<sup>Required</sup> <a name="transform" id="cdk-extensions.stacks.AwsLoggingStack.addTransform.parameter.transform"></a>

- *Type:* string

The transform to add.

---

##### `exportValue` <a name="exportValue" id="cdk-extensions.stacks.AwsLoggingStack.exportValue"></a>

```typescript
public exportValue(exportedValue: any, options?: ExportValueOptions): string
```

Create a CloudFormation Export for a value.

Returns a string representing the corresponding `Fn.importValue()`
expression for this Export. You can control the name for the export by
passing the `name` option.

If you don't supply a value for `name`, the value you're exporting must be
a Resource attribute (for example: `bucket.bucketName`) and it will be
given the same name as the automatic cross-stack reference that would be created
if you used the attribute in another Stack.

One of the uses for this method is to *remove* the relationship between
two Stacks established by automatic cross-stack references. It will
temporarily ensure that the CloudFormation Export still exists while you
remove the reference from the consuming stack. After that, you can remove
the resource and the manual export.

## Example

Here is how the process works. Let's say there are two stacks,
`producerStack` and `consumerStack`, and `producerStack` has a bucket
called `bucket`, which is referenced by `consumerStack` (perhaps because
an AWS Lambda Function writes into it, or something like that).

It is not safe to remove `producerStack.bucket` because as the bucket is being
deleted, `consumerStack` might still be using it.

Instead, the process takes two deployments:

### Deployment 1: break the relationship

- Make sure `consumerStack` no longer references `bucket.bucketName` (maybe the consumer
   stack now uses its own bucket, or it writes to an AWS DynamoDB table, or maybe you just
   remove the Lambda Function altogether).
- In the `ProducerStack` class, call `this.exportValue(this.bucket.bucketName)`. This
   will make sure the CloudFormation Export continues to exist while the relationship
   between the two stacks is being broken.
- Deploy (this will effectively only change the `consumerStack`, but it's safe to deploy both).

### Deployment 2: remove the bucket resource

- You are now free to remove the `bucket` resource from `producerStack`.
- Don't forget to remove the `exportValue()` call as well.
- Deploy again (this time only the `producerStack` will be changed -- the bucket will be deleted).

###### `exportedValue`<sup>Required</sup> <a name="exportedValue" id="cdk-extensions.stacks.AwsLoggingStack.exportValue.parameter.exportedValue"></a>

- *Type:* any

---

###### `options`<sup>Optional</sup> <a name="options" id="cdk-extensions.stacks.AwsLoggingStack.exportValue.parameter.options"></a>

- *Type:* aws-cdk-lib.ExportValueOptions

---

##### `formatArn` <a name="formatArn" id="cdk-extensions.stacks.AwsLoggingStack.formatArn"></a>

```typescript
public formatArn(components: ArnComponents): string
```

Creates an ARN from components.

If `partition`, `region` or `account` are not specified, the stack's
partition, region and account will be used.

If any component is the empty string, an empty string will be inserted
into the generated ARN at the location that component corresponds to.

The ARN will be formatted as follows:

   arn:{partition}:{service}:{region}:{account}:{resource}{sep}{resource-name}

The required ARN pieces that are omitted will be taken from the stack that
the 'scope' is attached to. If all ARN pieces are supplied, the supplied scope
can be 'undefined'.

###### `components`<sup>Required</sup> <a name="components" id="cdk-extensions.stacks.AwsLoggingStack.formatArn.parameter.components"></a>

- *Type:* aws-cdk-lib.ArnComponents

---

##### `getLogicalId` <a name="getLogicalId" id="cdk-extensions.stacks.AwsLoggingStack.getLogicalId"></a>

```typescript
public getLogicalId(element: CfnElement): string
```

Allocates a stack-unique CloudFormation-compatible logical identity for a specific resource.

This method is called when a `CfnElement` is created and used to render the
initial logical identity of resources. Logical ID renames are applied at
this stage.

This method uses the protected method `allocateLogicalId` to render the
logical ID for an element. To modify the naming scheme, extend the `Stack`
class and override this method.

###### `element`<sup>Required</sup> <a name="element" id="cdk-extensions.stacks.AwsLoggingStack.getLogicalId.parameter.element"></a>

- *Type:* aws-cdk-lib.CfnElement

The CloudFormation element for which a logical identity is needed.

---

##### `regionalFact` <a name="regionalFact" id="cdk-extensions.stacks.AwsLoggingStack.regionalFact"></a>

```typescript
public regionalFact(factName: string, defaultValue?: string): string
```

Look up a fact value for the given fact for the region of this stack.

Will return a definite value only if the region of the current stack is resolved.
If not, a lookup map will be added to the stack and the lookup will be done at
CDK deployment time.

What regions will be included in the lookup map is controlled by the
`@aws-cdk/core:target-partitions` context value: it must be set to a list
of partitions, and only regions from the given partitions will be included.
If no such context key is set, all regions will be included.

This function is intended to be used by construct library authors. Application
builders can rely on the abstractions offered by construct libraries and do
not have to worry about regional facts.

If `defaultValue` is not given, it is an error if the fact is unknown for
the given region.

###### `factName`<sup>Required</sup> <a name="factName" id="cdk-extensions.stacks.AwsLoggingStack.regionalFact.parameter.factName"></a>

- *Type:* string

---

###### `defaultValue`<sup>Optional</sup> <a name="defaultValue" id="cdk-extensions.stacks.AwsLoggingStack.regionalFact.parameter.defaultValue"></a>

- *Type:* string

---

##### `renameLogicalId` <a name="renameLogicalId" id="cdk-extensions.stacks.AwsLoggingStack.renameLogicalId"></a>

```typescript
public renameLogicalId(oldId: string, newId: string): void
```

Rename a generated logical identities.

To modify the naming scheme strategy, extend the `Stack` class and
override the `allocateLogicalId` method.

###### `oldId`<sup>Required</sup> <a name="oldId" id="cdk-extensions.stacks.AwsLoggingStack.renameLogicalId.parameter.oldId"></a>

- *Type:* string

---

###### `newId`<sup>Required</sup> <a name="newId" id="cdk-extensions.stacks.AwsLoggingStack.renameLogicalId.parameter.newId"></a>

- *Type:* string

---

##### `reportMissingContextKey` <a name="reportMissingContextKey" id="cdk-extensions.stacks.AwsLoggingStack.reportMissingContextKey"></a>

```typescript
public reportMissingContextKey(report: MissingContext): void
```

Indicate that a context key was expected.

Contains instructions which will be emitted into the cloud assembly on how
the key should be supplied.

###### `report`<sup>Required</sup> <a name="report" id="cdk-extensions.stacks.AwsLoggingStack.reportMissingContextKey.parameter.report"></a>

- *Type:* aws-cdk-lib.cloud_assembly_schema.MissingContext

The set of parameters needed to obtain the context.

---

##### `resolve` <a name="resolve" id="cdk-extensions.stacks.AwsLoggingStack.resolve"></a>

```typescript
public resolve(obj: any): any
```

Resolve a tokenized value in the context of the current stack.

###### `obj`<sup>Required</sup> <a name="obj" id="cdk-extensions.stacks.AwsLoggingStack.resolve.parameter.obj"></a>

- *Type:* any

---

##### `splitArn` <a name="splitArn" id="cdk-extensions.stacks.AwsLoggingStack.splitArn"></a>

```typescript
public splitArn(arn: string, arnFormat: ArnFormat): ArnComponents
```

Splits the provided ARN into its components.

Works both if 'arn' is a string like 'arn:aws:s3:::bucket',
and a Token representing a dynamic CloudFormation expression
(in which case the returned components will also be dynamic CloudFormation expressions,
encoded as Tokens).

###### `arn`<sup>Required</sup> <a name="arn" id="cdk-extensions.stacks.AwsLoggingStack.splitArn.parameter.arn"></a>

- *Type:* string

the ARN to split into its components.

---

###### `arnFormat`<sup>Required</sup> <a name="arnFormat" id="cdk-extensions.stacks.AwsLoggingStack.splitArn.parameter.arnFormat"></a>

- *Type:* aws-cdk-lib.ArnFormat

the expected format of 'arn' - depends on what format the service 'arn' represents uses.

---

##### `toJsonString` <a name="toJsonString" id="cdk-extensions.stacks.AwsLoggingStack.toJsonString"></a>

```typescript
public toJsonString(obj: any, space?: number): string
```

Convert an object, potentially containing tokens, to a JSON string.

###### `obj`<sup>Required</sup> <a name="obj" id="cdk-extensions.stacks.AwsLoggingStack.toJsonString.parameter.obj"></a>

- *Type:* any

---

###### `space`<sup>Optional</sup> <a name="space" id="cdk-extensions.stacks.AwsLoggingStack.toJsonString.parameter.space"></a>

- *Type:* number

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.isStack">isStack</a></code> | Return whether the given object is a Stack. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.of">of</a></code> | Looks up the first stack scope in which `construct` is defined. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-extensions.stacks.AwsLoggingStack.isConstruct"></a>

```typescript
import { stacks } from 'cdk-extensions'

stacks.AwsLoggingStack.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-extensions.stacks.AwsLoggingStack.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isStack` <a name="isStack" id="cdk-extensions.stacks.AwsLoggingStack.isStack"></a>

```typescript
import { stacks } from 'cdk-extensions'

stacks.AwsLoggingStack.isStack(x: any)
```

Return whether the given object is a Stack.

We do attribute detection since we can't reliably use 'instanceof'.

###### `x`<sup>Required</sup> <a name="x" id="cdk-extensions.stacks.AwsLoggingStack.isStack.parameter.x"></a>

- *Type:* any

---

##### `of` <a name="of" id="cdk-extensions.stacks.AwsLoggingStack.of"></a>

```typescript
import { stacks } from 'cdk-extensions'

stacks.AwsLoggingStack.of(construct: IConstruct)
```

Looks up the first stack scope in which `construct` is defined.

Fails if there is no stack up the tree.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.stacks.AwsLoggingStack.of.parameter.construct"></a>

- *Type:* constructs.IConstruct

The construct to start the search from.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.property.account">account</a></code> | <code>string</code> | The AWS account into which this stack will be deployed. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.property.artifactId">artifactId</a></code> | <code>string</code> | The ID of the cloud assembly artifact for this stack. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.property.availabilityZones">availabilityZones</a></code> | <code>string[]</code> | Returns the list of AZs that are available in the AWS environment (account/region) associated with this stack. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.property.bundlingRequired">bundlingRequired</a></code> | <code>boolean</code> | Indicates whether the stack requires bundling or not. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.property.dependencies">dependencies</a></code> | <code>aws-cdk-lib.Stack[]</code> | Return the stacks this stack depends on. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.property.environment">environment</a></code> | <code>string</code> | The environment coordinates in which this stack is deployed. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.property.nested">nested</a></code> | <code>boolean</code> | Indicates if this is a nested stack, in which case `parentStack` will include a reference to it's parent. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.property.notificationArns">notificationArns</a></code> | <code>string[]</code> | Returns the list of notification Amazon Resource Names (ARNs) for the current stack. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.property.partition">partition</a></code> | <code>string</code> | The partition in which this stack is defined. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.property.region">region</a></code> | <code>string</code> | The AWS region into which this stack will be deployed (e.g. `us-west-2`). |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.property.stackId">stackId</a></code> | <code>string</code> | The ID of the stack. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.property.stackName">stackName</a></code> | <code>string</code> | The concrete CloudFormation physical stack name. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.property.synthesizer">synthesizer</a></code> | <code>aws-cdk-lib.IStackSynthesizer</code> | Synthesis method for this stack. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.property.tags">tags</a></code> | <code>aws-cdk-lib.TagManager</code> | Tags to be applied to the stack. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.property.templateFile">templateFile</a></code> | <code>string</code> | The name of the CloudFormation template file emitted to the output directory during synthesis. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.property.templateOptions">templateOptions</a></code> | <code>aws-cdk-lib.ITemplateOptions</code> | Options for CloudFormation template (like version, transform, description). |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.property.urlSuffix">urlSuffix</a></code> | <code>string</code> | The Amazon domain suffix for the region in which this stack is defined. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.property.nestedStackParent">nestedStackParent</a></code> | <code>aws-cdk-lib.Stack</code> | If this is a nested stack, returns it's parent stack. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.property.nestedStackResource">nestedStackResource</a></code> | <code>aws-cdk-lib.CfnResource</code> | If this is a nested stack, this represents its `AWS::CloudFormation::Stack` resource. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.property.terminationProtection">terminationProtection</a></code> | <code>boolean</code> | Whether termination protection is enabled for this stack. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.property.albLogsBucket">albLogsBucket</a></code> | <code>cdk-extensions.s3_buckets.AlbLogsBucket</code> | *No description.* |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.property.cloudfrontLogsBucket">cloudfrontLogsBucket</a></code> | <code>cdk-extensions.s3_buckets.CloudfrontLogsBucket</code> | *No description.* |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.property.cloudtrailLogsBucket">cloudtrailLogsBucket</a></code> | <code>cdk-extensions.s3_buckets.CloudtrailBucket</code> | *No description.* |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.property.database">database</a></code> | <code>cdk-extensions.glue.Database</code> | *No description.* |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.property.databaseName">databaseName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.property.flowLogsBucket">flowLogsBucket</a></code> | <code>cdk-extensions.s3_buckets.FlowLogsBucket</code> | *No description.* |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.property.flowLogsFormat">flowLogsFormat</a></code> | <code>cdk-extensions.ec2.FlowLogFormat</code> | *No description.* |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.property.s3AccessLogsBucket">s3AccessLogsBucket</a></code> | <code>cdk-extensions.s3_buckets.S3AccessLogsBucket</code> | *No description.* |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.property.sesLogsBucket">sesLogsBucket</a></code> | <code>cdk-extensions.s3_buckets.SesLogsBucket</code> | *No description.* |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.property.standardizeNames">standardizeNames</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.property.wafLogsBucket">wafLogsBucket</a></code> | <code>cdk-extensions.s3_buckets.WafLogsBucket</code> | *No description.* |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStack.property.friendlyQueryNames">friendlyQueryNames</a></code> | <code>boolean</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-extensions.stacks.AwsLoggingStack.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `account`<sup>Required</sup> <a name="account" id="cdk-extensions.stacks.AwsLoggingStack.property.account"></a>

```typescript
public readonly account: string;
```

- *Type:* string

The AWS account into which this stack will be deployed.

This value is resolved according to the following rules:

1. The value provided to `env.account` when the stack is defined. This can
    either be a concrete account (e.g. `585695031111`) or the
    `Aws.ACCOUNT_ID` token.
3. `Aws.ACCOUNT_ID`, which represents the CloudFormation intrinsic reference
    `{ "Ref": "AWS::AccountId" }` encoded as a string token.

Preferably, you should use the return value as an opaque string and not
attempt to parse it to implement your logic. If you do, you must first
check that it is a concerete value an not an unresolved token. If this
value is an unresolved token (`Token.isUnresolved(stack.account)` returns
`true`), this implies that the user wishes that this stack will synthesize
into a **account-agnostic template**. In this case, your code should either
fail (throw an error, emit a synth error using `Annotations.of(construct).addError()`) or
implement some other region-agnostic behavior.

---

##### `artifactId`<sup>Required</sup> <a name="artifactId" id="cdk-extensions.stacks.AwsLoggingStack.property.artifactId"></a>

```typescript
public readonly artifactId: string;
```

- *Type:* string

The ID of the cloud assembly artifact for this stack.

---

##### `availabilityZones`<sup>Required</sup> <a name="availabilityZones" id="cdk-extensions.stacks.AwsLoggingStack.property.availabilityZones"></a>

```typescript
public readonly availabilityZones: string[];
```

- *Type:* string[]

Returns the list of AZs that are available in the AWS environment (account/region) associated with this stack.

If the stack is environment-agnostic (either account and/or region are
tokens), this property will return an array with 2 tokens that will resolve
at deploy-time to the first two availability zones returned from CloudFormation's
`Fn::GetAZs` intrinsic function.

If they are not available in the context, returns a set of dummy values and
reports them as missing, and let the CLI resolve them by calling EC2
`DescribeAvailabilityZones` on the target environment.

To specify a different strategy for selecting availability zones override this method.

---

##### `bundlingRequired`<sup>Required</sup> <a name="bundlingRequired" id="cdk-extensions.stacks.AwsLoggingStack.property.bundlingRequired"></a>

```typescript
public readonly bundlingRequired: boolean;
```

- *Type:* boolean

Indicates whether the stack requires bundling or not.

---

##### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk-extensions.stacks.AwsLoggingStack.property.dependencies"></a>

```typescript
public readonly dependencies: Stack[];
```

- *Type:* aws-cdk-lib.Stack[]

Return the stacks this stack depends on.

---

##### `environment`<sup>Required</sup> <a name="environment" id="cdk-extensions.stacks.AwsLoggingStack.property.environment"></a>

```typescript
public readonly environment: string;
```

- *Type:* string

The environment coordinates in which this stack is deployed.

In the form
`aws://account/region`. Use `stack.account` and `stack.region` to obtain
the specific values, no need to parse.

You can use this value to determine if two stacks are targeting the same
environment.

If either `stack.account` or `stack.region` are not concrete values (e.g.
`Aws.ACCOUNT_ID` or `Aws.REGION`) the special strings `unknown-account` and/or
`unknown-region` will be used respectively to indicate this stack is
region/account-agnostic.

---

##### `nested`<sup>Required</sup> <a name="nested" id="cdk-extensions.stacks.AwsLoggingStack.property.nested"></a>

```typescript
public readonly nested: boolean;
```

- *Type:* boolean

Indicates if this is a nested stack, in which case `parentStack` will include a reference to it's parent.

---

##### `notificationArns`<sup>Required</sup> <a name="notificationArns" id="cdk-extensions.stacks.AwsLoggingStack.property.notificationArns"></a>

```typescript
public readonly notificationArns: string[];
```

- *Type:* string[]

Returns the list of notification Amazon Resource Names (ARNs) for the current stack.

---

##### `partition`<sup>Required</sup> <a name="partition" id="cdk-extensions.stacks.AwsLoggingStack.property.partition"></a>

```typescript
public readonly partition: string;
```

- *Type:* string

The partition in which this stack is defined.

---

##### `region`<sup>Required</sup> <a name="region" id="cdk-extensions.stacks.AwsLoggingStack.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string

The AWS region into which this stack will be deployed (e.g. `us-west-2`).

This value is resolved according to the following rules:

1. The value provided to `env.region` when the stack is defined. This can
    either be a concerete region (e.g. `us-west-2`) or the `Aws.REGION`
    token.
3. `Aws.REGION`, which is represents the CloudFormation intrinsic reference
    `{ "Ref": "AWS::Region" }` encoded as a string token.

Preferably, you should use the return value as an opaque string and not
attempt to parse it to implement your logic. If you do, you must first
check that it is a concerete value an not an unresolved token. If this
value is an unresolved token (`Token.isUnresolved(stack.region)` returns
`true`), this implies that the user wishes that this stack will synthesize
into a **region-agnostic template**. In this case, your code should either
fail (throw an error, emit a synth error using `Annotations.of(construct).addError()`) or
implement some other region-agnostic behavior.

---

##### `stackId`<sup>Required</sup> <a name="stackId" id="cdk-extensions.stacks.AwsLoggingStack.property.stackId"></a>

```typescript
public readonly stackId: string;
```

- *Type:* string

The ID of the stack.

---

*Example*

```typescript
// After resolving, looks like
'arn:aws:cloudformation:us-west-2:123456789012:stack/teststack/51af3dc0-da77-11e4-872e-1234567db123'
```


##### `stackName`<sup>Required</sup> <a name="stackName" id="cdk-extensions.stacks.AwsLoggingStack.property.stackName"></a>

```typescript
public readonly stackName: string;
```

- *Type:* string

The concrete CloudFormation physical stack name.

This is either the name defined explicitly in the `stackName` prop or
allocated based on the stack's location in the construct tree. Stacks that
are directly defined under the app use their construct `id` as their stack
name. Stacks that are defined deeper within the tree will use a hashed naming
scheme based on the construct path to ensure uniqueness.

If you wish to obtain the deploy-time AWS::StackName intrinsic,
you can use `Aws.STACK_NAME` directly.

---

##### `synthesizer`<sup>Required</sup> <a name="synthesizer" id="cdk-extensions.stacks.AwsLoggingStack.property.synthesizer"></a>

```typescript
public readonly synthesizer: IStackSynthesizer;
```

- *Type:* aws-cdk-lib.IStackSynthesizer

Synthesis method for this stack.

---

##### `tags`<sup>Required</sup> <a name="tags" id="cdk-extensions.stacks.AwsLoggingStack.property.tags"></a>

```typescript
public readonly tags: TagManager;
```

- *Type:* aws-cdk-lib.TagManager

Tags to be applied to the stack.

---

##### `templateFile`<sup>Required</sup> <a name="templateFile" id="cdk-extensions.stacks.AwsLoggingStack.property.templateFile"></a>

```typescript
public readonly templateFile: string;
```

- *Type:* string

The name of the CloudFormation template file emitted to the output directory during synthesis.

Example value: `MyStack.template.json`

---

##### `templateOptions`<sup>Required</sup> <a name="templateOptions" id="cdk-extensions.stacks.AwsLoggingStack.property.templateOptions"></a>

```typescript
public readonly templateOptions: ITemplateOptions;
```

- *Type:* aws-cdk-lib.ITemplateOptions

Options for CloudFormation template (like version, transform, description).

---

##### `urlSuffix`<sup>Required</sup> <a name="urlSuffix" id="cdk-extensions.stacks.AwsLoggingStack.property.urlSuffix"></a>

```typescript
public readonly urlSuffix: string;
```

- *Type:* string

The Amazon domain suffix for the region in which this stack is defined.

---

##### `nestedStackParent`<sup>Optional</sup> <a name="nestedStackParent" id="cdk-extensions.stacks.AwsLoggingStack.property.nestedStackParent"></a>

```typescript
public readonly nestedStackParent: Stack;
```

- *Type:* aws-cdk-lib.Stack

If this is a nested stack, returns it's parent stack.

---

##### `nestedStackResource`<sup>Optional</sup> <a name="nestedStackResource" id="cdk-extensions.stacks.AwsLoggingStack.property.nestedStackResource"></a>

```typescript
public readonly nestedStackResource: CfnResource;
```

- *Type:* aws-cdk-lib.CfnResource

If this is a nested stack, this represents its `AWS::CloudFormation::Stack` resource.

`undefined` for top-level (non-nested) stacks.

---

##### `terminationProtection`<sup>Optional</sup> <a name="terminationProtection" id="cdk-extensions.stacks.AwsLoggingStack.property.terminationProtection"></a>

```typescript
public readonly terminationProtection: boolean;
```

- *Type:* boolean

Whether termination protection is enabled for this stack.

---

##### `albLogsBucket`<sup>Required</sup> <a name="albLogsBucket" id="cdk-extensions.stacks.AwsLoggingStack.property.albLogsBucket"></a>

```typescript
public readonly albLogsBucket: AlbLogsBucket;
```

- *Type:* cdk-extensions.s3_buckets.AlbLogsBucket

---

##### `cloudfrontLogsBucket`<sup>Required</sup> <a name="cloudfrontLogsBucket" id="cdk-extensions.stacks.AwsLoggingStack.property.cloudfrontLogsBucket"></a>

```typescript
public readonly cloudfrontLogsBucket: CloudfrontLogsBucket;
```

- *Type:* cdk-extensions.s3_buckets.CloudfrontLogsBucket

---

##### `cloudtrailLogsBucket`<sup>Required</sup> <a name="cloudtrailLogsBucket" id="cdk-extensions.stacks.AwsLoggingStack.property.cloudtrailLogsBucket"></a>

```typescript
public readonly cloudtrailLogsBucket: CloudtrailBucket;
```

- *Type:* cdk-extensions.s3_buckets.CloudtrailBucket

---

##### `database`<sup>Required</sup> <a name="database" id="cdk-extensions.stacks.AwsLoggingStack.property.database"></a>

```typescript
public readonly database: Database;
```

- *Type:* cdk-extensions.glue.Database

---

##### `databaseName`<sup>Required</sup> <a name="databaseName" id="cdk-extensions.stacks.AwsLoggingStack.property.databaseName"></a>

```typescript
public readonly databaseName: string;
```

- *Type:* string

---

##### `flowLogsBucket`<sup>Required</sup> <a name="flowLogsBucket" id="cdk-extensions.stacks.AwsLoggingStack.property.flowLogsBucket"></a>

```typescript
public readonly flowLogsBucket: FlowLogsBucket;
```

- *Type:* cdk-extensions.s3_buckets.FlowLogsBucket

---

##### `flowLogsFormat`<sup>Required</sup> <a name="flowLogsFormat" id="cdk-extensions.stacks.AwsLoggingStack.property.flowLogsFormat"></a>

```typescript
public readonly flowLogsFormat: FlowLogFormat;
```

- *Type:* cdk-extensions.ec2.FlowLogFormat

---

##### `s3AccessLogsBucket`<sup>Required</sup> <a name="s3AccessLogsBucket" id="cdk-extensions.stacks.AwsLoggingStack.property.s3AccessLogsBucket"></a>

```typescript
public readonly s3AccessLogsBucket: S3AccessLogsBucket;
```

- *Type:* cdk-extensions.s3_buckets.S3AccessLogsBucket

---

##### `sesLogsBucket`<sup>Required</sup> <a name="sesLogsBucket" id="cdk-extensions.stacks.AwsLoggingStack.property.sesLogsBucket"></a>

```typescript
public readonly sesLogsBucket: SesLogsBucket;
```

- *Type:* cdk-extensions.s3_buckets.SesLogsBucket

---

##### `standardizeNames`<sup>Required</sup> <a name="standardizeNames" id="cdk-extensions.stacks.AwsLoggingStack.property.standardizeNames"></a>

```typescript
public readonly standardizeNames: boolean;
```

- *Type:* boolean

---

##### `wafLogsBucket`<sup>Required</sup> <a name="wafLogsBucket" id="cdk-extensions.stacks.AwsLoggingStack.property.wafLogsBucket"></a>

```typescript
public readonly wafLogsBucket: WafLogsBucket;
```

- *Type:* cdk-extensions.s3_buckets.WafLogsBucket

---

##### `friendlyQueryNames`<sup>Optional</sup> <a name="friendlyQueryNames" id="cdk-extensions.stacks.AwsLoggingStack.property.friendlyQueryNames"></a>

```typescript
public readonly friendlyQueryNames: boolean;
```

- *Type:* boolean

---


### CloudfrontLogsBucket <a name="CloudfrontLogsBucket" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket"></a>

#### Initializers <a name="Initializers" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.Initializer"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

new s3_buckets.CloudfrontLogsBucket(scope: Construct, id: string, props?: CloudfrontLogsBucketProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | A CDK Construct that will serve as this stack's parent in the construct tree. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.Initializer.parameter.id">id</a></code> | <code>string</code> | A name to be associated with the stack and used in resource naming. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.Initializer.parameter.props">props</a></code> | <code>cdk-extensions.s3_buckets.CloudfrontLogsBucketProps</code> | Arguments related to the configuration of the resource. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

A CDK Construct that will serve as this stack's parent in the construct tree.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.Initializer.parameter.id"></a>

- *Type:* string

A name to be associated with the stack and used in resource naming.

Must be unique
within the context of 'scope'.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.Initializer.parameter.props"></a>

- *Type:* cdk-extensions.s3_buckets.CloudfrontLogsBucketProps

Arguments related to the configuration of the resource.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.addEventNotification">addEventNotification</a></code> | Adds a bucket notification event destination. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.addObjectCreatedNotification">addObjectCreatedNotification</a></code> | Subscribes a destination to receive notifications when an object is created in the bucket. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.addObjectRemovedNotification">addObjectRemovedNotification</a></code> | Subscribes a destination to receive notifications when an object is removed from the bucket. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.addToResourcePolicy">addToResourcePolicy</a></code> | Adds a statement to the resource policy for a principal (i.e. account/role/service) to perform actions on this bucket and/or its contents. Use `bucketArn` and `arnForObjects(keys)` to obtain ARNs for this bucket or objects. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.arnForObjects">arnForObjects</a></code> | Returns an ARN that represents all objects within the bucket that match the key pattern specified. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.enableEventBridgeNotification">enableEventBridgeNotification</a></code> | Enables event bridge notification, causing all events below to be sent to EventBridge:. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.grantDelete">grantDelete</a></code> | Grants s3:DeleteObject* permission to an IAM principal for objects in this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.grantPublicAccess">grantPublicAccess</a></code> | Allows unrestricted access to objects from this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.grantPut">grantPut</a></code> | Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.grantPutAcl">grantPutAcl</a></code> | Grant the given IAM identity permissions to modify the ACLs of objects in the given Bucket. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.grantRead">grantRead</a></code> | Grant read permissions for this bucket and it's contents to an IAM principal (Role/Group/User). |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.grantReadWrite">grantReadWrite</a></code> | Grants read/write permissions for this bucket and it's contents to an IAM principal (Role/Group/User). |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.grantWrite">grantWrite</a></code> | Grant write permissions to this bucket to an IAM principal. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.onCloudTrailEvent">onCloudTrailEvent</a></code> | Defines a CloudWatch event that triggers when something happens to this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.onCloudTrailPutObject">onCloudTrailPutObject</a></code> | Defines an AWS CloudWatch event that triggers when an object is uploaded to the specified paths (keys) in this bucket using the PutObject API call. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.onCloudTrailWriteObject">onCloudTrailWriteObject</a></code> | Defines an AWS CloudWatch event that triggers when an object at the specified paths (keys) in this bucket are written to. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.s3UrlForObject">s3UrlForObject</a></code> | The S3 URL of an S3 object. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.transferAccelerationUrlForObject">transferAccelerationUrlForObject</a></code> | The https Transfer Acceleration URL of an S3 object. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.urlForObject">urlForObject</a></code> | The https URL of an S3 object. For example:. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.virtualHostedUrlForObject">virtualHostedUrlForObject</a></code> | The virtual hosted-style URL of an S3 object. Specify `regional: false` at the options for non-regional URL. For example:. |

---

##### `toString` <a name="toString" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.applyRemovalPolicy"></a>

```typescript
public applyRemovalPolicy(policy: RemovalPolicy): void
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.RemovalPolicy

---

##### `addEventNotification` <a name="addEventNotification" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.addEventNotification"></a>

```typescript
public addEventNotification(_event: EventType, _dest: IBucketNotificationDestination, _filters: NotificationKeyFilter): void
```

Adds a bucket notification event destination.

###### `_event`<sup>Required</sup> <a name="_event" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.addEventNotification.parameter._event"></a>

- *Type:* aws-cdk-lib.aws_s3.EventType

---

###### `_dest`<sup>Required</sup> <a name="_dest" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.addEventNotification.parameter._dest"></a>

- *Type:* aws-cdk-lib.aws_s3.IBucketNotificationDestination

---

###### `_filters`<sup>Required</sup> <a name="_filters" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.addEventNotification.parameter._filters"></a>

- *Type:* aws-cdk-lib.aws_s3.NotificationKeyFilter

---

##### `addObjectCreatedNotification` <a name="addObjectCreatedNotification" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.addObjectCreatedNotification"></a>

```typescript
public addObjectCreatedNotification(_dest: IBucketNotificationDestination, _filters: NotificationKeyFilter): void
```

Subscribes a destination to receive notifications when an object is created in the bucket.

This is identical to calling
`onEvent(s3.EventType.OBJECT_CREATED)`.

###### `_dest`<sup>Required</sup> <a name="_dest" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.addObjectCreatedNotification.parameter._dest"></a>

- *Type:* aws-cdk-lib.aws_s3.IBucketNotificationDestination

---

###### `_filters`<sup>Required</sup> <a name="_filters" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.addObjectCreatedNotification.parameter._filters"></a>

- *Type:* aws-cdk-lib.aws_s3.NotificationKeyFilter

---

##### `addObjectRemovedNotification` <a name="addObjectRemovedNotification" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.addObjectRemovedNotification"></a>

```typescript
public addObjectRemovedNotification(_dest: IBucketNotificationDestination, _filters: NotificationKeyFilter): void
```

Subscribes a destination to receive notifications when an object is removed from the bucket.

This is identical to calling
`onEvent(EventType.OBJECT_REMOVED)`.

###### `_dest`<sup>Required</sup> <a name="_dest" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.addObjectRemovedNotification.parameter._dest"></a>

- *Type:* aws-cdk-lib.aws_s3.IBucketNotificationDestination

---

###### `_filters`<sup>Required</sup> <a name="_filters" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.addObjectRemovedNotification.parameter._filters"></a>

- *Type:* aws-cdk-lib.aws_s3.NotificationKeyFilter

---

##### `addToResourcePolicy` <a name="addToResourcePolicy" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.addToResourcePolicy"></a>

```typescript
public addToResourcePolicy(permission: PolicyStatement): AddToResourcePolicyResult
```

Adds a statement to the resource policy for a principal (i.e. account/role/service) to perform actions on this bucket and/or its contents. Use `bucketArn` and `arnForObjects(keys)` to obtain ARNs for this bucket or objects.

Note that the policy statement may or may not be added to the policy.
For example, when an `IBucket` is created from an existing bucket,
it's not possible to tell whether the bucket already has a policy
attached, let alone to re-use that policy to add more statements to it.
So it's safest to do nothing in these cases.

###### `permission`<sup>Required</sup> <a name="permission" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.addToResourcePolicy.parameter.permission"></a>

- *Type:* aws-cdk-lib.aws_iam.PolicyStatement

---

##### `arnForObjects` <a name="arnForObjects" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.arnForObjects"></a>

```typescript
public arnForObjects(_keyPattern: string): string
```

Returns an ARN that represents all objects within the bucket that match the key pattern specified.

To represent all keys, specify ``"*"``.

###### `_keyPattern`<sup>Required</sup> <a name="_keyPattern" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.arnForObjects.parameter._keyPattern"></a>

- *Type:* string

---

##### `enableEventBridgeNotification` <a name="enableEventBridgeNotification" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.enableEventBridgeNotification"></a>

```typescript
public enableEventBridgeNotification(): void
```

Enables event bridge notification, causing all events below to be sent to EventBridge:.

Object Deleted (DeleteObject)
- Object Deleted (Lifecycle expiration)
- Object Restore Initiated
- Object Restore Completed
- Object Restore Expired
- Object Storage Class Changed
- Object Access Tier Changed
- Object ACL Updated
- Object Tags Added
- Object Tags Deleted

##### `grantDelete` <a name="grantDelete" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.grantDelete"></a>

```typescript
public grantDelete(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grants s3:DeleteObject* permission to an IAM principal for objects in this bucket.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.grantDelete.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.grantDelete.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `grantPublicAccess` <a name="grantPublicAccess" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.grantPublicAccess"></a>

```typescript
public grantPublicAccess(_allowedActions: string, _keyPrefix?: string): Grant
```

Allows unrestricted access to objects from this bucket.

IMPORTANT: This permission allows anyone to perform actions on S3 objects
in this bucket, which is useful for when you configure your bucket as a
website and want everyone to be able to read objects in the bucket without
needing to authenticate.

Without arguments, this method will grant read ("s3:GetObject") access to
all objects ("*") in the bucket.

The method returns the `iam.Grant` object, which can then be modified
as needed. For example, you can add a condition that will restrict access only
to an IPv4 range like this:

     const grant = bucket.grantPublicAccess();
     grant.resourceStatement!.addCondition(‘IpAddress’, { “aws:SourceIp”: “54.240.143.0/24” });

###### `_allowedActions`<sup>Required</sup> <a name="_allowedActions" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.grantPublicAccess.parameter._allowedActions"></a>

- *Type:* string

---

###### `_keyPrefix`<sup>Optional</sup> <a name="_keyPrefix" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.grantPublicAccess.parameter._keyPrefix"></a>

- *Type:* string

---

##### `grantPut` <a name="grantPut" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.grantPut"></a>

```typescript
public grantPut(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal.

If encryption is used, permission to use the key to encrypt the contents
of written files will also be granted to the same principal.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.grantPut.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.grantPut.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `grantPutAcl` <a name="grantPutAcl" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.grantPutAcl"></a>

```typescript
public grantPutAcl(_identity: IGrantable, _objectsKeyPattern?: string): Grant
```

Grant the given IAM identity permissions to modify the ACLs of objects in the given Bucket.

If your application has the '@aws-cdk/aws-s3:grantWriteWithoutAcl' feature flag set,
calling {@link grantWrite} or {@link grantReadWrite} no longer grants permissions to modify the ACLs of the objects;
in this case, if you need to modify object ACLs, call this method explicitly.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.grantPutAcl.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.grantPutAcl.parameter._objectsKeyPattern"></a>

- *Type:* string

---

##### `grantRead` <a name="grantRead" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.grantRead"></a>

```typescript
public grantRead(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grant read permissions for this bucket and it's contents to an IAM principal (Role/Group/User).

If encryption is used, permission to use the key to decrypt the contents
of the bucket will also be granted to the same principal.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.grantRead.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.grantRead.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `grantReadWrite` <a name="grantReadWrite" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.grantReadWrite"></a>

```typescript
public grantReadWrite(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grants read/write permissions for this bucket and it's contents to an IAM principal (Role/Group/User).

If an encryption key is used, permission to use the key for
encrypt/decrypt will also be granted.

Before CDK version 1.85.0, this method granted the `s3:PutObject*` permission that included `s3:PutObjectAcl`,
which could be used to grant read/write object access to IAM principals in other accounts.
If you want to get rid of that behavior, update your CDK version to 1.85.0 or later,
and make sure the `@aws-cdk/aws-s3:grantWriteWithoutAcl` feature flag is set to `true`
in the `context` key of your cdk.json file.
If you've already updated, but still need the principal to have permissions to modify the ACLs,
use the {@link grantPutAcl} method.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.grantReadWrite.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.grantReadWrite.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `grantWrite` <a name="grantWrite" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.grantWrite"></a>

```typescript
public grantWrite(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grant write permissions to this bucket to an IAM principal.

If encryption is used, permission to use the key to encrypt the contents
of written files will also be granted to the same principal.

Before CDK version 1.85.0, this method granted the `s3:PutObject*` permission that included `s3:PutObjectAcl`,
which could be used to grant read/write object access to IAM principals in other accounts.
If you want to get rid of that behavior, update your CDK version to 1.85.0 or later,
and make sure the `@aws-cdk/aws-s3:grantWriteWithoutAcl` feature flag is set to `true`
in the `context` key of your cdk.json file.
If you've already updated, but still need the principal to have permissions to modify the ACLs,
use the {@link grantPutAcl} method.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.grantWrite.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.grantWrite.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `onCloudTrailEvent` <a name="onCloudTrailEvent" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.onCloudTrailEvent"></a>

```typescript
public onCloudTrailEvent(_id: string, _options?: OnCloudTrailBucketEventOptions): Rule
```

Defines a CloudWatch event that triggers when something happens to this bucket.

Requires that there exists at least one CloudTrail Trail in your account
that captures the event. This method will not create the Trail.

###### `_id`<sup>Required</sup> <a name="_id" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.onCloudTrailEvent.parameter._id"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.onCloudTrailEvent.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.OnCloudTrailBucketEventOptions

---

##### `onCloudTrailPutObject` <a name="onCloudTrailPutObject" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.onCloudTrailPutObject"></a>

```typescript
public onCloudTrailPutObject(_id: string, _options?: OnCloudTrailBucketEventOptions): Rule
```

Defines an AWS CloudWatch event that triggers when an object is uploaded to the specified paths (keys) in this bucket using the PutObject API call.

Note that some tools like `aws s3 cp` will automatically use either
PutObject or the multipart upload API depending on the file size,
so using `onCloudTrailWriteObject` may be preferable.

Requires that there exists at least one CloudTrail Trail in your account
that captures the event. This method will not create the Trail.

###### `_id`<sup>Required</sup> <a name="_id" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.onCloudTrailPutObject.parameter._id"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.onCloudTrailPutObject.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.OnCloudTrailBucketEventOptions

---

##### `onCloudTrailWriteObject` <a name="onCloudTrailWriteObject" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.onCloudTrailWriteObject"></a>

```typescript
public onCloudTrailWriteObject(_id: string, _options?: OnCloudTrailBucketEventOptions): Rule
```

Defines an AWS CloudWatch event that triggers when an object at the specified paths (keys) in this bucket are written to.

This includes
the events PutObject, CopyObject, and CompleteMultipartUpload.

Note that some tools like `aws s3 cp` will automatically use either
PutObject or the multipart upload API depending on the file size,
so using this method may be preferable to `onCloudTrailPutObject`.

Requires that there exists at least one CloudTrail Trail in your account
that captures the event. This method will not create the Trail.

###### `_id`<sup>Required</sup> <a name="_id" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.onCloudTrailWriteObject.parameter._id"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.onCloudTrailWriteObject.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.OnCloudTrailBucketEventOptions

---

##### `s3UrlForObject` <a name="s3UrlForObject" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.s3UrlForObject"></a>

```typescript
public s3UrlForObject(_key?: string): string
```

The S3 URL of an S3 object.

For example:
- `s3://onlybucket`
- `s3://bucket/key`

###### `_key`<sup>Optional</sup> <a name="_key" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.s3UrlForObject.parameter._key"></a>

- *Type:* string

---

##### `transferAccelerationUrlForObject` <a name="transferAccelerationUrlForObject" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.transferAccelerationUrlForObject"></a>

```typescript
public transferAccelerationUrlForObject(_key?: string, _options?: TransferAccelerationUrlOptions): string
```

The https Transfer Acceleration URL of an S3 object.

Specify `dualStack: true` at the options
for dual-stack endpoint (connect to the bucket over IPv6). For example:

- `https://bucket.s3-accelerate.amazonaws.com`
- `https://bucket.s3-accelerate.amazonaws.com/key`

###### `_key`<sup>Optional</sup> <a name="_key" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.transferAccelerationUrlForObject.parameter._key"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.transferAccelerationUrlForObject.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.TransferAccelerationUrlOptions

---

##### `urlForObject` <a name="urlForObject" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.urlForObject"></a>

```typescript
public urlForObject(_key?: string): string
```

The https URL of an S3 object. For example:.

`https://s3.us-west-1.amazonaws.com/onlybucket`
- `https://s3.us-west-1.amazonaws.com/bucket/key`
- `https://s3.cn-north-1.amazonaws.com.cn/china-bucket/mykey`

###### `_key`<sup>Optional</sup> <a name="_key" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.urlForObject.parameter._key"></a>

- *Type:* string

---

##### `virtualHostedUrlForObject` <a name="virtualHostedUrlForObject" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.virtualHostedUrlForObject"></a>

```typescript
public virtualHostedUrlForObject(_key?: string, _options?: VirtualHostedStyleUrlOptions): string
```

The virtual hosted-style URL of an S3 object. Specify `regional: false` at the options for non-regional URL. For example:.

`https://only-bucket.s3.us-west-1.amazonaws.com`
- `https://bucket.s3.us-west-1.amazonaws.com/key`
- `https://bucket.s3.amazonaws.com/key`
- `https://china-bucket.s3.cn-north-1.amazonaws.com.cn/mykey`

###### `_key`<sup>Optional</sup> <a name="_key" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.virtualHostedUrlForObject.parameter._key"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.virtualHostedUrlForObject.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.VirtualHostedStyleUrlOptions

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.isOwnedResource">isOwnedResource</a></code> | Returns true if the construct was created by CDK, and false otherwise. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.isResource">isResource</a></code> | Check whether the given construct is a Resource. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.isConstruct"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

s3_buckets.CloudfrontLogsBucket.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isOwnedResource` <a name="isOwnedResource" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.isOwnedResource"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

s3_buckets.CloudfrontLogsBucket.isOwnedResource(construct: IConstruct)
```

Returns true if the construct was created by CDK, and false otherwise.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.isOwnedResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `isResource` <a name="isResource" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.isResource"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

s3_buckets.CloudfrontLogsBucket.isResource(construct: IConstruct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.property.env">env</a></code> | <code>aws-cdk-lib.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.property.stack">stack</a></code> | <code>aws-cdk-lib.Stack</code> | The stack in which this resource is defined. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.property.bucketArn">bucketArn</a></code> | <code>string</code> | The ARN of the bucket. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.property.bucketDomainName">bucketDomainName</a></code> | <code>string</code> | The IPv4 DNS name of the specified bucket. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.property.bucketDualStackDomainName">bucketDualStackDomainName</a></code> | <code>string</code> | The IPv6 DNS name of the specified bucket. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.property.bucketName">bucketName</a></code> | <code>string</code> | The name of the bucket. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.property.bucketRegionalDomainName">bucketRegionalDomainName</a></code> | <code>string</code> | The regional domain name of the specified bucket. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.property.bucketWebsiteDomainName">bucketWebsiteDomainName</a></code> | <code>string</code> | The Domain name of the static website. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.property.bucketWebsiteUrl">bucketWebsiteUrl</a></code> | <code>string</code> | The URL of the static website. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.property.resource">resource</a></code> | <code>aws-cdk-lib.aws_s3.CfnBucket</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.property.encryptionKey">encryptionKey</a></code> | <code>aws-cdk-lib.aws_kms.IKey</code> | Optional KMS encryption key associated with this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.property.isWebsite">isWebsite</a></code> | <code>boolean</code> | If this bucket has been configured for static website hosting. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.property.policy">policy</a></code> | <code>aws-cdk-lib.aws_s3.BucketPolicy</code> | The resource policy associated with this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.property.database">database</a></code> | <code>cdk-extensions.glue.Database</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.property.table">table</a></code> | <code>cdk-extensions.glue_tables.CloudfrontLogsTable</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.property.createQueries">createQueries</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucket.property.friendlyQueryNames">friendlyQueryNames</a></code> | <code>boolean</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.property.env"></a>

```typescript
public readonly env: ResourceEnvironment;
```

- *Type:* aws-cdk-lib.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.property.stack"></a>

```typescript
public readonly stack: Stack;
```

- *Type:* aws-cdk-lib.Stack

The stack in which this resource is defined.

---

##### `bucketArn`<sup>Required</sup> <a name="bucketArn" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.property.bucketArn"></a>

```typescript
public readonly bucketArn: string;
```

- *Type:* string

The ARN of the bucket.

---

##### `bucketDomainName`<sup>Required</sup> <a name="bucketDomainName" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.property.bucketDomainName"></a>

```typescript
public readonly bucketDomainName: string;
```

- *Type:* string

The IPv4 DNS name of the specified bucket.

---

##### `bucketDualStackDomainName`<sup>Required</sup> <a name="bucketDualStackDomainName" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.property.bucketDualStackDomainName"></a>

```typescript
public readonly bucketDualStackDomainName: string;
```

- *Type:* string

The IPv6 DNS name of the specified bucket.

---

##### `bucketName`<sup>Required</sup> <a name="bucketName" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.property.bucketName"></a>

```typescript
public readonly bucketName: string;
```

- *Type:* string

The name of the bucket.

---

##### `bucketRegionalDomainName`<sup>Required</sup> <a name="bucketRegionalDomainName" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.property.bucketRegionalDomainName"></a>

```typescript
public readonly bucketRegionalDomainName: string;
```

- *Type:* string

The regional domain name of the specified bucket.

---

##### `bucketWebsiteDomainName`<sup>Required</sup> <a name="bucketWebsiteDomainName" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.property.bucketWebsiteDomainName"></a>

```typescript
public readonly bucketWebsiteDomainName: string;
```

- *Type:* string

The Domain name of the static website.

---

##### `bucketWebsiteUrl`<sup>Required</sup> <a name="bucketWebsiteUrl" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.property.bucketWebsiteUrl"></a>

```typescript
public readonly bucketWebsiteUrl: string;
```

- *Type:* string

The URL of the static website.

---

##### `resource`<sup>Required</sup> <a name="resource" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.property.resource"></a>

```typescript
public readonly resource: CfnBucket;
```

- *Type:* aws-cdk-lib.aws_s3.CfnBucket

---

##### `encryptionKey`<sup>Optional</sup> <a name="encryptionKey" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.property.encryptionKey"></a>

```typescript
public readonly encryptionKey: IKey;
```

- *Type:* aws-cdk-lib.aws_kms.IKey

Optional KMS encryption key associated with this bucket.

---

##### `isWebsite`<sup>Optional</sup> <a name="isWebsite" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.property.isWebsite"></a>

```typescript
public readonly isWebsite: boolean;
```

- *Type:* boolean

If this bucket has been configured for static website hosting.

---

##### `policy`<sup>Optional</sup> <a name="policy" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.property.policy"></a>

```typescript
public readonly policy: BucketPolicy;
```

- *Type:* aws-cdk-lib.aws_s3.BucketPolicy

The resource policy associated with this bucket.

If `autoCreatePolicy` is true, a `BucketPolicy` will be created upon the
first call to addToResourcePolicy(s).

---

##### `database`<sup>Required</sup> <a name="database" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.property.database"></a>

```typescript
public readonly database: Database;
```

- *Type:* cdk-extensions.glue.Database

---

##### `table`<sup>Required</sup> <a name="table" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.property.table"></a>

```typescript
public readonly table: CloudfrontLogsTable;
```

- *Type:* cdk-extensions.glue_tables.CloudfrontLogsTable

---

##### `createQueries`<sup>Optional</sup> <a name="createQueries" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.property.createQueries"></a>

```typescript
public readonly createQueries: boolean;
```

- *Type:* boolean

---

##### `friendlyQueryNames`<sup>Optional</sup> <a name="friendlyQueryNames" id="cdk-extensions.s3_buckets.CloudfrontLogsBucket.property.friendlyQueryNames"></a>

```typescript
public readonly friendlyQueryNames: boolean;
```

- *Type:* boolean

---


### CloudfrontLogsTable <a name="CloudfrontLogsTable" id="cdk-extensions.glue_tables.CloudfrontLogsTable"></a>

#### Initializers <a name="Initializers" id="cdk-extensions.glue_tables.CloudfrontLogsTable.Initializer"></a>

```typescript
import { glue_tables } from 'cdk-extensions'

new glue_tables.CloudfrontLogsTable(scope: Construct, id: string, props: CloudfrontLogsTableProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | A CDK Construct that will serve as this stack's parent in the construct tree. |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.Initializer.parameter.id">id</a></code> | <code>string</code> | A name to be associated with the stack and used in resource naming. |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.Initializer.parameter.props">props</a></code> | <code>cdk-extensions.glue_tables.CloudfrontLogsTableProps</code> | Arguments related to the configuration of the resource. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.glue_tables.CloudfrontLogsTable.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

A CDK Construct that will serve as this stack's parent in the construct tree.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.glue_tables.CloudfrontLogsTable.Initializer.parameter.id"></a>

- *Type:* string

A name to be associated with the stack and used in resource naming.

Must be unique
within the context of 'scope'.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk-extensions.glue_tables.CloudfrontLogsTable.Initializer.parameter.props"></a>

- *Type:* cdk-extensions.glue_tables.CloudfrontLogsTableProps

Arguments related to the configuration of the resource.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.addColumn">addColumn</a></code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.addParameter">addParameter</a></code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.addPartitionKey">addPartitionKey</a></code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.addSerdeParameter">addSerdeParameter</a></code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.addStorageParameter">addStorageParameter</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="cdk-extensions.glue_tables.CloudfrontLogsTable.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="cdk-extensions.glue_tables.CloudfrontLogsTable.applyRemovalPolicy"></a>

```typescript
public applyRemovalPolicy(policy: RemovalPolicy): void
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="cdk-extensions.glue_tables.CloudfrontLogsTable.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.RemovalPolicy

---

##### `addColumn` <a name="addColumn" id="cdk-extensions.glue_tables.CloudfrontLogsTable.addColumn"></a>

```typescript
public addColumn(column: Column): void
```

###### `column`<sup>Required</sup> <a name="column" id="cdk-extensions.glue_tables.CloudfrontLogsTable.addColumn.parameter.column"></a>

- *Type:* cdk-extensions.glue.Column

---

##### `addParameter` <a name="addParameter" id="cdk-extensions.glue_tables.CloudfrontLogsTable.addParameter"></a>

```typescript
public addParameter(key: string, value: string): void
```

###### `key`<sup>Required</sup> <a name="key" id="cdk-extensions.glue_tables.CloudfrontLogsTable.addParameter.parameter.key"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="cdk-extensions.glue_tables.CloudfrontLogsTable.addParameter.parameter.value"></a>

- *Type:* string

---

##### `addPartitionKey` <a name="addPartitionKey" id="cdk-extensions.glue_tables.CloudfrontLogsTable.addPartitionKey"></a>

```typescript
public addPartitionKey(column: Column): void
```

###### `column`<sup>Required</sup> <a name="column" id="cdk-extensions.glue_tables.CloudfrontLogsTable.addPartitionKey.parameter.column"></a>

- *Type:* cdk-extensions.glue.Column

---

##### `addSerdeParameter` <a name="addSerdeParameter" id="cdk-extensions.glue_tables.CloudfrontLogsTable.addSerdeParameter"></a>

```typescript
public addSerdeParameter(key: string, value: string): void
```

###### `key`<sup>Required</sup> <a name="key" id="cdk-extensions.glue_tables.CloudfrontLogsTable.addSerdeParameter.parameter.key"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="cdk-extensions.glue_tables.CloudfrontLogsTable.addSerdeParameter.parameter.value"></a>

- *Type:* string

---

##### `addStorageParameter` <a name="addStorageParameter" id="cdk-extensions.glue_tables.CloudfrontLogsTable.addStorageParameter"></a>

```typescript
public addStorageParameter(key: string, value: string): void
```

###### `key`<sup>Required</sup> <a name="key" id="cdk-extensions.glue_tables.CloudfrontLogsTable.addStorageParameter.parameter.key"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="cdk-extensions.glue_tables.CloudfrontLogsTable.addStorageParameter.parameter.value"></a>

- *Type:* string

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.isOwnedResource">isOwnedResource</a></code> | Returns true if the construct was created by CDK, and false otherwise. |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.isResource">isResource</a></code> | Check whether the given construct is a Resource. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-extensions.glue_tables.CloudfrontLogsTable.isConstruct"></a>

```typescript
import { glue_tables } from 'cdk-extensions'

glue_tables.CloudfrontLogsTable.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-extensions.glue_tables.CloudfrontLogsTable.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isOwnedResource` <a name="isOwnedResource" id="cdk-extensions.glue_tables.CloudfrontLogsTable.isOwnedResource"></a>

```typescript
import { glue_tables } from 'cdk-extensions'

glue_tables.CloudfrontLogsTable.isOwnedResource(construct: IConstruct)
```

Returns true if the construct was created by CDK, and false otherwise.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.glue_tables.CloudfrontLogsTable.isOwnedResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `isResource` <a name="isResource" id="cdk-extensions.glue_tables.CloudfrontLogsTable.isResource"></a>

```typescript
import { glue_tables } from 'cdk-extensions'

glue_tables.CloudfrontLogsTable.isResource(construct: IConstruct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.glue_tables.CloudfrontLogsTable.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.property.env">env</a></code> | <code>aws-cdk-lib.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.property.stack">stack</a></code> | <code>aws-cdk-lib.Stack</code> | The stack in which this resource is defined. |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.property.database">database</a></code> | <code>cdk-extensions.glue.Database</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.property.resource">resource</a></code> | <code>aws-cdk-lib.aws_glue.CfnTable</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.property.tableArn">tableArn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.property.tableName">tableName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.property.compressed">compressed</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.property.dataFormat">dataFormat</a></code> | <code>cdk-extensions.glue.DataFormat</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.property.description">description</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.property.location">location</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.property.owner">owner</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.property.retention">retention</a></code> | <code>aws-cdk-lib.Duration</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.property.serdeName">serdeName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.property.storedAsSubDirectories">storedAsSubDirectories</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.property.tableType">tableType</a></code> | <code>cdk-extensions.glue.TableType</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.property.targetTable">targetTable</a></code> | <code>cdk-extensions.glue.Table</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.property.viewExpandedText">viewExpandedText</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.property.viewOriginalText">viewOriginalText</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.property.createQueries">createQueries</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.property.friendlyQueryNames">friendlyQueryNames</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.property.distributionStatisticsNamedQuery">distributionStatisticsNamedQuery</a></code> | <code>cdk-extensions.athena.NamedQuery</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.property.requestErrorsNamedQuery">requestErrorsNamedQuery</a></code> | <code>cdk-extensions.athena.NamedQuery</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.property.topIpsNamedQuery">topIpsNamedQuery</a></code> | <code>cdk-extensions.athena.NamedQuery</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTable.property.topObjectsNamedQuery">topObjectsNamedQuery</a></code> | <code>cdk-extensions.athena.NamedQuery</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-extensions.glue_tables.CloudfrontLogsTable.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="cdk-extensions.glue_tables.CloudfrontLogsTable.property.env"></a>

```typescript
public readonly env: ResourceEnvironment;
```

- *Type:* aws-cdk-lib.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="cdk-extensions.glue_tables.CloudfrontLogsTable.property.stack"></a>

```typescript
public readonly stack: Stack;
```

- *Type:* aws-cdk-lib.Stack

The stack in which this resource is defined.

---

##### `database`<sup>Required</sup> <a name="database" id="cdk-extensions.glue_tables.CloudfrontLogsTable.property.database"></a>

```typescript
public readonly database: Database;
```

- *Type:* cdk-extensions.glue.Database

---

##### `resource`<sup>Required</sup> <a name="resource" id="cdk-extensions.glue_tables.CloudfrontLogsTable.property.resource"></a>

```typescript
public readonly resource: CfnTable;
```

- *Type:* aws-cdk-lib.aws_glue.CfnTable

---

##### `tableArn`<sup>Required</sup> <a name="tableArn" id="cdk-extensions.glue_tables.CloudfrontLogsTable.property.tableArn"></a>

```typescript
public readonly tableArn: string;
```

- *Type:* string

---

##### `tableName`<sup>Required</sup> <a name="tableName" id="cdk-extensions.glue_tables.CloudfrontLogsTable.property.tableName"></a>

```typescript
public readonly tableName: string;
```

- *Type:* string

---

##### `compressed`<sup>Optional</sup> <a name="compressed" id="cdk-extensions.glue_tables.CloudfrontLogsTable.property.compressed"></a>

```typescript
public readonly compressed: boolean;
```

- *Type:* boolean

---

##### `dataFormat`<sup>Optional</sup> <a name="dataFormat" id="cdk-extensions.glue_tables.CloudfrontLogsTable.property.dataFormat"></a>

```typescript
public readonly dataFormat: DataFormat;
```

- *Type:* cdk-extensions.glue.DataFormat

---

##### `description`<sup>Optional</sup> <a name="description" id="cdk-extensions.glue_tables.CloudfrontLogsTable.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

---

##### `location`<sup>Optional</sup> <a name="location" id="cdk-extensions.glue_tables.CloudfrontLogsTable.property.location"></a>

```typescript
public readonly location: string;
```

- *Type:* string

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.glue_tables.CloudfrontLogsTable.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `owner`<sup>Optional</sup> <a name="owner" id="cdk-extensions.glue_tables.CloudfrontLogsTable.property.owner"></a>

```typescript
public readonly owner: string;
```

- *Type:* string

---

##### `retention`<sup>Optional</sup> <a name="retention" id="cdk-extensions.glue_tables.CloudfrontLogsTable.property.retention"></a>

```typescript
public readonly retention: Duration;
```

- *Type:* aws-cdk-lib.Duration

---

##### `serdeName`<sup>Optional</sup> <a name="serdeName" id="cdk-extensions.glue_tables.CloudfrontLogsTable.property.serdeName"></a>

```typescript
public readonly serdeName: string;
```

- *Type:* string

---

##### `storedAsSubDirectories`<sup>Optional</sup> <a name="storedAsSubDirectories" id="cdk-extensions.glue_tables.CloudfrontLogsTable.property.storedAsSubDirectories"></a>

```typescript
public readonly storedAsSubDirectories: boolean;
```

- *Type:* boolean

---

##### `tableType`<sup>Optional</sup> <a name="tableType" id="cdk-extensions.glue_tables.CloudfrontLogsTable.property.tableType"></a>

```typescript
public readonly tableType: TableType;
```

- *Type:* cdk-extensions.glue.TableType

---

##### `targetTable`<sup>Optional</sup> <a name="targetTable" id="cdk-extensions.glue_tables.CloudfrontLogsTable.property.targetTable"></a>

```typescript
public readonly targetTable: Table;
```

- *Type:* cdk-extensions.glue.Table

---

##### `viewExpandedText`<sup>Optional</sup> <a name="viewExpandedText" id="cdk-extensions.glue_tables.CloudfrontLogsTable.property.viewExpandedText"></a>

```typescript
public readonly viewExpandedText: string;
```

- *Type:* string

---

##### `viewOriginalText`<sup>Optional</sup> <a name="viewOriginalText" id="cdk-extensions.glue_tables.CloudfrontLogsTable.property.viewOriginalText"></a>

```typescript
public readonly viewOriginalText: string;
```

- *Type:* string

---

##### `createQueries`<sup>Required</sup> <a name="createQueries" id="cdk-extensions.glue_tables.CloudfrontLogsTable.property.createQueries"></a>

```typescript
public readonly createQueries: boolean;
```

- *Type:* boolean

---

##### `friendlyQueryNames`<sup>Required</sup> <a name="friendlyQueryNames" id="cdk-extensions.glue_tables.CloudfrontLogsTable.property.friendlyQueryNames"></a>

```typescript
public readonly friendlyQueryNames: boolean;
```

- *Type:* boolean

---

##### `distributionStatisticsNamedQuery`<sup>Optional</sup> <a name="distributionStatisticsNamedQuery" id="cdk-extensions.glue_tables.CloudfrontLogsTable.property.distributionStatisticsNamedQuery"></a>

```typescript
public readonly distributionStatisticsNamedQuery: NamedQuery;
```

- *Type:* cdk-extensions.athena.NamedQuery

---

##### `requestErrorsNamedQuery`<sup>Optional</sup> <a name="requestErrorsNamedQuery" id="cdk-extensions.glue_tables.CloudfrontLogsTable.property.requestErrorsNamedQuery"></a>

```typescript
public readonly requestErrorsNamedQuery: NamedQuery;
```

- *Type:* cdk-extensions.athena.NamedQuery

---

##### `topIpsNamedQuery`<sup>Optional</sup> <a name="topIpsNamedQuery" id="cdk-extensions.glue_tables.CloudfrontLogsTable.property.topIpsNamedQuery"></a>

```typescript
public readonly topIpsNamedQuery: NamedQuery;
```

- *Type:* cdk-extensions.athena.NamedQuery

---

##### `topObjectsNamedQuery`<sup>Optional</sup> <a name="topObjectsNamedQuery" id="cdk-extensions.glue_tables.CloudfrontLogsTable.property.topObjectsNamedQuery"></a>

```typescript
public readonly topObjectsNamedQuery: NamedQuery;
```

- *Type:* cdk-extensions.athena.NamedQuery

---


### CloudtrailBucket <a name="CloudtrailBucket" id="cdk-extensions.s3_buckets.CloudtrailBucket"></a>

#### Initializers <a name="Initializers" id="cdk-extensions.s3_buckets.CloudtrailBucket.Initializer"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

new s3_buckets.CloudtrailBucket(scope: Construct, id: string, props?: CloudtrailBucketProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | A CDK Construct that will serve as this stack's parent in the construct tree. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.Initializer.parameter.id">id</a></code> | <code>string</code> | A name to be associated with the stack and used in resource naming. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.Initializer.parameter.props">props</a></code> | <code>cdk-extensions.s3_buckets.CloudtrailBucketProps</code> | Arguments related to the configuration of the resource. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.s3_buckets.CloudtrailBucket.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

A CDK Construct that will serve as this stack's parent in the construct tree.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.s3_buckets.CloudtrailBucket.Initializer.parameter.id"></a>

- *Type:* string

A name to be associated with the stack and used in resource naming.

Must be unique
within the context of 'scope'.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk-extensions.s3_buckets.CloudtrailBucket.Initializer.parameter.props"></a>

- *Type:* cdk-extensions.s3_buckets.CloudtrailBucketProps

Arguments related to the configuration of the resource.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.addEventNotification">addEventNotification</a></code> | Adds a bucket notification event destination. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.addObjectCreatedNotification">addObjectCreatedNotification</a></code> | Subscribes a destination to receive notifications when an object is created in the bucket. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.addObjectRemovedNotification">addObjectRemovedNotification</a></code> | Subscribes a destination to receive notifications when an object is removed from the bucket. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.addToResourcePolicy">addToResourcePolicy</a></code> | Adds a statement to the resource policy for a principal (i.e. account/role/service) to perform actions on this bucket and/or its contents. Use `bucketArn` and `arnForObjects(keys)` to obtain ARNs for this bucket or objects. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.arnForObjects">arnForObjects</a></code> | Returns an ARN that represents all objects within the bucket that match the key pattern specified. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.enableEventBridgeNotification">enableEventBridgeNotification</a></code> | Enables event bridge notification, causing all events below to be sent to EventBridge:. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.grantDelete">grantDelete</a></code> | Grants s3:DeleteObject* permission to an IAM principal for objects in this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.grantPublicAccess">grantPublicAccess</a></code> | Allows unrestricted access to objects from this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.grantPut">grantPut</a></code> | Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.grantPutAcl">grantPutAcl</a></code> | Grant the given IAM identity permissions to modify the ACLs of objects in the given Bucket. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.grantRead">grantRead</a></code> | Grant read permissions for this bucket and it's contents to an IAM principal (Role/Group/User). |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.grantReadWrite">grantReadWrite</a></code> | Grants read/write permissions for this bucket and it's contents to an IAM principal (Role/Group/User). |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.grantWrite">grantWrite</a></code> | Grant write permissions to this bucket to an IAM principal. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.onCloudTrailEvent">onCloudTrailEvent</a></code> | Defines a CloudWatch event that triggers when something happens to this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.onCloudTrailPutObject">onCloudTrailPutObject</a></code> | Defines an AWS CloudWatch event that triggers when an object is uploaded to the specified paths (keys) in this bucket using the PutObject API call. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.onCloudTrailWriteObject">onCloudTrailWriteObject</a></code> | Defines an AWS CloudWatch event that triggers when an object at the specified paths (keys) in this bucket are written to. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.s3UrlForObject">s3UrlForObject</a></code> | The S3 URL of an S3 object. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.transferAccelerationUrlForObject">transferAccelerationUrlForObject</a></code> | The https Transfer Acceleration URL of an S3 object. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.urlForObject">urlForObject</a></code> | The https URL of an S3 object. For example:. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.virtualHostedUrlForObject">virtualHostedUrlForObject</a></code> | The virtual hosted-style URL of an S3 object. Specify `regional: false` at the options for non-regional URL. For example:. |

---

##### `toString` <a name="toString" id="cdk-extensions.s3_buckets.CloudtrailBucket.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="cdk-extensions.s3_buckets.CloudtrailBucket.applyRemovalPolicy"></a>

```typescript
public applyRemovalPolicy(policy: RemovalPolicy): void
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="cdk-extensions.s3_buckets.CloudtrailBucket.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.RemovalPolicy

---

##### `addEventNotification` <a name="addEventNotification" id="cdk-extensions.s3_buckets.CloudtrailBucket.addEventNotification"></a>

```typescript
public addEventNotification(_event: EventType, _dest: IBucketNotificationDestination, _filters: NotificationKeyFilter): void
```

Adds a bucket notification event destination.

###### `_event`<sup>Required</sup> <a name="_event" id="cdk-extensions.s3_buckets.CloudtrailBucket.addEventNotification.parameter._event"></a>

- *Type:* aws-cdk-lib.aws_s3.EventType

---

###### `_dest`<sup>Required</sup> <a name="_dest" id="cdk-extensions.s3_buckets.CloudtrailBucket.addEventNotification.parameter._dest"></a>

- *Type:* aws-cdk-lib.aws_s3.IBucketNotificationDestination

---

###### `_filters`<sup>Required</sup> <a name="_filters" id="cdk-extensions.s3_buckets.CloudtrailBucket.addEventNotification.parameter._filters"></a>

- *Type:* aws-cdk-lib.aws_s3.NotificationKeyFilter

---

##### `addObjectCreatedNotification` <a name="addObjectCreatedNotification" id="cdk-extensions.s3_buckets.CloudtrailBucket.addObjectCreatedNotification"></a>

```typescript
public addObjectCreatedNotification(_dest: IBucketNotificationDestination, _filters: NotificationKeyFilter): void
```

Subscribes a destination to receive notifications when an object is created in the bucket.

This is identical to calling
`onEvent(s3.EventType.OBJECT_CREATED)`.

###### `_dest`<sup>Required</sup> <a name="_dest" id="cdk-extensions.s3_buckets.CloudtrailBucket.addObjectCreatedNotification.parameter._dest"></a>

- *Type:* aws-cdk-lib.aws_s3.IBucketNotificationDestination

---

###### `_filters`<sup>Required</sup> <a name="_filters" id="cdk-extensions.s3_buckets.CloudtrailBucket.addObjectCreatedNotification.parameter._filters"></a>

- *Type:* aws-cdk-lib.aws_s3.NotificationKeyFilter

---

##### `addObjectRemovedNotification` <a name="addObjectRemovedNotification" id="cdk-extensions.s3_buckets.CloudtrailBucket.addObjectRemovedNotification"></a>

```typescript
public addObjectRemovedNotification(_dest: IBucketNotificationDestination, _filters: NotificationKeyFilter): void
```

Subscribes a destination to receive notifications when an object is removed from the bucket.

This is identical to calling
`onEvent(EventType.OBJECT_REMOVED)`.

###### `_dest`<sup>Required</sup> <a name="_dest" id="cdk-extensions.s3_buckets.CloudtrailBucket.addObjectRemovedNotification.parameter._dest"></a>

- *Type:* aws-cdk-lib.aws_s3.IBucketNotificationDestination

---

###### `_filters`<sup>Required</sup> <a name="_filters" id="cdk-extensions.s3_buckets.CloudtrailBucket.addObjectRemovedNotification.parameter._filters"></a>

- *Type:* aws-cdk-lib.aws_s3.NotificationKeyFilter

---

##### `addToResourcePolicy` <a name="addToResourcePolicy" id="cdk-extensions.s3_buckets.CloudtrailBucket.addToResourcePolicy"></a>

```typescript
public addToResourcePolicy(permission: PolicyStatement): AddToResourcePolicyResult
```

Adds a statement to the resource policy for a principal (i.e. account/role/service) to perform actions on this bucket and/or its contents. Use `bucketArn` and `arnForObjects(keys)` to obtain ARNs for this bucket or objects.

Note that the policy statement may or may not be added to the policy.
For example, when an `IBucket` is created from an existing bucket,
it's not possible to tell whether the bucket already has a policy
attached, let alone to re-use that policy to add more statements to it.
So it's safest to do nothing in these cases.

###### `permission`<sup>Required</sup> <a name="permission" id="cdk-extensions.s3_buckets.CloudtrailBucket.addToResourcePolicy.parameter.permission"></a>

- *Type:* aws-cdk-lib.aws_iam.PolicyStatement

---

##### `arnForObjects` <a name="arnForObjects" id="cdk-extensions.s3_buckets.CloudtrailBucket.arnForObjects"></a>

```typescript
public arnForObjects(_keyPattern: string): string
```

Returns an ARN that represents all objects within the bucket that match the key pattern specified.

To represent all keys, specify ``"*"``.

###### `_keyPattern`<sup>Required</sup> <a name="_keyPattern" id="cdk-extensions.s3_buckets.CloudtrailBucket.arnForObjects.parameter._keyPattern"></a>

- *Type:* string

---

##### `enableEventBridgeNotification` <a name="enableEventBridgeNotification" id="cdk-extensions.s3_buckets.CloudtrailBucket.enableEventBridgeNotification"></a>

```typescript
public enableEventBridgeNotification(): void
```

Enables event bridge notification, causing all events below to be sent to EventBridge:.

Object Deleted (DeleteObject)
- Object Deleted (Lifecycle expiration)
- Object Restore Initiated
- Object Restore Completed
- Object Restore Expired
- Object Storage Class Changed
- Object Access Tier Changed
- Object ACL Updated
- Object Tags Added
- Object Tags Deleted

##### `grantDelete` <a name="grantDelete" id="cdk-extensions.s3_buckets.CloudtrailBucket.grantDelete"></a>

```typescript
public grantDelete(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grants s3:DeleteObject* permission to an IAM principal for objects in this bucket.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.CloudtrailBucket.grantDelete.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.CloudtrailBucket.grantDelete.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `grantPublicAccess` <a name="grantPublicAccess" id="cdk-extensions.s3_buckets.CloudtrailBucket.grantPublicAccess"></a>

```typescript
public grantPublicAccess(_allowedActions: string, _keyPrefix?: string): Grant
```

Allows unrestricted access to objects from this bucket.

IMPORTANT: This permission allows anyone to perform actions on S3 objects
in this bucket, which is useful for when you configure your bucket as a
website and want everyone to be able to read objects in the bucket without
needing to authenticate.

Without arguments, this method will grant read ("s3:GetObject") access to
all objects ("*") in the bucket.

The method returns the `iam.Grant` object, which can then be modified
as needed. For example, you can add a condition that will restrict access only
to an IPv4 range like this:

     const grant = bucket.grantPublicAccess();
     grant.resourceStatement!.addCondition(‘IpAddress’, { “aws:SourceIp”: “54.240.143.0/24” });

###### `_allowedActions`<sup>Required</sup> <a name="_allowedActions" id="cdk-extensions.s3_buckets.CloudtrailBucket.grantPublicAccess.parameter._allowedActions"></a>

- *Type:* string

---

###### `_keyPrefix`<sup>Optional</sup> <a name="_keyPrefix" id="cdk-extensions.s3_buckets.CloudtrailBucket.grantPublicAccess.parameter._keyPrefix"></a>

- *Type:* string

---

##### `grantPut` <a name="grantPut" id="cdk-extensions.s3_buckets.CloudtrailBucket.grantPut"></a>

```typescript
public grantPut(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal.

If encryption is used, permission to use the key to encrypt the contents
of written files will also be granted to the same principal.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.CloudtrailBucket.grantPut.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.CloudtrailBucket.grantPut.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `grantPutAcl` <a name="grantPutAcl" id="cdk-extensions.s3_buckets.CloudtrailBucket.grantPutAcl"></a>

```typescript
public grantPutAcl(_identity: IGrantable, _objectsKeyPattern?: string): Grant
```

Grant the given IAM identity permissions to modify the ACLs of objects in the given Bucket.

If your application has the '@aws-cdk/aws-s3:grantWriteWithoutAcl' feature flag set,
calling {@link grantWrite} or {@link grantReadWrite} no longer grants permissions to modify the ACLs of the objects;
in this case, if you need to modify object ACLs, call this method explicitly.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.CloudtrailBucket.grantPutAcl.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.CloudtrailBucket.grantPutAcl.parameter._objectsKeyPattern"></a>

- *Type:* string

---

##### `grantRead` <a name="grantRead" id="cdk-extensions.s3_buckets.CloudtrailBucket.grantRead"></a>

```typescript
public grantRead(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grant read permissions for this bucket and it's contents to an IAM principal (Role/Group/User).

If encryption is used, permission to use the key to decrypt the contents
of the bucket will also be granted to the same principal.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.CloudtrailBucket.grantRead.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.CloudtrailBucket.grantRead.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `grantReadWrite` <a name="grantReadWrite" id="cdk-extensions.s3_buckets.CloudtrailBucket.grantReadWrite"></a>

```typescript
public grantReadWrite(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grants read/write permissions for this bucket and it's contents to an IAM principal (Role/Group/User).

If an encryption key is used, permission to use the key for
encrypt/decrypt will also be granted.

Before CDK version 1.85.0, this method granted the `s3:PutObject*` permission that included `s3:PutObjectAcl`,
which could be used to grant read/write object access to IAM principals in other accounts.
If you want to get rid of that behavior, update your CDK version to 1.85.0 or later,
and make sure the `@aws-cdk/aws-s3:grantWriteWithoutAcl` feature flag is set to `true`
in the `context` key of your cdk.json file.
If you've already updated, but still need the principal to have permissions to modify the ACLs,
use the {@link grantPutAcl} method.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.CloudtrailBucket.grantReadWrite.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.CloudtrailBucket.grantReadWrite.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `grantWrite` <a name="grantWrite" id="cdk-extensions.s3_buckets.CloudtrailBucket.grantWrite"></a>

```typescript
public grantWrite(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grant write permissions to this bucket to an IAM principal.

If encryption is used, permission to use the key to encrypt the contents
of written files will also be granted to the same principal.

Before CDK version 1.85.0, this method granted the `s3:PutObject*` permission that included `s3:PutObjectAcl`,
which could be used to grant read/write object access to IAM principals in other accounts.
If you want to get rid of that behavior, update your CDK version to 1.85.0 or later,
and make sure the `@aws-cdk/aws-s3:grantWriteWithoutAcl` feature flag is set to `true`
in the `context` key of your cdk.json file.
If you've already updated, but still need the principal to have permissions to modify the ACLs,
use the {@link grantPutAcl} method.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.CloudtrailBucket.grantWrite.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.CloudtrailBucket.grantWrite.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `onCloudTrailEvent` <a name="onCloudTrailEvent" id="cdk-extensions.s3_buckets.CloudtrailBucket.onCloudTrailEvent"></a>

```typescript
public onCloudTrailEvent(_id: string, _options?: OnCloudTrailBucketEventOptions): Rule
```

Defines a CloudWatch event that triggers when something happens to this bucket.

Requires that there exists at least one CloudTrail Trail in your account
that captures the event. This method will not create the Trail.

###### `_id`<sup>Required</sup> <a name="_id" id="cdk-extensions.s3_buckets.CloudtrailBucket.onCloudTrailEvent.parameter._id"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.CloudtrailBucket.onCloudTrailEvent.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.OnCloudTrailBucketEventOptions

---

##### `onCloudTrailPutObject` <a name="onCloudTrailPutObject" id="cdk-extensions.s3_buckets.CloudtrailBucket.onCloudTrailPutObject"></a>

```typescript
public onCloudTrailPutObject(_id: string, _options?: OnCloudTrailBucketEventOptions): Rule
```

Defines an AWS CloudWatch event that triggers when an object is uploaded to the specified paths (keys) in this bucket using the PutObject API call.

Note that some tools like `aws s3 cp` will automatically use either
PutObject or the multipart upload API depending on the file size,
so using `onCloudTrailWriteObject` may be preferable.

Requires that there exists at least one CloudTrail Trail in your account
that captures the event. This method will not create the Trail.

###### `_id`<sup>Required</sup> <a name="_id" id="cdk-extensions.s3_buckets.CloudtrailBucket.onCloudTrailPutObject.parameter._id"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.CloudtrailBucket.onCloudTrailPutObject.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.OnCloudTrailBucketEventOptions

---

##### `onCloudTrailWriteObject` <a name="onCloudTrailWriteObject" id="cdk-extensions.s3_buckets.CloudtrailBucket.onCloudTrailWriteObject"></a>

```typescript
public onCloudTrailWriteObject(_id: string, _options?: OnCloudTrailBucketEventOptions): Rule
```

Defines an AWS CloudWatch event that triggers when an object at the specified paths (keys) in this bucket are written to.

This includes
the events PutObject, CopyObject, and CompleteMultipartUpload.

Note that some tools like `aws s3 cp` will automatically use either
PutObject or the multipart upload API depending on the file size,
so using this method may be preferable to `onCloudTrailPutObject`.

Requires that there exists at least one CloudTrail Trail in your account
that captures the event. This method will not create the Trail.

###### `_id`<sup>Required</sup> <a name="_id" id="cdk-extensions.s3_buckets.CloudtrailBucket.onCloudTrailWriteObject.parameter._id"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.CloudtrailBucket.onCloudTrailWriteObject.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.OnCloudTrailBucketEventOptions

---

##### `s3UrlForObject` <a name="s3UrlForObject" id="cdk-extensions.s3_buckets.CloudtrailBucket.s3UrlForObject"></a>

```typescript
public s3UrlForObject(_key?: string): string
```

The S3 URL of an S3 object.

For example:
- `s3://onlybucket`
- `s3://bucket/key`

###### `_key`<sup>Optional</sup> <a name="_key" id="cdk-extensions.s3_buckets.CloudtrailBucket.s3UrlForObject.parameter._key"></a>

- *Type:* string

---

##### `transferAccelerationUrlForObject` <a name="transferAccelerationUrlForObject" id="cdk-extensions.s3_buckets.CloudtrailBucket.transferAccelerationUrlForObject"></a>

```typescript
public transferAccelerationUrlForObject(_key?: string, _options?: TransferAccelerationUrlOptions): string
```

The https Transfer Acceleration URL of an S3 object.

Specify `dualStack: true` at the options
for dual-stack endpoint (connect to the bucket over IPv6). For example:

- `https://bucket.s3-accelerate.amazonaws.com`
- `https://bucket.s3-accelerate.amazonaws.com/key`

###### `_key`<sup>Optional</sup> <a name="_key" id="cdk-extensions.s3_buckets.CloudtrailBucket.transferAccelerationUrlForObject.parameter._key"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.CloudtrailBucket.transferAccelerationUrlForObject.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.TransferAccelerationUrlOptions

---

##### `urlForObject` <a name="urlForObject" id="cdk-extensions.s3_buckets.CloudtrailBucket.urlForObject"></a>

```typescript
public urlForObject(_key?: string): string
```

The https URL of an S3 object. For example:.

`https://s3.us-west-1.amazonaws.com/onlybucket`
- `https://s3.us-west-1.amazonaws.com/bucket/key`
- `https://s3.cn-north-1.amazonaws.com.cn/china-bucket/mykey`

###### `_key`<sup>Optional</sup> <a name="_key" id="cdk-extensions.s3_buckets.CloudtrailBucket.urlForObject.parameter._key"></a>

- *Type:* string

---

##### `virtualHostedUrlForObject` <a name="virtualHostedUrlForObject" id="cdk-extensions.s3_buckets.CloudtrailBucket.virtualHostedUrlForObject"></a>

```typescript
public virtualHostedUrlForObject(_key?: string, _options?: VirtualHostedStyleUrlOptions): string
```

The virtual hosted-style URL of an S3 object. Specify `regional: false` at the options for non-regional URL. For example:.

`https://only-bucket.s3.us-west-1.amazonaws.com`
- `https://bucket.s3.us-west-1.amazonaws.com/key`
- `https://bucket.s3.amazonaws.com/key`
- `https://china-bucket.s3.cn-north-1.amazonaws.com.cn/mykey`

###### `_key`<sup>Optional</sup> <a name="_key" id="cdk-extensions.s3_buckets.CloudtrailBucket.virtualHostedUrlForObject.parameter._key"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.CloudtrailBucket.virtualHostedUrlForObject.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.VirtualHostedStyleUrlOptions

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.isOwnedResource">isOwnedResource</a></code> | Returns true if the construct was created by CDK, and false otherwise. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.isResource">isResource</a></code> | Check whether the given construct is a Resource. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-extensions.s3_buckets.CloudtrailBucket.isConstruct"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

s3_buckets.CloudtrailBucket.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-extensions.s3_buckets.CloudtrailBucket.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isOwnedResource` <a name="isOwnedResource" id="cdk-extensions.s3_buckets.CloudtrailBucket.isOwnedResource"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

s3_buckets.CloudtrailBucket.isOwnedResource(construct: IConstruct)
```

Returns true if the construct was created by CDK, and false otherwise.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.s3_buckets.CloudtrailBucket.isOwnedResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `isResource` <a name="isResource" id="cdk-extensions.s3_buckets.CloudtrailBucket.isResource"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

s3_buckets.CloudtrailBucket.isResource(construct: IConstruct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.s3_buckets.CloudtrailBucket.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.property.env">env</a></code> | <code>aws-cdk-lib.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.property.stack">stack</a></code> | <code>aws-cdk-lib.Stack</code> | The stack in which this resource is defined. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.property.bucketArn">bucketArn</a></code> | <code>string</code> | The ARN of the bucket. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.property.bucketDomainName">bucketDomainName</a></code> | <code>string</code> | The IPv4 DNS name of the specified bucket. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.property.bucketDualStackDomainName">bucketDualStackDomainName</a></code> | <code>string</code> | The IPv6 DNS name of the specified bucket. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.property.bucketName">bucketName</a></code> | <code>string</code> | The name of the bucket. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.property.bucketRegionalDomainName">bucketRegionalDomainName</a></code> | <code>string</code> | The regional domain name of the specified bucket. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.property.bucketWebsiteDomainName">bucketWebsiteDomainName</a></code> | <code>string</code> | The Domain name of the static website. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.property.bucketWebsiteUrl">bucketWebsiteUrl</a></code> | <code>string</code> | The URL of the static website. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.property.resource">resource</a></code> | <code>aws-cdk-lib.aws_s3.CfnBucket</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.property.encryptionKey">encryptionKey</a></code> | <code>aws-cdk-lib.aws_kms.IKey</code> | Optional KMS encryption key associated with this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.property.isWebsite">isWebsite</a></code> | <code>boolean</code> | If this bucket has been configured for static website hosting. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.property.policy">policy</a></code> | <code>aws-cdk-lib.aws_s3.BucketPolicy</code> | The resource policy associated with this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.property.database">database</a></code> | <code>cdk-extensions.glue.Database</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.property.table">table</a></code> | <code>cdk-extensions.glue_tables.CloudtrailTable</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.property.createQueries">createQueries</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucket.property.friendlyQueryNames">friendlyQueryNames</a></code> | <code>boolean</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-extensions.s3_buckets.CloudtrailBucket.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="cdk-extensions.s3_buckets.CloudtrailBucket.property.env"></a>

```typescript
public readonly env: ResourceEnvironment;
```

- *Type:* aws-cdk-lib.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="cdk-extensions.s3_buckets.CloudtrailBucket.property.stack"></a>

```typescript
public readonly stack: Stack;
```

- *Type:* aws-cdk-lib.Stack

The stack in which this resource is defined.

---

##### `bucketArn`<sup>Required</sup> <a name="bucketArn" id="cdk-extensions.s3_buckets.CloudtrailBucket.property.bucketArn"></a>

```typescript
public readonly bucketArn: string;
```

- *Type:* string

The ARN of the bucket.

---

##### `bucketDomainName`<sup>Required</sup> <a name="bucketDomainName" id="cdk-extensions.s3_buckets.CloudtrailBucket.property.bucketDomainName"></a>

```typescript
public readonly bucketDomainName: string;
```

- *Type:* string

The IPv4 DNS name of the specified bucket.

---

##### `bucketDualStackDomainName`<sup>Required</sup> <a name="bucketDualStackDomainName" id="cdk-extensions.s3_buckets.CloudtrailBucket.property.bucketDualStackDomainName"></a>

```typescript
public readonly bucketDualStackDomainName: string;
```

- *Type:* string

The IPv6 DNS name of the specified bucket.

---

##### `bucketName`<sup>Required</sup> <a name="bucketName" id="cdk-extensions.s3_buckets.CloudtrailBucket.property.bucketName"></a>

```typescript
public readonly bucketName: string;
```

- *Type:* string

The name of the bucket.

---

##### `bucketRegionalDomainName`<sup>Required</sup> <a name="bucketRegionalDomainName" id="cdk-extensions.s3_buckets.CloudtrailBucket.property.bucketRegionalDomainName"></a>

```typescript
public readonly bucketRegionalDomainName: string;
```

- *Type:* string

The regional domain name of the specified bucket.

---

##### `bucketWebsiteDomainName`<sup>Required</sup> <a name="bucketWebsiteDomainName" id="cdk-extensions.s3_buckets.CloudtrailBucket.property.bucketWebsiteDomainName"></a>

```typescript
public readonly bucketWebsiteDomainName: string;
```

- *Type:* string

The Domain name of the static website.

---

##### `bucketWebsiteUrl`<sup>Required</sup> <a name="bucketWebsiteUrl" id="cdk-extensions.s3_buckets.CloudtrailBucket.property.bucketWebsiteUrl"></a>

```typescript
public readonly bucketWebsiteUrl: string;
```

- *Type:* string

The URL of the static website.

---

##### `resource`<sup>Required</sup> <a name="resource" id="cdk-extensions.s3_buckets.CloudtrailBucket.property.resource"></a>

```typescript
public readonly resource: CfnBucket;
```

- *Type:* aws-cdk-lib.aws_s3.CfnBucket

---

##### `encryptionKey`<sup>Optional</sup> <a name="encryptionKey" id="cdk-extensions.s3_buckets.CloudtrailBucket.property.encryptionKey"></a>

```typescript
public readonly encryptionKey: IKey;
```

- *Type:* aws-cdk-lib.aws_kms.IKey

Optional KMS encryption key associated with this bucket.

---

##### `isWebsite`<sup>Optional</sup> <a name="isWebsite" id="cdk-extensions.s3_buckets.CloudtrailBucket.property.isWebsite"></a>

```typescript
public readonly isWebsite: boolean;
```

- *Type:* boolean

If this bucket has been configured for static website hosting.

---

##### `policy`<sup>Optional</sup> <a name="policy" id="cdk-extensions.s3_buckets.CloudtrailBucket.property.policy"></a>

```typescript
public readonly policy: BucketPolicy;
```

- *Type:* aws-cdk-lib.aws_s3.BucketPolicy

The resource policy associated with this bucket.

If `autoCreatePolicy` is true, a `BucketPolicy` will be created upon the
first call to addToResourcePolicy(s).

---

##### `database`<sup>Required</sup> <a name="database" id="cdk-extensions.s3_buckets.CloudtrailBucket.property.database"></a>

```typescript
public readonly database: Database;
```

- *Type:* cdk-extensions.glue.Database

---

##### `table`<sup>Required</sup> <a name="table" id="cdk-extensions.s3_buckets.CloudtrailBucket.property.table"></a>

```typescript
public readonly table: CloudtrailTable;
```

- *Type:* cdk-extensions.glue_tables.CloudtrailTable

---

##### `createQueries`<sup>Optional</sup> <a name="createQueries" id="cdk-extensions.s3_buckets.CloudtrailBucket.property.createQueries"></a>

```typescript
public readonly createQueries: boolean;
```

- *Type:* boolean

---

##### `friendlyQueryNames`<sup>Optional</sup> <a name="friendlyQueryNames" id="cdk-extensions.s3_buckets.CloudtrailBucket.property.friendlyQueryNames"></a>

```typescript
public readonly friendlyQueryNames: boolean;
```

- *Type:* boolean

---


### CloudtrailTable <a name="CloudtrailTable" id="cdk-extensions.glue_tables.CloudtrailTable"></a>

#### Initializers <a name="Initializers" id="cdk-extensions.glue_tables.CloudtrailTable.Initializer"></a>

```typescript
import { glue_tables } from 'cdk-extensions'

new glue_tables.CloudtrailTable(scope: Construct, id: string, props: CloudtrailTableProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTable.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | A CDK Construct that will serve as this stack's parent in the construct tree. |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTable.Initializer.parameter.id">id</a></code> | <code>string</code> | A name to be associated with the stack and used in resource naming. |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTable.Initializer.parameter.props">props</a></code> | <code>cdk-extensions.glue_tables.CloudtrailTableProps</code> | Arguments related to the configuration of the resource. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.glue_tables.CloudtrailTable.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

A CDK Construct that will serve as this stack's parent in the construct tree.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.glue_tables.CloudtrailTable.Initializer.parameter.id"></a>

- *Type:* string

A name to be associated with the stack and used in resource naming.

Must be unique
within the context of 'scope'.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk-extensions.glue_tables.CloudtrailTable.Initializer.parameter.props"></a>

- *Type:* cdk-extensions.glue_tables.CloudtrailTableProps

Arguments related to the configuration of the resource.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTable.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTable.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTable.addColumn">addColumn</a></code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTable.addParameter">addParameter</a></code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTable.addPartitionKey">addPartitionKey</a></code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTable.addSerdeParameter">addSerdeParameter</a></code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTable.addStorageParameter">addStorageParameter</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="cdk-extensions.glue_tables.CloudtrailTable.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="cdk-extensions.glue_tables.CloudtrailTable.applyRemovalPolicy"></a>

```typescript
public applyRemovalPolicy(policy: RemovalPolicy): void
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="cdk-extensions.glue_tables.CloudtrailTable.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.RemovalPolicy

---

##### `addColumn` <a name="addColumn" id="cdk-extensions.glue_tables.CloudtrailTable.addColumn"></a>

```typescript
public addColumn(column: Column): void
```

###### `column`<sup>Required</sup> <a name="column" id="cdk-extensions.glue_tables.CloudtrailTable.addColumn.parameter.column"></a>

- *Type:* cdk-extensions.glue.Column

---

##### `addParameter` <a name="addParameter" id="cdk-extensions.glue_tables.CloudtrailTable.addParameter"></a>

```typescript
public addParameter(key: string, value: string): void
```

###### `key`<sup>Required</sup> <a name="key" id="cdk-extensions.glue_tables.CloudtrailTable.addParameter.parameter.key"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="cdk-extensions.glue_tables.CloudtrailTable.addParameter.parameter.value"></a>

- *Type:* string

---

##### `addPartitionKey` <a name="addPartitionKey" id="cdk-extensions.glue_tables.CloudtrailTable.addPartitionKey"></a>

```typescript
public addPartitionKey(column: Column): void
```

###### `column`<sup>Required</sup> <a name="column" id="cdk-extensions.glue_tables.CloudtrailTable.addPartitionKey.parameter.column"></a>

- *Type:* cdk-extensions.glue.Column

---

##### `addSerdeParameter` <a name="addSerdeParameter" id="cdk-extensions.glue_tables.CloudtrailTable.addSerdeParameter"></a>

```typescript
public addSerdeParameter(key: string, value: string): void
```

###### `key`<sup>Required</sup> <a name="key" id="cdk-extensions.glue_tables.CloudtrailTable.addSerdeParameter.parameter.key"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="cdk-extensions.glue_tables.CloudtrailTable.addSerdeParameter.parameter.value"></a>

- *Type:* string

---

##### `addStorageParameter` <a name="addStorageParameter" id="cdk-extensions.glue_tables.CloudtrailTable.addStorageParameter"></a>

```typescript
public addStorageParameter(key: string, value: string): void
```

###### `key`<sup>Required</sup> <a name="key" id="cdk-extensions.glue_tables.CloudtrailTable.addStorageParameter.parameter.key"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="cdk-extensions.glue_tables.CloudtrailTable.addStorageParameter.parameter.value"></a>

- *Type:* string

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTable.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTable.isOwnedResource">isOwnedResource</a></code> | Returns true if the construct was created by CDK, and false otherwise. |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTable.isResource">isResource</a></code> | Check whether the given construct is a Resource. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-extensions.glue_tables.CloudtrailTable.isConstruct"></a>

```typescript
import { glue_tables } from 'cdk-extensions'

glue_tables.CloudtrailTable.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-extensions.glue_tables.CloudtrailTable.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isOwnedResource` <a name="isOwnedResource" id="cdk-extensions.glue_tables.CloudtrailTable.isOwnedResource"></a>

```typescript
import { glue_tables } from 'cdk-extensions'

glue_tables.CloudtrailTable.isOwnedResource(construct: IConstruct)
```

Returns true if the construct was created by CDK, and false otherwise.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.glue_tables.CloudtrailTable.isOwnedResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `isResource` <a name="isResource" id="cdk-extensions.glue_tables.CloudtrailTable.isResource"></a>

```typescript
import { glue_tables } from 'cdk-extensions'

glue_tables.CloudtrailTable.isResource(construct: IConstruct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.glue_tables.CloudtrailTable.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTable.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTable.property.env">env</a></code> | <code>aws-cdk-lib.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTable.property.stack">stack</a></code> | <code>aws-cdk-lib.Stack</code> | The stack in which this resource is defined. |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTable.property.database">database</a></code> | <code>cdk-extensions.glue.Database</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTable.property.resource">resource</a></code> | <code>aws-cdk-lib.aws_glue.CfnTable</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTable.property.tableArn">tableArn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTable.property.tableName">tableName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTable.property.compressed">compressed</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTable.property.dataFormat">dataFormat</a></code> | <code>cdk-extensions.glue.DataFormat</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTable.property.description">description</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTable.property.location">location</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTable.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTable.property.owner">owner</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTable.property.retention">retention</a></code> | <code>aws-cdk-lib.Duration</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTable.property.serdeName">serdeName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTable.property.storedAsSubDirectories">storedAsSubDirectories</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTable.property.tableType">tableType</a></code> | <code>cdk-extensions.glue.TableType</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTable.property.targetTable">targetTable</a></code> | <code>cdk-extensions.glue.Table</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTable.property.viewExpandedText">viewExpandedText</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTable.property.viewOriginalText">viewOriginalText</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTable.property.createQueries">createQueries</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTable.property.friendlyQueryNames">friendlyQueryNames</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTable.property.unauthorizedNamedQuery">unauthorizedNamedQuery</a></code> | <code>cdk-extensions.athena.NamedQuery</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTable.property.userLoginsNamedQuery">userLoginsNamedQuery</a></code> | <code>cdk-extensions.athena.NamedQuery</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-extensions.glue_tables.CloudtrailTable.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="cdk-extensions.glue_tables.CloudtrailTable.property.env"></a>

```typescript
public readonly env: ResourceEnvironment;
```

- *Type:* aws-cdk-lib.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="cdk-extensions.glue_tables.CloudtrailTable.property.stack"></a>

```typescript
public readonly stack: Stack;
```

- *Type:* aws-cdk-lib.Stack

The stack in which this resource is defined.

---

##### `database`<sup>Required</sup> <a name="database" id="cdk-extensions.glue_tables.CloudtrailTable.property.database"></a>

```typescript
public readonly database: Database;
```

- *Type:* cdk-extensions.glue.Database

---

##### `resource`<sup>Required</sup> <a name="resource" id="cdk-extensions.glue_tables.CloudtrailTable.property.resource"></a>

```typescript
public readonly resource: CfnTable;
```

- *Type:* aws-cdk-lib.aws_glue.CfnTable

---

##### `tableArn`<sup>Required</sup> <a name="tableArn" id="cdk-extensions.glue_tables.CloudtrailTable.property.tableArn"></a>

```typescript
public readonly tableArn: string;
```

- *Type:* string

---

##### `tableName`<sup>Required</sup> <a name="tableName" id="cdk-extensions.glue_tables.CloudtrailTable.property.tableName"></a>

```typescript
public readonly tableName: string;
```

- *Type:* string

---

##### `compressed`<sup>Optional</sup> <a name="compressed" id="cdk-extensions.glue_tables.CloudtrailTable.property.compressed"></a>

```typescript
public readonly compressed: boolean;
```

- *Type:* boolean

---

##### `dataFormat`<sup>Optional</sup> <a name="dataFormat" id="cdk-extensions.glue_tables.CloudtrailTable.property.dataFormat"></a>

```typescript
public readonly dataFormat: DataFormat;
```

- *Type:* cdk-extensions.glue.DataFormat

---

##### `description`<sup>Optional</sup> <a name="description" id="cdk-extensions.glue_tables.CloudtrailTable.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

---

##### `location`<sup>Optional</sup> <a name="location" id="cdk-extensions.glue_tables.CloudtrailTable.property.location"></a>

```typescript
public readonly location: string;
```

- *Type:* string

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.glue_tables.CloudtrailTable.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `owner`<sup>Optional</sup> <a name="owner" id="cdk-extensions.glue_tables.CloudtrailTable.property.owner"></a>

```typescript
public readonly owner: string;
```

- *Type:* string

---

##### `retention`<sup>Optional</sup> <a name="retention" id="cdk-extensions.glue_tables.CloudtrailTable.property.retention"></a>

```typescript
public readonly retention: Duration;
```

- *Type:* aws-cdk-lib.Duration

---

##### `serdeName`<sup>Optional</sup> <a name="serdeName" id="cdk-extensions.glue_tables.CloudtrailTable.property.serdeName"></a>

```typescript
public readonly serdeName: string;
```

- *Type:* string

---

##### `storedAsSubDirectories`<sup>Optional</sup> <a name="storedAsSubDirectories" id="cdk-extensions.glue_tables.CloudtrailTable.property.storedAsSubDirectories"></a>

```typescript
public readonly storedAsSubDirectories: boolean;
```

- *Type:* boolean

---

##### `tableType`<sup>Optional</sup> <a name="tableType" id="cdk-extensions.glue_tables.CloudtrailTable.property.tableType"></a>

```typescript
public readonly tableType: TableType;
```

- *Type:* cdk-extensions.glue.TableType

---

##### `targetTable`<sup>Optional</sup> <a name="targetTable" id="cdk-extensions.glue_tables.CloudtrailTable.property.targetTable"></a>

```typescript
public readonly targetTable: Table;
```

- *Type:* cdk-extensions.glue.Table

---

##### `viewExpandedText`<sup>Optional</sup> <a name="viewExpandedText" id="cdk-extensions.glue_tables.CloudtrailTable.property.viewExpandedText"></a>

```typescript
public readonly viewExpandedText: string;
```

- *Type:* string

---

##### `viewOriginalText`<sup>Optional</sup> <a name="viewOriginalText" id="cdk-extensions.glue_tables.CloudtrailTable.property.viewOriginalText"></a>

```typescript
public readonly viewOriginalText: string;
```

- *Type:* string

---

##### `createQueries`<sup>Required</sup> <a name="createQueries" id="cdk-extensions.glue_tables.CloudtrailTable.property.createQueries"></a>

```typescript
public readonly createQueries: boolean;
```

- *Type:* boolean

---

##### `friendlyQueryNames`<sup>Required</sup> <a name="friendlyQueryNames" id="cdk-extensions.glue_tables.CloudtrailTable.property.friendlyQueryNames"></a>

```typescript
public readonly friendlyQueryNames: boolean;
```

- *Type:* boolean

---

##### `unauthorizedNamedQuery`<sup>Optional</sup> <a name="unauthorizedNamedQuery" id="cdk-extensions.glue_tables.CloudtrailTable.property.unauthorizedNamedQuery"></a>

```typescript
public readonly unauthorizedNamedQuery: NamedQuery;
```

- *Type:* cdk-extensions.athena.NamedQuery

---

##### `userLoginsNamedQuery`<sup>Optional</sup> <a name="userLoginsNamedQuery" id="cdk-extensions.glue_tables.CloudtrailTable.property.userLoginsNamedQuery"></a>

```typescript
public readonly userLoginsNamedQuery: NamedQuery;
```

- *Type:* cdk-extensions.athena.NamedQuery

---


### Connection <a name="Connection" id="cdk-extensions.glue.Connection"></a>

- *Implements:* aws-cdk-lib.aws_ec2.IConnectable

#### Initializers <a name="Initializers" id="cdk-extensions.glue.Connection.Initializer"></a>

```typescript
import { glue } from 'cdk-extensions'

new glue.Connection(scope: Construct, id: string, props: ConnectionProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.Connection.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Connection.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Connection.Initializer.parameter.props">props</a></code> | <code>cdk-extensions.glue.ConnectionProps</code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.glue.Connection.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.glue.Connection.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="cdk-extensions.glue.Connection.Initializer.parameter.props"></a>

- *Type:* cdk-extensions.glue.ConnectionProps

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.glue.Connection.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-extensions.glue.Connection.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |
| <code><a href="#cdk-extensions.glue.Connection.addMatchCriteria">addMatchCriteria</a></code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Connection.addProperty">addProperty</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="cdk-extensions.glue.Connection.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="cdk-extensions.glue.Connection.applyRemovalPolicy"></a>

```typescript
public applyRemovalPolicy(policy: RemovalPolicy): void
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="cdk-extensions.glue.Connection.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.RemovalPolicy

---

##### `addMatchCriteria` <a name="addMatchCriteria" id="cdk-extensions.glue.Connection.addMatchCriteria"></a>

```typescript
public addMatchCriteria(value: string): void
```

###### `value`<sup>Required</sup> <a name="value" id="cdk-extensions.glue.Connection.addMatchCriteria.parameter.value"></a>

- *Type:* string

---

##### `addProperty` <a name="addProperty" id="cdk-extensions.glue.Connection.addProperty"></a>

```typescript
public addProperty(key: string, value: string): void
```

###### `key`<sup>Required</sup> <a name="key" id="cdk-extensions.glue.Connection.addProperty.parameter.key"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="cdk-extensions.glue.Connection.addProperty.parameter.value"></a>

- *Type:* string

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.glue.Connection.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-extensions.glue.Connection.isOwnedResource">isOwnedResource</a></code> | Returns true if the construct was created by CDK, and false otherwise. |
| <code><a href="#cdk-extensions.glue.Connection.isResource">isResource</a></code> | Check whether the given construct is a Resource. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-extensions.glue.Connection.isConstruct"></a>

```typescript
import { glue } from 'cdk-extensions'

glue.Connection.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-extensions.glue.Connection.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isOwnedResource` <a name="isOwnedResource" id="cdk-extensions.glue.Connection.isOwnedResource"></a>

```typescript
import { glue } from 'cdk-extensions'

glue.Connection.isOwnedResource(construct: IConstruct)
```

Returns true if the construct was created by CDK, and false otherwise.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.glue.Connection.isOwnedResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `isResource` <a name="isResource" id="cdk-extensions.glue.Connection.isResource"></a>

```typescript
import { glue } from 'cdk-extensions'

glue.Connection.isResource(construct: IConstruct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.glue.Connection.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.Connection.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-extensions.glue.Connection.property.env">env</a></code> | <code>aws-cdk-lib.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#cdk-extensions.glue.Connection.property.stack">stack</a></code> | <code>aws-cdk-lib.Stack</code> | The stack in which this resource is defined. |
| <code><a href="#cdk-extensions.glue.Connection.property.connectionArn">connectionArn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Connection.property.connectionName">connectionName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Connection.property.connections">connections</a></code> | <code>aws-cdk-lib.aws_ec2.Connections</code> | The network connections associated with this resource. |
| <code><a href="#cdk-extensions.glue.Connection.property.connectionType">connectionType</a></code> | <code>cdk-extensions.glue.ConnectionType</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Connection.property.resource">resource</a></code> | <code>aws-cdk-lib.aws_glue.CfnConnection</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Connection.property.securityGroups">securityGroups</a></code> | <code>aws-cdk-lib.aws_ec2.ISecurityGroup[]</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Connection.property.description">description</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Connection.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Connection.property.securityGroup">securityGroup</a></code> | <code>aws-cdk-lib.aws_ec2.SecurityGroup</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Connection.property.subnets">subnets</a></code> | <code>aws-cdk-lib.aws_ec2.SubnetSelection</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Connection.property.vpc">vpc</a></code> | <code>aws-cdk-lib.aws_ec2.IVpc</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-extensions.glue.Connection.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="cdk-extensions.glue.Connection.property.env"></a>

```typescript
public readonly env: ResourceEnvironment;
```

- *Type:* aws-cdk-lib.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="cdk-extensions.glue.Connection.property.stack"></a>

```typescript
public readonly stack: Stack;
```

- *Type:* aws-cdk-lib.Stack

The stack in which this resource is defined.

---

##### `connectionArn`<sup>Required</sup> <a name="connectionArn" id="cdk-extensions.glue.Connection.property.connectionArn"></a>

```typescript
public readonly connectionArn: string;
```

- *Type:* string

---

##### `connectionName`<sup>Required</sup> <a name="connectionName" id="cdk-extensions.glue.Connection.property.connectionName"></a>

```typescript
public readonly connectionName: string;
```

- *Type:* string

---

##### `connections`<sup>Required</sup> <a name="connections" id="cdk-extensions.glue.Connection.property.connections"></a>

```typescript
public readonly connections: Connections;
```

- *Type:* aws-cdk-lib.aws_ec2.Connections

The network connections associated with this resource.

---

##### `connectionType`<sup>Required</sup> <a name="connectionType" id="cdk-extensions.glue.Connection.property.connectionType"></a>

```typescript
public readonly connectionType: ConnectionType;
```

- *Type:* cdk-extensions.glue.ConnectionType

---

##### `resource`<sup>Required</sup> <a name="resource" id="cdk-extensions.glue.Connection.property.resource"></a>

```typescript
public readonly resource: CfnConnection;
```

- *Type:* aws-cdk-lib.aws_glue.CfnConnection

---

##### `securityGroups`<sup>Required</sup> <a name="securityGroups" id="cdk-extensions.glue.Connection.property.securityGroups"></a>

```typescript
public readonly securityGroups: ISecurityGroup[];
```

- *Type:* aws-cdk-lib.aws_ec2.ISecurityGroup[]

---

##### `description`<sup>Optional</sup> <a name="description" id="cdk-extensions.glue.Connection.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.glue.Connection.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `securityGroup`<sup>Optional</sup> <a name="securityGroup" id="cdk-extensions.glue.Connection.property.securityGroup"></a>

```typescript
public readonly securityGroup: SecurityGroup;
```

- *Type:* aws-cdk-lib.aws_ec2.SecurityGroup

---

##### `subnets`<sup>Optional</sup> <a name="subnets" id="cdk-extensions.glue.Connection.property.subnets"></a>

```typescript
public readonly subnets: SubnetSelection;
```

- *Type:* aws-cdk-lib.aws_ec2.SubnetSelection

---

##### `vpc`<sup>Optional</sup> <a name="vpc" id="cdk-extensions.glue.Connection.property.vpc"></a>

```typescript
public readonly vpc: IVpc;
```

- *Type:* aws-cdk-lib.aws_ec2.IVpc

---


### Crawler <a name="Crawler" id="cdk-extensions.glue.Crawler"></a>

#### Initializers <a name="Initializers" id="cdk-extensions.glue.Crawler.Initializer"></a>

```typescript
import { glue } from 'cdk-extensions'

new glue.Crawler(scope: Construct, id: string, props: CrawlerProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.Crawler.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | A CDK Construct that will serve as this stack's parent in the construct tree. |
| <code><a href="#cdk-extensions.glue.Crawler.Initializer.parameter.id">id</a></code> | <code>string</code> | A name to be associated with the stack and used in resource naming. |
| <code><a href="#cdk-extensions.glue.Crawler.Initializer.parameter.props">props</a></code> | <code>cdk-extensions.glue.CrawlerProps</code> | Arguments related to the configuration of the resource. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.glue.Crawler.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

A CDK Construct that will serve as this stack's parent in the construct tree.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.glue.Crawler.Initializer.parameter.id"></a>

- *Type:* string

A name to be associated with the stack and used in resource naming.

Must be unique
within the context of 'scope'.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk-extensions.glue.Crawler.Initializer.parameter.props"></a>

- *Type:* cdk-extensions.glue.CrawlerProps

Arguments related to the configuration of the resource.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.glue.Crawler.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-extensions.glue.Crawler.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |
| <code><a href="#cdk-extensions.glue.Crawler.addClassifier">addClassifier</a></code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Crawler.addTarget">addTarget</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="cdk-extensions.glue.Crawler.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="cdk-extensions.glue.Crawler.applyRemovalPolicy"></a>

```typescript
public applyRemovalPolicy(policy: RemovalPolicy): void
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="cdk-extensions.glue.Crawler.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.RemovalPolicy

---

##### `addClassifier` <a name="addClassifier" id="cdk-extensions.glue.Crawler.addClassifier"></a>

```typescript
public addClassifier(classifier: string): void
```

###### `classifier`<sup>Required</sup> <a name="classifier" id="cdk-extensions.glue.Crawler.addClassifier.parameter.classifier"></a>

- *Type:* string

---

##### `addTarget` <a name="addTarget" id="cdk-extensions.glue.Crawler.addTarget"></a>

```typescript
public addTarget(target: ICrawlerTarget): void
```

###### `target`<sup>Required</sup> <a name="target" id="cdk-extensions.glue.Crawler.addTarget.parameter.target"></a>

- *Type:* cdk-extensions.glue.ICrawlerTarget

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.glue.Crawler.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-extensions.glue.Crawler.isOwnedResource">isOwnedResource</a></code> | Returns true if the construct was created by CDK, and false otherwise. |
| <code><a href="#cdk-extensions.glue.Crawler.isResource">isResource</a></code> | Check whether the given construct is a Resource. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-extensions.glue.Crawler.isConstruct"></a>

```typescript
import { glue } from 'cdk-extensions'

glue.Crawler.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-extensions.glue.Crawler.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isOwnedResource` <a name="isOwnedResource" id="cdk-extensions.glue.Crawler.isOwnedResource"></a>

```typescript
import { glue } from 'cdk-extensions'

glue.Crawler.isOwnedResource(construct: IConstruct)
```

Returns true if the construct was created by CDK, and false otherwise.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.glue.Crawler.isOwnedResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `isResource` <a name="isResource" id="cdk-extensions.glue.Crawler.isResource"></a>

```typescript
import { glue } from 'cdk-extensions'

glue.Crawler.isResource(construct: IConstruct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.glue.Crawler.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.Crawler.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-extensions.glue.Crawler.property.env">env</a></code> | <code>aws-cdk-lib.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#cdk-extensions.glue.Crawler.property.stack">stack</a></code> | <code>aws-cdk-lib.Stack</code> | The stack in which this resource is defined. |
| <code><a href="#cdk-extensions.glue.Crawler.property.crawlerArn">crawlerArn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Crawler.property.crawlerName">crawlerName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Crawler.property.resource">resource</a></code> | <code>aws-cdk-lib.aws_glue.CfnCrawler</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Crawler.property.role">role</a></code> | <code>aws-cdk-lib.aws_iam.Role</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Crawler.property.configuration">configuration</a></code> | <code>cdk-extensions.glue.CrawlerConfiguration</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Crawler.property.database">database</a></code> | <code>cdk-extensions.glue.Database</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Crawler.property.deleteBehavior">deleteBehavior</a></code> | <code>cdk-extensions.glue.DeleteBehavior</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Crawler.property.description">description</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Crawler.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Crawler.property.recrawlBehavior">recrawlBehavior</a></code> | <code>cdk-extensions.glue.RecrawlBehavior</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Crawler.property.scheduleExpression">scheduleExpression</a></code> | <code>aws-cdk-lib.aws_events.Schedule</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Crawler.property.securityConfiguration">securityConfiguration</a></code> | <code>cdk-extensions.glue.SecurityConfiguration</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Crawler.property.tablePrefix">tablePrefix</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Crawler.property.updateBehavior">updateBehavior</a></code> | <code>cdk-extensions.glue.UpdateBehavior</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-extensions.glue.Crawler.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="cdk-extensions.glue.Crawler.property.env"></a>

```typescript
public readonly env: ResourceEnvironment;
```

- *Type:* aws-cdk-lib.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="cdk-extensions.glue.Crawler.property.stack"></a>

```typescript
public readonly stack: Stack;
```

- *Type:* aws-cdk-lib.Stack

The stack in which this resource is defined.

---

##### `crawlerArn`<sup>Required</sup> <a name="crawlerArn" id="cdk-extensions.glue.Crawler.property.crawlerArn"></a>

```typescript
public readonly crawlerArn: string;
```

- *Type:* string

---

##### `crawlerName`<sup>Required</sup> <a name="crawlerName" id="cdk-extensions.glue.Crawler.property.crawlerName"></a>

```typescript
public readonly crawlerName: string;
```

- *Type:* string

---

##### `resource`<sup>Required</sup> <a name="resource" id="cdk-extensions.glue.Crawler.property.resource"></a>

```typescript
public readonly resource: CfnCrawler;
```

- *Type:* aws-cdk-lib.aws_glue.CfnCrawler

---

##### `role`<sup>Required</sup> <a name="role" id="cdk-extensions.glue.Crawler.property.role"></a>

```typescript
public readonly role: Role;
```

- *Type:* aws-cdk-lib.aws_iam.Role

---

##### `configuration`<sup>Optional</sup> <a name="configuration" id="cdk-extensions.glue.Crawler.property.configuration"></a>

```typescript
public readonly configuration: CrawlerConfiguration;
```

- *Type:* cdk-extensions.glue.CrawlerConfiguration

---

##### `database`<sup>Optional</sup> <a name="database" id="cdk-extensions.glue.Crawler.property.database"></a>

```typescript
public readonly database: Database;
```

- *Type:* cdk-extensions.glue.Database

---

##### `deleteBehavior`<sup>Optional</sup> <a name="deleteBehavior" id="cdk-extensions.glue.Crawler.property.deleteBehavior"></a>

```typescript
public readonly deleteBehavior: DeleteBehavior;
```

- *Type:* cdk-extensions.glue.DeleteBehavior

---

##### `description`<sup>Optional</sup> <a name="description" id="cdk-extensions.glue.Crawler.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.glue.Crawler.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `recrawlBehavior`<sup>Optional</sup> <a name="recrawlBehavior" id="cdk-extensions.glue.Crawler.property.recrawlBehavior"></a>

```typescript
public readonly recrawlBehavior: RecrawlBehavior;
```

- *Type:* cdk-extensions.glue.RecrawlBehavior

---

##### `scheduleExpression`<sup>Optional</sup> <a name="scheduleExpression" id="cdk-extensions.glue.Crawler.property.scheduleExpression"></a>

```typescript
public readonly scheduleExpression: Schedule;
```

- *Type:* aws-cdk-lib.aws_events.Schedule

---

##### `securityConfiguration`<sup>Optional</sup> <a name="securityConfiguration" id="cdk-extensions.glue.Crawler.property.securityConfiguration"></a>

```typescript
public readonly securityConfiguration: SecurityConfiguration;
```

- *Type:* cdk-extensions.glue.SecurityConfiguration

---

##### `tablePrefix`<sup>Optional</sup> <a name="tablePrefix" id="cdk-extensions.glue.Crawler.property.tablePrefix"></a>

```typescript
public readonly tablePrefix: string;
```

- *Type:* string

---

##### `updateBehavior`<sup>Optional</sup> <a name="updateBehavior" id="cdk-extensions.glue.Crawler.property.updateBehavior"></a>

```typescript
public readonly updateBehavior: UpdateBehavior;
```

- *Type:* cdk-extensions.glue.UpdateBehavior

---


### Database <a name="Database" id="cdk-extensions.glue.Database"></a>

#### Initializers <a name="Initializers" id="cdk-extensions.glue.Database.Initializer"></a>

```typescript
import { glue } from 'cdk-extensions'

new glue.Database(scope: Construct, id: string, props?: DatabaseProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.Database.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | A CDK Construct that will serve as this stack's parent in the construct tree. |
| <code><a href="#cdk-extensions.glue.Database.Initializer.parameter.id">id</a></code> | <code>string</code> | A name to be associated with the stack and used in resource naming. |
| <code><a href="#cdk-extensions.glue.Database.Initializer.parameter.props">props</a></code> | <code>cdk-extensions.glue.DatabaseProps</code> | Arguments related to the configuration of the resource. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.glue.Database.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

A CDK Construct that will serve as this stack's parent in the construct tree.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.glue.Database.Initializer.parameter.id"></a>

- *Type:* string

A name to be associated with the stack and used in resource naming.

Must be unique
within the context of 'scope'.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk-extensions.glue.Database.Initializer.parameter.props"></a>

- *Type:* cdk-extensions.glue.DatabaseProps

Arguments related to the configuration of the resource.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.glue.Database.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-extensions.glue.Database.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |

---

##### `toString` <a name="toString" id="cdk-extensions.glue.Database.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="cdk-extensions.glue.Database.applyRemovalPolicy"></a>

```typescript
public applyRemovalPolicy(policy: RemovalPolicy): void
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="cdk-extensions.glue.Database.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.RemovalPolicy

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.glue.Database.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-extensions.glue.Database.isOwnedResource">isOwnedResource</a></code> | Returns true if the construct was created by CDK, and false otherwise. |
| <code><a href="#cdk-extensions.glue.Database.isResource">isResource</a></code> | Check whether the given construct is a Resource. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-extensions.glue.Database.isConstruct"></a>

```typescript
import { glue } from 'cdk-extensions'

glue.Database.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-extensions.glue.Database.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isOwnedResource` <a name="isOwnedResource" id="cdk-extensions.glue.Database.isOwnedResource"></a>

```typescript
import { glue } from 'cdk-extensions'

glue.Database.isOwnedResource(construct: IConstruct)
```

Returns true if the construct was created by CDK, and false otherwise.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.glue.Database.isOwnedResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `isResource` <a name="isResource" id="cdk-extensions.glue.Database.isResource"></a>

```typescript
import { glue } from 'cdk-extensions'

glue.Database.isResource(construct: IConstruct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.glue.Database.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.Database.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-extensions.glue.Database.property.env">env</a></code> | <code>aws-cdk-lib.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#cdk-extensions.glue.Database.property.stack">stack</a></code> | <code>aws-cdk-lib.Stack</code> | The stack in which this resource is defined. |
| <code><a href="#cdk-extensions.glue.Database.property.catalogArn">catalogArn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Database.property.catalogId">catalogId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Database.property.databaseArn">databaseArn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Database.property.databaseName">databaseName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Database.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Database.property.resource">resource</a></code> | <code>aws-cdk-lib.aws_glue.CfnDatabase</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Database.property.description">description</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Database.property.locationUri">locationUri</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-extensions.glue.Database.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="cdk-extensions.glue.Database.property.env"></a>

```typescript
public readonly env: ResourceEnvironment;
```

- *Type:* aws-cdk-lib.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="cdk-extensions.glue.Database.property.stack"></a>

```typescript
public readonly stack: Stack;
```

- *Type:* aws-cdk-lib.Stack

The stack in which this resource is defined.

---

##### `catalogArn`<sup>Required</sup> <a name="catalogArn" id="cdk-extensions.glue.Database.property.catalogArn"></a>

```typescript
public readonly catalogArn: string;
```

- *Type:* string

---

##### `catalogId`<sup>Required</sup> <a name="catalogId" id="cdk-extensions.glue.Database.property.catalogId"></a>

```typescript
public readonly catalogId: string;
```

- *Type:* string

---

##### `databaseArn`<sup>Required</sup> <a name="databaseArn" id="cdk-extensions.glue.Database.property.databaseArn"></a>

```typescript
public readonly databaseArn: string;
```

- *Type:* string

---

##### `databaseName`<sup>Required</sup> <a name="databaseName" id="cdk-extensions.glue.Database.property.databaseName"></a>

```typescript
public readonly databaseName: string;
```

- *Type:* string

---

##### `name`<sup>Required</sup> <a name="name" id="cdk-extensions.glue.Database.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `resource`<sup>Required</sup> <a name="resource" id="cdk-extensions.glue.Database.property.resource"></a>

```typescript
public readonly resource: CfnDatabase;
```

- *Type:* aws-cdk-lib.aws_glue.CfnDatabase

---

##### `description`<sup>Optional</sup> <a name="description" id="cdk-extensions.glue.Database.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

---

##### `locationUri`<sup>Optional</sup> <a name="locationUri" id="cdk-extensions.glue.Database.property.locationUri"></a>

```typescript
public readonly locationUri: string;
```

- *Type:* string

---


### DeliveryStream <a name="DeliveryStream" id="cdk-extensions.kinesis_firehose.DeliveryStream"></a>

- *Implements:* cdk-extensions.kinesis_firehose.IDeliveryStream

#### Initializers <a name="Initializers" id="cdk-extensions.kinesis_firehose.DeliveryStream.Initializer"></a>

```typescript
import { kinesis_firehose } from 'cdk-extensions'

new kinesis_firehose.DeliveryStream(scope: Construct, id: string, props: DeliveryStreamProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStream.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStream.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStream.Initializer.parameter.props">props</a></code> | <code>cdk-extensions.kinesis_firehose.DeliveryStreamProps</code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.kinesis_firehose.DeliveryStream.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.kinesis_firehose.DeliveryStream.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="cdk-extensions.kinesis_firehose.DeliveryStream.Initializer.parameter.props"></a>

- *Type:* cdk-extensions.kinesis_firehose.DeliveryStreamProps

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStream.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStream.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStream.grant">grant</a></code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStream.grantPutRecords">grantPutRecords</a></code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStream.metric">metric</a></code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStream.metricBackupToS3Bytes">metricBackupToS3Bytes</a></code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStream.metricBackupToS3DataFreshness">metricBackupToS3DataFreshness</a></code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStream.metricBackupToS3Records">metricBackupToS3Records</a></code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStream.metricIncomingBytes">metricIncomingBytes</a></code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStream.metricIncomingRecords">metricIncomingRecords</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="cdk-extensions.kinesis_firehose.DeliveryStream.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="cdk-extensions.kinesis_firehose.DeliveryStream.applyRemovalPolicy"></a>

```typescript
public applyRemovalPolicy(policy: RemovalPolicy): void
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="cdk-extensions.kinesis_firehose.DeliveryStream.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.RemovalPolicy

---

##### `grant` <a name="grant" id="cdk-extensions.kinesis_firehose.DeliveryStream.grant"></a>

```typescript
public grant(grantee: IGrantable, actions: string): Grant
```

###### `grantee`<sup>Required</sup> <a name="grantee" id="cdk-extensions.kinesis_firehose.DeliveryStream.grant.parameter.grantee"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `actions`<sup>Required</sup> <a name="actions" id="cdk-extensions.kinesis_firehose.DeliveryStream.grant.parameter.actions"></a>

- *Type:* string

---

##### `grantPutRecords` <a name="grantPutRecords" id="cdk-extensions.kinesis_firehose.DeliveryStream.grantPutRecords"></a>

```typescript
public grantPutRecords(grantee: IGrantable): Grant
```

###### `grantee`<sup>Required</sup> <a name="grantee" id="cdk-extensions.kinesis_firehose.DeliveryStream.grantPutRecords.parameter.grantee"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

##### `metric` <a name="metric" id="cdk-extensions.kinesis_firehose.DeliveryStream.metric"></a>

```typescript
public metric(metricName: string, props?: MetricOptions): Metric
```

###### `metricName`<sup>Required</sup> <a name="metricName" id="cdk-extensions.kinesis_firehose.DeliveryStream.metric.parameter.metricName"></a>

- *Type:* string

---

###### `props`<sup>Optional</sup> <a name="props" id="cdk-extensions.kinesis_firehose.DeliveryStream.metric.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricBackupToS3Bytes` <a name="metricBackupToS3Bytes" id="cdk-extensions.kinesis_firehose.DeliveryStream.metricBackupToS3Bytes"></a>

```typescript
public metricBackupToS3Bytes(props?: MetricOptions): Metric
```

###### `props`<sup>Optional</sup> <a name="props" id="cdk-extensions.kinesis_firehose.DeliveryStream.metricBackupToS3Bytes.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricBackupToS3DataFreshness` <a name="metricBackupToS3DataFreshness" id="cdk-extensions.kinesis_firehose.DeliveryStream.metricBackupToS3DataFreshness"></a>

```typescript
public metricBackupToS3DataFreshness(props?: MetricOptions): Metric
```

###### `props`<sup>Optional</sup> <a name="props" id="cdk-extensions.kinesis_firehose.DeliveryStream.metricBackupToS3DataFreshness.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricBackupToS3Records` <a name="metricBackupToS3Records" id="cdk-extensions.kinesis_firehose.DeliveryStream.metricBackupToS3Records"></a>

```typescript
public metricBackupToS3Records(props?: MetricOptions): Metric
```

###### `props`<sup>Optional</sup> <a name="props" id="cdk-extensions.kinesis_firehose.DeliveryStream.metricBackupToS3Records.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricIncomingBytes` <a name="metricIncomingBytes" id="cdk-extensions.kinesis_firehose.DeliveryStream.metricIncomingBytes"></a>

```typescript
public metricIncomingBytes(props?: MetricOptions): Metric
```

###### `props`<sup>Optional</sup> <a name="props" id="cdk-extensions.kinesis_firehose.DeliveryStream.metricIncomingBytes.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricIncomingRecords` <a name="metricIncomingRecords" id="cdk-extensions.kinesis_firehose.DeliveryStream.metricIncomingRecords"></a>

```typescript
public metricIncomingRecords(props?: MetricOptions): Metric
```

###### `props`<sup>Optional</sup> <a name="props" id="cdk-extensions.kinesis_firehose.DeliveryStream.metricIncomingRecords.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStream.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStream.isOwnedResource">isOwnedResource</a></code> | Returns true if the construct was created by CDK, and false otherwise. |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStream.isResource">isResource</a></code> | Check whether the given construct is a Resource. |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStream.fromDeliveryStreamArn">fromDeliveryStreamArn</a></code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStream.fromDeliveryStreamAttributes">fromDeliveryStreamAttributes</a></code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStream.fromDeliveryStreamName">fromDeliveryStreamName</a></code> | *No description.* |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-extensions.kinesis_firehose.DeliveryStream.isConstruct"></a>

```typescript
import { kinesis_firehose } from 'cdk-extensions'

kinesis_firehose.DeliveryStream.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-extensions.kinesis_firehose.DeliveryStream.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isOwnedResource` <a name="isOwnedResource" id="cdk-extensions.kinesis_firehose.DeliveryStream.isOwnedResource"></a>

```typescript
import { kinesis_firehose } from 'cdk-extensions'

kinesis_firehose.DeliveryStream.isOwnedResource(construct: IConstruct)
```

Returns true if the construct was created by CDK, and false otherwise.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.kinesis_firehose.DeliveryStream.isOwnedResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `isResource` <a name="isResource" id="cdk-extensions.kinesis_firehose.DeliveryStream.isResource"></a>

```typescript
import { kinesis_firehose } from 'cdk-extensions'

kinesis_firehose.DeliveryStream.isResource(construct: IConstruct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.kinesis_firehose.DeliveryStream.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `fromDeliveryStreamArn` <a name="fromDeliveryStreamArn" id="cdk-extensions.kinesis_firehose.DeliveryStream.fromDeliveryStreamArn"></a>

```typescript
import { kinesis_firehose } from 'cdk-extensions'

kinesis_firehose.DeliveryStream.fromDeliveryStreamArn(scope: Construct, id: string, deliveryStreamArn: string)
```

###### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.kinesis_firehose.DeliveryStream.fromDeliveryStreamArn.parameter.scope"></a>

- *Type:* constructs.Construct

---

###### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.kinesis_firehose.DeliveryStream.fromDeliveryStreamArn.parameter.id"></a>

- *Type:* string

---

###### `deliveryStreamArn`<sup>Required</sup> <a name="deliveryStreamArn" id="cdk-extensions.kinesis_firehose.DeliveryStream.fromDeliveryStreamArn.parameter.deliveryStreamArn"></a>

- *Type:* string

---

##### `fromDeliveryStreamAttributes` <a name="fromDeliveryStreamAttributes" id="cdk-extensions.kinesis_firehose.DeliveryStream.fromDeliveryStreamAttributes"></a>

```typescript
import { kinesis_firehose } from 'cdk-extensions'

kinesis_firehose.DeliveryStream.fromDeliveryStreamAttributes(scope: Construct, id: string, attrs: DeliveryStreamAttributes)
```

###### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.kinesis_firehose.DeliveryStream.fromDeliveryStreamAttributes.parameter.scope"></a>

- *Type:* constructs.Construct

---

###### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.kinesis_firehose.DeliveryStream.fromDeliveryStreamAttributes.parameter.id"></a>

- *Type:* string

---

###### `attrs`<sup>Required</sup> <a name="attrs" id="cdk-extensions.kinesis_firehose.DeliveryStream.fromDeliveryStreamAttributes.parameter.attrs"></a>

- *Type:* cdk-extensions.kinesis_firehose.DeliveryStreamAttributes

---

##### `fromDeliveryStreamName` <a name="fromDeliveryStreamName" id="cdk-extensions.kinesis_firehose.DeliveryStream.fromDeliveryStreamName"></a>

```typescript
import { kinesis_firehose } from 'cdk-extensions'

kinesis_firehose.DeliveryStream.fromDeliveryStreamName(scope: Construct, id: string, deliveryStreamName: string)
```

###### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.kinesis_firehose.DeliveryStream.fromDeliveryStreamName.parameter.scope"></a>

- *Type:* constructs.Construct

---

###### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.kinesis_firehose.DeliveryStream.fromDeliveryStreamName.parameter.id"></a>

- *Type:* string

---

###### `deliveryStreamName`<sup>Required</sup> <a name="deliveryStreamName" id="cdk-extensions.kinesis_firehose.DeliveryStream.fromDeliveryStreamName.parameter.deliveryStreamName"></a>

- *Type:* string

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStream.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStream.property.env">env</a></code> | <code>aws-cdk-lib.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStream.property.stack">stack</a></code> | <code>aws-cdk-lib.Stack</code> | The stack in which this resource is defined. |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStream.property.connections">connections</a></code> | <code>aws-cdk-lib.aws_ec2.Connections</code> | The network connections associated with this resource. |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStream.property.deliveryStreamArn">deliveryStreamArn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStream.property.deliveryStreamName">deliveryStreamName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStream.property.destination">destination</a></code> | <code>cdk-extensions.kinesis_firehose.DeliveryStreamDestination</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStream.property.grantPrincipal">grantPrincipal</a></code> | <code>aws-cdk-lib.aws_iam.IPrincipal</code> | The principal to grant permissions to. |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStream.property.resource">resource</a></code> | <code>aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStream.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStream.property.streamType">streamType</a></code> | <code>cdk-extensions.kinesis_firehose.DeliveryStreamType</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-extensions.kinesis_firehose.DeliveryStream.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="cdk-extensions.kinesis_firehose.DeliveryStream.property.env"></a>

```typescript
public readonly env: ResourceEnvironment;
```

- *Type:* aws-cdk-lib.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="cdk-extensions.kinesis_firehose.DeliveryStream.property.stack"></a>

```typescript
public readonly stack: Stack;
```

- *Type:* aws-cdk-lib.Stack

The stack in which this resource is defined.

---

##### `connections`<sup>Required</sup> <a name="connections" id="cdk-extensions.kinesis_firehose.DeliveryStream.property.connections"></a>

```typescript
public readonly connections: Connections;
```

- *Type:* aws-cdk-lib.aws_ec2.Connections

The network connections associated with this resource.

---

##### `deliveryStreamArn`<sup>Required</sup> <a name="deliveryStreamArn" id="cdk-extensions.kinesis_firehose.DeliveryStream.property.deliveryStreamArn"></a>

```typescript
public readonly deliveryStreamArn: string;
```

- *Type:* string

---

##### `deliveryStreamName`<sup>Required</sup> <a name="deliveryStreamName" id="cdk-extensions.kinesis_firehose.DeliveryStream.property.deliveryStreamName"></a>

```typescript
public readonly deliveryStreamName: string;
```

- *Type:* string

---

##### `destination`<sup>Required</sup> <a name="destination" id="cdk-extensions.kinesis_firehose.DeliveryStream.property.destination"></a>

```typescript
public readonly destination: DeliveryStreamDestination;
```

- *Type:* cdk-extensions.kinesis_firehose.DeliveryStreamDestination

---

##### `grantPrincipal`<sup>Required</sup> <a name="grantPrincipal" id="cdk-extensions.kinesis_firehose.DeliveryStream.property.grantPrincipal"></a>

```typescript
public readonly grantPrincipal: IPrincipal;
```

- *Type:* aws-cdk-lib.aws_iam.IPrincipal

The principal to grant permissions to.

---

##### `resource`<sup>Required</sup> <a name="resource" id="cdk-extensions.kinesis_firehose.DeliveryStream.property.resource"></a>

```typescript
public readonly resource: CfnDeliveryStream;
```

- *Type:* aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.kinesis_firehose.DeliveryStream.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `streamType`<sup>Optional</sup> <a name="streamType" id="cdk-extensions.kinesis_firehose.DeliveryStream.property.streamType"></a>

```typescript
public readonly streamType: DeliveryStreamType;
```

- *Type:* cdk-extensions.kinesis_firehose.DeliveryStreamType

---


### FlowLog <a name="FlowLog" id="cdk-extensions.ec2.FlowLog"></a>

- *Implements:* aws-cdk-lib.aws_ec2.IFlowLog

#### Initializers <a name="Initializers" id="cdk-extensions.ec2.FlowLog.Initializer"></a>

```typescript
import { ec2 } from 'cdk-extensions'

new ec2.FlowLog(scope: IConstruct, id: string, props: FlowLogProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.ec2.FlowLog.Initializer.parameter.scope">scope</a></code> | <code>constructs.IConstruct</code> | A CDK Construct that will serve as this stack's parent in the construct tree. |
| <code><a href="#cdk-extensions.ec2.FlowLog.Initializer.parameter.id">id</a></code> | <code>string</code> | A name to be associated with the stack and used in resource naming. |
| <code><a href="#cdk-extensions.ec2.FlowLog.Initializer.parameter.props">props</a></code> | <code>cdk-extensions.ec2.FlowLogProps</code> | Arguments related to the configuration of the resource. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.ec2.FlowLog.Initializer.parameter.scope"></a>

- *Type:* constructs.IConstruct

A CDK Construct that will serve as this stack's parent in the construct tree.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.ec2.FlowLog.Initializer.parameter.id"></a>

- *Type:* string

A name to be associated with the stack and used in resource naming.

Must be unique
within the context of 'scope'.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk-extensions.ec2.FlowLog.Initializer.parameter.props"></a>

- *Type:* cdk-extensions.ec2.FlowLogProps

Arguments related to the configuration of the resource.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.ec2.FlowLog.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-extensions.ec2.FlowLog.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |

---

##### `toString` <a name="toString" id="cdk-extensions.ec2.FlowLog.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="cdk-extensions.ec2.FlowLog.applyRemovalPolicy"></a>

```typescript
public applyRemovalPolicy(policy: RemovalPolicy): void
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="cdk-extensions.ec2.FlowLog.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.RemovalPolicy

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.ec2.FlowLog.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-extensions.ec2.FlowLog.isOwnedResource">isOwnedResource</a></code> | Returns true if the construct was created by CDK, and false otherwise. |
| <code><a href="#cdk-extensions.ec2.FlowLog.isResource">isResource</a></code> | Check whether the given construct is a Resource. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-extensions.ec2.FlowLog.isConstruct"></a>

```typescript
import { ec2 } from 'cdk-extensions'

ec2.FlowLog.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-extensions.ec2.FlowLog.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isOwnedResource` <a name="isOwnedResource" id="cdk-extensions.ec2.FlowLog.isOwnedResource"></a>

```typescript
import { ec2 } from 'cdk-extensions'

ec2.FlowLog.isOwnedResource(construct: IConstruct)
```

Returns true if the construct was created by CDK, and false otherwise.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.ec2.FlowLog.isOwnedResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `isResource` <a name="isResource" id="cdk-extensions.ec2.FlowLog.isResource"></a>

```typescript
import { ec2 } from 'cdk-extensions'

ec2.FlowLog.isResource(construct: IConstruct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.ec2.FlowLog.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.ec2.FlowLog.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-extensions.ec2.FlowLog.property.env">env</a></code> | <code>aws-cdk-lib.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#cdk-extensions.ec2.FlowLog.property.stack">stack</a></code> | <code>aws-cdk-lib.Stack</code> | The stack in which this resource is defined. |
| <code><a href="#cdk-extensions.ec2.FlowLog.property.destination">destination</a></code> | <code>cdk-extensions.ec2.FlowLogDestination</code> | The location where flow logs should be delivered. |
| <code><a href="#cdk-extensions.ec2.FlowLog.property.flowLogArn">flowLogArn</a></code> | <code>string</code> | The Amazon Resource Name (ARN) of the flow log. |
| <code><a href="#cdk-extensions.ec2.FlowLog.property.flowLogId">flowLogId</a></code> | <code>string</code> | The ID of the flow log. |
| <code><a href="#cdk-extensions.ec2.FlowLog.property.format">format</a></code> | <code>cdk-extensions.ec2.FlowLogFormat</code> | The fields to include in the flow log record, in the order in which they should appear. |
| <code><a href="#cdk-extensions.ec2.FlowLog.property.resource">resource</a></code> | <code>aws-cdk-lib.aws_ec2.CfnFlowLog</code> | The underlying FlowLog CloudFormation resource. |
| <code><a href="#cdk-extensions.ec2.FlowLog.property.resourceType">resourceType</a></code> | <code>aws-cdk-lib.aws_ec2.FlowLogResourceType</code> | Details for the resource from which flow logs will be captured. |
| <code><a href="#cdk-extensions.ec2.FlowLog.property.trafficType">trafficType</a></code> | <code>aws-cdk-lib.aws_ec2.FlowLogTrafficType</code> | The type of traffic to monitor (accepted traffic, rejected traffic, or all traffic). |
| <code><a href="#cdk-extensions.ec2.FlowLog.property.maxAggregationInterval">maxAggregationInterval</a></code> | <code>cdk-extensions.ec2.FlowLogAggregationInterval</code> | The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-extensions.ec2.FlowLog.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="cdk-extensions.ec2.FlowLog.property.env"></a>

```typescript
public readonly env: ResourceEnvironment;
```

- *Type:* aws-cdk-lib.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="cdk-extensions.ec2.FlowLog.property.stack"></a>

```typescript
public readonly stack: Stack;
```

- *Type:* aws-cdk-lib.Stack

The stack in which this resource is defined.

---

##### `destination`<sup>Required</sup> <a name="destination" id="cdk-extensions.ec2.FlowLog.property.destination"></a>

```typescript
public readonly destination: FlowLogDestination;
```

- *Type:* cdk-extensions.ec2.FlowLogDestination

The location where flow logs should be delivered.

> [[FlowLog LogDestinationType](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logdestinationtype)]([FlowLog LogDestinationType](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logdestinationtype))

---

##### `flowLogArn`<sup>Required</sup> <a name="flowLogArn" id="cdk-extensions.ec2.FlowLog.property.flowLogArn"></a>

```typescript
public readonly flowLogArn: string;
```

- *Type:* string

The Amazon Resource Name (ARN) of the flow log.

---

##### `flowLogId`<sup>Required</sup> <a name="flowLogId" id="cdk-extensions.ec2.FlowLog.property.flowLogId"></a>

```typescript
public readonly flowLogId: string;
```

- *Type:* string

The ID of the flow log.

---

##### `format`<sup>Required</sup> <a name="format" id="cdk-extensions.ec2.FlowLog.property.format"></a>

```typescript
public readonly format: FlowLogFormat;
```

- *Type:* cdk-extensions.ec2.FlowLogFormat

The fields to include in the flow log record, in the order in which they should appear.

For a list of available fields, see {@link FlowLogField}.

> [[FlowLog LogFormat](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logformat)]([FlowLog LogFormat](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logformat))

---

##### `resource`<sup>Required</sup> <a name="resource" id="cdk-extensions.ec2.FlowLog.property.resource"></a>

```typescript
public readonly resource: CfnFlowLog;
```

- *Type:* aws-cdk-lib.aws_ec2.CfnFlowLog

The underlying FlowLog CloudFormation resource.

> [[AWS::EC2::FlowLog](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html)]([AWS::EC2::FlowLog](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html))

---

##### `resourceType`<sup>Required</sup> <a name="resourceType" id="cdk-extensions.ec2.FlowLog.property.resourceType"></a>

```typescript
public readonly resourceType: FlowLogResourceType;
```

- *Type:* aws-cdk-lib.aws_ec2.FlowLogResourceType

Details for the resource from which flow logs will be captured.

> [[FlowLog ResourceType](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-resourcetype)]([FlowLog ResourceType](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-resourcetype))

---

##### `trafficType`<sup>Required</sup> <a name="trafficType" id="cdk-extensions.ec2.FlowLog.property.trafficType"></a>

```typescript
public readonly trafficType: FlowLogTrafficType;
```

- *Type:* aws-cdk-lib.aws_ec2.FlowLogTrafficType

The type of traffic to monitor (accepted traffic, rejected traffic, or all traffic).

> [[FlowLog TrafficType](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-traffictype)]([FlowLog TrafficType](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-traffictype))

---

##### `maxAggregationInterval`<sup>Optional</sup> <a name="maxAggregationInterval" id="cdk-extensions.ec2.FlowLog.property.maxAggregationInterval"></a>

```typescript
public readonly maxAggregationInterval: FlowLogAggregationInterval;
```

- *Type:* cdk-extensions.ec2.FlowLogAggregationInterval

The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record.

> [[FlowLog MaxAggregationInterval](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-maxaggregationinterval)]([FlowLog MaxAggregationInterval](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-maxaggregationinterval))

---


### FlowLogsBucket <a name="FlowLogsBucket" id="cdk-extensions.s3_buckets.FlowLogsBucket"></a>

#### Initializers <a name="Initializers" id="cdk-extensions.s3_buckets.FlowLogsBucket.Initializer"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

new s3_buckets.FlowLogsBucket(scope: Construct, id: string, props?: FlowLogsBucketProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | A CDK Construct that will serve as this stack's parent in the construct tree. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.Initializer.parameter.id">id</a></code> | <code>string</code> | A name to be associated with the stack and used in resource naming. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.Initializer.parameter.props">props</a></code> | <code>cdk-extensions.s3_buckets.FlowLogsBucketProps</code> | Arguments related to the configuration of the resource. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.s3_buckets.FlowLogsBucket.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

A CDK Construct that will serve as this stack's parent in the construct tree.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.s3_buckets.FlowLogsBucket.Initializer.parameter.id"></a>

- *Type:* string

A name to be associated with the stack and used in resource naming.

Must be unique
within the context of 'scope'.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk-extensions.s3_buckets.FlowLogsBucket.Initializer.parameter.props"></a>

- *Type:* cdk-extensions.s3_buckets.FlowLogsBucketProps

Arguments related to the configuration of the resource.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.addEventNotification">addEventNotification</a></code> | Adds a bucket notification event destination. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.addObjectCreatedNotification">addObjectCreatedNotification</a></code> | Subscribes a destination to receive notifications when an object is created in the bucket. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.addObjectRemovedNotification">addObjectRemovedNotification</a></code> | Subscribes a destination to receive notifications when an object is removed from the bucket. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.addToResourcePolicy">addToResourcePolicy</a></code> | Adds a statement to the resource policy for a principal (i.e. account/role/service) to perform actions on this bucket and/or its contents. Use `bucketArn` and `arnForObjects(keys)` to obtain ARNs for this bucket or objects. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.arnForObjects">arnForObjects</a></code> | Returns an ARN that represents all objects within the bucket that match the key pattern specified. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.enableEventBridgeNotification">enableEventBridgeNotification</a></code> | Enables event bridge notification, causing all events below to be sent to EventBridge:. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.grantDelete">grantDelete</a></code> | Grants s3:DeleteObject* permission to an IAM principal for objects in this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.grantPublicAccess">grantPublicAccess</a></code> | Allows unrestricted access to objects from this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.grantPut">grantPut</a></code> | Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.grantPutAcl">grantPutAcl</a></code> | Grant the given IAM identity permissions to modify the ACLs of objects in the given Bucket. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.grantRead">grantRead</a></code> | Grant read permissions for this bucket and it's contents to an IAM principal (Role/Group/User). |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.grantReadWrite">grantReadWrite</a></code> | Grants read/write permissions for this bucket and it's contents to an IAM principal (Role/Group/User). |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.grantWrite">grantWrite</a></code> | Grant write permissions to this bucket to an IAM principal. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.onCloudTrailEvent">onCloudTrailEvent</a></code> | Defines a CloudWatch event that triggers when something happens to this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.onCloudTrailPutObject">onCloudTrailPutObject</a></code> | Defines an AWS CloudWatch event that triggers when an object is uploaded to the specified paths (keys) in this bucket using the PutObject API call. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.onCloudTrailWriteObject">onCloudTrailWriteObject</a></code> | Defines an AWS CloudWatch event that triggers when an object at the specified paths (keys) in this bucket are written to. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.s3UrlForObject">s3UrlForObject</a></code> | The S3 URL of an S3 object. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.transferAccelerationUrlForObject">transferAccelerationUrlForObject</a></code> | The https Transfer Acceleration URL of an S3 object. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.urlForObject">urlForObject</a></code> | The https URL of an S3 object. For example:. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.virtualHostedUrlForObject">virtualHostedUrlForObject</a></code> | The virtual hosted-style URL of an S3 object. Specify `regional: false` at the options for non-regional URL. For example:. |

---

##### `toString` <a name="toString" id="cdk-extensions.s3_buckets.FlowLogsBucket.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="cdk-extensions.s3_buckets.FlowLogsBucket.applyRemovalPolicy"></a>

```typescript
public applyRemovalPolicy(policy: RemovalPolicy): void
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="cdk-extensions.s3_buckets.FlowLogsBucket.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.RemovalPolicy

---

##### `addEventNotification` <a name="addEventNotification" id="cdk-extensions.s3_buckets.FlowLogsBucket.addEventNotification"></a>

```typescript
public addEventNotification(_event: EventType, _dest: IBucketNotificationDestination, _filters: NotificationKeyFilter): void
```

Adds a bucket notification event destination.

###### `_event`<sup>Required</sup> <a name="_event" id="cdk-extensions.s3_buckets.FlowLogsBucket.addEventNotification.parameter._event"></a>

- *Type:* aws-cdk-lib.aws_s3.EventType

---

###### `_dest`<sup>Required</sup> <a name="_dest" id="cdk-extensions.s3_buckets.FlowLogsBucket.addEventNotification.parameter._dest"></a>

- *Type:* aws-cdk-lib.aws_s3.IBucketNotificationDestination

---

###### `_filters`<sup>Required</sup> <a name="_filters" id="cdk-extensions.s3_buckets.FlowLogsBucket.addEventNotification.parameter._filters"></a>

- *Type:* aws-cdk-lib.aws_s3.NotificationKeyFilter

---

##### `addObjectCreatedNotification` <a name="addObjectCreatedNotification" id="cdk-extensions.s3_buckets.FlowLogsBucket.addObjectCreatedNotification"></a>

```typescript
public addObjectCreatedNotification(_dest: IBucketNotificationDestination, _filters: NotificationKeyFilter): void
```

Subscribes a destination to receive notifications when an object is created in the bucket.

This is identical to calling
`onEvent(s3.EventType.OBJECT_CREATED)`.

###### `_dest`<sup>Required</sup> <a name="_dest" id="cdk-extensions.s3_buckets.FlowLogsBucket.addObjectCreatedNotification.parameter._dest"></a>

- *Type:* aws-cdk-lib.aws_s3.IBucketNotificationDestination

---

###### `_filters`<sup>Required</sup> <a name="_filters" id="cdk-extensions.s3_buckets.FlowLogsBucket.addObjectCreatedNotification.parameter._filters"></a>

- *Type:* aws-cdk-lib.aws_s3.NotificationKeyFilter

---

##### `addObjectRemovedNotification` <a name="addObjectRemovedNotification" id="cdk-extensions.s3_buckets.FlowLogsBucket.addObjectRemovedNotification"></a>

```typescript
public addObjectRemovedNotification(_dest: IBucketNotificationDestination, _filters: NotificationKeyFilter): void
```

Subscribes a destination to receive notifications when an object is removed from the bucket.

This is identical to calling
`onEvent(EventType.OBJECT_REMOVED)`.

###### `_dest`<sup>Required</sup> <a name="_dest" id="cdk-extensions.s3_buckets.FlowLogsBucket.addObjectRemovedNotification.parameter._dest"></a>

- *Type:* aws-cdk-lib.aws_s3.IBucketNotificationDestination

---

###### `_filters`<sup>Required</sup> <a name="_filters" id="cdk-extensions.s3_buckets.FlowLogsBucket.addObjectRemovedNotification.parameter._filters"></a>

- *Type:* aws-cdk-lib.aws_s3.NotificationKeyFilter

---

##### `addToResourcePolicy` <a name="addToResourcePolicy" id="cdk-extensions.s3_buckets.FlowLogsBucket.addToResourcePolicy"></a>

```typescript
public addToResourcePolicy(permission: PolicyStatement): AddToResourcePolicyResult
```

Adds a statement to the resource policy for a principal (i.e. account/role/service) to perform actions on this bucket and/or its contents. Use `bucketArn` and `arnForObjects(keys)` to obtain ARNs for this bucket or objects.

Note that the policy statement may or may not be added to the policy.
For example, when an `IBucket` is created from an existing bucket,
it's not possible to tell whether the bucket already has a policy
attached, let alone to re-use that policy to add more statements to it.
So it's safest to do nothing in these cases.

###### `permission`<sup>Required</sup> <a name="permission" id="cdk-extensions.s3_buckets.FlowLogsBucket.addToResourcePolicy.parameter.permission"></a>

- *Type:* aws-cdk-lib.aws_iam.PolicyStatement

---

##### `arnForObjects` <a name="arnForObjects" id="cdk-extensions.s3_buckets.FlowLogsBucket.arnForObjects"></a>

```typescript
public arnForObjects(_keyPattern: string): string
```

Returns an ARN that represents all objects within the bucket that match the key pattern specified.

To represent all keys, specify ``"*"``.

###### `_keyPattern`<sup>Required</sup> <a name="_keyPattern" id="cdk-extensions.s3_buckets.FlowLogsBucket.arnForObjects.parameter._keyPattern"></a>

- *Type:* string

---

##### `enableEventBridgeNotification` <a name="enableEventBridgeNotification" id="cdk-extensions.s3_buckets.FlowLogsBucket.enableEventBridgeNotification"></a>

```typescript
public enableEventBridgeNotification(): void
```

Enables event bridge notification, causing all events below to be sent to EventBridge:.

Object Deleted (DeleteObject)
- Object Deleted (Lifecycle expiration)
- Object Restore Initiated
- Object Restore Completed
- Object Restore Expired
- Object Storage Class Changed
- Object Access Tier Changed
- Object ACL Updated
- Object Tags Added
- Object Tags Deleted

##### `grantDelete` <a name="grantDelete" id="cdk-extensions.s3_buckets.FlowLogsBucket.grantDelete"></a>

```typescript
public grantDelete(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grants s3:DeleteObject* permission to an IAM principal for objects in this bucket.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.FlowLogsBucket.grantDelete.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.FlowLogsBucket.grantDelete.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `grantPublicAccess` <a name="grantPublicAccess" id="cdk-extensions.s3_buckets.FlowLogsBucket.grantPublicAccess"></a>

```typescript
public grantPublicAccess(_allowedActions: string, _keyPrefix?: string): Grant
```

Allows unrestricted access to objects from this bucket.

IMPORTANT: This permission allows anyone to perform actions on S3 objects
in this bucket, which is useful for when you configure your bucket as a
website and want everyone to be able to read objects in the bucket without
needing to authenticate.

Without arguments, this method will grant read ("s3:GetObject") access to
all objects ("*") in the bucket.

The method returns the `iam.Grant` object, which can then be modified
as needed. For example, you can add a condition that will restrict access only
to an IPv4 range like this:

     const grant = bucket.grantPublicAccess();
     grant.resourceStatement!.addCondition(‘IpAddress’, { “aws:SourceIp”: “54.240.143.0/24” });

###### `_allowedActions`<sup>Required</sup> <a name="_allowedActions" id="cdk-extensions.s3_buckets.FlowLogsBucket.grantPublicAccess.parameter._allowedActions"></a>

- *Type:* string

---

###### `_keyPrefix`<sup>Optional</sup> <a name="_keyPrefix" id="cdk-extensions.s3_buckets.FlowLogsBucket.grantPublicAccess.parameter._keyPrefix"></a>

- *Type:* string

---

##### `grantPut` <a name="grantPut" id="cdk-extensions.s3_buckets.FlowLogsBucket.grantPut"></a>

```typescript
public grantPut(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal.

If encryption is used, permission to use the key to encrypt the contents
of written files will also be granted to the same principal.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.FlowLogsBucket.grantPut.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.FlowLogsBucket.grantPut.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `grantPutAcl` <a name="grantPutAcl" id="cdk-extensions.s3_buckets.FlowLogsBucket.grantPutAcl"></a>

```typescript
public grantPutAcl(_identity: IGrantable, _objectsKeyPattern?: string): Grant
```

Grant the given IAM identity permissions to modify the ACLs of objects in the given Bucket.

If your application has the '@aws-cdk/aws-s3:grantWriteWithoutAcl' feature flag set,
calling {@link grantWrite} or {@link grantReadWrite} no longer grants permissions to modify the ACLs of the objects;
in this case, if you need to modify object ACLs, call this method explicitly.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.FlowLogsBucket.grantPutAcl.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.FlowLogsBucket.grantPutAcl.parameter._objectsKeyPattern"></a>

- *Type:* string

---

##### `grantRead` <a name="grantRead" id="cdk-extensions.s3_buckets.FlowLogsBucket.grantRead"></a>

```typescript
public grantRead(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grant read permissions for this bucket and it's contents to an IAM principal (Role/Group/User).

If encryption is used, permission to use the key to decrypt the contents
of the bucket will also be granted to the same principal.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.FlowLogsBucket.grantRead.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.FlowLogsBucket.grantRead.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `grantReadWrite` <a name="grantReadWrite" id="cdk-extensions.s3_buckets.FlowLogsBucket.grantReadWrite"></a>

```typescript
public grantReadWrite(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grants read/write permissions for this bucket and it's contents to an IAM principal (Role/Group/User).

If an encryption key is used, permission to use the key for
encrypt/decrypt will also be granted.

Before CDK version 1.85.0, this method granted the `s3:PutObject*` permission that included `s3:PutObjectAcl`,
which could be used to grant read/write object access to IAM principals in other accounts.
If you want to get rid of that behavior, update your CDK version to 1.85.0 or later,
and make sure the `@aws-cdk/aws-s3:grantWriteWithoutAcl` feature flag is set to `true`
in the `context` key of your cdk.json file.
If you've already updated, but still need the principal to have permissions to modify the ACLs,
use the {@link grantPutAcl} method.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.FlowLogsBucket.grantReadWrite.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.FlowLogsBucket.grantReadWrite.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `grantWrite` <a name="grantWrite" id="cdk-extensions.s3_buckets.FlowLogsBucket.grantWrite"></a>

```typescript
public grantWrite(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grant write permissions to this bucket to an IAM principal.

If encryption is used, permission to use the key to encrypt the contents
of written files will also be granted to the same principal.

Before CDK version 1.85.0, this method granted the `s3:PutObject*` permission that included `s3:PutObjectAcl`,
which could be used to grant read/write object access to IAM principals in other accounts.
If you want to get rid of that behavior, update your CDK version to 1.85.0 or later,
and make sure the `@aws-cdk/aws-s3:grantWriteWithoutAcl` feature flag is set to `true`
in the `context` key of your cdk.json file.
If you've already updated, but still need the principal to have permissions to modify the ACLs,
use the {@link grantPutAcl} method.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.FlowLogsBucket.grantWrite.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.FlowLogsBucket.grantWrite.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `onCloudTrailEvent` <a name="onCloudTrailEvent" id="cdk-extensions.s3_buckets.FlowLogsBucket.onCloudTrailEvent"></a>

```typescript
public onCloudTrailEvent(_id: string, _options?: OnCloudTrailBucketEventOptions): Rule
```

Defines a CloudWatch event that triggers when something happens to this bucket.

Requires that there exists at least one CloudTrail Trail in your account
that captures the event. This method will not create the Trail.

###### `_id`<sup>Required</sup> <a name="_id" id="cdk-extensions.s3_buckets.FlowLogsBucket.onCloudTrailEvent.parameter._id"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.FlowLogsBucket.onCloudTrailEvent.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.OnCloudTrailBucketEventOptions

---

##### `onCloudTrailPutObject` <a name="onCloudTrailPutObject" id="cdk-extensions.s3_buckets.FlowLogsBucket.onCloudTrailPutObject"></a>

```typescript
public onCloudTrailPutObject(_id: string, _options?: OnCloudTrailBucketEventOptions): Rule
```

Defines an AWS CloudWatch event that triggers when an object is uploaded to the specified paths (keys) in this bucket using the PutObject API call.

Note that some tools like `aws s3 cp` will automatically use either
PutObject or the multipart upload API depending on the file size,
so using `onCloudTrailWriteObject` may be preferable.

Requires that there exists at least one CloudTrail Trail in your account
that captures the event. This method will not create the Trail.

###### `_id`<sup>Required</sup> <a name="_id" id="cdk-extensions.s3_buckets.FlowLogsBucket.onCloudTrailPutObject.parameter._id"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.FlowLogsBucket.onCloudTrailPutObject.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.OnCloudTrailBucketEventOptions

---

##### `onCloudTrailWriteObject` <a name="onCloudTrailWriteObject" id="cdk-extensions.s3_buckets.FlowLogsBucket.onCloudTrailWriteObject"></a>

```typescript
public onCloudTrailWriteObject(_id: string, _options?: OnCloudTrailBucketEventOptions): Rule
```

Defines an AWS CloudWatch event that triggers when an object at the specified paths (keys) in this bucket are written to.

This includes
the events PutObject, CopyObject, and CompleteMultipartUpload.

Note that some tools like `aws s3 cp` will automatically use either
PutObject or the multipart upload API depending on the file size,
so using this method may be preferable to `onCloudTrailPutObject`.

Requires that there exists at least one CloudTrail Trail in your account
that captures the event. This method will not create the Trail.

###### `_id`<sup>Required</sup> <a name="_id" id="cdk-extensions.s3_buckets.FlowLogsBucket.onCloudTrailWriteObject.parameter._id"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.FlowLogsBucket.onCloudTrailWriteObject.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.OnCloudTrailBucketEventOptions

---

##### `s3UrlForObject` <a name="s3UrlForObject" id="cdk-extensions.s3_buckets.FlowLogsBucket.s3UrlForObject"></a>

```typescript
public s3UrlForObject(_key?: string): string
```

The S3 URL of an S3 object.

For example:
- `s3://onlybucket`
- `s3://bucket/key`

###### `_key`<sup>Optional</sup> <a name="_key" id="cdk-extensions.s3_buckets.FlowLogsBucket.s3UrlForObject.parameter._key"></a>

- *Type:* string

---

##### `transferAccelerationUrlForObject` <a name="transferAccelerationUrlForObject" id="cdk-extensions.s3_buckets.FlowLogsBucket.transferAccelerationUrlForObject"></a>

```typescript
public transferAccelerationUrlForObject(_key?: string, _options?: TransferAccelerationUrlOptions): string
```

The https Transfer Acceleration URL of an S3 object.

Specify `dualStack: true` at the options
for dual-stack endpoint (connect to the bucket over IPv6). For example:

- `https://bucket.s3-accelerate.amazonaws.com`
- `https://bucket.s3-accelerate.amazonaws.com/key`

###### `_key`<sup>Optional</sup> <a name="_key" id="cdk-extensions.s3_buckets.FlowLogsBucket.transferAccelerationUrlForObject.parameter._key"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.FlowLogsBucket.transferAccelerationUrlForObject.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.TransferAccelerationUrlOptions

---

##### `urlForObject` <a name="urlForObject" id="cdk-extensions.s3_buckets.FlowLogsBucket.urlForObject"></a>

```typescript
public urlForObject(_key?: string): string
```

The https URL of an S3 object. For example:.

`https://s3.us-west-1.amazonaws.com/onlybucket`
- `https://s3.us-west-1.amazonaws.com/bucket/key`
- `https://s3.cn-north-1.amazonaws.com.cn/china-bucket/mykey`

###### `_key`<sup>Optional</sup> <a name="_key" id="cdk-extensions.s3_buckets.FlowLogsBucket.urlForObject.parameter._key"></a>

- *Type:* string

---

##### `virtualHostedUrlForObject` <a name="virtualHostedUrlForObject" id="cdk-extensions.s3_buckets.FlowLogsBucket.virtualHostedUrlForObject"></a>

```typescript
public virtualHostedUrlForObject(_key?: string, _options?: VirtualHostedStyleUrlOptions): string
```

The virtual hosted-style URL of an S3 object. Specify `regional: false` at the options for non-regional URL. For example:.

`https://only-bucket.s3.us-west-1.amazonaws.com`
- `https://bucket.s3.us-west-1.amazonaws.com/key`
- `https://bucket.s3.amazonaws.com/key`
- `https://china-bucket.s3.cn-north-1.amazonaws.com.cn/mykey`

###### `_key`<sup>Optional</sup> <a name="_key" id="cdk-extensions.s3_buckets.FlowLogsBucket.virtualHostedUrlForObject.parameter._key"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.FlowLogsBucket.virtualHostedUrlForObject.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.VirtualHostedStyleUrlOptions

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.isOwnedResource">isOwnedResource</a></code> | Returns true if the construct was created by CDK, and false otherwise. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.isResource">isResource</a></code> | Check whether the given construct is a Resource. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-extensions.s3_buckets.FlowLogsBucket.isConstruct"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

s3_buckets.FlowLogsBucket.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-extensions.s3_buckets.FlowLogsBucket.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isOwnedResource` <a name="isOwnedResource" id="cdk-extensions.s3_buckets.FlowLogsBucket.isOwnedResource"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

s3_buckets.FlowLogsBucket.isOwnedResource(construct: IConstruct)
```

Returns true if the construct was created by CDK, and false otherwise.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.s3_buckets.FlowLogsBucket.isOwnedResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `isResource` <a name="isResource" id="cdk-extensions.s3_buckets.FlowLogsBucket.isResource"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

s3_buckets.FlowLogsBucket.isResource(construct: IConstruct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.s3_buckets.FlowLogsBucket.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.property.env">env</a></code> | <code>aws-cdk-lib.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.property.stack">stack</a></code> | <code>aws-cdk-lib.Stack</code> | The stack in which this resource is defined. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.property.bucketArn">bucketArn</a></code> | <code>string</code> | The ARN of the bucket. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.property.bucketDomainName">bucketDomainName</a></code> | <code>string</code> | The IPv4 DNS name of the specified bucket. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.property.bucketDualStackDomainName">bucketDualStackDomainName</a></code> | <code>string</code> | The IPv6 DNS name of the specified bucket. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.property.bucketName">bucketName</a></code> | <code>string</code> | The name of the bucket. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.property.bucketRegionalDomainName">bucketRegionalDomainName</a></code> | <code>string</code> | The regional domain name of the specified bucket. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.property.bucketWebsiteDomainName">bucketWebsiteDomainName</a></code> | <code>string</code> | The Domain name of the static website. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.property.bucketWebsiteUrl">bucketWebsiteUrl</a></code> | <code>string</code> | The URL of the static website. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.property.resource">resource</a></code> | <code>aws-cdk-lib.aws_s3.CfnBucket</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.property.encryptionKey">encryptionKey</a></code> | <code>aws-cdk-lib.aws_kms.IKey</code> | Optional KMS encryption key associated with this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.property.isWebsite">isWebsite</a></code> | <code>boolean</code> | If this bucket has been configured for static website hosting. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.property.policy">policy</a></code> | <code>aws-cdk-lib.aws_s3.BucketPolicy</code> | The resource policy associated with this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.property.crawler">crawler</a></code> | <code>cdk-extensions.glue.Crawler</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.property.database">database</a></code> | <code>cdk-extensions.glue.Database</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.property.format">format</a></code> | <code>cdk-extensions.ec2.FlowLogFormat</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.property.table">table</a></code> | <code>cdk-extensions.glue_tables.FlowLogsTable</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.property.crawlerSchedule">crawlerSchedule</a></code> | <code>aws-cdk-lib.aws_events.Schedule</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.property.createQueries">createQueries</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucket.property.friendlyQueryNames">friendlyQueryNames</a></code> | <code>boolean</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-extensions.s3_buckets.FlowLogsBucket.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="cdk-extensions.s3_buckets.FlowLogsBucket.property.env"></a>

```typescript
public readonly env: ResourceEnvironment;
```

- *Type:* aws-cdk-lib.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="cdk-extensions.s3_buckets.FlowLogsBucket.property.stack"></a>

```typescript
public readonly stack: Stack;
```

- *Type:* aws-cdk-lib.Stack

The stack in which this resource is defined.

---

##### `bucketArn`<sup>Required</sup> <a name="bucketArn" id="cdk-extensions.s3_buckets.FlowLogsBucket.property.bucketArn"></a>

```typescript
public readonly bucketArn: string;
```

- *Type:* string

The ARN of the bucket.

---

##### `bucketDomainName`<sup>Required</sup> <a name="bucketDomainName" id="cdk-extensions.s3_buckets.FlowLogsBucket.property.bucketDomainName"></a>

```typescript
public readonly bucketDomainName: string;
```

- *Type:* string

The IPv4 DNS name of the specified bucket.

---

##### `bucketDualStackDomainName`<sup>Required</sup> <a name="bucketDualStackDomainName" id="cdk-extensions.s3_buckets.FlowLogsBucket.property.bucketDualStackDomainName"></a>

```typescript
public readonly bucketDualStackDomainName: string;
```

- *Type:* string

The IPv6 DNS name of the specified bucket.

---

##### `bucketName`<sup>Required</sup> <a name="bucketName" id="cdk-extensions.s3_buckets.FlowLogsBucket.property.bucketName"></a>

```typescript
public readonly bucketName: string;
```

- *Type:* string

The name of the bucket.

---

##### `bucketRegionalDomainName`<sup>Required</sup> <a name="bucketRegionalDomainName" id="cdk-extensions.s3_buckets.FlowLogsBucket.property.bucketRegionalDomainName"></a>

```typescript
public readonly bucketRegionalDomainName: string;
```

- *Type:* string

The regional domain name of the specified bucket.

---

##### `bucketWebsiteDomainName`<sup>Required</sup> <a name="bucketWebsiteDomainName" id="cdk-extensions.s3_buckets.FlowLogsBucket.property.bucketWebsiteDomainName"></a>

```typescript
public readonly bucketWebsiteDomainName: string;
```

- *Type:* string

The Domain name of the static website.

---

##### `bucketWebsiteUrl`<sup>Required</sup> <a name="bucketWebsiteUrl" id="cdk-extensions.s3_buckets.FlowLogsBucket.property.bucketWebsiteUrl"></a>

```typescript
public readonly bucketWebsiteUrl: string;
```

- *Type:* string

The URL of the static website.

---

##### `resource`<sup>Required</sup> <a name="resource" id="cdk-extensions.s3_buckets.FlowLogsBucket.property.resource"></a>

```typescript
public readonly resource: CfnBucket;
```

- *Type:* aws-cdk-lib.aws_s3.CfnBucket

---

##### `encryptionKey`<sup>Optional</sup> <a name="encryptionKey" id="cdk-extensions.s3_buckets.FlowLogsBucket.property.encryptionKey"></a>

```typescript
public readonly encryptionKey: IKey;
```

- *Type:* aws-cdk-lib.aws_kms.IKey

Optional KMS encryption key associated with this bucket.

---

##### `isWebsite`<sup>Optional</sup> <a name="isWebsite" id="cdk-extensions.s3_buckets.FlowLogsBucket.property.isWebsite"></a>

```typescript
public readonly isWebsite: boolean;
```

- *Type:* boolean

If this bucket has been configured for static website hosting.

---

##### `policy`<sup>Optional</sup> <a name="policy" id="cdk-extensions.s3_buckets.FlowLogsBucket.property.policy"></a>

```typescript
public readonly policy: BucketPolicy;
```

- *Type:* aws-cdk-lib.aws_s3.BucketPolicy

The resource policy associated with this bucket.

If `autoCreatePolicy` is true, a `BucketPolicy` will be created upon the
first call to addToResourcePolicy(s).

---

##### `crawler`<sup>Required</sup> <a name="crawler" id="cdk-extensions.s3_buckets.FlowLogsBucket.property.crawler"></a>

```typescript
public readonly crawler: Crawler;
```

- *Type:* cdk-extensions.glue.Crawler

---

##### `database`<sup>Required</sup> <a name="database" id="cdk-extensions.s3_buckets.FlowLogsBucket.property.database"></a>

```typescript
public readonly database: Database;
```

- *Type:* cdk-extensions.glue.Database

---

##### `format`<sup>Required</sup> <a name="format" id="cdk-extensions.s3_buckets.FlowLogsBucket.property.format"></a>

```typescript
public readonly format: FlowLogFormat;
```

- *Type:* cdk-extensions.ec2.FlowLogFormat

---

##### `table`<sup>Required</sup> <a name="table" id="cdk-extensions.s3_buckets.FlowLogsBucket.property.table"></a>

```typescript
public readonly table: FlowLogsTable;
```

- *Type:* cdk-extensions.glue_tables.FlowLogsTable

---

##### `crawlerSchedule`<sup>Optional</sup> <a name="crawlerSchedule" id="cdk-extensions.s3_buckets.FlowLogsBucket.property.crawlerSchedule"></a>

```typescript
public readonly crawlerSchedule: Schedule;
```

- *Type:* aws-cdk-lib.aws_events.Schedule

---

##### `createQueries`<sup>Optional</sup> <a name="createQueries" id="cdk-extensions.s3_buckets.FlowLogsBucket.property.createQueries"></a>

```typescript
public readonly createQueries: boolean;
```

- *Type:* boolean

---

##### `friendlyQueryNames`<sup>Optional</sup> <a name="friendlyQueryNames" id="cdk-extensions.s3_buckets.FlowLogsBucket.property.friendlyQueryNames"></a>

```typescript
public readonly friendlyQueryNames: boolean;
```

- *Type:* boolean

---


### FlowLogsTable <a name="FlowLogsTable" id="cdk-extensions.glue_tables.FlowLogsTable"></a>

#### Initializers <a name="Initializers" id="cdk-extensions.glue_tables.FlowLogsTable.Initializer"></a>

```typescript
import { glue_tables } from 'cdk-extensions'

new glue_tables.FlowLogsTable(scope: Construct, id: string, props: FlowLogsTableProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTable.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | A CDK Construct that will serve as this stack's parent in the construct tree. |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTable.Initializer.parameter.id">id</a></code> | <code>string</code> | A name to be associated with the stack and used in resource naming. |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTable.Initializer.parameter.props">props</a></code> | <code>cdk-extensions.glue_tables.FlowLogsTableProps</code> | Arguments related to the configuration of the resource. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.glue_tables.FlowLogsTable.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

A CDK Construct that will serve as this stack's parent in the construct tree.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.glue_tables.FlowLogsTable.Initializer.parameter.id"></a>

- *Type:* string

A name to be associated with the stack and used in resource naming.

Must be unique
within the context of 'scope'.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk-extensions.glue_tables.FlowLogsTable.Initializer.parameter.props"></a>

- *Type:* cdk-extensions.glue_tables.FlowLogsTableProps

Arguments related to the configuration of the resource.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTable.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTable.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTable.addColumn">addColumn</a></code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTable.addParameter">addParameter</a></code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTable.addPartitionKey">addPartitionKey</a></code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTable.addSerdeParameter">addSerdeParameter</a></code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTable.addStorageParameter">addStorageParameter</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="cdk-extensions.glue_tables.FlowLogsTable.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="cdk-extensions.glue_tables.FlowLogsTable.applyRemovalPolicy"></a>

```typescript
public applyRemovalPolicy(policy: RemovalPolicy): void
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="cdk-extensions.glue_tables.FlowLogsTable.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.RemovalPolicy

---

##### `addColumn` <a name="addColumn" id="cdk-extensions.glue_tables.FlowLogsTable.addColumn"></a>

```typescript
public addColumn(column: Column): void
```

###### `column`<sup>Required</sup> <a name="column" id="cdk-extensions.glue_tables.FlowLogsTable.addColumn.parameter.column"></a>

- *Type:* cdk-extensions.glue.Column

---

##### `addParameter` <a name="addParameter" id="cdk-extensions.glue_tables.FlowLogsTable.addParameter"></a>

```typescript
public addParameter(key: string, value: string): void
```

###### `key`<sup>Required</sup> <a name="key" id="cdk-extensions.glue_tables.FlowLogsTable.addParameter.parameter.key"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="cdk-extensions.glue_tables.FlowLogsTable.addParameter.parameter.value"></a>

- *Type:* string

---

##### `addPartitionKey` <a name="addPartitionKey" id="cdk-extensions.glue_tables.FlowLogsTable.addPartitionKey"></a>

```typescript
public addPartitionKey(column: Column): void
```

###### `column`<sup>Required</sup> <a name="column" id="cdk-extensions.glue_tables.FlowLogsTable.addPartitionKey.parameter.column"></a>

- *Type:* cdk-extensions.glue.Column

---

##### `addSerdeParameter` <a name="addSerdeParameter" id="cdk-extensions.glue_tables.FlowLogsTable.addSerdeParameter"></a>

```typescript
public addSerdeParameter(key: string, value: string): void
```

###### `key`<sup>Required</sup> <a name="key" id="cdk-extensions.glue_tables.FlowLogsTable.addSerdeParameter.parameter.key"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="cdk-extensions.glue_tables.FlowLogsTable.addSerdeParameter.parameter.value"></a>

- *Type:* string

---

##### `addStorageParameter` <a name="addStorageParameter" id="cdk-extensions.glue_tables.FlowLogsTable.addStorageParameter"></a>

```typescript
public addStorageParameter(key: string, value: string): void
```

###### `key`<sup>Required</sup> <a name="key" id="cdk-extensions.glue_tables.FlowLogsTable.addStorageParameter.parameter.key"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="cdk-extensions.glue_tables.FlowLogsTable.addStorageParameter.parameter.value"></a>

- *Type:* string

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTable.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTable.isOwnedResource">isOwnedResource</a></code> | Returns true if the construct was created by CDK, and false otherwise. |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTable.isResource">isResource</a></code> | Check whether the given construct is a Resource. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-extensions.glue_tables.FlowLogsTable.isConstruct"></a>

```typescript
import { glue_tables } from 'cdk-extensions'

glue_tables.FlowLogsTable.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-extensions.glue_tables.FlowLogsTable.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isOwnedResource` <a name="isOwnedResource" id="cdk-extensions.glue_tables.FlowLogsTable.isOwnedResource"></a>

```typescript
import { glue_tables } from 'cdk-extensions'

glue_tables.FlowLogsTable.isOwnedResource(construct: IConstruct)
```

Returns true if the construct was created by CDK, and false otherwise.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.glue_tables.FlowLogsTable.isOwnedResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `isResource` <a name="isResource" id="cdk-extensions.glue_tables.FlowLogsTable.isResource"></a>

```typescript
import { glue_tables } from 'cdk-extensions'

glue_tables.FlowLogsTable.isResource(construct: IConstruct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.glue_tables.FlowLogsTable.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTable.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTable.property.env">env</a></code> | <code>aws-cdk-lib.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTable.property.stack">stack</a></code> | <code>aws-cdk-lib.Stack</code> | The stack in which this resource is defined. |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTable.property.database">database</a></code> | <code>cdk-extensions.glue.Database</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTable.property.resource">resource</a></code> | <code>aws-cdk-lib.aws_glue.CfnTable</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTable.property.tableArn">tableArn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTable.property.tableName">tableName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTable.property.compressed">compressed</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTable.property.dataFormat">dataFormat</a></code> | <code>cdk-extensions.glue.DataFormat</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTable.property.description">description</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTable.property.location">location</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTable.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTable.property.owner">owner</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTable.property.retention">retention</a></code> | <code>aws-cdk-lib.Duration</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTable.property.serdeName">serdeName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTable.property.storedAsSubDirectories">storedAsSubDirectories</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTable.property.tableType">tableType</a></code> | <code>cdk-extensions.glue.TableType</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTable.property.targetTable">targetTable</a></code> | <code>cdk-extensions.glue.Table</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTable.property.viewExpandedText">viewExpandedText</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTable.property.viewOriginalText">viewOriginalText</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTable.property.createQueries">createQueries</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTable.property.format">format</a></code> | <code>cdk-extensions.ec2.FlowLogFormat</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTable.property.friendlyQueryNames">friendlyQueryNames</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTable.property.internalRejectedNamedQuery">internalRejectedNamedQuery</a></code> | <code>cdk-extensions.athena.NamedQuery</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-extensions.glue_tables.FlowLogsTable.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="cdk-extensions.glue_tables.FlowLogsTable.property.env"></a>

```typescript
public readonly env: ResourceEnvironment;
```

- *Type:* aws-cdk-lib.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="cdk-extensions.glue_tables.FlowLogsTable.property.stack"></a>

```typescript
public readonly stack: Stack;
```

- *Type:* aws-cdk-lib.Stack

The stack in which this resource is defined.

---

##### `database`<sup>Required</sup> <a name="database" id="cdk-extensions.glue_tables.FlowLogsTable.property.database"></a>

```typescript
public readonly database: Database;
```

- *Type:* cdk-extensions.glue.Database

---

##### `resource`<sup>Required</sup> <a name="resource" id="cdk-extensions.glue_tables.FlowLogsTable.property.resource"></a>

```typescript
public readonly resource: CfnTable;
```

- *Type:* aws-cdk-lib.aws_glue.CfnTable

---

##### `tableArn`<sup>Required</sup> <a name="tableArn" id="cdk-extensions.glue_tables.FlowLogsTable.property.tableArn"></a>

```typescript
public readonly tableArn: string;
```

- *Type:* string

---

##### `tableName`<sup>Required</sup> <a name="tableName" id="cdk-extensions.glue_tables.FlowLogsTable.property.tableName"></a>

```typescript
public readonly tableName: string;
```

- *Type:* string

---

##### `compressed`<sup>Optional</sup> <a name="compressed" id="cdk-extensions.glue_tables.FlowLogsTable.property.compressed"></a>

```typescript
public readonly compressed: boolean;
```

- *Type:* boolean

---

##### `dataFormat`<sup>Optional</sup> <a name="dataFormat" id="cdk-extensions.glue_tables.FlowLogsTable.property.dataFormat"></a>

```typescript
public readonly dataFormat: DataFormat;
```

- *Type:* cdk-extensions.glue.DataFormat

---

##### `description`<sup>Optional</sup> <a name="description" id="cdk-extensions.glue_tables.FlowLogsTable.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

---

##### `location`<sup>Optional</sup> <a name="location" id="cdk-extensions.glue_tables.FlowLogsTable.property.location"></a>

```typescript
public readonly location: string;
```

- *Type:* string

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.glue_tables.FlowLogsTable.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `owner`<sup>Optional</sup> <a name="owner" id="cdk-extensions.glue_tables.FlowLogsTable.property.owner"></a>

```typescript
public readonly owner: string;
```

- *Type:* string

---

##### `retention`<sup>Optional</sup> <a name="retention" id="cdk-extensions.glue_tables.FlowLogsTable.property.retention"></a>

```typescript
public readonly retention: Duration;
```

- *Type:* aws-cdk-lib.Duration

---

##### `serdeName`<sup>Optional</sup> <a name="serdeName" id="cdk-extensions.glue_tables.FlowLogsTable.property.serdeName"></a>

```typescript
public readonly serdeName: string;
```

- *Type:* string

---

##### `storedAsSubDirectories`<sup>Optional</sup> <a name="storedAsSubDirectories" id="cdk-extensions.glue_tables.FlowLogsTable.property.storedAsSubDirectories"></a>

```typescript
public readonly storedAsSubDirectories: boolean;
```

- *Type:* boolean

---

##### `tableType`<sup>Optional</sup> <a name="tableType" id="cdk-extensions.glue_tables.FlowLogsTable.property.tableType"></a>

```typescript
public readonly tableType: TableType;
```

- *Type:* cdk-extensions.glue.TableType

---

##### `targetTable`<sup>Optional</sup> <a name="targetTable" id="cdk-extensions.glue_tables.FlowLogsTable.property.targetTable"></a>

```typescript
public readonly targetTable: Table;
```

- *Type:* cdk-extensions.glue.Table

---

##### `viewExpandedText`<sup>Optional</sup> <a name="viewExpandedText" id="cdk-extensions.glue_tables.FlowLogsTable.property.viewExpandedText"></a>

```typescript
public readonly viewExpandedText: string;
```

- *Type:* string

---

##### `viewOriginalText`<sup>Optional</sup> <a name="viewOriginalText" id="cdk-extensions.glue_tables.FlowLogsTable.property.viewOriginalText"></a>

```typescript
public readonly viewOriginalText: string;
```

- *Type:* string

---

##### `createQueries`<sup>Required</sup> <a name="createQueries" id="cdk-extensions.glue_tables.FlowLogsTable.property.createQueries"></a>

```typescript
public readonly createQueries: boolean;
```

- *Type:* boolean

---

##### `format`<sup>Required</sup> <a name="format" id="cdk-extensions.glue_tables.FlowLogsTable.property.format"></a>

```typescript
public readonly format: FlowLogFormat;
```

- *Type:* cdk-extensions.ec2.FlowLogFormat

---

##### `friendlyQueryNames`<sup>Required</sup> <a name="friendlyQueryNames" id="cdk-extensions.glue_tables.FlowLogsTable.property.friendlyQueryNames"></a>

```typescript
public readonly friendlyQueryNames: boolean;
```

- *Type:* boolean

---

##### `internalRejectedNamedQuery`<sup>Optional</sup> <a name="internalRejectedNamedQuery" id="cdk-extensions.glue_tables.FlowLogsTable.property.internalRejectedNamedQuery"></a>

```typescript
public readonly internalRejectedNamedQuery: NamedQuery;
```

- *Type:* cdk-extensions.athena.NamedQuery

---


### GroupBase <a name="GroupBase" id="cdk-extensions.sso.GroupBase"></a>

- *Implements:* cdk-extensions.sso.IGroup, cdk-extensions.sso.IIdentityCenterPrincipal

#### Initializers <a name="Initializers" id="cdk-extensions.sso.GroupBase.Initializer"></a>

```typescript
import { sso } from 'cdk-extensions'

new sso.GroupBase(scope: IConstruct, id: string, props?: ResourceProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.sso.GroupBase.Initializer.parameter.scope">scope</a></code> | <code>constructs.IConstruct</code> | *No description.* |
| <code><a href="#cdk-extensions.sso.GroupBase.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.sso.GroupBase.Initializer.parameter.props">props</a></code> | <code>aws-cdk-lib.ResourceProps</code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.sso.GroupBase.Initializer.parameter.scope"></a>

- *Type:* constructs.IConstruct

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.sso.GroupBase.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk-extensions.sso.GroupBase.Initializer.parameter.props"></a>

- *Type:* aws-cdk-lib.ResourceProps

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.sso.GroupBase.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-extensions.sso.GroupBase.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |

---

##### `toString` <a name="toString" id="cdk-extensions.sso.GroupBase.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="cdk-extensions.sso.GroupBase.applyRemovalPolicy"></a>

```typescript
public applyRemovalPolicy(policy: RemovalPolicy): void
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="cdk-extensions.sso.GroupBase.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.RemovalPolicy

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.sso.GroupBase.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-extensions.sso.GroupBase.isOwnedResource">isOwnedResource</a></code> | Returns true if the construct was created by CDK, and false otherwise. |
| <code><a href="#cdk-extensions.sso.GroupBase.isResource">isResource</a></code> | Check whether the given construct is a Resource. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-extensions.sso.GroupBase.isConstruct"></a>

```typescript
import { sso } from 'cdk-extensions'

sso.GroupBase.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-extensions.sso.GroupBase.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isOwnedResource` <a name="isOwnedResource" id="cdk-extensions.sso.GroupBase.isOwnedResource"></a>

```typescript
import { sso } from 'cdk-extensions'

sso.GroupBase.isOwnedResource(construct: IConstruct)
```

Returns true if the construct was created by CDK, and false otherwise.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.sso.GroupBase.isOwnedResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `isResource` <a name="isResource" id="cdk-extensions.sso.GroupBase.isResource"></a>

```typescript
import { sso } from 'cdk-extensions'

sso.GroupBase.isResource(construct: IConstruct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.sso.GroupBase.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.sso.GroupBase.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-extensions.sso.GroupBase.property.env">env</a></code> | <code>aws-cdk-lib.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#cdk-extensions.sso.GroupBase.property.stack">stack</a></code> | <code>aws-cdk-lib.Stack</code> | The stack in which this resource is defined. |
| <code><a href="#cdk-extensions.sso.GroupBase.property.groupId">groupId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.sso.GroupBase.property.principalId">principalId</a></code> | <code>string</code> | The unique ID that identifies the entity withing IAM Identity Center. |
| <code><a href="#cdk-extensions.sso.GroupBase.property.principalType">principalType</a></code> | <code>cdk-extensions.sso.IdentityCenterPrincipalType</code> | The type of entity being represented. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-extensions.sso.GroupBase.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="cdk-extensions.sso.GroupBase.property.env"></a>

```typescript
public readonly env: ResourceEnvironment;
```

- *Type:* aws-cdk-lib.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="cdk-extensions.sso.GroupBase.property.stack"></a>

```typescript
public readonly stack: Stack;
```

- *Type:* aws-cdk-lib.Stack

The stack in which this resource is defined.

---

##### `groupId`<sup>Required</sup> <a name="groupId" id="cdk-extensions.sso.GroupBase.property.groupId"></a>

```typescript
public readonly groupId: string;
```

- *Type:* string

---

##### `principalId`<sup>Required</sup> <a name="principalId" id="cdk-extensions.sso.GroupBase.property.principalId"></a>

```typescript
public readonly principalId: string;
```

- *Type:* string

The unique ID that identifies the entity withing IAM Identity Center.

---

##### `principalType`<sup>Required</sup> <a name="principalType" id="cdk-extensions.sso.GroupBase.property.principalType"></a>

```typescript
public readonly principalType: IdentityCenterPrincipalType;
```

- *Type:* cdk-extensions.sso.IdentityCenterPrincipalType

The type of entity being represented.

---


### InstanceAccessControlAttributeConfiguration <a name="InstanceAccessControlAttributeConfiguration" id="cdk-extensions.sso.InstanceAccessControlAttributeConfiguration"></a>

Enables the attribute-based access control (ABAC) feature for the specified IAM Identity Center instance.

You can also specify new attributes to add to
your ABAC configuration during the enabling process. For more information
about ABAC, see [Attribute-Based Access Control](https://docs.aws.amazon.com/singlesignon/latest/userguide/abac.html) in the IAM Identity Center
User Guide.

#### Initializers <a name="Initializers" id="cdk-extensions.sso.InstanceAccessControlAttributeConfiguration.Initializer"></a>

```typescript
import { sso } from 'cdk-extensions'

new sso.InstanceAccessControlAttributeConfiguration(scope: Construct, id: string, props: InstanceAccessControlAttributeConfigurationProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.sso.InstanceAccessControlAttributeConfiguration.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | A CDK Construct that will serve as this stack's parent in the construct tree. |
| <code><a href="#cdk-extensions.sso.InstanceAccessControlAttributeConfiguration.Initializer.parameter.id">id</a></code> | <code>string</code> | A name to be associated with the stack and used in resource naming. |
| <code><a href="#cdk-extensions.sso.InstanceAccessControlAttributeConfiguration.Initializer.parameter.props">props</a></code> | <code>cdk-extensions.sso.InstanceAccessControlAttributeConfigurationProps</code> | Arguments related to the configuration of the resource. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.sso.InstanceAccessControlAttributeConfiguration.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

A CDK Construct that will serve as this stack's parent in the construct tree.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.sso.InstanceAccessControlAttributeConfiguration.Initializer.parameter.id"></a>

- *Type:* string

A name to be associated with the stack and used in resource naming.

Must be unique
within the context of 'scope'.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk-extensions.sso.InstanceAccessControlAttributeConfiguration.Initializer.parameter.props"></a>

- *Type:* cdk-extensions.sso.InstanceAccessControlAttributeConfigurationProps

Arguments related to the configuration of the resource.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.sso.InstanceAccessControlAttributeConfiguration.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-extensions.sso.InstanceAccessControlAttributeConfiguration.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |
| <code><a href="#cdk-extensions.sso.InstanceAccessControlAttributeConfiguration.addAttribute">addAttribute</a></code> | Adds a new ABAC attribute in the specified IAM Identity Center instance. |

---

##### `toString` <a name="toString" id="cdk-extensions.sso.InstanceAccessControlAttributeConfiguration.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="cdk-extensions.sso.InstanceAccessControlAttributeConfiguration.applyRemovalPolicy"></a>

```typescript
public applyRemovalPolicy(policy: RemovalPolicy): void
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="cdk-extensions.sso.InstanceAccessControlAttributeConfiguration.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.RemovalPolicy

---

##### `addAttribute` <a name="addAttribute" id="cdk-extensions.sso.InstanceAccessControlAttributeConfiguration.addAttribute"></a>

```typescript
public addAttribute(key: string, sources: string): AccessControlAttribute
```

Adds a new ABAC attribute in the specified IAM Identity Center instance.

###### `key`<sup>Required</sup> <a name="key" id="cdk-extensions.sso.InstanceAccessControlAttributeConfiguration.addAttribute.parameter.key"></a>

- *Type:* string

The name of the attribute associated with your identities in your identity source.

This is used to map a specified attribute in your
identity source with an attribute in IAM Identity Center.

---

###### `sources`<sup>Required</sup> <a name="sources" id="cdk-extensions.sso.InstanceAccessControlAttributeConfiguration.addAttribute.parameter.sources"></a>

- *Type:* string

The identity sources to use when mapping a specified attribute to IAM Identity Center.

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.sso.InstanceAccessControlAttributeConfiguration.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-extensions.sso.InstanceAccessControlAttributeConfiguration.isOwnedResource">isOwnedResource</a></code> | Returns true if the construct was created by CDK, and false otherwise. |
| <code><a href="#cdk-extensions.sso.InstanceAccessControlAttributeConfiguration.isResource">isResource</a></code> | Check whether the given construct is a Resource. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-extensions.sso.InstanceAccessControlAttributeConfiguration.isConstruct"></a>

```typescript
import { sso } from 'cdk-extensions'

sso.InstanceAccessControlAttributeConfiguration.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-extensions.sso.InstanceAccessControlAttributeConfiguration.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isOwnedResource` <a name="isOwnedResource" id="cdk-extensions.sso.InstanceAccessControlAttributeConfiguration.isOwnedResource"></a>

```typescript
import { sso } from 'cdk-extensions'

sso.InstanceAccessControlAttributeConfiguration.isOwnedResource(construct: IConstruct)
```

Returns true if the construct was created by CDK, and false otherwise.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.sso.InstanceAccessControlAttributeConfiguration.isOwnedResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `isResource` <a name="isResource" id="cdk-extensions.sso.InstanceAccessControlAttributeConfiguration.isResource"></a>

```typescript
import { sso } from 'cdk-extensions'

sso.InstanceAccessControlAttributeConfiguration.isResource(construct: IConstruct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.sso.InstanceAccessControlAttributeConfiguration.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.sso.InstanceAccessControlAttributeConfiguration.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-extensions.sso.InstanceAccessControlAttributeConfiguration.property.env">env</a></code> | <code>aws-cdk-lib.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#cdk-extensions.sso.InstanceAccessControlAttributeConfiguration.property.stack">stack</a></code> | <code>aws-cdk-lib.Stack</code> | The stack in which this resource is defined. |
| <code><a href="#cdk-extensions.sso.InstanceAccessControlAttributeConfiguration.property.attributes">attributes</a></code> | <code>cdk-extensions.sso.AccessControlAttribute[]</code> | Lists the attributes that are configured for ABAC in the specified IAM Identity Center instance. |
| <code><a href="#cdk-extensions.sso.InstanceAccessControlAttributeConfiguration.property.instance">instance</a></code> | <code>cdk-extensions.sso.IInstance</code> | The ARN of the IAM Identity Center instance under which the operation will be executed. |
| <code><a href="#cdk-extensions.sso.InstanceAccessControlAttributeConfiguration.property.resource">resource</a></code> | <code>aws-cdk-lib.aws_sso.CfnInstanceAccessControlAttributeConfiguration</code> | The underlying InstanceAccessControlAttributeConfiguration CloudFormation resource. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-extensions.sso.InstanceAccessControlAttributeConfiguration.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="cdk-extensions.sso.InstanceAccessControlAttributeConfiguration.property.env"></a>

```typescript
public readonly env: ResourceEnvironment;
```

- *Type:* aws-cdk-lib.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="cdk-extensions.sso.InstanceAccessControlAttributeConfiguration.property.stack"></a>

```typescript
public readonly stack: Stack;
```

- *Type:* aws-cdk-lib.Stack

The stack in which this resource is defined.

---

##### `attributes`<sup>Required</sup> <a name="attributes" id="cdk-extensions.sso.InstanceAccessControlAttributeConfiguration.property.attributes"></a>

```typescript
public readonly attributes: AccessControlAttribute[];
```

- *Type:* cdk-extensions.sso.AccessControlAttribute[]

Lists the attributes that are configured for ABAC in the specified IAM Identity Center instance.

This array is readonly. Changes made to the
array will not be reflected in this resource. To add new attributes use
the `{@link addAttribute}` method.

---

##### `instance`<sup>Required</sup> <a name="instance" id="cdk-extensions.sso.InstanceAccessControlAttributeConfiguration.property.instance"></a>

```typescript
public readonly instance: IInstance;
```

- *Type:* cdk-extensions.sso.IInstance

The ARN of the IAM Identity Center instance under which the operation will be executed.

---

##### `resource`<sup>Required</sup> <a name="resource" id="cdk-extensions.sso.InstanceAccessControlAttributeConfiguration.property.resource"></a>

```typescript
public readonly resource: CfnInstanceAccessControlAttributeConfiguration;
```

- *Type:* aws-cdk-lib.aws_sso.CfnInstanceAccessControlAttributeConfiguration

The underlying InstanceAccessControlAttributeConfiguration CloudFormation resource.

---


### InstanceBase <a name="InstanceBase" id="cdk-extensions.sso.InstanceBase"></a>

- *Implements:* cdk-extensions.sso.IInstance

#### Initializers <a name="Initializers" id="cdk-extensions.sso.InstanceBase.Initializer"></a>

```typescript
import { sso } from 'cdk-extensions'

new sso.InstanceBase(scope: Construct, id: string, props?: ResourceProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.sso.InstanceBase.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#cdk-extensions.sso.InstanceBase.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.sso.InstanceBase.Initializer.parameter.props">props</a></code> | <code>aws-cdk-lib.ResourceProps</code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.sso.InstanceBase.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.sso.InstanceBase.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk-extensions.sso.InstanceBase.Initializer.parameter.props"></a>

- *Type:* aws-cdk-lib.ResourceProps

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.sso.InstanceBase.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-extensions.sso.InstanceBase.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |

---

##### `toString` <a name="toString" id="cdk-extensions.sso.InstanceBase.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="cdk-extensions.sso.InstanceBase.applyRemovalPolicy"></a>

```typescript
public applyRemovalPolicy(policy: RemovalPolicy): void
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="cdk-extensions.sso.InstanceBase.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.RemovalPolicy

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.sso.InstanceBase.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-extensions.sso.InstanceBase.isOwnedResource">isOwnedResource</a></code> | Returns true if the construct was created by CDK, and false otherwise. |
| <code><a href="#cdk-extensions.sso.InstanceBase.isResource">isResource</a></code> | Check whether the given construct is a Resource. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-extensions.sso.InstanceBase.isConstruct"></a>

```typescript
import { sso } from 'cdk-extensions'

sso.InstanceBase.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-extensions.sso.InstanceBase.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isOwnedResource` <a name="isOwnedResource" id="cdk-extensions.sso.InstanceBase.isOwnedResource"></a>

```typescript
import { sso } from 'cdk-extensions'

sso.InstanceBase.isOwnedResource(construct: IConstruct)
```

Returns true if the construct was created by CDK, and false otherwise.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.sso.InstanceBase.isOwnedResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `isResource` <a name="isResource" id="cdk-extensions.sso.InstanceBase.isResource"></a>

```typescript
import { sso } from 'cdk-extensions'

sso.InstanceBase.isResource(construct: IConstruct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.sso.InstanceBase.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.sso.InstanceBase.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-extensions.sso.InstanceBase.property.env">env</a></code> | <code>aws-cdk-lib.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#cdk-extensions.sso.InstanceBase.property.stack">stack</a></code> | <code>aws-cdk-lib.Stack</code> | The stack in which this resource is defined. |
| <code><a href="#cdk-extensions.sso.InstanceBase.property.instanceArn">instanceArn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.sso.InstanceBase.property.instanceId">instanceId</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-extensions.sso.InstanceBase.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="cdk-extensions.sso.InstanceBase.property.env"></a>

```typescript
public readonly env: ResourceEnvironment;
```

- *Type:* aws-cdk-lib.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="cdk-extensions.sso.InstanceBase.property.stack"></a>

```typescript
public readonly stack: Stack;
```

- *Type:* aws-cdk-lib.Stack

The stack in which this resource is defined.

---

##### `instanceArn`<sup>Required</sup> <a name="instanceArn" id="cdk-extensions.sso.InstanceBase.property.instanceArn"></a>

```typescript
public readonly instanceArn: string;
```

- *Type:* string

---

##### `instanceId`<sup>Required</sup> <a name="instanceId" id="cdk-extensions.sso.InstanceBase.property.instanceId"></a>

```typescript
public readonly instanceId: string;
```

- *Type:* string

---


### Job <a name="Job" id="cdk-extensions.glue.Job"></a>

#### Initializers <a name="Initializers" id="cdk-extensions.glue.Job.Initializer"></a>

```typescript
import { glue } from 'cdk-extensions'

new glue.Job(scope: Construct, id: string, props: JobProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.Job.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Job.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Job.Initializer.parameter.props">props</a></code> | <code>cdk-extensions.glue.JobProps</code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.glue.Job.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.glue.Job.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="cdk-extensions.glue.Job.Initializer.parameter.props"></a>

- *Type:* cdk-extensions.glue.JobProps

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.glue.Job.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-extensions.glue.Job.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |
| <code><a href="#cdk-extensions.glue.Job.addArgument">addArgument</a></code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Job.addConnection">addConnection</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="cdk-extensions.glue.Job.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="cdk-extensions.glue.Job.applyRemovalPolicy"></a>

```typescript
public applyRemovalPolicy(policy: RemovalPolicy): void
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="cdk-extensions.glue.Job.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.RemovalPolicy

---

##### `addArgument` <a name="addArgument" id="cdk-extensions.glue.Job.addArgument"></a>

```typescript
public addArgument(key: string, value: string): void
```

###### `key`<sup>Required</sup> <a name="key" id="cdk-extensions.glue.Job.addArgument.parameter.key"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="cdk-extensions.glue.Job.addArgument.parameter.value"></a>

- *Type:* string

---

##### `addConnection` <a name="addConnection" id="cdk-extensions.glue.Job.addConnection"></a>

```typescript
public addConnection(connection: Connection): void
```

###### `connection`<sup>Required</sup> <a name="connection" id="cdk-extensions.glue.Job.addConnection.parameter.connection"></a>

- *Type:* cdk-extensions.glue.Connection

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.glue.Job.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-extensions.glue.Job.isOwnedResource">isOwnedResource</a></code> | Returns true if the construct was created by CDK, and false otherwise. |
| <code><a href="#cdk-extensions.glue.Job.isResource">isResource</a></code> | Check whether the given construct is a Resource. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-extensions.glue.Job.isConstruct"></a>

```typescript
import { glue } from 'cdk-extensions'

glue.Job.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-extensions.glue.Job.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isOwnedResource` <a name="isOwnedResource" id="cdk-extensions.glue.Job.isOwnedResource"></a>

```typescript
import { glue } from 'cdk-extensions'

glue.Job.isOwnedResource(construct: IConstruct)
```

Returns true if the construct was created by CDK, and false otherwise.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.glue.Job.isOwnedResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `isResource` <a name="isResource" id="cdk-extensions.glue.Job.isResource"></a>

```typescript
import { glue } from 'cdk-extensions'

glue.Job.isResource(construct: IConstruct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.glue.Job.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.Job.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-extensions.glue.Job.property.env">env</a></code> | <code>aws-cdk-lib.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#cdk-extensions.glue.Job.property.stack">stack</a></code> | <code>aws-cdk-lib.Stack</code> | The stack in which this resource is defined. |
| <code><a href="#cdk-extensions.glue.Job.property.executable">executable</a></code> | <code>cdk-extensions.glue.JobExecutable</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Job.property.jobArn">jobArn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Job.property.jobName">jobName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Job.property.resource">resource</a></code> | <code>aws-cdk-lib.aws_glue.CfnJob</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Job.property.role">role</a></code> | <code>aws-cdk-lib.aws_iam.IRole</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Job.property.allocatedCapacity">allocatedCapacity</a></code> | <code>number</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Job.property.connections">connections</a></code> | <code>cdk-extensions.glue.Connection[]</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Job.property.continuousLogging">continuousLogging</a></code> | <code>cdk-extensions.glue.ContinuousLoggingProps</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Job.property.description">description</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Job.property.logGroup">logGroup</a></code> | <code>aws-cdk-lib.aws_logs.ILogGroup</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Job.property.maxCapacity">maxCapacity</a></code> | <code>number</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Job.property.maxConcurrentRuns">maxConcurrentRuns</a></code> | <code>number</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Job.property.maxRetries">maxRetries</a></code> | <code>number</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Job.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Job.property.notifyDelayAfter">notifyDelayAfter</a></code> | <code>aws-cdk-lib.Duration</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Job.property.securityConfiguration">securityConfiguration</a></code> | <code>cdk-extensions.glue.SecurityConfiguration</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Job.property.timeout">timeout</a></code> | <code>aws-cdk-lib.Duration</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Job.property.workerCount">workerCount</a></code> | <code>number</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Job.property.workerType">workerType</a></code> | <code>cdk-extensions.glue.WorkerType</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-extensions.glue.Job.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="cdk-extensions.glue.Job.property.env"></a>

```typescript
public readonly env: ResourceEnvironment;
```

- *Type:* aws-cdk-lib.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="cdk-extensions.glue.Job.property.stack"></a>

```typescript
public readonly stack: Stack;
```

- *Type:* aws-cdk-lib.Stack

The stack in which this resource is defined.

---

##### `executable`<sup>Required</sup> <a name="executable" id="cdk-extensions.glue.Job.property.executable"></a>

```typescript
public readonly executable: JobExecutable;
```

- *Type:* cdk-extensions.glue.JobExecutable

---

##### `jobArn`<sup>Required</sup> <a name="jobArn" id="cdk-extensions.glue.Job.property.jobArn"></a>

```typescript
public readonly jobArn: string;
```

- *Type:* string

---

##### `jobName`<sup>Required</sup> <a name="jobName" id="cdk-extensions.glue.Job.property.jobName"></a>

```typescript
public readonly jobName: string;
```

- *Type:* string

---

##### `resource`<sup>Required</sup> <a name="resource" id="cdk-extensions.glue.Job.property.resource"></a>

```typescript
public readonly resource: CfnJob;
```

- *Type:* aws-cdk-lib.aws_glue.CfnJob

---

##### `role`<sup>Required</sup> <a name="role" id="cdk-extensions.glue.Job.property.role"></a>

```typescript
public readonly role: IRole;
```

- *Type:* aws-cdk-lib.aws_iam.IRole

---

##### `allocatedCapacity`<sup>Optional</sup> <a name="allocatedCapacity" id="cdk-extensions.glue.Job.property.allocatedCapacity"></a>

```typescript
public readonly allocatedCapacity: number;
```

- *Type:* number

---

##### `connections`<sup>Optional</sup> <a name="connections" id="cdk-extensions.glue.Job.property.connections"></a>

```typescript
public readonly connections: Connection[];
```

- *Type:* cdk-extensions.glue.Connection[]

---

##### `continuousLogging`<sup>Optional</sup> <a name="continuousLogging" id="cdk-extensions.glue.Job.property.continuousLogging"></a>

```typescript
public readonly continuousLogging: ContinuousLoggingProps;
```

- *Type:* cdk-extensions.glue.ContinuousLoggingProps

---

##### `description`<sup>Optional</sup> <a name="description" id="cdk-extensions.glue.Job.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

---

##### `logGroup`<sup>Optional</sup> <a name="logGroup" id="cdk-extensions.glue.Job.property.logGroup"></a>

```typescript
public readonly logGroup: ILogGroup;
```

- *Type:* aws-cdk-lib.aws_logs.ILogGroup

---

##### `maxCapacity`<sup>Optional</sup> <a name="maxCapacity" id="cdk-extensions.glue.Job.property.maxCapacity"></a>

```typescript
public readonly maxCapacity: number;
```

- *Type:* number

---

##### `maxConcurrentRuns`<sup>Optional</sup> <a name="maxConcurrentRuns" id="cdk-extensions.glue.Job.property.maxConcurrentRuns"></a>

```typescript
public readonly maxConcurrentRuns: number;
```

- *Type:* number

---

##### `maxRetries`<sup>Optional</sup> <a name="maxRetries" id="cdk-extensions.glue.Job.property.maxRetries"></a>

```typescript
public readonly maxRetries: number;
```

- *Type:* number

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.glue.Job.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `notifyDelayAfter`<sup>Optional</sup> <a name="notifyDelayAfter" id="cdk-extensions.glue.Job.property.notifyDelayAfter"></a>

```typescript
public readonly notifyDelayAfter: Duration;
```

- *Type:* aws-cdk-lib.Duration

---

##### `securityConfiguration`<sup>Optional</sup> <a name="securityConfiguration" id="cdk-extensions.glue.Job.property.securityConfiguration"></a>

```typescript
public readonly securityConfiguration: SecurityConfiguration;
```

- *Type:* cdk-extensions.glue.SecurityConfiguration

---

##### `timeout`<sup>Optional</sup> <a name="timeout" id="cdk-extensions.glue.Job.property.timeout"></a>

```typescript
public readonly timeout: Duration;
```

- *Type:* aws-cdk-lib.Duration

---

##### `workerCount`<sup>Optional</sup> <a name="workerCount" id="cdk-extensions.glue.Job.property.workerCount"></a>

```typescript
public readonly workerCount: number;
```

- *Type:* number

---

##### `workerType`<sup>Optional</sup> <a name="workerType" id="cdk-extensions.glue.Job.property.workerType"></a>

```typescript
public readonly workerType: WorkerType;
```

- *Type:* cdk-extensions.glue.WorkerType

---


### NamedQuery <a name="NamedQuery" id="cdk-extensions.athena.NamedQuery"></a>

#### Initializers <a name="Initializers" id="cdk-extensions.athena.NamedQuery.Initializer"></a>

```typescript
import { athena } from 'cdk-extensions'

new athena.NamedQuery(scope: Construct, id: string, props: NamedQueryProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.athena.NamedQuery.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | A CDK Construct that will serve as this stack's parent in the construct tree. |
| <code><a href="#cdk-extensions.athena.NamedQuery.Initializer.parameter.id">id</a></code> | <code>string</code> | A name to be associated with the stack and used in resource naming. |
| <code><a href="#cdk-extensions.athena.NamedQuery.Initializer.parameter.props">props</a></code> | <code>cdk-extensions.athena.NamedQueryProps</code> | Arguments related to the configuration of the resource. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.athena.NamedQuery.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

A CDK Construct that will serve as this stack's parent in the construct tree.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.athena.NamedQuery.Initializer.parameter.id"></a>

- *Type:* string

A name to be associated with the stack and used in resource naming.

Must be unique within the context of 'scope'.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk-extensions.athena.NamedQuery.Initializer.parameter.props"></a>

- *Type:* cdk-extensions.athena.NamedQueryProps

Arguments related to the configuration of the resource.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.athena.NamedQuery.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-extensions.athena.NamedQuery.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |

---

##### `toString` <a name="toString" id="cdk-extensions.athena.NamedQuery.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="cdk-extensions.athena.NamedQuery.applyRemovalPolicy"></a>

```typescript
public applyRemovalPolicy(policy: RemovalPolicy): void
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="cdk-extensions.athena.NamedQuery.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.RemovalPolicy

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.athena.NamedQuery.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-extensions.athena.NamedQuery.isOwnedResource">isOwnedResource</a></code> | Returns true if the construct was created by CDK, and false otherwise. |
| <code><a href="#cdk-extensions.athena.NamedQuery.isResource">isResource</a></code> | Check whether the given construct is a Resource. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-extensions.athena.NamedQuery.isConstruct"></a>

```typescript
import { athena } from 'cdk-extensions'

athena.NamedQuery.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-extensions.athena.NamedQuery.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isOwnedResource` <a name="isOwnedResource" id="cdk-extensions.athena.NamedQuery.isOwnedResource"></a>

```typescript
import { athena } from 'cdk-extensions'

athena.NamedQuery.isOwnedResource(construct: IConstruct)
```

Returns true if the construct was created by CDK, and false otherwise.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.athena.NamedQuery.isOwnedResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `isResource` <a name="isResource" id="cdk-extensions.athena.NamedQuery.isResource"></a>

```typescript
import { athena } from 'cdk-extensions'

athena.NamedQuery.isResource(construct: IConstruct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.athena.NamedQuery.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.athena.NamedQuery.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-extensions.athena.NamedQuery.property.env">env</a></code> | <code>aws-cdk-lib.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#cdk-extensions.athena.NamedQuery.property.stack">stack</a></code> | <code>aws-cdk-lib.Stack</code> | The stack in which this resource is defined. |
| <code><a href="#cdk-extensions.athena.NamedQuery.property.database">database</a></code> | <code>cdk-extensions.glue.Database</code> | The Glue database to which the query belongs. |
| <code><a href="#cdk-extensions.athena.NamedQuery.property.namedQueryId">namedQueryId</a></code> | <code>string</code> | The unique ID of the query. |
| <code><a href="#cdk-extensions.athena.NamedQuery.property.namedQueryName">namedQueryName</a></code> | <code>string</code> | The name of the query. |
| <code><a href="#cdk-extensions.athena.NamedQuery.property.queryString">queryString</a></code> | <code>string</code> | The SQL statements that make up the query. |
| <code><a href="#cdk-extensions.athena.NamedQuery.property.resource">resource</a></code> | <code>aws-cdk-lib.aws_athena.CfnNamedQuery</code> | The underlying NamedQuery CloudFormation resource. |
| <code><a href="#cdk-extensions.athena.NamedQuery.property.description">description</a></code> | <code>string</code> | A human friendly description explaining the functionality of the query. |
| <code><a href="#cdk-extensions.athena.NamedQuery.property.name">name</a></code> | <code>string</code> | The name of the query. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-extensions.athena.NamedQuery.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="cdk-extensions.athena.NamedQuery.property.env"></a>

```typescript
public readonly env: ResourceEnvironment;
```

- *Type:* aws-cdk-lib.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="cdk-extensions.athena.NamedQuery.property.stack"></a>

```typescript
public readonly stack: Stack;
```

- *Type:* aws-cdk-lib.Stack

The stack in which this resource is defined.

---

##### `database`<sup>Required</sup> <a name="database" id="cdk-extensions.athena.NamedQuery.property.database"></a>

```typescript
public readonly database: Database;
```

- *Type:* cdk-extensions.glue.Database

The Glue database to which the query belongs.

> [[NamedQuery Database](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html#cfn-athena-namedquery-database)]([NamedQuery Database](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html#cfn-athena-namedquery-database))

---

##### `namedQueryId`<sup>Required</sup> <a name="namedQueryId" id="cdk-extensions.athena.NamedQuery.property.namedQueryId"></a>

```typescript
public readonly namedQueryId: string;
```

- *Type:* string

The unique ID of the query.

---

##### `namedQueryName`<sup>Required</sup> <a name="namedQueryName" id="cdk-extensions.athena.NamedQuery.property.namedQueryName"></a>

```typescript
public readonly namedQueryName: string;
```

- *Type:* string

The name of the query.

---

##### `queryString`<sup>Required</sup> <a name="queryString" id="cdk-extensions.athena.NamedQuery.property.queryString"></a>

```typescript
public readonly queryString: string;
```

- *Type:* string

The SQL statements that make up the query.

> [[Athena SQL reference](https://docs.aws.amazon.com/athena/latest/ug/ddl-sql-reference.html)]([Athena SQL reference](https://docs.aws.amazon.com/athena/latest/ug/ddl-sql-reference.html))

---

##### `resource`<sup>Required</sup> <a name="resource" id="cdk-extensions.athena.NamedQuery.property.resource"></a>

```typescript
public readonly resource: CfnNamedQuery;
```

- *Type:* aws-cdk-lib.aws_athena.CfnNamedQuery

The underlying NamedQuery CloudFormation resource.

> [[AWS::Athena::NamedQuery](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html)]([AWS::Athena::NamedQuery](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html))

---

##### `description`<sup>Optional</sup> <a name="description" id="cdk-extensions.athena.NamedQuery.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

A human friendly description explaining the functionality of the query.

> [[NamedQuery Description](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html#cfn-athena-namedquery-description)]([NamedQuery Description](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html#cfn-athena-namedquery-description))

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.athena.NamedQuery.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the query.

> [[NamedQuery Name](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html#cfn-athena-namedquery-name)]([NamedQuery Name](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html#cfn-athena-namedquery-name))

---


### PermissionSet <a name="PermissionSet" id="cdk-extensions.sso.PermissionSet"></a>

- *Implements:* cdk-extensions.sso.IPermissionSet

Specifies a permission set within a specified IAM Identity Center instance.

#### Initializers <a name="Initializers" id="cdk-extensions.sso.PermissionSet.Initializer"></a>

```typescript
import { sso } from 'cdk-extensions'

new sso.PermissionSet(scope: Construct, id: string, props: PermissionSetProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.sso.PermissionSet.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | A CDK Construct that will serve as this stack's parent in the construct tree. |
| <code><a href="#cdk-extensions.sso.PermissionSet.Initializer.parameter.id">id</a></code> | <code>string</code> | A name to be associated with the stack and used in resource naming. |
| <code><a href="#cdk-extensions.sso.PermissionSet.Initializer.parameter.props">props</a></code> | <code>cdk-extensions.sso.PermissionSetProps</code> | Arguments related to the configuration of the resource. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.sso.PermissionSet.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

A CDK Construct that will serve as this stack's parent in the construct tree.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.sso.PermissionSet.Initializer.parameter.id"></a>

- *Type:* string

A name to be associated with the stack and used in resource naming.

Must be unique within the context of 'scope'.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk-extensions.sso.PermissionSet.Initializer.parameter.props"></a>

- *Type:* cdk-extensions.sso.PermissionSetProps

Arguments related to the configuration of the resource.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.sso.PermissionSet.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-extensions.sso.PermissionSet.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |
| <code><a href="#cdk-extensions.sso.PermissionSet.addCustomerManagedPolicy">addCustomerManagedPolicy</a></code> | Adds a custom managed policy to the permission set. |
| <code><a href="#cdk-extensions.sso.PermissionSet.addManagedPolicy">addManagedPolicy</a></code> | Adds a new Managed Policy to the permission set. |
| <code><a href="#cdk-extensions.sso.PermissionSet.addToPrincipalPolicy">addToPrincipalPolicy</a></code> | Adds a permission to the permission set's default policy document. |

---

##### `toString` <a name="toString" id="cdk-extensions.sso.PermissionSet.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="cdk-extensions.sso.PermissionSet.applyRemovalPolicy"></a>

```typescript
public applyRemovalPolicy(policy: RemovalPolicy): void
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="cdk-extensions.sso.PermissionSet.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.RemovalPolicy

---

##### `addCustomerManagedPolicy` <a name="addCustomerManagedPolicy" id="cdk-extensions.sso.PermissionSet.addCustomerManagedPolicy"></a>

```typescript
public addCustomerManagedPolicy(options: ReferenceOptions): ReferencedManagedPolicy
```

Adds a custom managed policy to the permission set.

When using customer
managed policies it is required that a managed policy with a matching
name and path exist in any AWS account for which the permission set
will be assigned.

###### `options`<sup>Required</sup> <a name="options" id="cdk-extensions.sso.PermissionSet.addCustomerManagedPolicy.parameter.options"></a>

- *Type:* cdk-extensions.sso.ReferenceOptions

The configuration for the customer managed policy.

---

##### `addManagedPolicy` <a name="addManagedPolicy" id="cdk-extensions.sso.PermissionSet.addManagedPolicy"></a>

```typescript
public addManagedPolicy(policy: IManagedPolicy): PermissionSet
```

Adds a new Managed Policy to the permission set.

Only Managed Policies
created and maintained by AWS are supported. To add a custom Managed
Policy that you control use the {@link addCustomerManagedPolicy} method.

###### `policy`<sup>Required</sup> <a name="policy" id="cdk-extensions.sso.PermissionSet.addManagedPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.aws_iam.IManagedPolicy

The AWS Managed Policy to associate with the Permission Set.

---

##### `addToPrincipalPolicy` <a name="addToPrincipalPolicy" id="cdk-extensions.sso.PermissionSet.addToPrincipalPolicy"></a>

```typescript
public addToPrincipalPolicy(statement: PolicyStatement): AddToPrincipalPolicyResult
```

Adds a permission to the permission set's default policy document.

If there is no default policy attached to this permission set, it will be created.

###### `statement`<sup>Required</sup> <a name="statement" id="cdk-extensions.sso.PermissionSet.addToPrincipalPolicy.parameter.statement"></a>

- *Type:* aws-cdk-lib.aws_iam.PolicyStatement

The permission statement to add to the policy document.

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.sso.PermissionSet.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-extensions.sso.PermissionSet.isOwnedResource">isOwnedResource</a></code> | Returns true if the construct was created by CDK, and false otherwise. |
| <code><a href="#cdk-extensions.sso.PermissionSet.isResource">isResource</a></code> | Check whether the given construct is a Resource. |
| <code><a href="#cdk-extensions.sso.PermissionSet.fromArn">fromArn</a></code> | *No description.* |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-extensions.sso.PermissionSet.isConstruct"></a>

```typescript
import { sso } from 'cdk-extensions'

sso.PermissionSet.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-extensions.sso.PermissionSet.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isOwnedResource` <a name="isOwnedResource" id="cdk-extensions.sso.PermissionSet.isOwnedResource"></a>

```typescript
import { sso } from 'cdk-extensions'

sso.PermissionSet.isOwnedResource(construct: IConstruct)
```

Returns true if the construct was created by CDK, and false otherwise.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.sso.PermissionSet.isOwnedResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `isResource` <a name="isResource" id="cdk-extensions.sso.PermissionSet.isResource"></a>

```typescript
import { sso } from 'cdk-extensions'

sso.PermissionSet.isResource(construct: IConstruct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.sso.PermissionSet.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `fromArn` <a name="fromArn" id="cdk-extensions.sso.PermissionSet.fromArn"></a>

```typescript
import { sso } from 'cdk-extensions'

sso.PermissionSet.fromArn(scope: Construct, id: string, arn: string)
```

###### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.sso.PermissionSet.fromArn.parameter.scope"></a>

- *Type:* constructs.Construct

---

###### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.sso.PermissionSet.fromArn.parameter.id"></a>

- *Type:* string

---

###### `arn`<sup>Required</sup> <a name="arn" id="cdk-extensions.sso.PermissionSet.fromArn.parameter.arn"></a>

- *Type:* string

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.sso.PermissionSet.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-extensions.sso.PermissionSet.property.env">env</a></code> | <code>aws-cdk-lib.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#cdk-extensions.sso.PermissionSet.property.stack">stack</a></code> | <code>aws-cdk-lib.Stack</code> | The stack in which this resource is defined. |
| <code><a href="#cdk-extensions.sso.PermissionSet.property.instance">instance</a></code> | <code>cdk-extensions.sso.IInstance</code> | The ARN of the IAM Identity Center instance under which the operation will be executed. |
| <code><a href="#cdk-extensions.sso.PermissionSet.property.permissionSetArn">permissionSetArn</a></code> | <code>string</code> | The permission set ARN of the permission set, such as `arn:aws:sso:::permissionSet/ins-instanceid/ps-permissionsetid`. |
| <code><a href="#cdk-extensions.sso.PermissionSet.property.resource">resource</a></code> | <code>aws-cdk-lib.aws_sso.CfnPermissionSet</code> | The underlying PermissionSet CloudFormation resource. |
| <code><a href="#cdk-extensions.sso.PermissionSet.property.description">description</a></code> | <code>string</code> | A user friendly description providing details about the permission set. |
| <code><a href="#cdk-extensions.sso.PermissionSet.property.name">name</a></code> | <code>string</code> | The name of the permission set. |
| <code><a href="#cdk-extensions.sso.PermissionSet.property.permissionsBoundary">permissionsBoundary</a></code> | <code>cdk-extensions.sso.PermissionsBoundary</code> | Specifies the configuration of the AWS managed or customer managed policy that you want to set as a permissions boundary. |
| <code><a href="#cdk-extensions.sso.PermissionSet.property.relayState">relayState</a></code> | <code>string</code> | Used to redirect users within the application during the federation authentication process. |
| <code><a href="#cdk-extensions.sso.PermissionSet.property.sessionDuration">sessionDuration</a></code> | <code>aws-cdk-lib.Duration</code> | The length of time that the application user sessions are valid for. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-extensions.sso.PermissionSet.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="cdk-extensions.sso.PermissionSet.property.env"></a>

```typescript
public readonly env: ResourceEnvironment;
```

- *Type:* aws-cdk-lib.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="cdk-extensions.sso.PermissionSet.property.stack"></a>

```typescript
public readonly stack: Stack;
```

- *Type:* aws-cdk-lib.Stack

The stack in which this resource is defined.

---

##### `instance`<sup>Required</sup> <a name="instance" id="cdk-extensions.sso.PermissionSet.property.instance"></a>

```typescript
public readonly instance: IInstance;
```

- *Type:* cdk-extensions.sso.IInstance

The ARN of the IAM Identity Center instance under which the operation will be executed.

---

##### `permissionSetArn`<sup>Required</sup> <a name="permissionSetArn" id="cdk-extensions.sso.PermissionSet.property.permissionSetArn"></a>

```typescript
public readonly permissionSetArn: string;
```

- *Type:* string

The permission set ARN of the permission set, such as `arn:aws:sso:::permissionSet/ins-instanceid/ps-permissionsetid`.

---

##### `resource`<sup>Required</sup> <a name="resource" id="cdk-extensions.sso.PermissionSet.property.resource"></a>

```typescript
public readonly resource: CfnPermissionSet;
```

- *Type:* aws-cdk-lib.aws_sso.CfnPermissionSet

The underlying PermissionSet CloudFormation resource.

---

##### `description`<sup>Optional</sup> <a name="description" id="cdk-extensions.sso.PermissionSet.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

A user friendly description providing details about the permission set.

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.sso.PermissionSet.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the permission set.

---

##### `permissionsBoundary`<sup>Optional</sup> <a name="permissionsBoundary" id="cdk-extensions.sso.PermissionSet.property.permissionsBoundary"></a>

```typescript
public readonly permissionsBoundary: PermissionsBoundary;
```

- *Type:* cdk-extensions.sso.PermissionsBoundary

Specifies the configuration of the AWS managed or customer managed policy that you want to set as a permissions boundary.

Specify either
CustomerManagedPolicyReference to use the name and path of a customer
managed policy, or ManagedPolicyArn to use the ARN of an AWS managed
policy. A permissions boundary represents the maximum permissions that
any policy can grant your role. For more information, see [Permissions
boundaries](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html) for IAM entities in the AWS Identity and Access Management
User Guide.

---

##### `relayState`<sup>Optional</sup> <a name="relayState" id="cdk-extensions.sso.PermissionSet.property.relayState"></a>

```typescript
public readonly relayState: string;
```

- *Type:* string

Used to redirect users within the application during the federation authentication process.

For example, you can redirect users to a
specific page that is most applicable to their job after singing in to
an AWS account.

---

##### `sessionDuration`<sup>Optional</sup> <a name="sessionDuration" id="cdk-extensions.sso.PermissionSet.property.sessionDuration"></a>

```typescript
public readonly sessionDuration: Duration;
```

- *Type:* aws-cdk-lib.Duration

The length of time that the application user sessions are valid for.

---


### RawBucket <a name="RawBucket" id="cdk-extensions.s3_buckets.RawBucket"></a>

- *Implements:* aws-cdk-lib.aws_s3.IBucket

Do not use directly.

Will be removed once a better replacemnt is written.

#### Initializers <a name="Initializers" id="cdk-extensions.s3_buckets.RawBucket.Initializer"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

new s3_buckets.RawBucket(scope: Construct, id: string, props?: RawBucketProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | A CDK Construct that will serve as this stack's parent in the construct tree. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.Initializer.parameter.id">id</a></code> | <code>string</code> | A name to be associated with the stack and used in resource naming. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.Initializer.parameter.props">props</a></code> | <code>cdk-extensions.s3_buckets.RawBucketProps</code> | Arguments related to the configuration of the resource. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.s3_buckets.RawBucket.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

A CDK Construct that will serve as this stack's parent in the construct tree.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.s3_buckets.RawBucket.Initializer.parameter.id"></a>

- *Type:* string

A name to be associated with the stack and used in resource naming.

Must be unique
within the context of 'scope'.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk-extensions.s3_buckets.RawBucket.Initializer.parameter.props"></a>

- *Type:* cdk-extensions.s3_buckets.RawBucketProps

Arguments related to the configuration of the resource.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.addEventNotification">addEventNotification</a></code> | Adds a bucket notification event destination. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.addObjectCreatedNotification">addObjectCreatedNotification</a></code> | Subscribes a destination to receive notifications when an object is created in the bucket. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.addObjectRemovedNotification">addObjectRemovedNotification</a></code> | Subscribes a destination to receive notifications when an object is removed from the bucket. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.addToResourcePolicy">addToResourcePolicy</a></code> | Adds a statement to the resource policy for a principal (i.e. account/role/service) to perform actions on this bucket and/or its contents. Use `bucketArn` and `arnForObjects(keys)` to obtain ARNs for this bucket or objects. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.arnForObjects">arnForObjects</a></code> | Returns an ARN that represents all objects within the bucket that match the key pattern specified. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.enableEventBridgeNotification">enableEventBridgeNotification</a></code> | Enables event bridge notification, causing all events below to be sent to EventBridge:. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.grantDelete">grantDelete</a></code> | Grants s3:DeleteObject* permission to an IAM principal for objects in this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.grantPublicAccess">grantPublicAccess</a></code> | Allows unrestricted access to objects from this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.grantPut">grantPut</a></code> | Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.grantPutAcl">grantPutAcl</a></code> | Grant the given IAM identity permissions to modify the ACLs of objects in the given Bucket. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.grantRead">grantRead</a></code> | Grant read permissions for this bucket and it's contents to an IAM principal (Role/Group/User). |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.grantReadWrite">grantReadWrite</a></code> | Grants read/write permissions for this bucket and it's contents to an IAM principal (Role/Group/User). |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.grantWrite">grantWrite</a></code> | Grant write permissions to this bucket to an IAM principal. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.onCloudTrailEvent">onCloudTrailEvent</a></code> | Defines a CloudWatch event that triggers when something happens to this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.onCloudTrailPutObject">onCloudTrailPutObject</a></code> | Defines an AWS CloudWatch event that triggers when an object is uploaded to the specified paths (keys) in this bucket using the PutObject API call. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.onCloudTrailWriteObject">onCloudTrailWriteObject</a></code> | Defines an AWS CloudWatch event that triggers when an object at the specified paths (keys) in this bucket are written to. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.s3UrlForObject">s3UrlForObject</a></code> | The S3 URL of an S3 object. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.transferAccelerationUrlForObject">transferAccelerationUrlForObject</a></code> | The https Transfer Acceleration URL of an S3 object. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.urlForObject">urlForObject</a></code> | The https URL of an S3 object. For example:. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.virtualHostedUrlForObject">virtualHostedUrlForObject</a></code> | The virtual hosted-style URL of an S3 object. Specify `regional: false` at the options for non-regional URL. For example:. |

---

##### `toString` <a name="toString" id="cdk-extensions.s3_buckets.RawBucket.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="cdk-extensions.s3_buckets.RawBucket.applyRemovalPolicy"></a>

```typescript
public applyRemovalPolicy(policy: RemovalPolicy): void
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="cdk-extensions.s3_buckets.RawBucket.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.RemovalPolicy

---

##### `addEventNotification` <a name="addEventNotification" id="cdk-extensions.s3_buckets.RawBucket.addEventNotification"></a>

```typescript
public addEventNotification(_event: EventType, _dest: IBucketNotificationDestination, _filters: NotificationKeyFilter): void
```

Adds a bucket notification event destination.

###### `_event`<sup>Required</sup> <a name="_event" id="cdk-extensions.s3_buckets.RawBucket.addEventNotification.parameter._event"></a>

- *Type:* aws-cdk-lib.aws_s3.EventType

---

###### `_dest`<sup>Required</sup> <a name="_dest" id="cdk-extensions.s3_buckets.RawBucket.addEventNotification.parameter._dest"></a>

- *Type:* aws-cdk-lib.aws_s3.IBucketNotificationDestination

---

###### `_filters`<sup>Required</sup> <a name="_filters" id="cdk-extensions.s3_buckets.RawBucket.addEventNotification.parameter._filters"></a>

- *Type:* aws-cdk-lib.aws_s3.NotificationKeyFilter

---

##### `addObjectCreatedNotification` <a name="addObjectCreatedNotification" id="cdk-extensions.s3_buckets.RawBucket.addObjectCreatedNotification"></a>

```typescript
public addObjectCreatedNotification(_dest: IBucketNotificationDestination, _filters: NotificationKeyFilter): void
```

Subscribes a destination to receive notifications when an object is created in the bucket.

This is identical to calling
`onEvent(s3.EventType.OBJECT_CREATED)`.

###### `_dest`<sup>Required</sup> <a name="_dest" id="cdk-extensions.s3_buckets.RawBucket.addObjectCreatedNotification.parameter._dest"></a>

- *Type:* aws-cdk-lib.aws_s3.IBucketNotificationDestination

---

###### `_filters`<sup>Required</sup> <a name="_filters" id="cdk-extensions.s3_buckets.RawBucket.addObjectCreatedNotification.parameter._filters"></a>

- *Type:* aws-cdk-lib.aws_s3.NotificationKeyFilter

---

##### `addObjectRemovedNotification` <a name="addObjectRemovedNotification" id="cdk-extensions.s3_buckets.RawBucket.addObjectRemovedNotification"></a>

```typescript
public addObjectRemovedNotification(_dest: IBucketNotificationDestination, _filters: NotificationKeyFilter): void
```

Subscribes a destination to receive notifications when an object is removed from the bucket.

This is identical to calling
`onEvent(EventType.OBJECT_REMOVED)`.

###### `_dest`<sup>Required</sup> <a name="_dest" id="cdk-extensions.s3_buckets.RawBucket.addObjectRemovedNotification.parameter._dest"></a>

- *Type:* aws-cdk-lib.aws_s3.IBucketNotificationDestination

---

###### `_filters`<sup>Required</sup> <a name="_filters" id="cdk-extensions.s3_buckets.RawBucket.addObjectRemovedNotification.parameter._filters"></a>

- *Type:* aws-cdk-lib.aws_s3.NotificationKeyFilter

---

##### `addToResourcePolicy` <a name="addToResourcePolicy" id="cdk-extensions.s3_buckets.RawBucket.addToResourcePolicy"></a>

```typescript
public addToResourcePolicy(permission: PolicyStatement): AddToResourcePolicyResult
```

Adds a statement to the resource policy for a principal (i.e. account/role/service) to perform actions on this bucket and/or its contents. Use `bucketArn` and `arnForObjects(keys)` to obtain ARNs for this bucket or objects.

Note that the policy statement may or may not be added to the policy.
For example, when an `IBucket` is created from an existing bucket,
it's not possible to tell whether the bucket already has a policy
attached, let alone to re-use that policy to add more statements to it.
So it's safest to do nothing in these cases.

###### `permission`<sup>Required</sup> <a name="permission" id="cdk-extensions.s3_buckets.RawBucket.addToResourcePolicy.parameter.permission"></a>

- *Type:* aws-cdk-lib.aws_iam.PolicyStatement

---

##### `arnForObjects` <a name="arnForObjects" id="cdk-extensions.s3_buckets.RawBucket.arnForObjects"></a>

```typescript
public arnForObjects(_keyPattern: string): string
```

Returns an ARN that represents all objects within the bucket that match the key pattern specified.

To represent all keys, specify ``"*"``.

###### `_keyPattern`<sup>Required</sup> <a name="_keyPattern" id="cdk-extensions.s3_buckets.RawBucket.arnForObjects.parameter._keyPattern"></a>

- *Type:* string

---

##### `enableEventBridgeNotification` <a name="enableEventBridgeNotification" id="cdk-extensions.s3_buckets.RawBucket.enableEventBridgeNotification"></a>

```typescript
public enableEventBridgeNotification(): void
```

Enables event bridge notification, causing all events below to be sent to EventBridge:.

Object Deleted (DeleteObject)
- Object Deleted (Lifecycle expiration)
- Object Restore Initiated
- Object Restore Completed
- Object Restore Expired
- Object Storage Class Changed
- Object Access Tier Changed
- Object ACL Updated
- Object Tags Added
- Object Tags Deleted

##### `grantDelete` <a name="grantDelete" id="cdk-extensions.s3_buckets.RawBucket.grantDelete"></a>

```typescript
public grantDelete(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grants s3:DeleteObject* permission to an IAM principal for objects in this bucket.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.RawBucket.grantDelete.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.RawBucket.grantDelete.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `grantPublicAccess` <a name="grantPublicAccess" id="cdk-extensions.s3_buckets.RawBucket.grantPublicAccess"></a>

```typescript
public grantPublicAccess(_allowedActions: string, _keyPrefix?: string): Grant
```

Allows unrestricted access to objects from this bucket.

IMPORTANT: This permission allows anyone to perform actions on S3 objects
in this bucket, which is useful for when you configure your bucket as a
website and want everyone to be able to read objects in the bucket without
needing to authenticate.

Without arguments, this method will grant read ("s3:GetObject") access to
all objects ("*") in the bucket.

The method returns the `iam.Grant` object, which can then be modified
as needed. For example, you can add a condition that will restrict access only
to an IPv4 range like this:

     const grant = bucket.grantPublicAccess();
     grant.resourceStatement!.addCondition(‘IpAddress’, { “aws:SourceIp”: “54.240.143.0/24” });

###### `_allowedActions`<sup>Required</sup> <a name="_allowedActions" id="cdk-extensions.s3_buckets.RawBucket.grantPublicAccess.parameter._allowedActions"></a>

- *Type:* string

---

###### `_keyPrefix`<sup>Optional</sup> <a name="_keyPrefix" id="cdk-extensions.s3_buckets.RawBucket.grantPublicAccess.parameter._keyPrefix"></a>

- *Type:* string

---

##### `grantPut` <a name="grantPut" id="cdk-extensions.s3_buckets.RawBucket.grantPut"></a>

```typescript
public grantPut(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal.

If encryption is used, permission to use the key to encrypt the contents
of written files will also be granted to the same principal.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.RawBucket.grantPut.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.RawBucket.grantPut.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `grantPutAcl` <a name="grantPutAcl" id="cdk-extensions.s3_buckets.RawBucket.grantPutAcl"></a>

```typescript
public grantPutAcl(_identity: IGrantable, _objectsKeyPattern?: string): Grant
```

Grant the given IAM identity permissions to modify the ACLs of objects in the given Bucket.

If your application has the '@aws-cdk/aws-s3:grantWriteWithoutAcl' feature flag set,
calling {@link grantWrite} or {@link grantReadWrite} no longer grants permissions to modify the ACLs of the objects;
in this case, if you need to modify object ACLs, call this method explicitly.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.RawBucket.grantPutAcl.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.RawBucket.grantPutAcl.parameter._objectsKeyPattern"></a>

- *Type:* string

---

##### `grantRead` <a name="grantRead" id="cdk-extensions.s3_buckets.RawBucket.grantRead"></a>

```typescript
public grantRead(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grant read permissions for this bucket and it's contents to an IAM principal (Role/Group/User).

If encryption is used, permission to use the key to decrypt the contents
of the bucket will also be granted to the same principal.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.RawBucket.grantRead.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.RawBucket.grantRead.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `grantReadWrite` <a name="grantReadWrite" id="cdk-extensions.s3_buckets.RawBucket.grantReadWrite"></a>

```typescript
public grantReadWrite(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grants read/write permissions for this bucket and it's contents to an IAM principal (Role/Group/User).

If an encryption key is used, permission to use the key for
encrypt/decrypt will also be granted.

Before CDK version 1.85.0, this method granted the `s3:PutObject*` permission that included `s3:PutObjectAcl`,
which could be used to grant read/write object access to IAM principals in other accounts.
If you want to get rid of that behavior, update your CDK version to 1.85.0 or later,
and make sure the `@aws-cdk/aws-s3:grantWriteWithoutAcl` feature flag is set to `true`
in the `context` key of your cdk.json file.
If you've already updated, but still need the principal to have permissions to modify the ACLs,
use the {@link grantPutAcl} method.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.RawBucket.grantReadWrite.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.RawBucket.grantReadWrite.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `grantWrite` <a name="grantWrite" id="cdk-extensions.s3_buckets.RawBucket.grantWrite"></a>

```typescript
public grantWrite(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grant write permissions to this bucket to an IAM principal.

If encryption is used, permission to use the key to encrypt the contents
of written files will also be granted to the same principal.

Before CDK version 1.85.0, this method granted the `s3:PutObject*` permission that included `s3:PutObjectAcl`,
which could be used to grant read/write object access to IAM principals in other accounts.
If you want to get rid of that behavior, update your CDK version to 1.85.0 or later,
and make sure the `@aws-cdk/aws-s3:grantWriteWithoutAcl` feature flag is set to `true`
in the `context` key of your cdk.json file.
If you've already updated, but still need the principal to have permissions to modify the ACLs,
use the {@link grantPutAcl} method.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.RawBucket.grantWrite.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.RawBucket.grantWrite.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `onCloudTrailEvent` <a name="onCloudTrailEvent" id="cdk-extensions.s3_buckets.RawBucket.onCloudTrailEvent"></a>

```typescript
public onCloudTrailEvent(_id: string, _options?: OnCloudTrailBucketEventOptions): Rule
```

Defines a CloudWatch event that triggers when something happens to this bucket.

Requires that there exists at least one CloudTrail Trail in your account
that captures the event. This method will not create the Trail.

###### `_id`<sup>Required</sup> <a name="_id" id="cdk-extensions.s3_buckets.RawBucket.onCloudTrailEvent.parameter._id"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.RawBucket.onCloudTrailEvent.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.OnCloudTrailBucketEventOptions

---

##### `onCloudTrailPutObject` <a name="onCloudTrailPutObject" id="cdk-extensions.s3_buckets.RawBucket.onCloudTrailPutObject"></a>

```typescript
public onCloudTrailPutObject(_id: string, _options?: OnCloudTrailBucketEventOptions): Rule
```

Defines an AWS CloudWatch event that triggers when an object is uploaded to the specified paths (keys) in this bucket using the PutObject API call.

Note that some tools like `aws s3 cp` will automatically use either
PutObject or the multipart upload API depending on the file size,
so using `onCloudTrailWriteObject` may be preferable.

Requires that there exists at least one CloudTrail Trail in your account
that captures the event. This method will not create the Trail.

###### `_id`<sup>Required</sup> <a name="_id" id="cdk-extensions.s3_buckets.RawBucket.onCloudTrailPutObject.parameter._id"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.RawBucket.onCloudTrailPutObject.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.OnCloudTrailBucketEventOptions

---

##### `onCloudTrailWriteObject` <a name="onCloudTrailWriteObject" id="cdk-extensions.s3_buckets.RawBucket.onCloudTrailWriteObject"></a>

```typescript
public onCloudTrailWriteObject(_id: string, _options?: OnCloudTrailBucketEventOptions): Rule
```

Defines an AWS CloudWatch event that triggers when an object at the specified paths (keys) in this bucket are written to.

This includes
the events PutObject, CopyObject, and CompleteMultipartUpload.

Note that some tools like `aws s3 cp` will automatically use either
PutObject or the multipart upload API depending on the file size,
so using this method may be preferable to `onCloudTrailPutObject`.

Requires that there exists at least one CloudTrail Trail in your account
that captures the event. This method will not create the Trail.

###### `_id`<sup>Required</sup> <a name="_id" id="cdk-extensions.s3_buckets.RawBucket.onCloudTrailWriteObject.parameter._id"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.RawBucket.onCloudTrailWriteObject.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.OnCloudTrailBucketEventOptions

---

##### `s3UrlForObject` <a name="s3UrlForObject" id="cdk-extensions.s3_buckets.RawBucket.s3UrlForObject"></a>

```typescript
public s3UrlForObject(_key?: string): string
```

The S3 URL of an S3 object.

For example:
- `s3://onlybucket`
- `s3://bucket/key`

###### `_key`<sup>Optional</sup> <a name="_key" id="cdk-extensions.s3_buckets.RawBucket.s3UrlForObject.parameter._key"></a>

- *Type:* string

---

##### `transferAccelerationUrlForObject` <a name="transferAccelerationUrlForObject" id="cdk-extensions.s3_buckets.RawBucket.transferAccelerationUrlForObject"></a>

```typescript
public transferAccelerationUrlForObject(_key?: string, _options?: TransferAccelerationUrlOptions): string
```

The https Transfer Acceleration URL of an S3 object.

Specify `dualStack: true` at the options
for dual-stack endpoint (connect to the bucket over IPv6). For example:

- `https://bucket.s3-accelerate.amazonaws.com`
- `https://bucket.s3-accelerate.amazonaws.com/key`

###### `_key`<sup>Optional</sup> <a name="_key" id="cdk-extensions.s3_buckets.RawBucket.transferAccelerationUrlForObject.parameter._key"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.RawBucket.transferAccelerationUrlForObject.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.TransferAccelerationUrlOptions

---

##### `urlForObject` <a name="urlForObject" id="cdk-extensions.s3_buckets.RawBucket.urlForObject"></a>

```typescript
public urlForObject(_key?: string): string
```

The https URL of an S3 object. For example:.

`https://s3.us-west-1.amazonaws.com/onlybucket`
- `https://s3.us-west-1.amazonaws.com/bucket/key`
- `https://s3.cn-north-1.amazonaws.com.cn/china-bucket/mykey`

###### `_key`<sup>Optional</sup> <a name="_key" id="cdk-extensions.s3_buckets.RawBucket.urlForObject.parameter._key"></a>

- *Type:* string

---

##### `virtualHostedUrlForObject` <a name="virtualHostedUrlForObject" id="cdk-extensions.s3_buckets.RawBucket.virtualHostedUrlForObject"></a>

```typescript
public virtualHostedUrlForObject(_key?: string, _options?: VirtualHostedStyleUrlOptions): string
```

The virtual hosted-style URL of an S3 object. Specify `regional: false` at the options for non-regional URL. For example:.

`https://only-bucket.s3.us-west-1.amazonaws.com`
- `https://bucket.s3.us-west-1.amazonaws.com/key`
- `https://bucket.s3.amazonaws.com/key`
- `https://china-bucket.s3.cn-north-1.amazonaws.com.cn/mykey`

###### `_key`<sup>Optional</sup> <a name="_key" id="cdk-extensions.s3_buckets.RawBucket.virtualHostedUrlForObject.parameter._key"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.RawBucket.virtualHostedUrlForObject.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.VirtualHostedStyleUrlOptions

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.isOwnedResource">isOwnedResource</a></code> | Returns true if the construct was created by CDK, and false otherwise. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.isResource">isResource</a></code> | Check whether the given construct is a Resource. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-extensions.s3_buckets.RawBucket.isConstruct"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

s3_buckets.RawBucket.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-extensions.s3_buckets.RawBucket.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isOwnedResource` <a name="isOwnedResource" id="cdk-extensions.s3_buckets.RawBucket.isOwnedResource"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

s3_buckets.RawBucket.isOwnedResource(construct: IConstruct)
```

Returns true if the construct was created by CDK, and false otherwise.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.s3_buckets.RawBucket.isOwnedResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `isResource` <a name="isResource" id="cdk-extensions.s3_buckets.RawBucket.isResource"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

s3_buckets.RawBucket.isResource(construct: IConstruct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.s3_buckets.RawBucket.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.property.env">env</a></code> | <code>aws-cdk-lib.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.property.stack">stack</a></code> | <code>aws-cdk-lib.Stack</code> | The stack in which this resource is defined. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.property.bucketArn">bucketArn</a></code> | <code>string</code> | The ARN of the bucket. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.property.bucketDomainName">bucketDomainName</a></code> | <code>string</code> | The IPv4 DNS name of the specified bucket. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.property.bucketDualStackDomainName">bucketDualStackDomainName</a></code> | <code>string</code> | The IPv6 DNS name of the specified bucket. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.property.bucketName">bucketName</a></code> | <code>string</code> | The name of the bucket. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.property.bucketRegionalDomainName">bucketRegionalDomainName</a></code> | <code>string</code> | The regional domain name of the specified bucket. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.property.bucketWebsiteDomainName">bucketWebsiteDomainName</a></code> | <code>string</code> | The Domain name of the static website. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.property.bucketWebsiteUrl">bucketWebsiteUrl</a></code> | <code>string</code> | The URL of the static website. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.property.resource">resource</a></code> | <code>aws-cdk-lib.aws_s3.CfnBucket</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.property.encryptionKey">encryptionKey</a></code> | <code>aws-cdk-lib.aws_kms.IKey</code> | Optional KMS encryption key associated with this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.property.isWebsite">isWebsite</a></code> | <code>boolean</code> | If this bucket has been configured for static website hosting. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucket.property.policy">policy</a></code> | <code>aws-cdk-lib.aws_s3.BucketPolicy</code> | The resource policy associated with this bucket. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-extensions.s3_buckets.RawBucket.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="cdk-extensions.s3_buckets.RawBucket.property.env"></a>

```typescript
public readonly env: ResourceEnvironment;
```

- *Type:* aws-cdk-lib.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="cdk-extensions.s3_buckets.RawBucket.property.stack"></a>

```typescript
public readonly stack: Stack;
```

- *Type:* aws-cdk-lib.Stack

The stack in which this resource is defined.

---

##### `bucketArn`<sup>Required</sup> <a name="bucketArn" id="cdk-extensions.s3_buckets.RawBucket.property.bucketArn"></a>

```typescript
public readonly bucketArn: string;
```

- *Type:* string

The ARN of the bucket.

---

##### `bucketDomainName`<sup>Required</sup> <a name="bucketDomainName" id="cdk-extensions.s3_buckets.RawBucket.property.bucketDomainName"></a>

```typescript
public readonly bucketDomainName: string;
```

- *Type:* string

The IPv4 DNS name of the specified bucket.

---

##### `bucketDualStackDomainName`<sup>Required</sup> <a name="bucketDualStackDomainName" id="cdk-extensions.s3_buckets.RawBucket.property.bucketDualStackDomainName"></a>

```typescript
public readonly bucketDualStackDomainName: string;
```

- *Type:* string

The IPv6 DNS name of the specified bucket.

---

##### `bucketName`<sup>Required</sup> <a name="bucketName" id="cdk-extensions.s3_buckets.RawBucket.property.bucketName"></a>

```typescript
public readonly bucketName: string;
```

- *Type:* string

The name of the bucket.

---

##### `bucketRegionalDomainName`<sup>Required</sup> <a name="bucketRegionalDomainName" id="cdk-extensions.s3_buckets.RawBucket.property.bucketRegionalDomainName"></a>

```typescript
public readonly bucketRegionalDomainName: string;
```

- *Type:* string

The regional domain name of the specified bucket.

---

##### `bucketWebsiteDomainName`<sup>Required</sup> <a name="bucketWebsiteDomainName" id="cdk-extensions.s3_buckets.RawBucket.property.bucketWebsiteDomainName"></a>

```typescript
public readonly bucketWebsiteDomainName: string;
```

- *Type:* string

The Domain name of the static website.

---

##### `bucketWebsiteUrl`<sup>Required</sup> <a name="bucketWebsiteUrl" id="cdk-extensions.s3_buckets.RawBucket.property.bucketWebsiteUrl"></a>

```typescript
public readonly bucketWebsiteUrl: string;
```

- *Type:* string

The URL of the static website.

---

##### `resource`<sup>Required</sup> <a name="resource" id="cdk-extensions.s3_buckets.RawBucket.property.resource"></a>

```typescript
public readonly resource: CfnBucket;
```

- *Type:* aws-cdk-lib.aws_s3.CfnBucket

---

##### `encryptionKey`<sup>Optional</sup> <a name="encryptionKey" id="cdk-extensions.s3_buckets.RawBucket.property.encryptionKey"></a>

```typescript
public readonly encryptionKey: IKey;
```

- *Type:* aws-cdk-lib.aws_kms.IKey

Optional KMS encryption key associated with this bucket.

---

##### `isWebsite`<sup>Optional</sup> <a name="isWebsite" id="cdk-extensions.s3_buckets.RawBucket.property.isWebsite"></a>

```typescript
public readonly isWebsite: boolean;
```

- *Type:* boolean

If this bucket has been configured for static website hosting.

---

##### `policy`<sup>Optional</sup> <a name="policy" id="cdk-extensions.s3_buckets.RawBucket.property.policy"></a>

```typescript
public readonly policy: BucketPolicy;
```

- *Type:* aws-cdk-lib.aws_s3.BucketPolicy

The resource policy associated with this bucket.

If `autoCreatePolicy` is true, a `BucketPolicy` will be created upon the
first call to addToResourcePolicy(s).

---


### ReferencedManagedPolicy <a name="ReferencedManagedPolicy" id="cdk-extensions.sso.ReferencedManagedPolicy"></a>

A managed policy that is referenced via IAM Identity Center.

#### Initializers <a name="Initializers" id="cdk-extensions.sso.ReferencedManagedPolicy.Initializer"></a>

```typescript
import { sso } from 'cdk-extensions'

new sso.ReferencedManagedPolicy(scope: Construct, id: string, props?: ReferencedManagedPolicyProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.sso.ReferencedManagedPolicy.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | A CDK Construct that will serve as this stack's parent in the construct tree. |
| <code><a href="#cdk-extensions.sso.ReferencedManagedPolicy.Initializer.parameter.id">id</a></code> | <code>string</code> | A name to be associated with the stack and used in resource naming. |
| <code><a href="#cdk-extensions.sso.ReferencedManagedPolicy.Initializer.parameter.props">props</a></code> | <code>cdk-extensions.sso.ReferencedManagedPolicyProps</code> | Arguments related to the configuration of the resource. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.sso.ReferencedManagedPolicy.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

A CDK Construct that will serve as this stack's parent in the construct tree.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.sso.ReferencedManagedPolicy.Initializer.parameter.id"></a>

- *Type:* string

A name to be associated with the stack and used in resource naming.

Must be unique within the context of 'scope'.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk-extensions.sso.ReferencedManagedPolicy.Initializer.parameter.props"></a>

- *Type:* cdk-extensions.sso.ReferencedManagedPolicyProps

Arguments related to the configuration of the resource.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.sso.ReferencedManagedPolicy.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-extensions.sso.ReferencedManagedPolicy.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |
| <code><a href="#cdk-extensions.sso.ReferencedManagedPolicy.addStatements">addStatements</a></code> | Adds a statement to the policy document. |
| <code><a href="#cdk-extensions.sso.ReferencedManagedPolicy.attachToGroup">attachToGroup</a></code> | Attaches this policy to a group. |
| <code><a href="#cdk-extensions.sso.ReferencedManagedPolicy.attachToRole">attachToRole</a></code> | Attaches this policy to a role. |
| <code><a href="#cdk-extensions.sso.ReferencedManagedPolicy.attachToUser">attachToUser</a></code> | Attaches this policy to a user. |

---

##### `toString` <a name="toString" id="cdk-extensions.sso.ReferencedManagedPolicy.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="cdk-extensions.sso.ReferencedManagedPolicy.applyRemovalPolicy"></a>

```typescript
public applyRemovalPolicy(policy: RemovalPolicy): void
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="cdk-extensions.sso.ReferencedManagedPolicy.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.RemovalPolicy

---

##### `addStatements` <a name="addStatements" id="cdk-extensions.sso.ReferencedManagedPolicy.addStatements"></a>

```typescript
public addStatements(statement: PolicyStatement): void
```

Adds a statement to the policy document.

###### `statement`<sup>Required</sup> <a name="statement" id="cdk-extensions.sso.ReferencedManagedPolicy.addStatements.parameter.statement"></a>

- *Type:* aws-cdk-lib.aws_iam.PolicyStatement

---

##### `attachToGroup` <a name="attachToGroup" id="cdk-extensions.sso.ReferencedManagedPolicy.attachToGroup"></a>

```typescript
public attachToGroup(group: IGroup): void
```

Attaches this policy to a group.

###### `group`<sup>Required</sup> <a name="group" id="cdk-extensions.sso.ReferencedManagedPolicy.attachToGroup.parameter.group"></a>

- *Type:* aws-cdk-lib.aws_iam.IGroup

---

##### `attachToRole` <a name="attachToRole" id="cdk-extensions.sso.ReferencedManagedPolicy.attachToRole"></a>

```typescript
public attachToRole(role: IRole): void
```

Attaches this policy to a role.

###### `role`<sup>Required</sup> <a name="role" id="cdk-extensions.sso.ReferencedManagedPolicy.attachToRole.parameter.role"></a>

- *Type:* aws-cdk-lib.aws_iam.IRole

---

##### `attachToUser` <a name="attachToUser" id="cdk-extensions.sso.ReferencedManagedPolicy.attachToUser"></a>

```typescript
public attachToUser(user: IUser): void
```

Attaches this policy to a user.

###### `user`<sup>Required</sup> <a name="user" id="cdk-extensions.sso.ReferencedManagedPolicy.attachToUser.parameter.user"></a>

- *Type:* aws-cdk-lib.aws_iam.IUser

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.sso.ReferencedManagedPolicy.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-extensions.sso.ReferencedManagedPolicy.isOwnedResource">isOwnedResource</a></code> | Returns true if the construct was created by CDK, and false otherwise. |
| <code><a href="#cdk-extensions.sso.ReferencedManagedPolicy.isResource">isResource</a></code> | Check whether the given construct is a Resource. |
| <code><a href="#cdk-extensions.sso.ReferencedManagedPolicy.fromAwsManagedPolicyName">fromAwsManagedPolicyName</a></code> | Import a managed policy from one of the policies that AWS manages. |
| <code><a href="#cdk-extensions.sso.ReferencedManagedPolicy.fromManagedPolicyArn">fromManagedPolicyArn</a></code> | Import an external managed policy by ARN. |
| <code><a href="#cdk-extensions.sso.ReferencedManagedPolicy.fromManagedPolicyName">fromManagedPolicyName</a></code> | Import a customer managed policy from the managedPolicyName. |
| <code><a href="#cdk-extensions.sso.ReferencedManagedPolicy.of">of</a></code> | Dynamically generates a new class that can be used to create a managed policy that matches a reference in IAM Identity Center. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-extensions.sso.ReferencedManagedPolicy.isConstruct"></a>

```typescript
import { sso } from 'cdk-extensions'

sso.ReferencedManagedPolicy.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-extensions.sso.ReferencedManagedPolicy.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isOwnedResource` <a name="isOwnedResource" id="cdk-extensions.sso.ReferencedManagedPolicy.isOwnedResource"></a>

```typescript
import { sso } from 'cdk-extensions'

sso.ReferencedManagedPolicy.isOwnedResource(construct: IConstruct)
```

Returns true if the construct was created by CDK, and false otherwise.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.sso.ReferencedManagedPolicy.isOwnedResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `isResource` <a name="isResource" id="cdk-extensions.sso.ReferencedManagedPolicy.isResource"></a>

```typescript
import { sso } from 'cdk-extensions'

sso.ReferencedManagedPolicy.isResource(construct: IConstruct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.sso.ReferencedManagedPolicy.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `fromAwsManagedPolicyName` <a name="fromAwsManagedPolicyName" id="cdk-extensions.sso.ReferencedManagedPolicy.fromAwsManagedPolicyName"></a>

```typescript
import { sso } from 'cdk-extensions'

sso.ReferencedManagedPolicy.fromAwsManagedPolicyName(managedPolicyName: string)
```

Import a managed policy from one of the policies that AWS manages.

For this managed policy, you only need to know the name to be able to use it.

Some managed policy names start with "service-role/", some start with
"job-function/", and some don't start with anything. Include the
prefix when constructing this object.

###### `managedPolicyName`<sup>Required</sup> <a name="managedPolicyName" id="cdk-extensions.sso.ReferencedManagedPolicy.fromAwsManagedPolicyName.parameter.managedPolicyName"></a>

- *Type:* string

---

##### `fromManagedPolicyArn` <a name="fromManagedPolicyArn" id="cdk-extensions.sso.ReferencedManagedPolicy.fromManagedPolicyArn"></a>

```typescript
import { sso } from 'cdk-extensions'

sso.ReferencedManagedPolicy.fromManagedPolicyArn(scope: Construct, id: string, managedPolicyArn: string)
```

Import an external managed policy by ARN.

For this managed policy, you only need to know the ARN to be able to use it.
This can be useful if you got the ARN from a CloudFormation Export.

If the imported Managed Policy ARN is a Token (such as a
`CfnParameter.valueAsString` or a `Fn.importValue()`) *and* the referenced
managed policy has a `path` (like `arn:...:policy/AdminPolicy/AdminAllow`), the
`managedPolicyName` property will not resolve to the correct value. Instead it
will resolve to the first path component. We unfortunately cannot express
the correct calculation of the full path name as a CloudFormation
expression. In this scenario the Managed Policy ARN should be supplied without the
`path` in order to resolve the correct managed policy resource.

###### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.sso.ReferencedManagedPolicy.fromManagedPolicyArn.parameter.scope"></a>

- *Type:* constructs.Construct

construct scope.

---

###### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.sso.ReferencedManagedPolicy.fromManagedPolicyArn.parameter.id"></a>

- *Type:* string

construct id.

---

###### `managedPolicyArn`<sup>Required</sup> <a name="managedPolicyArn" id="cdk-extensions.sso.ReferencedManagedPolicy.fromManagedPolicyArn.parameter.managedPolicyArn"></a>

- *Type:* string

the ARN of the managed policy to import.

---

##### `fromManagedPolicyName` <a name="fromManagedPolicyName" id="cdk-extensions.sso.ReferencedManagedPolicy.fromManagedPolicyName"></a>

```typescript
import { sso } from 'cdk-extensions'

sso.ReferencedManagedPolicy.fromManagedPolicyName(scope: Construct, id: string, managedPolicyName: string)
```

Import a customer managed policy from the managedPolicyName.

For this managed policy, you only need to know the name to be able to use it.

###### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.sso.ReferencedManagedPolicy.fromManagedPolicyName.parameter.scope"></a>

- *Type:* constructs.Construct

---

###### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.sso.ReferencedManagedPolicy.fromManagedPolicyName.parameter.id"></a>

- *Type:* string

---

###### `managedPolicyName`<sup>Required</sup> <a name="managedPolicyName" id="cdk-extensions.sso.ReferencedManagedPolicy.fromManagedPolicyName.parameter.managedPolicyName"></a>

- *Type:* string

---

##### `of` <a name="of" id="cdk-extensions.sso.ReferencedManagedPolicy.of"></a>

```typescript
import { sso } from 'cdk-extensions'

sso.ReferencedManagedPolicy.of(options: ReferenceOptions)
```

Dynamically generates a new class that can be used to create a managed policy that matches a reference in IAM Identity Center.

###### `options`<sup>Required</sup> <a name="options" id="cdk-extensions.sso.ReferencedManagedPolicy.of.parameter.options"></a>

- *Type:* cdk-extensions.sso.ReferenceOptions

The reference configuration used when registering a customer managed policy with a permission set in IAM Identity Center.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.sso.ReferencedManagedPolicy.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-extensions.sso.ReferencedManagedPolicy.property.env">env</a></code> | <code>aws-cdk-lib.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#cdk-extensions.sso.ReferencedManagedPolicy.property.stack">stack</a></code> | <code>aws-cdk-lib.Stack</code> | The stack in which this resource is defined. |
| <code><a href="#cdk-extensions.sso.ReferencedManagedPolicy.property.description">description</a></code> | <code>string</code> | The description of this policy. |
| <code><a href="#cdk-extensions.sso.ReferencedManagedPolicy.property.document">document</a></code> | <code>aws-cdk-lib.aws_iam.PolicyDocument</code> | The policy document. |
| <code><a href="#cdk-extensions.sso.ReferencedManagedPolicy.property.managedPolicyArn">managedPolicyArn</a></code> | <code>string</code> | Returns the ARN of this managed policy. |
| <code><a href="#cdk-extensions.sso.ReferencedManagedPolicy.property.managedPolicyName">managedPolicyName</a></code> | <code>string</code> | The name of this policy. |
| <code><a href="#cdk-extensions.sso.ReferencedManagedPolicy.property.path">path</a></code> | <code>string</code> | The path of this policy. |
| <code><a href="#cdk-extensions.sso.ReferencedManagedPolicy.property.referencedName">referencedName</a></code> | <code>string</code> | The name of the managed policy. |
| <code><a href="#cdk-extensions.sso.ReferencedManagedPolicy.property.referencedPath">referencedPath</a></code> | <code>string</code> | The path for the managed policy. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-extensions.sso.ReferencedManagedPolicy.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="cdk-extensions.sso.ReferencedManagedPolicy.property.env"></a>

```typescript
public readonly env: ResourceEnvironment;
```

- *Type:* aws-cdk-lib.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="cdk-extensions.sso.ReferencedManagedPolicy.property.stack"></a>

```typescript
public readonly stack: Stack;
```

- *Type:* aws-cdk-lib.Stack

The stack in which this resource is defined.

---

##### `description`<sup>Required</sup> <a name="description" id="cdk-extensions.sso.ReferencedManagedPolicy.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

The description of this policy.

---

##### `document`<sup>Required</sup> <a name="document" id="cdk-extensions.sso.ReferencedManagedPolicy.property.document"></a>

```typescript
public readonly document: PolicyDocument;
```

- *Type:* aws-cdk-lib.aws_iam.PolicyDocument

The policy document.

---

##### `managedPolicyArn`<sup>Required</sup> <a name="managedPolicyArn" id="cdk-extensions.sso.ReferencedManagedPolicy.property.managedPolicyArn"></a>

```typescript
public readonly managedPolicyArn: string;
```

- *Type:* string

Returns the ARN of this managed policy.

---

##### `managedPolicyName`<sup>Required</sup> <a name="managedPolicyName" id="cdk-extensions.sso.ReferencedManagedPolicy.property.managedPolicyName"></a>

```typescript
public readonly managedPolicyName: string;
```

- *Type:* string

The name of this policy.

---

##### `path`<sup>Required</sup> <a name="path" id="cdk-extensions.sso.ReferencedManagedPolicy.property.path"></a>

```typescript
public readonly path: string;
```

- *Type:* string

The path of this policy.

---

##### `referencedName`<sup>Required</sup> <a name="referencedName" id="cdk-extensions.sso.ReferencedManagedPolicy.property.referencedName"></a>

```typescript
public readonly referencedName: string;
```

- *Type:* string

The name of the managed policy.

---

##### `referencedPath`<sup>Optional</sup> <a name="referencedPath" id="cdk-extensions.sso.ReferencedManagedPolicy.property.referencedPath"></a>

```typescript
public readonly referencedPath: string;
```

- *Type:* string

The path for the managed policy.

For more information about paths, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the IAM User
Guide.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.sso.ReferencedManagedPolicy.property.policyName">policyName</a></code> | <code>string</code> | The name of the managed policy. |
| <code><a href="#cdk-extensions.sso.ReferencedManagedPolicy.property.policyPath">policyPath</a></code> | <code>string</code> | The path for the managed policy. |

---

##### `policyName`<sup>Required</sup> <a name="policyName" id="cdk-extensions.sso.ReferencedManagedPolicy.property.policyName"></a>

```typescript
public readonly policyName: string;
```

- *Type:* string

The name of the managed policy.

---

##### `policyPath`<sup>Optional</sup> <a name="policyPath" id="cdk-extensions.sso.ReferencedManagedPolicy.property.policyPath"></a>

```typescript
public readonly policyPath: string;
```

- *Type:* string

The path for the managed policy.

For more information about paths, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the IAM User
Guide.

---

### ResourceShare <a name="ResourceShare" id="cdk-extensions.ram.ResourceShare"></a>

#### Initializers <a name="Initializers" id="cdk-extensions.ram.ResourceShare.Initializer"></a>

```typescript
import { ram } from 'cdk-extensions'

new ram.ResourceShare(scope: Construct, id: string, props?: ResourceShareProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.ram.ResourceShare.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | A CDK Construct that will serve as this stack's parent in the construct tree. |
| <code><a href="#cdk-extensions.ram.ResourceShare.Initializer.parameter.id">id</a></code> | <code>string</code> | A name to be associated with the stack and used in resource naming. |
| <code><a href="#cdk-extensions.ram.ResourceShare.Initializer.parameter.props">props</a></code> | <code>cdk-extensions.ram.ResourceShareProps</code> | Arguments related to the configuration of the resource. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.ram.ResourceShare.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

A CDK Construct that will serve as this stack's parent in the construct tree.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.ram.ResourceShare.Initializer.parameter.id"></a>

- *Type:* string

A name to be associated with the stack and used in resource naming.

Must be unique
within the context of 'scope'.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk-extensions.ram.ResourceShare.Initializer.parameter.props"></a>

- *Type:* cdk-extensions.ram.ResourceShareProps

Arguments related to the configuration of the resource.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.ram.ResourceShare.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-extensions.ram.ResourceShare.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |
| <code><a href="#cdk-extensions.ram.ResourceShare.addPrincipal">addPrincipal</a></code> | *No description.* |
| <code><a href="#cdk-extensions.ram.ResourceShare.addResource">addResource</a></code> | *No description.* |
| <code><a href="#cdk-extensions.ram.ResourceShare.enableAutoDiscovery">enableAutoDiscovery</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="cdk-extensions.ram.ResourceShare.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="cdk-extensions.ram.ResourceShare.applyRemovalPolicy"></a>

```typescript
public applyRemovalPolicy(policy: RemovalPolicy): void
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="cdk-extensions.ram.ResourceShare.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.RemovalPolicy

---

##### `addPrincipal` <a name="addPrincipal" id="cdk-extensions.ram.ResourceShare.addPrincipal"></a>

```typescript
public addPrincipal(principal: ISharedPrincipal): void
```

###### `principal`<sup>Required</sup> <a name="principal" id="cdk-extensions.ram.ResourceShare.addPrincipal.parameter.principal"></a>

- *Type:* cdk-extensions.ram.ISharedPrincipal

---

##### `addResource` <a name="addResource" id="cdk-extensions.ram.ResourceShare.addResource"></a>

```typescript
public addResource(resource: ISharedResource): void
```

###### `resource`<sup>Required</sup> <a name="resource" id="cdk-extensions.ram.ResourceShare.addResource.parameter.resource"></a>

- *Type:* cdk-extensions.ram.ISharedResource

---

##### `enableAutoDiscovery` <a name="enableAutoDiscovery" id="cdk-extensions.ram.ResourceShare.enableAutoDiscovery"></a>

```typescript
public enableAutoDiscovery(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.ram.ResourceShare.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-extensions.ram.ResourceShare.isOwnedResource">isOwnedResource</a></code> | Returns true if the construct was created by CDK, and false otherwise. |
| <code><a href="#cdk-extensions.ram.ResourceShare.isResource">isResource</a></code> | Check whether the given construct is a Resource. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-extensions.ram.ResourceShare.isConstruct"></a>

```typescript
import { ram } from 'cdk-extensions'

ram.ResourceShare.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-extensions.ram.ResourceShare.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isOwnedResource` <a name="isOwnedResource" id="cdk-extensions.ram.ResourceShare.isOwnedResource"></a>

```typescript
import { ram } from 'cdk-extensions'

ram.ResourceShare.isOwnedResource(construct: IConstruct)
```

Returns true if the construct was created by CDK, and false otherwise.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.ram.ResourceShare.isOwnedResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `isResource` <a name="isResource" id="cdk-extensions.ram.ResourceShare.isResource"></a>

```typescript
import { ram } from 'cdk-extensions'

ram.ResourceShare.isResource(construct: IConstruct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.ram.ResourceShare.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.ram.ResourceShare.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-extensions.ram.ResourceShare.property.env">env</a></code> | <code>aws-cdk-lib.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#cdk-extensions.ram.ResourceShare.property.stack">stack</a></code> | <code>aws-cdk-lib.Stack</code> | The stack in which this resource is defined. |
| <code><a href="#cdk-extensions.ram.ResourceShare.property.autoDiscovery">autoDiscovery</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.ram.ResourceShare.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.ram.ResourceShare.property.resource">resource</a></code> | <code>aws-cdk-lib.aws_ram.CfnResourceShare</code> | *No description.* |
| <code><a href="#cdk-extensions.ram.ResourceShare.property.allowExternalPrincipals">allowExternalPrincipals</a></code> | <code>boolean</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-extensions.ram.ResourceShare.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="cdk-extensions.ram.ResourceShare.property.env"></a>

```typescript
public readonly env: ResourceEnvironment;
```

- *Type:* aws-cdk-lib.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="cdk-extensions.ram.ResourceShare.property.stack"></a>

```typescript
public readonly stack: Stack;
```

- *Type:* aws-cdk-lib.Stack

The stack in which this resource is defined.

---

##### `autoDiscovery`<sup>Required</sup> <a name="autoDiscovery" id="cdk-extensions.ram.ResourceShare.property.autoDiscovery"></a>

```typescript
public readonly autoDiscovery: boolean;
```

- *Type:* boolean

---

##### `name`<sup>Required</sup> <a name="name" id="cdk-extensions.ram.ResourceShare.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `resource`<sup>Required</sup> <a name="resource" id="cdk-extensions.ram.ResourceShare.property.resource"></a>

```typescript
public readonly resource: CfnResourceShare;
```

- *Type:* aws-cdk-lib.aws_ram.CfnResourceShare

---

##### `allowExternalPrincipals`<sup>Optional</sup> <a name="allowExternalPrincipals" id="cdk-extensions.ram.ResourceShare.property.allowExternalPrincipals"></a>

```typescript
public readonly allowExternalPrincipals: boolean;
```

- *Type:* boolean

---


### S3AccessLogsBucket <a name="S3AccessLogsBucket" id="cdk-extensions.s3_buckets.S3AccessLogsBucket"></a>

#### Initializers <a name="Initializers" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.Initializer"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

new s3_buckets.S3AccessLogsBucket(scope: Construct, id: string, props?: S3AccessLogsBucketProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | A CDK Construct that will serve as this stack's parent in the construct tree. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.Initializer.parameter.id">id</a></code> | <code>string</code> | A name to be associated with the stack and used in resource naming. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.Initializer.parameter.props">props</a></code> | <code>cdk-extensions.s3_buckets.S3AccessLogsBucketProps</code> | Arguments related to the configuration of the resource. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

A CDK Construct that will serve as this stack's parent in the construct tree.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.Initializer.parameter.id"></a>

- *Type:* string

A name to be associated with the stack and used in resource naming.

Must be unique
within the context of 'scope'.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.Initializer.parameter.props"></a>

- *Type:* cdk-extensions.s3_buckets.S3AccessLogsBucketProps

Arguments related to the configuration of the resource.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.addEventNotification">addEventNotification</a></code> | Adds a bucket notification event destination. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.addObjectCreatedNotification">addObjectCreatedNotification</a></code> | Subscribes a destination to receive notifications when an object is created in the bucket. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.addObjectRemovedNotification">addObjectRemovedNotification</a></code> | Subscribes a destination to receive notifications when an object is removed from the bucket. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.addToResourcePolicy">addToResourcePolicy</a></code> | Adds a statement to the resource policy for a principal (i.e. account/role/service) to perform actions on this bucket and/or its contents. Use `bucketArn` and `arnForObjects(keys)` to obtain ARNs for this bucket or objects. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.arnForObjects">arnForObjects</a></code> | Returns an ARN that represents all objects within the bucket that match the key pattern specified. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.enableEventBridgeNotification">enableEventBridgeNotification</a></code> | Enables event bridge notification, causing all events below to be sent to EventBridge:. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.grantDelete">grantDelete</a></code> | Grants s3:DeleteObject* permission to an IAM principal for objects in this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.grantPublicAccess">grantPublicAccess</a></code> | Allows unrestricted access to objects from this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.grantPut">grantPut</a></code> | Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.grantPutAcl">grantPutAcl</a></code> | Grant the given IAM identity permissions to modify the ACLs of objects in the given Bucket. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.grantRead">grantRead</a></code> | Grant read permissions for this bucket and it's contents to an IAM principal (Role/Group/User). |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.grantReadWrite">grantReadWrite</a></code> | Grants read/write permissions for this bucket and it's contents to an IAM principal (Role/Group/User). |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.grantWrite">grantWrite</a></code> | Grant write permissions to this bucket to an IAM principal. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.onCloudTrailEvent">onCloudTrailEvent</a></code> | Defines a CloudWatch event that triggers when something happens to this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.onCloudTrailPutObject">onCloudTrailPutObject</a></code> | Defines an AWS CloudWatch event that triggers when an object is uploaded to the specified paths (keys) in this bucket using the PutObject API call. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.onCloudTrailWriteObject">onCloudTrailWriteObject</a></code> | Defines an AWS CloudWatch event that triggers when an object at the specified paths (keys) in this bucket are written to. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.s3UrlForObject">s3UrlForObject</a></code> | The S3 URL of an S3 object. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.transferAccelerationUrlForObject">transferAccelerationUrlForObject</a></code> | The https Transfer Acceleration URL of an S3 object. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.urlForObject">urlForObject</a></code> | The https URL of an S3 object. For example:. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.virtualHostedUrlForObject">virtualHostedUrlForObject</a></code> | The virtual hosted-style URL of an S3 object. Specify `regional: false` at the options for non-regional URL. For example:. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.addLoggingAspect">addLoggingAspect</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.applyRemovalPolicy"></a>

```typescript
public applyRemovalPolicy(policy: RemovalPolicy): void
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.RemovalPolicy

---

##### `addEventNotification` <a name="addEventNotification" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.addEventNotification"></a>

```typescript
public addEventNotification(_event: EventType, _dest: IBucketNotificationDestination, _filters: NotificationKeyFilter): void
```

Adds a bucket notification event destination.

###### `_event`<sup>Required</sup> <a name="_event" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.addEventNotification.parameter._event"></a>

- *Type:* aws-cdk-lib.aws_s3.EventType

---

###### `_dest`<sup>Required</sup> <a name="_dest" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.addEventNotification.parameter._dest"></a>

- *Type:* aws-cdk-lib.aws_s3.IBucketNotificationDestination

---

###### `_filters`<sup>Required</sup> <a name="_filters" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.addEventNotification.parameter._filters"></a>

- *Type:* aws-cdk-lib.aws_s3.NotificationKeyFilter

---

##### `addObjectCreatedNotification` <a name="addObjectCreatedNotification" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.addObjectCreatedNotification"></a>

```typescript
public addObjectCreatedNotification(_dest: IBucketNotificationDestination, _filters: NotificationKeyFilter): void
```

Subscribes a destination to receive notifications when an object is created in the bucket.

This is identical to calling
`onEvent(s3.EventType.OBJECT_CREATED)`.

###### `_dest`<sup>Required</sup> <a name="_dest" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.addObjectCreatedNotification.parameter._dest"></a>

- *Type:* aws-cdk-lib.aws_s3.IBucketNotificationDestination

---

###### `_filters`<sup>Required</sup> <a name="_filters" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.addObjectCreatedNotification.parameter._filters"></a>

- *Type:* aws-cdk-lib.aws_s3.NotificationKeyFilter

---

##### `addObjectRemovedNotification` <a name="addObjectRemovedNotification" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.addObjectRemovedNotification"></a>

```typescript
public addObjectRemovedNotification(_dest: IBucketNotificationDestination, _filters: NotificationKeyFilter): void
```

Subscribes a destination to receive notifications when an object is removed from the bucket.

This is identical to calling
`onEvent(EventType.OBJECT_REMOVED)`.

###### `_dest`<sup>Required</sup> <a name="_dest" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.addObjectRemovedNotification.parameter._dest"></a>

- *Type:* aws-cdk-lib.aws_s3.IBucketNotificationDestination

---

###### `_filters`<sup>Required</sup> <a name="_filters" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.addObjectRemovedNotification.parameter._filters"></a>

- *Type:* aws-cdk-lib.aws_s3.NotificationKeyFilter

---

##### `addToResourcePolicy` <a name="addToResourcePolicy" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.addToResourcePolicy"></a>

```typescript
public addToResourcePolicy(permission: PolicyStatement): AddToResourcePolicyResult
```

Adds a statement to the resource policy for a principal (i.e. account/role/service) to perform actions on this bucket and/or its contents. Use `bucketArn` and `arnForObjects(keys)` to obtain ARNs for this bucket or objects.

Note that the policy statement may or may not be added to the policy.
For example, when an `IBucket` is created from an existing bucket,
it's not possible to tell whether the bucket already has a policy
attached, let alone to re-use that policy to add more statements to it.
So it's safest to do nothing in these cases.

###### `permission`<sup>Required</sup> <a name="permission" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.addToResourcePolicy.parameter.permission"></a>

- *Type:* aws-cdk-lib.aws_iam.PolicyStatement

---

##### `arnForObjects` <a name="arnForObjects" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.arnForObjects"></a>

```typescript
public arnForObjects(_keyPattern: string): string
```

Returns an ARN that represents all objects within the bucket that match the key pattern specified.

To represent all keys, specify ``"*"``.

###### `_keyPattern`<sup>Required</sup> <a name="_keyPattern" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.arnForObjects.parameter._keyPattern"></a>

- *Type:* string

---

##### `enableEventBridgeNotification` <a name="enableEventBridgeNotification" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.enableEventBridgeNotification"></a>

```typescript
public enableEventBridgeNotification(): void
```

Enables event bridge notification, causing all events below to be sent to EventBridge:.

Object Deleted (DeleteObject)
- Object Deleted (Lifecycle expiration)
- Object Restore Initiated
- Object Restore Completed
- Object Restore Expired
- Object Storage Class Changed
- Object Access Tier Changed
- Object ACL Updated
- Object Tags Added
- Object Tags Deleted

##### `grantDelete` <a name="grantDelete" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.grantDelete"></a>

```typescript
public grantDelete(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grants s3:DeleteObject* permission to an IAM principal for objects in this bucket.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.grantDelete.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.grantDelete.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `grantPublicAccess` <a name="grantPublicAccess" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.grantPublicAccess"></a>

```typescript
public grantPublicAccess(_allowedActions: string, _keyPrefix?: string): Grant
```

Allows unrestricted access to objects from this bucket.

IMPORTANT: This permission allows anyone to perform actions on S3 objects
in this bucket, which is useful for when you configure your bucket as a
website and want everyone to be able to read objects in the bucket without
needing to authenticate.

Without arguments, this method will grant read ("s3:GetObject") access to
all objects ("*") in the bucket.

The method returns the `iam.Grant` object, which can then be modified
as needed. For example, you can add a condition that will restrict access only
to an IPv4 range like this:

     const grant = bucket.grantPublicAccess();
     grant.resourceStatement!.addCondition(‘IpAddress’, { “aws:SourceIp”: “54.240.143.0/24” });

###### `_allowedActions`<sup>Required</sup> <a name="_allowedActions" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.grantPublicAccess.parameter._allowedActions"></a>

- *Type:* string

---

###### `_keyPrefix`<sup>Optional</sup> <a name="_keyPrefix" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.grantPublicAccess.parameter._keyPrefix"></a>

- *Type:* string

---

##### `grantPut` <a name="grantPut" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.grantPut"></a>

```typescript
public grantPut(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal.

If encryption is used, permission to use the key to encrypt the contents
of written files will also be granted to the same principal.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.grantPut.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.grantPut.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `grantPutAcl` <a name="grantPutAcl" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.grantPutAcl"></a>

```typescript
public grantPutAcl(_identity: IGrantable, _objectsKeyPattern?: string): Grant
```

Grant the given IAM identity permissions to modify the ACLs of objects in the given Bucket.

If your application has the '@aws-cdk/aws-s3:grantWriteWithoutAcl' feature flag set,
calling {@link grantWrite} or {@link grantReadWrite} no longer grants permissions to modify the ACLs of the objects;
in this case, if you need to modify object ACLs, call this method explicitly.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.grantPutAcl.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.grantPutAcl.parameter._objectsKeyPattern"></a>

- *Type:* string

---

##### `grantRead` <a name="grantRead" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.grantRead"></a>

```typescript
public grantRead(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grant read permissions for this bucket and it's contents to an IAM principal (Role/Group/User).

If encryption is used, permission to use the key to decrypt the contents
of the bucket will also be granted to the same principal.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.grantRead.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.grantRead.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `grantReadWrite` <a name="grantReadWrite" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.grantReadWrite"></a>

```typescript
public grantReadWrite(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grants read/write permissions for this bucket and it's contents to an IAM principal (Role/Group/User).

If an encryption key is used, permission to use the key for
encrypt/decrypt will also be granted.

Before CDK version 1.85.0, this method granted the `s3:PutObject*` permission that included `s3:PutObjectAcl`,
which could be used to grant read/write object access to IAM principals in other accounts.
If you want to get rid of that behavior, update your CDK version to 1.85.0 or later,
and make sure the `@aws-cdk/aws-s3:grantWriteWithoutAcl` feature flag is set to `true`
in the `context` key of your cdk.json file.
If you've already updated, but still need the principal to have permissions to modify the ACLs,
use the {@link grantPutAcl} method.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.grantReadWrite.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.grantReadWrite.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `grantWrite` <a name="grantWrite" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.grantWrite"></a>

```typescript
public grantWrite(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grant write permissions to this bucket to an IAM principal.

If encryption is used, permission to use the key to encrypt the contents
of written files will also be granted to the same principal.

Before CDK version 1.85.0, this method granted the `s3:PutObject*` permission that included `s3:PutObjectAcl`,
which could be used to grant read/write object access to IAM principals in other accounts.
If you want to get rid of that behavior, update your CDK version to 1.85.0 or later,
and make sure the `@aws-cdk/aws-s3:grantWriteWithoutAcl` feature flag is set to `true`
in the `context` key of your cdk.json file.
If you've already updated, but still need the principal to have permissions to modify the ACLs,
use the {@link grantPutAcl} method.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.grantWrite.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.grantWrite.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `onCloudTrailEvent` <a name="onCloudTrailEvent" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.onCloudTrailEvent"></a>

```typescript
public onCloudTrailEvent(_id: string, _options?: OnCloudTrailBucketEventOptions): Rule
```

Defines a CloudWatch event that triggers when something happens to this bucket.

Requires that there exists at least one CloudTrail Trail in your account
that captures the event. This method will not create the Trail.

###### `_id`<sup>Required</sup> <a name="_id" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.onCloudTrailEvent.parameter._id"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.onCloudTrailEvent.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.OnCloudTrailBucketEventOptions

---

##### `onCloudTrailPutObject` <a name="onCloudTrailPutObject" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.onCloudTrailPutObject"></a>

```typescript
public onCloudTrailPutObject(_id: string, _options?: OnCloudTrailBucketEventOptions): Rule
```

Defines an AWS CloudWatch event that triggers when an object is uploaded to the specified paths (keys) in this bucket using the PutObject API call.

Note that some tools like `aws s3 cp` will automatically use either
PutObject or the multipart upload API depending on the file size,
so using `onCloudTrailWriteObject` may be preferable.

Requires that there exists at least one CloudTrail Trail in your account
that captures the event. This method will not create the Trail.

###### `_id`<sup>Required</sup> <a name="_id" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.onCloudTrailPutObject.parameter._id"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.onCloudTrailPutObject.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.OnCloudTrailBucketEventOptions

---

##### `onCloudTrailWriteObject` <a name="onCloudTrailWriteObject" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.onCloudTrailWriteObject"></a>

```typescript
public onCloudTrailWriteObject(_id: string, _options?: OnCloudTrailBucketEventOptions): Rule
```

Defines an AWS CloudWatch event that triggers when an object at the specified paths (keys) in this bucket are written to.

This includes
the events PutObject, CopyObject, and CompleteMultipartUpload.

Note that some tools like `aws s3 cp` will automatically use either
PutObject or the multipart upload API depending on the file size,
so using this method may be preferable to `onCloudTrailPutObject`.

Requires that there exists at least one CloudTrail Trail in your account
that captures the event. This method will not create the Trail.

###### `_id`<sup>Required</sup> <a name="_id" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.onCloudTrailWriteObject.parameter._id"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.onCloudTrailWriteObject.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.OnCloudTrailBucketEventOptions

---

##### `s3UrlForObject` <a name="s3UrlForObject" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.s3UrlForObject"></a>

```typescript
public s3UrlForObject(_key?: string): string
```

The S3 URL of an S3 object.

For example:
- `s3://onlybucket`
- `s3://bucket/key`

###### `_key`<sup>Optional</sup> <a name="_key" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.s3UrlForObject.parameter._key"></a>

- *Type:* string

---

##### `transferAccelerationUrlForObject` <a name="transferAccelerationUrlForObject" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.transferAccelerationUrlForObject"></a>

```typescript
public transferAccelerationUrlForObject(_key?: string, _options?: TransferAccelerationUrlOptions): string
```

The https Transfer Acceleration URL of an S3 object.

Specify `dualStack: true` at the options
for dual-stack endpoint (connect to the bucket over IPv6). For example:

- `https://bucket.s3-accelerate.amazonaws.com`
- `https://bucket.s3-accelerate.amazonaws.com/key`

###### `_key`<sup>Optional</sup> <a name="_key" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.transferAccelerationUrlForObject.parameter._key"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.transferAccelerationUrlForObject.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.TransferAccelerationUrlOptions

---

##### `urlForObject` <a name="urlForObject" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.urlForObject"></a>

```typescript
public urlForObject(_key?: string): string
```

The https URL of an S3 object. For example:.

`https://s3.us-west-1.amazonaws.com/onlybucket`
- `https://s3.us-west-1.amazonaws.com/bucket/key`
- `https://s3.cn-north-1.amazonaws.com.cn/china-bucket/mykey`

###### `_key`<sup>Optional</sup> <a name="_key" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.urlForObject.parameter._key"></a>

- *Type:* string

---

##### `virtualHostedUrlForObject` <a name="virtualHostedUrlForObject" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.virtualHostedUrlForObject"></a>

```typescript
public virtualHostedUrlForObject(_key?: string, _options?: VirtualHostedStyleUrlOptions): string
```

The virtual hosted-style URL of an S3 object. Specify `regional: false` at the options for non-regional URL. For example:.

`https://only-bucket.s3.us-west-1.amazonaws.com`
- `https://bucket.s3.us-west-1.amazonaws.com/key`
- `https://bucket.s3.amazonaws.com/key`
- `https://china-bucket.s3.cn-north-1.amazonaws.com.cn/mykey`

###### `_key`<sup>Optional</sup> <a name="_key" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.virtualHostedUrlForObject.parameter._key"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.virtualHostedUrlForObject.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.VirtualHostedStyleUrlOptions

---

##### `addLoggingAspect` <a name="addLoggingAspect" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.addLoggingAspect"></a>

```typescript
public addLoggingAspect(scope: IConstruct, options?: LoggingAspectOptions): void
```

###### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.addLoggingAspect.parameter.scope"></a>

- *Type:* constructs.IConstruct

---

###### `options`<sup>Optional</sup> <a name="options" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.addLoggingAspect.parameter.options"></a>

- *Type:* cdk-extensions.s3_buckets.LoggingAspectOptions

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.isOwnedResource">isOwnedResource</a></code> | Returns true if the construct was created by CDK, and false otherwise. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.isResource">isResource</a></code> | Check whether the given construct is a Resource. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.isConstruct"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

s3_buckets.S3AccessLogsBucket.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isOwnedResource` <a name="isOwnedResource" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.isOwnedResource"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

s3_buckets.S3AccessLogsBucket.isOwnedResource(construct: IConstruct)
```

Returns true if the construct was created by CDK, and false otherwise.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.isOwnedResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `isResource` <a name="isResource" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.isResource"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

s3_buckets.S3AccessLogsBucket.isResource(construct: IConstruct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.property.env">env</a></code> | <code>aws-cdk-lib.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.property.stack">stack</a></code> | <code>aws-cdk-lib.Stack</code> | The stack in which this resource is defined. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.property.bucketArn">bucketArn</a></code> | <code>string</code> | The ARN of the bucket. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.property.bucketDomainName">bucketDomainName</a></code> | <code>string</code> | The IPv4 DNS name of the specified bucket. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.property.bucketDualStackDomainName">bucketDualStackDomainName</a></code> | <code>string</code> | The IPv6 DNS name of the specified bucket. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.property.bucketName">bucketName</a></code> | <code>string</code> | The name of the bucket. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.property.bucketRegionalDomainName">bucketRegionalDomainName</a></code> | <code>string</code> | The regional domain name of the specified bucket. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.property.bucketWebsiteDomainName">bucketWebsiteDomainName</a></code> | <code>string</code> | The Domain name of the static website. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.property.bucketWebsiteUrl">bucketWebsiteUrl</a></code> | <code>string</code> | The URL of the static website. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.property.resource">resource</a></code> | <code>aws-cdk-lib.aws_s3.CfnBucket</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.property.encryptionKey">encryptionKey</a></code> | <code>aws-cdk-lib.aws_kms.IKey</code> | Optional KMS encryption key associated with this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.property.isWebsite">isWebsite</a></code> | <code>boolean</code> | If this bucket has been configured for static website hosting. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.property.policy">policy</a></code> | <code>aws-cdk-lib.aws_s3.BucketPolicy</code> | The resource policy associated with this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.property.database">database</a></code> | <code>cdk-extensions.glue.Database</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.property.table">table</a></code> | <code>cdk-extensions.glue_tables.S3AccessLogsTable</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.property.createQueries">createQueries</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucket.property.friendlyQueryNames">friendlyQueryNames</a></code> | <code>boolean</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.property.env"></a>

```typescript
public readonly env: ResourceEnvironment;
```

- *Type:* aws-cdk-lib.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.property.stack"></a>

```typescript
public readonly stack: Stack;
```

- *Type:* aws-cdk-lib.Stack

The stack in which this resource is defined.

---

##### `bucketArn`<sup>Required</sup> <a name="bucketArn" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.property.bucketArn"></a>

```typescript
public readonly bucketArn: string;
```

- *Type:* string

The ARN of the bucket.

---

##### `bucketDomainName`<sup>Required</sup> <a name="bucketDomainName" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.property.bucketDomainName"></a>

```typescript
public readonly bucketDomainName: string;
```

- *Type:* string

The IPv4 DNS name of the specified bucket.

---

##### `bucketDualStackDomainName`<sup>Required</sup> <a name="bucketDualStackDomainName" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.property.bucketDualStackDomainName"></a>

```typescript
public readonly bucketDualStackDomainName: string;
```

- *Type:* string

The IPv6 DNS name of the specified bucket.

---

##### `bucketName`<sup>Required</sup> <a name="bucketName" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.property.bucketName"></a>

```typescript
public readonly bucketName: string;
```

- *Type:* string

The name of the bucket.

---

##### `bucketRegionalDomainName`<sup>Required</sup> <a name="bucketRegionalDomainName" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.property.bucketRegionalDomainName"></a>

```typescript
public readonly bucketRegionalDomainName: string;
```

- *Type:* string

The regional domain name of the specified bucket.

---

##### `bucketWebsiteDomainName`<sup>Required</sup> <a name="bucketWebsiteDomainName" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.property.bucketWebsiteDomainName"></a>

```typescript
public readonly bucketWebsiteDomainName: string;
```

- *Type:* string

The Domain name of the static website.

---

##### `bucketWebsiteUrl`<sup>Required</sup> <a name="bucketWebsiteUrl" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.property.bucketWebsiteUrl"></a>

```typescript
public readonly bucketWebsiteUrl: string;
```

- *Type:* string

The URL of the static website.

---

##### `resource`<sup>Required</sup> <a name="resource" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.property.resource"></a>

```typescript
public readonly resource: CfnBucket;
```

- *Type:* aws-cdk-lib.aws_s3.CfnBucket

---

##### `encryptionKey`<sup>Optional</sup> <a name="encryptionKey" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.property.encryptionKey"></a>

```typescript
public readonly encryptionKey: IKey;
```

- *Type:* aws-cdk-lib.aws_kms.IKey

Optional KMS encryption key associated with this bucket.

---

##### `isWebsite`<sup>Optional</sup> <a name="isWebsite" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.property.isWebsite"></a>

```typescript
public readonly isWebsite: boolean;
```

- *Type:* boolean

If this bucket has been configured for static website hosting.

---

##### `policy`<sup>Optional</sup> <a name="policy" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.property.policy"></a>

```typescript
public readonly policy: BucketPolicy;
```

- *Type:* aws-cdk-lib.aws_s3.BucketPolicy

The resource policy associated with this bucket.

If `autoCreatePolicy` is true, a `BucketPolicy` will be created upon the
first call to addToResourcePolicy(s).

---

##### `database`<sup>Required</sup> <a name="database" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.property.database"></a>

```typescript
public readonly database: Database;
```

- *Type:* cdk-extensions.glue.Database

---

##### `table`<sup>Required</sup> <a name="table" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.property.table"></a>

```typescript
public readonly table: S3AccessLogsTable;
```

- *Type:* cdk-extensions.glue_tables.S3AccessLogsTable

---

##### `createQueries`<sup>Optional</sup> <a name="createQueries" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.property.createQueries"></a>

```typescript
public readonly createQueries: boolean;
```

- *Type:* boolean

---

##### `friendlyQueryNames`<sup>Optional</sup> <a name="friendlyQueryNames" id="cdk-extensions.s3_buckets.S3AccessLogsBucket.property.friendlyQueryNames"></a>

```typescript
public readonly friendlyQueryNames: boolean;
```

- *Type:* boolean

---


### S3AccessLogsTable <a name="S3AccessLogsTable" id="cdk-extensions.glue_tables.S3AccessLogsTable"></a>

#### Initializers <a name="Initializers" id="cdk-extensions.glue_tables.S3AccessLogsTable.Initializer"></a>

```typescript
import { glue_tables } from 'cdk-extensions'

new glue_tables.S3AccessLogsTable(scope: Construct, id: string, props: S3AccessLogsTableProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTable.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | A CDK Construct that will serve as this stack's parent in the construct tree. |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTable.Initializer.parameter.id">id</a></code> | <code>string</code> | A name to be associated with the stack and used in resource naming. |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTable.Initializer.parameter.props">props</a></code> | <code>cdk-extensions.glue_tables.S3AccessLogsTableProps</code> | Arguments related to the configuration of the resource. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.glue_tables.S3AccessLogsTable.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

A CDK Construct that will serve as this stack's parent in the construct tree.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.glue_tables.S3AccessLogsTable.Initializer.parameter.id"></a>

- *Type:* string

A name to be associated with the stack and used in resource naming.

Must be unique
within the context of 'scope'.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk-extensions.glue_tables.S3AccessLogsTable.Initializer.parameter.props"></a>

- *Type:* cdk-extensions.glue_tables.S3AccessLogsTableProps

Arguments related to the configuration of the resource.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTable.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTable.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTable.addColumn">addColumn</a></code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTable.addParameter">addParameter</a></code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTable.addPartitionKey">addPartitionKey</a></code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTable.addSerdeParameter">addSerdeParameter</a></code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTable.addStorageParameter">addStorageParameter</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="cdk-extensions.glue_tables.S3AccessLogsTable.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="cdk-extensions.glue_tables.S3AccessLogsTable.applyRemovalPolicy"></a>

```typescript
public applyRemovalPolicy(policy: RemovalPolicy): void
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="cdk-extensions.glue_tables.S3AccessLogsTable.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.RemovalPolicy

---

##### `addColumn` <a name="addColumn" id="cdk-extensions.glue_tables.S3AccessLogsTable.addColumn"></a>

```typescript
public addColumn(column: Column): void
```

###### `column`<sup>Required</sup> <a name="column" id="cdk-extensions.glue_tables.S3AccessLogsTable.addColumn.parameter.column"></a>

- *Type:* cdk-extensions.glue.Column

---

##### `addParameter` <a name="addParameter" id="cdk-extensions.glue_tables.S3AccessLogsTable.addParameter"></a>

```typescript
public addParameter(key: string, value: string): void
```

###### `key`<sup>Required</sup> <a name="key" id="cdk-extensions.glue_tables.S3AccessLogsTable.addParameter.parameter.key"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="cdk-extensions.glue_tables.S3AccessLogsTable.addParameter.parameter.value"></a>

- *Type:* string

---

##### `addPartitionKey` <a name="addPartitionKey" id="cdk-extensions.glue_tables.S3AccessLogsTable.addPartitionKey"></a>

```typescript
public addPartitionKey(column: Column): void
```

###### `column`<sup>Required</sup> <a name="column" id="cdk-extensions.glue_tables.S3AccessLogsTable.addPartitionKey.parameter.column"></a>

- *Type:* cdk-extensions.glue.Column

---

##### `addSerdeParameter` <a name="addSerdeParameter" id="cdk-extensions.glue_tables.S3AccessLogsTable.addSerdeParameter"></a>

```typescript
public addSerdeParameter(key: string, value: string): void
```

###### `key`<sup>Required</sup> <a name="key" id="cdk-extensions.glue_tables.S3AccessLogsTable.addSerdeParameter.parameter.key"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="cdk-extensions.glue_tables.S3AccessLogsTable.addSerdeParameter.parameter.value"></a>

- *Type:* string

---

##### `addStorageParameter` <a name="addStorageParameter" id="cdk-extensions.glue_tables.S3AccessLogsTable.addStorageParameter"></a>

```typescript
public addStorageParameter(key: string, value: string): void
```

###### `key`<sup>Required</sup> <a name="key" id="cdk-extensions.glue_tables.S3AccessLogsTable.addStorageParameter.parameter.key"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="cdk-extensions.glue_tables.S3AccessLogsTable.addStorageParameter.parameter.value"></a>

- *Type:* string

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTable.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTable.isOwnedResource">isOwnedResource</a></code> | Returns true if the construct was created by CDK, and false otherwise. |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTable.isResource">isResource</a></code> | Check whether the given construct is a Resource. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-extensions.glue_tables.S3AccessLogsTable.isConstruct"></a>

```typescript
import { glue_tables } from 'cdk-extensions'

glue_tables.S3AccessLogsTable.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-extensions.glue_tables.S3AccessLogsTable.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isOwnedResource` <a name="isOwnedResource" id="cdk-extensions.glue_tables.S3AccessLogsTable.isOwnedResource"></a>

```typescript
import { glue_tables } from 'cdk-extensions'

glue_tables.S3AccessLogsTable.isOwnedResource(construct: IConstruct)
```

Returns true if the construct was created by CDK, and false otherwise.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.glue_tables.S3AccessLogsTable.isOwnedResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `isResource` <a name="isResource" id="cdk-extensions.glue_tables.S3AccessLogsTable.isResource"></a>

```typescript
import { glue_tables } from 'cdk-extensions'

glue_tables.S3AccessLogsTable.isResource(construct: IConstruct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.glue_tables.S3AccessLogsTable.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTable.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTable.property.env">env</a></code> | <code>aws-cdk-lib.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTable.property.stack">stack</a></code> | <code>aws-cdk-lib.Stack</code> | The stack in which this resource is defined. |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTable.property.database">database</a></code> | <code>cdk-extensions.glue.Database</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTable.property.resource">resource</a></code> | <code>aws-cdk-lib.aws_glue.CfnTable</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTable.property.tableArn">tableArn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTable.property.tableName">tableName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTable.property.compressed">compressed</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTable.property.dataFormat">dataFormat</a></code> | <code>cdk-extensions.glue.DataFormat</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTable.property.description">description</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTable.property.location">location</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTable.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTable.property.owner">owner</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTable.property.retention">retention</a></code> | <code>aws-cdk-lib.Duration</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTable.property.serdeName">serdeName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTable.property.storedAsSubDirectories">storedAsSubDirectories</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTable.property.tableType">tableType</a></code> | <code>cdk-extensions.glue.TableType</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTable.property.targetTable">targetTable</a></code> | <code>cdk-extensions.glue.Table</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTable.property.viewExpandedText">viewExpandedText</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTable.property.viewOriginalText">viewOriginalText</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTable.property.createQueries">createQueries</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTable.property.friendlyQueryNames">friendlyQueryNames</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTable.property.requestErrorsNamedQuery">requestErrorsNamedQuery</a></code> | <code>cdk-extensions.athena.NamedQuery</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-extensions.glue_tables.S3AccessLogsTable.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="cdk-extensions.glue_tables.S3AccessLogsTable.property.env"></a>

```typescript
public readonly env: ResourceEnvironment;
```

- *Type:* aws-cdk-lib.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="cdk-extensions.glue_tables.S3AccessLogsTable.property.stack"></a>

```typescript
public readonly stack: Stack;
```

- *Type:* aws-cdk-lib.Stack

The stack in which this resource is defined.

---

##### `database`<sup>Required</sup> <a name="database" id="cdk-extensions.glue_tables.S3AccessLogsTable.property.database"></a>

```typescript
public readonly database: Database;
```

- *Type:* cdk-extensions.glue.Database

---

##### `resource`<sup>Required</sup> <a name="resource" id="cdk-extensions.glue_tables.S3AccessLogsTable.property.resource"></a>

```typescript
public readonly resource: CfnTable;
```

- *Type:* aws-cdk-lib.aws_glue.CfnTable

---

##### `tableArn`<sup>Required</sup> <a name="tableArn" id="cdk-extensions.glue_tables.S3AccessLogsTable.property.tableArn"></a>

```typescript
public readonly tableArn: string;
```

- *Type:* string

---

##### `tableName`<sup>Required</sup> <a name="tableName" id="cdk-extensions.glue_tables.S3AccessLogsTable.property.tableName"></a>

```typescript
public readonly tableName: string;
```

- *Type:* string

---

##### `compressed`<sup>Optional</sup> <a name="compressed" id="cdk-extensions.glue_tables.S3AccessLogsTable.property.compressed"></a>

```typescript
public readonly compressed: boolean;
```

- *Type:* boolean

---

##### `dataFormat`<sup>Optional</sup> <a name="dataFormat" id="cdk-extensions.glue_tables.S3AccessLogsTable.property.dataFormat"></a>

```typescript
public readonly dataFormat: DataFormat;
```

- *Type:* cdk-extensions.glue.DataFormat

---

##### `description`<sup>Optional</sup> <a name="description" id="cdk-extensions.glue_tables.S3AccessLogsTable.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

---

##### `location`<sup>Optional</sup> <a name="location" id="cdk-extensions.glue_tables.S3AccessLogsTable.property.location"></a>

```typescript
public readonly location: string;
```

- *Type:* string

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.glue_tables.S3AccessLogsTable.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `owner`<sup>Optional</sup> <a name="owner" id="cdk-extensions.glue_tables.S3AccessLogsTable.property.owner"></a>

```typescript
public readonly owner: string;
```

- *Type:* string

---

##### `retention`<sup>Optional</sup> <a name="retention" id="cdk-extensions.glue_tables.S3AccessLogsTable.property.retention"></a>

```typescript
public readonly retention: Duration;
```

- *Type:* aws-cdk-lib.Duration

---

##### `serdeName`<sup>Optional</sup> <a name="serdeName" id="cdk-extensions.glue_tables.S3AccessLogsTable.property.serdeName"></a>

```typescript
public readonly serdeName: string;
```

- *Type:* string

---

##### `storedAsSubDirectories`<sup>Optional</sup> <a name="storedAsSubDirectories" id="cdk-extensions.glue_tables.S3AccessLogsTable.property.storedAsSubDirectories"></a>

```typescript
public readonly storedAsSubDirectories: boolean;
```

- *Type:* boolean

---

##### `tableType`<sup>Optional</sup> <a name="tableType" id="cdk-extensions.glue_tables.S3AccessLogsTable.property.tableType"></a>

```typescript
public readonly tableType: TableType;
```

- *Type:* cdk-extensions.glue.TableType

---

##### `targetTable`<sup>Optional</sup> <a name="targetTable" id="cdk-extensions.glue_tables.S3AccessLogsTable.property.targetTable"></a>

```typescript
public readonly targetTable: Table;
```

- *Type:* cdk-extensions.glue.Table

---

##### `viewExpandedText`<sup>Optional</sup> <a name="viewExpandedText" id="cdk-extensions.glue_tables.S3AccessLogsTable.property.viewExpandedText"></a>

```typescript
public readonly viewExpandedText: string;
```

- *Type:* string

---

##### `viewOriginalText`<sup>Optional</sup> <a name="viewOriginalText" id="cdk-extensions.glue_tables.S3AccessLogsTable.property.viewOriginalText"></a>

```typescript
public readonly viewOriginalText: string;
```

- *Type:* string

---

##### `createQueries`<sup>Required</sup> <a name="createQueries" id="cdk-extensions.glue_tables.S3AccessLogsTable.property.createQueries"></a>

```typescript
public readonly createQueries: boolean;
```

- *Type:* boolean

---

##### `friendlyQueryNames`<sup>Required</sup> <a name="friendlyQueryNames" id="cdk-extensions.glue_tables.S3AccessLogsTable.property.friendlyQueryNames"></a>

```typescript
public readonly friendlyQueryNames: boolean;
```

- *Type:* boolean

---

##### `requestErrorsNamedQuery`<sup>Optional</sup> <a name="requestErrorsNamedQuery" id="cdk-extensions.glue_tables.S3AccessLogsTable.property.requestErrorsNamedQuery"></a>

```typescript
public readonly requestErrorsNamedQuery: NamedQuery;
```

- *Type:* cdk-extensions.athena.NamedQuery

---


### SecurityConfiguration <a name="SecurityConfiguration" id="cdk-extensions.glue.SecurityConfiguration"></a>

#### Initializers <a name="Initializers" id="cdk-extensions.glue.SecurityConfiguration.Initializer"></a>

```typescript
import { glue } from 'cdk-extensions'

new glue.SecurityConfiguration(scope: Construct, id: string, props: SecurityConfigurationProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.SecurityConfiguration.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.SecurityConfiguration.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.SecurityConfiguration.Initializer.parameter.props">props</a></code> | <code>cdk-extensions.glue.SecurityConfigurationProps</code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.glue.SecurityConfiguration.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.glue.SecurityConfiguration.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="cdk-extensions.glue.SecurityConfiguration.Initializer.parameter.props"></a>

- *Type:* cdk-extensions.glue.SecurityConfigurationProps

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.glue.SecurityConfiguration.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-extensions.glue.SecurityConfiguration.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |

---

##### `toString` <a name="toString" id="cdk-extensions.glue.SecurityConfiguration.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="cdk-extensions.glue.SecurityConfiguration.applyRemovalPolicy"></a>

```typescript
public applyRemovalPolicy(policy: RemovalPolicy): void
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="cdk-extensions.glue.SecurityConfiguration.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.RemovalPolicy

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.glue.SecurityConfiguration.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-extensions.glue.SecurityConfiguration.isOwnedResource">isOwnedResource</a></code> | Returns true if the construct was created by CDK, and false otherwise. |
| <code><a href="#cdk-extensions.glue.SecurityConfiguration.isResource">isResource</a></code> | Check whether the given construct is a Resource. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-extensions.glue.SecurityConfiguration.isConstruct"></a>

```typescript
import { glue } from 'cdk-extensions'

glue.SecurityConfiguration.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-extensions.glue.SecurityConfiguration.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isOwnedResource` <a name="isOwnedResource" id="cdk-extensions.glue.SecurityConfiguration.isOwnedResource"></a>

```typescript
import { glue } from 'cdk-extensions'

glue.SecurityConfiguration.isOwnedResource(construct: IConstruct)
```

Returns true if the construct was created by CDK, and false otherwise.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.glue.SecurityConfiguration.isOwnedResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `isResource` <a name="isResource" id="cdk-extensions.glue.SecurityConfiguration.isResource"></a>

```typescript
import { glue } from 'cdk-extensions'

glue.SecurityConfiguration.isResource(construct: IConstruct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.glue.SecurityConfiguration.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.SecurityConfiguration.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-extensions.glue.SecurityConfiguration.property.env">env</a></code> | <code>aws-cdk-lib.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#cdk-extensions.glue.SecurityConfiguration.property.stack">stack</a></code> | <code>aws-cdk-lib.Stack</code> | The stack in which this resource is defined. |
| <code><a href="#cdk-extensions.glue.SecurityConfiguration.property.key">key</a></code> | <code>aws-cdk-lib.aws_kms.Key</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.SecurityConfiguration.property.resource">resource</a></code> | <code>aws-cdk-lib.aws_glue.CfnSecurityConfiguration</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.SecurityConfiguration.property.securityConfigurationName">securityConfigurationName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.SecurityConfiguration.property.cloudWatchEncryption">cloudWatchEncryption</a></code> | <code>cdk-extensions.glue.CloudWatchEncryption</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.SecurityConfiguration.property.jobBookmarksEncryption">jobBookmarksEncryption</a></code> | <code>cdk-extensions.glue.JobBookmarksEncryption</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.SecurityConfiguration.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.SecurityConfiguration.property.s3Encryption">s3Encryption</a></code> | <code>cdk-extensions.glue.S3Encryption</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-extensions.glue.SecurityConfiguration.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="cdk-extensions.glue.SecurityConfiguration.property.env"></a>

```typescript
public readonly env: ResourceEnvironment;
```

- *Type:* aws-cdk-lib.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="cdk-extensions.glue.SecurityConfiguration.property.stack"></a>

```typescript
public readonly stack: Stack;
```

- *Type:* aws-cdk-lib.Stack

The stack in which this resource is defined.

---

##### `key`<sup>Required</sup> <a name="key" id="cdk-extensions.glue.SecurityConfiguration.property.key"></a>

```typescript
public readonly key: Key;
```

- *Type:* aws-cdk-lib.aws_kms.Key

---

##### `resource`<sup>Required</sup> <a name="resource" id="cdk-extensions.glue.SecurityConfiguration.property.resource"></a>

```typescript
public readonly resource: CfnSecurityConfiguration;
```

- *Type:* aws-cdk-lib.aws_glue.CfnSecurityConfiguration

---

##### `securityConfigurationName`<sup>Required</sup> <a name="securityConfigurationName" id="cdk-extensions.glue.SecurityConfiguration.property.securityConfigurationName"></a>

```typescript
public readonly securityConfigurationName: string;
```

- *Type:* string

---

##### `cloudWatchEncryption`<sup>Optional</sup> <a name="cloudWatchEncryption" id="cdk-extensions.glue.SecurityConfiguration.property.cloudWatchEncryption"></a>

```typescript
public readonly cloudWatchEncryption: CloudWatchEncryption;
```

- *Type:* cdk-extensions.glue.CloudWatchEncryption

---

##### `jobBookmarksEncryption`<sup>Optional</sup> <a name="jobBookmarksEncryption" id="cdk-extensions.glue.SecurityConfiguration.property.jobBookmarksEncryption"></a>

```typescript
public readonly jobBookmarksEncryption: JobBookmarksEncryption;
```

- *Type:* cdk-extensions.glue.JobBookmarksEncryption

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.glue.SecurityConfiguration.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `s3Encryption`<sup>Optional</sup> <a name="s3Encryption" id="cdk-extensions.glue.SecurityConfiguration.property.s3Encryption"></a>

```typescript
public readonly s3Encryption: S3Encryption;
```

- *Type:* cdk-extensions.glue.S3Encryption

---


### SesLogsBucket <a name="SesLogsBucket" id="cdk-extensions.s3_buckets.SesLogsBucket"></a>

#### Initializers <a name="Initializers" id="cdk-extensions.s3_buckets.SesLogsBucket.Initializer"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

new s3_buckets.SesLogsBucket(scope: Construct, id: string, props?: SesLogsBucketProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | A CDK Construct that will serve as this stack's parent in the construct tree. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.Initializer.parameter.id">id</a></code> | <code>string</code> | A name to be associated with the stack and used in resource naming. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.Initializer.parameter.props">props</a></code> | <code>cdk-extensions.s3_buckets.SesLogsBucketProps</code> | Arguments related to the configuration of the resource. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.s3_buckets.SesLogsBucket.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

A CDK Construct that will serve as this stack's parent in the construct tree.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.s3_buckets.SesLogsBucket.Initializer.parameter.id"></a>

- *Type:* string

A name to be associated with the stack and used in resource naming.

Must be unique
within the context of 'scope'.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk-extensions.s3_buckets.SesLogsBucket.Initializer.parameter.props"></a>

- *Type:* cdk-extensions.s3_buckets.SesLogsBucketProps

Arguments related to the configuration of the resource.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.addEventNotification">addEventNotification</a></code> | Adds a bucket notification event destination. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.addObjectCreatedNotification">addObjectCreatedNotification</a></code> | Subscribes a destination to receive notifications when an object is created in the bucket. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.addObjectRemovedNotification">addObjectRemovedNotification</a></code> | Subscribes a destination to receive notifications when an object is removed from the bucket. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.addToResourcePolicy">addToResourcePolicy</a></code> | Adds a statement to the resource policy for a principal (i.e. account/role/service) to perform actions on this bucket and/or its contents. Use `bucketArn` and `arnForObjects(keys)` to obtain ARNs for this bucket or objects. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.arnForObjects">arnForObjects</a></code> | Returns an ARN that represents all objects within the bucket that match the key pattern specified. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.enableEventBridgeNotification">enableEventBridgeNotification</a></code> | Enables event bridge notification, causing all events below to be sent to EventBridge:. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.grantDelete">grantDelete</a></code> | Grants s3:DeleteObject* permission to an IAM principal for objects in this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.grantPublicAccess">grantPublicAccess</a></code> | Allows unrestricted access to objects from this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.grantPut">grantPut</a></code> | Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.grantPutAcl">grantPutAcl</a></code> | Grant the given IAM identity permissions to modify the ACLs of objects in the given Bucket. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.grantRead">grantRead</a></code> | Grant read permissions for this bucket and it's contents to an IAM principal (Role/Group/User). |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.grantReadWrite">grantReadWrite</a></code> | Grants read/write permissions for this bucket and it's contents to an IAM principal (Role/Group/User). |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.grantWrite">grantWrite</a></code> | Grant write permissions to this bucket to an IAM principal. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.onCloudTrailEvent">onCloudTrailEvent</a></code> | Defines a CloudWatch event that triggers when something happens to this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.onCloudTrailPutObject">onCloudTrailPutObject</a></code> | Defines an AWS CloudWatch event that triggers when an object is uploaded to the specified paths (keys) in this bucket using the PutObject API call. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.onCloudTrailWriteObject">onCloudTrailWriteObject</a></code> | Defines an AWS CloudWatch event that triggers when an object at the specified paths (keys) in this bucket are written to. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.s3UrlForObject">s3UrlForObject</a></code> | The S3 URL of an S3 object. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.transferAccelerationUrlForObject">transferAccelerationUrlForObject</a></code> | The https Transfer Acceleration URL of an S3 object. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.urlForObject">urlForObject</a></code> | The https URL of an S3 object. For example:. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.virtualHostedUrlForObject">virtualHostedUrlForObject</a></code> | The virtual hosted-style URL of an S3 object. Specify `regional: false` at the options for non-regional URL. For example:. |

---

##### `toString` <a name="toString" id="cdk-extensions.s3_buckets.SesLogsBucket.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="cdk-extensions.s3_buckets.SesLogsBucket.applyRemovalPolicy"></a>

```typescript
public applyRemovalPolicy(policy: RemovalPolicy): void
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="cdk-extensions.s3_buckets.SesLogsBucket.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.RemovalPolicy

---

##### `addEventNotification` <a name="addEventNotification" id="cdk-extensions.s3_buckets.SesLogsBucket.addEventNotification"></a>

```typescript
public addEventNotification(_event: EventType, _dest: IBucketNotificationDestination, _filters: NotificationKeyFilter): void
```

Adds a bucket notification event destination.

###### `_event`<sup>Required</sup> <a name="_event" id="cdk-extensions.s3_buckets.SesLogsBucket.addEventNotification.parameter._event"></a>

- *Type:* aws-cdk-lib.aws_s3.EventType

---

###### `_dest`<sup>Required</sup> <a name="_dest" id="cdk-extensions.s3_buckets.SesLogsBucket.addEventNotification.parameter._dest"></a>

- *Type:* aws-cdk-lib.aws_s3.IBucketNotificationDestination

---

###### `_filters`<sup>Required</sup> <a name="_filters" id="cdk-extensions.s3_buckets.SesLogsBucket.addEventNotification.parameter._filters"></a>

- *Type:* aws-cdk-lib.aws_s3.NotificationKeyFilter

---

##### `addObjectCreatedNotification` <a name="addObjectCreatedNotification" id="cdk-extensions.s3_buckets.SesLogsBucket.addObjectCreatedNotification"></a>

```typescript
public addObjectCreatedNotification(_dest: IBucketNotificationDestination, _filters: NotificationKeyFilter): void
```

Subscribes a destination to receive notifications when an object is created in the bucket.

This is identical to calling
`onEvent(s3.EventType.OBJECT_CREATED)`.

###### `_dest`<sup>Required</sup> <a name="_dest" id="cdk-extensions.s3_buckets.SesLogsBucket.addObjectCreatedNotification.parameter._dest"></a>

- *Type:* aws-cdk-lib.aws_s3.IBucketNotificationDestination

---

###### `_filters`<sup>Required</sup> <a name="_filters" id="cdk-extensions.s3_buckets.SesLogsBucket.addObjectCreatedNotification.parameter._filters"></a>

- *Type:* aws-cdk-lib.aws_s3.NotificationKeyFilter

---

##### `addObjectRemovedNotification` <a name="addObjectRemovedNotification" id="cdk-extensions.s3_buckets.SesLogsBucket.addObjectRemovedNotification"></a>

```typescript
public addObjectRemovedNotification(_dest: IBucketNotificationDestination, _filters: NotificationKeyFilter): void
```

Subscribes a destination to receive notifications when an object is removed from the bucket.

This is identical to calling
`onEvent(EventType.OBJECT_REMOVED)`.

###### `_dest`<sup>Required</sup> <a name="_dest" id="cdk-extensions.s3_buckets.SesLogsBucket.addObjectRemovedNotification.parameter._dest"></a>

- *Type:* aws-cdk-lib.aws_s3.IBucketNotificationDestination

---

###### `_filters`<sup>Required</sup> <a name="_filters" id="cdk-extensions.s3_buckets.SesLogsBucket.addObjectRemovedNotification.parameter._filters"></a>

- *Type:* aws-cdk-lib.aws_s3.NotificationKeyFilter

---

##### `addToResourcePolicy` <a name="addToResourcePolicy" id="cdk-extensions.s3_buckets.SesLogsBucket.addToResourcePolicy"></a>

```typescript
public addToResourcePolicy(permission: PolicyStatement): AddToResourcePolicyResult
```

Adds a statement to the resource policy for a principal (i.e. account/role/service) to perform actions on this bucket and/or its contents. Use `bucketArn` and `arnForObjects(keys)` to obtain ARNs for this bucket or objects.

Note that the policy statement may or may not be added to the policy.
For example, when an `IBucket` is created from an existing bucket,
it's not possible to tell whether the bucket already has a policy
attached, let alone to re-use that policy to add more statements to it.
So it's safest to do nothing in these cases.

###### `permission`<sup>Required</sup> <a name="permission" id="cdk-extensions.s3_buckets.SesLogsBucket.addToResourcePolicy.parameter.permission"></a>

- *Type:* aws-cdk-lib.aws_iam.PolicyStatement

---

##### `arnForObjects` <a name="arnForObjects" id="cdk-extensions.s3_buckets.SesLogsBucket.arnForObjects"></a>

```typescript
public arnForObjects(_keyPattern: string): string
```

Returns an ARN that represents all objects within the bucket that match the key pattern specified.

To represent all keys, specify ``"*"``.

###### `_keyPattern`<sup>Required</sup> <a name="_keyPattern" id="cdk-extensions.s3_buckets.SesLogsBucket.arnForObjects.parameter._keyPattern"></a>

- *Type:* string

---

##### `enableEventBridgeNotification` <a name="enableEventBridgeNotification" id="cdk-extensions.s3_buckets.SesLogsBucket.enableEventBridgeNotification"></a>

```typescript
public enableEventBridgeNotification(): void
```

Enables event bridge notification, causing all events below to be sent to EventBridge:.

Object Deleted (DeleteObject)
- Object Deleted (Lifecycle expiration)
- Object Restore Initiated
- Object Restore Completed
- Object Restore Expired
- Object Storage Class Changed
- Object Access Tier Changed
- Object ACL Updated
- Object Tags Added
- Object Tags Deleted

##### `grantDelete` <a name="grantDelete" id="cdk-extensions.s3_buckets.SesLogsBucket.grantDelete"></a>

```typescript
public grantDelete(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grants s3:DeleteObject* permission to an IAM principal for objects in this bucket.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.SesLogsBucket.grantDelete.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.SesLogsBucket.grantDelete.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `grantPublicAccess` <a name="grantPublicAccess" id="cdk-extensions.s3_buckets.SesLogsBucket.grantPublicAccess"></a>

```typescript
public grantPublicAccess(_allowedActions: string, _keyPrefix?: string): Grant
```

Allows unrestricted access to objects from this bucket.

IMPORTANT: This permission allows anyone to perform actions on S3 objects
in this bucket, which is useful for when you configure your bucket as a
website and want everyone to be able to read objects in the bucket without
needing to authenticate.

Without arguments, this method will grant read ("s3:GetObject") access to
all objects ("*") in the bucket.

The method returns the `iam.Grant` object, which can then be modified
as needed. For example, you can add a condition that will restrict access only
to an IPv4 range like this:

     const grant = bucket.grantPublicAccess();
     grant.resourceStatement!.addCondition(‘IpAddress’, { “aws:SourceIp”: “54.240.143.0/24” });

###### `_allowedActions`<sup>Required</sup> <a name="_allowedActions" id="cdk-extensions.s3_buckets.SesLogsBucket.grantPublicAccess.parameter._allowedActions"></a>

- *Type:* string

---

###### `_keyPrefix`<sup>Optional</sup> <a name="_keyPrefix" id="cdk-extensions.s3_buckets.SesLogsBucket.grantPublicAccess.parameter._keyPrefix"></a>

- *Type:* string

---

##### `grantPut` <a name="grantPut" id="cdk-extensions.s3_buckets.SesLogsBucket.grantPut"></a>

```typescript
public grantPut(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal.

If encryption is used, permission to use the key to encrypt the contents
of written files will also be granted to the same principal.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.SesLogsBucket.grantPut.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.SesLogsBucket.grantPut.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `grantPutAcl` <a name="grantPutAcl" id="cdk-extensions.s3_buckets.SesLogsBucket.grantPutAcl"></a>

```typescript
public grantPutAcl(_identity: IGrantable, _objectsKeyPattern?: string): Grant
```

Grant the given IAM identity permissions to modify the ACLs of objects in the given Bucket.

If your application has the '@aws-cdk/aws-s3:grantWriteWithoutAcl' feature flag set,
calling {@link grantWrite} or {@link grantReadWrite} no longer grants permissions to modify the ACLs of the objects;
in this case, if you need to modify object ACLs, call this method explicitly.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.SesLogsBucket.grantPutAcl.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.SesLogsBucket.grantPutAcl.parameter._objectsKeyPattern"></a>

- *Type:* string

---

##### `grantRead` <a name="grantRead" id="cdk-extensions.s3_buckets.SesLogsBucket.grantRead"></a>

```typescript
public grantRead(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grant read permissions for this bucket and it's contents to an IAM principal (Role/Group/User).

If encryption is used, permission to use the key to decrypt the contents
of the bucket will also be granted to the same principal.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.SesLogsBucket.grantRead.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.SesLogsBucket.grantRead.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `grantReadWrite` <a name="grantReadWrite" id="cdk-extensions.s3_buckets.SesLogsBucket.grantReadWrite"></a>

```typescript
public grantReadWrite(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grants read/write permissions for this bucket and it's contents to an IAM principal (Role/Group/User).

If an encryption key is used, permission to use the key for
encrypt/decrypt will also be granted.

Before CDK version 1.85.0, this method granted the `s3:PutObject*` permission that included `s3:PutObjectAcl`,
which could be used to grant read/write object access to IAM principals in other accounts.
If you want to get rid of that behavior, update your CDK version to 1.85.0 or later,
and make sure the `@aws-cdk/aws-s3:grantWriteWithoutAcl` feature flag is set to `true`
in the `context` key of your cdk.json file.
If you've already updated, but still need the principal to have permissions to modify the ACLs,
use the {@link grantPutAcl} method.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.SesLogsBucket.grantReadWrite.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.SesLogsBucket.grantReadWrite.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `grantWrite` <a name="grantWrite" id="cdk-extensions.s3_buckets.SesLogsBucket.grantWrite"></a>

```typescript
public grantWrite(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grant write permissions to this bucket to an IAM principal.

If encryption is used, permission to use the key to encrypt the contents
of written files will also be granted to the same principal.

Before CDK version 1.85.0, this method granted the `s3:PutObject*` permission that included `s3:PutObjectAcl`,
which could be used to grant read/write object access to IAM principals in other accounts.
If you want to get rid of that behavior, update your CDK version to 1.85.0 or later,
and make sure the `@aws-cdk/aws-s3:grantWriteWithoutAcl` feature flag is set to `true`
in the `context` key of your cdk.json file.
If you've already updated, but still need the principal to have permissions to modify the ACLs,
use the {@link grantPutAcl} method.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.SesLogsBucket.grantWrite.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.SesLogsBucket.grantWrite.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `onCloudTrailEvent` <a name="onCloudTrailEvent" id="cdk-extensions.s3_buckets.SesLogsBucket.onCloudTrailEvent"></a>

```typescript
public onCloudTrailEvent(_id: string, _options?: OnCloudTrailBucketEventOptions): Rule
```

Defines a CloudWatch event that triggers when something happens to this bucket.

Requires that there exists at least one CloudTrail Trail in your account
that captures the event. This method will not create the Trail.

###### `_id`<sup>Required</sup> <a name="_id" id="cdk-extensions.s3_buckets.SesLogsBucket.onCloudTrailEvent.parameter._id"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.SesLogsBucket.onCloudTrailEvent.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.OnCloudTrailBucketEventOptions

---

##### `onCloudTrailPutObject` <a name="onCloudTrailPutObject" id="cdk-extensions.s3_buckets.SesLogsBucket.onCloudTrailPutObject"></a>

```typescript
public onCloudTrailPutObject(_id: string, _options?: OnCloudTrailBucketEventOptions): Rule
```

Defines an AWS CloudWatch event that triggers when an object is uploaded to the specified paths (keys) in this bucket using the PutObject API call.

Note that some tools like `aws s3 cp` will automatically use either
PutObject or the multipart upload API depending on the file size,
so using `onCloudTrailWriteObject` may be preferable.

Requires that there exists at least one CloudTrail Trail in your account
that captures the event. This method will not create the Trail.

###### `_id`<sup>Required</sup> <a name="_id" id="cdk-extensions.s3_buckets.SesLogsBucket.onCloudTrailPutObject.parameter._id"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.SesLogsBucket.onCloudTrailPutObject.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.OnCloudTrailBucketEventOptions

---

##### `onCloudTrailWriteObject` <a name="onCloudTrailWriteObject" id="cdk-extensions.s3_buckets.SesLogsBucket.onCloudTrailWriteObject"></a>

```typescript
public onCloudTrailWriteObject(_id: string, _options?: OnCloudTrailBucketEventOptions): Rule
```

Defines an AWS CloudWatch event that triggers when an object at the specified paths (keys) in this bucket are written to.

This includes
the events PutObject, CopyObject, and CompleteMultipartUpload.

Note that some tools like `aws s3 cp` will automatically use either
PutObject or the multipart upload API depending on the file size,
so using this method may be preferable to `onCloudTrailPutObject`.

Requires that there exists at least one CloudTrail Trail in your account
that captures the event. This method will not create the Trail.

###### `_id`<sup>Required</sup> <a name="_id" id="cdk-extensions.s3_buckets.SesLogsBucket.onCloudTrailWriteObject.parameter._id"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.SesLogsBucket.onCloudTrailWriteObject.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.OnCloudTrailBucketEventOptions

---

##### `s3UrlForObject` <a name="s3UrlForObject" id="cdk-extensions.s3_buckets.SesLogsBucket.s3UrlForObject"></a>

```typescript
public s3UrlForObject(_key?: string): string
```

The S3 URL of an S3 object.

For example:
- `s3://onlybucket`
- `s3://bucket/key`

###### `_key`<sup>Optional</sup> <a name="_key" id="cdk-extensions.s3_buckets.SesLogsBucket.s3UrlForObject.parameter._key"></a>

- *Type:* string

---

##### `transferAccelerationUrlForObject` <a name="transferAccelerationUrlForObject" id="cdk-extensions.s3_buckets.SesLogsBucket.transferAccelerationUrlForObject"></a>

```typescript
public transferAccelerationUrlForObject(_key?: string, _options?: TransferAccelerationUrlOptions): string
```

The https Transfer Acceleration URL of an S3 object.

Specify `dualStack: true` at the options
for dual-stack endpoint (connect to the bucket over IPv6). For example:

- `https://bucket.s3-accelerate.amazonaws.com`
- `https://bucket.s3-accelerate.amazonaws.com/key`

###### `_key`<sup>Optional</sup> <a name="_key" id="cdk-extensions.s3_buckets.SesLogsBucket.transferAccelerationUrlForObject.parameter._key"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.SesLogsBucket.transferAccelerationUrlForObject.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.TransferAccelerationUrlOptions

---

##### `urlForObject` <a name="urlForObject" id="cdk-extensions.s3_buckets.SesLogsBucket.urlForObject"></a>

```typescript
public urlForObject(_key?: string): string
```

The https URL of an S3 object. For example:.

`https://s3.us-west-1.amazonaws.com/onlybucket`
- `https://s3.us-west-1.amazonaws.com/bucket/key`
- `https://s3.cn-north-1.amazonaws.com.cn/china-bucket/mykey`

###### `_key`<sup>Optional</sup> <a name="_key" id="cdk-extensions.s3_buckets.SesLogsBucket.urlForObject.parameter._key"></a>

- *Type:* string

---

##### `virtualHostedUrlForObject` <a name="virtualHostedUrlForObject" id="cdk-extensions.s3_buckets.SesLogsBucket.virtualHostedUrlForObject"></a>

```typescript
public virtualHostedUrlForObject(_key?: string, _options?: VirtualHostedStyleUrlOptions): string
```

The virtual hosted-style URL of an S3 object. Specify `regional: false` at the options for non-regional URL. For example:.

`https://only-bucket.s3.us-west-1.amazonaws.com`
- `https://bucket.s3.us-west-1.amazonaws.com/key`
- `https://bucket.s3.amazonaws.com/key`
- `https://china-bucket.s3.cn-north-1.amazonaws.com.cn/mykey`

###### `_key`<sup>Optional</sup> <a name="_key" id="cdk-extensions.s3_buckets.SesLogsBucket.virtualHostedUrlForObject.parameter._key"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.SesLogsBucket.virtualHostedUrlForObject.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.VirtualHostedStyleUrlOptions

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.isOwnedResource">isOwnedResource</a></code> | Returns true if the construct was created by CDK, and false otherwise. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.isResource">isResource</a></code> | Check whether the given construct is a Resource. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-extensions.s3_buckets.SesLogsBucket.isConstruct"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

s3_buckets.SesLogsBucket.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-extensions.s3_buckets.SesLogsBucket.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isOwnedResource` <a name="isOwnedResource" id="cdk-extensions.s3_buckets.SesLogsBucket.isOwnedResource"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

s3_buckets.SesLogsBucket.isOwnedResource(construct: IConstruct)
```

Returns true if the construct was created by CDK, and false otherwise.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.s3_buckets.SesLogsBucket.isOwnedResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `isResource` <a name="isResource" id="cdk-extensions.s3_buckets.SesLogsBucket.isResource"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

s3_buckets.SesLogsBucket.isResource(construct: IConstruct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.s3_buckets.SesLogsBucket.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.property.env">env</a></code> | <code>aws-cdk-lib.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.property.stack">stack</a></code> | <code>aws-cdk-lib.Stack</code> | The stack in which this resource is defined. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.property.bucketArn">bucketArn</a></code> | <code>string</code> | The ARN of the bucket. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.property.bucketDomainName">bucketDomainName</a></code> | <code>string</code> | The IPv4 DNS name of the specified bucket. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.property.bucketDualStackDomainName">bucketDualStackDomainName</a></code> | <code>string</code> | The IPv6 DNS name of the specified bucket. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.property.bucketName">bucketName</a></code> | <code>string</code> | The name of the bucket. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.property.bucketRegionalDomainName">bucketRegionalDomainName</a></code> | <code>string</code> | The regional domain name of the specified bucket. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.property.bucketWebsiteDomainName">bucketWebsiteDomainName</a></code> | <code>string</code> | The Domain name of the static website. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.property.bucketWebsiteUrl">bucketWebsiteUrl</a></code> | <code>string</code> | The URL of the static website. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.property.resource">resource</a></code> | <code>aws-cdk-lib.aws_s3.CfnBucket</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.property.encryptionKey">encryptionKey</a></code> | <code>aws-cdk-lib.aws_kms.IKey</code> | Optional KMS encryption key associated with this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.property.isWebsite">isWebsite</a></code> | <code>boolean</code> | If this bucket has been configured for static website hosting. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.property.policy">policy</a></code> | <code>aws-cdk-lib.aws_s3.BucketPolicy</code> | The resource policy associated with this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.property.database">database</a></code> | <code>cdk-extensions.glue.Database</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.property.table">table</a></code> | <code>cdk-extensions.glue_tables.SesLogsTable</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.property.createQueries">createQueries</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucket.property.friendlyQueryNames">friendlyQueryNames</a></code> | <code>boolean</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-extensions.s3_buckets.SesLogsBucket.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="cdk-extensions.s3_buckets.SesLogsBucket.property.env"></a>

```typescript
public readonly env: ResourceEnvironment;
```

- *Type:* aws-cdk-lib.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="cdk-extensions.s3_buckets.SesLogsBucket.property.stack"></a>

```typescript
public readonly stack: Stack;
```

- *Type:* aws-cdk-lib.Stack

The stack in which this resource is defined.

---

##### `bucketArn`<sup>Required</sup> <a name="bucketArn" id="cdk-extensions.s3_buckets.SesLogsBucket.property.bucketArn"></a>

```typescript
public readonly bucketArn: string;
```

- *Type:* string

The ARN of the bucket.

---

##### `bucketDomainName`<sup>Required</sup> <a name="bucketDomainName" id="cdk-extensions.s3_buckets.SesLogsBucket.property.bucketDomainName"></a>

```typescript
public readonly bucketDomainName: string;
```

- *Type:* string

The IPv4 DNS name of the specified bucket.

---

##### `bucketDualStackDomainName`<sup>Required</sup> <a name="bucketDualStackDomainName" id="cdk-extensions.s3_buckets.SesLogsBucket.property.bucketDualStackDomainName"></a>

```typescript
public readonly bucketDualStackDomainName: string;
```

- *Type:* string

The IPv6 DNS name of the specified bucket.

---

##### `bucketName`<sup>Required</sup> <a name="bucketName" id="cdk-extensions.s3_buckets.SesLogsBucket.property.bucketName"></a>

```typescript
public readonly bucketName: string;
```

- *Type:* string

The name of the bucket.

---

##### `bucketRegionalDomainName`<sup>Required</sup> <a name="bucketRegionalDomainName" id="cdk-extensions.s3_buckets.SesLogsBucket.property.bucketRegionalDomainName"></a>

```typescript
public readonly bucketRegionalDomainName: string;
```

- *Type:* string

The regional domain name of the specified bucket.

---

##### `bucketWebsiteDomainName`<sup>Required</sup> <a name="bucketWebsiteDomainName" id="cdk-extensions.s3_buckets.SesLogsBucket.property.bucketWebsiteDomainName"></a>

```typescript
public readonly bucketWebsiteDomainName: string;
```

- *Type:* string

The Domain name of the static website.

---

##### `bucketWebsiteUrl`<sup>Required</sup> <a name="bucketWebsiteUrl" id="cdk-extensions.s3_buckets.SesLogsBucket.property.bucketWebsiteUrl"></a>

```typescript
public readonly bucketWebsiteUrl: string;
```

- *Type:* string

The URL of the static website.

---

##### `resource`<sup>Required</sup> <a name="resource" id="cdk-extensions.s3_buckets.SesLogsBucket.property.resource"></a>

```typescript
public readonly resource: CfnBucket;
```

- *Type:* aws-cdk-lib.aws_s3.CfnBucket

---

##### `encryptionKey`<sup>Optional</sup> <a name="encryptionKey" id="cdk-extensions.s3_buckets.SesLogsBucket.property.encryptionKey"></a>

```typescript
public readonly encryptionKey: IKey;
```

- *Type:* aws-cdk-lib.aws_kms.IKey

Optional KMS encryption key associated with this bucket.

---

##### `isWebsite`<sup>Optional</sup> <a name="isWebsite" id="cdk-extensions.s3_buckets.SesLogsBucket.property.isWebsite"></a>

```typescript
public readonly isWebsite: boolean;
```

- *Type:* boolean

If this bucket has been configured for static website hosting.

---

##### `policy`<sup>Optional</sup> <a name="policy" id="cdk-extensions.s3_buckets.SesLogsBucket.property.policy"></a>

```typescript
public readonly policy: BucketPolicy;
```

- *Type:* aws-cdk-lib.aws_s3.BucketPolicy

The resource policy associated with this bucket.

If `autoCreatePolicy` is true, a `BucketPolicy` will be created upon the
first call to addToResourcePolicy(s).

---

##### `database`<sup>Required</sup> <a name="database" id="cdk-extensions.s3_buckets.SesLogsBucket.property.database"></a>

```typescript
public readonly database: Database;
```

- *Type:* cdk-extensions.glue.Database

---

##### `table`<sup>Required</sup> <a name="table" id="cdk-extensions.s3_buckets.SesLogsBucket.property.table"></a>

```typescript
public readonly table: SesLogsTable;
```

- *Type:* cdk-extensions.glue_tables.SesLogsTable

---

##### `createQueries`<sup>Optional</sup> <a name="createQueries" id="cdk-extensions.s3_buckets.SesLogsBucket.property.createQueries"></a>

```typescript
public readonly createQueries: boolean;
```

- *Type:* boolean

---

##### `friendlyQueryNames`<sup>Optional</sup> <a name="friendlyQueryNames" id="cdk-extensions.s3_buckets.SesLogsBucket.property.friendlyQueryNames"></a>

```typescript
public readonly friendlyQueryNames: boolean;
```

- *Type:* boolean

---


### SesLogsTable <a name="SesLogsTable" id="cdk-extensions.glue_tables.SesLogsTable"></a>

#### Initializers <a name="Initializers" id="cdk-extensions.glue_tables.SesLogsTable.Initializer"></a>

```typescript
import { glue_tables } from 'cdk-extensions'

new glue_tables.SesLogsTable(scope: Construct, id: string, props: SesLogsTableProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTable.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | A CDK Construct that will serve as this stack's parent in the construct tree. |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTable.Initializer.parameter.id">id</a></code> | <code>string</code> | A name to be associated with the stack and used in resource naming. |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTable.Initializer.parameter.props">props</a></code> | <code>cdk-extensions.glue_tables.SesLogsTableProps</code> | Arguments related to the configuration of the resource. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.glue_tables.SesLogsTable.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

A CDK Construct that will serve as this stack's parent in the construct tree.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.glue_tables.SesLogsTable.Initializer.parameter.id"></a>

- *Type:* string

A name to be associated with the stack and used in resource naming.

Must be unique
within the context of 'scope'.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk-extensions.glue_tables.SesLogsTable.Initializer.parameter.props"></a>

- *Type:* cdk-extensions.glue_tables.SesLogsTableProps

Arguments related to the configuration of the resource.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTable.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTable.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTable.addColumn">addColumn</a></code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTable.addParameter">addParameter</a></code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTable.addPartitionKey">addPartitionKey</a></code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTable.addSerdeParameter">addSerdeParameter</a></code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTable.addStorageParameter">addStorageParameter</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="cdk-extensions.glue_tables.SesLogsTable.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="cdk-extensions.glue_tables.SesLogsTable.applyRemovalPolicy"></a>

```typescript
public applyRemovalPolicy(policy: RemovalPolicy): void
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="cdk-extensions.glue_tables.SesLogsTable.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.RemovalPolicy

---

##### `addColumn` <a name="addColumn" id="cdk-extensions.glue_tables.SesLogsTable.addColumn"></a>

```typescript
public addColumn(column: Column): void
```

###### `column`<sup>Required</sup> <a name="column" id="cdk-extensions.glue_tables.SesLogsTable.addColumn.parameter.column"></a>

- *Type:* cdk-extensions.glue.Column

---

##### `addParameter` <a name="addParameter" id="cdk-extensions.glue_tables.SesLogsTable.addParameter"></a>

```typescript
public addParameter(key: string, value: string): void
```

###### `key`<sup>Required</sup> <a name="key" id="cdk-extensions.glue_tables.SesLogsTable.addParameter.parameter.key"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="cdk-extensions.glue_tables.SesLogsTable.addParameter.parameter.value"></a>

- *Type:* string

---

##### `addPartitionKey` <a name="addPartitionKey" id="cdk-extensions.glue_tables.SesLogsTable.addPartitionKey"></a>

```typescript
public addPartitionKey(column: Column): void
```

###### `column`<sup>Required</sup> <a name="column" id="cdk-extensions.glue_tables.SesLogsTable.addPartitionKey.parameter.column"></a>

- *Type:* cdk-extensions.glue.Column

---

##### `addSerdeParameter` <a name="addSerdeParameter" id="cdk-extensions.glue_tables.SesLogsTable.addSerdeParameter"></a>

```typescript
public addSerdeParameter(key: string, value: string): void
```

###### `key`<sup>Required</sup> <a name="key" id="cdk-extensions.glue_tables.SesLogsTable.addSerdeParameter.parameter.key"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="cdk-extensions.glue_tables.SesLogsTable.addSerdeParameter.parameter.value"></a>

- *Type:* string

---

##### `addStorageParameter` <a name="addStorageParameter" id="cdk-extensions.glue_tables.SesLogsTable.addStorageParameter"></a>

```typescript
public addStorageParameter(key: string, value: string): void
```

###### `key`<sup>Required</sup> <a name="key" id="cdk-extensions.glue_tables.SesLogsTable.addStorageParameter.parameter.key"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="cdk-extensions.glue_tables.SesLogsTable.addStorageParameter.parameter.value"></a>

- *Type:* string

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTable.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTable.isOwnedResource">isOwnedResource</a></code> | Returns true if the construct was created by CDK, and false otherwise. |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTable.isResource">isResource</a></code> | Check whether the given construct is a Resource. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-extensions.glue_tables.SesLogsTable.isConstruct"></a>

```typescript
import { glue_tables } from 'cdk-extensions'

glue_tables.SesLogsTable.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-extensions.glue_tables.SesLogsTable.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isOwnedResource` <a name="isOwnedResource" id="cdk-extensions.glue_tables.SesLogsTable.isOwnedResource"></a>

```typescript
import { glue_tables } from 'cdk-extensions'

glue_tables.SesLogsTable.isOwnedResource(construct: IConstruct)
```

Returns true if the construct was created by CDK, and false otherwise.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.glue_tables.SesLogsTable.isOwnedResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `isResource` <a name="isResource" id="cdk-extensions.glue_tables.SesLogsTable.isResource"></a>

```typescript
import { glue_tables } from 'cdk-extensions'

glue_tables.SesLogsTable.isResource(construct: IConstruct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.glue_tables.SesLogsTable.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTable.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTable.property.env">env</a></code> | <code>aws-cdk-lib.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTable.property.stack">stack</a></code> | <code>aws-cdk-lib.Stack</code> | The stack in which this resource is defined. |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTable.property.database">database</a></code> | <code>cdk-extensions.glue.Database</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTable.property.resource">resource</a></code> | <code>aws-cdk-lib.aws_glue.CfnTable</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTable.property.tableArn">tableArn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTable.property.tableName">tableName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTable.property.compressed">compressed</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTable.property.dataFormat">dataFormat</a></code> | <code>cdk-extensions.glue.DataFormat</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTable.property.description">description</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTable.property.location">location</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTable.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTable.property.owner">owner</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTable.property.retention">retention</a></code> | <code>aws-cdk-lib.Duration</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTable.property.serdeName">serdeName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTable.property.storedAsSubDirectories">storedAsSubDirectories</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTable.property.tableType">tableType</a></code> | <code>cdk-extensions.glue.TableType</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTable.property.targetTable">targetTable</a></code> | <code>cdk-extensions.glue.Table</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTable.property.viewExpandedText">viewExpandedText</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTable.property.viewOriginalText">viewOriginalText</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTable.property.createQueries">createQueries</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTable.property.friendlyQueryNames">friendlyQueryNames</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTable.property.bouncesQuery">bouncesQuery</a></code> | <code>cdk-extensions.athena.NamedQuery</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTable.property.complaintsQuery">complaintsQuery</a></code> | <code>cdk-extensions.athena.NamedQuery</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-extensions.glue_tables.SesLogsTable.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="cdk-extensions.glue_tables.SesLogsTable.property.env"></a>

```typescript
public readonly env: ResourceEnvironment;
```

- *Type:* aws-cdk-lib.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="cdk-extensions.glue_tables.SesLogsTable.property.stack"></a>

```typescript
public readonly stack: Stack;
```

- *Type:* aws-cdk-lib.Stack

The stack in which this resource is defined.

---

##### `database`<sup>Required</sup> <a name="database" id="cdk-extensions.glue_tables.SesLogsTable.property.database"></a>

```typescript
public readonly database: Database;
```

- *Type:* cdk-extensions.glue.Database

---

##### `resource`<sup>Required</sup> <a name="resource" id="cdk-extensions.glue_tables.SesLogsTable.property.resource"></a>

```typescript
public readonly resource: CfnTable;
```

- *Type:* aws-cdk-lib.aws_glue.CfnTable

---

##### `tableArn`<sup>Required</sup> <a name="tableArn" id="cdk-extensions.glue_tables.SesLogsTable.property.tableArn"></a>

```typescript
public readonly tableArn: string;
```

- *Type:* string

---

##### `tableName`<sup>Required</sup> <a name="tableName" id="cdk-extensions.glue_tables.SesLogsTable.property.tableName"></a>

```typescript
public readonly tableName: string;
```

- *Type:* string

---

##### `compressed`<sup>Optional</sup> <a name="compressed" id="cdk-extensions.glue_tables.SesLogsTable.property.compressed"></a>

```typescript
public readonly compressed: boolean;
```

- *Type:* boolean

---

##### `dataFormat`<sup>Optional</sup> <a name="dataFormat" id="cdk-extensions.glue_tables.SesLogsTable.property.dataFormat"></a>

```typescript
public readonly dataFormat: DataFormat;
```

- *Type:* cdk-extensions.glue.DataFormat

---

##### `description`<sup>Optional</sup> <a name="description" id="cdk-extensions.glue_tables.SesLogsTable.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

---

##### `location`<sup>Optional</sup> <a name="location" id="cdk-extensions.glue_tables.SesLogsTable.property.location"></a>

```typescript
public readonly location: string;
```

- *Type:* string

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.glue_tables.SesLogsTable.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `owner`<sup>Optional</sup> <a name="owner" id="cdk-extensions.glue_tables.SesLogsTable.property.owner"></a>

```typescript
public readonly owner: string;
```

- *Type:* string

---

##### `retention`<sup>Optional</sup> <a name="retention" id="cdk-extensions.glue_tables.SesLogsTable.property.retention"></a>

```typescript
public readonly retention: Duration;
```

- *Type:* aws-cdk-lib.Duration

---

##### `serdeName`<sup>Optional</sup> <a name="serdeName" id="cdk-extensions.glue_tables.SesLogsTable.property.serdeName"></a>

```typescript
public readonly serdeName: string;
```

- *Type:* string

---

##### `storedAsSubDirectories`<sup>Optional</sup> <a name="storedAsSubDirectories" id="cdk-extensions.glue_tables.SesLogsTable.property.storedAsSubDirectories"></a>

```typescript
public readonly storedAsSubDirectories: boolean;
```

- *Type:* boolean

---

##### `tableType`<sup>Optional</sup> <a name="tableType" id="cdk-extensions.glue_tables.SesLogsTable.property.tableType"></a>

```typescript
public readonly tableType: TableType;
```

- *Type:* cdk-extensions.glue.TableType

---

##### `targetTable`<sup>Optional</sup> <a name="targetTable" id="cdk-extensions.glue_tables.SesLogsTable.property.targetTable"></a>

```typescript
public readonly targetTable: Table;
```

- *Type:* cdk-extensions.glue.Table

---

##### `viewExpandedText`<sup>Optional</sup> <a name="viewExpandedText" id="cdk-extensions.glue_tables.SesLogsTable.property.viewExpandedText"></a>

```typescript
public readonly viewExpandedText: string;
```

- *Type:* string

---

##### `viewOriginalText`<sup>Optional</sup> <a name="viewOriginalText" id="cdk-extensions.glue_tables.SesLogsTable.property.viewOriginalText"></a>

```typescript
public readonly viewOriginalText: string;
```

- *Type:* string

---

##### `createQueries`<sup>Required</sup> <a name="createQueries" id="cdk-extensions.glue_tables.SesLogsTable.property.createQueries"></a>

```typescript
public readonly createQueries: boolean;
```

- *Type:* boolean

---

##### `friendlyQueryNames`<sup>Required</sup> <a name="friendlyQueryNames" id="cdk-extensions.glue_tables.SesLogsTable.property.friendlyQueryNames"></a>

```typescript
public readonly friendlyQueryNames: boolean;
```

- *Type:* boolean

---

##### `bouncesQuery`<sup>Optional</sup> <a name="bouncesQuery" id="cdk-extensions.glue_tables.SesLogsTable.property.bouncesQuery"></a>

```typescript
public readonly bouncesQuery: NamedQuery;
```

- *Type:* cdk-extensions.athena.NamedQuery

---

##### `complaintsQuery`<sup>Optional</sup> <a name="complaintsQuery" id="cdk-extensions.glue_tables.SesLogsTable.property.complaintsQuery"></a>

```typescript
public readonly complaintsQuery: NamedQuery;
```

- *Type:* cdk-extensions.athena.NamedQuery

---


### Table <a name="Table" id="cdk-extensions.glue.Table"></a>

#### Initializers <a name="Initializers" id="cdk-extensions.glue.Table.Initializer"></a>

```typescript
import { glue } from 'cdk-extensions'

new glue.Table(scope: Construct, id: string, props: TableProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.Table.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | A CDK Construct that will serve as this stack's parent in the construct tree. |
| <code><a href="#cdk-extensions.glue.Table.Initializer.parameter.id">id</a></code> | <code>string</code> | A name to be associated with the stack and used in resource naming. |
| <code><a href="#cdk-extensions.glue.Table.Initializer.parameter.props">props</a></code> | <code>cdk-extensions.glue.TableProps</code> | Arguments related to the configuration of the resource. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.glue.Table.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

A CDK Construct that will serve as this stack's parent in the construct tree.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.glue.Table.Initializer.parameter.id"></a>

- *Type:* string

A name to be associated with the stack and used in resource naming.

Must be unique
within the context of 'scope'.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk-extensions.glue.Table.Initializer.parameter.props"></a>

- *Type:* cdk-extensions.glue.TableProps

Arguments related to the configuration of the resource.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.glue.Table.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-extensions.glue.Table.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |
| <code><a href="#cdk-extensions.glue.Table.addColumn">addColumn</a></code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Table.addParameter">addParameter</a></code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Table.addPartitionKey">addPartitionKey</a></code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Table.addSerdeParameter">addSerdeParameter</a></code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Table.addStorageParameter">addStorageParameter</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="cdk-extensions.glue.Table.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="cdk-extensions.glue.Table.applyRemovalPolicy"></a>

```typescript
public applyRemovalPolicy(policy: RemovalPolicy): void
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="cdk-extensions.glue.Table.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.RemovalPolicy

---

##### `addColumn` <a name="addColumn" id="cdk-extensions.glue.Table.addColumn"></a>

```typescript
public addColumn(column: Column): void
```

###### `column`<sup>Required</sup> <a name="column" id="cdk-extensions.glue.Table.addColumn.parameter.column"></a>

- *Type:* cdk-extensions.glue.Column

---

##### `addParameter` <a name="addParameter" id="cdk-extensions.glue.Table.addParameter"></a>

```typescript
public addParameter(key: string, value: string): void
```

###### `key`<sup>Required</sup> <a name="key" id="cdk-extensions.glue.Table.addParameter.parameter.key"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="cdk-extensions.glue.Table.addParameter.parameter.value"></a>

- *Type:* string

---

##### `addPartitionKey` <a name="addPartitionKey" id="cdk-extensions.glue.Table.addPartitionKey"></a>

```typescript
public addPartitionKey(column: Column): void
```

###### `column`<sup>Required</sup> <a name="column" id="cdk-extensions.glue.Table.addPartitionKey.parameter.column"></a>

- *Type:* cdk-extensions.glue.Column

---

##### `addSerdeParameter` <a name="addSerdeParameter" id="cdk-extensions.glue.Table.addSerdeParameter"></a>

```typescript
public addSerdeParameter(key: string, value: string): void
```

###### `key`<sup>Required</sup> <a name="key" id="cdk-extensions.glue.Table.addSerdeParameter.parameter.key"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="cdk-extensions.glue.Table.addSerdeParameter.parameter.value"></a>

- *Type:* string

---

##### `addStorageParameter` <a name="addStorageParameter" id="cdk-extensions.glue.Table.addStorageParameter"></a>

```typescript
public addStorageParameter(key: string, value: string): void
```

###### `key`<sup>Required</sup> <a name="key" id="cdk-extensions.glue.Table.addStorageParameter.parameter.key"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="cdk-extensions.glue.Table.addStorageParameter.parameter.value"></a>

- *Type:* string

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.glue.Table.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-extensions.glue.Table.isOwnedResource">isOwnedResource</a></code> | Returns true if the construct was created by CDK, and false otherwise. |
| <code><a href="#cdk-extensions.glue.Table.isResource">isResource</a></code> | Check whether the given construct is a Resource. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-extensions.glue.Table.isConstruct"></a>

```typescript
import { glue } from 'cdk-extensions'

glue.Table.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-extensions.glue.Table.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isOwnedResource` <a name="isOwnedResource" id="cdk-extensions.glue.Table.isOwnedResource"></a>

```typescript
import { glue } from 'cdk-extensions'

glue.Table.isOwnedResource(construct: IConstruct)
```

Returns true if the construct was created by CDK, and false otherwise.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.glue.Table.isOwnedResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `isResource` <a name="isResource" id="cdk-extensions.glue.Table.isResource"></a>

```typescript
import { glue } from 'cdk-extensions'

glue.Table.isResource(construct: IConstruct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.glue.Table.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.Table.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-extensions.glue.Table.property.env">env</a></code> | <code>aws-cdk-lib.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#cdk-extensions.glue.Table.property.stack">stack</a></code> | <code>aws-cdk-lib.Stack</code> | The stack in which this resource is defined. |
| <code><a href="#cdk-extensions.glue.Table.property.database">database</a></code> | <code>cdk-extensions.glue.Database</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Table.property.resource">resource</a></code> | <code>aws-cdk-lib.aws_glue.CfnTable</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Table.property.tableArn">tableArn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Table.property.tableName">tableName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Table.property.compressed">compressed</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Table.property.dataFormat">dataFormat</a></code> | <code>cdk-extensions.glue.DataFormat</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Table.property.description">description</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Table.property.location">location</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Table.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Table.property.owner">owner</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Table.property.retention">retention</a></code> | <code>aws-cdk-lib.Duration</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Table.property.serdeName">serdeName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Table.property.storedAsSubDirectories">storedAsSubDirectories</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Table.property.tableType">tableType</a></code> | <code>cdk-extensions.glue.TableType</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Table.property.targetTable">targetTable</a></code> | <code>cdk-extensions.glue.Table</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Table.property.viewExpandedText">viewExpandedText</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Table.property.viewOriginalText">viewOriginalText</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-extensions.glue.Table.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="cdk-extensions.glue.Table.property.env"></a>

```typescript
public readonly env: ResourceEnvironment;
```

- *Type:* aws-cdk-lib.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="cdk-extensions.glue.Table.property.stack"></a>

```typescript
public readonly stack: Stack;
```

- *Type:* aws-cdk-lib.Stack

The stack in which this resource is defined.

---

##### `database`<sup>Required</sup> <a name="database" id="cdk-extensions.glue.Table.property.database"></a>

```typescript
public readonly database: Database;
```

- *Type:* cdk-extensions.glue.Database

---

##### `resource`<sup>Required</sup> <a name="resource" id="cdk-extensions.glue.Table.property.resource"></a>

```typescript
public readonly resource: CfnTable;
```

- *Type:* aws-cdk-lib.aws_glue.CfnTable

---

##### `tableArn`<sup>Required</sup> <a name="tableArn" id="cdk-extensions.glue.Table.property.tableArn"></a>

```typescript
public readonly tableArn: string;
```

- *Type:* string

---

##### `tableName`<sup>Required</sup> <a name="tableName" id="cdk-extensions.glue.Table.property.tableName"></a>

```typescript
public readonly tableName: string;
```

- *Type:* string

---

##### `compressed`<sup>Optional</sup> <a name="compressed" id="cdk-extensions.glue.Table.property.compressed"></a>

```typescript
public readonly compressed: boolean;
```

- *Type:* boolean

---

##### `dataFormat`<sup>Optional</sup> <a name="dataFormat" id="cdk-extensions.glue.Table.property.dataFormat"></a>

```typescript
public readonly dataFormat: DataFormat;
```

- *Type:* cdk-extensions.glue.DataFormat

---

##### `description`<sup>Optional</sup> <a name="description" id="cdk-extensions.glue.Table.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

---

##### `location`<sup>Optional</sup> <a name="location" id="cdk-extensions.glue.Table.property.location"></a>

```typescript
public readonly location: string;
```

- *Type:* string

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.glue.Table.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `owner`<sup>Optional</sup> <a name="owner" id="cdk-extensions.glue.Table.property.owner"></a>

```typescript
public readonly owner: string;
```

- *Type:* string

---

##### `retention`<sup>Optional</sup> <a name="retention" id="cdk-extensions.glue.Table.property.retention"></a>

```typescript
public readonly retention: Duration;
```

- *Type:* aws-cdk-lib.Duration

---

##### `serdeName`<sup>Optional</sup> <a name="serdeName" id="cdk-extensions.glue.Table.property.serdeName"></a>

```typescript
public readonly serdeName: string;
```

- *Type:* string

---

##### `storedAsSubDirectories`<sup>Optional</sup> <a name="storedAsSubDirectories" id="cdk-extensions.glue.Table.property.storedAsSubDirectories"></a>

```typescript
public readonly storedAsSubDirectories: boolean;
```

- *Type:* boolean

---

##### `tableType`<sup>Optional</sup> <a name="tableType" id="cdk-extensions.glue.Table.property.tableType"></a>

```typescript
public readonly tableType: TableType;
```

- *Type:* cdk-extensions.glue.TableType

---

##### `targetTable`<sup>Optional</sup> <a name="targetTable" id="cdk-extensions.glue.Table.property.targetTable"></a>

```typescript
public readonly targetTable: Table;
```

- *Type:* cdk-extensions.glue.Table

---

##### `viewExpandedText`<sup>Optional</sup> <a name="viewExpandedText" id="cdk-extensions.glue.Table.property.viewExpandedText"></a>

```typescript
public readonly viewExpandedText: string;
```

- *Type:* string

---

##### `viewOriginalText`<sup>Optional</sup> <a name="viewOriginalText" id="cdk-extensions.glue.Table.property.viewOriginalText"></a>

```typescript
public readonly viewOriginalText: string;
```

- *Type:* string

---


### Trigger <a name="Trigger" id="cdk-extensions.glue.Trigger"></a>

#### Initializers <a name="Initializers" id="cdk-extensions.glue.Trigger.Initializer"></a>

```typescript
import { glue } from 'cdk-extensions'

new glue.Trigger(scope: Construct, id: string, props: TriggerProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.Trigger.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Trigger.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Trigger.Initializer.parameter.props">props</a></code> | <code>cdk-extensions.glue.TriggerProps</code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.glue.Trigger.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.glue.Trigger.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="cdk-extensions.glue.Trigger.Initializer.parameter.props"></a>

- *Type:* cdk-extensions.glue.TriggerProps

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.glue.Trigger.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-extensions.glue.Trigger.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |
| <code><a href="#cdk-extensions.glue.Trigger.addAction">addAction</a></code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Trigger.addPredicate">addPredicate</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="cdk-extensions.glue.Trigger.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="cdk-extensions.glue.Trigger.applyRemovalPolicy"></a>

```typescript
public applyRemovalPolicy(policy: RemovalPolicy): void
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="cdk-extensions.glue.Trigger.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.RemovalPolicy

---

##### `addAction` <a name="addAction" id="cdk-extensions.glue.Trigger.addAction"></a>

```typescript
public addAction(action: ITriggerAction): Trigger
```

###### `action`<sup>Required</sup> <a name="action" id="cdk-extensions.glue.Trigger.addAction.parameter.action"></a>

- *Type:* cdk-extensions.glue.ITriggerAction

---

##### `addPredicate` <a name="addPredicate" id="cdk-extensions.glue.Trigger.addPredicate"></a>

```typescript
public addPredicate(predicate: ITriggerPredicate): Trigger
```

###### `predicate`<sup>Required</sup> <a name="predicate" id="cdk-extensions.glue.Trigger.addPredicate.parameter.predicate"></a>

- *Type:* cdk-extensions.glue.ITriggerPredicate

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.glue.Trigger.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-extensions.glue.Trigger.isOwnedResource">isOwnedResource</a></code> | Returns true if the construct was created by CDK, and false otherwise. |
| <code><a href="#cdk-extensions.glue.Trigger.isResource">isResource</a></code> | Check whether the given construct is a Resource. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-extensions.glue.Trigger.isConstruct"></a>

```typescript
import { glue } from 'cdk-extensions'

glue.Trigger.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-extensions.glue.Trigger.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isOwnedResource` <a name="isOwnedResource" id="cdk-extensions.glue.Trigger.isOwnedResource"></a>

```typescript
import { glue } from 'cdk-extensions'

glue.Trigger.isOwnedResource(construct: IConstruct)
```

Returns true if the construct was created by CDK, and false otherwise.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.glue.Trigger.isOwnedResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `isResource` <a name="isResource" id="cdk-extensions.glue.Trigger.isResource"></a>

```typescript
import { glue } from 'cdk-extensions'

glue.Trigger.isResource(construct: IConstruct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.glue.Trigger.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.Trigger.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-extensions.glue.Trigger.property.env">env</a></code> | <code>aws-cdk-lib.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#cdk-extensions.glue.Trigger.property.stack">stack</a></code> | <code>aws-cdk-lib.Stack</code> | The stack in which this resource is defined. |
| <code><a href="#cdk-extensions.glue.Trigger.property.predicateOperator">predicateOperator</a></code> | <code>cdk-extensions.glue.PredicateOperator</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Trigger.property.resource">resource</a></code> | <code>aws-cdk-lib.aws_glue.CfnTrigger</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Trigger.property.type">type</a></code> | <code>cdk-extensions.glue.TriggerType</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Trigger.property.workflowArn">workflowArn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Trigger.property.workflowName">workflowName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Trigger.property.description">description</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Trigger.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Trigger.property.schedule">schedule</a></code> | <code>aws-cdk-lib.aws_events.Schedule</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Trigger.property.startOnCreation">startOnCreation</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Trigger.property.workflow">workflow</a></code> | <code>cdk-extensions.glue.Workflow</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-extensions.glue.Trigger.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="cdk-extensions.glue.Trigger.property.env"></a>

```typescript
public readonly env: ResourceEnvironment;
```

- *Type:* aws-cdk-lib.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="cdk-extensions.glue.Trigger.property.stack"></a>

```typescript
public readonly stack: Stack;
```

- *Type:* aws-cdk-lib.Stack

The stack in which this resource is defined.

---

##### `predicateOperator`<sup>Required</sup> <a name="predicateOperator" id="cdk-extensions.glue.Trigger.property.predicateOperator"></a>

```typescript
public readonly predicateOperator: PredicateOperator;
```

- *Type:* cdk-extensions.glue.PredicateOperator

---

##### `resource`<sup>Required</sup> <a name="resource" id="cdk-extensions.glue.Trigger.property.resource"></a>

```typescript
public readonly resource: CfnTrigger;
```

- *Type:* aws-cdk-lib.aws_glue.CfnTrigger

---

##### `type`<sup>Required</sup> <a name="type" id="cdk-extensions.glue.Trigger.property.type"></a>

```typescript
public readonly type: TriggerType;
```

- *Type:* cdk-extensions.glue.TriggerType

---

##### `workflowArn`<sup>Required</sup> <a name="workflowArn" id="cdk-extensions.glue.Trigger.property.workflowArn"></a>

```typescript
public readonly workflowArn: string;
```

- *Type:* string

---

##### `workflowName`<sup>Required</sup> <a name="workflowName" id="cdk-extensions.glue.Trigger.property.workflowName"></a>

```typescript
public readonly workflowName: string;
```

- *Type:* string

---

##### `description`<sup>Optional</sup> <a name="description" id="cdk-extensions.glue.Trigger.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.glue.Trigger.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `schedule`<sup>Optional</sup> <a name="schedule" id="cdk-extensions.glue.Trigger.property.schedule"></a>

```typescript
public readonly schedule: Schedule;
```

- *Type:* aws-cdk-lib.aws_events.Schedule

---

##### `startOnCreation`<sup>Optional</sup> <a name="startOnCreation" id="cdk-extensions.glue.Trigger.property.startOnCreation"></a>

```typescript
public readonly startOnCreation: boolean;
```

- *Type:* boolean

---

##### `workflow`<sup>Optional</sup> <a name="workflow" id="cdk-extensions.glue.Trigger.property.workflow"></a>

```typescript
public readonly workflow: Workflow;
```

- *Type:* cdk-extensions.glue.Workflow

---


### UserBase <a name="UserBase" id="cdk-extensions.sso.UserBase"></a>

- *Implements:* cdk-extensions.sso.IUser, cdk-extensions.sso.IIdentityCenterPrincipal

#### Initializers <a name="Initializers" id="cdk-extensions.sso.UserBase.Initializer"></a>

```typescript
import { sso } from 'cdk-extensions'

new sso.UserBase(scope: IConstruct, id: string, props?: ResourceProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.sso.UserBase.Initializer.parameter.scope">scope</a></code> | <code>constructs.IConstruct</code> | *No description.* |
| <code><a href="#cdk-extensions.sso.UserBase.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.sso.UserBase.Initializer.parameter.props">props</a></code> | <code>aws-cdk-lib.ResourceProps</code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.sso.UserBase.Initializer.parameter.scope"></a>

- *Type:* constructs.IConstruct

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.sso.UserBase.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk-extensions.sso.UserBase.Initializer.parameter.props"></a>

- *Type:* aws-cdk-lib.ResourceProps

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.sso.UserBase.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-extensions.sso.UserBase.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |

---

##### `toString` <a name="toString" id="cdk-extensions.sso.UserBase.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="cdk-extensions.sso.UserBase.applyRemovalPolicy"></a>

```typescript
public applyRemovalPolicy(policy: RemovalPolicy): void
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="cdk-extensions.sso.UserBase.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.RemovalPolicy

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.sso.UserBase.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-extensions.sso.UserBase.isOwnedResource">isOwnedResource</a></code> | Returns true if the construct was created by CDK, and false otherwise. |
| <code><a href="#cdk-extensions.sso.UserBase.isResource">isResource</a></code> | Check whether the given construct is a Resource. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-extensions.sso.UserBase.isConstruct"></a>

```typescript
import { sso } from 'cdk-extensions'

sso.UserBase.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-extensions.sso.UserBase.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isOwnedResource` <a name="isOwnedResource" id="cdk-extensions.sso.UserBase.isOwnedResource"></a>

```typescript
import { sso } from 'cdk-extensions'

sso.UserBase.isOwnedResource(construct: IConstruct)
```

Returns true if the construct was created by CDK, and false otherwise.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.sso.UserBase.isOwnedResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `isResource` <a name="isResource" id="cdk-extensions.sso.UserBase.isResource"></a>

```typescript
import { sso } from 'cdk-extensions'

sso.UserBase.isResource(construct: IConstruct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.sso.UserBase.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.sso.UserBase.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-extensions.sso.UserBase.property.env">env</a></code> | <code>aws-cdk-lib.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#cdk-extensions.sso.UserBase.property.stack">stack</a></code> | <code>aws-cdk-lib.Stack</code> | The stack in which this resource is defined. |
| <code><a href="#cdk-extensions.sso.UserBase.property.principalId">principalId</a></code> | <code>string</code> | The unique ID that identifies the entity withing IAM Identity Center. |
| <code><a href="#cdk-extensions.sso.UserBase.property.principalType">principalType</a></code> | <code>cdk-extensions.sso.IdentityCenterPrincipalType</code> | The type of entity being represented. |
| <code><a href="#cdk-extensions.sso.UserBase.property.userId">userId</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-extensions.sso.UserBase.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="cdk-extensions.sso.UserBase.property.env"></a>

```typescript
public readonly env: ResourceEnvironment;
```

- *Type:* aws-cdk-lib.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="cdk-extensions.sso.UserBase.property.stack"></a>

```typescript
public readonly stack: Stack;
```

- *Type:* aws-cdk-lib.Stack

The stack in which this resource is defined.

---

##### `principalId`<sup>Required</sup> <a name="principalId" id="cdk-extensions.sso.UserBase.property.principalId"></a>

```typescript
public readonly principalId: string;
```

- *Type:* string

The unique ID that identifies the entity withing IAM Identity Center.

---

##### `principalType`<sup>Required</sup> <a name="principalType" id="cdk-extensions.sso.UserBase.property.principalType"></a>

```typescript
public readonly principalType: IdentityCenterPrincipalType;
```

- *Type:* cdk-extensions.sso.IdentityCenterPrincipalType

The type of entity being represented.

---

##### `userId`<sup>Required</sup> <a name="userId" id="cdk-extensions.sso.UserBase.property.userId"></a>

```typescript
public readonly userId: string;
```

- *Type:* string

---


### WafLogsBucket <a name="WafLogsBucket" id="cdk-extensions.s3_buckets.WafLogsBucket"></a>

#### Initializers <a name="Initializers" id="cdk-extensions.s3_buckets.WafLogsBucket.Initializer"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

new s3_buckets.WafLogsBucket(scope: Construct, id: string, props?: WafLogsBucketProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | A CDK Construct that will serve as this stack's parent in the construct tree. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.Initializer.parameter.id">id</a></code> | <code>string</code> | A name to be associated with the stack and used in resource naming. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.Initializer.parameter.props">props</a></code> | <code>cdk-extensions.s3_buckets.WafLogsBucketProps</code> | Arguments related to the configuration of the resource. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.s3_buckets.WafLogsBucket.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

A CDK Construct that will serve as this stack's parent in the construct tree.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.s3_buckets.WafLogsBucket.Initializer.parameter.id"></a>

- *Type:* string

A name to be associated with the stack and used in resource naming.

Must be unique
within the context of 'scope'.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk-extensions.s3_buckets.WafLogsBucket.Initializer.parameter.props"></a>

- *Type:* cdk-extensions.s3_buckets.WafLogsBucketProps

Arguments related to the configuration of the resource.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.addEventNotification">addEventNotification</a></code> | Adds a bucket notification event destination. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.addObjectCreatedNotification">addObjectCreatedNotification</a></code> | Subscribes a destination to receive notifications when an object is created in the bucket. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.addObjectRemovedNotification">addObjectRemovedNotification</a></code> | Subscribes a destination to receive notifications when an object is removed from the bucket. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.addToResourcePolicy">addToResourcePolicy</a></code> | Adds a statement to the resource policy for a principal (i.e. account/role/service) to perform actions on this bucket and/or its contents. Use `bucketArn` and `arnForObjects(keys)` to obtain ARNs for this bucket or objects. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.arnForObjects">arnForObjects</a></code> | Returns an ARN that represents all objects within the bucket that match the key pattern specified. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.enableEventBridgeNotification">enableEventBridgeNotification</a></code> | Enables event bridge notification, causing all events below to be sent to EventBridge:. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.grantDelete">grantDelete</a></code> | Grants s3:DeleteObject* permission to an IAM principal for objects in this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.grantPublicAccess">grantPublicAccess</a></code> | Allows unrestricted access to objects from this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.grantPut">grantPut</a></code> | Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.grantPutAcl">grantPutAcl</a></code> | Grant the given IAM identity permissions to modify the ACLs of objects in the given Bucket. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.grantRead">grantRead</a></code> | Grant read permissions for this bucket and it's contents to an IAM principal (Role/Group/User). |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.grantReadWrite">grantReadWrite</a></code> | Grants read/write permissions for this bucket and it's contents to an IAM principal (Role/Group/User). |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.grantWrite">grantWrite</a></code> | Grant write permissions to this bucket to an IAM principal. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.onCloudTrailEvent">onCloudTrailEvent</a></code> | Defines a CloudWatch event that triggers when something happens to this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.onCloudTrailPutObject">onCloudTrailPutObject</a></code> | Defines an AWS CloudWatch event that triggers when an object is uploaded to the specified paths (keys) in this bucket using the PutObject API call. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.onCloudTrailWriteObject">onCloudTrailWriteObject</a></code> | Defines an AWS CloudWatch event that triggers when an object at the specified paths (keys) in this bucket are written to. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.s3UrlForObject">s3UrlForObject</a></code> | The S3 URL of an S3 object. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.transferAccelerationUrlForObject">transferAccelerationUrlForObject</a></code> | The https Transfer Acceleration URL of an S3 object. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.urlForObject">urlForObject</a></code> | The https URL of an S3 object. For example:. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.virtualHostedUrlForObject">virtualHostedUrlForObject</a></code> | The virtual hosted-style URL of an S3 object. Specify `regional: false` at the options for non-regional URL. For example:. |

---

##### `toString` <a name="toString" id="cdk-extensions.s3_buckets.WafLogsBucket.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="cdk-extensions.s3_buckets.WafLogsBucket.applyRemovalPolicy"></a>

```typescript
public applyRemovalPolicy(policy: RemovalPolicy): void
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="cdk-extensions.s3_buckets.WafLogsBucket.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.RemovalPolicy

---

##### `addEventNotification` <a name="addEventNotification" id="cdk-extensions.s3_buckets.WafLogsBucket.addEventNotification"></a>

```typescript
public addEventNotification(_event: EventType, _dest: IBucketNotificationDestination, _filters: NotificationKeyFilter): void
```

Adds a bucket notification event destination.

###### `_event`<sup>Required</sup> <a name="_event" id="cdk-extensions.s3_buckets.WafLogsBucket.addEventNotification.parameter._event"></a>

- *Type:* aws-cdk-lib.aws_s3.EventType

---

###### `_dest`<sup>Required</sup> <a name="_dest" id="cdk-extensions.s3_buckets.WafLogsBucket.addEventNotification.parameter._dest"></a>

- *Type:* aws-cdk-lib.aws_s3.IBucketNotificationDestination

---

###### `_filters`<sup>Required</sup> <a name="_filters" id="cdk-extensions.s3_buckets.WafLogsBucket.addEventNotification.parameter._filters"></a>

- *Type:* aws-cdk-lib.aws_s3.NotificationKeyFilter

---

##### `addObjectCreatedNotification` <a name="addObjectCreatedNotification" id="cdk-extensions.s3_buckets.WafLogsBucket.addObjectCreatedNotification"></a>

```typescript
public addObjectCreatedNotification(_dest: IBucketNotificationDestination, _filters: NotificationKeyFilter): void
```

Subscribes a destination to receive notifications when an object is created in the bucket.

This is identical to calling
`onEvent(s3.EventType.OBJECT_CREATED)`.

###### `_dest`<sup>Required</sup> <a name="_dest" id="cdk-extensions.s3_buckets.WafLogsBucket.addObjectCreatedNotification.parameter._dest"></a>

- *Type:* aws-cdk-lib.aws_s3.IBucketNotificationDestination

---

###### `_filters`<sup>Required</sup> <a name="_filters" id="cdk-extensions.s3_buckets.WafLogsBucket.addObjectCreatedNotification.parameter._filters"></a>

- *Type:* aws-cdk-lib.aws_s3.NotificationKeyFilter

---

##### `addObjectRemovedNotification` <a name="addObjectRemovedNotification" id="cdk-extensions.s3_buckets.WafLogsBucket.addObjectRemovedNotification"></a>

```typescript
public addObjectRemovedNotification(_dest: IBucketNotificationDestination, _filters: NotificationKeyFilter): void
```

Subscribes a destination to receive notifications when an object is removed from the bucket.

This is identical to calling
`onEvent(EventType.OBJECT_REMOVED)`.

###### `_dest`<sup>Required</sup> <a name="_dest" id="cdk-extensions.s3_buckets.WafLogsBucket.addObjectRemovedNotification.parameter._dest"></a>

- *Type:* aws-cdk-lib.aws_s3.IBucketNotificationDestination

---

###### `_filters`<sup>Required</sup> <a name="_filters" id="cdk-extensions.s3_buckets.WafLogsBucket.addObjectRemovedNotification.parameter._filters"></a>

- *Type:* aws-cdk-lib.aws_s3.NotificationKeyFilter

---

##### `addToResourcePolicy` <a name="addToResourcePolicy" id="cdk-extensions.s3_buckets.WafLogsBucket.addToResourcePolicy"></a>

```typescript
public addToResourcePolicy(permission: PolicyStatement): AddToResourcePolicyResult
```

Adds a statement to the resource policy for a principal (i.e. account/role/service) to perform actions on this bucket and/or its contents. Use `bucketArn` and `arnForObjects(keys)` to obtain ARNs for this bucket or objects.

Note that the policy statement may or may not be added to the policy.
For example, when an `IBucket` is created from an existing bucket,
it's not possible to tell whether the bucket already has a policy
attached, let alone to re-use that policy to add more statements to it.
So it's safest to do nothing in these cases.

###### `permission`<sup>Required</sup> <a name="permission" id="cdk-extensions.s3_buckets.WafLogsBucket.addToResourcePolicy.parameter.permission"></a>

- *Type:* aws-cdk-lib.aws_iam.PolicyStatement

---

##### `arnForObjects` <a name="arnForObjects" id="cdk-extensions.s3_buckets.WafLogsBucket.arnForObjects"></a>

```typescript
public arnForObjects(_keyPattern: string): string
```

Returns an ARN that represents all objects within the bucket that match the key pattern specified.

To represent all keys, specify ``"*"``.

###### `_keyPattern`<sup>Required</sup> <a name="_keyPattern" id="cdk-extensions.s3_buckets.WafLogsBucket.arnForObjects.parameter._keyPattern"></a>

- *Type:* string

---

##### `enableEventBridgeNotification` <a name="enableEventBridgeNotification" id="cdk-extensions.s3_buckets.WafLogsBucket.enableEventBridgeNotification"></a>

```typescript
public enableEventBridgeNotification(): void
```

Enables event bridge notification, causing all events below to be sent to EventBridge:.

Object Deleted (DeleteObject)
- Object Deleted (Lifecycle expiration)
- Object Restore Initiated
- Object Restore Completed
- Object Restore Expired
- Object Storage Class Changed
- Object Access Tier Changed
- Object ACL Updated
- Object Tags Added
- Object Tags Deleted

##### `grantDelete` <a name="grantDelete" id="cdk-extensions.s3_buckets.WafLogsBucket.grantDelete"></a>

```typescript
public grantDelete(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grants s3:DeleteObject* permission to an IAM principal for objects in this bucket.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.WafLogsBucket.grantDelete.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.WafLogsBucket.grantDelete.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `grantPublicAccess` <a name="grantPublicAccess" id="cdk-extensions.s3_buckets.WafLogsBucket.grantPublicAccess"></a>

```typescript
public grantPublicAccess(_allowedActions: string, _keyPrefix?: string): Grant
```

Allows unrestricted access to objects from this bucket.

IMPORTANT: This permission allows anyone to perform actions on S3 objects
in this bucket, which is useful for when you configure your bucket as a
website and want everyone to be able to read objects in the bucket without
needing to authenticate.

Without arguments, this method will grant read ("s3:GetObject") access to
all objects ("*") in the bucket.

The method returns the `iam.Grant` object, which can then be modified
as needed. For example, you can add a condition that will restrict access only
to an IPv4 range like this:

     const grant = bucket.grantPublicAccess();
     grant.resourceStatement!.addCondition(‘IpAddress’, { “aws:SourceIp”: “54.240.143.0/24” });

###### `_allowedActions`<sup>Required</sup> <a name="_allowedActions" id="cdk-extensions.s3_buckets.WafLogsBucket.grantPublicAccess.parameter._allowedActions"></a>

- *Type:* string

---

###### `_keyPrefix`<sup>Optional</sup> <a name="_keyPrefix" id="cdk-extensions.s3_buckets.WafLogsBucket.grantPublicAccess.parameter._keyPrefix"></a>

- *Type:* string

---

##### `grantPut` <a name="grantPut" id="cdk-extensions.s3_buckets.WafLogsBucket.grantPut"></a>

```typescript
public grantPut(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal.

If encryption is used, permission to use the key to encrypt the contents
of written files will also be granted to the same principal.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.WafLogsBucket.grantPut.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.WafLogsBucket.grantPut.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `grantPutAcl` <a name="grantPutAcl" id="cdk-extensions.s3_buckets.WafLogsBucket.grantPutAcl"></a>

```typescript
public grantPutAcl(_identity: IGrantable, _objectsKeyPattern?: string): Grant
```

Grant the given IAM identity permissions to modify the ACLs of objects in the given Bucket.

If your application has the '@aws-cdk/aws-s3:grantWriteWithoutAcl' feature flag set,
calling {@link grantWrite} or {@link grantReadWrite} no longer grants permissions to modify the ACLs of the objects;
in this case, if you need to modify object ACLs, call this method explicitly.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.WafLogsBucket.grantPutAcl.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.WafLogsBucket.grantPutAcl.parameter._objectsKeyPattern"></a>

- *Type:* string

---

##### `grantRead` <a name="grantRead" id="cdk-extensions.s3_buckets.WafLogsBucket.grantRead"></a>

```typescript
public grantRead(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grant read permissions for this bucket and it's contents to an IAM principal (Role/Group/User).

If encryption is used, permission to use the key to decrypt the contents
of the bucket will also be granted to the same principal.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.WafLogsBucket.grantRead.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.WafLogsBucket.grantRead.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `grantReadWrite` <a name="grantReadWrite" id="cdk-extensions.s3_buckets.WafLogsBucket.grantReadWrite"></a>

```typescript
public grantReadWrite(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grants read/write permissions for this bucket and it's contents to an IAM principal (Role/Group/User).

If an encryption key is used, permission to use the key for
encrypt/decrypt will also be granted.

Before CDK version 1.85.0, this method granted the `s3:PutObject*` permission that included `s3:PutObjectAcl`,
which could be used to grant read/write object access to IAM principals in other accounts.
If you want to get rid of that behavior, update your CDK version to 1.85.0 or later,
and make sure the `@aws-cdk/aws-s3:grantWriteWithoutAcl` feature flag is set to `true`
in the `context` key of your cdk.json file.
If you've already updated, but still need the principal to have permissions to modify the ACLs,
use the {@link grantPutAcl} method.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.WafLogsBucket.grantReadWrite.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.WafLogsBucket.grantReadWrite.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `grantWrite` <a name="grantWrite" id="cdk-extensions.s3_buckets.WafLogsBucket.grantWrite"></a>

```typescript
public grantWrite(_identity: IGrantable, _objectsKeyPattern?: any): Grant
```

Grant write permissions to this bucket to an IAM principal.

If encryption is used, permission to use the key to encrypt the contents
of written files will also be granted to the same principal.

Before CDK version 1.85.0, this method granted the `s3:PutObject*` permission that included `s3:PutObjectAcl`,
which could be used to grant read/write object access to IAM principals in other accounts.
If you want to get rid of that behavior, update your CDK version to 1.85.0 or later,
and make sure the `@aws-cdk/aws-s3:grantWriteWithoutAcl` feature flag is set to `true`
in the `context` key of your cdk.json file.
If you've already updated, but still need the principal to have permissions to modify the ACLs,
use the {@link grantPutAcl} method.

###### `_identity`<sup>Required</sup> <a name="_identity" id="cdk-extensions.s3_buckets.WafLogsBucket.grantWrite.parameter._identity"></a>

- *Type:* aws-cdk-lib.aws_iam.IGrantable

---

###### `_objectsKeyPattern`<sup>Optional</sup> <a name="_objectsKeyPattern" id="cdk-extensions.s3_buckets.WafLogsBucket.grantWrite.parameter._objectsKeyPattern"></a>

- *Type:* any

---

##### `onCloudTrailEvent` <a name="onCloudTrailEvent" id="cdk-extensions.s3_buckets.WafLogsBucket.onCloudTrailEvent"></a>

```typescript
public onCloudTrailEvent(_id: string, _options?: OnCloudTrailBucketEventOptions): Rule
```

Defines a CloudWatch event that triggers when something happens to this bucket.

Requires that there exists at least one CloudTrail Trail in your account
that captures the event. This method will not create the Trail.

###### `_id`<sup>Required</sup> <a name="_id" id="cdk-extensions.s3_buckets.WafLogsBucket.onCloudTrailEvent.parameter._id"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.WafLogsBucket.onCloudTrailEvent.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.OnCloudTrailBucketEventOptions

---

##### `onCloudTrailPutObject` <a name="onCloudTrailPutObject" id="cdk-extensions.s3_buckets.WafLogsBucket.onCloudTrailPutObject"></a>

```typescript
public onCloudTrailPutObject(_id: string, _options?: OnCloudTrailBucketEventOptions): Rule
```

Defines an AWS CloudWatch event that triggers when an object is uploaded to the specified paths (keys) in this bucket using the PutObject API call.

Note that some tools like `aws s3 cp` will automatically use either
PutObject or the multipart upload API depending on the file size,
so using `onCloudTrailWriteObject` may be preferable.

Requires that there exists at least one CloudTrail Trail in your account
that captures the event. This method will not create the Trail.

###### `_id`<sup>Required</sup> <a name="_id" id="cdk-extensions.s3_buckets.WafLogsBucket.onCloudTrailPutObject.parameter._id"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.WafLogsBucket.onCloudTrailPutObject.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.OnCloudTrailBucketEventOptions

---

##### `onCloudTrailWriteObject` <a name="onCloudTrailWriteObject" id="cdk-extensions.s3_buckets.WafLogsBucket.onCloudTrailWriteObject"></a>

```typescript
public onCloudTrailWriteObject(_id: string, _options?: OnCloudTrailBucketEventOptions): Rule
```

Defines an AWS CloudWatch event that triggers when an object at the specified paths (keys) in this bucket are written to.

This includes
the events PutObject, CopyObject, and CompleteMultipartUpload.

Note that some tools like `aws s3 cp` will automatically use either
PutObject or the multipart upload API depending on the file size,
so using this method may be preferable to `onCloudTrailPutObject`.

Requires that there exists at least one CloudTrail Trail in your account
that captures the event. This method will not create the Trail.

###### `_id`<sup>Required</sup> <a name="_id" id="cdk-extensions.s3_buckets.WafLogsBucket.onCloudTrailWriteObject.parameter._id"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.WafLogsBucket.onCloudTrailWriteObject.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.OnCloudTrailBucketEventOptions

---

##### `s3UrlForObject` <a name="s3UrlForObject" id="cdk-extensions.s3_buckets.WafLogsBucket.s3UrlForObject"></a>

```typescript
public s3UrlForObject(_key?: string): string
```

The S3 URL of an S3 object.

For example:
- `s3://onlybucket`
- `s3://bucket/key`

###### `_key`<sup>Optional</sup> <a name="_key" id="cdk-extensions.s3_buckets.WafLogsBucket.s3UrlForObject.parameter._key"></a>

- *Type:* string

---

##### `transferAccelerationUrlForObject` <a name="transferAccelerationUrlForObject" id="cdk-extensions.s3_buckets.WafLogsBucket.transferAccelerationUrlForObject"></a>

```typescript
public transferAccelerationUrlForObject(_key?: string, _options?: TransferAccelerationUrlOptions): string
```

The https Transfer Acceleration URL of an S3 object.

Specify `dualStack: true` at the options
for dual-stack endpoint (connect to the bucket over IPv6). For example:

- `https://bucket.s3-accelerate.amazonaws.com`
- `https://bucket.s3-accelerate.amazonaws.com/key`

###### `_key`<sup>Optional</sup> <a name="_key" id="cdk-extensions.s3_buckets.WafLogsBucket.transferAccelerationUrlForObject.parameter._key"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.WafLogsBucket.transferAccelerationUrlForObject.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.TransferAccelerationUrlOptions

---

##### `urlForObject` <a name="urlForObject" id="cdk-extensions.s3_buckets.WafLogsBucket.urlForObject"></a>

```typescript
public urlForObject(_key?: string): string
```

The https URL of an S3 object. For example:.

`https://s3.us-west-1.amazonaws.com/onlybucket`
- `https://s3.us-west-1.amazonaws.com/bucket/key`
- `https://s3.cn-north-1.amazonaws.com.cn/china-bucket/mykey`

###### `_key`<sup>Optional</sup> <a name="_key" id="cdk-extensions.s3_buckets.WafLogsBucket.urlForObject.parameter._key"></a>

- *Type:* string

---

##### `virtualHostedUrlForObject` <a name="virtualHostedUrlForObject" id="cdk-extensions.s3_buckets.WafLogsBucket.virtualHostedUrlForObject"></a>

```typescript
public virtualHostedUrlForObject(_key?: string, _options?: VirtualHostedStyleUrlOptions): string
```

The virtual hosted-style URL of an S3 object. Specify `regional: false` at the options for non-regional URL. For example:.

`https://only-bucket.s3.us-west-1.amazonaws.com`
- `https://bucket.s3.us-west-1.amazonaws.com/key`
- `https://bucket.s3.amazonaws.com/key`
- `https://china-bucket.s3.cn-north-1.amazonaws.com.cn/mykey`

###### `_key`<sup>Optional</sup> <a name="_key" id="cdk-extensions.s3_buckets.WafLogsBucket.virtualHostedUrlForObject.parameter._key"></a>

- *Type:* string

---

###### `_options`<sup>Optional</sup> <a name="_options" id="cdk-extensions.s3_buckets.WafLogsBucket.virtualHostedUrlForObject.parameter._options"></a>

- *Type:* aws-cdk-lib.aws_s3.VirtualHostedStyleUrlOptions

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.isOwnedResource">isOwnedResource</a></code> | Returns true if the construct was created by CDK, and false otherwise. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.isResource">isResource</a></code> | Check whether the given construct is a Resource. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-extensions.s3_buckets.WafLogsBucket.isConstruct"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

s3_buckets.WafLogsBucket.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-extensions.s3_buckets.WafLogsBucket.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isOwnedResource` <a name="isOwnedResource" id="cdk-extensions.s3_buckets.WafLogsBucket.isOwnedResource"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

s3_buckets.WafLogsBucket.isOwnedResource(construct: IConstruct)
```

Returns true if the construct was created by CDK, and false otherwise.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.s3_buckets.WafLogsBucket.isOwnedResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `isResource` <a name="isResource" id="cdk-extensions.s3_buckets.WafLogsBucket.isResource"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

s3_buckets.WafLogsBucket.isResource(construct: IConstruct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.s3_buckets.WafLogsBucket.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.property.env">env</a></code> | <code>aws-cdk-lib.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.property.stack">stack</a></code> | <code>aws-cdk-lib.Stack</code> | The stack in which this resource is defined. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.property.bucketArn">bucketArn</a></code> | <code>string</code> | The ARN of the bucket. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.property.bucketDomainName">bucketDomainName</a></code> | <code>string</code> | The IPv4 DNS name of the specified bucket. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.property.bucketDualStackDomainName">bucketDualStackDomainName</a></code> | <code>string</code> | The IPv6 DNS name of the specified bucket. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.property.bucketName">bucketName</a></code> | <code>string</code> | The name of the bucket. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.property.bucketRegionalDomainName">bucketRegionalDomainName</a></code> | <code>string</code> | The regional domain name of the specified bucket. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.property.bucketWebsiteDomainName">bucketWebsiteDomainName</a></code> | <code>string</code> | The Domain name of the static website. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.property.bucketWebsiteUrl">bucketWebsiteUrl</a></code> | <code>string</code> | The URL of the static website. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.property.resource">resource</a></code> | <code>aws-cdk-lib.aws_s3.CfnBucket</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.property.encryptionKey">encryptionKey</a></code> | <code>aws-cdk-lib.aws_kms.IKey</code> | Optional KMS encryption key associated with this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.property.isWebsite">isWebsite</a></code> | <code>boolean</code> | If this bucket has been configured for static website hosting. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.property.policy">policy</a></code> | <code>aws-cdk-lib.aws_s3.BucketPolicy</code> | The resource policy associated with this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.property.database">database</a></code> | <code>cdk-extensions.glue.Database</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.property.table">table</a></code> | <code>cdk-extensions.glue_tables.WafLogsTable</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.property.createQueries">createQueries</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucket.property.friendlyQueryNames">friendlyQueryNames</a></code> | <code>boolean</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-extensions.s3_buckets.WafLogsBucket.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="cdk-extensions.s3_buckets.WafLogsBucket.property.env"></a>

```typescript
public readonly env: ResourceEnvironment;
```

- *Type:* aws-cdk-lib.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="cdk-extensions.s3_buckets.WafLogsBucket.property.stack"></a>

```typescript
public readonly stack: Stack;
```

- *Type:* aws-cdk-lib.Stack

The stack in which this resource is defined.

---

##### `bucketArn`<sup>Required</sup> <a name="bucketArn" id="cdk-extensions.s3_buckets.WafLogsBucket.property.bucketArn"></a>

```typescript
public readonly bucketArn: string;
```

- *Type:* string

The ARN of the bucket.

---

##### `bucketDomainName`<sup>Required</sup> <a name="bucketDomainName" id="cdk-extensions.s3_buckets.WafLogsBucket.property.bucketDomainName"></a>

```typescript
public readonly bucketDomainName: string;
```

- *Type:* string

The IPv4 DNS name of the specified bucket.

---

##### `bucketDualStackDomainName`<sup>Required</sup> <a name="bucketDualStackDomainName" id="cdk-extensions.s3_buckets.WafLogsBucket.property.bucketDualStackDomainName"></a>

```typescript
public readonly bucketDualStackDomainName: string;
```

- *Type:* string

The IPv6 DNS name of the specified bucket.

---

##### `bucketName`<sup>Required</sup> <a name="bucketName" id="cdk-extensions.s3_buckets.WafLogsBucket.property.bucketName"></a>

```typescript
public readonly bucketName: string;
```

- *Type:* string

The name of the bucket.

---

##### `bucketRegionalDomainName`<sup>Required</sup> <a name="bucketRegionalDomainName" id="cdk-extensions.s3_buckets.WafLogsBucket.property.bucketRegionalDomainName"></a>

```typescript
public readonly bucketRegionalDomainName: string;
```

- *Type:* string

The regional domain name of the specified bucket.

---

##### `bucketWebsiteDomainName`<sup>Required</sup> <a name="bucketWebsiteDomainName" id="cdk-extensions.s3_buckets.WafLogsBucket.property.bucketWebsiteDomainName"></a>

```typescript
public readonly bucketWebsiteDomainName: string;
```

- *Type:* string

The Domain name of the static website.

---

##### `bucketWebsiteUrl`<sup>Required</sup> <a name="bucketWebsiteUrl" id="cdk-extensions.s3_buckets.WafLogsBucket.property.bucketWebsiteUrl"></a>

```typescript
public readonly bucketWebsiteUrl: string;
```

- *Type:* string

The URL of the static website.

---

##### `resource`<sup>Required</sup> <a name="resource" id="cdk-extensions.s3_buckets.WafLogsBucket.property.resource"></a>

```typescript
public readonly resource: CfnBucket;
```

- *Type:* aws-cdk-lib.aws_s3.CfnBucket

---

##### `encryptionKey`<sup>Optional</sup> <a name="encryptionKey" id="cdk-extensions.s3_buckets.WafLogsBucket.property.encryptionKey"></a>

```typescript
public readonly encryptionKey: IKey;
```

- *Type:* aws-cdk-lib.aws_kms.IKey

Optional KMS encryption key associated with this bucket.

---

##### `isWebsite`<sup>Optional</sup> <a name="isWebsite" id="cdk-extensions.s3_buckets.WafLogsBucket.property.isWebsite"></a>

```typescript
public readonly isWebsite: boolean;
```

- *Type:* boolean

If this bucket has been configured for static website hosting.

---

##### `policy`<sup>Optional</sup> <a name="policy" id="cdk-extensions.s3_buckets.WafLogsBucket.property.policy"></a>

```typescript
public readonly policy: BucketPolicy;
```

- *Type:* aws-cdk-lib.aws_s3.BucketPolicy

The resource policy associated with this bucket.

If `autoCreatePolicy` is true, a `BucketPolicy` will be created upon the
first call to addToResourcePolicy(s).

---

##### `database`<sup>Required</sup> <a name="database" id="cdk-extensions.s3_buckets.WafLogsBucket.property.database"></a>

```typescript
public readonly database: Database;
```

- *Type:* cdk-extensions.glue.Database

---

##### `table`<sup>Required</sup> <a name="table" id="cdk-extensions.s3_buckets.WafLogsBucket.property.table"></a>

```typescript
public readonly table: WafLogsTable;
```

- *Type:* cdk-extensions.glue_tables.WafLogsTable

---

##### `createQueries`<sup>Optional</sup> <a name="createQueries" id="cdk-extensions.s3_buckets.WafLogsBucket.property.createQueries"></a>

```typescript
public readonly createQueries: boolean;
```

- *Type:* boolean

---

##### `friendlyQueryNames`<sup>Optional</sup> <a name="friendlyQueryNames" id="cdk-extensions.s3_buckets.WafLogsBucket.property.friendlyQueryNames"></a>

```typescript
public readonly friendlyQueryNames: boolean;
```

- *Type:* boolean

---


### WafLogsTable <a name="WafLogsTable" id="cdk-extensions.glue_tables.WafLogsTable"></a>

#### Initializers <a name="Initializers" id="cdk-extensions.glue_tables.WafLogsTable.Initializer"></a>

```typescript
import { glue_tables } from 'cdk-extensions'

new glue_tables.WafLogsTable(scope: Construct, id: string, props: WafLogsTableProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTable.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | A CDK Construct that will serve as this stack's parent in the construct tree. |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTable.Initializer.parameter.id">id</a></code> | <code>string</code> | A name to be associated with the stack and used in resource naming. |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTable.Initializer.parameter.props">props</a></code> | <code>cdk-extensions.glue_tables.WafLogsTableProps</code> | Arguments related to the configuration of the resource. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.glue_tables.WafLogsTable.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

A CDK Construct that will serve as this stack's parent in the construct tree.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.glue_tables.WafLogsTable.Initializer.parameter.id"></a>

- *Type:* string

A name to be associated with the stack and used in resource naming.

Must be unique
within the context of 'scope'.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk-extensions.glue_tables.WafLogsTable.Initializer.parameter.props"></a>

- *Type:* cdk-extensions.glue_tables.WafLogsTableProps

Arguments related to the configuration of the resource.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTable.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTable.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTable.addColumn">addColumn</a></code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTable.addParameter">addParameter</a></code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTable.addPartitionKey">addPartitionKey</a></code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTable.addSerdeParameter">addSerdeParameter</a></code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTable.addStorageParameter">addStorageParameter</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="cdk-extensions.glue_tables.WafLogsTable.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="cdk-extensions.glue_tables.WafLogsTable.applyRemovalPolicy"></a>

```typescript
public applyRemovalPolicy(policy: RemovalPolicy): void
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="cdk-extensions.glue_tables.WafLogsTable.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.RemovalPolicy

---

##### `addColumn` <a name="addColumn" id="cdk-extensions.glue_tables.WafLogsTable.addColumn"></a>

```typescript
public addColumn(column: Column): void
```

###### `column`<sup>Required</sup> <a name="column" id="cdk-extensions.glue_tables.WafLogsTable.addColumn.parameter.column"></a>

- *Type:* cdk-extensions.glue.Column

---

##### `addParameter` <a name="addParameter" id="cdk-extensions.glue_tables.WafLogsTable.addParameter"></a>

```typescript
public addParameter(key: string, value: string): void
```

###### `key`<sup>Required</sup> <a name="key" id="cdk-extensions.glue_tables.WafLogsTable.addParameter.parameter.key"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="cdk-extensions.glue_tables.WafLogsTable.addParameter.parameter.value"></a>

- *Type:* string

---

##### `addPartitionKey` <a name="addPartitionKey" id="cdk-extensions.glue_tables.WafLogsTable.addPartitionKey"></a>

```typescript
public addPartitionKey(column: Column): void
```

###### `column`<sup>Required</sup> <a name="column" id="cdk-extensions.glue_tables.WafLogsTable.addPartitionKey.parameter.column"></a>

- *Type:* cdk-extensions.glue.Column

---

##### `addSerdeParameter` <a name="addSerdeParameter" id="cdk-extensions.glue_tables.WafLogsTable.addSerdeParameter"></a>

```typescript
public addSerdeParameter(key: string, value: string): void
```

###### `key`<sup>Required</sup> <a name="key" id="cdk-extensions.glue_tables.WafLogsTable.addSerdeParameter.parameter.key"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="cdk-extensions.glue_tables.WafLogsTable.addSerdeParameter.parameter.value"></a>

- *Type:* string

---

##### `addStorageParameter` <a name="addStorageParameter" id="cdk-extensions.glue_tables.WafLogsTable.addStorageParameter"></a>

```typescript
public addStorageParameter(key: string, value: string): void
```

###### `key`<sup>Required</sup> <a name="key" id="cdk-extensions.glue_tables.WafLogsTable.addStorageParameter.parameter.key"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="cdk-extensions.glue_tables.WafLogsTable.addStorageParameter.parameter.value"></a>

- *Type:* string

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTable.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTable.isOwnedResource">isOwnedResource</a></code> | Returns true if the construct was created by CDK, and false otherwise. |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTable.isResource">isResource</a></code> | Check whether the given construct is a Resource. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-extensions.glue_tables.WafLogsTable.isConstruct"></a>

```typescript
import { glue_tables } from 'cdk-extensions'

glue_tables.WafLogsTable.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-extensions.glue_tables.WafLogsTable.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isOwnedResource` <a name="isOwnedResource" id="cdk-extensions.glue_tables.WafLogsTable.isOwnedResource"></a>

```typescript
import { glue_tables } from 'cdk-extensions'

glue_tables.WafLogsTable.isOwnedResource(construct: IConstruct)
```

Returns true if the construct was created by CDK, and false otherwise.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.glue_tables.WafLogsTable.isOwnedResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `isResource` <a name="isResource" id="cdk-extensions.glue_tables.WafLogsTable.isResource"></a>

```typescript
import { glue_tables } from 'cdk-extensions'

glue_tables.WafLogsTable.isResource(construct: IConstruct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.glue_tables.WafLogsTable.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTable.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTable.property.env">env</a></code> | <code>aws-cdk-lib.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTable.property.stack">stack</a></code> | <code>aws-cdk-lib.Stack</code> | The stack in which this resource is defined. |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTable.property.database">database</a></code> | <code>cdk-extensions.glue.Database</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTable.property.resource">resource</a></code> | <code>aws-cdk-lib.aws_glue.CfnTable</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTable.property.tableArn">tableArn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTable.property.tableName">tableName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTable.property.compressed">compressed</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTable.property.dataFormat">dataFormat</a></code> | <code>cdk-extensions.glue.DataFormat</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTable.property.description">description</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTable.property.location">location</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTable.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTable.property.owner">owner</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTable.property.retention">retention</a></code> | <code>aws-cdk-lib.Duration</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTable.property.serdeName">serdeName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTable.property.storedAsSubDirectories">storedAsSubDirectories</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTable.property.tableType">tableType</a></code> | <code>cdk-extensions.glue.TableType</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTable.property.targetTable">targetTable</a></code> | <code>cdk-extensions.glue.Table</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTable.property.viewExpandedText">viewExpandedText</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTable.property.viewOriginalText">viewOriginalText</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTable.property.createQueries">createQueries</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTable.property.friendlyQueryNames">friendlyQueryNames</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTable.property.status5xxNamedQuery">status5xxNamedQuery</a></code> | <code>cdk-extensions.athena.NamedQuery</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTable.property.topIpsNamedQuery">topIpsNamedQuery</a></code> | <code>cdk-extensions.athena.NamedQuery</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-extensions.glue_tables.WafLogsTable.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="cdk-extensions.glue_tables.WafLogsTable.property.env"></a>

```typescript
public readonly env: ResourceEnvironment;
```

- *Type:* aws-cdk-lib.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="cdk-extensions.glue_tables.WafLogsTable.property.stack"></a>

```typescript
public readonly stack: Stack;
```

- *Type:* aws-cdk-lib.Stack

The stack in which this resource is defined.

---

##### `database`<sup>Required</sup> <a name="database" id="cdk-extensions.glue_tables.WafLogsTable.property.database"></a>

```typescript
public readonly database: Database;
```

- *Type:* cdk-extensions.glue.Database

---

##### `resource`<sup>Required</sup> <a name="resource" id="cdk-extensions.glue_tables.WafLogsTable.property.resource"></a>

```typescript
public readonly resource: CfnTable;
```

- *Type:* aws-cdk-lib.aws_glue.CfnTable

---

##### `tableArn`<sup>Required</sup> <a name="tableArn" id="cdk-extensions.glue_tables.WafLogsTable.property.tableArn"></a>

```typescript
public readonly tableArn: string;
```

- *Type:* string

---

##### `tableName`<sup>Required</sup> <a name="tableName" id="cdk-extensions.glue_tables.WafLogsTable.property.tableName"></a>

```typescript
public readonly tableName: string;
```

- *Type:* string

---

##### `compressed`<sup>Optional</sup> <a name="compressed" id="cdk-extensions.glue_tables.WafLogsTable.property.compressed"></a>

```typescript
public readonly compressed: boolean;
```

- *Type:* boolean

---

##### `dataFormat`<sup>Optional</sup> <a name="dataFormat" id="cdk-extensions.glue_tables.WafLogsTable.property.dataFormat"></a>

```typescript
public readonly dataFormat: DataFormat;
```

- *Type:* cdk-extensions.glue.DataFormat

---

##### `description`<sup>Optional</sup> <a name="description" id="cdk-extensions.glue_tables.WafLogsTable.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

---

##### `location`<sup>Optional</sup> <a name="location" id="cdk-extensions.glue_tables.WafLogsTable.property.location"></a>

```typescript
public readonly location: string;
```

- *Type:* string

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.glue_tables.WafLogsTable.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `owner`<sup>Optional</sup> <a name="owner" id="cdk-extensions.glue_tables.WafLogsTable.property.owner"></a>

```typescript
public readonly owner: string;
```

- *Type:* string

---

##### `retention`<sup>Optional</sup> <a name="retention" id="cdk-extensions.glue_tables.WafLogsTable.property.retention"></a>

```typescript
public readonly retention: Duration;
```

- *Type:* aws-cdk-lib.Duration

---

##### `serdeName`<sup>Optional</sup> <a name="serdeName" id="cdk-extensions.glue_tables.WafLogsTable.property.serdeName"></a>

```typescript
public readonly serdeName: string;
```

- *Type:* string

---

##### `storedAsSubDirectories`<sup>Optional</sup> <a name="storedAsSubDirectories" id="cdk-extensions.glue_tables.WafLogsTable.property.storedAsSubDirectories"></a>

```typescript
public readonly storedAsSubDirectories: boolean;
```

- *Type:* boolean

---

##### `tableType`<sup>Optional</sup> <a name="tableType" id="cdk-extensions.glue_tables.WafLogsTable.property.tableType"></a>

```typescript
public readonly tableType: TableType;
```

- *Type:* cdk-extensions.glue.TableType

---

##### `targetTable`<sup>Optional</sup> <a name="targetTable" id="cdk-extensions.glue_tables.WafLogsTable.property.targetTable"></a>

```typescript
public readonly targetTable: Table;
```

- *Type:* cdk-extensions.glue.Table

---

##### `viewExpandedText`<sup>Optional</sup> <a name="viewExpandedText" id="cdk-extensions.glue_tables.WafLogsTable.property.viewExpandedText"></a>

```typescript
public readonly viewExpandedText: string;
```

- *Type:* string

---

##### `viewOriginalText`<sup>Optional</sup> <a name="viewOriginalText" id="cdk-extensions.glue_tables.WafLogsTable.property.viewOriginalText"></a>

```typescript
public readonly viewOriginalText: string;
```

- *Type:* string

---

##### `createQueries`<sup>Required</sup> <a name="createQueries" id="cdk-extensions.glue_tables.WafLogsTable.property.createQueries"></a>

```typescript
public readonly createQueries: boolean;
```

- *Type:* boolean

---

##### `friendlyQueryNames`<sup>Required</sup> <a name="friendlyQueryNames" id="cdk-extensions.glue_tables.WafLogsTable.property.friendlyQueryNames"></a>

```typescript
public readonly friendlyQueryNames: boolean;
```

- *Type:* boolean

---

##### `status5xxNamedQuery`<sup>Optional</sup> <a name="status5xxNamedQuery" id="cdk-extensions.glue_tables.WafLogsTable.property.status5xxNamedQuery"></a>

```typescript
public readonly status5xxNamedQuery: NamedQuery;
```

- *Type:* cdk-extensions.athena.NamedQuery

---

##### `topIpsNamedQuery`<sup>Optional</sup> <a name="topIpsNamedQuery" id="cdk-extensions.glue_tables.WafLogsTable.property.topIpsNamedQuery"></a>

```typescript
public readonly topIpsNamedQuery: NamedQuery;
```

- *Type:* cdk-extensions.athena.NamedQuery

---


### Workflow <a name="Workflow" id="cdk-extensions.glue.Workflow"></a>

#### Initializers <a name="Initializers" id="cdk-extensions.glue.Workflow.Initializer"></a>

```typescript
import { glue } from 'cdk-extensions'

new glue.Workflow(scope: Construct, id: string, props: WorkflowProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.Workflow.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Workflow.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Workflow.Initializer.parameter.props">props</a></code> | <code>cdk-extensions.glue.WorkflowProps</code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-extensions.glue.Workflow.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.glue.Workflow.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="cdk-extensions.glue.Workflow.Initializer.parameter.props"></a>

- *Type:* cdk-extensions.glue.WorkflowProps

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.glue.Workflow.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-extensions.glue.Workflow.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |
| <code><a href="#cdk-extensions.glue.Workflow.addTrigger">addTrigger</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="cdk-extensions.glue.Workflow.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="cdk-extensions.glue.Workflow.applyRemovalPolicy"></a>

```typescript
public applyRemovalPolicy(policy: RemovalPolicy): void
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="cdk-extensions.glue.Workflow.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.RemovalPolicy

---

##### `addTrigger` <a name="addTrigger" id="cdk-extensions.glue.Workflow.addTrigger"></a>

```typescript
public addTrigger(id: string, options: TriggerOptions): Trigger
```

###### `id`<sup>Required</sup> <a name="id" id="cdk-extensions.glue.Workflow.addTrigger.parameter.id"></a>

- *Type:* string

---

###### `options`<sup>Required</sup> <a name="options" id="cdk-extensions.glue.Workflow.addTrigger.parameter.options"></a>

- *Type:* cdk-extensions.glue.TriggerOptions

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-extensions.glue.Workflow.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-extensions.glue.Workflow.isOwnedResource">isOwnedResource</a></code> | Returns true if the construct was created by CDK, and false otherwise. |
| <code><a href="#cdk-extensions.glue.Workflow.isResource">isResource</a></code> | Check whether the given construct is a Resource. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-extensions.glue.Workflow.isConstruct"></a>

```typescript
import { glue } from 'cdk-extensions'

glue.Workflow.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-extensions.glue.Workflow.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isOwnedResource` <a name="isOwnedResource" id="cdk-extensions.glue.Workflow.isOwnedResource"></a>

```typescript
import { glue } from 'cdk-extensions'

glue.Workflow.isOwnedResource(construct: IConstruct)
```

Returns true if the construct was created by CDK, and false otherwise.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.glue.Workflow.isOwnedResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `isResource` <a name="isResource" id="cdk-extensions.glue.Workflow.isResource"></a>

```typescript
import { glue } from 'cdk-extensions'

glue.Workflow.isResource(construct: IConstruct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-extensions.glue.Workflow.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.Workflow.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-extensions.glue.Workflow.property.env">env</a></code> | <code>aws-cdk-lib.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#cdk-extensions.glue.Workflow.property.stack">stack</a></code> | <code>aws-cdk-lib.Stack</code> | The stack in which this resource is defined. |
| <code><a href="#cdk-extensions.glue.Workflow.property.resource">resource</a></code> | <code>aws-cdk-lib.aws_glue.CfnWorkflow</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Workflow.property.workflowArn">workflowArn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Workflow.property.workflowName">workflowName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Workflow.property.description">description</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.Workflow.property.name">name</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-extensions.glue.Workflow.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="cdk-extensions.glue.Workflow.property.env"></a>

```typescript
public readonly env: ResourceEnvironment;
```

- *Type:* aws-cdk-lib.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="cdk-extensions.glue.Workflow.property.stack"></a>

```typescript
public readonly stack: Stack;
```

- *Type:* aws-cdk-lib.Stack

The stack in which this resource is defined.

---

##### `resource`<sup>Required</sup> <a name="resource" id="cdk-extensions.glue.Workflow.property.resource"></a>

```typescript
public readonly resource: CfnWorkflow;
```

- *Type:* aws-cdk-lib.aws_glue.CfnWorkflow

---

##### `workflowArn`<sup>Required</sup> <a name="workflowArn" id="cdk-extensions.glue.Workflow.property.workflowArn"></a>

```typescript
public readonly workflowArn: string;
```

- *Type:* string

---

##### `workflowName`<sup>Required</sup> <a name="workflowName" id="cdk-extensions.glue.Workflow.property.workflowName"></a>

```typescript
public readonly workflowName: string;
```

- *Type:* string

---

##### `description`<sup>Optional</sup> <a name="description" id="cdk-extensions.glue.Workflow.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.glue.Workflow.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---


## Structs <a name="Structs" id="Structs"></a>

### AccessControlAttributeOptions <a name="AccessControlAttributeOptions" id="cdk-extensions.sso.AccessControlAttributeOptions"></a>

Configuration options for adding an ABAC attribute to IAM Identity Center.

#### Initializer <a name="Initializer" id="cdk-extensions.sso.AccessControlAttributeOptions.Initializer"></a>

```typescript
import { sso } from 'cdk-extensions'

const accessControlAttributeOptions: sso.AccessControlAttributeOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.sso.AccessControlAttributeOptions.property.name">name</a></code> | <code>string</code> | The name of the attribute associated with your identities in your identity source. |
| <code><a href="#cdk-extensions.sso.AccessControlAttributeOptions.property.sources">sources</a></code> | <code>string[]</code> | A list of identity sources to use when mapping a specified attribute to IAM Identity Center. |

---

##### `name`<sup>Required</sup> <a name="name" id="cdk-extensions.sso.AccessControlAttributeOptions.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the attribute associated with your identities in your identity source.

This is used to map a specified attribute in your
identity source with an attribute in IAM Identity Center.

---

##### `sources`<sup>Optional</sup> <a name="sources" id="cdk-extensions.sso.AccessControlAttributeOptions.property.sources"></a>

```typescript
public readonly sources: string[];
```

- *Type:* string[]

A list of identity sources to use when mapping a specified attribute to IAM Identity Center.

---

### AlbLogsBucketProps <a name="AlbLogsBucketProps" id="cdk-extensions.s3_buckets.AlbLogsBucketProps"></a>

Configuration for objects bucket.

#### Initializer <a name="Initializer" id="cdk-extensions.s3_buckets.AlbLogsBucketProps.Initializer"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

const albLogsBucketProps: s3_buckets.AlbLogsBucketProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucketProps.property.account">account</a></code> | <code>string</code> | The AWS account ID this resource belongs to. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucketProps.property.environmentFromArn">environmentFromArn</a></code> | <code>string</code> | ARN to deduce region and account from. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucketProps.property.physicalName">physicalName</a></code> | <code>string</code> | The value passed in by users to the physical name prop of the resource. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucketProps.property.region">region</a></code> | <code>string</code> | The AWS region this resource belongs to. |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucketProps.property.bucketName">bucketName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucketProps.property.createQueries">createQueries</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucketProps.property.database">database</a></code> | <code>cdk-extensions.glue.Database</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucketProps.property.friendlyQueryNames">friendlyQueryNames</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.AlbLogsBucketProps.property.tableName">tableName</a></code> | <code>string</code> | *No description.* |

---

##### `account`<sup>Optional</sup> <a name="account" id="cdk-extensions.s3_buckets.AlbLogsBucketProps.property.account"></a>

```typescript
public readonly account: string;
```

- *Type:* string
- *Default:* the resource is in the same account as the stack it belongs to

The AWS account ID this resource belongs to.

---

##### `environmentFromArn`<sup>Optional</sup> <a name="environmentFromArn" id="cdk-extensions.s3_buckets.AlbLogsBucketProps.property.environmentFromArn"></a>

```typescript
public readonly environmentFromArn: string;
```

- *Type:* string
- *Default:* take environment from `account`, `region` parameters, or use Stack environment.

ARN to deduce region and account from.

The ARN is parsed and the account and region are taken from the ARN.
This should be used for imported resources.

Cannot be supplied together with either `account` or `region`.

---

##### `physicalName`<sup>Optional</sup> <a name="physicalName" id="cdk-extensions.s3_buckets.AlbLogsBucketProps.property.physicalName"></a>

```typescript
public readonly physicalName: string;
```

- *Type:* string
- *Default:* The physical name will be allocated by CloudFormation at deployment time

The value passed in by users to the physical name prop of the resource.

`undefined` implies that a physical name will be allocated by
   CloudFormation during deployment.
- a concrete value implies a specific physical name
- `PhysicalName.GENERATE_IF_NEEDED` is a marker that indicates that a physical will only be generated
   by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.

---

##### `region`<sup>Optional</sup> <a name="region" id="cdk-extensions.s3_buckets.AlbLogsBucketProps.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string
- *Default:* the resource is in the same region as the stack it belongs to

The AWS region this resource belongs to.

---

##### `bucketName`<sup>Optional</sup> <a name="bucketName" id="cdk-extensions.s3_buckets.AlbLogsBucketProps.property.bucketName"></a>

```typescript
public readonly bucketName: string;
```

- *Type:* string

---

##### `createQueries`<sup>Optional</sup> <a name="createQueries" id="cdk-extensions.s3_buckets.AlbLogsBucketProps.property.createQueries"></a>

```typescript
public readonly createQueries: boolean;
```

- *Type:* boolean

---

##### `database`<sup>Optional</sup> <a name="database" id="cdk-extensions.s3_buckets.AlbLogsBucketProps.property.database"></a>

```typescript
public readonly database: Database;
```

- *Type:* cdk-extensions.glue.Database

---

##### `friendlyQueryNames`<sup>Optional</sup> <a name="friendlyQueryNames" id="cdk-extensions.s3_buckets.AlbLogsBucketProps.property.friendlyQueryNames"></a>

```typescript
public readonly friendlyQueryNames: boolean;
```

- *Type:* boolean

---

##### `tableName`<sup>Optional</sup> <a name="tableName" id="cdk-extensions.s3_buckets.AlbLogsBucketProps.property.tableName"></a>

```typescript
public readonly tableName: string;
```

- *Type:* string

---

### AlbLogsTableProps <a name="AlbLogsTableProps" id="cdk-extensions.glue_tables.AlbLogsTableProps"></a>

Configuration for AlbLogsTable.

#### Initializer <a name="Initializer" id="cdk-extensions.glue_tables.AlbLogsTableProps.Initializer"></a>

```typescript
import { glue_tables } from 'cdk-extensions'

const albLogsTableProps: glue_tables.AlbLogsTableProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTableProps.property.account">account</a></code> | <code>string</code> | The AWS account ID this resource belongs to. |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTableProps.property.environmentFromArn">environmentFromArn</a></code> | <code>string</code> | ARN to deduce region and account from. |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTableProps.property.physicalName">physicalName</a></code> | <code>string</code> | The value passed in by users to the physical name prop of the resource. |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTableProps.property.region">region</a></code> | <code>string</code> | The AWS region this resource belongs to. |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTableProps.property.bucket">bucket</a></code> | <code>aws-cdk-lib.aws_s3.IBucket</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTableProps.property.database">database</a></code> | <code>cdk-extensions.glue.Database</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTableProps.property.createQueries">createQueries</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTableProps.property.friendlyQueryNames">friendlyQueryNames</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTableProps.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.AlbLogsTableProps.property.s3Prefix">s3Prefix</a></code> | <code>string</code> | *No description.* |

---

##### `account`<sup>Optional</sup> <a name="account" id="cdk-extensions.glue_tables.AlbLogsTableProps.property.account"></a>

```typescript
public readonly account: string;
```

- *Type:* string
- *Default:* the resource is in the same account as the stack it belongs to

The AWS account ID this resource belongs to.

---

##### `environmentFromArn`<sup>Optional</sup> <a name="environmentFromArn" id="cdk-extensions.glue_tables.AlbLogsTableProps.property.environmentFromArn"></a>

```typescript
public readonly environmentFromArn: string;
```

- *Type:* string
- *Default:* take environment from `account`, `region` parameters, or use Stack environment.

ARN to deduce region and account from.

The ARN is parsed and the account and region are taken from the ARN.
This should be used for imported resources.

Cannot be supplied together with either `account` or `region`.

---

##### `physicalName`<sup>Optional</sup> <a name="physicalName" id="cdk-extensions.glue_tables.AlbLogsTableProps.property.physicalName"></a>

```typescript
public readonly physicalName: string;
```

- *Type:* string
- *Default:* The physical name will be allocated by CloudFormation at deployment time

The value passed in by users to the physical name prop of the resource.

`undefined` implies that a physical name will be allocated by
   CloudFormation during deployment.
- a concrete value implies a specific physical name
- `PhysicalName.GENERATE_IF_NEEDED` is a marker that indicates that a physical will only be generated
   by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.

---

##### `region`<sup>Optional</sup> <a name="region" id="cdk-extensions.glue_tables.AlbLogsTableProps.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string
- *Default:* the resource is in the same region as the stack it belongs to

The AWS region this resource belongs to.

---

##### `bucket`<sup>Required</sup> <a name="bucket" id="cdk-extensions.glue_tables.AlbLogsTableProps.property.bucket"></a>

```typescript
public readonly bucket: IBucket;
```

- *Type:* aws-cdk-lib.aws_s3.IBucket

---

##### `database`<sup>Required</sup> <a name="database" id="cdk-extensions.glue_tables.AlbLogsTableProps.property.database"></a>

```typescript
public readonly database: Database;
```

- *Type:* cdk-extensions.glue.Database

---

##### `createQueries`<sup>Optional</sup> <a name="createQueries" id="cdk-extensions.glue_tables.AlbLogsTableProps.property.createQueries"></a>

```typescript
public readonly createQueries: boolean;
```

- *Type:* boolean

---

##### `friendlyQueryNames`<sup>Optional</sup> <a name="friendlyQueryNames" id="cdk-extensions.glue_tables.AlbLogsTableProps.property.friendlyQueryNames"></a>

```typescript
public readonly friendlyQueryNames: boolean;
```

- *Type:* boolean

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.glue_tables.AlbLogsTableProps.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `s3Prefix`<sup>Optional</sup> <a name="s3Prefix" id="cdk-extensions.glue_tables.AlbLogsTableProps.property.s3Prefix"></a>

```typescript
public readonly s3Prefix: string;
```

- *Type:* string

---

### AppendDelimiterProcessorOptions <a name="AppendDelimiterProcessorOptions" id="cdk-extensions.kinesis_firehose.AppendDelimiterProcessorOptions"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.kinesis_firehose.AppendDelimiterProcessorOptions.Initializer"></a>

```typescript
import { kinesis_firehose } from 'cdk-extensions'

const appendDelimiterProcessorOptions: kinesis_firehose.AppendDelimiterProcessorOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.kinesis_firehose.AppendDelimiterProcessorOptions.property.delimiter">delimiter</a></code> | <code>string</code> | *No description.* |

---

##### `delimiter`<sup>Required</sup> <a name="delimiter" id="cdk-extensions.kinesis_firehose.AppendDelimiterProcessorOptions.property.delimiter"></a>

```typescript
public readonly delimiter: string;
```

- *Type:* string

---

### ArrayColumnProps <a name="ArrayColumnProps" id="cdk-extensions.glue.ArrayColumnProps"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.glue.ArrayColumnProps.Initializer"></a>

```typescript
import { glue } from 'cdk-extensions'

const arrayColumnProps: glue.ArrayColumnProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.ArrayColumnProps.property.comment">comment</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.ArrayColumnProps.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.ArrayColumnProps.property.data">data</a></code> | <code>cdk-extensions.glue.Column</code> | *No description.* |

---

##### `comment`<sup>Optional</sup> <a name="comment" id="cdk-extensions.glue.ArrayColumnProps.property.comment"></a>

```typescript
public readonly comment: string;
```

- *Type:* string

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.glue.ArrayColumnProps.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `data`<sup>Required</sup> <a name="data" id="cdk-extensions.glue.ArrayColumnProps.property.data"></a>

```typescript
public readonly data: Column;
```

- *Type:* cdk-extensions.glue.Column

---

### AssignmentProps <a name="AssignmentProps" id="cdk-extensions.sso.AssignmentProps"></a>

Configuration for Assignment resource.

#### Initializer <a name="Initializer" id="cdk-extensions.sso.AssignmentProps.Initializer"></a>

```typescript
import { sso } from 'cdk-extensions'

const assignmentProps: sso.AssignmentProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.sso.AssignmentProps.property.account">account</a></code> | <code>string</code> | The AWS account ID this resource belongs to. |
| <code><a href="#cdk-extensions.sso.AssignmentProps.property.environmentFromArn">environmentFromArn</a></code> | <code>string</code> | ARN to deduce region and account from. |
| <code><a href="#cdk-extensions.sso.AssignmentProps.property.physicalName">physicalName</a></code> | <code>string</code> | The value passed in by users to the physical name prop of the resource. |
| <code><a href="#cdk-extensions.sso.AssignmentProps.property.region">region</a></code> | <code>string</code> | The AWS region this resource belongs to. |
| <code><a href="#cdk-extensions.sso.AssignmentProps.property.instance">instance</a></code> | <code>cdk-extensions.sso.IInstance</code> | The IAM Identity Center instance under which the operation will be executed. |
| <code><a href="#cdk-extensions.sso.AssignmentProps.property.permissionSet">permissionSet</a></code> | <code>cdk-extensions.sso.IPermissionSet</code> | The permission set which governs the access being assigned. |
| <code><a href="#cdk-extensions.sso.AssignmentProps.property.principal">principal</a></code> | <code>cdk-extensions.sso.IIdentityCenterPrincipal</code> | The IAM Identity Center principal you wish to grant permissions to. |
| <code><a href="#cdk-extensions.sso.AssignmentProps.property.target">target</a></code> | <code>cdk-extensions.sso.AssignmentTarget</code> | The resource you wish to grant the {@link principal} entity access to using the permissions defined in the {@link permissionSet}. |

---

##### `account`<sup>Optional</sup> <a name="account" id="cdk-extensions.sso.AssignmentProps.property.account"></a>

```typescript
public readonly account: string;
```

- *Type:* string
- *Default:* the resource is in the same account as the stack it belongs to

The AWS account ID this resource belongs to.

---

##### `environmentFromArn`<sup>Optional</sup> <a name="environmentFromArn" id="cdk-extensions.sso.AssignmentProps.property.environmentFromArn"></a>

```typescript
public readonly environmentFromArn: string;
```

- *Type:* string
- *Default:* take environment from `account`, `region` parameters, or use Stack environment.

ARN to deduce region and account from.

The ARN is parsed and the account and region are taken from the ARN.
This should be used for imported resources.

Cannot be supplied together with either `account` or `region`.

---

##### `physicalName`<sup>Optional</sup> <a name="physicalName" id="cdk-extensions.sso.AssignmentProps.property.physicalName"></a>

```typescript
public readonly physicalName: string;
```

- *Type:* string
- *Default:* The physical name will be allocated by CloudFormation at deployment time

The value passed in by users to the physical name prop of the resource.

`undefined` implies that a physical name will be allocated by
   CloudFormation during deployment.
- a concrete value implies a specific physical name
- `PhysicalName.GENERATE_IF_NEEDED` is a marker that indicates that a physical will only be generated
   by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.

---

##### `region`<sup>Optional</sup> <a name="region" id="cdk-extensions.sso.AssignmentProps.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string
- *Default:* the resource is in the same region as the stack it belongs to

The AWS region this resource belongs to.

---

##### `instance`<sup>Required</sup> <a name="instance" id="cdk-extensions.sso.AssignmentProps.property.instance"></a>

```typescript
public readonly instance: IInstance;
```

- *Type:* cdk-extensions.sso.IInstance

The IAM Identity Center instance under which the operation will be executed.

---

##### `permissionSet`<sup>Required</sup> <a name="permissionSet" id="cdk-extensions.sso.AssignmentProps.property.permissionSet"></a>

```typescript
public readonly permissionSet: IPermissionSet;
```

- *Type:* cdk-extensions.sso.IPermissionSet

The permission set which governs the access being assigned.

The
permission set grants the {@link principal} permissions on
{@link target}.

---

##### `principal`<sup>Required</sup> <a name="principal" id="cdk-extensions.sso.AssignmentProps.property.principal"></a>

```typescript
public readonly principal: IIdentityCenterPrincipal;
```

- *Type:* cdk-extensions.sso.IIdentityCenterPrincipal

The IAM Identity Center principal you wish to grant permissions to.

---

##### `target`<sup>Required</sup> <a name="target" id="cdk-extensions.sso.AssignmentProps.property.target"></a>

```typescript
public readonly target: AssignmentTarget;
```

- *Type:* cdk-extensions.sso.AssignmentTarget

The resource you wish to grant the {@link principal} entity access to using the permissions defined in the {@link permissionSet}.

For example,
an AWS account.

---

### AwsLoggingStackProps <a name="AwsLoggingStackProps" id="cdk-extensions.stacks.AwsLoggingStackProps"></a>

Configuration for the demo service stack.

#### Initializer <a name="Initializer" id="cdk-extensions.stacks.AwsLoggingStackProps.Initializer"></a>

```typescript
import { stacks } from 'cdk-extensions'

const awsLoggingStackProps: stacks.AwsLoggingStackProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStackProps.property.analyticsReporting">analyticsReporting</a></code> | <code>boolean</code> | Include runtime versioning information in this Stack. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStackProps.property.description">description</a></code> | <code>string</code> | A description of the stack. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStackProps.property.env">env</a></code> | <code>aws-cdk-lib.Environment</code> | The AWS environment (account/region) where this stack will be deployed. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStackProps.property.stackName">stackName</a></code> | <code>string</code> | Name to deploy the stack with. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStackProps.property.synthesizer">synthesizer</a></code> | <code>aws-cdk-lib.IStackSynthesizer</code> | Synthesis method to use while deploying this stack. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStackProps.property.tags">tags</a></code> | <code>{[ key: string ]: string}</code> | Stack tags that will be applied to all the taggable resources and the stack itself. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStackProps.property.terminationProtection">terminationProtection</a></code> | <code>boolean</code> | Whether to enable termination protection for this stack. |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStackProps.property.albLogsBucket">albLogsBucket</a></code> | <code>cdk-extensions.s3_buckets.AlbLogsBucket</code> | *No description.* |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStackProps.property.cloudfrontLogsBucket">cloudfrontLogsBucket</a></code> | <code>cdk-extensions.s3_buckets.CloudfrontLogsBucket</code> | *No description.* |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStackProps.property.cloudtrailLogsBucket">cloudtrailLogsBucket</a></code> | <code>cdk-extensions.s3_buckets.CloudtrailBucket</code> | *No description.* |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStackProps.property.databaseName">databaseName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStackProps.property.flowLogsBucket">flowLogsBucket</a></code> | <code>cdk-extensions.s3_buckets.FlowLogsBucket</code> | *No description.* |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStackProps.property.flowLogsFormat">flowLogsFormat</a></code> | <code>cdk-extensions.ec2.FlowLogFormat</code> | *No description.* |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStackProps.property.friendlyQueryNames">friendlyQueryNames</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStackProps.property.sesLogsBucket">sesLogsBucket</a></code> | <code>cdk-extensions.s3_buckets.SesLogsBucket</code> | *No description.* |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStackProps.property.standardizeNames">standardizeNames</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.stacks.AwsLoggingStackProps.property.wafLogsBucket">wafLogsBucket</a></code> | <code>cdk-extensions.s3_buckets.WafLogsBucket</code> | *No description.* |

---

##### `analyticsReporting`<sup>Optional</sup> <a name="analyticsReporting" id="cdk-extensions.stacks.AwsLoggingStackProps.property.analyticsReporting"></a>

```typescript
public readonly analyticsReporting: boolean;
```

- *Type:* boolean
- *Default:* `analyticsReporting` setting of containing `App`, or value of 'aws:cdk:version-reporting' context key

Include runtime versioning information in this Stack.

---

##### `description`<sup>Optional</sup> <a name="description" id="cdk-extensions.stacks.AwsLoggingStackProps.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string
- *Default:* No description.

A description of the stack.

---

##### `env`<sup>Optional</sup> <a name="env" id="cdk-extensions.stacks.AwsLoggingStackProps.property.env"></a>

```typescript
public readonly env: Environment;
```

- *Type:* aws-cdk-lib.Environment
- *Default:* The environment of the containing `Stage` if available, otherwise create the stack will be environment-agnostic.

The AWS environment (account/region) where this stack will be deployed.

Set the `region`/`account` fields of `env` to either a concrete value to
select the indicated environment (recommended for production stacks), or to
the values of environment variables
`CDK_DEFAULT_REGION`/`CDK_DEFAULT_ACCOUNT` to let the target environment
depend on the AWS credentials/configuration that the CDK CLI is executed
under (recommended for development stacks).

If the `Stack` is instantiated inside a `Stage`, any undefined
`region`/`account` fields from `env` will default to the same field on the
encompassing `Stage`, if configured there.

If either `region` or `account` are not set nor inherited from `Stage`, the
Stack will be considered "*environment-agnostic*"". Environment-agnostic
stacks can be deployed to any environment but may not be able to take
advantage of all features of the CDK. For example, they will not be able to
use environmental context lookups such as `ec2.Vpc.fromLookup` and will not
automatically translate Service Principals to the right format based on the
environment's AWS partition, and other such enhancements.

---

*Example*

```typescript
// Use a concrete account and region to deploy this stack to:
// `.account` and `.region` will simply return these values.
new Stack(app, 'Stack1', {
  env: {
    account: '123456789012',
    region: 'us-east-1'
  },
});

// Use the CLI's current credentials to determine the target environment:
// `.account` and `.region` will reflect the account+region the CLI
// is configured to use (based on the user CLI credentials)
new Stack(app, 'Stack2', {
  env: {
    account: process.env.CDK_DEFAULT_ACCOUNT,
    region: process.env.CDK_DEFAULT_REGION
  },
});

// Define multiple stacks stage associated with an environment
const myStage = new Stage(app, 'MyStage', {
  env: {
    account: '123456789012',
    region: 'us-east-1'
  }
});

// both of these stacks will use the stage's account/region:
// `.account` and `.region` will resolve to the concrete values as above
new MyStack(myStage, 'Stack1');
new YourStack(myStage, 'Stack2');

// Define an environment-agnostic stack:
// `.account` and `.region` will resolve to `{ "Ref": "AWS::AccountId" }` and `{ "Ref": "AWS::Region" }` respectively.
// which will only resolve to actual values by CloudFormation during deployment.
new MyStack(app, 'Stack1');
```


##### `stackName`<sup>Optional</sup> <a name="stackName" id="cdk-extensions.stacks.AwsLoggingStackProps.property.stackName"></a>

```typescript
public readonly stackName: string;
```

- *Type:* string
- *Default:* Derived from construct path.

Name to deploy the stack with.

---

##### `synthesizer`<sup>Optional</sup> <a name="synthesizer" id="cdk-extensions.stacks.AwsLoggingStackProps.property.synthesizer"></a>

```typescript
public readonly synthesizer: IStackSynthesizer;
```

- *Type:* aws-cdk-lib.IStackSynthesizer
- *Default:* `DefaultStackSynthesizer` if the `@aws-cdk/core:newStyleStackSynthesis` feature flag is set, `LegacyStackSynthesizer` otherwise.

Synthesis method to use while deploying this stack.

---

##### `tags`<sup>Optional</sup> <a name="tags" id="cdk-extensions.stacks.AwsLoggingStackProps.property.tags"></a>

```typescript
public readonly tags: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: string}
- *Default:* {}

Stack tags that will be applied to all the taggable resources and the stack itself.

---

##### `terminationProtection`<sup>Optional</sup> <a name="terminationProtection" id="cdk-extensions.stacks.AwsLoggingStackProps.property.terminationProtection"></a>

```typescript
public readonly terminationProtection: boolean;
```

- *Type:* boolean
- *Default:* false

Whether to enable termination protection for this stack.

---

##### `albLogsBucket`<sup>Optional</sup> <a name="albLogsBucket" id="cdk-extensions.stacks.AwsLoggingStackProps.property.albLogsBucket"></a>

```typescript
public readonly albLogsBucket: AlbLogsBucket;
```

- *Type:* cdk-extensions.s3_buckets.AlbLogsBucket

---

##### `cloudfrontLogsBucket`<sup>Optional</sup> <a name="cloudfrontLogsBucket" id="cdk-extensions.stacks.AwsLoggingStackProps.property.cloudfrontLogsBucket"></a>

```typescript
public readonly cloudfrontLogsBucket: CloudfrontLogsBucket;
```

- *Type:* cdk-extensions.s3_buckets.CloudfrontLogsBucket

---

##### `cloudtrailLogsBucket`<sup>Optional</sup> <a name="cloudtrailLogsBucket" id="cdk-extensions.stacks.AwsLoggingStackProps.property.cloudtrailLogsBucket"></a>

```typescript
public readonly cloudtrailLogsBucket: CloudtrailBucket;
```

- *Type:* cdk-extensions.s3_buckets.CloudtrailBucket

---

##### `databaseName`<sup>Optional</sup> <a name="databaseName" id="cdk-extensions.stacks.AwsLoggingStackProps.property.databaseName"></a>

```typescript
public readonly databaseName: string;
```

- *Type:* string

---

##### `flowLogsBucket`<sup>Optional</sup> <a name="flowLogsBucket" id="cdk-extensions.stacks.AwsLoggingStackProps.property.flowLogsBucket"></a>

```typescript
public readonly flowLogsBucket: FlowLogsBucket;
```

- *Type:* cdk-extensions.s3_buckets.FlowLogsBucket

---

##### `flowLogsFormat`<sup>Optional</sup> <a name="flowLogsFormat" id="cdk-extensions.stacks.AwsLoggingStackProps.property.flowLogsFormat"></a>

```typescript
public readonly flowLogsFormat: FlowLogFormat;
```

- *Type:* cdk-extensions.ec2.FlowLogFormat

---

##### `friendlyQueryNames`<sup>Optional</sup> <a name="friendlyQueryNames" id="cdk-extensions.stacks.AwsLoggingStackProps.property.friendlyQueryNames"></a>

```typescript
public readonly friendlyQueryNames: boolean;
```

- *Type:* boolean

---

##### `sesLogsBucket`<sup>Optional</sup> <a name="sesLogsBucket" id="cdk-extensions.stacks.AwsLoggingStackProps.property.sesLogsBucket"></a>

```typescript
public readonly sesLogsBucket: SesLogsBucket;
```

- *Type:* cdk-extensions.s3_buckets.SesLogsBucket

---

##### `standardizeNames`<sup>Optional</sup> <a name="standardizeNames" id="cdk-extensions.stacks.AwsLoggingStackProps.property.standardizeNames"></a>

```typescript
public readonly standardizeNames: boolean;
```

- *Type:* boolean

---

##### `wafLogsBucket`<sup>Optional</sup> <a name="wafLogsBucket" id="cdk-extensions.stacks.AwsLoggingStackProps.property.wafLogsBucket"></a>

```typescript
public readonly wafLogsBucket: WafLogsBucket;
```

- *Type:* cdk-extensions.s3_buckets.WafLogsBucket

---

### BackupConfigurationOptions <a name="BackupConfigurationOptions" id="cdk-extensions.kinesis_firehose.BackupConfigurationOptions"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.kinesis_firehose.BackupConfigurationOptions.Initializer"></a>

```typescript
import { kinesis_firehose } from 'cdk-extensions'

const backupConfigurationOptions: kinesis_firehose.BackupConfigurationOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.kinesis_firehose.BackupConfigurationOptions.property.destination">destination</a></code> | <code>cdk-extensions.kinesis_firehose.IDeliveryStreamBackupDestination</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.BackupConfigurationOptions.property.enabled">enabled</a></code> | <code>boolean</code> | *No description.* |

---

##### `destination`<sup>Required</sup> <a name="destination" id="cdk-extensions.kinesis_firehose.BackupConfigurationOptions.property.destination"></a>

```typescript
public readonly destination: IDeliveryStreamBackupDestination;
```

- *Type:* cdk-extensions.kinesis_firehose.IDeliveryStreamBackupDestination

---

##### `enabled`<sup>Optional</sup> <a name="enabled" id="cdk-extensions.kinesis_firehose.BackupConfigurationOptions.property.enabled"></a>

```typescript
public readonly enabled: boolean;
```

- *Type:* boolean

---

### BackupConfigurationResult <a name="BackupConfigurationResult" id="cdk-extensions.kinesis_firehose.BackupConfigurationResult"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.kinesis_firehose.BackupConfigurationResult.Initializer"></a>

```typescript
import { kinesis_firehose } from 'cdk-extensions'

const backupConfigurationResult: kinesis_firehose.BackupConfigurationResult = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.kinesis_firehose.BackupConfigurationResult.property.s3BackupConfiguration">s3BackupConfiguration</a></code> | <code>aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.S3DestinationConfigurationProperty</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.BackupConfigurationResult.property.s3BackupMode">s3BackupMode</a></code> | <code>string</code> | *No description.* |

---

##### `s3BackupConfiguration`<sup>Required</sup> <a name="s3BackupConfiguration" id="cdk-extensions.kinesis_firehose.BackupConfigurationResult.property.s3BackupConfiguration"></a>

```typescript
public readonly s3BackupConfiguration: S3DestinationConfigurationProperty;
```

- *Type:* aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.S3DestinationConfigurationProperty

---

##### `s3BackupMode`<sup>Optional</sup> <a name="s3BackupMode" id="cdk-extensions.kinesis_firehose.BackupConfigurationResult.property.s3BackupMode"></a>

```typescript
public readonly s3BackupMode: string;
```

- *Type:* string

---

### BasicColumnProps <a name="BasicColumnProps" id="cdk-extensions.glue.BasicColumnProps"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.glue.BasicColumnProps.Initializer"></a>

```typescript
import { glue } from 'cdk-extensions'

const basicColumnProps: glue.BasicColumnProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.BasicColumnProps.property.comment">comment</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.BasicColumnProps.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.BasicColumnProps.property.type">type</a></code> | <code>string</code> | *No description.* |

---

##### `comment`<sup>Optional</sup> <a name="comment" id="cdk-extensions.glue.BasicColumnProps.property.comment"></a>

```typescript
public readonly comment: string;
```

- *Type:* string

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.glue.BasicColumnProps.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `type`<sup>Required</sup> <a name="type" id="cdk-extensions.glue.BasicColumnProps.property.type"></a>

```typescript
public readonly type: string;
```

- *Type:* string

---

### BufferingConfigurationOptions <a name="BufferingConfigurationOptions" id="cdk-extensions.kinesis_firehose.BufferingConfigurationOptions"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.kinesis_firehose.BufferingConfigurationOptions.Initializer"></a>

```typescript
import { kinesis_firehose } from 'cdk-extensions'

const bufferingConfigurationOptions: kinesis_firehose.BufferingConfigurationOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.kinesis_firehose.BufferingConfigurationOptions.property.interval">interval</a></code> | <code>aws-cdk-lib.Duration</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.BufferingConfigurationOptions.property.sizeInMb">sizeInMb</a></code> | <code>number</code> | *No description.* |

---

##### `interval`<sup>Optional</sup> <a name="interval" id="cdk-extensions.kinesis_firehose.BufferingConfigurationOptions.property.interval"></a>

```typescript
public readonly interval: Duration;
```

- *Type:* aws-cdk-lib.Duration

---

##### `sizeInMb`<sup>Optional</sup> <a name="sizeInMb" id="cdk-extensions.kinesis_firehose.BufferingConfigurationOptions.property.sizeInMb"></a>

```typescript
public readonly sizeInMb: number;
```

- *Type:* number

---

### CloudfrontLogsBucketProps <a name="CloudfrontLogsBucketProps" id="cdk-extensions.s3_buckets.CloudfrontLogsBucketProps"></a>

Configuration for objects bucket.

#### Initializer <a name="Initializer" id="cdk-extensions.s3_buckets.CloudfrontLogsBucketProps.Initializer"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

const cloudfrontLogsBucketProps: s3_buckets.CloudfrontLogsBucketProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucketProps.property.account">account</a></code> | <code>string</code> | The AWS account ID this resource belongs to. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucketProps.property.environmentFromArn">environmentFromArn</a></code> | <code>string</code> | ARN to deduce region and account from. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucketProps.property.physicalName">physicalName</a></code> | <code>string</code> | The value passed in by users to the physical name prop of the resource. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucketProps.property.region">region</a></code> | <code>string</code> | The AWS region this resource belongs to. |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucketProps.property.bucketName">bucketName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucketProps.property.createQueries">createQueries</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucketProps.property.database">database</a></code> | <code>cdk-extensions.glue.Database</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucketProps.property.friendlyQueryNames">friendlyQueryNames</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.CloudfrontLogsBucketProps.property.tableName">tableName</a></code> | <code>string</code> | *No description.* |

---

##### `account`<sup>Optional</sup> <a name="account" id="cdk-extensions.s3_buckets.CloudfrontLogsBucketProps.property.account"></a>

```typescript
public readonly account: string;
```

- *Type:* string
- *Default:* the resource is in the same account as the stack it belongs to

The AWS account ID this resource belongs to.

---

##### `environmentFromArn`<sup>Optional</sup> <a name="environmentFromArn" id="cdk-extensions.s3_buckets.CloudfrontLogsBucketProps.property.environmentFromArn"></a>

```typescript
public readonly environmentFromArn: string;
```

- *Type:* string
- *Default:* take environment from `account`, `region` parameters, or use Stack environment.

ARN to deduce region and account from.

The ARN is parsed and the account and region are taken from the ARN.
This should be used for imported resources.

Cannot be supplied together with either `account` or `region`.

---

##### `physicalName`<sup>Optional</sup> <a name="physicalName" id="cdk-extensions.s3_buckets.CloudfrontLogsBucketProps.property.physicalName"></a>

```typescript
public readonly physicalName: string;
```

- *Type:* string
- *Default:* The physical name will be allocated by CloudFormation at deployment time

The value passed in by users to the physical name prop of the resource.

`undefined` implies that a physical name will be allocated by
   CloudFormation during deployment.
- a concrete value implies a specific physical name
- `PhysicalName.GENERATE_IF_NEEDED` is a marker that indicates that a physical will only be generated
   by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.

---

##### `region`<sup>Optional</sup> <a name="region" id="cdk-extensions.s3_buckets.CloudfrontLogsBucketProps.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string
- *Default:* the resource is in the same region as the stack it belongs to

The AWS region this resource belongs to.

---

##### `bucketName`<sup>Optional</sup> <a name="bucketName" id="cdk-extensions.s3_buckets.CloudfrontLogsBucketProps.property.bucketName"></a>

```typescript
public readonly bucketName: string;
```

- *Type:* string

---

##### `createQueries`<sup>Optional</sup> <a name="createQueries" id="cdk-extensions.s3_buckets.CloudfrontLogsBucketProps.property.createQueries"></a>

```typescript
public readonly createQueries: boolean;
```

- *Type:* boolean

---

##### `database`<sup>Optional</sup> <a name="database" id="cdk-extensions.s3_buckets.CloudfrontLogsBucketProps.property.database"></a>

```typescript
public readonly database: Database;
```

- *Type:* cdk-extensions.glue.Database

---

##### `friendlyQueryNames`<sup>Optional</sup> <a name="friendlyQueryNames" id="cdk-extensions.s3_buckets.CloudfrontLogsBucketProps.property.friendlyQueryNames"></a>

```typescript
public readonly friendlyQueryNames: boolean;
```

- *Type:* boolean

---

##### `tableName`<sup>Optional</sup> <a name="tableName" id="cdk-extensions.s3_buckets.CloudfrontLogsBucketProps.property.tableName"></a>

```typescript
public readonly tableName: string;
```

- *Type:* string

---

### CloudfrontLogsTableProps <a name="CloudfrontLogsTableProps" id="cdk-extensions.glue_tables.CloudfrontLogsTableProps"></a>

Configuration for CloudfrontAccessLogsTable.

#### Initializer <a name="Initializer" id="cdk-extensions.glue_tables.CloudfrontLogsTableProps.Initializer"></a>

```typescript
import { glue_tables } from 'cdk-extensions'

const cloudfrontLogsTableProps: glue_tables.CloudfrontLogsTableProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTableProps.property.account">account</a></code> | <code>string</code> | The AWS account ID this resource belongs to. |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTableProps.property.environmentFromArn">environmentFromArn</a></code> | <code>string</code> | ARN to deduce region and account from. |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTableProps.property.physicalName">physicalName</a></code> | <code>string</code> | The value passed in by users to the physical name prop of the resource. |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTableProps.property.region">region</a></code> | <code>string</code> | The AWS region this resource belongs to. |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTableProps.property.bucket">bucket</a></code> | <code>aws-cdk-lib.aws_s3.IBucket</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTableProps.property.database">database</a></code> | <code>cdk-extensions.glue.Database</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTableProps.property.createQueries">createQueries</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTableProps.property.friendlyQueryNames">friendlyQueryNames</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTableProps.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudfrontLogsTableProps.property.s3Prefix">s3Prefix</a></code> | <code>string</code> | *No description.* |

---

##### `account`<sup>Optional</sup> <a name="account" id="cdk-extensions.glue_tables.CloudfrontLogsTableProps.property.account"></a>

```typescript
public readonly account: string;
```

- *Type:* string
- *Default:* the resource is in the same account as the stack it belongs to

The AWS account ID this resource belongs to.

---

##### `environmentFromArn`<sup>Optional</sup> <a name="environmentFromArn" id="cdk-extensions.glue_tables.CloudfrontLogsTableProps.property.environmentFromArn"></a>

```typescript
public readonly environmentFromArn: string;
```

- *Type:* string
- *Default:* take environment from `account`, `region` parameters, or use Stack environment.

ARN to deduce region and account from.

The ARN is parsed and the account and region are taken from the ARN.
This should be used for imported resources.

Cannot be supplied together with either `account` or `region`.

---

##### `physicalName`<sup>Optional</sup> <a name="physicalName" id="cdk-extensions.glue_tables.CloudfrontLogsTableProps.property.physicalName"></a>

```typescript
public readonly physicalName: string;
```

- *Type:* string
- *Default:* The physical name will be allocated by CloudFormation at deployment time

The value passed in by users to the physical name prop of the resource.

`undefined` implies that a physical name will be allocated by
   CloudFormation during deployment.
- a concrete value implies a specific physical name
- `PhysicalName.GENERATE_IF_NEEDED` is a marker that indicates that a physical will only be generated
   by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.

---

##### `region`<sup>Optional</sup> <a name="region" id="cdk-extensions.glue_tables.CloudfrontLogsTableProps.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string
- *Default:* the resource is in the same region as the stack it belongs to

The AWS region this resource belongs to.

---

##### `bucket`<sup>Required</sup> <a name="bucket" id="cdk-extensions.glue_tables.CloudfrontLogsTableProps.property.bucket"></a>

```typescript
public readonly bucket: IBucket;
```

- *Type:* aws-cdk-lib.aws_s3.IBucket

---

##### `database`<sup>Required</sup> <a name="database" id="cdk-extensions.glue_tables.CloudfrontLogsTableProps.property.database"></a>

```typescript
public readonly database: Database;
```

- *Type:* cdk-extensions.glue.Database

---

##### `createQueries`<sup>Optional</sup> <a name="createQueries" id="cdk-extensions.glue_tables.CloudfrontLogsTableProps.property.createQueries"></a>

```typescript
public readonly createQueries: boolean;
```

- *Type:* boolean

---

##### `friendlyQueryNames`<sup>Optional</sup> <a name="friendlyQueryNames" id="cdk-extensions.glue_tables.CloudfrontLogsTableProps.property.friendlyQueryNames"></a>

```typescript
public readonly friendlyQueryNames: boolean;
```

- *Type:* boolean

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.glue_tables.CloudfrontLogsTableProps.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `s3Prefix`<sup>Optional</sup> <a name="s3Prefix" id="cdk-extensions.glue_tables.CloudfrontLogsTableProps.property.s3Prefix"></a>

```typescript
public readonly s3Prefix: string;
```

- *Type:* string

---

### CloudtrailBucketProps <a name="CloudtrailBucketProps" id="cdk-extensions.s3_buckets.CloudtrailBucketProps"></a>

Configuration for objects bucket.

#### Initializer <a name="Initializer" id="cdk-extensions.s3_buckets.CloudtrailBucketProps.Initializer"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

const cloudtrailBucketProps: s3_buckets.CloudtrailBucketProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucketProps.property.account">account</a></code> | <code>string</code> | The AWS account ID this resource belongs to. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucketProps.property.environmentFromArn">environmentFromArn</a></code> | <code>string</code> | ARN to deduce region and account from. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucketProps.property.physicalName">physicalName</a></code> | <code>string</code> | The value passed in by users to the physical name prop of the resource. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucketProps.property.region">region</a></code> | <code>string</code> | The AWS region this resource belongs to. |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucketProps.property.bucketName">bucketName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucketProps.property.createQueries">createQueries</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucketProps.property.database">database</a></code> | <code>cdk-extensions.glue.Database</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucketProps.property.friendlyQueryNames">friendlyQueryNames</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.CloudtrailBucketProps.property.tableName">tableName</a></code> | <code>string</code> | *No description.* |

---

##### `account`<sup>Optional</sup> <a name="account" id="cdk-extensions.s3_buckets.CloudtrailBucketProps.property.account"></a>

```typescript
public readonly account: string;
```

- *Type:* string
- *Default:* the resource is in the same account as the stack it belongs to

The AWS account ID this resource belongs to.

---

##### `environmentFromArn`<sup>Optional</sup> <a name="environmentFromArn" id="cdk-extensions.s3_buckets.CloudtrailBucketProps.property.environmentFromArn"></a>

```typescript
public readonly environmentFromArn: string;
```

- *Type:* string
- *Default:* take environment from `account`, `region` parameters, or use Stack environment.

ARN to deduce region and account from.

The ARN is parsed and the account and region are taken from the ARN.
This should be used for imported resources.

Cannot be supplied together with either `account` or `region`.

---

##### `physicalName`<sup>Optional</sup> <a name="physicalName" id="cdk-extensions.s3_buckets.CloudtrailBucketProps.property.physicalName"></a>

```typescript
public readonly physicalName: string;
```

- *Type:* string
- *Default:* The physical name will be allocated by CloudFormation at deployment time

The value passed in by users to the physical name prop of the resource.

`undefined` implies that a physical name will be allocated by
   CloudFormation during deployment.
- a concrete value implies a specific physical name
- `PhysicalName.GENERATE_IF_NEEDED` is a marker that indicates that a physical will only be generated
   by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.

---

##### `region`<sup>Optional</sup> <a name="region" id="cdk-extensions.s3_buckets.CloudtrailBucketProps.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string
- *Default:* the resource is in the same region as the stack it belongs to

The AWS region this resource belongs to.

---

##### `bucketName`<sup>Optional</sup> <a name="bucketName" id="cdk-extensions.s3_buckets.CloudtrailBucketProps.property.bucketName"></a>

```typescript
public readonly bucketName: string;
```

- *Type:* string

---

##### `createQueries`<sup>Optional</sup> <a name="createQueries" id="cdk-extensions.s3_buckets.CloudtrailBucketProps.property.createQueries"></a>

```typescript
public readonly createQueries: boolean;
```

- *Type:* boolean

---

##### `database`<sup>Optional</sup> <a name="database" id="cdk-extensions.s3_buckets.CloudtrailBucketProps.property.database"></a>

```typescript
public readonly database: Database;
```

- *Type:* cdk-extensions.glue.Database

---

##### `friendlyQueryNames`<sup>Optional</sup> <a name="friendlyQueryNames" id="cdk-extensions.s3_buckets.CloudtrailBucketProps.property.friendlyQueryNames"></a>

```typescript
public readonly friendlyQueryNames: boolean;
```

- *Type:* boolean

---

##### `tableName`<sup>Optional</sup> <a name="tableName" id="cdk-extensions.s3_buckets.CloudtrailBucketProps.property.tableName"></a>

```typescript
public readonly tableName: string;
```

- *Type:* string

---

### CloudtrailTableProps <a name="CloudtrailTableProps" id="cdk-extensions.glue_tables.CloudtrailTableProps"></a>

Configuration for FlowLogsTable.

#### Initializer <a name="Initializer" id="cdk-extensions.glue_tables.CloudtrailTableProps.Initializer"></a>

```typescript
import { glue_tables } from 'cdk-extensions'

const cloudtrailTableProps: glue_tables.CloudtrailTableProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTableProps.property.account">account</a></code> | <code>string</code> | The AWS account ID this resource belongs to. |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTableProps.property.environmentFromArn">environmentFromArn</a></code> | <code>string</code> | ARN to deduce region and account from. |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTableProps.property.physicalName">physicalName</a></code> | <code>string</code> | The value passed in by users to the physical name prop of the resource. |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTableProps.property.region">region</a></code> | <code>string</code> | The AWS region this resource belongs to. |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTableProps.property.bucket">bucket</a></code> | <code>aws-cdk-lib.aws_s3.IBucket</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTableProps.property.database">database</a></code> | <code>cdk-extensions.glue.Database</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTableProps.property.createQueries">createQueries</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTableProps.property.friendlyQueryNames">friendlyQueryNames</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTableProps.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.CloudtrailTableProps.property.s3Prefix">s3Prefix</a></code> | <code>string</code> | *No description.* |

---

##### `account`<sup>Optional</sup> <a name="account" id="cdk-extensions.glue_tables.CloudtrailTableProps.property.account"></a>

```typescript
public readonly account: string;
```

- *Type:* string
- *Default:* the resource is in the same account as the stack it belongs to

The AWS account ID this resource belongs to.

---

##### `environmentFromArn`<sup>Optional</sup> <a name="environmentFromArn" id="cdk-extensions.glue_tables.CloudtrailTableProps.property.environmentFromArn"></a>

```typescript
public readonly environmentFromArn: string;
```

- *Type:* string
- *Default:* take environment from `account`, `region` parameters, or use Stack environment.

ARN to deduce region and account from.

The ARN is parsed and the account and region are taken from the ARN.
This should be used for imported resources.

Cannot be supplied together with either `account` or `region`.

---

##### `physicalName`<sup>Optional</sup> <a name="physicalName" id="cdk-extensions.glue_tables.CloudtrailTableProps.property.physicalName"></a>

```typescript
public readonly physicalName: string;
```

- *Type:* string
- *Default:* The physical name will be allocated by CloudFormation at deployment time

The value passed in by users to the physical name prop of the resource.

`undefined` implies that a physical name will be allocated by
   CloudFormation during deployment.
- a concrete value implies a specific physical name
- `PhysicalName.GENERATE_IF_NEEDED` is a marker that indicates that a physical will only be generated
   by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.

---

##### `region`<sup>Optional</sup> <a name="region" id="cdk-extensions.glue_tables.CloudtrailTableProps.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string
- *Default:* the resource is in the same region as the stack it belongs to

The AWS region this resource belongs to.

---

##### `bucket`<sup>Required</sup> <a name="bucket" id="cdk-extensions.glue_tables.CloudtrailTableProps.property.bucket"></a>

```typescript
public readonly bucket: IBucket;
```

- *Type:* aws-cdk-lib.aws_s3.IBucket

---

##### `database`<sup>Required</sup> <a name="database" id="cdk-extensions.glue_tables.CloudtrailTableProps.property.database"></a>

```typescript
public readonly database: Database;
```

- *Type:* cdk-extensions.glue.Database

---

##### `createQueries`<sup>Optional</sup> <a name="createQueries" id="cdk-extensions.glue_tables.CloudtrailTableProps.property.createQueries"></a>

```typescript
public readonly createQueries: boolean;
```

- *Type:* boolean

---

##### `friendlyQueryNames`<sup>Optional</sup> <a name="friendlyQueryNames" id="cdk-extensions.glue_tables.CloudtrailTableProps.property.friendlyQueryNames"></a>

```typescript
public readonly friendlyQueryNames: boolean;
```

- *Type:* boolean

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.glue_tables.CloudtrailTableProps.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `s3Prefix`<sup>Optional</sup> <a name="s3Prefix" id="cdk-extensions.glue_tables.CloudtrailTableProps.property.s3Prefix"></a>

```typescript
public readonly s3Prefix: string;
```

- *Type:* string

---

### CloudWatchEncryption <a name="CloudWatchEncryption" id="cdk-extensions.glue.CloudWatchEncryption"></a>

CloudWatch Logs encryption configuration.

#### Initializer <a name="Initializer" id="cdk-extensions.glue.CloudWatchEncryption.Initializer"></a>

```typescript
import { glue } from 'cdk-extensions'

const cloudWatchEncryption: glue.CloudWatchEncryption = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.CloudWatchEncryption.property.mode">mode</a></code> | <code>cdk-extensions.glue.CloudWatchEncryptionMode</code> | Encryption mode. |
| <code><a href="#cdk-extensions.glue.CloudWatchEncryption.property.kmsKey">kmsKey</a></code> | <code>aws-cdk-lib.aws_kms.IKey</code> | The KMS key to be used to encrypt the data. |

---

##### `mode`<sup>Required</sup> <a name="mode" id="cdk-extensions.glue.CloudWatchEncryption.property.mode"></a>

```typescript
public readonly mode: CloudWatchEncryptionMode;
```

- *Type:* cdk-extensions.glue.CloudWatchEncryptionMode

Encryption mode.

---

##### `kmsKey`<sup>Optional</sup> <a name="kmsKey" id="cdk-extensions.glue.CloudWatchEncryption.property.kmsKey"></a>

```typescript
public readonly kmsKey: IKey;
```

- *Type:* aws-cdk-lib.aws_kms.IKey
- *Default:* A key will be created if one is not provided.

The KMS key to be used to encrypt the data.

---

### CloudWatchLoggingConfigurationOptions <a name="CloudWatchLoggingConfigurationOptions" id="cdk-extensions.kinesis_firehose.CloudWatchLoggingConfigurationOptions"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.kinesis_firehose.CloudWatchLoggingConfigurationOptions.Initializer"></a>

```typescript
import { kinesis_firehose } from 'cdk-extensions'

const cloudWatchLoggingConfigurationOptions: kinesis_firehose.CloudWatchLoggingConfigurationOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.kinesis_firehose.CloudWatchLoggingConfigurationOptions.property.enabled">enabled</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.CloudWatchLoggingConfigurationOptions.property.logGroup">logGroup</a></code> | <code>aws-cdk-lib.aws_logs.ILogGroup</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.CloudWatchLoggingConfigurationOptions.property.logStream">logStream</a></code> | <code>aws-cdk-lib.aws_logs.ILogStream</code> | *No description.* |

---

##### `enabled`<sup>Optional</sup> <a name="enabled" id="cdk-extensions.kinesis_firehose.CloudWatchLoggingConfigurationOptions.property.enabled"></a>

```typescript
public readonly enabled: boolean;
```

- *Type:* boolean

---

##### `logGroup`<sup>Optional</sup> <a name="logGroup" id="cdk-extensions.kinesis_firehose.CloudWatchLoggingConfigurationOptions.property.logGroup"></a>

```typescript
public readonly logGroup: ILogGroup;
```

- *Type:* aws-cdk-lib.aws_logs.ILogGroup

---

##### `logStream`<sup>Optional</sup> <a name="logStream" id="cdk-extensions.kinesis_firehose.CloudWatchLoggingConfigurationOptions.property.logStream"></a>

```typescript
public readonly logStream: ILogStream;
```

- *Type:* aws-cdk-lib.aws_logs.ILogStream

---

### CodeConfig <a name="CodeConfig" id="cdk-extensions.glue.CodeConfig"></a>

Result of binding `Code` into a `Job`.

#### Initializer <a name="Initializer" id="cdk-extensions.glue.CodeConfig.Initializer"></a>

```typescript
import { glue } from 'cdk-extensions'

const codeConfig: glue.CodeConfig = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.CodeConfig.property.s3Location">s3Location</a></code> | <code>aws-cdk-lib.aws_s3.Location</code> | The location of the code in S3. |

---

##### `s3Location`<sup>Required</sup> <a name="s3Location" id="cdk-extensions.glue.CodeConfig.property.s3Location"></a>

```typescript
public readonly s3Location: Location;
```

- *Type:* aws-cdk-lib.aws_s3.Location

The location of the code in S3.

---

### ColumnProps <a name="ColumnProps" id="cdk-extensions.glue.ColumnProps"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.glue.ColumnProps.Initializer"></a>

```typescript
import { glue } from 'cdk-extensions'

const columnProps: glue.ColumnProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.ColumnProps.property.comment">comment</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.ColumnProps.property.name">name</a></code> | <code>string</code> | *No description.* |

---

##### `comment`<sup>Optional</sup> <a name="comment" id="cdk-extensions.glue.ColumnProps.property.comment"></a>

```typescript
public readonly comment: string;
```

- *Type:* string

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.glue.ColumnProps.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

### CommonPartitioningOptions <a name="CommonPartitioningOptions" id="cdk-extensions.kinesis_firehose.CommonPartitioningOptions"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.kinesis_firehose.CommonPartitioningOptions.Initializer"></a>

```typescript
import { kinesis_firehose } from 'cdk-extensions'

const commonPartitioningOptions: kinesis_firehose.CommonPartitioningOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.kinesis_firehose.CommonPartitioningOptions.property.enabled">enabled</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.CommonPartitioningOptions.property.retryInterval">retryInterval</a></code> | <code>aws-cdk-lib.Duration</code> | *No description.* |

---

##### `enabled`<sup>Optional</sup> <a name="enabled" id="cdk-extensions.kinesis_firehose.CommonPartitioningOptions.property.enabled"></a>

```typescript
public readonly enabled: boolean;
```

- *Type:* boolean

---

##### `retryInterval`<sup>Optional</sup> <a name="retryInterval" id="cdk-extensions.kinesis_firehose.CommonPartitioningOptions.property.retryInterval"></a>

```typescript
public readonly retryInterval: Duration;
```

- *Type:* aws-cdk-lib.Duration

---

### ConnectionProps <a name="ConnectionProps" id="cdk-extensions.glue.ConnectionProps"></a>

Configuration for the Glue Workflow resource.

#### Initializer <a name="Initializer" id="cdk-extensions.glue.ConnectionProps.Initializer"></a>

```typescript
import { glue } from 'cdk-extensions'

const connectionProps: glue.ConnectionProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.ConnectionProps.property.account">account</a></code> | <code>string</code> | The AWS account ID this resource belongs to. |
| <code><a href="#cdk-extensions.glue.ConnectionProps.property.environmentFromArn">environmentFromArn</a></code> | <code>string</code> | ARN to deduce region and account from. |
| <code><a href="#cdk-extensions.glue.ConnectionProps.property.physicalName">physicalName</a></code> | <code>string</code> | The value passed in by users to the physical name prop of the resource. |
| <code><a href="#cdk-extensions.glue.ConnectionProps.property.region">region</a></code> | <code>string</code> | The AWS region this resource belongs to. |
| <code><a href="#cdk-extensions.glue.ConnectionProps.property.connectionType">connectionType</a></code> | <code>cdk-extensions.glue.ConnectionType</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.ConnectionProps.property.description">description</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.ConnectionProps.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.ConnectionProps.property.properties">properties</a></code> | <code>{[ key: string ]: string}</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.ConnectionProps.property.securityGroups">securityGroups</a></code> | <code>aws-cdk-lib.aws_ec2.ISecurityGroup[]</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.ConnectionProps.property.subnets">subnets</a></code> | <code>aws-cdk-lib.aws_ec2.SubnetSelection</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.ConnectionProps.property.vpc">vpc</a></code> | <code>aws-cdk-lib.aws_ec2.IVpc</code> | *No description.* |

---

##### `account`<sup>Optional</sup> <a name="account" id="cdk-extensions.glue.ConnectionProps.property.account"></a>

```typescript
public readonly account: string;
```

- *Type:* string
- *Default:* the resource is in the same account as the stack it belongs to

The AWS account ID this resource belongs to.

---

##### `environmentFromArn`<sup>Optional</sup> <a name="environmentFromArn" id="cdk-extensions.glue.ConnectionProps.property.environmentFromArn"></a>

```typescript
public readonly environmentFromArn: string;
```

- *Type:* string
- *Default:* take environment from `account`, `region` parameters, or use Stack environment.

ARN to deduce region and account from.

The ARN is parsed and the account and region are taken from the ARN.
This should be used for imported resources.

Cannot be supplied together with either `account` or `region`.

---

##### `physicalName`<sup>Optional</sup> <a name="physicalName" id="cdk-extensions.glue.ConnectionProps.property.physicalName"></a>

```typescript
public readonly physicalName: string;
```

- *Type:* string
- *Default:* The physical name will be allocated by CloudFormation at deployment time

The value passed in by users to the physical name prop of the resource.

`undefined` implies that a physical name will be allocated by
   CloudFormation during deployment.
- a concrete value implies a specific physical name
- `PhysicalName.GENERATE_IF_NEEDED` is a marker that indicates that a physical will only be generated
   by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.

---

##### `region`<sup>Optional</sup> <a name="region" id="cdk-extensions.glue.ConnectionProps.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string
- *Default:* the resource is in the same region as the stack it belongs to

The AWS region this resource belongs to.

---

##### `connectionType`<sup>Required</sup> <a name="connectionType" id="cdk-extensions.glue.ConnectionProps.property.connectionType"></a>

```typescript
public readonly connectionType: ConnectionType;
```

- *Type:* cdk-extensions.glue.ConnectionType

---

##### `description`<sup>Optional</sup> <a name="description" id="cdk-extensions.glue.ConnectionProps.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.glue.ConnectionProps.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `properties`<sup>Optional</sup> <a name="properties" id="cdk-extensions.glue.ConnectionProps.property.properties"></a>

```typescript
public readonly properties: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: string}

---

##### `securityGroups`<sup>Optional</sup> <a name="securityGroups" id="cdk-extensions.glue.ConnectionProps.property.securityGroups"></a>

```typescript
public readonly securityGroups: ISecurityGroup[];
```

- *Type:* aws-cdk-lib.aws_ec2.ISecurityGroup[]

---

##### `subnets`<sup>Optional</sup> <a name="subnets" id="cdk-extensions.glue.ConnectionProps.property.subnets"></a>

```typescript
public readonly subnets: SubnetSelection;
```

- *Type:* aws-cdk-lib.aws_ec2.SubnetSelection

---

##### `vpc`<sup>Optional</sup> <a name="vpc" id="cdk-extensions.glue.ConnectionProps.property.vpc"></a>

```typescript
public readonly vpc: IVpc;
```

- *Type:* aws-cdk-lib.aws_ec2.IVpc

---

### ContinuousLoggingProps <a name="ContinuousLoggingProps" id="cdk-extensions.glue.ContinuousLoggingProps"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.glue.ContinuousLoggingProps.Initializer"></a>

```typescript
import { glue } from 'cdk-extensions'

const continuousLoggingProps: glue.ContinuousLoggingProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.ContinuousLoggingProps.property.enabled">enabled</a></code> | <code>boolean</code> | Enable continouous logging. |
| <code><a href="#cdk-extensions.glue.ContinuousLoggingProps.property.conversionPattern">conversionPattern</a></code> | <code>string</code> | Apply the provided conversion pattern. |
| <code><a href="#cdk-extensions.glue.ContinuousLoggingProps.property.logGroup">logGroup</a></code> | <code>aws-cdk-lib.aws_logs.ILogGroup</code> | Specify a custom CloudWatch log group name. |
| <code><a href="#cdk-extensions.glue.ContinuousLoggingProps.property.logStreamPrefix">logStreamPrefix</a></code> | <code>string</code> | Specify a custom CloudWatch log stream prefix. |
| <code><a href="#cdk-extensions.glue.ContinuousLoggingProps.property.quiet">quiet</a></code> | <code>boolean</code> | Filter out non-useful Apache Spark driver/executor and Apache Hadoop YARN heartbeat log messages. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="cdk-extensions.glue.ContinuousLoggingProps.property.enabled"></a>

```typescript
public readonly enabled: boolean;
```

- *Type:* boolean

Enable continouous logging.

---

##### `conversionPattern`<sup>Optional</sup> <a name="conversionPattern" id="cdk-extensions.glue.ContinuousLoggingProps.property.conversionPattern"></a>

```typescript
public readonly conversionPattern: string;
```

- *Type:* string
- *Default:* `%d{yy/MM/dd HH:mm:ss} %p %c{1}: %m%n`

Apply the provided conversion pattern.

This is a Log4j Conversion Pattern to customize driver and executor logs.

---

##### `logGroup`<sup>Optional</sup> <a name="logGroup" id="cdk-extensions.glue.ContinuousLoggingProps.property.logGroup"></a>

```typescript
public readonly logGroup: ILogGroup;
```

- *Type:* aws-cdk-lib.aws_logs.ILogGroup
- *Default:* a log group is created with name `/aws-glue/jobs/logs-v2/`.

Specify a custom CloudWatch log group name.

---

##### `logStreamPrefix`<sup>Optional</sup> <a name="logStreamPrefix" id="cdk-extensions.glue.ContinuousLoggingProps.property.logStreamPrefix"></a>

```typescript
public readonly logStreamPrefix: string;
```

- *Type:* string
- *Default:* the job run ID.

Specify a custom CloudWatch log stream prefix.

---

##### `quiet`<sup>Optional</sup> <a name="quiet" id="cdk-extensions.glue.ContinuousLoggingProps.property.quiet"></a>

```typescript
public readonly quiet: boolean;
```

- *Type:* boolean
- *Default:* true

Filter out non-useful Apache Spark driver/executor and Apache Hadoop YARN heartbeat log messages.

---

### CrawlerConfiguration <a name="CrawlerConfiguration" id="cdk-extensions.glue.CrawlerConfiguration"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.glue.CrawlerConfiguration.Initializer"></a>

```typescript
import { glue } from 'cdk-extensions'

const crawlerConfiguration: glue.CrawlerConfiguration = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.CrawlerConfiguration.property.partitionUpdateBehavior">partitionUpdateBehavior</a></code> | <code>cdk-extensions.glue.PartitionUpdateBehavior</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.CrawlerConfiguration.property.tableGroupingPolicy">tableGroupingPolicy</a></code> | <code>cdk-extensions.glue.TableGroupingPolicy</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.CrawlerConfiguration.property.tableLevel">tableLevel</a></code> | <code>number</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.CrawlerConfiguration.property.tableUpdateBehavior">tableUpdateBehavior</a></code> | <code>cdk-extensions.glue.TableUpdateBehavior</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.CrawlerConfiguration.property.version">version</a></code> | <code>cdk-extensions.glue.ConfigurationVersion</code> | *No description.* |

---

##### `partitionUpdateBehavior`<sup>Optional</sup> <a name="partitionUpdateBehavior" id="cdk-extensions.glue.CrawlerConfiguration.property.partitionUpdateBehavior"></a>

```typescript
public readonly partitionUpdateBehavior: PartitionUpdateBehavior;
```

- *Type:* cdk-extensions.glue.PartitionUpdateBehavior

---

##### `tableGroupingPolicy`<sup>Optional</sup> <a name="tableGroupingPolicy" id="cdk-extensions.glue.CrawlerConfiguration.property.tableGroupingPolicy"></a>

```typescript
public readonly tableGroupingPolicy: TableGroupingPolicy;
```

- *Type:* cdk-extensions.glue.TableGroupingPolicy

---

##### `tableLevel`<sup>Optional</sup> <a name="tableLevel" id="cdk-extensions.glue.CrawlerConfiguration.property.tableLevel"></a>

```typescript
public readonly tableLevel: number;
```

- *Type:* number

---

##### `tableUpdateBehavior`<sup>Optional</sup> <a name="tableUpdateBehavior" id="cdk-extensions.glue.CrawlerConfiguration.property.tableUpdateBehavior"></a>

```typescript
public readonly tableUpdateBehavior: TableUpdateBehavior;
```

- *Type:* cdk-extensions.glue.TableUpdateBehavior

---

##### `version`<sup>Optional</sup> <a name="version" id="cdk-extensions.glue.CrawlerConfiguration.property.version"></a>

```typescript
public readonly version: ConfigurationVersion;
```

- *Type:* cdk-extensions.glue.ConfigurationVersion

---

### CrawlerProps <a name="CrawlerProps" id="cdk-extensions.glue.CrawlerProps"></a>

Configuration for Crawlner.

#### Initializer <a name="Initializer" id="cdk-extensions.glue.CrawlerProps.Initializer"></a>

```typescript
import { glue } from 'cdk-extensions'

const crawlerProps: glue.CrawlerProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.CrawlerProps.property.account">account</a></code> | <code>string</code> | The AWS account ID this resource belongs to. |
| <code><a href="#cdk-extensions.glue.CrawlerProps.property.environmentFromArn">environmentFromArn</a></code> | <code>string</code> | ARN to deduce region and account from. |
| <code><a href="#cdk-extensions.glue.CrawlerProps.property.physicalName">physicalName</a></code> | <code>string</code> | The value passed in by users to the physical name prop of the resource. |
| <code><a href="#cdk-extensions.glue.CrawlerProps.property.region">region</a></code> | <code>string</code> | The AWS region this resource belongs to. |
| <code><a href="#cdk-extensions.glue.CrawlerProps.property.classifiers">classifiers</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.CrawlerProps.property.configuration">configuration</a></code> | <code>cdk-extensions.glue.CrawlerConfiguration</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.CrawlerProps.property.database">database</a></code> | <code>cdk-extensions.glue.Database</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.CrawlerProps.property.deleteBehavior">deleteBehavior</a></code> | <code>cdk-extensions.glue.DeleteBehavior</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.CrawlerProps.property.description">description</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.CrawlerProps.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.CrawlerProps.property.recrawlBehavior">recrawlBehavior</a></code> | <code>cdk-extensions.glue.RecrawlBehavior</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.CrawlerProps.property.scheduleExpression">scheduleExpression</a></code> | <code>aws-cdk-lib.aws_events.Schedule</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.CrawlerProps.property.securityConfiguration">securityConfiguration</a></code> | <code>cdk-extensions.glue.SecurityConfiguration</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.CrawlerProps.property.tablePrefix">tablePrefix</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.CrawlerProps.property.targets">targets</a></code> | <code>cdk-extensions.glue.ICrawlerTarget[]</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.CrawlerProps.property.updateBehavior">updateBehavior</a></code> | <code>cdk-extensions.glue.UpdateBehavior</code> | *No description.* |

---

##### `account`<sup>Optional</sup> <a name="account" id="cdk-extensions.glue.CrawlerProps.property.account"></a>

```typescript
public readonly account: string;
```

- *Type:* string
- *Default:* the resource is in the same account as the stack it belongs to

The AWS account ID this resource belongs to.

---

##### `environmentFromArn`<sup>Optional</sup> <a name="environmentFromArn" id="cdk-extensions.glue.CrawlerProps.property.environmentFromArn"></a>

```typescript
public readonly environmentFromArn: string;
```

- *Type:* string
- *Default:* take environment from `account`, `region` parameters, or use Stack environment.

ARN to deduce region and account from.

The ARN is parsed and the account and region are taken from the ARN.
This should be used for imported resources.

Cannot be supplied together with either `account` or `region`.

---

##### `physicalName`<sup>Optional</sup> <a name="physicalName" id="cdk-extensions.glue.CrawlerProps.property.physicalName"></a>

```typescript
public readonly physicalName: string;
```

- *Type:* string
- *Default:* The physical name will be allocated by CloudFormation at deployment time

The value passed in by users to the physical name prop of the resource.

`undefined` implies that a physical name will be allocated by
   CloudFormation during deployment.
- a concrete value implies a specific physical name
- `PhysicalName.GENERATE_IF_NEEDED` is a marker that indicates that a physical will only be generated
   by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.

---

##### `region`<sup>Optional</sup> <a name="region" id="cdk-extensions.glue.CrawlerProps.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string
- *Default:* the resource is in the same region as the stack it belongs to

The AWS region this resource belongs to.

---

##### `classifiers`<sup>Optional</sup> <a name="classifiers" id="cdk-extensions.glue.CrawlerProps.property.classifiers"></a>

```typescript
public readonly classifiers: string[];
```

- *Type:* string[]

---

##### `configuration`<sup>Optional</sup> <a name="configuration" id="cdk-extensions.glue.CrawlerProps.property.configuration"></a>

```typescript
public readonly configuration: CrawlerConfiguration;
```

- *Type:* cdk-extensions.glue.CrawlerConfiguration

---

##### `database`<sup>Optional</sup> <a name="database" id="cdk-extensions.glue.CrawlerProps.property.database"></a>

```typescript
public readonly database: Database;
```

- *Type:* cdk-extensions.glue.Database

---

##### `deleteBehavior`<sup>Optional</sup> <a name="deleteBehavior" id="cdk-extensions.glue.CrawlerProps.property.deleteBehavior"></a>

```typescript
public readonly deleteBehavior: DeleteBehavior;
```

- *Type:* cdk-extensions.glue.DeleteBehavior

---

##### `description`<sup>Optional</sup> <a name="description" id="cdk-extensions.glue.CrawlerProps.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.glue.CrawlerProps.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `recrawlBehavior`<sup>Optional</sup> <a name="recrawlBehavior" id="cdk-extensions.glue.CrawlerProps.property.recrawlBehavior"></a>

```typescript
public readonly recrawlBehavior: RecrawlBehavior;
```

- *Type:* cdk-extensions.glue.RecrawlBehavior

---

##### `scheduleExpression`<sup>Optional</sup> <a name="scheduleExpression" id="cdk-extensions.glue.CrawlerProps.property.scheduleExpression"></a>

```typescript
public readonly scheduleExpression: Schedule;
```

- *Type:* aws-cdk-lib.aws_events.Schedule

---

##### `securityConfiguration`<sup>Optional</sup> <a name="securityConfiguration" id="cdk-extensions.glue.CrawlerProps.property.securityConfiguration"></a>

```typescript
public readonly securityConfiguration: SecurityConfiguration;
```

- *Type:* cdk-extensions.glue.SecurityConfiguration

---

##### `tablePrefix`<sup>Optional</sup> <a name="tablePrefix" id="cdk-extensions.glue.CrawlerProps.property.tablePrefix"></a>

```typescript
public readonly tablePrefix: string;
```

- *Type:* string

---

##### `targets`<sup>Optional</sup> <a name="targets" id="cdk-extensions.glue.CrawlerProps.property.targets"></a>

```typescript
public readonly targets: ICrawlerTarget[];
```

- *Type:* cdk-extensions.glue.ICrawlerTarget[]

---

##### `updateBehavior`<sup>Optional</sup> <a name="updateBehavior" id="cdk-extensions.glue.CrawlerProps.property.updateBehavior"></a>

```typescript
public readonly updateBehavior: UpdateBehavior;
```

- *Type:* cdk-extensions.glue.UpdateBehavior

---

### CrawlerTargetCollection <a name="CrawlerTargetCollection" id="cdk-extensions.glue.CrawlerTargetCollection"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.glue.CrawlerTargetCollection.Initializer"></a>

```typescript
import { glue } from 'cdk-extensions'

const crawlerTargetCollection: glue.CrawlerTargetCollection = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.CrawlerTargetCollection.property.catalogTargets">catalogTargets</a></code> | <code>aws-cdk-lib.aws_glue.CfnCrawler.CatalogTargetProperty[]</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.CrawlerTargetCollection.property.dynamoDbTargets">dynamoDbTargets</a></code> | <code>aws-cdk-lib.aws_glue.CfnCrawler.DynamoDBTargetProperty[]</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.CrawlerTargetCollection.property.jdbcTargets">jdbcTargets</a></code> | <code>aws-cdk-lib.aws_glue.CfnCrawler.JdbcTargetProperty[]</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.CrawlerTargetCollection.property.s3Targets">s3Targets</a></code> | <code>aws-cdk-lib.aws_glue.CfnCrawler.S3TargetProperty[]</code> | *No description.* |

---

##### `catalogTargets`<sup>Optional</sup> <a name="catalogTargets" id="cdk-extensions.glue.CrawlerTargetCollection.property.catalogTargets"></a>

```typescript
public readonly catalogTargets: CatalogTargetProperty[];
```

- *Type:* aws-cdk-lib.aws_glue.CfnCrawler.CatalogTargetProperty[]

---

##### `dynamoDbTargets`<sup>Optional</sup> <a name="dynamoDbTargets" id="cdk-extensions.glue.CrawlerTargetCollection.property.dynamoDbTargets"></a>

```typescript
public readonly dynamoDbTargets: DynamoDBTargetProperty[];
```

- *Type:* aws-cdk-lib.aws_glue.CfnCrawler.DynamoDBTargetProperty[]

---

##### `jdbcTargets`<sup>Optional</sup> <a name="jdbcTargets" id="cdk-extensions.glue.CrawlerTargetCollection.property.jdbcTargets"></a>

```typescript
public readonly jdbcTargets: JdbcTargetProperty[];
```

- *Type:* aws-cdk-lib.aws_glue.CfnCrawler.JdbcTargetProperty[]

---

##### `s3Targets`<sup>Optional</sup> <a name="s3Targets" id="cdk-extensions.glue.CrawlerTargetCollection.property.s3Targets"></a>

```typescript
public readonly s3Targets: S3TargetProperty[];
```

- *Type:* aws-cdk-lib.aws_glue.CfnCrawler.S3TargetProperty[]

---

### CustomProcessorOptions <a name="CustomProcessorOptions" id="cdk-extensions.kinesis_firehose.CustomProcessorOptions"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.kinesis_firehose.CustomProcessorOptions.Initializer"></a>

```typescript
import { kinesis_firehose } from 'cdk-extensions'

const customProcessorOptions: kinesis_firehose.CustomProcessorOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.kinesis_firehose.CustomProcessorOptions.property.processorType">processorType</a></code> | <code>cdk-extensions.kinesis_firehose.ProcessorType</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.CustomProcessorOptions.property.parameters">parameters</a></code> | <code>{[ key: string ]: string}</code> | *No description.* |

---

##### `processorType`<sup>Required</sup> <a name="processorType" id="cdk-extensions.kinesis_firehose.CustomProcessorOptions.property.processorType"></a>

```typescript
public readonly processorType: ProcessorType;
```

- *Type:* cdk-extensions.kinesis_firehose.ProcessorType

---

##### `parameters`<sup>Optional</sup> <a name="parameters" id="cdk-extensions.kinesis_firehose.CustomProcessorOptions.property.parameters"></a>

```typescript
public readonly parameters: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: string}

---

### DatabaseProps <a name="DatabaseProps" id="cdk-extensions.glue.DatabaseProps"></a>

Configuration for Database.

#### Initializer <a name="Initializer" id="cdk-extensions.glue.DatabaseProps.Initializer"></a>

```typescript
import { glue } from 'cdk-extensions'

const databaseProps: glue.DatabaseProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.DatabaseProps.property.account">account</a></code> | <code>string</code> | The AWS account ID this resource belongs to. |
| <code><a href="#cdk-extensions.glue.DatabaseProps.property.environmentFromArn">environmentFromArn</a></code> | <code>string</code> | ARN to deduce region and account from. |
| <code><a href="#cdk-extensions.glue.DatabaseProps.property.physicalName">physicalName</a></code> | <code>string</code> | The value passed in by users to the physical name prop of the resource. |
| <code><a href="#cdk-extensions.glue.DatabaseProps.property.region">region</a></code> | <code>string</code> | The AWS region this resource belongs to. |
| <code><a href="#cdk-extensions.glue.DatabaseProps.property.description">description</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.DatabaseProps.property.locationUri">locationUri</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.DatabaseProps.property.name">name</a></code> | <code>string</code> | *No description.* |

---

##### `account`<sup>Optional</sup> <a name="account" id="cdk-extensions.glue.DatabaseProps.property.account"></a>

```typescript
public readonly account: string;
```

- *Type:* string
- *Default:* the resource is in the same account as the stack it belongs to

The AWS account ID this resource belongs to.

---

##### `environmentFromArn`<sup>Optional</sup> <a name="environmentFromArn" id="cdk-extensions.glue.DatabaseProps.property.environmentFromArn"></a>

```typescript
public readonly environmentFromArn: string;
```

- *Type:* string
- *Default:* take environment from `account`, `region` parameters, or use Stack environment.

ARN to deduce region and account from.

The ARN is parsed and the account and region are taken from the ARN.
This should be used for imported resources.

Cannot be supplied together with either `account` or `region`.

---

##### `physicalName`<sup>Optional</sup> <a name="physicalName" id="cdk-extensions.glue.DatabaseProps.property.physicalName"></a>

```typescript
public readonly physicalName: string;
```

- *Type:* string
- *Default:* The physical name will be allocated by CloudFormation at deployment time

The value passed in by users to the physical name prop of the resource.

`undefined` implies that a physical name will be allocated by
   CloudFormation during deployment.
- a concrete value implies a specific physical name
- `PhysicalName.GENERATE_IF_NEEDED` is a marker that indicates that a physical will only be generated
   by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.

---

##### `region`<sup>Optional</sup> <a name="region" id="cdk-extensions.glue.DatabaseProps.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string
- *Default:* the resource is in the same region as the stack it belongs to

The AWS region this resource belongs to.

---

##### `description`<sup>Optional</sup> <a name="description" id="cdk-extensions.glue.DatabaseProps.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

---

##### `locationUri`<sup>Optional</sup> <a name="locationUri" id="cdk-extensions.glue.DatabaseProps.property.locationUri"></a>

```typescript
public readonly locationUri: string;
```

- *Type:* string

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.glue.DatabaseProps.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

### DataFormatConversionOptions <a name="DataFormatConversionOptions" id="cdk-extensions.kinesis_firehose.DataFormatConversionOptions"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.kinesis_firehose.DataFormatConversionOptions.Initializer"></a>

```typescript
import { kinesis_firehose } from 'cdk-extensions'

const dataFormatConversionOptions: kinesis_firehose.DataFormatConversionOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.kinesis_firehose.DataFormatConversionOptions.property.database">database</a></code> | <code>cdk-extensions.glue.Database</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.DataFormatConversionOptions.property.inputFormat">inputFormat</a></code> | <code>cdk-extensions.kinesis_firehose.InputFormat</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.DataFormatConversionOptions.property.outputFormat">outputFormat</a></code> | <code>cdk-extensions.kinesis_firehose.OutputFormat</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.DataFormatConversionOptions.property.table">table</a></code> | <code>cdk-extensions.glue.Table</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.DataFormatConversionOptions.property.catalogId">catalogId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.DataFormatConversionOptions.property.enabled">enabled</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.DataFormatConversionOptions.property.region">region</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.DataFormatConversionOptions.property.role">role</a></code> | <code>aws-cdk-lib.aws_iam.IRole</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.DataFormatConversionOptions.property.version">version</a></code> | <code>cdk-extensions.kinesis_firehose.TableVersion</code> | *No description.* |

---

##### `database`<sup>Required</sup> <a name="database" id="cdk-extensions.kinesis_firehose.DataFormatConversionOptions.property.database"></a>

```typescript
public readonly database: Database;
```

- *Type:* cdk-extensions.glue.Database

---

##### `inputFormat`<sup>Required</sup> <a name="inputFormat" id="cdk-extensions.kinesis_firehose.DataFormatConversionOptions.property.inputFormat"></a>

```typescript
public readonly inputFormat: InputFormat;
```

- *Type:* cdk-extensions.kinesis_firehose.InputFormat

---

##### `outputFormat`<sup>Required</sup> <a name="outputFormat" id="cdk-extensions.kinesis_firehose.DataFormatConversionOptions.property.outputFormat"></a>

```typescript
public readonly outputFormat: OutputFormat;
```

- *Type:* cdk-extensions.kinesis_firehose.OutputFormat

---

##### `table`<sup>Required</sup> <a name="table" id="cdk-extensions.kinesis_firehose.DataFormatConversionOptions.property.table"></a>

```typescript
public readonly table: Table;
```

- *Type:* cdk-extensions.glue.Table

---

##### `catalogId`<sup>Optional</sup> <a name="catalogId" id="cdk-extensions.kinesis_firehose.DataFormatConversionOptions.property.catalogId"></a>

```typescript
public readonly catalogId: string;
```

- *Type:* string

---

##### `enabled`<sup>Optional</sup> <a name="enabled" id="cdk-extensions.kinesis_firehose.DataFormatConversionOptions.property.enabled"></a>

```typescript
public readonly enabled: boolean;
```

- *Type:* boolean

---

##### `region`<sup>Optional</sup> <a name="region" id="cdk-extensions.kinesis_firehose.DataFormatConversionOptions.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string

---

##### `role`<sup>Optional</sup> <a name="role" id="cdk-extensions.kinesis_firehose.DataFormatConversionOptions.property.role"></a>

```typescript
public readonly role: IRole;
```

- *Type:* aws-cdk-lib.aws_iam.IRole

---

##### `version`<sup>Optional</sup> <a name="version" id="cdk-extensions.kinesis_firehose.DataFormatConversionOptions.property.version"></a>

```typescript
public readonly version: TableVersion;
```

- *Type:* cdk-extensions.kinesis_firehose.TableVersion

---

### DataFormatProps <a name="DataFormatProps" id="cdk-extensions.glue.DataFormatProps"></a>

Properties of a DataFormat instance.

#### Initializer <a name="Initializer" id="cdk-extensions.glue.DataFormatProps.Initializer"></a>

```typescript
import { glue } from 'cdk-extensions'

const dataFormatProps: glue.DataFormatProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.DataFormatProps.property.inputFormat">inputFormat</a></code> | <code>cdk-extensions.glue.InputFormat</code> | `InputFormat` for this data format. |
| <code><a href="#cdk-extensions.glue.DataFormatProps.property.outputFormat">outputFormat</a></code> | <code>cdk-extensions.glue.OutputFormat</code> | `OutputFormat` for this data format. |
| <code><a href="#cdk-extensions.glue.DataFormatProps.property.serializationLibrary">serializationLibrary</a></code> | <code>cdk-extensions.glue.SerializationLibrary</code> | Serialization library for this data format. |
| <code><a href="#cdk-extensions.glue.DataFormatProps.property.classificationString">classificationString</a></code> | <code>cdk-extensions.glue.ClassificationString</code> | Classification string given to tables with this data format. |

---

##### `inputFormat`<sup>Required</sup> <a name="inputFormat" id="cdk-extensions.glue.DataFormatProps.property.inputFormat"></a>

```typescript
public readonly inputFormat: InputFormat;
```

- *Type:* cdk-extensions.glue.InputFormat

`InputFormat` for this data format.

---

##### `outputFormat`<sup>Required</sup> <a name="outputFormat" id="cdk-extensions.glue.DataFormatProps.property.outputFormat"></a>

```typescript
public readonly outputFormat: OutputFormat;
```

- *Type:* cdk-extensions.glue.OutputFormat

`OutputFormat` for this data format.

---

##### `serializationLibrary`<sup>Required</sup> <a name="serializationLibrary" id="cdk-extensions.glue.DataFormatProps.property.serializationLibrary"></a>

```typescript
public readonly serializationLibrary: SerializationLibrary;
```

- *Type:* cdk-extensions.glue.SerializationLibrary

Serialization library for this data format.

---

##### `classificationString`<sup>Optional</sup> <a name="classificationString" id="cdk-extensions.glue.DataFormatProps.property.classificationString"></a>

```typescript
public readonly classificationString: ClassificationString;
```

- *Type:* cdk-extensions.glue.ClassificationString
- *Default:* No classification is specified.

Classification string given to tables with this data format.

---

### DelimitedDeaggregationOptions <a name="DelimitedDeaggregationOptions" id="cdk-extensions.kinesis_firehose.DelimitedDeaggregationOptions"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.kinesis_firehose.DelimitedDeaggregationOptions.Initializer"></a>

```typescript
import { kinesis_firehose } from 'cdk-extensions'

const delimitedDeaggregationOptions: kinesis_firehose.DelimitedDeaggregationOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.kinesis_firehose.DelimitedDeaggregationOptions.property.delimiter">delimiter</a></code> | <code>string</code> | *No description.* |

---

##### `delimiter`<sup>Required</sup> <a name="delimiter" id="cdk-extensions.kinesis_firehose.DelimitedDeaggregationOptions.property.delimiter"></a>

```typescript
public readonly delimiter: string;
```

- *Type:* string

---

### DeliveryStreamAttributes <a name="DeliveryStreamAttributes" id="cdk-extensions.kinesis_firehose.DeliveryStreamAttributes"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.kinesis_firehose.DeliveryStreamAttributes.Initializer"></a>

```typescript
import { kinesis_firehose } from 'cdk-extensions'

const deliveryStreamAttributes: kinesis_firehose.DeliveryStreamAttributes = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStreamAttributes.property.deliveryStreamArn">deliveryStreamArn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStreamAttributes.property.deliveryStreamName">deliveryStreamName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStreamAttributes.property.role">role</a></code> | <code>aws-cdk-lib.aws_iam.IRole</code> | *No description.* |

---

##### `deliveryStreamArn`<sup>Optional</sup> <a name="deliveryStreamArn" id="cdk-extensions.kinesis_firehose.DeliveryStreamAttributes.property.deliveryStreamArn"></a>

```typescript
public readonly deliveryStreamArn: string;
```

- *Type:* string

---

##### `deliveryStreamName`<sup>Optional</sup> <a name="deliveryStreamName" id="cdk-extensions.kinesis_firehose.DeliveryStreamAttributes.property.deliveryStreamName"></a>

```typescript
public readonly deliveryStreamName: string;
```

- *Type:* string

---

##### `role`<sup>Optional</sup> <a name="role" id="cdk-extensions.kinesis_firehose.DeliveryStreamAttributes.property.role"></a>

```typescript
public readonly role: IRole;
```

- *Type:* aws-cdk-lib.aws_iam.IRole

---

### DeliveryStreamDestinationConfiguration <a name="DeliveryStreamDestinationConfiguration" id="cdk-extensions.kinesis_firehose.DeliveryStreamDestinationConfiguration"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.kinesis_firehose.DeliveryStreamDestinationConfiguration.Initializer"></a>

```typescript
import { kinesis_firehose } from 'cdk-extensions'

const deliveryStreamDestinationConfiguration: kinesis_firehose.DeliveryStreamDestinationConfiguration = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStreamDestinationConfiguration.property.amazonopensearchserviceDestinationConfiguration">amazonopensearchserviceDestinationConfiguration</a></code> | <code>aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.AmazonopensearchserviceDestinationConfigurationProperty</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStreamDestinationConfiguration.property.elasticsearchDestinationConfiguration">elasticsearchDestinationConfiguration</a></code> | <code>aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStreamDestinationConfiguration.property.extendedS3DestinationConfiguration">extendedS3DestinationConfiguration</a></code> | <code>aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStreamDestinationConfiguration.property.httpEndpointDestinationConfiguration">httpEndpointDestinationConfiguration</a></code> | <code>aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStreamDestinationConfiguration.property.redshiftDestinationConfiguration">redshiftDestinationConfiguration</a></code> | <code>aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.RedshiftDestinationConfigurationProperty</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStreamDestinationConfiguration.property.s3DestinationConfiguration">s3DestinationConfiguration</a></code> | <code>aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.S3DestinationConfigurationProperty</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStreamDestinationConfiguration.property.splunkDestinationConfiguration">splunkDestinationConfiguration</a></code> | <code>aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.SplunkDestinationConfigurationProperty</code> | *No description.* |

---

##### `amazonopensearchserviceDestinationConfiguration`<sup>Optional</sup> <a name="amazonopensearchserviceDestinationConfiguration" id="cdk-extensions.kinesis_firehose.DeliveryStreamDestinationConfiguration.property.amazonopensearchserviceDestinationConfiguration"></a>

```typescript
public readonly amazonopensearchserviceDestinationConfiguration: AmazonopensearchserviceDestinationConfigurationProperty;
```

- *Type:* aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.AmazonopensearchserviceDestinationConfigurationProperty

---

##### `elasticsearchDestinationConfiguration`<sup>Optional</sup> <a name="elasticsearchDestinationConfiguration" id="cdk-extensions.kinesis_firehose.DeliveryStreamDestinationConfiguration.property.elasticsearchDestinationConfiguration"></a>

```typescript
public readonly elasticsearchDestinationConfiguration: ElasticsearchDestinationConfigurationProperty;
```

- *Type:* aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty

---

##### `extendedS3DestinationConfiguration`<sup>Optional</sup> <a name="extendedS3DestinationConfiguration" id="cdk-extensions.kinesis_firehose.DeliveryStreamDestinationConfiguration.property.extendedS3DestinationConfiguration"></a>

```typescript
public readonly extendedS3DestinationConfiguration: ExtendedS3DestinationConfigurationProperty;
```

- *Type:* aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty

---

##### `httpEndpointDestinationConfiguration`<sup>Optional</sup> <a name="httpEndpointDestinationConfiguration" id="cdk-extensions.kinesis_firehose.DeliveryStreamDestinationConfiguration.property.httpEndpointDestinationConfiguration"></a>

```typescript
public readonly httpEndpointDestinationConfiguration: HttpEndpointDestinationConfigurationProperty;
```

- *Type:* aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty

---

##### `redshiftDestinationConfiguration`<sup>Optional</sup> <a name="redshiftDestinationConfiguration" id="cdk-extensions.kinesis_firehose.DeliveryStreamDestinationConfiguration.property.redshiftDestinationConfiguration"></a>

```typescript
public readonly redshiftDestinationConfiguration: RedshiftDestinationConfigurationProperty;
```

- *Type:* aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.RedshiftDestinationConfigurationProperty

---

##### `s3DestinationConfiguration`<sup>Optional</sup> <a name="s3DestinationConfiguration" id="cdk-extensions.kinesis_firehose.DeliveryStreamDestinationConfiguration.property.s3DestinationConfiguration"></a>

```typescript
public readonly s3DestinationConfiguration: S3DestinationConfigurationProperty;
```

- *Type:* aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.S3DestinationConfigurationProperty

---

##### `splunkDestinationConfiguration`<sup>Optional</sup> <a name="splunkDestinationConfiguration" id="cdk-extensions.kinesis_firehose.DeliveryStreamDestinationConfiguration.property.splunkDestinationConfiguration"></a>

```typescript
public readonly splunkDestinationConfiguration: SplunkDestinationConfigurationProperty;
```

- *Type:* aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.SplunkDestinationConfigurationProperty

---

### DeliveryStreamProcessorOptions <a name="DeliveryStreamProcessorOptions" id="cdk-extensions.kinesis_firehose.DeliveryStreamProcessorOptions"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.kinesis_firehose.DeliveryStreamProcessorOptions.Initializer"></a>

```typescript
import { kinesis_firehose } from 'cdk-extensions'

const deliveryStreamProcessorOptions: kinesis_firehose.DeliveryStreamProcessorOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStreamProcessorOptions.property.processorType">processorType</a></code> | <code>cdk-extensions.kinesis_firehose.ProcessorType</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStreamProcessorOptions.property.parameters">parameters</a></code> | <code>{[ key: string ]: string}</code> | *No description.* |

---

##### `processorType`<sup>Required</sup> <a name="processorType" id="cdk-extensions.kinesis_firehose.DeliveryStreamProcessorOptions.property.processorType"></a>

```typescript
public readonly processorType: ProcessorType;
```

- *Type:* cdk-extensions.kinesis_firehose.ProcessorType

---

##### `parameters`<sup>Optional</sup> <a name="parameters" id="cdk-extensions.kinesis_firehose.DeliveryStreamProcessorOptions.property.parameters"></a>

```typescript
public readonly parameters: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: string}

---

### DeliveryStreamProps <a name="DeliveryStreamProps" id="cdk-extensions.kinesis_firehose.DeliveryStreamProps"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.kinesis_firehose.DeliveryStreamProps.Initializer"></a>

```typescript
import { kinesis_firehose } from 'cdk-extensions'

const deliveryStreamProps: kinesis_firehose.DeliveryStreamProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStreamProps.property.account">account</a></code> | <code>string</code> | The AWS account ID this resource belongs to. |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStreamProps.property.environmentFromArn">environmentFromArn</a></code> | <code>string</code> | ARN to deduce region and account from. |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStreamProps.property.physicalName">physicalName</a></code> | <code>string</code> | The value passed in by users to the physical name prop of the resource. |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStreamProps.property.region">region</a></code> | <code>string</code> | The AWS region this resource belongs to. |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStreamProps.property.destination">destination</a></code> | <code>cdk-extensions.kinesis_firehose.DeliveryStreamDestination</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStreamProps.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.DeliveryStreamProps.property.streamType">streamType</a></code> | <code>cdk-extensions.kinesis_firehose.DeliveryStreamType</code> | *No description.* |

---

##### `account`<sup>Optional</sup> <a name="account" id="cdk-extensions.kinesis_firehose.DeliveryStreamProps.property.account"></a>

```typescript
public readonly account: string;
```

- *Type:* string
- *Default:* the resource is in the same account as the stack it belongs to

The AWS account ID this resource belongs to.

---

##### `environmentFromArn`<sup>Optional</sup> <a name="environmentFromArn" id="cdk-extensions.kinesis_firehose.DeliveryStreamProps.property.environmentFromArn"></a>

```typescript
public readonly environmentFromArn: string;
```

- *Type:* string
- *Default:* take environment from `account`, `region` parameters, or use Stack environment.

ARN to deduce region and account from.

The ARN is parsed and the account and region are taken from the ARN.
This should be used for imported resources.

Cannot be supplied together with either `account` or `region`.

---

##### `physicalName`<sup>Optional</sup> <a name="physicalName" id="cdk-extensions.kinesis_firehose.DeliveryStreamProps.property.physicalName"></a>

```typescript
public readonly physicalName: string;
```

- *Type:* string
- *Default:* The physical name will be allocated by CloudFormation at deployment time

The value passed in by users to the physical name prop of the resource.

`undefined` implies that a physical name will be allocated by
   CloudFormation during deployment.
- a concrete value implies a specific physical name
- `PhysicalName.GENERATE_IF_NEEDED` is a marker that indicates that a physical will only be generated
   by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.

---

##### `region`<sup>Optional</sup> <a name="region" id="cdk-extensions.kinesis_firehose.DeliveryStreamProps.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string
- *Default:* the resource is in the same region as the stack it belongs to

The AWS region this resource belongs to.

---

##### `destination`<sup>Required</sup> <a name="destination" id="cdk-extensions.kinesis_firehose.DeliveryStreamProps.property.destination"></a>

```typescript
public readonly destination: DeliveryStreamDestination;
```

- *Type:* cdk-extensions.kinesis_firehose.DeliveryStreamDestination

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.kinesis_firehose.DeliveryStreamProps.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `streamType`<sup>Optional</sup> <a name="streamType" id="cdk-extensions.kinesis_firehose.DeliveryStreamProps.property.streamType"></a>

```typescript
public readonly streamType: DeliveryStreamType;
```

- *Type:* cdk-extensions.kinesis_firehose.DeliveryStreamType

---

### DynamicPartitioningConfiguration <a name="DynamicPartitioningConfiguration" id="cdk-extensions.kinesis_firehose.DynamicPartitioningConfiguration"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.kinesis_firehose.DynamicPartitioningConfiguration.Initializer"></a>

```typescript
import { kinesis_firehose } from 'cdk-extensions'

const dynamicPartitioningConfiguration: kinesis_firehose.DynamicPartitioningConfiguration = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.kinesis_firehose.DynamicPartitioningConfiguration.property.partitioningConfiguration">partitioningConfiguration</a></code> | <code>aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DynamicPartitioningConfigurationProperty</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.DynamicPartitioningConfiguration.property.processors">processors</a></code> | <code>cdk-extensions.kinesis_firehose.DeliveryStreamProcessor[]</code> | *No description.* |

---

##### `partitioningConfiguration`<sup>Required</sup> <a name="partitioningConfiguration" id="cdk-extensions.kinesis_firehose.DynamicPartitioningConfiguration.property.partitioningConfiguration"></a>

```typescript
public readonly partitioningConfiguration: DynamicPartitioningConfigurationProperty;
```

- *Type:* aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DynamicPartitioningConfigurationProperty

---

##### `processors`<sup>Optional</sup> <a name="processors" id="cdk-extensions.kinesis_firehose.DynamicPartitioningConfiguration.property.processors"></a>

```typescript
public readonly processors: DeliveryStreamProcessor[];
```

- *Type:* cdk-extensions.kinesis_firehose.DeliveryStreamProcessor[]

---

### ExtendedS3DestinationOptions <a name="ExtendedS3DestinationOptions" id="cdk-extensions.kinesis_firehose.ExtendedS3DestinationOptions"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.kinesis_firehose.ExtendedS3DestinationOptions.Initializer"></a>

```typescript
import { kinesis_firehose } from 'cdk-extensions'

const extendedS3DestinationOptions: kinesis_firehose.ExtendedS3DestinationOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.kinesis_firehose.ExtendedS3DestinationOptions.property.buffering">buffering</a></code> | <code>cdk-extensions.kinesis_firehose.BufferingConfiguration</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.ExtendedS3DestinationOptions.property.cloudwatchLoggingConfiguration">cloudwatchLoggingConfiguration</a></code> | <code>cdk-extensions.kinesis_firehose.CloudWatchLoggingConfiguration</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.ExtendedS3DestinationOptions.property.compressionFormat">compressionFormat</a></code> | <code>cdk-extensions.kinesis_firehose.S3CompressionFormat</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.ExtendedS3DestinationOptions.property.encryptionEnabled">encryptionEnabled</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.ExtendedS3DestinationOptions.property.encryptionKey">encryptionKey</a></code> | <code>aws-cdk-lib.aws_kms.IKey</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.ExtendedS3DestinationOptions.property.errorOutputPrefix">errorOutputPrefix</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.ExtendedS3DestinationOptions.property.keyPrefix">keyPrefix</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.ExtendedS3DestinationOptions.property.role">role</a></code> | <code>aws-cdk-lib.aws_iam.IRole</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.ExtendedS3DestinationOptions.property.backupConfiguration">backupConfiguration</a></code> | <code>cdk-extensions.kinesis_firehose.BackupConfiguration</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.ExtendedS3DestinationOptions.property.dataFormatConversion">dataFormatConversion</a></code> | <code>cdk-extensions.kinesis_firehose.DataFormatConversion</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.ExtendedS3DestinationOptions.property.dynamicPartitioning">dynamicPartitioning</a></code> | <code>cdk-extensions.kinesis_firehose.DynamicPartitioning</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.ExtendedS3DestinationOptions.property.processorConfiguration">processorConfiguration</a></code> | <code>cdk-extensions.kinesis_firehose.ProcessorConfiguration</code> | *No description.* |

---

##### `buffering`<sup>Optional</sup> <a name="buffering" id="cdk-extensions.kinesis_firehose.ExtendedS3DestinationOptions.property.buffering"></a>

```typescript
public readonly buffering: BufferingConfiguration;
```

- *Type:* cdk-extensions.kinesis_firehose.BufferingConfiguration

---

##### `cloudwatchLoggingConfiguration`<sup>Optional</sup> <a name="cloudwatchLoggingConfiguration" id="cdk-extensions.kinesis_firehose.ExtendedS3DestinationOptions.property.cloudwatchLoggingConfiguration"></a>

```typescript
public readonly cloudwatchLoggingConfiguration: CloudWatchLoggingConfiguration;
```

- *Type:* cdk-extensions.kinesis_firehose.CloudWatchLoggingConfiguration

---

##### `compressionFormat`<sup>Optional</sup> <a name="compressionFormat" id="cdk-extensions.kinesis_firehose.ExtendedS3DestinationOptions.property.compressionFormat"></a>

```typescript
public readonly compressionFormat: S3CompressionFormat;
```

- *Type:* cdk-extensions.kinesis_firehose.S3CompressionFormat

---

##### `encryptionEnabled`<sup>Optional</sup> <a name="encryptionEnabled" id="cdk-extensions.kinesis_firehose.ExtendedS3DestinationOptions.property.encryptionEnabled"></a>

```typescript
public readonly encryptionEnabled: boolean;
```

- *Type:* boolean

---

##### `encryptionKey`<sup>Optional</sup> <a name="encryptionKey" id="cdk-extensions.kinesis_firehose.ExtendedS3DestinationOptions.property.encryptionKey"></a>

```typescript
public readonly encryptionKey: IKey;
```

- *Type:* aws-cdk-lib.aws_kms.IKey

---

##### `errorOutputPrefix`<sup>Optional</sup> <a name="errorOutputPrefix" id="cdk-extensions.kinesis_firehose.ExtendedS3DestinationOptions.property.errorOutputPrefix"></a>

```typescript
public readonly errorOutputPrefix: string;
```

- *Type:* string

---

##### `keyPrefix`<sup>Optional</sup> <a name="keyPrefix" id="cdk-extensions.kinesis_firehose.ExtendedS3DestinationOptions.property.keyPrefix"></a>

```typescript
public readonly keyPrefix: string;
```

- *Type:* string

---

##### `role`<sup>Optional</sup> <a name="role" id="cdk-extensions.kinesis_firehose.ExtendedS3DestinationOptions.property.role"></a>

```typescript
public readonly role: IRole;
```

- *Type:* aws-cdk-lib.aws_iam.IRole

---

##### `backupConfiguration`<sup>Optional</sup> <a name="backupConfiguration" id="cdk-extensions.kinesis_firehose.ExtendedS3DestinationOptions.property.backupConfiguration"></a>

```typescript
public readonly backupConfiguration: BackupConfiguration;
```

- *Type:* cdk-extensions.kinesis_firehose.BackupConfiguration

---

##### `dataFormatConversion`<sup>Optional</sup> <a name="dataFormatConversion" id="cdk-extensions.kinesis_firehose.ExtendedS3DestinationOptions.property.dataFormatConversion"></a>

```typescript
public readonly dataFormatConversion: DataFormatConversion;
```

- *Type:* cdk-extensions.kinesis_firehose.DataFormatConversion

---

##### `dynamicPartitioning`<sup>Optional</sup> <a name="dynamicPartitioning" id="cdk-extensions.kinesis_firehose.ExtendedS3DestinationOptions.property.dynamicPartitioning"></a>

```typescript
public readonly dynamicPartitioning: DynamicPartitioning;
```

- *Type:* cdk-extensions.kinesis_firehose.DynamicPartitioning

---

##### `processorConfiguration`<sup>Optional</sup> <a name="processorConfiguration" id="cdk-extensions.kinesis_firehose.ExtendedS3DestinationOptions.property.processorConfiguration"></a>

```typescript
public readonly processorConfiguration: ProcessorConfiguration;
```

- *Type:* cdk-extensions.kinesis_firehose.ProcessorConfiguration

---

### FlowLogDestinationConfig <a name="FlowLogDestinationConfig" id="cdk-extensions.ec2.FlowLogDestinationConfig"></a>

A configuration object providing the details necessary to set up log delivery to a given destination.

#### Initializer <a name="Initializer" id="cdk-extensions.ec2.FlowLogDestinationConfig.Initializer"></a>

```typescript
import { ec2 } from 'cdk-extensions'

const flowLogDestinationConfig: ec2.FlowLogDestinationConfig = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.ec2.FlowLogDestinationConfig.property.destinationType">destinationType</a></code> | <code>aws-cdk-lib.aws_ec2.FlowLogDestinationType</code> | The type of destination for the flow log data. |
| <code><a href="#cdk-extensions.ec2.FlowLogDestinationConfig.property.bucket">bucket</a></code> | <code>aws-cdk-lib.aws_s3.IBucket</code> | An S3 bucket where logs should be delivered. |
| <code><a href="#cdk-extensions.ec2.FlowLogDestinationConfig.property.destinationOptions">destinationOptions</a></code> | <code>{[ key: string ]: any}</code> | Additional options that control the format and behavior of logs delivered to the destination. |
| <code><a href="#cdk-extensions.ec2.FlowLogDestinationConfig.property.logGroup">logGroup</a></code> | <code>aws-cdk-lib.aws_logs.ILogGroup</code> | A CloudWatch LogGroup where logs should be delivered. |
| <code><a href="#cdk-extensions.ec2.FlowLogDestinationConfig.property.role">role</a></code> | <code>aws-cdk-lib.aws_iam.IRole</code> | The ARN of the IAM role that allows Amazon EC2 to publish flow logs in your account. |
| <code><a href="#cdk-extensions.ec2.FlowLogDestinationConfig.property.s3Path">s3Path</a></code> | <code>string</code> | An Amazon Resource Name (ARN) for the S3 destination where log files are to be delivered. |

---

##### `destinationType`<sup>Required</sup> <a name="destinationType" id="cdk-extensions.ec2.FlowLogDestinationConfig.property.destinationType"></a>

```typescript
public readonly destinationType: FlowLogDestinationType;
```

- *Type:* aws-cdk-lib.aws_ec2.FlowLogDestinationType

The type of destination for the flow log data.

> [[FlowLog LogDestinationType](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logdestinationtype)]([FlowLog LogDestinationType](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logdestinationtype))

---

##### `bucket`<sup>Optional</sup> <a name="bucket" id="cdk-extensions.ec2.FlowLogDestinationConfig.property.bucket"></a>

```typescript
public readonly bucket: IBucket;
```

- *Type:* aws-cdk-lib.aws_s3.IBucket

An S3 bucket where logs should be delivered.

> [[FlowLog LogDestination](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logdestination)]([FlowLog LogDestination](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logdestination))

---

##### `destinationOptions`<sup>Optional</sup> <a name="destinationOptions" id="cdk-extensions.ec2.FlowLogDestinationConfig.property.destinationOptions"></a>

```typescript
public readonly destinationOptions: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

Additional options that control the format and behavior of logs delivered to the destination.

---

##### `logGroup`<sup>Optional</sup> <a name="logGroup" id="cdk-extensions.ec2.FlowLogDestinationConfig.property.logGroup"></a>

```typescript
public readonly logGroup: ILogGroup;
```

- *Type:* aws-cdk-lib.aws_logs.ILogGroup

A CloudWatch LogGroup where logs should be delivered.

> [[FlowLog LogDestination](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logdestination)]([FlowLog LogDestination](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logdestination))

---

##### `role`<sup>Optional</sup> <a name="role" id="cdk-extensions.ec2.FlowLogDestinationConfig.property.role"></a>

```typescript
public readonly role: IRole;
```

- *Type:* aws-cdk-lib.aws_iam.IRole

The ARN of the IAM role that allows Amazon EC2 to publish flow logs in your account.

> [[FlowLog DeliverLogsPermissionArn](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-deliverlogspermissionarn)]([FlowLog DeliverLogsPermissionArn](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-deliverlogspermissionarn))

---

##### `s3Path`<sup>Optional</sup> <a name="s3Path" id="cdk-extensions.ec2.FlowLogDestinationConfig.property.s3Path"></a>

```typescript
public readonly s3Path: string;
```

- *Type:* string

An Amazon Resource Name (ARN) for the S3 destination where log files are to be delivered.

If a custom prefix is being added the ARN should reflect that prefix.

> [[FlowLog LogDestination](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logdestination)]([FlowLog LogDestination](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logdestination))

---

### FlowLogProps <a name="FlowLogProps" id="cdk-extensions.ec2.FlowLogProps"></a>

Configuration for the FlowLog class.

#### Initializer <a name="Initializer" id="cdk-extensions.ec2.FlowLogProps.Initializer"></a>

```typescript
import { ec2 } from 'cdk-extensions'

const flowLogProps: ec2.FlowLogProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.ec2.FlowLogProps.property.account">account</a></code> | <code>string</code> | The AWS account ID this resource belongs to. |
| <code><a href="#cdk-extensions.ec2.FlowLogProps.property.environmentFromArn">environmentFromArn</a></code> | <code>string</code> | ARN to deduce region and account from. |
| <code><a href="#cdk-extensions.ec2.FlowLogProps.property.physicalName">physicalName</a></code> | <code>string</code> | The value passed in by users to the physical name prop of the resource. |
| <code><a href="#cdk-extensions.ec2.FlowLogProps.property.region">region</a></code> | <code>string</code> | The AWS region this resource belongs to. |
| <code><a href="#cdk-extensions.ec2.FlowLogProps.property.resourceType">resourceType</a></code> | <code>aws-cdk-lib.aws_ec2.FlowLogResourceType</code> | Details for the resource from which flow logs will be captured. |
| <code><a href="#cdk-extensions.ec2.FlowLogProps.property.destination">destination</a></code> | <code>cdk-extensions.ec2.FlowLogDestination</code> | The location where flow logs should be delivered. |
| <code><a href="#cdk-extensions.ec2.FlowLogProps.property.format">format</a></code> | <code>cdk-extensions.ec2.FlowLogFormat</code> | The fields to include in the flow log record, in the order in which they should appear. |
| <code><a href="#cdk-extensions.ec2.FlowLogProps.property.maxAggregationInterval">maxAggregationInterval</a></code> | <code>cdk-extensions.ec2.FlowLogAggregationInterval</code> | The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record. |
| <code><a href="#cdk-extensions.ec2.FlowLogProps.property.trafficType">trafficType</a></code> | <code>aws-cdk-lib.aws_ec2.FlowLogTrafficType</code> | The type of traffic to monitor (accepted traffic, rejected traffic, or all traffic). |

---

##### `account`<sup>Optional</sup> <a name="account" id="cdk-extensions.ec2.FlowLogProps.property.account"></a>

```typescript
public readonly account: string;
```

- *Type:* string
- *Default:* the resource is in the same account as the stack it belongs to

The AWS account ID this resource belongs to.

---

##### `environmentFromArn`<sup>Optional</sup> <a name="environmentFromArn" id="cdk-extensions.ec2.FlowLogProps.property.environmentFromArn"></a>

```typescript
public readonly environmentFromArn: string;
```

- *Type:* string
- *Default:* take environment from `account`, `region` parameters, or use Stack environment.

ARN to deduce region and account from.

The ARN is parsed and the account and region are taken from the ARN.
This should be used for imported resources.

Cannot be supplied together with either `account` or `region`.

---

##### `physicalName`<sup>Optional</sup> <a name="physicalName" id="cdk-extensions.ec2.FlowLogProps.property.physicalName"></a>

```typescript
public readonly physicalName: string;
```

- *Type:* string
- *Default:* The physical name will be allocated by CloudFormation at deployment time

The value passed in by users to the physical name prop of the resource.

`undefined` implies that a physical name will be allocated by
   CloudFormation during deployment.
- a concrete value implies a specific physical name
- `PhysicalName.GENERATE_IF_NEEDED` is a marker that indicates that a physical will only be generated
   by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.

---

##### `region`<sup>Optional</sup> <a name="region" id="cdk-extensions.ec2.FlowLogProps.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string
- *Default:* the resource is in the same region as the stack it belongs to

The AWS region this resource belongs to.

---

##### `resourceType`<sup>Required</sup> <a name="resourceType" id="cdk-extensions.ec2.FlowLogProps.property.resourceType"></a>

```typescript
public readonly resourceType: FlowLogResourceType;
```

- *Type:* aws-cdk-lib.aws_ec2.FlowLogResourceType

Details for the resource from which flow logs will be captured.

> [[FlowLog ResourceType](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-resourcetype)]([FlowLog ResourceType](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-resourcetype))

---

##### `destination`<sup>Optional</sup> <a name="destination" id="cdk-extensions.ec2.FlowLogProps.property.destination"></a>

```typescript
public readonly destination: FlowLogDestination;
```

- *Type:* cdk-extensions.ec2.FlowLogDestination

The location where flow logs should be delivered.

> [[FlowLog LogDestinationType](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logdestinationtype)]([FlowLog LogDestinationType](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logdestinationtype))

---

##### `format`<sup>Optional</sup> <a name="format" id="cdk-extensions.ec2.FlowLogProps.property.format"></a>

```typescript
public readonly format: FlowLogFormat;
```

- *Type:* cdk-extensions.ec2.FlowLogFormat

The fields to include in the flow log record, in the order in which they should appear.

For a list of available fields, see {@link FlowLogField}.

> [[FlowLog LogFormat](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logformat)]([FlowLog LogFormat](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logformat))

---

##### `maxAggregationInterval`<sup>Optional</sup> <a name="maxAggregationInterval" id="cdk-extensions.ec2.FlowLogProps.property.maxAggregationInterval"></a>

```typescript
public readonly maxAggregationInterval: FlowLogAggregationInterval;
```

- *Type:* cdk-extensions.ec2.FlowLogAggregationInterval

The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record.

> [[FlowLog MaxAggregationInterval](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-maxaggregationinterval)]([FlowLog MaxAggregationInterval](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-maxaggregationinterval))

---

##### `trafficType`<sup>Optional</sup> <a name="trafficType" id="cdk-extensions.ec2.FlowLogProps.property.trafficType"></a>

```typescript
public readonly trafficType: FlowLogTrafficType;
```

- *Type:* aws-cdk-lib.aws_ec2.FlowLogTrafficType

The type of traffic to monitor (accepted traffic, rejected traffic, or all traffic).

> [[FlowLog TrafficType](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-traffictype)]([FlowLog TrafficType](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-traffictype))

---

### FlowLogS3Options <a name="FlowLogS3Options" id="cdk-extensions.ec2.FlowLogS3Options"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.ec2.FlowLogS3Options.Initializer"></a>

```typescript
import { ec2 } from 'cdk-extensions'

const flowLogS3Options: ec2.FlowLogS3Options = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.ec2.FlowLogS3Options.property.fileFormat">fileFormat</a></code> | <code>cdk-extensions.ec2.FlowLogFileFormat</code> | The file format in which flow logs should be delivered to S3. |
| <code><a href="#cdk-extensions.ec2.FlowLogS3Options.property.hiveCompatiblePartitions">hiveCompatiblePartitions</a></code> | <code>boolean</code> | Controls the format of partitions ("folders") when the flow logs are delivered to S3. |
| <code><a href="#cdk-extensions.ec2.FlowLogS3Options.property.keyPrefix">keyPrefix</a></code> | <code>string</code> | An optional prefix that will be added to the start of all flow log files delivered to the S3 bucket. |
| <code><a href="#cdk-extensions.ec2.FlowLogS3Options.property.perHourPartition">perHourPartition</a></code> | <code>boolean</code> | Indicates whether to partition the flow log per hour. |

---

##### `fileFormat`<sup>Optional</sup> <a name="fileFormat" id="cdk-extensions.ec2.FlowLogS3Options.property.fileFormat"></a>

```typescript
public readonly fileFormat: FlowLogFileFormat;
```

- *Type:* cdk-extensions.ec2.FlowLogFileFormat

The file format in which flow logs should be delivered to S3.

> [[Flow log files](https://docs.aws.amazon.com/vpc/latest/tgw/flow-logs-s3.html#flow-logs-s3-path)]([Flow log files](https://docs.aws.amazon.com/vpc/latest/tgw/flow-logs-s3.html#flow-logs-s3-path))

---

##### `hiveCompatiblePartitions`<sup>Optional</sup> <a name="hiveCompatiblePartitions" id="cdk-extensions.ec2.FlowLogS3Options.property.hiveCompatiblePartitions"></a>

```typescript
public readonly hiveCompatiblePartitions: boolean;
```

- *Type:* boolean

Controls the format of partitions ("folders") when the flow logs are delivered to S3.

By default, flow logs are delivered partitioned such that each part of
the S3 path represents a values pertaining to details of the log.

When hive compatible partitions are enabled, partitions will be
structured such that keys declaring the partition name are added at
each level.

An example of standard partitioning:
```
/us-east-1/2020/03/08/log.tar.gz
```

An example with Hive compatible partitions:
```
/region=us-east-1/year=2020/month=03/day=08/log.tar.gz
```

> [[AWS Big Data Blog](https://aws.amazon.com/blogs/big-data/optimize-performance-and-reduce-costs-for-network-analytics-with-vpc-flow-logs-in-apache-parquet-format/)]([AWS Big Data Blog](https://aws.amazon.com/blogs/big-data/optimize-performance-and-reduce-costs-for-network-analytics-with-vpc-flow-logs-in-apache-parquet-format/))

---

##### `keyPrefix`<sup>Optional</sup> <a name="keyPrefix" id="cdk-extensions.ec2.FlowLogS3Options.property.keyPrefix"></a>

```typescript
public readonly keyPrefix: string;
```

- *Type:* string

An optional prefix that will be added to the start of all flow log files delivered to the S3 bucket.

> [[FlowLog LogDestination](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logdestination)]([FlowLog LogDestination](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logdestination))

---

##### `perHourPartition`<sup>Optional</sup> <a name="perHourPartition" id="cdk-extensions.ec2.FlowLogS3Options.property.perHourPartition"></a>

```typescript
public readonly perHourPartition: boolean;
```

- *Type:* boolean

Indicates whether to partition the flow log per hour.

By default, flow logs are partitioned (organized into S3 "folders") by
day.

Setting this to true will add an extra layer of directories splitting
flow log files by the hour in which they were delivered.

> [[Flow log files](https://docs.aws.amazon.com/vpc/latest/tgw/flow-logs-s3.html#flow-logs-s3-path)]([Flow log files](https://docs.aws.amazon.com/vpc/latest/tgw/flow-logs-s3.html#flow-logs-s3-path))

---

### FlowLogsBucketProps <a name="FlowLogsBucketProps" id="cdk-extensions.s3_buckets.FlowLogsBucketProps"></a>

Configuration for objects bucket.

#### Initializer <a name="Initializer" id="cdk-extensions.s3_buckets.FlowLogsBucketProps.Initializer"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

const flowLogsBucketProps: s3_buckets.FlowLogsBucketProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucketProps.property.account">account</a></code> | <code>string</code> | The AWS account ID this resource belongs to. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucketProps.property.environmentFromArn">environmentFromArn</a></code> | <code>string</code> | ARN to deduce region and account from. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucketProps.property.physicalName">physicalName</a></code> | <code>string</code> | The value passed in by users to the physical name prop of the resource. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucketProps.property.region">region</a></code> | <code>string</code> | The AWS region this resource belongs to. |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucketProps.property.bucketName">bucketName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucketProps.property.crawlerSchedule">crawlerSchedule</a></code> | <code>aws-cdk-lib.aws_events.Schedule</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucketProps.property.createQueries">createQueries</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucketProps.property.database">database</a></code> | <code>cdk-extensions.glue.Database</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucketProps.property.format">format</a></code> | <code>cdk-extensions.ec2.FlowLogFormat</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucketProps.property.friendlyQueryNames">friendlyQueryNames</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.FlowLogsBucketProps.property.tableName">tableName</a></code> | <code>string</code> | *No description.* |

---

##### `account`<sup>Optional</sup> <a name="account" id="cdk-extensions.s3_buckets.FlowLogsBucketProps.property.account"></a>

```typescript
public readonly account: string;
```

- *Type:* string
- *Default:* the resource is in the same account as the stack it belongs to

The AWS account ID this resource belongs to.

---

##### `environmentFromArn`<sup>Optional</sup> <a name="environmentFromArn" id="cdk-extensions.s3_buckets.FlowLogsBucketProps.property.environmentFromArn"></a>

```typescript
public readonly environmentFromArn: string;
```

- *Type:* string
- *Default:* take environment from `account`, `region` parameters, or use Stack environment.

ARN to deduce region and account from.

The ARN is parsed and the account and region are taken from the ARN.
This should be used for imported resources.

Cannot be supplied together with either `account` or `region`.

---

##### `physicalName`<sup>Optional</sup> <a name="physicalName" id="cdk-extensions.s3_buckets.FlowLogsBucketProps.property.physicalName"></a>

```typescript
public readonly physicalName: string;
```

- *Type:* string
- *Default:* The physical name will be allocated by CloudFormation at deployment time

The value passed in by users to the physical name prop of the resource.

`undefined` implies that a physical name will be allocated by
   CloudFormation during deployment.
- a concrete value implies a specific physical name
- `PhysicalName.GENERATE_IF_NEEDED` is a marker that indicates that a physical will only be generated
   by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.

---

##### `region`<sup>Optional</sup> <a name="region" id="cdk-extensions.s3_buckets.FlowLogsBucketProps.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string
- *Default:* the resource is in the same region as the stack it belongs to

The AWS region this resource belongs to.

---

##### `bucketName`<sup>Optional</sup> <a name="bucketName" id="cdk-extensions.s3_buckets.FlowLogsBucketProps.property.bucketName"></a>

```typescript
public readonly bucketName: string;
```

- *Type:* string

---

##### `crawlerSchedule`<sup>Optional</sup> <a name="crawlerSchedule" id="cdk-extensions.s3_buckets.FlowLogsBucketProps.property.crawlerSchedule"></a>

```typescript
public readonly crawlerSchedule: Schedule;
```

- *Type:* aws-cdk-lib.aws_events.Schedule

---

##### `createQueries`<sup>Optional</sup> <a name="createQueries" id="cdk-extensions.s3_buckets.FlowLogsBucketProps.property.createQueries"></a>

```typescript
public readonly createQueries: boolean;
```

- *Type:* boolean

---

##### `database`<sup>Optional</sup> <a name="database" id="cdk-extensions.s3_buckets.FlowLogsBucketProps.property.database"></a>

```typescript
public readonly database: Database;
```

- *Type:* cdk-extensions.glue.Database

---

##### `format`<sup>Optional</sup> <a name="format" id="cdk-extensions.s3_buckets.FlowLogsBucketProps.property.format"></a>

```typescript
public readonly format: FlowLogFormat;
```

- *Type:* cdk-extensions.ec2.FlowLogFormat

---

##### `friendlyQueryNames`<sup>Optional</sup> <a name="friendlyQueryNames" id="cdk-extensions.s3_buckets.FlowLogsBucketProps.property.friendlyQueryNames"></a>

```typescript
public readonly friendlyQueryNames: boolean;
```

- *Type:* boolean

---

##### `tableName`<sup>Optional</sup> <a name="tableName" id="cdk-extensions.s3_buckets.FlowLogsBucketProps.property.tableName"></a>

```typescript
public readonly tableName: string;
```

- *Type:* string

---

### FlowLogsTableProps <a name="FlowLogsTableProps" id="cdk-extensions.glue_tables.FlowLogsTableProps"></a>

Configuration for FlowLogsTable.

#### Initializer <a name="Initializer" id="cdk-extensions.glue_tables.FlowLogsTableProps.Initializer"></a>

```typescript
import { glue_tables } from 'cdk-extensions'

const flowLogsTableProps: glue_tables.FlowLogsTableProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTableProps.property.account">account</a></code> | <code>string</code> | The AWS account ID this resource belongs to. |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTableProps.property.environmentFromArn">environmentFromArn</a></code> | <code>string</code> | ARN to deduce region and account from. |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTableProps.property.physicalName">physicalName</a></code> | <code>string</code> | The value passed in by users to the physical name prop of the resource. |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTableProps.property.region">region</a></code> | <code>string</code> | The AWS region this resource belongs to. |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTableProps.property.bucket">bucket</a></code> | <code>aws-cdk-lib.aws_s3.IBucket</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTableProps.property.database">database</a></code> | <code>cdk-extensions.glue.Database</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTableProps.property.createQueries">createQueries</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTableProps.property.format">format</a></code> | <code>cdk-extensions.ec2.FlowLogFormat</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTableProps.property.friendlyQueryNames">friendlyQueryNames</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTableProps.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.FlowLogsTableProps.property.s3Prefix">s3Prefix</a></code> | <code>string</code> | *No description.* |

---

##### `account`<sup>Optional</sup> <a name="account" id="cdk-extensions.glue_tables.FlowLogsTableProps.property.account"></a>

```typescript
public readonly account: string;
```

- *Type:* string
- *Default:* the resource is in the same account as the stack it belongs to

The AWS account ID this resource belongs to.

---

##### `environmentFromArn`<sup>Optional</sup> <a name="environmentFromArn" id="cdk-extensions.glue_tables.FlowLogsTableProps.property.environmentFromArn"></a>

```typescript
public readonly environmentFromArn: string;
```

- *Type:* string
- *Default:* take environment from `account`, `region` parameters, or use Stack environment.

ARN to deduce region and account from.

The ARN is parsed and the account and region are taken from the ARN.
This should be used for imported resources.

Cannot be supplied together with either `account` or `region`.

---

##### `physicalName`<sup>Optional</sup> <a name="physicalName" id="cdk-extensions.glue_tables.FlowLogsTableProps.property.physicalName"></a>

```typescript
public readonly physicalName: string;
```

- *Type:* string
- *Default:* The physical name will be allocated by CloudFormation at deployment time

The value passed in by users to the physical name prop of the resource.

`undefined` implies that a physical name will be allocated by
   CloudFormation during deployment.
- a concrete value implies a specific physical name
- `PhysicalName.GENERATE_IF_NEEDED` is a marker that indicates that a physical will only be generated
   by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.

---

##### `region`<sup>Optional</sup> <a name="region" id="cdk-extensions.glue_tables.FlowLogsTableProps.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string
- *Default:* the resource is in the same region as the stack it belongs to

The AWS region this resource belongs to.

---

##### `bucket`<sup>Required</sup> <a name="bucket" id="cdk-extensions.glue_tables.FlowLogsTableProps.property.bucket"></a>

```typescript
public readonly bucket: IBucket;
```

- *Type:* aws-cdk-lib.aws_s3.IBucket

---

##### `database`<sup>Required</sup> <a name="database" id="cdk-extensions.glue_tables.FlowLogsTableProps.property.database"></a>

```typescript
public readonly database: Database;
```

- *Type:* cdk-extensions.glue.Database

---

##### `createQueries`<sup>Optional</sup> <a name="createQueries" id="cdk-extensions.glue_tables.FlowLogsTableProps.property.createQueries"></a>

```typescript
public readonly createQueries: boolean;
```

- *Type:* boolean

---

##### `format`<sup>Optional</sup> <a name="format" id="cdk-extensions.glue_tables.FlowLogsTableProps.property.format"></a>

```typescript
public readonly format: FlowLogFormat;
```

- *Type:* cdk-extensions.ec2.FlowLogFormat

---

##### `friendlyQueryNames`<sup>Optional</sup> <a name="friendlyQueryNames" id="cdk-extensions.glue_tables.FlowLogsTableProps.property.friendlyQueryNames"></a>

```typescript
public readonly friendlyQueryNames: boolean;
```

- *Type:* boolean

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.glue_tables.FlowLogsTableProps.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `s3Prefix`<sup>Optional</sup> <a name="s3Prefix" id="cdk-extensions.glue_tables.FlowLogsTableProps.property.s3Prefix"></a>

```typescript
public readonly s3Prefix: string;
```

- *Type:* string

---

### HiveJsonInputSerDeOptions <a name="HiveJsonInputSerDeOptions" id="cdk-extensions.kinesis_firehose.HiveJsonInputSerDeOptions"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.kinesis_firehose.HiveJsonInputSerDeOptions.Initializer"></a>

```typescript
import { kinesis_firehose } from 'cdk-extensions'

const hiveJsonInputSerDeOptions: kinesis_firehose.HiveJsonInputSerDeOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.kinesis_firehose.HiveJsonInputSerDeOptions.property.timestampFormats">timestampFormats</a></code> | <code>string[]</code> | *No description.* |

---

##### `timestampFormats`<sup>Optional</sup> <a name="timestampFormats" id="cdk-extensions.kinesis_firehose.HiveJsonInputSerDeOptions.property.timestampFormats"></a>

```typescript
public readonly timestampFormats: string[];
```

- *Type:* string[]

---

### HttpEndpointDestinationOptions <a name="HttpEndpointDestinationOptions" id="cdk-extensions.kinesis_firehose.HttpEndpointDestinationOptions"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.kinesis_firehose.HttpEndpointDestinationOptions.Initializer"></a>

```typescript
import { kinesis_firehose } from 'cdk-extensions'

const httpEndpointDestinationOptions: kinesis_firehose.HttpEndpointDestinationOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.kinesis_firehose.HttpEndpointDestinationOptions.property.accessKey">accessKey</a></code> | <code>aws-cdk-lib.SecretValue</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.HttpEndpointDestinationOptions.property.backupConfiguration">backupConfiguration</a></code> | <code>cdk-extensions.kinesis_firehose.BackupConfiguration</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.HttpEndpointDestinationOptions.property.buffering">buffering</a></code> | <code>cdk-extensions.kinesis_firehose.BufferingConfiguration</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.HttpEndpointDestinationOptions.property.cloudwatchLoggingConfiguration">cloudwatchLoggingConfiguration</a></code> | <code>cdk-extensions.kinesis_firehose.CloudWatchLoggingConfiguration</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.HttpEndpointDestinationOptions.property.commonAttributes">commonAttributes</a></code> | <code>{[ key: string ]: string}</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.HttpEndpointDestinationOptions.property.contentEncoding">contentEncoding</a></code> | <code>cdk-extensions.kinesis_firehose.ContentEncoding</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.HttpEndpointDestinationOptions.property.endpointName">endpointName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.HttpEndpointDestinationOptions.property.processorConfiguration">processorConfiguration</a></code> | <code>cdk-extensions.kinesis_firehose.ProcessorConfiguration</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.HttpEndpointDestinationOptions.property.retryDuration">retryDuration</a></code> | <code>aws-cdk-lib.Duration</code> | *No description.* |

---

##### `accessKey`<sup>Optional</sup> <a name="accessKey" id="cdk-extensions.kinesis_firehose.HttpEndpointDestinationOptions.property.accessKey"></a>

```typescript
public readonly accessKey: SecretValue;
```

- *Type:* aws-cdk-lib.SecretValue

---

##### `backupConfiguration`<sup>Optional</sup> <a name="backupConfiguration" id="cdk-extensions.kinesis_firehose.HttpEndpointDestinationOptions.property.backupConfiguration"></a>

```typescript
public readonly backupConfiguration: BackupConfiguration;
```

- *Type:* cdk-extensions.kinesis_firehose.BackupConfiguration

---

##### `buffering`<sup>Optional</sup> <a name="buffering" id="cdk-extensions.kinesis_firehose.HttpEndpointDestinationOptions.property.buffering"></a>

```typescript
public readonly buffering: BufferingConfiguration;
```

- *Type:* cdk-extensions.kinesis_firehose.BufferingConfiguration

---

##### `cloudwatchLoggingConfiguration`<sup>Optional</sup> <a name="cloudwatchLoggingConfiguration" id="cdk-extensions.kinesis_firehose.HttpEndpointDestinationOptions.property.cloudwatchLoggingConfiguration"></a>

```typescript
public readonly cloudwatchLoggingConfiguration: CloudWatchLoggingConfiguration;
```

- *Type:* cdk-extensions.kinesis_firehose.CloudWatchLoggingConfiguration

---

##### `commonAttributes`<sup>Optional</sup> <a name="commonAttributes" id="cdk-extensions.kinesis_firehose.HttpEndpointDestinationOptions.property.commonAttributes"></a>

```typescript
public readonly commonAttributes: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: string}

---

##### `contentEncoding`<sup>Optional</sup> <a name="contentEncoding" id="cdk-extensions.kinesis_firehose.HttpEndpointDestinationOptions.property.contentEncoding"></a>

```typescript
public readonly contentEncoding: ContentEncoding;
```

- *Type:* cdk-extensions.kinesis_firehose.ContentEncoding

---

##### `endpointName`<sup>Optional</sup> <a name="endpointName" id="cdk-extensions.kinesis_firehose.HttpEndpointDestinationOptions.property.endpointName"></a>

```typescript
public readonly endpointName: string;
```

- *Type:* string

---

##### `processorConfiguration`<sup>Optional</sup> <a name="processorConfiguration" id="cdk-extensions.kinesis_firehose.HttpEndpointDestinationOptions.property.processorConfiguration"></a>

```typescript
public readonly processorConfiguration: ProcessorConfiguration;
```

- *Type:* cdk-extensions.kinesis_firehose.ProcessorConfiguration

---

##### `retryDuration`<sup>Optional</sup> <a name="retryDuration" id="cdk-extensions.kinesis_firehose.HttpEndpointDestinationOptions.property.retryDuration"></a>

```typescript
public readonly retryDuration: Duration;
```

- *Type:* aws-cdk-lib.Duration

---

### InstanceAccessControlAttributeConfigurationProps <a name="InstanceAccessControlAttributeConfigurationProps" id="cdk-extensions.sso.InstanceAccessControlAttributeConfigurationProps"></a>

Configuration for InstanceAccessControlAttributeConfiguration resource.

#### Initializer <a name="Initializer" id="cdk-extensions.sso.InstanceAccessControlAttributeConfigurationProps.Initializer"></a>

```typescript
import { sso } from 'cdk-extensions'

const instanceAccessControlAttributeConfigurationProps: sso.InstanceAccessControlAttributeConfigurationProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.sso.InstanceAccessControlAttributeConfigurationProps.property.account">account</a></code> | <code>string</code> | The AWS account ID this resource belongs to. |
| <code><a href="#cdk-extensions.sso.InstanceAccessControlAttributeConfigurationProps.property.environmentFromArn">environmentFromArn</a></code> | <code>string</code> | ARN to deduce region and account from. |
| <code><a href="#cdk-extensions.sso.InstanceAccessControlAttributeConfigurationProps.property.physicalName">physicalName</a></code> | <code>string</code> | The value passed in by users to the physical name prop of the resource. |
| <code><a href="#cdk-extensions.sso.InstanceAccessControlAttributeConfigurationProps.property.region">region</a></code> | <code>string</code> | The AWS region this resource belongs to. |
| <code><a href="#cdk-extensions.sso.InstanceAccessControlAttributeConfigurationProps.property.instance">instance</a></code> | <code>cdk-extensions.sso.IInstance</code> | The ARN of the IAM Identity Center instance under which the operation will be executed. |
| <code><a href="#cdk-extensions.sso.InstanceAccessControlAttributeConfigurationProps.property.attributeMapping">attributeMapping</a></code> | <code>{[ key: string ]: string[]}</code> | Lists the attributes that are configured for ABAC in the specified IAM Identity Center instance. |

---

##### `account`<sup>Optional</sup> <a name="account" id="cdk-extensions.sso.InstanceAccessControlAttributeConfigurationProps.property.account"></a>

```typescript
public readonly account: string;
```

- *Type:* string
- *Default:* the resource is in the same account as the stack it belongs to

The AWS account ID this resource belongs to.

---

##### `environmentFromArn`<sup>Optional</sup> <a name="environmentFromArn" id="cdk-extensions.sso.InstanceAccessControlAttributeConfigurationProps.property.environmentFromArn"></a>

```typescript
public readonly environmentFromArn: string;
```

- *Type:* string
- *Default:* take environment from `account`, `region` parameters, or use Stack environment.

ARN to deduce region and account from.

The ARN is parsed and the account and region are taken from the ARN.
This should be used for imported resources.

Cannot be supplied together with either `account` or `region`.

---

##### `physicalName`<sup>Optional</sup> <a name="physicalName" id="cdk-extensions.sso.InstanceAccessControlAttributeConfigurationProps.property.physicalName"></a>

```typescript
public readonly physicalName: string;
```

- *Type:* string
- *Default:* The physical name will be allocated by CloudFormation at deployment time

The value passed in by users to the physical name prop of the resource.

`undefined` implies that a physical name will be allocated by
   CloudFormation during deployment.
- a concrete value implies a specific physical name
- `PhysicalName.GENERATE_IF_NEEDED` is a marker that indicates that a physical will only be generated
   by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.

---

##### `region`<sup>Optional</sup> <a name="region" id="cdk-extensions.sso.InstanceAccessControlAttributeConfigurationProps.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string
- *Default:* the resource is in the same region as the stack it belongs to

The AWS region this resource belongs to.

---

##### `instance`<sup>Required</sup> <a name="instance" id="cdk-extensions.sso.InstanceAccessControlAttributeConfigurationProps.property.instance"></a>

```typescript
public readonly instance: IInstance;
```

- *Type:* cdk-extensions.sso.IInstance

The ARN of the IAM Identity Center instance under which the operation will be executed.

---

##### `attributeMapping`<sup>Optional</sup> <a name="attributeMapping" id="cdk-extensions.sso.InstanceAccessControlAttributeConfigurationProps.property.attributeMapping"></a>

```typescript
public readonly attributeMapping: {[ key: string ]: string[]};
```

- *Type:* {[ key: string ]: string[]}

Lists the attributes that are configured for ABAC in the specified IAM Identity Center instance.

---

### JdbcTargetOptions <a name="JdbcTargetOptions" id="cdk-extensions.glue.JdbcTargetOptions"></a>

Configuration for Crawler JDBC target.

#### Initializer <a name="Initializer" id="cdk-extensions.glue.JdbcTargetOptions.Initializer"></a>

```typescript
import { glue } from 'cdk-extensions'

const jdbcTargetOptions: glue.JdbcTargetOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.JdbcTargetOptions.property.exclusions">exclusions</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.JdbcTargetOptions.property.paths">paths</a></code> | <code>string[]</code> | *No description.* |

---

##### `exclusions`<sup>Optional</sup> <a name="exclusions" id="cdk-extensions.glue.JdbcTargetOptions.property.exclusions"></a>

```typescript
public readonly exclusions: string[];
```

- *Type:* string[]

---

##### `paths`<sup>Optional</sup> <a name="paths" id="cdk-extensions.glue.JdbcTargetOptions.property.paths"></a>

```typescript
public readonly paths: string[];
```

- *Type:* string[]

---

### JobBookmarksEncryption <a name="JobBookmarksEncryption" id="cdk-extensions.glue.JobBookmarksEncryption"></a>

Job bookmarks encryption configuration.

#### Initializer <a name="Initializer" id="cdk-extensions.glue.JobBookmarksEncryption.Initializer"></a>

```typescript
import { glue } from 'cdk-extensions'

const jobBookmarksEncryption: glue.JobBookmarksEncryption = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.JobBookmarksEncryption.property.mode">mode</a></code> | <code>cdk-extensions.glue.JobBookmarksEncryptionMode</code> | Encryption mode. |
| <code><a href="#cdk-extensions.glue.JobBookmarksEncryption.property.kmsKey">kmsKey</a></code> | <code>aws-cdk-lib.aws_kms.IKey</code> | The KMS key to be used to encrypt the data. |

---

##### `mode`<sup>Required</sup> <a name="mode" id="cdk-extensions.glue.JobBookmarksEncryption.property.mode"></a>

```typescript
public readonly mode: JobBookmarksEncryptionMode;
```

- *Type:* cdk-extensions.glue.JobBookmarksEncryptionMode

Encryption mode.

---

##### `kmsKey`<sup>Optional</sup> <a name="kmsKey" id="cdk-extensions.glue.JobBookmarksEncryption.property.kmsKey"></a>

```typescript
public readonly kmsKey: IKey;
```

- *Type:* aws-cdk-lib.aws_kms.IKey
- *Default:* A key will be created if one is not provided.

The KMS key to be used to encrypt the data.

---

### JobExecutableConfig <a name="JobExecutableConfig" id="cdk-extensions.glue.JobExecutableConfig"></a>

Result of binding a `JobExecutable` into a `Job`.

#### Initializer <a name="Initializer" id="cdk-extensions.glue.JobExecutableConfig.Initializer"></a>

```typescript
import { glue } from 'cdk-extensions'

const jobExecutableConfig: glue.JobExecutableConfig = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.JobExecutableConfig.property.glueVersion">glueVersion</a></code> | <code>cdk-extensions.glue.GlueVersion</code> | Glue version. |
| <code><a href="#cdk-extensions.glue.JobExecutableConfig.property.language">language</a></code> | <code>cdk-extensions.glue.JobLanguage</code> | The language of the job (Scala or Python). |
| <code><a href="#cdk-extensions.glue.JobExecutableConfig.property.script">script</a></code> | <code>cdk-extensions.glue.Code</code> | The script that is executed by a job. |
| <code><a href="#cdk-extensions.glue.JobExecutableConfig.property.type">type</a></code> | <code>cdk-extensions.glue.JobType</code> | Specify the type of the job whether it's an Apache Spark ETL or streaming one or if it's a Python shell job. |
| <code><a href="#cdk-extensions.glue.JobExecutableConfig.property.className">className</a></code> | <code>string</code> | The Scala class that serves as the entry point for the job. |
| <code><a href="#cdk-extensions.glue.JobExecutableConfig.property.extraFiles">extraFiles</a></code> | <code>cdk-extensions.glue.Code[]</code> | Additional files, such as configuration files that AWS Glue copies to the working directory of your script before executing it. |
| <code><a href="#cdk-extensions.glue.JobExecutableConfig.property.extraJars">extraJars</a></code> | <code>cdk-extensions.glue.Code[]</code> | Additional Java .jar files that AWS Glue adds to the Java classpath before executing your script. |
| <code><a href="#cdk-extensions.glue.JobExecutableConfig.property.extraJarsFirst">extraJarsFirst</a></code> | <code>boolean</code> | Setting this value to true prioritizes the customer's extra JAR files in the classpath. |
| <code><a href="#cdk-extensions.glue.JobExecutableConfig.property.extraPythonFiles">extraPythonFiles</a></code> | <code>cdk-extensions.glue.Code[]</code> | Additional Python files that AWS Glue adds to the Python path before executing your script. |
| <code><a href="#cdk-extensions.glue.JobExecutableConfig.property.pythonVersion">pythonVersion</a></code> | <code>cdk-extensions.glue.PythonVersion</code> | The Python version to use. |

---

##### `glueVersion`<sup>Required</sup> <a name="glueVersion" id="cdk-extensions.glue.JobExecutableConfig.property.glueVersion"></a>

```typescript
public readonly glueVersion: GlueVersion;
```

- *Type:* cdk-extensions.glue.GlueVersion

Glue version.

> [https://docs.aws.amazon.com/glue/latest/dg/release-notes.html](https://docs.aws.amazon.com/glue/latest/dg/release-notes.html)

---

##### `language`<sup>Required</sup> <a name="language" id="cdk-extensions.glue.JobExecutableConfig.property.language"></a>

```typescript
public readonly language: JobLanguage;
```

- *Type:* cdk-extensions.glue.JobLanguage

The language of the job (Scala or Python).

> [`--job-language` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html](`--job-language` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)

---

##### `script`<sup>Required</sup> <a name="script" id="cdk-extensions.glue.JobExecutableConfig.property.script"></a>

```typescript
public readonly script: Code;
```

- *Type:* cdk-extensions.glue.Code

The script that is executed by a job.

---

##### `type`<sup>Required</sup> <a name="type" id="cdk-extensions.glue.JobExecutableConfig.property.type"></a>

```typescript
public readonly type: JobType;
```

- *Type:* cdk-extensions.glue.JobType

Specify the type of the job whether it's an Apache Spark ETL or streaming one or if it's a Python shell job.

---

##### `className`<sup>Optional</sup> <a name="className" id="cdk-extensions.glue.JobExecutableConfig.property.className"></a>

```typescript
public readonly className: string;
```

- *Type:* string
- *Default:* no scala className specified

The Scala class that serves as the entry point for the job.

This applies only if your the job langauage is Scala.

> [`--class` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html](`--class` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)

---

##### `extraFiles`<sup>Optional</sup> <a name="extraFiles" id="cdk-extensions.glue.JobExecutableConfig.property.extraFiles"></a>

```typescript
public readonly extraFiles: Code[];
```

- *Type:* cdk-extensions.glue.Code[]
- *Default:* no extra files specified.

Additional files, such as configuration files that AWS Glue copies to the working directory of your script before executing it.

> [`--extra-files` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html](`--extra-files` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)

---

##### `extraJars`<sup>Optional</sup> <a name="extraJars" id="cdk-extensions.glue.JobExecutableConfig.property.extraJars"></a>

```typescript
public readonly extraJars: Code[];
```

- *Type:* cdk-extensions.glue.Code[]
- *Default:* no extra jars specified.

Additional Java .jar files that AWS Glue adds to the Java classpath before executing your script.

> [`--extra-jars` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html](`--extra-jars` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)

---

##### `extraJarsFirst`<sup>Optional</sup> <a name="extraJarsFirst" id="cdk-extensions.glue.JobExecutableConfig.property.extraJarsFirst"></a>

```typescript
public readonly extraJarsFirst: boolean;
```

- *Type:* boolean
- *Default:* extra jars are not prioritized.

Setting this value to true prioritizes the customer's extra JAR files in the classpath.

> [`--user-jars-first` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html](`--user-jars-first` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)

---

##### `extraPythonFiles`<sup>Optional</sup> <a name="extraPythonFiles" id="cdk-extensions.glue.JobExecutableConfig.property.extraPythonFiles"></a>

```typescript
public readonly extraPythonFiles: Code[];
```

- *Type:* cdk-extensions.glue.Code[]
- *Default:* no extra python files specified.

Additional Python files that AWS Glue adds to the Python path before executing your script.

> [`--extra-py-files` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html](`--extra-py-files` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)

---

##### `pythonVersion`<sup>Optional</sup> <a name="pythonVersion" id="cdk-extensions.glue.JobExecutableConfig.property.pythonVersion"></a>

```typescript
public readonly pythonVersion: PythonVersion;
```

- *Type:* cdk-extensions.glue.PythonVersion
- *Default:* no python version specified

The Python version to use.

---

### JobProps <a name="JobProps" id="cdk-extensions.glue.JobProps"></a>

Configuration for the Glue Job resource.

#### Initializer <a name="Initializer" id="cdk-extensions.glue.JobProps.Initializer"></a>

```typescript
import { glue } from 'cdk-extensions'

const jobProps: glue.JobProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.JobProps.property.account">account</a></code> | <code>string</code> | The AWS account ID this resource belongs to. |
| <code><a href="#cdk-extensions.glue.JobProps.property.environmentFromArn">environmentFromArn</a></code> | <code>string</code> | ARN to deduce region and account from. |
| <code><a href="#cdk-extensions.glue.JobProps.property.physicalName">physicalName</a></code> | <code>string</code> | The value passed in by users to the physical name prop of the resource. |
| <code><a href="#cdk-extensions.glue.JobProps.property.region">region</a></code> | <code>string</code> | The AWS region this resource belongs to. |
| <code><a href="#cdk-extensions.glue.JobProps.property.executable">executable</a></code> | <code>cdk-extensions.glue.JobExecutable</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.JobProps.property.allocatedCapacity">allocatedCapacity</a></code> | <code>number</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.JobProps.property.connections">connections</a></code> | <code>cdk-extensions.glue.Connection[]</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.JobProps.property.continuousLogging">continuousLogging</a></code> | <code>cdk-extensions.glue.ContinuousLoggingProps</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.JobProps.property.defaultArguments">defaultArguments</a></code> | <code>{[ key: string ]: string}</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.JobProps.property.description">description</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.JobProps.property.enableProfilingMetrics">enableProfilingMetrics</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.JobProps.property.maxCapacity">maxCapacity</a></code> | <code>number</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.JobProps.property.maxConcurrentRuns">maxConcurrentRuns</a></code> | <code>number</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.JobProps.property.maxRetries">maxRetries</a></code> | <code>number</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.JobProps.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.JobProps.property.notifyDelayAfter">notifyDelayAfter</a></code> | <code>aws-cdk-lib.Duration</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.JobProps.property.role">role</a></code> | <code>aws-cdk-lib.aws_iam.IRole</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.JobProps.property.securityConfiguration">securityConfiguration</a></code> | <code>cdk-extensions.glue.SecurityConfiguration</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.JobProps.property.timeout">timeout</a></code> | <code>aws-cdk-lib.Duration</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.JobProps.property.workerCount">workerCount</a></code> | <code>number</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.JobProps.property.workerType">workerType</a></code> | <code>cdk-extensions.glue.WorkerType</code> | *No description.* |

---

##### `account`<sup>Optional</sup> <a name="account" id="cdk-extensions.glue.JobProps.property.account"></a>

```typescript
public readonly account: string;
```

- *Type:* string
- *Default:* the resource is in the same account as the stack it belongs to

The AWS account ID this resource belongs to.

---

##### `environmentFromArn`<sup>Optional</sup> <a name="environmentFromArn" id="cdk-extensions.glue.JobProps.property.environmentFromArn"></a>

```typescript
public readonly environmentFromArn: string;
```

- *Type:* string
- *Default:* take environment from `account`, `region` parameters, or use Stack environment.

ARN to deduce region and account from.

The ARN is parsed and the account and region are taken from the ARN.
This should be used for imported resources.

Cannot be supplied together with either `account` or `region`.

---

##### `physicalName`<sup>Optional</sup> <a name="physicalName" id="cdk-extensions.glue.JobProps.property.physicalName"></a>

```typescript
public readonly physicalName: string;
```

- *Type:* string
- *Default:* The physical name will be allocated by CloudFormation at deployment time

The value passed in by users to the physical name prop of the resource.

`undefined` implies that a physical name will be allocated by
   CloudFormation during deployment.
- a concrete value implies a specific physical name
- `PhysicalName.GENERATE_IF_NEEDED` is a marker that indicates that a physical will only be generated
   by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.

---

##### `region`<sup>Optional</sup> <a name="region" id="cdk-extensions.glue.JobProps.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string
- *Default:* the resource is in the same region as the stack it belongs to

The AWS region this resource belongs to.

---

##### `executable`<sup>Required</sup> <a name="executable" id="cdk-extensions.glue.JobProps.property.executable"></a>

```typescript
public readonly executable: JobExecutable;
```

- *Type:* cdk-extensions.glue.JobExecutable

---

##### `allocatedCapacity`<sup>Optional</sup> <a name="allocatedCapacity" id="cdk-extensions.glue.JobProps.property.allocatedCapacity"></a>

```typescript
public readonly allocatedCapacity: number;
```

- *Type:* number

---

##### `connections`<sup>Optional</sup> <a name="connections" id="cdk-extensions.glue.JobProps.property.connections"></a>

```typescript
public readonly connections: Connection[];
```

- *Type:* cdk-extensions.glue.Connection[]

---

##### `continuousLogging`<sup>Optional</sup> <a name="continuousLogging" id="cdk-extensions.glue.JobProps.property.continuousLogging"></a>

```typescript
public readonly continuousLogging: ContinuousLoggingProps;
```

- *Type:* cdk-extensions.glue.ContinuousLoggingProps

---

##### `defaultArguments`<sup>Optional</sup> <a name="defaultArguments" id="cdk-extensions.glue.JobProps.property.defaultArguments"></a>

```typescript
public readonly defaultArguments: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: string}

---

##### `description`<sup>Optional</sup> <a name="description" id="cdk-extensions.glue.JobProps.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

---

##### `enableProfilingMetrics`<sup>Optional</sup> <a name="enableProfilingMetrics" id="cdk-extensions.glue.JobProps.property.enableProfilingMetrics"></a>

```typescript
public readonly enableProfilingMetrics: boolean;
```

- *Type:* boolean

---

##### `maxCapacity`<sup>Optional</sup> <a name="maxCapacity" id="cdk-extensions.glue.JobProps.property.maxCapacity"></a>

```typescript
public readonly maxCapacity: number;
```

- *Type:* number

---

##### `maxConcurrentRuns`<sup>Optional</sup> <a name="maxConcurrentRuns" id="cdk-extensions.glue.JobProps.property.maxConcurrentRuns"></a>

```typescript
public readonly maxConcurrentRuns: number;
```

- *Type:* number

---

##### `maxRetries`<sup>Optional</sup> <a name="maxRetries" id="cdk-extensions.glue.JobProps.property.maxRetries"></a>

```typescript
public readonly maxRetries: number;
```

- *Type:* number

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.glue.JobProps.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `notifyDelayAfter`<sup>Optional</sup> <a name="notifyDelayAfter" id="cdk-extensions.glue.JobProps.property.notifyDelayAfter"></a>

```typescript
public readonly notifyDelayAfter: Duration;
```

- *Type:* aws-cdk-lib.Duration

---

##### `role`<sup>Optional</sup> <a name="role" id="cdk-extensions.glue.JobProps.property.role"></a>

```typescript
public readonly role: IRole;
```

- *Type:* aws-cdk-lib.aws_iam.IRole

---

##### `securityConfiguration`<sup>Optional</sup> <a name="securityConfiguration" id="cdk-extensions.glue.JobProps.property.securityConfiguration"></a>

```typescript
public readonly securityConfiguration: SecurityConfiguration;
```

- *Type:* cdk-extensions.glue.SecurityConfiguration

---

##### `timeout`<sup>Optional</sup> <a name="timeout" id="cdk-extensions.glue.JobProps.property.timeout"></a>

```typescript
public readonly timeout: Duration;
```

- *Type:* aws-cdk-lib.Duration

---

##### `workerCount`<sup>Optional</sup> <a name="workerCount" id="cdk-extensions.glue.JobProps.property.workerCount"></a>

```typescript
public readonly workerCount: number;
```

- *Type:* number

---

##### `workerType`<sup>Optional</sup> <a name="workerType" id="cdk-extensions.glue.JobProps.property.workerType"></a>

```typescript
public readonly workerType: WorkerType;
```

- *Type:* cdk-extensions.glue.WorkerType

---

### JsonPartitioningOptions <a name="JsonPartitioningOptions" id="cdk-extensions.kinesis_firehose.JsonPartitioningOptions"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.kinesis_firehose.JsonPartitioningOptions.Initializer"></a>

```typescript
import { kinesis_firehose } from 'cdk-extensions'

const jsonPartitioningOptions: kinesis_firehose.JsonPartitioningOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.kinesis_firehose.JsonPartitioningOptions.property.enabled">enabled</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.JsonPartitioningOptions.property.retryInterval">retryInterval</a></code> | <code>aws-cdk-lib.Duration</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.JsonPartitioningOptions.property.partitions">partitions</a></code> | <code>{[ key: string ]: string}</code> | *No description.* |

---

##### `enabled`<sup>Optional</sup> <a name="enabled" id="cdk-extensions.kinesis_firehose.JsonPartitioningOptions.property.enabled"></a>

```typescript
public readonly enabled: boolean;
```

- *Type:* boolean

---

##### `retryInterval`<sup>Optional</sup> <a name="retryInterval" id="cdk-extensions.kinesis_firehose.JsonPartitioningOptions.property.retryInterval"></a>

```typescript
public readonly retryInterval: Duration;
```

- *Type:* aws-cdk-lib.Duration

---

##### `partitions`<sup>Required</sup> <a name="partitions" id="cdk-extensions.kinesis_firehose.JsonPartitioningOptions.property.partitions"></a>

```typescript
public readonly partitions: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: string}

---

### LambdaPartitioningOptions <a name="LambdaPartitioningOptions" id="cdk-extensions.kinesis_firehose.LambdaPartitioningOptions"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.kinesis_firehose.LambdaPartitioningOptions.Initializer"></a>

```typescript
import { kinesis_firehose } from 'cdk-extensions'

const lambdaPartitioningOptions: kinesis_firehose.LambdaPartitioningOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.kinesis_firehose.LambdaPartitioningOptions.property.enabled">enabled</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.LambdaPartitioningOptions.property.retryInterval">retryInterval</a></code> | <code>aws-cdk-lib.Duration</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.LambdaPartitioningOptions.property.lambdaFunction">lambdaFunction</a></code> | <code>aws-cdk-lib.aws_lambda.IFunction</code> | *No description.* |

---

##### `enabled`<sup>Optional</sup> <a name="enabled" id="cdk-extensions.kinesis_firehose.LambdaPartitioningOptions.property.enabled"></a>

```typescript
public readonly enabled: boolean;
```

- *Type:* boolean

---

##### `retryInterval`<sup>Optional</sup> <a name="retryInterval" id="cdk-extensions.kinesis_firehose.LambdaPartitioningOptions.property.retryInterval"></a>

```typescript
public readonly retryInterval: Duration;
```

- *Type:* aws-cdk-lib.Duration

---

##### `lambdaFunction`<sup>Required</sup> <a name="lambdaFunction" id="cdk-extensions.kinesis_firehose.LambdaPartitioningOptions.property.lambdaFunction"></a>

```typescript
public readonly lambdaFunction: IFunction;
```

- *Type:* aws-cdk-lib.aws_lambda.IFunction

---

### LambdaProcessorOptions <a name="LambdaProcessorOptions" id="cdk-extensions.kinesis_firehose.LambdaProcessorOptions"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.kinesis_firehose.LambdaProcessorOptions.Initializer"></a>

```typescript
import { kinesis_firehose } from 'cdk-extensions'

const lambdaProcessorOptions: kinesis_firehose.LambdaProcessorOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.kinesis_firehose.LambdaProcessorOptions.property.lambdaFunction">lambdaFunction</a></code> | <code>aws-cdk-lib.aws_lambda.IFunction</code> | *No description.* |

---

##### `lambdaFunction`<sup>Required</sup> <a name="lambdaFunction" id="cdk-extensions.kinesis_firehose.LambdaProcessorOptions.property.lambdaFunction"></a>

```typescript
public readonly lambdaFunction: IFunction;
```

- *Type:* aws-cdk-lib.aws_lambda.IFunction

---

### LoggingAspectOptions <a name="LoggingAspectOptions" id="cdk-extensions.s3_buckets.LoggingAspectOptions"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.s3_buckets.LoggingAspectOptions.Initializer"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

const loggingAspectOptions: s3_buckets.LoggingAspectOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.LoggingAspectOptions.property.exclusions">exclusions</a></code> | <code>constructs.IConstruct[]</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.LoggingAspectOptions.property.force">force</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.LoggingAspectOptions.property.prefix">prefix</a></code> | <code>string</code> | *No description.* |

---

##### `exclusions`<sup>Optional</sup> <a name="exclusions" id="cdk-extensions.s3_buckets.LoggingAspectOptions.property.exclusions"></a>

```typescript
public readonly exclusions: IConstruct[];
```

- *Type:* constructs.IConstruct[]

---

##### `force`<sup>Optional</sup> <a name="force" id="cdk-extensions.s3_buckets.LoggingAspectOptions.property.force"></a>

```typescript
public readonly force: boolean;
```

- *Type:* boolean

---

##### `prefix`<sup>Optional</sup> <a name="prefix" id="cdk-extensions.s3_buckets.LoggingAspectOptions.property.prefix"></a>

```typescript
public readonly prefix: string;
```

- *Type:* string

---

### MetadataExtractionProcessorOptions <a name="MetadataExtractionProcessorOptions" id="cdk-extensions.kinesis_firehose.MetadataExtractionProcessorOptions"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.kinesis_firehose.MetadataExtractionProcessorOptions.Initializer"></a>

```typescript
import { kinesis_firehose } from 'cdk-extensions'

const metadataExtractionProcessorOptions: kinesis_firehose.MetadataExtractionProcessorOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.kinesis_firehose.MetadataExtractionProcessorOptions.property.query">query</a></code> | <code>cdk-extensions.kinesis_firehose.MetaDataExtractionQuery</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.MetadataExtractionProcessorOptions.property.engine">engine</a></code> | <code>cdk-extensions.kinesis_firehose.JsonParsingEngine</code> | *No description.* |

---

##### `query`<sup>Required</sup> <a name="query" id="cdk-extensions.kinesis_firehose.MetadataExtractionProcessorOptions.property.query"></a>

```typescript
public readonly query: MetaDataExtractionQuery;
```

- *Type:* cdk-extensions.kinesis_firehose.MetaDataExtractionQuery

---

##### `engine`<sup>Optional</sup> <a name="engine" id="cdk-extensions.kinesis_firehose.MetadataExtractionProcessorOptions.property.engine"></a>

```typescript
public readonly engine: JsonParsingEngine;
```

- *Type:* cdk-extensions.kinesis_firehose.JsonParsingEngine

---

### NamedQueryProps <a name="NamedQueryProps" id="cdk-extensions.athena.NamedQueryProps"></a>

Configuration for Database.

#### Initializer <a name="Initializer" id="cdk-extensions.athena.NamedQueryProps.Initializer"></a>

```typescript
import { athena } from 'cdk-extensions'

const namedQueryProps: athena.NamedQueryProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.athena.NamedQueryProps.property.account">account</a></code> | <code>string</code> | The AWS account ID this resource belongs to. |
| <code><a href="#cdk-extensions.athena.NamedQueryProps.property.environmentFromArn">environmentFromArn</a></code> | <code>string</code> | ARN to deduce region and account from. |
| <code><a href="#cdk-extensions.athena.NamedQueryProps.property.physicalName">physicalName</a></code> | <code>string</code> | The value passed in by users to the physical name prop of the resource. |
| <code><a href="#cdk-extensions.athena.NamedQueryProps.property.region">region</a></code> | <code>string</code> | The AWS region this resource belongs to. |
| <code><a href="#cdk-extensions.athena.NamedQueryProps.property.database">database</a></code> | <code>cdk-extensions.glue.Database</code> | The Glue database to which the query belongs. |
| <code><a href="#cdk-extensions.athena.NamedQueryProps.property.queryString">queryString</a></code> | <code>string</code> | The SQL statements that make up the query. |
| <code><a href="#cdk-extensions.athena.NamedQueryProps.property.description">description</a></code> | <code>string</code> | A human friendly description explaining the functionality of the query. |
| <code><a href="#cdk-extensions.athena.NamedQueryProps.property.name">name</a></code> | <code>string</code> | The name of the query. |

---

##### `account`<sup>Optional</sup> <a name="account" id="cdk-extensions.athena.NamedQueryProps.property.account"></a>

```typescript
public readonly account: string;
```

- *Type:* string
- *Default:* the resource is in the same account as the stack it belongs to

The AWS account ID this resource belongs to.

---

##### `environmentFromArn`<sup>Optional</sup> <a name="environmentFromArn" id="cdk-extensions.athena.NamedQueryProps.property.environmentFromArn"></a>

```typescript
public readonly environmentFromArn: string;
```

- *Type:* string
- *Default:* take environment from `account`, `region` parameters, or use Stack environment.

ARN to deduce region and account from.

The ARN is parsed and the account and region are taken from the ARN.
This should be used for imported resources.

Cannot be supplied together with either `account` or `region`.

---

##### `physicalName`<sup>Optional</sup> <a name="physicalName" id="cdk-extensions.athena.NamedQueryProps.property.physicalName"></a>

```typescript
public readonly physicalName: string;
```

- *Type:* string
- *Default:* The physical name will be allocated by CloudFormation at deployment time

The value passed in by users to the physical name prop of the resource.

`undefined` implies that a physical name will be allocated by
   CloudFormation during deployment.
- a concrete value implies a specific physical name
- `PhysicalName.GENERATE_IF_NEEDED` is a marker that indicates that a physical will only be generated
   by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.

---

##### `region`<sup>Optional</sup> <a name="region" id="cdk-extensions.athena.NamedQueryProps.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string
- *Default:* the resource is in the same region as the stack it belongs to

The AWS region this resource belongs to.

---

##### `database`<sup>Required</sup> <a name="database" id="cdk-extensions.athena.NamedQueryProps.property.database"></a>

```typescript
public readonly database: Database;
```

- *Type:* cdk-extensions.glue.Database

The Glue database to which the query belongs.

> [[NamedQuery Database](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html#cfn-athena-namedquery-database)]([NamedQuery Database](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html#cfn-athena-namedquery-database))

---

##### `queryString`<sup>Required</sup> <a name="queryString" id="cdk-extensions.athena.NamedQueryProps.property.queryString"></a>

```typescript
public readonly queryString: string;
```

- *Type:* string

The SQL statements that make up the query.

> [[Athena SQL reference](https://docs.aws.amazon.com/athena/latest/ug/ddl-sql-reference.html)]([Athena SQL reference](https://docs.aws.amazon.com/athena/latest/ug/ddl-sql-reference.html))

---

##### `description`<sup>Optional</sup> <a name="description" id="cdk-extensions.athena.NamedQueryProps.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

A human friendly description explaining the functionality of the query.

> [[NamedQuery Description](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html#cfn-athena-namedquery-description)]([NamedQuery Description](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html#cfn-athena-namedquery-description))

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.athena.NamedQueryProps.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the query.

> [[NamedQuery Name](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html#cfn-athena-namedquery-name)]([NamedQuery Name](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html#cfn-athena-namedquery-name))

---

### OpenxJsonInputSerDeOptions <a name="OpenxJsonInputSerDeOptions" id="cdk-extensions.kinesis_firehose.OpenxJsonInputSerDeOptions"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.kinesis_firehose.OpenxJsonInputSerDeOptions.Initializer"></a>

```typescript
import { kinesis_firehose } from 'cdk-extensions'

const openxJsonInputSerDeOptions: kinesis_firehose.OpenxJsonInputSerDeOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.kinesis_firehose.OpenxJsonInputSerDeOptions.property.caseInsensitive">caseInsensitive</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.OpenxJsonInputSerDeOptions.property.columnKeyMappings">columnKeyMappings</a></code> | <code>{[ key: string ]: string}</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.OpenxJsonInputSerDeOptions.property.convertDotsToUnderscores">convertDotsToUnderscores</a></code> | <code>boolean</code> | *No description.* |

---

##### `caseInsensitive`<sup>Optional</sup> <a name="caseInsensitive" id="cdk-extensions.kinesis_firehose.OpenxJsonInputSerDeOptions.property.caseInsensitive"></a>

```typescript
public readonly caseInsensitive: boolean;
```

- *Type:* boolean

---

##### `columnKeyMappings`<sup>Optional</sup> <a name="columnKeyMappings" id="cdk-extensions.kinesis_firehose.OpenxJsonInputSerDeOptions.property.columnKeyMappings"></a>

```typescript
public readonly columnKeyMappings: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: string}

---

##### `convertDotsToUnderscores`<sup>Optional</sup> <a name="convertDotsToUnderscores" id="cdk-extensions.kinesis_firehose.OpenxJsonInputSerDeOptions.property.convertDotsToUnderscores"></a>

```typescript
public readonly convertDotsToUnderscores: boolean;
```

- *Type:* boolean

---

### OrcOutputSerDeOptions <a name="OrcOutputSerDeOptions" id="cdk-extensions.kinesis_firehose.OrcOutputSerDeOptions"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.kinesis_firehose.OrcOutputSerDeOptions.Initializer"></a>

```typescript
import { kinesis_firehose } from 'cdk-extensions'

const orcOutputSerDeOptions: kinesis_firehose.OrcOutputSerDeOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.kinesis_firehose.OrcOutputSerDeOptions.property.blockSizeBytes">blockSizeBytes</a></code> | <code>number</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.OrcOutputSerDeOptions.property.bloomFilterColumns">bloomFilterColumns</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.OrcOutputSerDeOptions.property.bloomFilterFalsePositiveProbability">bloomFilterFalsePositiveProbability</a></code> | <code>number</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.OrcOutputSerDeOptions.property.compression">compression</a></code> | <code>cdk-extensions.kinesis_firehose.OrcCompressionFormat</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.OrcOutputSerDeOptions.property.dictionaryKeyThreshold">dictionaryKeyThreshold</a></code> | <code>number</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.OrcOutputSerDeOptions.property.enablePadding">enablePadding</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.OrcOutputSerDeOptions.property.formatVersion">formatVersion</a></code> | <code>cdk-extensions.kinesis_firehose.OrcFormatVersion</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.OrcOutputSerDeOptions.property.paddingTolerance">paddingTolerance</a></code> | <code>number</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.OrcOutputSerDeOptions.property.rowIndexStride">rowIndexStride</a></code> | <code>number</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.OrcOutputSerDeOptions.property.stripeSizeBytes">stripeSizeBytes</a></code> | <code>number</code> | *No description.* |

---

##### `blockSizeBytes`<sup>Optional</sup> <a name="blockSizeBytes" id="cdk-extensions.kinesis_firehose.OrcOutputSerDeOptions.property.blockSizeBytes"></a>

```typescript
public readonly blockSizeBytes: number;
```

- *Type:* number

---

##### `bloomFilterColumns`<sup>Optional</sup> <a name="bloomFilterColumns" id="cdk-extensions.kinesis_firehose.OrcOutputSerDeOptions.property.bloomFilterColumns"></a>

```typescript
public readonly bloomFilterColumns: string[];
```

- *Type:* string[]

---

##### `bloomFilterFalsePositiveProbability`<sup>Optional</sup> <a name="bloomFilterFalsePositiveProbability" id="cdk-extensions.kinesis_firehose.OrcOutputSerDeOptions.property.bloomFilterFalsePositiveProbability"></a>

```typescript
public readonly bloomFilterFalsePositiveProbability: number;
```

- *Type:* number

---

##### `compression`<sup>Optional</sup> <a name="compression" id="cdk-extensions.kinesis_firehose.OrcOutputSerDeOptions.property.compression"></a>

```typescript
public readonly compression: OrcCompressionFormat;
```

- *Type:* cdk-extensions.kinesis_firehose.OrcCompressionFormat

---

##### `dictionaryKeyThreshold`<sup>Optional</sup> <a name="dictionaryKeyThreshold" id="cdk-extensions.kinesis_firehose.OrcOutputSerDeOptions.property.dictionaryKeyThreshold"></a>

```typescript
public readonly dictionaryKeyThreshold: number;
```

- *Type:* number

---

##### `enablePadding`<sup>Optional</sup> <a name="enablePadding" id="cdk-extensions.kinesis_firehose.OrcOutputSerDeOptions.property.enablePadding"></a>

```typescript
public readonly enablePadding: boolean;
```

- *Type:* boolean

---

##### `formatVersion`<sup>Optional</sup> <a name="formatVersion" id="cdk-extensions.kinesis_firehose.OrcOutputSerDeOptions.property.formatVersion"></a>

```typescript
public readonly formatVersion: OrcFormatVersion;
```

- *Type:* cdk-extensions.kinesis_firehose.OrcFormatVersion

---

##### `paddingTolerance`<sup>Optional</sup> <a name="paddingTolerance" id="cdk-extensions.kinesis_firehose.OrcOutputSerDeOptions.property.paddingTolerance"></a>

```typescript
public readonly paddingTolerance: number;
```

- *Type:* number

---

##### `rowIndexStride`<sup>Optional</sup> <a name="rowIndexStride" id="cdk-extensions.kinesis_firehose.OrcOutputSerDeOptions.property.rowIndexStride"></a>

```typescript
public readonly rowIndexStride: number;
```

- *Type:* number

---

##### `stripeSizeBytes`<sup>Optional</sup> <a name="stripeSizeBytes" id="cdk-extensions.kinesis_firehose.OrcOutputSerDeOptions.property.stripeSizeBytes"></a>

```typescript
public readonly stripeSizeBytes: number;
```

- *Type:* number

---

### ParquetOutputSerDeOptions <a name="ParquetOutputSerDeOptions" id="cdk-extensions.kinesis_firehose.ParquetOutputSerDeOptions"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.kinesis_firehose.ParquetOutputSerDeOptions.Initializer"></a>

```typescript
import { kinesis_firehose } from 'cdk-extensions'

const parquetOutputSerDeOptions: kinesis_firehose.ParquetOutputSerDeOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.kinesis_firehose.ParquetOutputSerDeOptions.property.blockSizeBytes">blockSizeBytes</a></code> | <code>number</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.ParquetOutputSerDeOptions.property.compression">compression</a></code> | <code>cdk-extensions.kinesis_firehose.ParquetCompressionFormat</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.ParquetOutputSerDeOptions.property.enableDictionaryCompression">enableDictionaryCompression</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.ParquetOutputSerDeOptions.property.maxPaddingBytes">maxPaddingBytes</a></code> | <code>number</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.ParquetOutputSerDeOptions.property.pageSizeBytes">pageSizeBytes</a></code> | <code>number</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.ParquetOutputSerDeOptions.property.writerVersion">writerVersion</a></code> | <code>cdk-extensions.kinesis_firehose.ParquetWriterVersion</code> | *No description.* |

---

##### `blockSizeBytes`<sup>Optional</sup> <a name="blockSizeBytes" id="cdk-extensions.kinesis_firehose.ParquetOutputSerDeOptions.property.blockSizeBytes"></a>

```typescript
public readonly blockSizeBytes: number;
```

- *Type:* number

---

##### `compression`<sup>Optional</sup> <a name="compression" id="cdk-extensions.kinesis_firehose.ParquetOutputSerDeOptions.property.compression"></a>

```typescript
public readonly compression: ParquetCompressionFormat;
```

- *Type:* cdk-extensions.kinesis_firehose.ParquetCompressionFormat

---

##### `enableDictionaryCompression`<sup>Optional</sup> <a name="enableDictionaryCompression" id="cdk-extensions.kinesis_firehose.ParquetOutputSerDeOptions.property.enableDictionaryCompression"></a>

```typescript
public readonly enableDictionaryCompression: boolean;
```

- *Type:* boolean

---

##### `maxPaddingBytes`<sup>Optional</sup> <a name="maxPaddingBytes" id="cdk-extensions.kinesis_firehose.ParquetOutputSerDeOptions.property.maxPaddingBytes"></a>

```typescript
public readonly maxPaddingBytes: number;
```

- *Type:* number

---

##### `pageSizeBytes`<sup>Optional</sup> <a name="pageSizeBytes" id="cdk-extensions.kinesis_firehose.ParquetOutputSerDeOptions.property.pageSizeBytes"></a>

```typescript
public readonly pageSizeBytes: number;
```

- *Type:* number

---

##### `writerVersion`<sup>Optional</sup> <a name="writerVersion" id="cdk-extensions.kinesis_firehose.ParquetOutputSerDeOptions.property.writerVersion"></a>

```typescript
public readonly writerVersion: ParquetWriterVersion;
```

- *Type:* cdk-extensions.kinesis_firehose.ParquetWriterVersion

---

### PermissionSetProps <a name="PermissionSetProps" id="cdk-extensions.sso.PermissionSetProps"></a>

Configuration for PermissionSet resource.

#### Initializer <a name="Initializer" id="cdk-extensions.sso.PermissionSetProps.Initializer"></a>

```typescript
import { sso } from 'cdk-extensions'

const permissionSetProps: sso.PermissionSetProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.sso.PermissionSetProps.property.account">account</a></code> | <code>string</code> | The AWS account ID this resource belongs to. |
| <code><a href="#cdk-extensions.sso.PermissionSetProps.property.environmentFromArn">environmentFromArn</a></code> | <code>string</code> | ARN to deduce region and account from. |
| <code><a href="#cdk-extensions.sso.PermissionSetProps.property.physicalName">physicalName</a></code> | <code>string</code> | The value passed in by users to the physical name prop of the resource. |
| <code><a href="#cdk-extensions.sso.PermissionSetProps.property.region">region</a></code> | <code>string</code> | The AWS region this resource belongs to. |
| <code><a href="#cdk-extensions.sso.PermissionSetProps.property.instance">instance</a></code> | <code>cdk-extensions.sso.IInstance</code> | The ARN of the IAM Identity Center instance under which the operation will be executed. |
| <code><a href="#cdk-extensions.sso.PermissionSetProps.property.description">description</a></code> | <code>string</code> | A user friendly description providing details about the permission set. |
| <code><a href="#cdk-extensions.sso.PermissionSetProps.property.inlinePolicies">inlinePolicies</a></code> | <code>{[ key: string ]: aws-cdk-lib.aws_iam.PolicyDocument}</code> | Adds inline policy documents that will be embedded in the permission set. |
| <code><a href="#cdk-extensions.sso.PermissionSetProps.property.managedPolicies">managedPolicies</a></code> | <code>aws-cdk-lib.aws_iam.IManagedPolicy[]</code> | A list of the IAM managed policies that you want to attach to the permission set. |
| <code><a href="#cdk-extensions.sso.PermissionSetProps.property.name">name</a></code> | <code>string</code> | The name of the permission set. |
| <code><a href="#cdk-extensions.sso.PermissionSetProps.property.permissionsBoundary">permissionsBoundary</a></code> | <code>cdk-extensions.sso.PermissionsBoundary</code> | Specifies the configuration of the AWS managed or customer managed policy that you want to set as a permissions boundary. |
| <code><a href="#cdk-extensions.sso.PermissionSetProps.property.relayState">relayState</a></code> | <code>string</code> | Used to redirect users within the application during the federation authentication process. |
| <code><a href="#cdk-extensions.sso.PermissionSetProps.property.sessionDuration">sessionDuration</a></code> | <code>aws-cdk-lib.Duration</code> | The length of time that the application user sessions are valid for. |

---

##### `account`<sup>Optional</sup> <a name="account" id="cdk-extensions.sso.PermissionSetProps.property.account"></a>

```typescript
public readonly account: string;
```

- *Type:* string
- *Default:* the resource is in the same account as the stack it belongs to

The AWS account ID this resource belongs to.

---

##### `environmentFromArn`<sup>Optional</sup> <a name="environmentFromArn" id="cdk-extensions.sso.PermissionSetProps.property.environmentFromArn"></a>

```typescript
public readonly environmentFromArn: string;
```

- *Type:* string
- *Default:* take environment from `account`, `region` parameters, or use Stack environment.

ARN to deduce region and account from.

The ARN is parsed and the account and region are taken from the ARN.
This should be used for imported resources.

Cannot be supplied together with either `account` or `region`.

---

##### `physicalName`<sup>Optional</sup> <a name="physicalName" id="cdk-extensions.sso.PermissionSetProps.property.physicalName"></a>

```typescript
public readonly physicalName: string;
```

- *Type:* string
- *Default:* The physical name will be allocated by CloudFormation at deployment time

The value passed in by users to the physical name prop of the resource.

`undefined` implies that a physical name will be allocated by
   CloudFormation during deployment.
- a concrete value implies a specific physical name
- `PhysicalName.GENERATE_IF_NEEDED` is a marker that indicates that a physical will only be generated
   by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.

---

##### `region`<sup>Optional</sup> <a name="region" id="cdk-extensions.sso.PermissionSetProps.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string
- *Default:* the resource is in the same region as the stack it belongs to

The AWS region this resource belongs to.

---

##### `instance`<sup>Required</sup> <a name="instance" id="cdk-extensions.sso.PermissionSetProps.property.instance"></a>

```typescript
public readonly instance: IInstance;
```

- *Type:* cdk-extensions.sso.IInstance

The ARN of the IAM Identity Center instance under which the operation will be executed.

---

##### `description`<sup>Optional</sup> <a name="description" id="cdk-extensions.sso.PermissionSetProps.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

A user friendly description providing details about the permission set.

---

##### `inlinePolicies`<sup>Optional</sup> <a name="inlinePolicies" id="cdk-extensions.sso.PermissionSetProps.property.inlinePolicies"></a>

```typescript
public readonly inlinePolicies: {[ key: string ]: PolicyDocument};
```

- *Type:* {[ key: string ]: aws-cdk-lib.aws_iam.PolicyDocument}

Adds inline policy documents that will be embedded in the permission set.

---

##### `managedPolicies`<sup>Optional</sup> <a name="managedPolicies" id="cdk-extensions.sso.PermissionSetProps.property.managedPolicies"></a>

```typescript
public readonly managedPolicies: IManagedPolicy[];
```

- *Type:* aws-cdk-lib.aws_iam.IManagedPolicy[]

A list of the IAM managed policies that you want to attach to the permission set.

Managed policies specified here must be AWS managed.
To reference custom managed policies use the {@link PermissionSet.addCustomerManagedPolicy}
method.

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.sso.PermissionSetProps.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the permission set.

---

##### `permissionsBoundary`<sup>Optional</sup> <a name="permissionsBoundary" id="cdk-extensions.sso.PermissionSetProps.property.permissionsBoundary"></a>

```typescript
public readonly permissionsBoundary: PermissionsBoundary;
```

- *Type:* cdk-extensions.sso.PermissionsBoundary

Specifies the configuration of the AWS managed or customer managed policy that you want to set as a permissions boundary.

Specify either
CustomerManagedPolicyReference to use the name and path of a customer
managed policy, or ManagedPolicyArn to use the ARN of an AWS managed
policy. A permissions boundary represents the maximum permissions that
any policy can grant your role. For more information, see [Permissions
boundaries](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html) for IAM entities in the AWS Identity and Access Management
User Guide.

---

##### `relayState`<sup>Optional</sup> <a name="relayState" id="cdk-extensions.sso.PermissionSetProps.property.relayState"></a>

```typescript
public readonly relayState: string;
```

- *Type:* string

Used to redirect users within the application during the federation authentication process.

For example, you can redirect users to a
specific page that is most applicable to their job after singing in to
an AWS account.

---

##### `sessionDuration`<sup>Optional</sup> <a name="sessionDuration" id="cdk-extensions.sso.PermissionSetProps.property.sessionDuration"></a>

```typescript
public readonly sessionDuration: Duration;
```

- *Type:* aws-cdk-lib.Duration

The length of time that the application user sessions are valid for.

---

### ProcessorConfigurationOptions <a name="ProcessorConfigurationOptions" id="cdk-extensions.kinesis_firehose.ProcessorConfigurationOptions"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.kinesis_firehose.ProcessorConfigurationOptions.Initializer"></a>

```typescript
import { kinesis_firehose } from 'cdk-extensions'

const processorConfigurationOptions: kinesis_firehose.ProcessorConfigurationOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.kinesis_firehose.ProcessorConfigurationOptions.property.enabled">enabled</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.ProcessorConfigurationOptions.property.processors">processors</a></code> | <code>cdk-extensions.kinesis_firehose.DeliveryStreamProcessor[]</code> | *No description.* |

---

##### `enabled`<sup>Optional</sup> <a name="enabled" id="cdk-extensions.kinesis_firehose.ProcessorConfigurationOptions.property.enabled"></a>

```typescript
public readonly enabled: boolean;
```

- *Type:* boolean

---

##### `processors`<sup>Optional</sup> <a name="processors" id="cdk-extensions.kinesis_firehose.ProcessorConfigurationOptions.property.processors"></a>

```typescript
public readonly processors: DeliveryStreamProcessor[];
```

- *Type:* cdk-extensions.kinesis_firehose.DeliveryStreamProcessor[]

---

### ProcessorConfigurationResult <a name="ProcessorConfigurationResult" id="cdk-extensions.kinesis_firehose.ProcessorConfigurationResult"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.kinesis_firehose.ProcessorConfigurationResult.Initializer"></a>

```typescript
import { kinesis_firehose } from 'cdk-extensions'

const processorConfigurationResult: kinesis_firehose.ProcessorConfigurationResult = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.kinesis_firehose.ProcessorConfigurationResult.property.processors">processors</a></code> | <code>cdk-extensions.kinesis_firehose.DeliveryStreamProcessor[]</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.ProcessorConfigurationResult.property.enabled">enabled</a></code> | <code>boolean</code> | *No description.* |

---

##### `processors`<sup>Required</sup> <a name="processors" id="cdk-extensions.kinesis_firehose.ProcessorConfigurationResult.property.processors"></a>

```typescript
public readonly processors: DeliveryStreamProcessor[];
```

- *Type:* cdk-extensions.kinesis_firehose.DeliveryStreamProcessor[]

---

##### `enabled`<sup>Optional</sup> <a name="enabled" id="cdk-extensions.kinesis_firehose.ProcessorConfigurationResult.property.enabled"></a>

```typescript
public readonly enabled: boolean;
```

- *Type:* boolean

---

### PythonShellExecutableProps <a name="PythonShellExecutableProps" id="cdk-extensions.glue.PythonShellExecutableProps"></a>

Props for creating a Python shell job executable.

#### Initializer <a name="Initializer" id="cdk-extensions.glue.PythonShellExecutableProps.Initializer"></a>

```typescript
import { glue } from 'cdk-extensions'

const pythonShellExecutableProps: glue.PythonShellExecutableProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.PythonShellExecutableProps.property.glueVersion">glueVersion</a></code> | <code>cdk-extensions.glue.GlueVersion</code> | Glue version. |
| <code><a href="#cdk-extensions.glue.PythonShellExecutableProps.property.pythonVersion">pythonVersion</a></code> | <code>cdk-extensions.glue.PythonVersion</code> | The Python version to use. |
| <code><a href="#cdk-extensions.glue.PythonShellExecutableProps.property.script">script</a></code> | <code>cdk-extensions.glue.Code</code> | The script that executes a job. |
| <code><a href="#cdk-extensions.glue.PythonShellExecutableProps.property.extraFiles">extraFiles</a></code> | <code>cdk-extensions.glue.Code[]</code> | Additional files, such as configuration files that AWS Glue copies to the working directory of your script before executing it. |
| <code><a href="#cdk-extensions.glue.PythonShellExecutableProps.property.extraPythonFiles">extraPythonFiles</a></code> | <code>cdk-extensions.glue.Code[]</code> | Additional Python files that AWS Glue adds to the Python path before executing your script. |

---

##### `glueVersion`<sup>Required</sup> <a name="glueVersion" id="cdk-extensions.glue.PythonShellExecutableProps.property.glueVersion"></a>

```typescript
public readonly glueVersion: GlueVersion;
```

- *Type:* cdk-extensions.glue.GlueVersion

Glue version.

> [https://docs.aws.amazon.com/glue/latest/dg/release-notes.html](https://docs.aws.amazon.com/glue/latest/dg/release-notes.html)

---

##### `pythonVersion`<sup>Required</sup> <a name="pythonVersion" id="cdk-extensions.glue.PythonShellExecutableProps.property.pythonVersion"></a>

```typescript
public readonly pythonVersion: PythonVersion;
```

- *Type:* cdk-extensions.glue.PythonVersion

The Python version to use.

---

##### `script`<sup>Required</sup> <a name="script" id="cdk-extensions.glue.PythonShellExecutableProps.property.script"></a>

```typescript
public readonly script: Code;
```

- *Type:* cdk-extensions.glue.Code

The script that executes a job.

---

##### `extraFiles`<sup>Optional</sup> <a name="extraFiles" id="cdk-extensions.glue.PythonShellExecutableProps.property.extraFiles"></a>

```typescript
public readonly extraFiles: Code[];
```

- *Type:* cdk-extensions.glue.Code[]
- *Default:* [] - no extra files are copied to the working directory

Additional files, such as configuration files that AWS Glue copies to the working directory of your script before executing it.

Only individual files are supported, directories are not supported.

> [`--extra-files` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html](`--extra-files` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)

---

##### `extraPythonFiles`<sup>Optional</sup> <a name="extraPythonFiles" id="cdk-extensions.glue.PythonShellExecutableProps.property.extraPythonFiles"></a>

```typescript
public readonly extraPythonFiles: Code[];
```

- *Type:* cdk-extensions.glue.Code[]
- *Default:* no extra python files and argument is not set

Additional Python files that AWS Glue adds to the Python path before executing your script.

Only individual files are supported, directories are not supported.

> [`--extra-py-files` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html](`--extra-py-files` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)

---

### PythonSparkJobExecutableProps <a name="PythonSparkJobExecutableProps" id="cdk-extensions.glue.PythonSparkJobExecutableProps"></a>

Props for creating a Python Spark (ETL or Streaming) job executable.

#### Initializer <a name="Initializer" id="cdk-extensions.glue.PythonSparkJobExecutableProps.Initializer"></a>

```typescript
import { glue } from 'cdk-extensions'

const pythonSparkJobExecutableProps: glue.PythonSparkJobExecutableProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.PythonSparkJobExecutableProps.property.glueVersion">glueVersion</a></code> | <code>cdk-extensions.glue.GlueVersion</code> | Glue version. |
| <code><a href="#cdk-extensions.glue.PythonSparkJobExecutableProps.property.pythonVersion">pythonVersion</a></code> | <code>cdk-extensions.glue.PythonVersion</code> | The Python version to use. |
| <code><a href="#cdk-extensions.glue.PythonSparkJobExecutableProps.property.script">script</a></code> | <code>cdk-extensions.glue.Code</code> | The script that executes a job. |
| <code><a href="#cdk-extensions.glue.PythonSparkJobExecutableProps.property.extraFiles">extraFiles</a></code> | <code>cdk-extensions.glue.Code[]</code> | Additional files, such as configuration files that AWS Glue copies to the working directory of your script before executing it. |
| <code><a href="#cdk-extensions.glue.PythonSparkJobExecutableProps.property.extraJars">extraJars</a></code> | <code>cdk-extensions.glue.Code[]</code> | Additional Java .jar files that AWS Glue adds to the Java classpath before executing your script. Only individual files are supported, directories are not supported. |
| <code><a href="#cdk-extensions.glue.PythonSparkJobExecutableProps.property.extraJarsFirst">extraJarsFirst</a></code> | <code>boolean</code> | Setting this value to true prioritizes the customer's extra JAR files in the classpath. |
| <code><a href="#cdk-extensions.glue.PythonSparkJobExecutableProps.property.extraPythonFiles">extraPythonFiles</a></code> | <code>cdk-extensions.glue.Code[]</code> | Additional Python files that AWS Glue adds to the Python path before executing your script. |

---

##### `glueVersion`<sup>Required</sup> <a name="glueVersion" id="cdk-extensions.glue.PythonSparkJobExecutableProps.property.glueVersion"></a>

```typescript
public readonly glueVersion: GlueVersion;
```

- *Type:* cdk-extensions.glue.GlueVersion

Glue version.

> [https://docs.aws.amazon.com/glue/latest/dg/release-notes.html](https://docs.aws.amazon.com/glue/latest/dg/release-notes.html)

---

##### `pythonVersion`<sup>Required</sup> <a name="pythonVersion" id="cdk-extensions.glue.PythonSparkJobExecutableProps.property.pythonVersion"></a>

```typescript
public readonly pythonVersion: PythonVersion;
```

- *Type:* cdk-extensions.glue.PythonVersion

The Python version to use.

---

##### `script`<sup>Required</sup> <a name="script" id="cdk-extensions.glue.PythonSparkJobExecutableProps.property.script"></a>

```typescript
public readonly script: Code;
```

- *Type:* cdk-extensions.glue.Code

The script that executes a job.

---

##### `extraFiles`<sup>Optional</sup> <a name="extraFiles" id="cdk-extensions.glue.PythonSparkJobExecutableProps.property.extraFiles"></a>

```typescript
public readonly extraFiles: Code[];
```

- *Type:* cdk-extensions.glue.Code[]
- *Default:* [] - no extra files are copied to the working directory

Additional files, such as configuration files that AWS Glue copies to the working directory of your script before executing it.

Only individual files are supported, directories are not supported.

> [`--extra-files` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html](`--extra-files` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)

---

##### `extraJars`<sup>Optional</sup> <a name="extraJars" id="cdk-extensions.glue.PythonSparkJobExecutableProps.property.extraJars"></a>

```typescript
public readonly extraJars: Code[];
```

- *Type:* cdk-extensions.glue.Code[]
- *Default:* [] - no extra jars are added to the classpath

Additional Java .jar files that AWS Glue adds to the Java classpath before executing your script. Only individual files are supported, directories are not supported.

> [`--extra-jars` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html](`--extra-jars` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)

---

##### `extraJarsFirst`<sup>Optional</sup> <a name="extraJarsFirst" id="cdk-extensions.glue.PythonSparkJobExecutableProps.property.extraJarsFirst"></a>

```typescript
public readonly extraJarsFirst: boolean;
```

- *Type:* boolean
- *Default:* false - priority is not given to user-provided jars

Setting this value to true prioritizes the customer's extra JAR files in the classpath.

> [`--user-jars-first` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html](`--user-jars-first` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)

---

##### `extraPythonFiles`<sup>Optional</sup> <a name="extraPythonFiles" id="cdk-extensions.glue.PythonSparkJobExecutableProps.property.extraPythonFiles"></a>

```typescript
public readonly extraPythonFiles: Code[];
```

- *Type:* cdk-extensions.glue.Code[]
- *Default:* no extra python files and argument is not set

Additional Python files that AWS Glue adds to the Python path before executing your script.

Only individual files are supported, directories are not supported.

> [`--extra-py-files` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html](`--extra-py-files` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)

---

### RawBucketProps <a name="RawBucketProps" id="cdk-extensions.s3_buckets.RawBucketProps"></a>

Configuration for objects bucket.

#### Initializer <a name="Initializer" id="cdk-extensions.s3_buckets.RawBucketProps.Initializer"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

const rawBucketProps: s3_buckets.RawBucketProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.RawBucketProps.property.accelerateConfiguration">accelerateConfiguration</a></code> | <code>aws-cdk-lib.aws_s3.CfnBucket.AccelerateConfigurationProperty \| aws-cdk-lib.IResolvable</code> | Configures the transfer acceleration state for an Amazon S3 bucket. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucketProps.property.accessControl">accessControl</a></code> | <code>string</code> | A canned access control list (ACL) that grants predefined permissions to the bucket. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucketProps.property.analyticsConfigurations">analyticsConfigurations</a></code> | <code>aws-cdk-lib.IResolvable \| aws-cdk-lib.aws_s3.CfnBucket.AnalyticsConfigurationProperty \| aws-cdk-lib.IResolvable[]</code> | Specifies the configuration and any analyses for the analytics filter of an Amazon S3 bucket. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucketProps.property.bucketEncryption">bucketEncryption</a></code> | <code>aws-cdk-lib.aws_s3.CfnBucket.BucketEncryptionProperty \| aws-cdk-lib.IResolvable</code> | Specifies default encryption for a bucket using server-side encryption with Amazon S3-managed keys (SSE-S3) or AWS KMS-managed keys (SSE-KMS) bucket. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucketProps.property.bucketName">bucketName</a></code> | <code>string</code> | A name for the bucket. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucketProps.property.corsConfiguration">corsConfiguration</a></code> | <code>aws-cdk-lib.aws_s3.CfnBucket.CorsConfigurationProperty \| aws-cdk-lib.IResolvable</code> | Describes the cross-origin access configuration for objects in an Amazon S3 bucket. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucketProps.property.intelligentTieringConfigurations">intelligentTieringConfigurations</a></code> | <code>aws-cdk-lib.IResolvable \| aws-cdk-lib.aws_s3.CfnBucket.IntelligentTieringConfigurationProperty \| aws-cdk-lib.IResolvable[]</code> | Defines how Amazon S3 handles Intelligent-Tiering storage. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucketProps.property.inventoryConfigurations">inventoryConfigurations</a></code> | <code>aws-cdk-lib.IResolvable \| aws-cdk-lib.aws_s3.CfnBucket.InventoryConfigurationProperty \| aws-cdk-lib.IResolvable[]</code> | Specifies the inventory configuration for an Amazon S3 bucket. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucketProps.property.lifecycleConfiguration">lifecycleConfiguration</a></code> | <code>aws-cdk-lib.aws_s3.CfnBucket.LifecycleConfigurationProperty \| aws-cdk-lib.IResolvable</code> | Specifies the lifecycle configuration for objects in an Amazon S3 bucket. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucketProps.property.loggingConfiguration">loggingConfiguration</a></code> | <code>aws-cdk-lib.aws_s3.CfnBucket.LoggingConfigurationProperty \| aws-cdk-lib.IResolvable</code> | Settings that define where logs are stored. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucketProps.property.metricsConfigurations">metricsConfigurations</a></code> | <code>aws-cdk-lib.IResolvable \| aws-cdk-lib.aws_s3.CfnBucket.MetricsConfigurationProperty \| aws-cdk-lib.IResolvable[]</code> | Specifies a metrics configuration for the CloudWatch request metrics (specified by the metrics configuration ID) from an Amazon S3 bucket. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucketProps.property.notificationConfiguration">notificationConfiguration</a></code> | <code>aws-cdk-lib.aws_s3.CfnBucket.NotificationConfigurationProperty \| aws-cdk-lib.IResolvable</code> | Configuration that defines how Amazon S3 handles bucket notifications. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucketProps.property.objectLockConfiguration">objectLockConfiguration</a></code> | <code>aws-cdk-lib.aws_s3.CfnBucket.ObjectLockConfigurationProperty \| aws-cdk-lib.IResolvable</code> | Places an Object Lock configuration on the specified bucket. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucketProps.property.objectLockEnabled">objectLockEnabled</a></code> | <code>boolean \| aws-cdk-lib.IResolvable</code> | Indicates whether this bucket has an Object Lock configuration enabled. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucketProps.property.ownershipControls">ownershipControls</a></code> | <code>aws-cdk-lib.aws_s3.CfnBucket.OwnershipControlsProperty \| aws-cdk-lib.IResolvable</code> | Configuration that defines how Amazon S3 handles Object Ownership rules. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucketProps.property.publicAccessBlockConfiguration">publicAccessBlockConfiguration</a></code> | <code>aws-cdk-lib.aws_s3.CfnBucket.PublicAccessBlockConfigurationProperty \| aws-cdk-lib.IResolvable</code> | Configuration that defines how Amazon S3 handles public access. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucketProps.property.replicationConfiguration">replicationConfiguration</a></code> | <code>aws-cdk-lib.aws_s3.CfnBucket.ReplicationConfigurationProperty \| aws-cdk-lib.IResolvable</code> | Configuration for replicating objects in an S3 bucket. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucketProps.property.tags">tags</a></code> | <code>aws-cdk-lib.CfnTag[]</code> | An arbitrary set of tags (key-value pairs) for this S3 bucket. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucketProps.property.versioningConfiguration">versioningConfiguration</a></code> | <code>aws-cdk-lib.aws_s3.CfnBucket.VersioningConfigurationProperty \| aws-cdk-lib.IResolvable</code> | Enables multiple versions of all objects in this bucket. |
| <code><a href="#cdk-extensions.s3_buckets.RawBucketProps.property.websiteConfiguration">websiteConfiguration</a></code> | <code>aws-cdk-lib.aws_s3.CfnBucket.WebsiteConfigurationProperty \| aws-cdk-lib.IResolvable</code> | Information used to configure the bucket as a static website. |

---

##### `accelerateConfiguration`<sup>Optional</sup> <a name="accelerateConfiguration" id="cdk-extensions.s3_buckets.RawBucketProps.property.accelerateConfiguration"></a>

```typescript
public readonly accelerateConfiguration: AccelerateConfigurationProperty | IResolvable;
```

- *Type:* aws-cdk-lib.aws_s3.CfnBucket.AccelerateConfigurationProperty | aws-cdk-lib.IResolvable

Configures the transfer acceleration state for an Amazon S3 bucket.

For more information, see [Amazon S3 Transfer Acceleration](https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html) in the *Amazon S3 User Guide* .

> [http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-accelerateconfiguration](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-accelerateconfiguration)

---

##### `accessControl`<sup>Optional</sup> <a name="accessControl" id="cdk-extensions.s3_buckets.RawBucketProps.property.accessControl"></a>

```typescript
public readonly accessControl: string;
```

- *Type:* string

A canned access control list (ACL) that grants predefined permissions to the bucket.

For more information about canned ACLs, see [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) in the *Amazon S3 User Guide* .

Be aware that the syntax for this property differs from the information provided in the *Amazon S3 User Guide* . The AccessControl property is case-sensitive and must be one of the following values: Private, PublicRead, PublicReadWrite, AuthenticatedRead, LogDeliveryWrite, BucketOwnerRead, BucketOwnerFullControl, or AwsExecRead.

> [http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-accesscontrol](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-accesscontrol)

---

##### `analyticsConfigurations`<sup>Optional</sup> <a name="analyticsConfigurations" id="cdk-extensions.s3_buckets.RawBucketProps.property.analyticsConfigurations"></a>

```typescript
public readonly analyticsConfigurations: IResolvable | AnalyticsConfigurationProperty | IResolvable[];
```

- *Type:* aws-cdk-lib.IResolvable | aws-cdk-lib.aws_s3.CfnBucket.AnalyticsConfigurationProperty | aws-cdk-lib.IResolvable[]

Specifies the configuration and any analyses for the analytics filter of an Amazon S3 bucket.

> [http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-analyticsconfigurations](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-analyticsconfigurations)

---

##### `bucketEncryption`<sup>Optional</sup> <a name="bucketEncryption" id="cdk-extensions.s3_buckets.RawBucketProps.property.bucketEncryption"></a>

```typescript
public readonly bucketEncryption: BucketEncryptionProperty | IResolvable;
```

- *Type:* aws-cdk-lib.aws_s3.CfnBucket.BucketEncryptionProperty | aws-cdk-lib.IResolvable

Specifies default encryption for a bucket using server-side encryption with Amazon S3-managed keys (SSE-S3) or AWS KMS-managed keys (SSE-KMS) bucket.

For information about the Amazon S3 default encryption feature, see [Amazon S3 Default Encryption for S3 Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html) in the *Amazon S3 User Guide* .

> [http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-bucketencryption](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-bucketencryption)

---

##### `bucketName`<sup>Optional</sup> <a name="bucketName" id="cdk-extensions.s3_buckets.RawBucketProps.property.bucketName"></a>

```typescript
public readonly bucketName: string;
```

- *Type:* string

A name for the bucket.

If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID for the bucket name. The bucket name must contain only lowercase letters, numbers, periods (.), and dashes (-) and must follow [Amazon S3 bucket restrictions and limitations](https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html) . For more information, see [Rules for naming Amazon S3 buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html#bucketnamingrules) in the *Amazon S3 User Guide* .

> If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you need to replace the resource, specify a new name.

> [http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-name](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-name)

---

##### `corsConfiguration`<sup>Optional</sup> <a name="corsConfiguration" id="cdk-extensions.s3_buckets.RawBucketProps.property.corsConfiguration"></a>

```typescript
public readonly corsConfiguration: CorsConfigurationProperty | IResolvable;
```

- *Type:* aws-cdk-lib.aws_s3.CfnBucket.CorsConfigurationProperty | aws-cdk-lib.IResolvable

Describes the cross-origin access configuration for objects in an Amazon S3 bucket.

For more information, see [Enabling Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html) in the *Amazon S3 User Guide* .

> [http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-crossoriginconfig](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-crossoriginconfig)

---

##### `intelligentTieringConfigurations`<sup>Optional</sup> <a name="intelligentTieringConfigurations" id="cdk-extensions.s3_buckets.RawBucketProps.property.intelligentTieringConfigurations"></a>

```typescript
public readonly intelligentTieringConfigurations: IResolvable | IntelligentTieringConfigurationProperty | IResolvable[];
```

- *Type:* aws-cdk-lib.IResolvable | aws-cdk-lib.aws_s3.CfnBucket.IntelligentTieringConfigurationProperty | aws-cdk-lib.IResolvable[]

Defines how Amazon S3 handles Intelligent-Tiering storage.

> [http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-intelligenttieringconfigurations](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-intelligenttieringconfigurations)

---

##### `inventoryConfigurations`<sup>Optional</sup> <a name="inventoryConfigurations" id="cdk-extensions.s3_buckets.RawBucketProps.property.inventoryConfigurations"></a>

```typescript
public readonly inventoryConfigurations: IResolvable | InventoryConfigurationProperty | IResolvable[];
```

- *Type:* aws-cdk-lib.IResolvable | aws-cdk-lib.aws_s3.CfnBucket.InventoryConfigurationProperty | aws-cdk-lib.IResolvable[]

Specifies the inventory configuration for an Amazon S3 bucket.

For more information, see [GET Bucket inventory](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketGETInventoryConfig.html) in the *Amazon S3 API Reference* .

> [http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-inventoryconfigurations](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-inventoryconfigurations)

---

##### `lifecycleConfiguration`<sup>Optional</sup> <a name="lifecycleConfiguration" id="cdk-extensions.s3_buckets.RawBucketProps.property.lifecycleConfiguration"></a>

```typescript
public readonly lifecycleConfiguration: LifecycleConfigurationProperty | IResolvable;
```

- *Type:* aws-cdk-lib.aws_s3.CfnBucket.LifecycleConfigurationProperty | aws-cdk-lib.IResolvable

Specifies the lifecycle configuration for objects in an Amazon S3 bucket.

For more information, see [Object Lifecycle Management](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html) in the *Amazon S3 User Guide* .

> [http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-lifecycleconfig](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-lifecycleconfig)

---

##### `loggingConfiguration`<sup>Optional</sup> <a name="loggingConfiguration" id="cdk-extensions.s3_buckets.RawBucketProps.property.loggingConfiguration"></a>

```typescript
public readonly loggingConfiguration: LoggingConfigurationProperty | IResolvable;
```

- *Type:* aws-cdk-lib.aws_s3.CfnBucket.LoggingConfigurationProperty | aws-cdk-lib.IResolvable

Settings that define where logs are stored.

> [http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-loggingconfig](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-loggingconfig)

---

##### `metricsConfigurations`<sup>Optional</sup> <a name="metricsConfigurations" id="cdk-extensions.s3_buckets.RawBucketProps.property.metricsConfigurations"></a>

```typescript
public readonly metricsConfigurations: IResolvable | MetricsConfigurationProperty | IResolvable[];
```

- *Type:* aws-cdk-lib.IResolvable | aws-cdk-lib.aws_s3.CfnBucket.MetricsConfigurationProperty | aws-cdk-lib.IResolvable[]

Specifies a metrics configuration for the CloudWatch request metrics (specified by the metrics configuration ID) from an Amazon S3 bucket.

If you're updating an existing metrics configuration, note that this is a full replacement of the existing metrics configuration. If you don't include the elements you want to keep, they are erased. For more information, see [PutBucketMetricsConfiguration](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTMetricConfiguration.html) .

> [http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-metricsconfigurations](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-metricsconfigurations)

---

##### `notificationConfiguration`<sup>Optional</sup> <a name="notificationConfiguration" id="cdk-extensions.s3_buckets.RawBucketProps.property.notificationConfiguration"></a>

```typescript
public readonly notificationConfiguration: NotificationConfigurationProperty | IResolvable;
```

- *Type:* aws-cdk-lib.aws_s3.CfnBucket.NotificationConfigurationProperty | aws-cdk-lib.IResolvable

Configuration that defines how Amazon S3 handles bucket notifications.

> [http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-notification](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-notification)

---

##### `objectLockConfiguration`<sup>Optional</sup> <a name="objectLockConfiguration" id="cdk-extensions.s3_buckets.RawBucketProps.property.objectLockConfiguration"></a>

```typescript
public readonly objectLockConfiguration: ObjectLockConfigurationProperty | IResolvable;
```

- *Type:* aws-cdk-lib.aws_s3.CfnBucket.ObjectLockConfigurationProperty | aws-cdk-lib.IResolvable

Places an Object Lock configuration on the specified bucket.

The rule specified in the Object Lock configuration will be applied by default to every new object placed in the specified bucket. For more information, see [Locking Objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html) .

> - The `DefaultRetention` settings require both a mode and a period.
> - The `DefaultRetention` period can be either `Days` or `Years` but you must select one. You cannot specify `Days` and `Years` at the same time.
> - You can only enable Object Lock for new buckets. If you want to turn on Object Lock for an existing bucket, contact AWS Support.

> [http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-objectlockconfiguration](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-objectlockconfiguration)

---

##### `objectLockEnabled`<sup>Optional</sup> <a name="objectLockEnabled" id="cdk-extensions.s3_buckets.RawBucketProps.property.objectLockEnabled"></a>

```typescript
public readonly objectLockEnabled: boolean | IResolvable;
```

- *Type:* boolean | aws-cdk-lib.IResolvable

Indicates whether this bucket has an Object Lock configuration enabled.

Enable `ObjectLockEnabled` when you apply `ObjectLockConfiguration` to a bucket.

> [http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-objectlockenabled](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-objectlockenabled)

---

##### `ownershipControls`<sup>Optional</sup> <a name="ownershipControls" id="cdk-extensions.s3_buckets.RawBucketProps.property.ownershipControls"></a>

```typescript
public readonly ownershipControls: OwnershipControlsProperty | IResolvable;
```

- *Type:* aws-cdk-lib.aws_s3.CfnBucket.OwnershipControlsProperty | aws-cdk-lib.IResolvable

Configuration that defines how Amazon S3 handles Object Ownership rules.

> [http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-ownershipcontrols](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-ownershipcontrols)

---

##### `publicAccessBlockConfiguration`<sup>Optional</sup> <a name="publicAccessBlockConfiguration" id="cdk-extensions.s3_buckets.RawBucketProps.property.publicAccessBlockConfiguration"></a>

```typescript
public readonly publicAccessBlockConfiguration: PublicAccessBlockConfigurationProperty | IResolvable;
```

- *Type:* aws-cdk-lib.aws_s3.CfnBucket.PublicAccessBlockConfigurationProperty | aws-cdk-lib.IResolvable

Configuration that defines how Amazon S3 handles public access.

> [http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-publicaccessblockconfiguration](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-publicaccessblockconfiguration)

---

##### `replicationConfiguration`<sup>Optional</sup> <a name="replicationConfiguration" id="cdk-extensions.s3_buckets.RawBucketProps.property.replicationConfiguration"></a>

```typescript
public readonly replicationConfiguration: ReplicationConfigurationProperty | IResolvable;
```

- *Type:* aws-cdk-lib.aws_s3.CfnBucket.ReplicationConfigurationProperty | aws-cdk-lib.IResolvable

Configuration for replicating objects in an S3 bucket.

To enable replication, you must also enable versioning by using the `VersioningConfiguration` property.

Amazon S3 can store replicated objects in a single destination bucket or multiple destination buckets. The destination bucket or buckets must already exist.

> [http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-replicationconfiguration](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-replicationconfiguration)

---

##### `tags`<sup>Optional</sup> <a name="tags" id="cdk-extensions.s3_buckets.RawBucketProps.property.tags"></a>

```typescript
public readonly tags: CfnTag[];
```

- *Type:* aws-cdk-lib.CfnTag[]

An arbitrary set of tags (key-value pairs) for this S3 bucket.

> [http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-tags](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-tags)

---

##### `versioningConfiguration`<sup>Optional</sup> <a name="versioningConfiguration" id="cdk-extensions.s3_buckets.RawBucketProps.property.versioningConfiguration"></a>

```typescript
public readonly versioningConfiguration: VersioningConfigurationProperty | IResolvable;
```

- *Type:* aws-cdk-lib.aws_s3.CfnBucket.VersioningConfigurationProperty | aws-cdk-lib.IResolvable

Enables multiple versions of all objects in this bucket.

You might enable versioning to prevent objects from being deleted or overwritten by mistake or to archive objects so that you can retrieve previous versions of them.

> [http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-versioning](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-versioning)

---

##### `websiteConfiguration`<sup>Optional</sup> <a name="websiteConfiguration" id="cdk-extensions.s3_buckets.RawBucketProps.property.websiteConfiguration"></a>

```typescript
public readonly websiteConfiguration: WebsiteConfigurationProperty | IResolvable;
```

- *Type:* aws-cdk-lib.aws_s3.CfnBucket.WebsiteConfigurationProperty | aws-cdk-lib.IResolvable

Information used to configure the bucket as a static website.

For more information, see [Hosting Websites on Amazon S3](https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html) .

> [http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-websiteconfiguration](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-websiteconfiguration)

---

### RecordDeaggregationProcessorOptions <a name="RecordDeaggregationProcessorOptions" id="cdk-extensions.kinesis_firehose.RecordDeaggregationProcessorOptions"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.kinesis_firehose.RecordDeaggregationProcessorOptions.Initializer"></a>

```typescript
import { kinesis_firehose } from 'cdk-extensions'

const recordDeaggregationProcessorOptions: kinesis_firehose.RecordDeaggregationProcessorOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.kinesis_firehose.RecordDeaggregationProcessorOptions.property.subRecordType">subRecordType</a></code> | <code>cdk-extensions.kinesis_firehose.SubRecordType</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.RecordDeaggregationProcessorOptions.property.delimiter">delimiter</a></code> | <code>string</code> | *No description.* |

---

##### `subRecordType`<sup>Required</sup> <a name="subRecordType" id="cdk-extensions.kinesis_firehose.RecordDeaggregationProcessorOptions.property.subRecordType"></a>

```typescript
public readonly subRecordType: SubRecordType;
```

- *Type:* cdk-extensions.kinesis_firehose.SubRecordType

---

##### `delimiter`<sup>Optional</sup> <a name="delimiter" id="cdk-extensions.kinesis_firehose.RecordDeaggregationProcessorOptions.property.delimiter"></a>

```typescript
public readonly delimiter: string;
```

- *Type:* string

---

### ReferencedManagedPolicyProps <a name="ReferencedManagedPolicyProps" id="cdk-extensions.sso.ReferencedManagedPolicyProps"></a>

Represents configuration options when creating a managed policy from a class generated when adding a custom policy reference.

#### Initializer <a name="Initializer" id="cdk-extensions.sso.ReferencedManagedPolicyProps.Initializer"></a>

```typescript
import { sso } from 'cdk-extensions'

const referencedManagedPolicyProps: sso.ReferencedManagedPolicyProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.sso.ReferencedManagedPolicyProps.property.description">description</a></code> | <code>string</code> | A friendly description of the policy. |
| <code><a href="#cdk-extensions.sso.ReferencedManagedPolicyProps.property.document">document</a></code> | <code>aws-cdk-lib.aws_iam.PolicyDocument</code> | The policy document that you want to use as the content for the new policy. |
| <code><a href="#cdk-extensions.sso.ReferencedManagedPolicyProps.property.groups">groups</a></code> | <code>aws-cdk-lib.aws_iam.IGroup[]</code> | The groups to attach the policy to. |
| <code><a href="#cdk-extensions.sso.ReferencedManagedPolicyProps.property.roles">roles</a></code> | <code>aws-cdk-lib.aws_iam.IRole[]</code> | The roles to attach the policy to. |
| <code><a href="#cdk-extensions.sso.ReferencedManagedPolicyProps.property.statements">statements</a></code> | <code>aws-cdk-lib.aws_iam.PolicyStatement[]</code> | Initial set of permissions to add to this policy document. |
| <code><a href="#cdk-extensions.sso.ReferencedManagedPolicyProps.property.users">users</a></code> | <code>aws-cdk-lib.aws_iam.IUser[]</code> | The users to attach the policy to. |

---

##### `description`<sup>Optional</sup> <a name="description" id="cdk-extensions.sso.ReferencedManagedPolicyProps.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

A friendly description of the policy.

Typically used to store information about the permissions defined in the
policy. For example, "Grants access to production DynamoDB tables."

The policy description is immutable. After a value is assigned, it
cannot be changed.

---

##### `document`<sup>Optional</sup> <a name="document" id="cdk-extensions.sso.ReferencedManagedPolicyProps.property.document"></a>

```typescript
public readonly document: PolicyDocument;
```

- *Type:* aws-cdk-lib.aws_iam.PolicyDocument

The policy document that you want to use as the content for the new policy.

---

##### `groups`<sup>Optional</sup> <a name="groups" id="cdk-extensions.sso.ReferencedManagedPolicyProps.property.groups"></a>

```typescript
public readonly groups: IGroup[];
```

- *Type:* aws-cdk-lib.aws_iam.IGroup[]

The groups to attach the policy to.

When creating managed policies that will be referenced by IAM identity
center it is possible to associate them with other resources such as
users, groups, and roles. However, this is typically not done as IAM
Identity Center will handle configuring associations in the background.

---

##### `roles`<sup>Optional</sup> <a name="roles" id="cdk-extensions.sso.ReferencedManagedPolicyProps.property.roles"></a>

```typescript
public readonly roles: IRole[];
```

- *Type:* aws-cdk-lib.aws_iam.IRole[]

The roles to attach the policy to.

When creating managed policies that will be referenced by IAM identity
center it is possible to associate them with other resources such as
users, groups, and roles. However, this is typically not done as IAM
Identity Center will handle configuring associations in the background.

---

##### `statements`<sup>Optional</sup> <a name="statements" id="cdk-extensions.sso.ReferencedManagedPolicyProps.property.statements"></a>

```typescript
public readonly statements: PolicyStatement[];
```

- *Type:* aws-cdk-lib.aws_iam.PolicyStatement[]

Initial set of permissions to add to this policy document.

---

##### `users`<sup>Optional</sup> <a name="users" id="cdk-extensions.sso.ReferencedManagedPolicyProps.property.users"></a>

```typescript
public readonly users: IUser[];
```

- *Type:* aws-cdk-lib.aws_iam.IUser[]

The users to attach the policy to.

When creating managed policies that will be referenced by IAM identity
center it is possible to associate them with other resources such as
users, groups, and roles. However, this is typically not done as IAM
Identity Center will handle configuring associations in the background.

---

### ReferenceOptions <a name="ReferenceOptions" id="cdk-extensions.sso.ReferenceOptions"></a>

Configuration options for creating a referenced customer managed policy.

#### Initializer <a name="Initializer" id="cdk-extensions.sso.ReferenceOptions.Initializer"></a>

```typescript
import { sso } from 'cdk-extensions'

const referenceOptions: sso.ReferenceOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.sso.ReferenceOptions.property.name">name</a></code> | <code>string</code> | The name of the customer managed policy. |
| <code><a href="#cdk-extensions.sso.ReferenceOptions.property.path">path</a></code> | <code>string</code> | The path for the policy. |

---

##### `name`<sup>Required</sup> <a name="name" id="cdk-extensions.sso.ReferenceOptions.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the customer managed policy.

---

##### `path`<sup>Optional</sup> <a name="path" id="cdk-extensions.sso.ReferenceOptions.property.path"></a>

```typescript
public readonly path: string;
```

- *Type:* string
- *Default:* '/''

The path for the policy.

For more information about paths, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the IAM User
Guide.

This parameter is optional. If it is not included, it defaults to a slash (/).

This parameter allows a string of characters consisting of either a
forward slash (/) by itself or a string that must begin and end with
forward slashes. In addition, it can contain any ASCII character from
the ! (`\u0021`) through the DEL character (`\u007F`), including most
punctuation characters, digits, and upper and lowercased letters.

---

### ResourceShareProps <a name="ResourceShareProps" id="cdk-extensions.ram.ResourceShareProps"></a>

Configuration for ResourceShare resource.

#### Initializer <a name="Initializer" id="cdk-extensions.ram.ResourceShareProps.Initializer"></a>

```typescript
import { ram } from 'cdk-extensions'

const resourceShareProps: ram.ResourceShareProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.ram.ResourceShareProps.property.account">account</a></code> | <code>string</code> | The AWS account ID this resource belongs to. |
| <code><a href="#cdk-extensions.ram.ResourceShareProps.property.environmentFromArn">environmentFromArn</a></code> | <code>string</code> | ARN to deduce region and account from. |
| <code><a href="#cdk-extensions.ram.ResourceShareProps.property.physicalName">physicalName</a></code> | <code>string</code> | The value passed in by users to the physical name prop of the resource. |
| <code><a href="#cdk-extensions.ram.ResourceShareProps.property.region">region</a></code> | <code>string</code> | The AWS region this resource belongs to. |
| <code><a href="#cdk-extensions.ram.ResourceShareProps.property.allowExternalPrincipals">allowExternalPrincipals</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.ram.ResourceShareProps.property.autoDiscoverAccounts">autoDiscoverAccounts</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.ram.ResourceShareProps.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.ram.ResourceShareProps.property.principals">principals</a></code> | <code>cdk-extensions.ram.ISharedPrincipal[]</code> | *No description.* |
| <code><a href="#cdk-extensions.ram.ResourceShareProps.property.resources">resources</a></code> | <code>cdk-extensions.ram.ISharedResource[]</code> | *No description.* |

---

##### `account`<sup>Optional</sup> <a name="account" id="cdk-extensions.ram.ResourceShareProps.property.account"></a>

```typescript
public readonly account: string;
```

- *Type:* string
- *Default:* the resource is in the same account as the stack it belongs to

The AWS account ID this resource belongs to.

---

##### `environmentFromArn`<sup>Optional</sup> <a name="environmentFromArn" id="cdk-extensions.ram.ResourceShareProps.property.environmentFromArn"></a>

```typescript
public readonly environmentFromArn: string;
```

- *Type:* string
- *Default:* take environment from `account`, `region` parameters, or use Stack environment.

ARN to deduce region and account from.

The ARN is parsed and the account and region are taken from the ARN.
This should be used for imported resources.

Cannot be supplied together with either `account` or `region`.

---

##### `physicalName`<sup>Optional</sup> <a name="physicalName" id="cdk-extensions.ram.ResourceShareProps.property.physicalName"></a>

```typescript
public readonly physicalName: string;
```

- *Type:* string
- *Default:* The physical name will be allocated by CloudFormation at deployment time

The value passed in by users to the physical name prop of the resource.

`undefined` implies that a physical name will be allocated by
   CloudFormation during deployment.
- a concrete value implies a specific physical name
- `PhysicalName.GENERATE_IF_NEEDED` is a marker that indicates that a physical will only be generated
   by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.

---

##### `region`<sup>Optional</sup> <a name="region" id="cdk-extensions.ram.ResourceShareProps.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string
- *Default:* the resource is in the same region as the stack it belongs to

The AWS region this resource belongs to.

---

##### `allowExternalPrincipals`<sup>Optional</sup> <a name="allowExternalPrincipals" id="cdk-extensions.ram.ResourceShareProps.property.allowExternalPrincipals"></a>

```typescript
public readonly allowExternalPrincipals: boolean;
```

- *Type:* boolean

---

##### `autoDiscoverAccounts`<sup>Optional</sup> <a name="autoDiscoverAccounts" id="cdk-extensions.ram.ResourceShareProps.property.autoDiscoverAccounts"></a>

```typescript
public readonly autoDiscoverAccounts: boolean;
```

- *Type:* boolean

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.ram.ResourceShareProps.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `principals`<sup>Optional</sup> <a name="principals" id="cdk-extensions.ram.ResourceShareProps.property.principals"></a>

```typescript
public readonly principals: ISharedPrincipal[];
```

- *Type:* cdk-extensions.ram.ISharedPrincipal[]

---

##### `resources`<sup>Optional</sup> <a name="resources" id="cdk-extensions.ram.ResourceShareProps.property.resources"></a>

```typescript
public readonly resources: ISharedResource[];
```

- *Type:* cdk-extensions.ram.ISharedResource[]

---

### S3AccessLogsBucketProps <a name="S3AccessLogsBucketProps" id="cdk-extensions.s3_buckets.S3AccessLogsBucketProps"></a>

Configuration for objects bucket.

#### Initializer <a name="Initializer" id="cdk-extensions.s3_buckets.S3AccessLogsBucketProps.Initializer"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

const s3AccessLogsBucketProps: s3_buckets.S3AccessLogsBucketProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucketProps.property.account">account</a></code> | <code>string</code> | The AWS account ID this resource belongs to. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucketProps.property.environmentFromArn">environmentFromArn</a></code> | <code>string</code> | ARN to deduce region and account from. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucketProps.property.physicalName">physicalName</a></code> | <code>string</code> | The value passed in by users to the physical name prop of the resource. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucketProps.property.region">region</a></code> | <code>string</code> | The AWS region this resource belongs to. |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucketProps.property.bucketName">bucketName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucketProps.property.createQueries">createQueries</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucketProps.property.database">database</a></code> | <code>cdk-extensions.glue.Database</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucketProps.property.friendlyQueryNames">friendlyQueryNames</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.S3AccessLogsBucketProps.property.tableName">tableName</a></code> | <code>string</code> | *No description.* |

---

##### `account`<sup>Optional</sup> <a name="account" id="cdk-extensions.s3_buckets.S3AccessLogsBucketProps.property.account"></a>

```typescript
public readonly account: string;
```

- *Type:* string
- *Default:* the resource is in the same account as the stack it belongs to

The AWS account ID this resource belongs to.

---

##### `environmentFromArn`<sup>Optional</sup> <a name="environmentFromArn" id="cdk-extensions.s3_buckets.S3AccessLogsBucketProps.property.environmentFromArn"></a>

```typescript
public readonly environmentFromArn: string;
```

- *Type:* string
- *Default:* take environment from `account`, `region` parameters, or use Stack environment.

ARN to deduce region and account from.

The ARN is parsed and the account and region are taken from the ARN.
This should be used for imported resources.

Cannot be supplied together with either `account` or `region`.

---

##### `physicalName`<sup>Optional</sup> <a name="physicalName" id="cdk-extensions.s3_buckets.S3AccessLogsBucketProps.property.physicalName"></a>

```typescript
public readonly physicalName: string;
```

- *Type:* string
- *Default:* The physical name will be allocated by CloudFormation at deployment time

The value passed in by users to the physical name prop of the resource.

`undefined` implies that a physical name will be allocated by
   CloudFormation during deployment.
- a concrete value implies a specific physical name
- `PhysicalName.GENERATE_IF_NEEDED` is a marker that indicates that a physical will only be generated
   by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.

---

##### `region`<sup>Optional</sup> <a name="region" id="cdk-extensions.s3_buckets.S3AccessLogsBucketProps.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string
- *Default:* the resource is in the same region as the stack it belongs to

The AWS region this resource belongs to.

---

##### `bucketName`<sup>Optional</sup> <a name="bucketName" id="cdk-extensions.s3_buckets.S3AccessLogsBucketProps.property.bucketName"></a>

```typescript
public readonly bucketName: string;
```

- *Type:* string

---

##### `createQueries`<sup>Optional</sup> <a name="createQueries" id="cdk-extensions.s3_buckets.S3AccessLogsBucketProps.property.createQueries"></a>

```typescript
public readonly createQueries: boolean;
```

- *Type:* boolean

---

##### `database`<sup>Optional</sup> <a name="database" id="cdk-extensions.s3_buckets.S3AccessLogsBucketProps.property.database"></a>

```typescript
public readonly database: Database;
```

- *Type:* cdk-extensions.glue.Database

---

##### `friendlyQueryNames`<sup>Optional</sup> <a name="friendlyQueryNames" id="cdk-extensions.s3_buckets.S3AccessLogsBucketProps.property.friendlyQueryNames"></a>

```typescript
public readonly friendlyQueryNames: boolean;
```

- *Type:* boolean

---

##### `tableName`<sup>Optional</sup> <a name="tableName" id="cdk-extensions.s3_buckets.S3AccessLogsBucketProps.property.tableName"></a>

```typescript
public readonly tableName: string;
```

- *Type:* string

---

### S3AccessLogsTableProps <a name="S3AccessLogsTableProps" id="cdk-extensions.glue_tables.S3AccessLogsTableProps"></a>

Configuration for S3AccessLogsTable.

#### Initializer <a name="Initializer" id="cdk-extensions.glue_tables.S3AccessLogsTableProps.Initializer"></a>

```typescript
import { glue_tables } from 'cdk-extensions'

const s3AccessLogsTableProps: glue_tables.S3AccessLogsTableProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTableProps.property.account">account</a></code> | <code>string</code> | The AWS account ID this resource belongs to. |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTableProps.property.environmentFromArn">environmentFromArn</a></code> | <code>string</code> | ARN to deduce region and account from. |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTableProps.property.physicalName">physicalName</a></code> | <code>string</code> | The value passed in by users to the physical name prop of the resource. |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTableProps.property.region">region</a></code> | <code>string</code> | The AWS region this resource belongs to. |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTableProps.property.bucket">bucket</a></code> | <code>aws-cdk-lib.aws_s3.IBucket</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTableProps.property.database">database</a></code> | <code>cdk-extensions.glue.Database</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTableProps.property.createQueries">createQueries</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTableProps.property.friendlyQueryNames">friendlyQueryNames</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTableProps.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.S3AccessLogsTableProps.property.s3Prefix">s3Prefix</a></code> | <code>string</code> | *No description.* |

---

##### `account`<sup>Optional</sup> <a name="account" id="cdk-extensions.glue_tables.S3AccessLogsTableProps.property.account"></a>

```typescript
public readonly account: string;
```

- *Type:* string
- *Default:* the resource is in the same account as the stack it belongs to

The AWS account ID this resource belongs to.

---

##### `environmentFromArn`<sup>Optional</sup> <a name="environmentFromArn" id="cdk-extensions.glue_tables.S3AccessLogsTableProps.property.environmentFromArn"></a>

```typescript
public readonly environmentFromArn: string;
```

- *Type:* string
- *Default:* take environment from `account`, `region` parameters, or use Stack environment.

ARN to deduce region and account from.

The ARN is parsed and the account and region are taken from the ARN.
This should be used for imported resources.

Cannot be supplied together with either `account` or `region`.

---

##### `physicalName`<sup>Optional</sup> <a name="physicalName" id="cdk-extensions.glue_tables.S3AccessLogsTableProps.property.physicalName"></a>

```typescript
public readonly physicalName: string;
```

- *Type:* string
- *Default:* The physical name will be allocated by CloudFormation at deployment time

The value passed in by users to the physical name prop of the resource.

`undefined` implies that a physical name will be allocated by
   CloudFormation during deployment.
- a concrete value implies a specific physical name
- `PhysicalName.GENERATE_IF_NEEDED` is a marker that indicates that a physical will only be generated
   by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.

---

##### `region`<sup>Optional</sup> <a name="region" id="cdk-extensions.glue_tables.S3AccessLogsTableProps.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string
- *Default:* the resource is in the same region as the stack it belongs to

The AWS region this resource belongs to.

---

##### `bucket`<sup>Required</sup> <a name="bucket" id="cdk-extensions.glue_tables.S3AccessLogsTableProps.property.bucket"></a>

```typescript
public readonly bucket: IBucket;
```

- *Type:* aws-cdk-lib.aws_s3.IBucket

---

##### `database`<sup>Required</sup> <a name="database" id="cdk-extensions.glue_tables.S3AccessLogsTableProps.property.database"></a>

```typescript
public readonly database: Database;
```

- *Type:* cdk-extensions.glue.Database

---

##### `createQueries`<sup>Optional</sup> <a name="createQueries" id="cdk-extensions.glue_tables.S3AccessLogsTableProps.property.createQueries"></a>

```typescript
public readonly createQueries: boolean;
```

- *Type:* boolean

---

##### `friendlyQueryNames`<sup>Optional</sup> <a name="friendlyQueryNames" id="cdk-extensions.glue_tables.S3AccessLogsTableProps.property.friendlyQueryNames"></a>

```typescript
public readonly friendlyQueryNames: boolean;
```

- *Type:* boolean

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.glue_tables.S3AccessLogsTableProps.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `s3Prefix`<sup>Optional</sup> <a name="s3Prefix" id="cdk-extensions.glue_tables.S3AccessLogsTableProps.property.s3Prefix"></a>

```typescript
public readonly s3Prefix: string;
```

- *Type:* string

---

### S3DestinationOptions <a name="S3DestinationOptions" id="cdk-extensions.kinesis_firehose.S3DestinationOptions"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.kinesis_firehose.S3DestinationOptions.Initializer"></a>

```typescript
import { kinesis_firehose } from 'cdk-extensions'

const s3DestinationOptions: kinesis_firehose.S3DestinationOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.kinesis_firehose.S3DestinationOptions.property.buffering">buffering</a></code> | <code>cdk-extensions.kinesis_firehose.BufferingConfiguration</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.S3DestinationOptions.property.cloudwatchLoggingConfiguration">cloudwatchLoggingConfiguration</a></code> | <code>cdk-extensions.kinesis_firehose.CloudWatchLoggingConfiguration</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.S3DestinationOptions.property.compressionFormat">compressionFormat</a></code> | <code>cdk-extensions.kinesis_firehose.S3CompressionFormat</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.S3DestinationOptions.property.encryptionEnabled">encryptionEnabled</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.S3DestinationOptions.property.encryptionKey">encryptionKey</a></code> | <code>aws-cdk-lib.aws_kms.IKey</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.S3DestinationOptions.property.errorOutputPrefix">errorOutputPrefix</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.S3DestinationOptions.property.keyPrefix">keyPrefix</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.kinesis_firehose.S3DestinationOptions.property.role">role</a></code> | <code>aws-cdk-lib.aws_iam.IRole</code> | *No description.* |

---

##### `buffering`<sup>Optional</sup> <a name="buffering" id="cdk-extensions.kinesis_firehose.S3DestinationOptions.property.buffering"></a>

```typescript
public readonly buffering: BufferingConfiguration;
```

- *Type:* cdk-extensions.kinesis_firehose.BufferingConfiguration

---

##### `cloudwatchLoggingConfiguration`<sup>Optional</sup> <a name="cloudwatchLoggingConfiguration" id="cdk-extensions.kinesis_firehose.S3DestinationOptions.property.cloudwatchLoggingConfiguration"></a>

```typescript
public readonly cloudwatchLoggingConfiguration: CloudWatchLoggingConfiguration;
```

- *Type:* cdk-extensions.kinesis_firehose.CloudWatchLoggingConfiguration

---

##### `compressionFormat`<sup>Optional</sup> <a name="compressionFormat" id="cdk-extensions.kinesis_firehose.S3DestinationOptions.property.compressionFormat"></a>

```typescript
public readonly compressionFormat: S3CompressionFormat;
```

- *Type:* cdk-extensions.kinesis_firehose.S3CompressionFormat

---

##### `encryptionEnabled`<sup>Optional</sup> <a name="encryptionEnabled" id="cdk-extensions.kinesis_firehose.S3DestinationOptions.property.encryptionEnabled"></a>

```typescript
public readonly encryptionEnabled: boolean;
```

- *Type:* boolean

---

##### `encryptionKey`<sup>Optional</sup> <a name="encryptionKey" id="cdk-extensions.kinesis_firehose.S3DestinationOptions.property.encryptionKey"></a>

```typescript
public readonly encryptionKey: IKey;
```

- *Type:* aws-cdk-lib.aws_kms.IKey

---

##### `errorOutputPrefix`<sup>Optional</sup> <a name="errorOutputPrefix" id="cdk-extensions.kinesis_firehose.S3DestinationOptions.property.errorOutputPrefix"></a>

```typescript
public readonly errorOutputPrefix: string;
```

- *Type:* string

---

##### `keyPrefix`<sup>Optional</sup> <a name="keyPrefix" id="cdk-extensions.kinesis_firehose.S3DestinationOptions.property.keyPrefix"></a>

```typescript
public readonly keyPrefix: string;
```

- *Type:* string

---

##### `role`<sup>Optional</sup> <a name="role" id="cdk-extensions.kinesis_firehose.S3DestinationOptions.property.role"></a>

```typescript
public readonly role: IRole;
```

- *Type:* aws-cdk-lib.aws_iam.IRole

---

### S3Encryption <a name="S3Encryption" id="cdk-extensions.glue.S3Encryption"></a>

S3 encryption configuration.

#### Initializer <a name="Initializer" id="cdk-extensions.glue.S3Encryption.Initializer"></a>

```typescript
import { glue } from 'cdk-extensions'

const s3Encryption: glue.S3Encryption = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.S3Encryption.property.mode">mode</a></code> | <code>cdk-extensions.glue.S3EncryptionMode</code> | Encryption mode. |
| <code><a href="#cdk-extensions.glue.S3Encryption.property.kmsKey">kmsKey</a></code> | <code>aws-cdk-lib.aws_kms.IKey</code> | The KMS key to be used to encrypt the data. |

---

##### `mode`<sup>Required</sup> <a name="mode" id="cdk-extensions.glue.S3Encryption.property.mode"></a>

```typescript
public readonly mode: S3EncryptionMode;
```

- *Type:* cdk-extensions.glue.S3EncryptionMode

Encryption mode.

---

##### `kmsKey`<sup>Optional</sup> <a name="kmsKey" id="cdk-extensions.glue.S3Encryption.property.kmsKey"></a>

```typescript
public readonly kmsKey: IKey;
```

- *Type:* aws-cdk-lib.aws_kms.IKey
- *Default:* no kms key if mode = S3_MANAGED. A key will be created if one is not provided and mode = KMS.

The KMS key to be used to encrypt the data.

---

### S3TargetOptions <a name="S3TargetOptions" id="cdk-extensions.glue.S3TargetOptions"></a>

Configuration for Crawler S3 target.

#### Initializer <a name="Initializer" id="cdk-extensions.glue.S3TargetOptions.Initializer"></a>

```typescript
import { glue } from 'cdk-extensions'

const s3TargetOptions: glue.S3TargetOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.S3TargetOptions.property.connection">connection</a></code> | <code>cdk-extensions.glue.Connection</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.S3TargetOptions.property.exclusions">exclusions</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.S3TargetOptions.property.keyPrefix">keyPrefix</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.S3TargetOptions.property.sampleSize">sampleSize</a></code> | <code>string</code> | *No description.* |

---

##### `connection`<sup>Optional</sup> <a name="connection" id="cdk-extensions.glue.S3TargetOptions.property.connection"></a>

```typescript
public readonly connection: Connection;
```

- *Type:* cdk-extensions.glue.Connection

---

##### `exclusions`<sup>Optional</sup> <a name="exclusions" id="cdk-extensions.glue.S3TargetOptions.property.exclusions"></a>

```typescript
public readonly exclusions: string[];
```

- *Type:* string[]

---

##### `keyPrefix`<sup>Optional</sup> <a name="keyPrefix" id="cdk-extensions.glue.S3TargetOptions.property.keyPrefix"></a>

```typescript
public readonly keyPrefix: string;
```

- *Type:* string

---

##### `sampleSize`<sup>Optional</sup> <a name="sampleSize" id="cdk-extensions.glue.S3TargetOptions.property.sampleSize"></a>

```typescript
public readonly sampleSize: string;
```

- *Type:* string

---

### ScalaJobExecutableProps <a name="ScalaJobExecutableProps" id="cdk-extensions.glue.ScalaJobExecutableProps"></a>

Props for creating a Scala Spark (ETL or Streaming) job executable.

#### Initializer <a name="Initializer" id="cdk-extensions.glue.ScalaJobExecutableProps.Initializer"></a>

```typescript
import { glue } from 'cdk-extensions'

const scalaJobExecutableProps: glue.ScalaJobExecutableProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.ScalaJobExecutableProps.property.className">className</a></code> | <code>string</code> | The fully qualified Scala class name that serves as the entry point for the job. |
| <code><a href="#cdk-extensions.glue.ScalaJobExecutableProps.property.glueVersion">glueVersion</a></code> | <code>cdk-extensions.glue.GlueVersion</code> | Glue version. |
| <code><a href="#cdk-extensions.glue.ScalaJobExecutableProps.property.script">script</a></code> | <code>cdk-extensions.glue.Code</code> | The script that executes a job. |
| <code><a href="#cdk-extensions.glue.ScalaJobExecutableProps.property.extraFiles">extraFiles</a></code> | <code>cdk-extensions.glue.Code[]</code> | Additional files, such as configuration files that AWS Glue copies to the working directory of your script before executing it. |
| <code><a href="#cdk-extensions.glue.ScalaJobExecutableProps.property.extraJars">extraJars</a></code> | <code>cdk-extensions.glue.Code[]</code> | Additional Java .jar files that AWS Glue adds to the Java classpath before executing your script. Only individual files are supported, directories are not supported. |
| <code><a href="#cdk-extensions.glue.ScalaJobExecutableProps.property.extraJarsFirst">extraJarsFirst</a></code> | <code>boolean</code> | Setting this value to true prioritizes the customer's extra JAR files in the classpath. |

---

##### `className`<sup>Required</sup> <a name="className" id="cdk-extensions.glue.ScalaJobExecutableProps.property.className"></a>

```typescript
public readonly className: string;
```

- *Type:* string

The fully qualified Scala class name that serves as the entry point for the job.

> [`--class` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html](`--class` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)

---

##### `glueVersion`<sup>Required</sup> <a name="glueVersion" id="cdk-extensions.glue.ScalaJobExecutableProps.property.glueVersion"></a>

```typescript
public readonly glueVersion: GlueVersion;
```

- *Type:* cdk-extensions.glue.GlueVersion

Glue version.

> [https://docs.aws.amazon.com/glue/latest/dg/release-notes.html](https://docs.aws.amazon.com/glue/latest/dg/release-notes.html)

---

##### `script`<sup>Required</sup> <a name="script" id="cdk-extensions.glue.ScalaJobExecutableProps.property.script"></a>

```typescript
public readonly script: Code;
```

- *Type:* cdk-extensions.glue.Code

The script that executes a job.

---

##### `extraFiles`<sup>Optional</sup> <a name="extraFiles" id="cdk-extensions.glue.ScalaJobExecutableProps.property.extraFiles"></a>

```typescript
public readonly extraFiles: Code[];
```

- *Type:* cdk-extensions.glue.Code[]
- *Default:* [] - no extra files are copied to the working directory

Additional files, such as configuration files that AWS Glue copies to the working directory of your script before executing it.

Only individual files are supported, directories are not supported.

> [`--extra-files` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html](`--extra-files` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)

---

##### `extraJars`<sup>Optional</sup> <a name="extraJars" id="cdk-extensions.glue.ScalaJobExecutableProps.property.extraJars"></a>

```typescript
public readonly extraJars: Code[];
```

- *Type:* cdk-extensions.glue.Code[]
- *Default:* [] - no extra jars are added to the classpath

Additional Java .jar files that AWS Glue adds to the Java classpath before executing your script. Only individual files are supported, directories are not supported.

> [`--extra-jars` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html](`--extra-jars` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)

---

##### `extraJarsFirst`<sup>Optional</sup> <a name="extraJarsFirst" id="cdk-extensions.glue.ScalaJobExecutableProps.property.extraJarsFirst"></a>

```typescript
public readonly extraJarsFirst: boolean;
```

- *Type:* boolean
- *Default:* false - priority is not given to user-provided jars

Setting this value to true prioritizes the customer's extra JAR files in the classpath.

> [`--user-jars-first` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html](`--user-jars-first` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)

---

### SecurityConfigurationProps <a name="SecurityConfigurationProps" id="cdk-extensions.glue.SecurityConfigurationProps"></a>

Configuration for the Glue SecurityConfiguration resource.

#### Initializer <a name="Initializer" id="cdk-extensions.glue.SecurityConfigurationProps.Initializer"></a>

```typescript
import { glue } from 'cdk-extensions'

const securityConfigurationProps: glue.SecurityConfigurationProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.SecurityConfigurationProps.property.account">account</a></code> | <code>string</code> | The AWS account ID this resource belongs to. |
| <code><a href="#cdk-extensions.glue.SecurityConfigurationProps.property.environmentFromArn">environmentFromArn</a></code> | <code>string</code> | ARN to deduce region and account from. |
| <code><a href="#cdk-extensions.glue.SecurityConfigurationProps.property.physicalName">physicalName</a></code> | <code>string</code> | The value passed in by users to the physical name prop of the resource. |
| <code><a href="#cdk-extensions.glue.SecurityConfigurationProps.property.region">region</a></code> | <code>string</code> | The AWS region this resource belongs to. |
| <code><a href="#cdk-extensions.glue.SecurityConfigurationProps.property.cloudWatchEncryption">cloudWatchEncryption</a></code> | <code>cdk-extensions.glue.CloudWatchEncryption</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.SecurityConfigurationProps.property.jobBookmarksEncryption">jobBookmarksEncryption</a></code> | <code>cdk-extensions.glue.JobBookmarksEncryption</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.SecurityConfigurationProps.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.SecurityConfigurationProps.property.s3Encryption">s3Encryption</a></code> | <code>cdk-extensions.glue.S3Encryption</code> | *No description.* |

---

##### `account`<sup>Optional</sup> <a name="account" id="cdk-extensions.glue.SecurityConfigurationProps.property.account"></a>

```typescript
public readonly account: string;
```

- *Type:* string
- *Default:* the resource is in the same account as the stack it belongs to

The AWS account ID this resource belongs to.

---

##### `environmentFromArn`<sup>Optional</sup> <a name="environmentFromArn" id="cdk-extensions.glue.SecurityConfigurationProps.property.environmentFromArn"></a>

```typescript
public readonly environmentFromArn: string;
```

- *Type:* string
- *Default:* take environment from `account`, `region` parameters, or use Stack environment.

ARN to deduce region and account from.

The ARN is parsed and the account and region are taken from the ARN.
This should be used for imported resources.

Cannot be supplied together with either `account` or `region`.

---

##### `physicalName`<sup>Optional</sup> <a name="physicalName" id="cdk-extensions.glue.SecurityConfigurationProps.property.physicalName"></a>

```typescript
public readonly physicalName: string;
```

- *Type:* string
- *Default:* The physical name will be allocated by CloudFormation at deployment time

The value passed in by users to the physical name prop of the resource.

`undefined` implies that a physical name will be allocated by
   CloudFormation during deployment.
- a concrete value implies a specific physical name
- `PhysicalName.GENERATE_IF_NEEDED` is a marker that indicates that a physical will only be generated
   by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.

---

##### `region`<sup>Optional</sup> <a name="region" id="cdk-extensions.glue.SecurityConfigurationProps.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string
- *Default:* the resource is in the same region as the stack it belongs to

The AWS region this resource belongs to.

---

##### `cloudWatchEncryption`<sup>Optional</sup> <a name="cloudWatchEncryption" id="cdk-extensions.glue.SecurityConfigurationProps.property.cloudWatchEncryption"></a>

```typescript
public readonly cloudWatchEncryption: CloudWatchEncryption;
```

- *Type:* cdk-extensions.glue.CloudWatchEncryption

---

##### `jobBookmarksEncryption`<sup>Optional</sup> <a name="jobBookmarksEncryption" id="cdk-extensions.glue.SecurityConfigurationProps.property.jobBookmarksEncryption"></a>

```typescript
public readonly jobBookmarksEncryption: JobBookmarksEncryption;
```

- *Type:* cdk-extensions.glue.JobBookmarksEncryption

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.glue.SecurityConfigurationProps.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `s3Encryption`<sup>Optional</sup> <a name="s3Encryption" id="cdk-extensions.glue.SecurityConfigurationProps.property.s3Encryption"></a>

```typescript
public readonly s3Encryption: S3Encryption;
```

- *Type:* cdk-extensions.glue.S3Encryption

---

### SesLogsBucketProps <a name="SesLogsBucketProps" id="cdk-extensions.s3_buckets.SesLogsBucketProps"></a>

Configuration for objects bucket.

#### Initializer <a name="Initializer" id="cdk-extensions.s3_buckets.SesLogsBucketProps.Initializer"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

const sesLogsBucketProps: s3_buckets.SesLogsBucketProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucketProps.property.account">account</a></code> | <code>string</code> | The AWS account ID this resource belongs to. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucketProps.property.environmentFromArn">environmentFromArn</a></code> | <code>string</code> | ARN to deduce region and account from. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucketProps.property.physicalName">physicalName</a></code> | <code>string</code> | The value passed in by users to the physical name prop of the resource. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucketProps.property.region">region</a></code> | <code>string</code> | The AWS region this resource belongs to. |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucketProps.property.bucketName">bucketName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucketProps.property.createQueries">createQueries</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucketProps.property.database">database</a></code> | <code>cdk-extensions.glue.Database</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucketProps.property.friendlyQueryNames">friendlyQueryNames</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.SesLogsBucketProps.property.tableName">tableName</a></code> | <code>string</code> | *No description.* |

---

##### `account`<sup>Optional</sup> <a name="account" id="cdk-extensions.s3_buckets.SesLogsBucketProps.property.account"></a>

```typescript
public readonly account: string;
```

- *Type:* string
- *Default:* the resource is in the same account as the stack it belongs to

The AWS account ID this resource belongs to.

---

##### `environmentFromArn`<sup>Optional</sup> <a name="environmentFromArn" id="cdk-extensions.s3_buckets.SesLogsBucketProps.property.environmentFromArn"></a>

```typescript
public readonly environmentFromArn: string;
```

- *Type:* string
- *Default:* take environment from `account`, `region` parameters, or use Stack environment.

ARN to deduce region and account from.

The ARN is parsed and the account and region are taken from the ARN.
This should be used for imported resources.

Cannot be supplied together with either `account` or `region`.

---

##### `physicalName`<sup>Optional</sup> <a name="physicalName" id="cdk-extensions.s3_buckets.SesLogsBucketProps.property.physicalName"></a>

```typescript
public readonly physicalName: string;
```

- *Type:* string
- *Default:* The physical name will be allocated by CloudFormation at deployment time

The value passed in by users to the physical name prop of the resource.

`undefined` implies that a physical name will be allocated by
   CloudFormation during deployment.
- a concrete value implies a specific physical name
- `PhysicalName.GENERATE_IF_NEEDED` is a marker that indicates that a physical will only be generated
   by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.

---

##### `region`<sup>Optional</sup> <a name="region" id="cdk-extensions.s3_buckets.SesLogsBucketProps.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string
- *Default:* the resource is in the same region as the stack it belongs to

The AWS region this resource belongs to.

---

##### `bucketName`<sup>Optional</sup> <a name="bucketName" id="cdk-extensions.s3_buckets.SesLogsBucketProps.property.bucketName"></a>

```typescript
public readonly bucketName: string;
```

- *Type:* string

---

##### `createQueries`<sup>Optional</sup> <a name="createQueries" id="cdk-extensions.s3_buckets.SesLogsBucketProps.property.createQueries"></a>

```typescript
public readonly createQueries: boolean;
```

- *Type:* boolean

---

##### `database`<sup>Optional</sup> <a name="database" id="cdk-extensions.s3_buckets.SesLogsBucketProps.property.database"></a>

```typescript
public readonly database: Database;
```

- *Type:* cdk-extensions.glue.Database

---

##### `friendlyQueryNames`<sup>Optional</sup> <a name="friendlyQueryNames" id="cdk-extensions.s3_buckets.SesLogsBucketProps.property.friendlyQueryNames"></a>

```typescript
public readonly friendlyQueryNames: boolean;
```

- *Type:* boolean

---

##### `tableName`<sup>Optional</sup> <a name="tableName" id="cdk-extensions.s3_buckets.SesLogsBucketProps.property.tableName"></a>

```typescript
public readonly tableName: string;
```

- *Type:* string

---

### SesLogsTableProps <a name="SesLogsTableProps" id="cdk-extensions.glue_tables.SesLogsTableProps"></a>

Configuration for SesLogsTable.

#### Initializer <a name="Initializer" id="cdk-extensions.glue_tables.SesLogsTableProps.Initializer"></a>

```typescript
import { glue_tables } from 'cdk-extensions'

const sesLogsTableProps: glue_tables.SesLogsTableProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTableProps.property.account">account</a></code> | <code>string</code> | The AWS account ID this resource belongs to. |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTableProps.property.environmentFromArn">environmentFromArn</a></code> | <code>string</code> | ARN to deduce region and account from. |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTableProps.property.physicalName">physicalName</a></code> | <code>string</code> | The value passed in by users to the physical name prop of the resource. |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTableProps.property.region">region</a></code> | <code>string</code> | The AWS region this resource belongs to. |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTableProps.property.bucket">bucket</a></code> | <code>aws-cdk-lib.aws_s3.IBucket</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTableProps.property.database">database</a></code> | <code>cdk-extensions.glue.Database</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTableProps.property.createQueries">createQueries</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTableProps.property.friendlyQueryNames">friendlyQueryNames</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTableProps.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.SesLogsTableProps.property.s3Prefix">s3Prefix</a></code> | <code>string</code> | *No description.* |

---

##### `account`<sup>Optional</sup> <a name="account" id="cdk-extensions.glue_tables.SesLogsTableProps.property.account"></a>

```typescript
public readonly account: string;
```

- *Type:* string
- *Default:* the resource is in the same account as the stack it belongs to

The AWS account ID this resource belongs to.

---

##### `environmentFromArn`<sup>Optional</sup> <a name="environmentFromArn" id="cdk-extensions.glue_tables.SesLogsTableProps.property.environmentFromArn"></a>

```typescript
public readonly environmentFromArn: string;
```

- *Type:* string
- *Default:* take environment from `account`, `region` parameters, or use Stack environment.

ARN to deduce region and account from.

The ARN is parsed and the account and region are taken from the ARN.
This should be used for imported resources.

Cannot be supplied together with either `account` or `region`.

---

##### `physicalName`<sup>Optional</sup> <a name="physicalName" id="cdk-extensions.glue_tables.SesLogsTableProps.property.physicalName"></a>

```typescript
public readonly physicalName: string;
```

- *Type:* string
- *Default:* The physical name will be allocated by CloudFormation at deployment time

The value passed in by users to the physical name prop of the resource.

`undefined` implies that a physical name will be allocated by
   CloudFormation during deployment.
- a concrete value implies a specific physical name
- `PhysicalName.GENERATE_IF_NEEDED` is a marker that indicates that a physical will only be generated
   by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.

---

##### `region`<sup>Optional</sup> <a name="region" id="cdk-extensions.glue_tables.SesLogsTableProps.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string
- *Default:* the resource is in the same region as the stack it belongs to

The AWS region this resource belongs to.

---

##### `bucket`<sup>Required</sup> <a name="bucket" id="cdk-extensions.glue_tables.SesLogsTableProps.property.bucket"></a>

```typescript
public readonly bucket: IBucket;
```

- *Type:* aws-cdk-lib.aws_s3.IBucket

---

##### `database`<sup>Required</sup> <a name="database" id="cdk-extensions.glue_tables.SesLogsTableProps.property.database"></a>

```typescript
public readonly database: Database;
```

- *Type:* cdk-extensions.glue.Database

---

##### `createQueries`<sup>Optional</sup> <a name="createQueries" id="cdk-extensions.glue_tables.SesLogsTableProps.property.createQueries"></a>

```typescript
public readonly createQueries: boolean;
```

- *Type:* boolean

---

##### `friendlyQueryNames`<sup>Optional</sup> <a name="friendlyQueryNames" id="cdk-extensions.glue_tables.SesLogsTableProps.property.friendlyQueryNames"></a>

```typescript
public readonly friendlyQueryNames: boolean;
```

- *Type:* boolean

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.glue_tables.SesLogsTableProps.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `s3Prefix`<sup>Optional</sup> <a name="s3Prefix" id="cdk-extensions.glue_tables.SesLogsTableProps.property.s3Prefix"></a>

```typescript
public readonly s3Prefix: string;
```

- *Type:* string

---

### StructColumnProps <a name="StructColumnProps" id="cdk-extensions.glue.StructColumnProps"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.glue.StructColumnProps.Initializer"></a>

```typescript
import { glue } from 'cdk-extensions'

const structColumnProps: glue.StructColumnProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.StructColumnProps.property.comment">comment</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.StructColumnProps.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.StructColumnProps.property.data">data</a></code> | <code>cdk-extensions.glue.Column[]</code> | *No description.* |

---

##### `comment`<sup>Optional</sup> <a name="comment" id="cdk-extensions.glue.StructColumnProps.property.comment"></a>

```typescript
public readonly comment: string;
```

- *Type:* string

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.glue.StructColumnProps.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `data`<sup>Optional</sup> <a name="data" id="cdk-extensions.glue.StructColumnProps.property.data"></a>

```typescript
public readonly data: Column[];
```

- *Type:* cdk-extensions.glue.Column[]

---

### TableProps <a name="TableProps" id="cdk-extensions.glue.TableProps"></a>

Configuration for Table.

#### Initializer <a name="Initializer" id="cdk-extensions.glue.TableProps.Initializer"></a>

```typescript
import { glue } from 'cdk-extensions'

const tableProps: glue.TableProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.TableProps.property.account">account</a></code> | <code>string</code> | The AWS account ID this resource belongs to. |
| <code><a href="#cdk-extensions.glue.TableProps.property.environmentFromArn">environmentFromArn</a></code> | <code>string</code> | ARN to deduce region and account from. |
| <code><a href="#cdk-extensions.glue.TableProps.property.physicalName">physicalName</a></code> | <code>string</code> | The value passed in by users to the physical name prop of the resource. |
| <code><a href="#cdk-extensions.glue.TableProps.property.region">region</a></code> | <code>string</code> | The AWS region this resource belongs to. |
| <code><a href="#cdk-extensions.glue.TableProps.property.database">database</a></code> | <code>cdk-extensions.glue.Database</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.TableProps.property.columns">columns</a></code> | <code>cdk-extensions.glue.Column[]</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.TableProps.property.compressed">compressed</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.TableProps.property.dataFormat">dataFormat</a></code> | <code>cdk-extensions.glue.DataFormat</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.TableProps.property.description">description</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.TableProps.property.location">location</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.TableProps.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.TableProps.property.owner">owner</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.TableProps.property.parameters">parameters</a></code> | <code>{[ key: string ]: string}</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.TableProps.property.partitionKeys">partitionKeys</a></code> | <code>cdk-extensions.glue.Column[]</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.TableProps.property.retention">retention</a></code> | <code>aws-cdk-lib.Duration</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.TableProps.property.serdeName">serdeName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.TableProps.property.serdeParameters">serdeParameters</a></code> | <code>{[ key: string ]: string}</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.TableProps.property.storageParameters">storageParameters</a></code> | <code>{[ key: string ]: string}</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.TableProps.property.storedAsSubDirectories">storedAsSubDirectories</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.TableProps.property.tableType">tableType</a></code> | <code>cdk-extensions.glue.TableType</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.TableProps.property.targetTable">targetTable</a></code> | <code>cdk-extensions.glue.Table</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.TableProps.property.viewExpandedText">viewExpandedText</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.TableProps.property.viewOriginalText">viewOriginalText</a></code> | <code>string</code> | *No description.* |

---

##### `account`<sup>Optional</sup> <a name="account" id="cdk-extensions.glue.TableProps.property.account"></a>

```typescript
public readonly account: string;
```

- *Type:* string
- *Default:* the resource is in the same account as the stack it belongs to

The AWS account ID this resource belongs to.

---

##### `environmentFromArn`<sup>Optional</sup> <a name="environmentFromArn" id="cdk-extensions.glue.TableProps.property.environmentFromArn"></a>

```typescript
public readonly environmentFromArn: string;
```

- *Type:* string
- *Default:* take environment from `account`, `region` parameters, or use Stack environment.

ARN to deduce region and account from.

The ARN is parsed and the account and region are taken from the ARN.
This should be used for imported resources.

Cannot be supplied together with either `account` or `region`.

---

##### `physicalName`<sup>Optional</sup> <a name="physicalName" id="cdk-extensions.glue.TableProps.property.physicalName"></a>

```typescript
public readonly physicalName: string;
```

- *Type:* string
- *Default:* The physical name will be allocated by CloudFormation at deployment time

The value passed in by users to the physical name prop of the resource.

`undefined` implies that a physical name will be allocated by
   CloudFormation during deployment.
- a concrete value implies a specific physical name
- `PhysicalName.GENERATE_IF_NEEDED` is a marker that indicates that a physical will only be generated
   by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.

---

##### `region`<sup>Optional</sup> <a name="region" id="cdk-extensions.glue.TableProps.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string
- *Default:* the resource is in the same region as the stack it belongs to

The AWS region this resource belongs to.

---

##### `database`<sup>Required</sup> <a name="database" id="cdk-extensions.glue.TableProps.property.database"></a>

```typescript
public readonly database: Database;
```

- *Type:* cdk-extensions.glue.Database

---

##### `columns`<sup>Optional</sup> <a name="columns" id="cdk-extensions.glue.TableProps.property.columns"></a>

```typescript
public readonly columns: Column[];
```

- *Type:* cdk-extensions.glue.Column[]

---

##### `compressed`<sup>Optional</sup> <a name="compressed" id="cdk-extensions.glue.TableProps.property.compressed"></a>

```typescript
public readonly compressed: boolean;
```

- *Type:* boolean

---

##### `dataFormat`<sup>Optional</sup> <a name="dataFormat" id="cdk-extensions.glue.TableProps.property.dataFormat"></a>

```typescript
public readonly dataFormat: DataFormat;
```

- *Type:* cdk-extensions.glue.DataFormat

---

##### `description`<sup>Optional</sup> <a name="description" id="cdk-extensions.glue.TableProps.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

---

##### `location`<sup>Optional</sup> <a name="location" id="cdk-extensions.glue.TableProps.property.location"></a>

```typescript
public readonly location: string;
```

- *Type:* string

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.glue.TableProps.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `owner`<sup>Optional</sup> <a name="owner" id="cdk-extensions.glue.TableProps.property.owner"></a>

```typescript
public readonly owner: string;
```

- *Type:* string

---

##### `parameters`<sup>Optional</sup> <a name="parameters" id="cdk-extensions.glue.TableProps.property.parameters"></a>

```typescript
public readonly parameters: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: string}

---

##### `partitionKeys`<sup>Optional</sup> <a name="partitionKeys" id="cdk-extensions.glue.TableProps.property.partitionKeys"></a>

```typescript
public readonly partitionKeys: Column[];
```

- *Type:* cdk-extensions.glue.Column[]

---

##### `retention`<sup>Optional</sup> <a name="retention" id="cdk-extensions.glue.TableProps.property.retention"></a>

```typescript
public readonly retention: Duration;
```

- *Type:* aws-cdk-lib.Duration

---

##### `serdeName`<sup>Optional</sup> <a name="serdeName" id="cdk-extensions.glue.TableProps.property.serdeName"></a>

```typescript
public readonly serdeName: string;
```

- *Type:* string

---

##### `serdeParameters`<sup>Optional</sup> <a name="serdeParameters" id="cdk-extensions.glue.TableProps.property.serdeParameters"></a>

```typescript
public readonly serdeParameters: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: string}

---

##### `storageParameters`<sup>Optional</sup> <a name="storageParameters" id="cdk-extensions.glue.TableProps.property.storageParameters"></a>

```typescript
public readonly storageParameters: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: string}

---

##### `storedAsSubDirectories`<sup>Optional</sup> <a name="storedAsSubDirectories" id="cdk-extensions.glue.TableProps.property.storedAsSubDirectories"></a>

```typescript
public readonly storedAsSubDirectories: boolean;
```

- *Type:* boolean

---

##### `tableType`<sup>Optional</sup> <a name="tableType" id="cdk-extensions.glue.TableProps.property.tableType"></a>

```typescript
public readonly tableType: TableType;
```

- *Type:* cdk-extensions.glue.TableType

---

##### `targetTable`<sup>Optional</sup> <a name="targetTable" id="cdk-extensions.glue.TableProps.property.targetTable"></a>

```typescript
public readonly targetTable: Table;
```

- *Type:* cdk-extensions.glue.Table

---

##### `viewExpandedText`<sup>Optional</sup> <a name="viewExpandedText" id="cdk-extensions.glue.TableProps.property.viewExpandedText"></a>

```typescript
public readonly viewExpandedText: string;
```

- *Type:* string

---

##### `viewOriginalText`<sup>Optional</sup> <a name="viewOriginalText" id="cdk-extensions.glue.TableProps.property.viewOriginalText"></a>

```typescript
public readonly viewOriginalText: string;
```

- *Type:* string

---

### TriggerOptions <a name="TriggerOptions" id="cdk-extensions.glue.TriggerOptions"></a>

#### Initializer <a name="Initializer" id="cdk-extensions.glue.TriggerOptions.Initializer"></a>

```typescript
import { glue } from 'cdk-extensions'

const triggerOptions: glue.TriggerOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.TriggerOptions.property.account">account</a></code> | <code>string</code> | The AWS account ID this resource belongs to. |
| <code><a href="#cdk-extensions.glue.TriggerOptions.property.environmentFromArn">environmentFromArn</a></code> | <code>string</code> | ARN to deduce region and account from. |
| <code><a href="#cdk-extensions.glue.TriggerOptions.property.physicalName">physicalName</a></code> | <code>string</code> | The value passed in by users to the physical name prop of the resource. |
| <code><a href="#cdk-extensions.glue.TriggerOptions.property.region">region</a></code> | <code>string</code> | The AWS region this resource belongs to. |
| <code><a href="#cdk-extensions.glue.TriggerOptions.property.type">type</a></code> | <code>cdk-extensions.glue.TriggerType</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.TriggerOptions.property.actions">actions</a></code> | <code>cdk-extensions.glue.ITriggerAction[]</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.TriggerOptions.property.description">description</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.TriggerOptions.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.TriggerOptions.property.predicateConditions">predicateConditions</a></code> | <code>cdk-extensions.glue.ITriggerPredicate[]</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.TriggerOptions.property.predicateOperator">predicateOperator</a></code> | <code>cdk-extensions.glue.PredicateOperator</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.TriggerOptions.property.schedule">schedule</a></code> | <code>aws-cdk-lib.aws_events.Schedule</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.TriggerOptions.property.startOnCreation">startOnCreation</a></code> | <code>boolean</code> | *No description.* |

---

##### `account`<sup>Optional</sup> <a name="account" id="cdk-extensions.glue.TriggerOptions.property.account"></a>

```typescript
public readonly account: string;
```

- *Type:* string
- *Default:* the resource is in the same account as the stack it belongs to

The AWS account ID this resource belongs to.

---

##### `environmentFromArn`<sup>Optional</sup> <a name="environmentFromArn" id="cdk-extensions.glue.TriggerOptions.property.environmentFromArn"></a>

```typescript
public readonly environmentFromArn: string;
```

- *Type:* string
- *Default:* take environment from `account`, `region` parameters, or use Stack environment.

ARN to deduce region and account from.

The ARN is parsed and the account and region are taken from the ARN.
This should be used for imported resources.

Cannot be supplied together with either `account` or `region`.

---

##### `physicalName`<sup>Optional</sup> <a name="physicalName" id="cdk-extensions.glue.TriggerOptions.property.physicalName"></a>

```typescript
public readonly physicalName: string;
```

- *Type:* string
- *Default:* The physical name will be allocated by CloudFormation at deployment time

The value passed in by users to the physical name prop of the resource.

`undefined` implies that a physical name will be allocated by
   CloudFormation during deployment.
- a concrete value implies a specific physical name
- `PhysicalName.GENERATE_IF_NEEDED` is a marker that indicates that a physical will only be generated
   by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.

---

##### `region`<sup>Optional</sup> <a name="region" id="cdk-extensions.glue.TriggerOptions.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string
- *Default:* the resource is in the same region as the stack it belongs to

The AWS region this resource belongs to.

---

##### `type`<sup>Required</sup> <a name="type" id="cdk-extensions.glue.TriggerOptions.property.type"></a>

```typescript
public readonly type: TriggerType;
```

- *Type:* cdk-extensions.glue.TriggerType

---

##### `actions`<sup>Optional</sup> <a name="actions" id="cdk-extensions.glue.TriggerOptions.property.actions"></a>

```typescript
public readonly actions: ITriggerAction[];
```

- *Type:* cdk-extensions.glue.ITriggerAction[]

---

##### `description`<sup>Optional</sup> <a name="description" id="cdk-extensions.glue.TriggerOptions.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.glue.TriggerOptions.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `predicateConditions`<sup>Optional</sup> <a name="predicateConditions" id="cdk-extensions.glue.TriggerOptions.property.predicateConditions"></a>

```typescript
public readonly predicateConditions: ITriggerPredicate[];
```

- *Type:* cdk-extensions.glue.ITriggerPredicate[]

---

##### `predicateOperator`<sup>Optional</sup> <a name="predicateOperator" id="cdk-extensions.glue.TriggerOptions.property.predicateOperator"></a>

```typescript
public readonly predicateOperator: PredicateOperator;
```

- *Type:* cdk-extensions.glue.PredicateOperator

---

##### `schedule`<sup>Optional</sup> <a name="schedule" id="cdk-extensions.glue.TriggerOptions.property.schedule"></a>

```typescript
public readonly schedule: Schedule;
```

- *Type:* aws-cdk-lib.aws_events.Schedule

---

##### `startOnCreation`<sup>Optional</sup> <a name="startOnCreation" id="cdk-extensions.glue.TriggerOptions.property.startOnCreation"></a>

```typescript
public readonly startOnCreation: boolean;
```

- *Type:* boolean

---

### TriggerProps <a name="TriggerProps" id="cdk-extensions.glue.TriggerProps"></a>

Configuration for the Glue Trigger resource.

#### Initializer <a name="Initializer" id="cdk-extensions.glue.TriggerProps.Initializer"></a>

```typescript
import { glue } from 'cdk-extensions'

const triggerProps: glue.TriggerProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue.TriggerProps.property.account">account</a></code> | <code>string</code> | The AWS account ID this resource belongs to. |
| <code><a href="#cdk-extensions.glue.TriggerProps.property.environmentFromArn">environmentFromArn</a></code> | <code>string</code> | ARN to deduce region and account from. |
| <code><a href="#cdk-extensions.glue.TriggerProps.property.physicalName">physicalName</a></code> | <code>string</code> | The value passed in by users to the physical name prop of the resource. |
| <code><a href="#cdk-extensions.glue.TriggerProps.property.region">region</a></code> | <code>string</code> | The AWS region this resource belongs to. |
| <code><a href="#cdk-extensions.glue.TriggerProps.property.type">type</a></code> | <code>cdk-extensions.glue.TriggerType</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.TriggerProps.property.actions">actions</a></code> | <code>cdk-extensions.glue.ITriggerAction[]</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.TriggerProps.property.description">description</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.TriggerProps.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.TriggerProps.property.predicateConditions">predicateConditions</a></code> | <code>cdk-extensions.glue.ITriggerPredicate[]</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.TriggerProps.property.predicateOperator">predicateOperator</a></code> | <code>cdk-extensions.glue.PredicateOperator</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.TriggerProps.property.schedule">schedule</a></code> | <code>aws-cdk-lib.aws_events.Schedule</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.TriggerProps.property.startOnCreation">startOnCreation</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue.TriggerProps.property.workflow">workflow</a></code> | <code>cdk-extensions.glue.Workflow</code> | *No description.* |

---

##### `account`<sup>Optional</sup> <a name="account" id="cdk-extensions.glue.TriggerProps.property.account"></a>

```typescript
public readonly account: string;
```

- *Type:* string
- *Default:* the resource is in the same account as the stack it belongs to

The AWS account ID this resource belongs to.

---

##### `environmentFromArn`<sup>Optional</sup> <a name="environmentFromArn" id="cdk-extensions.glue.TriggerProps.property.environmentFromArn"></a>

```typescript
public readonly environmentFromArn: string;
```

- *Type:* string
- *Default:* take environment from `account`, `region` parameters, or use Stack environment.

ARN to deduce region and account from.

The ARN is parsed and the account and region are taken from the ARN.
This should be used for imported resources.

Cannot be supplied together with either `account` or `region`.

---

##### `physicalName`<sup>Optional</sup> <a name="physicalName" id="cdk-extensions.glue.TriggerProps.property.physicalName"></a>

```typescript
public readonly physicalName: string;
```

- *Type:* string
- *Default:* The physical name will be allocated by CloudFormation at deployment time

The value passed in by users to the physical name prop of the resource.

`undefined` implies that a physical name will be allocated by
   CloudFormation during deployment.
- a concrete value implies a specific physical name
- `PhysicalName.GENERATE_IF_NEEDED` is a marker that indicates that a physical will only be generated
   by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.

---

##### `region`<sup>Optional</sup> <a name="region" id="cdk-extensions.glue.TriggerProps.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string
- *Default:* the resource is in the same region as the stack it belongs to

The AWS region this resource belongs to.

---

##### `type`<sup>Required</sup> <a name="type" id="cdk-extensions.glue.TriggerProps.property.type"></a>

```typescript
public readonly type: TriggerType;
```

- *Type:* cdk-extensions.glue.TriggerType

---

##### `actions`<sup>Optional</sup> <a name="actions" id="cdk-extensions.glue.TriggerProps.property.actions"></a>

```typescript
public readonly actions: ITriggerAction[];
```

- *Type:* cdk-extensions.glue.ITriggerAction[]

---

##### `description`<sup>Optional</sup> <a name="description" id="cdk-extensions.glue.TriggerProps.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.glue.TriggerProps.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `predicateConditions`<sup>Optional</sup> <a name="predicateConditions" id="cdk-extensions.glue.TriggerProps.property.predicateConditions"></a>

```typescript
public readonly predicateConditions: ITriggerPredicate[];
```

- *Type:* cdk-extensions.glue.ITriggerPredicate[]

---

##### `predicateOperator`<sup>Optional</sup> <a name="predicateOperator" id="cdk-extensions.glue.TriggerProps.property.predicateOperator"></a>

```typescript
public readonly predicateOperator: PredicateOperator;
```

- *Type:* cdk-extensions.glue.PredicateOperator

---

##### `schedule`<sup>Optional</sup> <a name="schedule" id="cdk-extensions.glue.TriggerProps.property.schedule"></a>

```typescript
public readonly schedule: Schedule;
```

- *Type:* aws-cdk-lib.aws_events.Schedule

---

##### `startOnCreation`<sup>Optional</sup> <a name="startOnCreation" id="cdk-extensions.glue.TriggerProps.property.startOnCreation"></a>

```typescript
public readonly startOnCreation: boolean;
```

- *Type:* boolean

---

##### `workflow`<sup>Optional</sup> <a name="workflow" id="cdk-extensions.glue.TriggerProps.property.workflow"></a>

```typescript
public readonly workflow: Workflow;
```

- *Type:* cdk-extensions.glue.Workflow

---

### WafLogsBucketProps <a name="WafLogsBucketProps" id="cdk-extensions.s3_buckets.WafLogsBucketProps"></a>

Configuration for objects bucket.

#### Initializer <a name="Initializer" id="cdk-extensions.s3_buckets.WafLogsBucketProps.Initializer"></a>

```typescript
import { s3_buckets } from 'cdk-extensions'

const wafLogsBucketProps: s3_buckets.WafLogsBucketProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucketProps.property.account">account</a></code> | <code>string</code> | The AWS account ID this resource belongs to. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucketProps.property.environmentFromArn">environmentFromArn</a></code> | <code>string</code> | ARN to deduce region and account from. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucketProps.property.physicalName">physicalName</a></code> | <code>string</code> | The value passed in by users to the physical name prop of the resource. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucketProps.property.region">region</a></code> | <code>string</code> | The AWS region this resource belongs to. |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucketProps.property.bucketName">bucketName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucketProps.property.createQueries">createQueries</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucketProps.property.database">database</a></code> | <code>cdk-extensions.glue.Database</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucketProps.property.friendlyQueryNames">friendlyQueryNames</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.s3_buckets.WafLogsBucketProps.property.tableName">tableName</a></code> | <code>string</code> | *No description.* |

---

##### `account`<sup>Optional</sup> <a name="account" id="cdk-extensions.s3_buckets.WafLogsBucketProps.property.account"></a>

```typescript
public readonly account: string;
```

- *Type:* string
- *Default:* the resource is in the same account as the stack it belongs to

The AWS account ID this resource belongs to.

---

##### `environmentFromArn`<sup>Optional</sup> <a name="environmentFromArn" id="cdk-extensions.s3_buckets.WafLogsBucketProps.property.environmentFromArn"></a>

```typescript
public readonly environmentFromArn: string;
```

- *Type:* string
- *Default:* take environment from `account`, `region` parameters, or use Stack environment.

ARN to deduce region and account from.

The ARN is parsed and the account and region are taken from the ARN.
This should be used for imported resources.

Cannot be supplied together with either `account` or `region`.

---

##### `physicalName`<sup>Optional</sup> <a name="physicalName" id="cdk-extensions.s3_buckets.WafLogsBucketProps.property.physicalName"></a>

```typescript
public readonly physicalName: string;
```

- *Type:* string
- *Default:* The physical name will be allocated by CloudFormation at deployment time

The value passed in by users to the physical name prop of the resource.

`undefined` implies that a physical name will be allocated by
   CloudFormation during deployment.
- a concrete value implies a specific physical name
- `PhysicalName.GENERATE_IF_NEEDED` is a marker that indicates that a physical will only be generated
   by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.

---

##### `region`<sup>Optional</sup> <a name="region" id="cdk-extensions.s3_buckets.WafLogsBucketProps.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string
- *Default:* the resource is in the same region as the stack it belongs to

The AWS region this resource belongs to.

---

##### `bucketName`<sup>Optional</sup> <a name="bucketName" id="cdk-extensions.s3_buckets.WafLogsBucketProps.property.bucketName"></a>

```typescript
public readonly bucketName: string;
```

- *Type:* string

---

##### `createQueries`<sup>Optional</sup> <a name="createQueries" id="cdk-extensions.s3_buckets.WafLogsBucketProps.property.createQueries"></a>

```typescript
public readonly createQueries: boolean;
```

- *Type:* boolean

---

##### `database`<sup>Optional</sup> <a name="database" id="cdk-extensions.s3_buckets.WafLogsBucketProps.property.database"></a>

```typescript
public readonly database: Database;
```

- *Type:* cdk-extensions.glue.Database

---

##### `friendlyQueryNames`<sup>Optional</sup> <a name="friendlyQueryNames" id="cdk-extensions.s3_buckets.WafLogsBucketProps.property.friendlyQueryNames"></a>

```typescript
public readonly friendlyQueryNames: boolean;
```

- *Type:* boolean

---

##### `tableName`<sup>Optional</sup> <a name="tableName" id="cdk-extensions.s3_buckets.WafLogsBucketProps.property.tableName"></a>

```typescript
public readonly tableName: string;
```

- *Type:* string

---

### WafLogsTableProps <a name="WafLogsTableProps" id="cdk-extensions.glue_tables.WafLogsTableProps"></a>

Configuration for S3AccessLogsTable.

#### Initializer <a name="Initializer" id="cdk-extensions.glue_tables.WafLogsTableProps.Initializer"></a>

```typescript
import { glue_tables } from 'cdk-extensions'

const wafLogsTableProps: glue_tables.WafLogsTableProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTableProps.property.account">account</a></code> | <code>string</code> | The AWS account ID this resource belongs to. |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTableProps.property.environmentFromArn">environmentFromArn</a></code> | <code>string</code> | ARN to deduce region and account from. |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTableProps.property.physicalName">physicalName</a></code> | <code>string</code> | The value passed in by users to the physical name prop of the resource. |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTableProps.property.region">region</a></code> | <code>string</code> | The AWS region this resource belongs to. |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTableProps.property.bucket">bucket</a></code> | <code>aws-cdk-lib.aws_s3.IBucket</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTableProps.property.database">database</a></code> | <code>cdk-extensions.glue.Database</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTableProps.property.createQueries">createQueries</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTableProps.property.friendlyQueryNames">friendlyQueryNames</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTableProps.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-extensions.glue_tables.WafLogsTableProps.property.s3Prefix">s3Prefix</a></code> | <code>string</code> | *No description.* |

---

##### `account`<sup>Optional</sup> <a name="account" id="cdk-extensions.glue_tables.WafLogsTableProps.property.account"></a>

```typescript
public readonly account: string;
```

- *Type:* string
- *Default:* the resource is in the same account as the stack it belongs to

The AWS account ID this resource belongs to.

---

##### `environmentFromArn`<sup>Optional</sup> <a name="environmentFromArn" id="cdk-extensions.glue_tables.WafLogsTableProps.property.environmentFromArn"></a>

```typescript
public readonly environmentFromArn: string;
```

- *Type:* string
- *Default:* take environment from `account`, `region` parameters, or use Stack environment.

ARN to deduce region and account from.

The ARN is parsed and the account and region are taken from the ARN.
This should be used for imported resources.

Cannot be supplied together with either `account` or `region`.

---

##### `physicalName`<sup>Optional</sup> <a name="physicalName" id="cdk-extensions.glue_tables.WafLogsTableProps.property.physicalName"></a>

```typescript
public readonly physicalName: string;
```

- *Type:* string
- *Default:* The physical name will be allocated by CloudFormation at deployment time

The value passed in by users to the physical name prop of the resource.

`undefined` implies that a physical name will be allocated by
   CloudFormation during deployment.
- a concrete value implies a specific physical name
- `PhysicalName.GENERATE_IF_NEEDED` is a marker that indicates that a physical will only be generated
   by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.

---

##### `region`<sup>Optional</sup> <a name="region" id="cdk-extensions.glue_tables.WafLogsTableProps.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string
- *Default:* the resource is in the same region as the stack it belongs to

The AWS region this resource belongs to.

---

##### `bucket`<sup>Required</sup> <a name="bucket" id="cdk-extensions.glue_tables.WafLogsTableProps.property.bucket"></a>

```typescript
public readonly bucket: IBucket;
```

- *Type:* aws-cdk-lib.aws_s3.IBucket

---

##### `database`<sup>Required</sup> <a name="database" id="cdk-extensions.glue_tables.WafLogsTableProps.property.database"></a>

```typescript
public readonly database: Database;
```

- *Type:* cdk-extensions.glue.Database

---

##### `createQueries`<sup>Optional</sup> <a name="createQueries" id="cdk-extensions.glue_tables.WafLogsTableProps.property.createQueries"></a>

```typescript
public readonly createQueries: boolean;
```

- *Type:* boolean

---

##### `friendlyQueryNames`<sup>Optional</sup> <a name="friendlyQueryNames" id="cdk-extensions.glue_tables.WafLogsTableProps.property.friendlyQueryNames"></a>

```typescript
public readonly friendlyQueryNames: boolean;
```

- *Type:* boolean

---

##### `name`<sup>Optional</sup> <a name="name" id="cdk-extensions.glue_tables.WafLogsTableProps.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `s3Prefix`<sup>Optional</sup> <a name="s3Prefix" id="cdk-extensions.glue_tables.WafLogsTableProps.property.s3Prefix"></a>

```typescript
public readonly s3Prefix: string;
```

- *Type:* string

---

### WorkflowProps <a name="WorkflowProps" id="cdk-extensions.glue.WorkflowProps"></a>

Configuration for the Glue Workflow resource.

#### Initializer <a name="Initializer" id="cdk-extensions.glue.WorkflowProps.Initializer"></a>

```typescript
import { glue } from 'cdk-extensions'

const workflowProps: glue.WorkflowProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-exte