"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FlowLog = exports.FlowLogFormat = exports.FlowLogField = exports.FlowLogDataType = exports.FlowLogAggregationInterval = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
const s3_buckets_1 = require("../s3-buckets");
const flow_log_destination_1 = require("./lib/flow-log-destination");
var FlowLogAggregationInterval;
(function (FlowLogAggregationInterval) {
    /**
       * Flow logs will be written at least every 60 seconds.
       */
    FlowLogAggregationInterval[FlowLogAggregationInterval["ONE_MINUTE"] = 60] = "ONE_MINUTE";
    /**
       * Flow logs will be written at least every ten minutes.
       */
    FlowLogAggregationInterval[FlowLogAggregationInterval["TEN_MINUTES"] = 600] = "TEN_MINUTES";
})(FlowLogAggregationInterval = exports.FlowLogAggregationInterval || (exports.FlowLogAggregationInterval = {}));
var FlowLogDataType;
(function (FlowLogDataType) {
    /**
       * 32 bit signed int.
       */
    FlowLogDataType["INT_32"] = "INT_32";
    /**
       * 64 bit signed int.
       */
    FlowLogDataType["INT_64"] = "INT_64";
    /**
       * UTF-8 encoded character string.
       */
    FlowLogDataType["STRING"] = "STRING";
})(FlowLogDataType = exports.FlowLogDataType || (exports.FlowLogDataType = {}));
class FlowLogField {
    /**
       * Creates a new instance of the FlowLogField class.
       *
       * @param name The name of the Flow Log field, as it should be used when
       * building a format string.
       * @param type The data type of the field as it would appear in Parquet.
       * For information on the type for various files, see documentation on the
       * [available fields](https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-logs-fields).
       */
    constructor(name, type) {
        this.name = name;
        this.type = type;
    }
}
exports.FlowLogField = FlowLogField;
_a = JSII_RTTI_SYMBOL_1;
FlowLogField[_a] = { fqn: "cdk-extensions.ec2.FlowLogField", version: "0.0.12" };
/**
   * The AWS account ID of the owner of the source network interface for
   * which traffic is recorded. If the network interface is created by an
   * AWS service, for example when creating a VPC endpoint or Network Load
   * Balancer, the record might display unknown for this field.
   */
FlowLogField.ACCOUNT_ID = new FlowLogField('account-id', FlowLogDataType.STRING);
/**
   * The action that is associated with the traffic:
   *
   * ACCEPT: The recorded traffic was permitted by the security groups and
   * network ACLs.
   * REJECT: The recorded traffic was not permitted by the security groups
   * or network ACLs.
   */
FlowLogField.ACTION = new FlowLogField('action', FlowLogDataType.STRING);
/**
   * The ID of the Availability Zone that contains the network interface for
   * which traffic is recorded. If the traffic is from a sublocation, the
   * record displays a '-' symbol for this field.
   */
FlowLogField.AZ_ID = new FlowLogField('az-id', FlowLogDataType.STRING);
/**
   * The number of bytes transferred during the flow.
   */
FlowLogField.BYTES = new FlowLogField('bytes', FlowLogDataType.INT_64);
/**
   * The destination address for outgoing traffic, or the IPv4 or IPv6
   * address of the network interface for incoming traffic on the network
   * interface. The IPv4 address of the network interface is always its
   * private IPv4 address.
   *
   * See also:
   * {@link FlowLogField.PKT_DSTADDR | PKT_DSTADDR}
   */
FlowLogField.DSTADDR = new FlowLogField('dstaddr', FlowLogDataType.STRING);
/**
   * The destination port of the traffic.
   */
FlowLogField.DSTPORT = new FlowLogField('dstport', FlowLogDataType.INT_32);
/**
   * The time, in Unix seconds, when the last packet of the flow was
   * received within the aggregation interval. This might be up to 60
   * seconds after the packet was transmitted or received on the network
   * interface.
   */
FlowLogField.END = new FlowLogField('end', FlowLogDataType.INT_64);
/**
   * The direction of the flow with respect to the interface where traffic
   * is captured. The possible values are: ingress | egress.
   */
FlowLogField.FLOW_DIRECTION = new FlowLogField('flow-direction', FlowLogDataType.STRING);
/**
   * The ID of the instance that's associated with network interface for
   * which the traffic is recorded, if the instance is owned by you. Returns
   * a '-' symbol for a requester-managed network interface; for example,
   * the network interface for a NAT gateway.
   *
   * See also:
   * [Request-managed ENI](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/requester-managed-eni.html)
   */
FlowLogField.INSTANCE_ID = new FlowLogField('instance-id', FlowLogDataType.STRING);
/**
   * The ID of the network interface for which the traffic is recorded.
   */
FlowLogField.INTERFACE_ID = new FlowLogField('interface-id', FlowLogDataType.STRING);
/**
   * The logging status of the flow log:
   *
   * OK: Data is logging normally to the chosen destinations.
   * NODATA: There was no network traffic to or from the network interface
   * during the aggregation interval.
   * SKIPDATA — Some flow log records were skipped during the aggregation
   * interval. This might be because of an internal capacity constraint, or
   * an internal error.
   */
FlowLogField.LOG_STATUS = new FlowLogField('log-status', FlowLogDataType.STRING);
/**
   * The number of packets transferred during the flow.
   */
FlowLogField.PACKETS = new FlowLogField('packets', FlowLogDataType.INT_64);
/**
   * The name of the subset of IP address ranges for the pkt-dstaddr field,
   * if the destination IP address is for an AWS service. For a list of
   * possible values, see the {@link FlowLogField.PKT_SRC_AWS_SERVICE | PKT_SRC_AWS_SERVICE} field.
   */
FlowLogField.PKT_DST_AWS_SERVICE = new FlowLogField('pkt-dst-aws-service', FlowLogDataType.STRING);
/**
   * The packet-level (original) destination IP address for the traffic. Use
   * this field with the dstaddr field to distinguish between the IP address
   * of an intermediate layer through which traffic flows, and the final
   * destination IP address of the traffic. For example, when traffic flows
   * through a network interface for a NAT gateway, or where the IP address
   * of a pod in Amazon EKS is different from the IP address of the network
   * interface of the instance node on which the pod is running (for
   * communication within a VPC).
   *
   * See also:
   * [Flow Log Example NAT](https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs-records-examples.html#flow-log-example-nat)
   */
FlowLogField.PKT_DSTADDR = new FlowLogField('pkt-dstaddr', FlowLogDataType.STRING);
/**
   * The name of the subset of IP address ranges for the pkt-srcaddr field,
   * if the source IP address is for an AWS service. The possible values
   * are: AMAZON | AMAZON_APPFLOW | AMAZON_CONNECT | API_GATEWAY |
   * CHIME_MEETINGS | CHIME_VOICECONNECTOR | CLOUD9 | CLOUDFRONT |
   * CODEBUILD | DYNAMODB | EBS | EC2 | EC2_INSTANCE_CONNECT |
   * GLOBALACCELERATOR | KINESIS_VIDEO_STREAMS | ROUTE53 |
   * ROUTE53_HEALTHCHECKS | ROUTE53_HEALTHCHECKS_PUBLISHING |
   * ROUTE53_RESOLVER | S3 | WORKSPACES_GATEWAYS.
   */
FlowLogField.PKT_SRC_AWS_SERVICE = new FlowLogField('pkt-src-aws-service', FlowLogDataType.STRING);
/**
   * The packet-level (original) source IP address of the traffic. Use this
   * field with the srcaddr field to distinguish between the IP address of
   * an intermediate layer through which traffic flows, and the original
   * source IP address of the traffic. For example, when traffic flows
   * through a network interface for a NAT gateway, or where the IP address
   * of a pod in Amazon EKS is different from the IP address of the network
   * interface of the instance node on which the pod is running (for
   * communication within a VPC).
   *
   * See also:
   * [Flow Log Example NAT](https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs-records-examples.html#flow-log-example-nat)
   */
FlowLogField.PKT_SRCADDR = new FlowLogField('pkt-srcaddr', FlowLogDataType.STRING);
/**
   * The IANA protocol number of the traffic.
   *
   * See also:
   * [Assigned Internet Protocol Numbers](http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml).
   */
FlowLogField.PROTOCOL = new FlowLogField('protocol', FlowLogDataType.INT_32);
/**
   * The Region that contains the network interface for which traffic is
   * recorded.
   */
FlowLogField.REGION = new FlowLogField('region', FlowLogDataType.STRING);
/**
   * The source address for incoming traffic, or the IPv4 or IPv6 address of
   * the network interface for outgoing traffic on the network interface.
   * The IPv4 address of the network interface is always its private IPv4
   * address.
   *
   * See also:
   * {@link FlowLogField.PKT_SRCADDR | PKT_SRCADDR}
   */
FlowLogField.SRCADDR = new FlowLogField('srcaddr', FlowLogDataType.STRING);
/**
   * The source port of the traffic.
   */
FlowLogField.SRCPORT = new FlowLogField('srcport', FlowLogDataType.INT_32);
/**
   * The time, in Unix seconds, when the first packet of the flow was
   * received within the aggregation interval. This might be up to 60
   * seconds after the packet was transmitted or received on the network
   * interface.
   */
FlowLogField.START = new FlowLogField('start', FlowLogDataType.INT_64);
/**
   * The ID of the sublocation that contains the network interface for which
   * traffic is recorded. If the traffic is not from a sublocation, the
   * record displays a '-' symbol for this field.
   */
FlowLogField.SUBLOCATION_ID = new FlowLogField('sublocation-id', FlowLogDataType.STRING);
/**
   * The type of sublocation that's returned in the sublocation-id field.
   * The possible values are: wavelength | outpost | localzone. If the
   * traffic is not from a sublocation, the record displays a '-' symbol
   * for this field.
   *
   * See also:
   * [Wavelength](https://aws.amazon.com/wavelength/)
   * [Outposts](https://docs.aws.amazon.com/outposts/latest/userguide/)
   * [Local Zones](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-local-zones)
   */
FlowLogField.SUBLOCATION_TYPE = new FlowLogField('sublocation-type', FlowLogDataType.STRING);
/**
   * The ID of the subnet that contains the network interface for which the
   * traffic is recorded.
   */
FlowLogField.SUBNET_ID = new FlowLogField('subnet-id', FlowLogDataType.STRING);
/**
   * The bitmask value for the following TCP flags:
   *
   * FIN: 1
   * SYN: 2
   * RST: 4
   * PSH: 8
   * ACK: 16
   * SYN-ACK: 18
   * URG: 32
   *
   * When a flow log entry consists of only ACK packets, the flag value is
   * 0, not 16.
   *
   * TCP flags can be OR-ed during the aggregation interval. For short
   * connections, the flags might be set on the same line in the flow log
   * record, for example, 19 for SYN-ACK and FIN, and 3 for SYN and FIN.
   *
   * See also:
   * [TCP Segment Structure](https://en.wikipedia.org/wiki/Transmission_Control_Protocol#TCP_segment_structure)
   * [TCP Flag Sequence](https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs-records-examples.html#flow-log-example-tcp-flag)
   */
FlowLogField.TCP_FLAGS = new FlowLogField('tcp-flags', FlowLogDataType.INT_32);
/**
   * The path that egress traffic takes to the destination. To determine
   * whether the traffic is egress traffic, check the flow-direction field.
   * The possible values are as follows. If none of the values apply, the
   * field is set to -.
   *
   * 1: Through another resource in the same VPC
   * 2: Through an internet gateway or a gateway VPC endpoint
   * 3: Through a virtual private gateway
   * 4: Through an intra-region VPC peering connection
   * 5: Through an inter-region VPC peering connection
   * 6: Through a local gateway
   * 7: Through a gateway VPC endpoint (Nitro-based instances only)
   * 8: Through an internet gateway (Nitro-based instances only)
   */
FlowLogField.TRAFFIC_PATH = new FlowLogField('traffic-path', FlowLogDataType.INT_32);
/**
   * The type of traffic. The possible values are: IPv4 | IPv6 | EFA.
   *
   * See also:
   * [Elastic Fabric Adapter](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/efa.html)
   */
FlowLogField.TYPE = new FlowLogField('type', FlowLogDataType.STRING);
/**
   * The VPC Flow Logs version. If you use the default format, the version
   * is 2. If you use a custom format, the version is the highest version
   * among the specified fields. For example, if you specify only fields
   * from version 2, the version is 2. If you specify a mixture of fields
   * from versions 2, 3, and 4, the version is 4.
   */
FlowLogField.VERSION = new FlowLogField('version', FlowLogDataType.INT_32);
/**
   * The ID of the VPC that contains the network interface for which the
   * traffic is recorded.
   */
FlowLogField.VPC_ID = new FlowLogField('vpc-id', FlowLogDataType.STRING);
class FlowLogFormat {
    /**
       * Creates a new instance of the FlowLogFormat class.
       *
       * @param fields The fields that should be included in the flow log output.
       */
    constructor(...fields) {
        this.fields = fields;
        this.template = aws_cdk_lib_1.Lazy.uncachedString({
            produce: () => {
                return this.fields.map((x) => {
                    return `\${${x.name}}`;
                }).join(' ');
            },
        });
    }
    /**
       * Adds a new field to the flow log output. New fields are added at the
       * end of a log entry after all the other fields that came before it.
       *
       * @param field The field to add to the FlowLogFormat.
       */
    addField(field) {
        this.fields.push(field);
    }
}
exports.FlowLogFormat = FlowLogFormat;
_b = JSII_RTTI_SYMBOL_1;
FlowLogFormat[_b] = { fqn: "cdk-extensions.ec2.FlowLogFormat", version: "0.0.12" };
/**
   * The basic set of fields included in most flow logs. This is the default
   * format that is used when new flow logs are created without specifying a
   * custom format.
   */
FlowLogFormat.V2 = new FlowLogFormat(FlowLogField.VERSION, FlowLogField.ACCOUNT_ID, FlowLogField.INTERFACE_ID, FlowLogField.SRCADDR, FlowLogField.DSTADDR, FlowLogField.SRCPORT, FlowLogField.DSTPORT, FlowLogField.PROTOCOL, FlowLogField.PACKETS, FlowLogField.BYTES, FlowLogField.START, FlowLogField.END, FlowLogField.ACTION, FlowLogField.LOG_STATUS);
/**
   * Includes all the fields available in V2. Adds fields to help identify
   * AWS resources associated with traffic as well as fields that give
   * greater visibility into protocol specific details.
   */
FlowLogFormat.V3 = new FlowLogFormat(...FlowLogFormat.V2.fields, FlowLogField.VPC_ID, FlowLogField.SUBNET_ID, FlowLogField.INSTANCE_ID, FlowLogField.TCP_FLAGS, FlowLogField.TYPE, FlowLogField.PKT_SRCADDR, FlowLogField.PKT_DSTADDR);
/**
   * Includes all the fields available in V3. Adds fields for identifying
   * the region and availabilty zone associated with flows, as well as
   * details related to extended zones such as Wavelength, Outputs, and
   * Local Zones.
   */
FlowLogFormat.V4 = new FlowLogFormat(...FlowLogFormat.V3.fields, FlowLogField.REGION, FlowLogField.AZ_ID, FlowLogField.SUBLOCATION_TYPE, FlowLogField.SUBLOCATION_ID);
/**
   * Includes all the fields available in V4. Adds fields to help identify
   * related AWS services and improve visibility into packet routing.
   */
FlowLogFormat.V5 = new FlowLogFormat(...FlowLogFormat.V4.fields, FlowLogField.PKT_SRC_AWS_SERVICE, FlowLogField.PKT_DST_AWS_SERVICE, FlowLogField.FLOW_DIRECTION, FlowLogField.TRAFFIC_PATH);
class FlowLog extends aws_cdk_lib_1.Resource {
    /**
       * Creates a new instance of the FlowLog class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope, id, props) {
        super(scope, id);
        this.format = props.format ?? FlowLogFormat.V2;
        this.maxAggregationInterval = props.maxAggregationInterval;
        this.resourceType = props.resourceType;
        this.trafficType = props.trafficType ?? aws_ec2_1.FlowLogTrafficType.ALL;
        this.destination = props.destination ?? flow_log_destination_1.FlowLogDestination.toS3(new s3_buckets_1.FlowLogsBucket(this, 'bucket', {
            format: this.format,
            bucketName: aws_cdk_lib_1.Names.uniqueId(this).toLowerCase(),
        }));
        const resolvedDestination = this.destination.bind(this);
        this.resource = new aws_ec2_1.CfnFlowLog(this, 'Resource', {
            deliverLogsPermissionArn: resolvedDestination.role?.roleArn,
            destinationOptions: resolvedDestination.destinationOptions,
            logDestination: resolvedDestination.s3Path,
            logDestinationType: resolvedDestination.destinationType,
            logFormat: this.format.template,
            logGroupName: resolvedDestination.logGroup?.logGroupName,
            maxAggregationInterval: this.maxAggregationInterval,
            resourceId: this.resourceType.resourceId,
            resourceType: this.resourceType.resourceType,
            trafficType: this.trafficType,
        });
        this.flowLogArn = this.stack.formatArn({
            resource: 'vpc-flow-log',
            resourceName: this.resource.ref,
            service: 'ec2',
        });
        this.flowLogId = this.resource.ref;
    }
}
exports.FlowLog = FlowLog;
_c = JSII_RTTI_SYMBOL_1;
FlowLog[_c] = { fqn: "cdk-extensions.ec2.FlowLog", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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