export declare enum CacheEngineName {
    MEMCACHED = "memcached",
    REDIS = "redis"
}
export declare class CacheEngineFamily {
    static readonly MEMCACHED_1_4: CacheEngineFamily;
    static readonly MEMCACHED_1_5: CacheEngineFamily;
    static readonly MEMCACHED_1_6: CacheEngineFamily;
    static readonly REDIS_2_6: CacheEngineFamily;
    static readonly REDIS_2_8: CacheEngineFamily;
    static readonly REDIS_3_2: CacheEngineFamily;
    static readonly REDIS_4_0: CacheEngineFamily;
    static readonly REDIS_5_0: CacheEngineFamily;
    static readonly REDIS_6_X: CacheEngineFamily;
    static of(name: string): CacheEngineFamily;
    readonly name: string;
    private constructor();
}
export interface CacheEngineOptions {
    readonly engineFamily?: CacheEngineFamily;
}
export declare abstract class CacheEngine {
    abstract readonly defaultPort: number;
    readonly engineFamily: CacheEngineFamily;
    readonly engineName: CacheEngineName;
    readonly engineVersion: string;
    protected constructor(name: CacheEngineName, version: string, options?: CacheEngineOptions);
}
export interface RedisEngineOptions extends CacheEngineOptions {
    readonly transitEncryptionSupported?: boolean;
}
export declare class RedisEngine extends CacheEngine {
    static readonly V_2_6_13: RedisEngine;
    static readonly V_2_8_6: RedisEngine;
    static readonly V_2_8_19: RedisEngine;
    static readonly V_2_8_21: RedisEngine;
    static readonly V_2_8_22: RedisEngine;
    static readonly V_2_8_23: RedisEngine;
    static readonly V_2_8_24: RedisEngine;
    static readonly V_3_2_4: RedisEngine;
    static readonly V_3_2_6: RedisEngine;
    static readonly V_3_2_10: RedisEngine;
    static readonly V_4_0_10: RedisEngine;
    static readonly V_5_0_0: RedisEngine;
    static readonly V_5_0_3: RedisEngine;
    static readonly V_5_0_4: RedisEngine;
    static readonly V_5_0_5: RedisEngine;
    static readonly V_5_0_6: RedisEngine;
    static readonly V_6_0: RedisEngine;
    static readonly V_6_2: RedisEngine;
    static of(version: string, options?: RedisEngineOptions): RedisEngine;
    readonly defaultPort: number;
    readonly transitEncryptionSupported: boolean;
    private constructor();
}
