import { CfnReplicationGroup } from 'aws-cdk-lib/aws-elasticache';
import { ILogGroup } from 'aws-cdk-lib/aws-logs';
import { IConstruct } from 'constructs';
import { IDeliveryStream } from '../../kinesis-firehose/delivery-stream';
export declare enum LogDestinationType {
    CLOUDWATCH = "cloudwatch-logs",
    FIREHOSE = "kinesis-firehose"
}
export interface LogDestinationConfiguration {
    destinationDetails: CfnReplicationGroup.DestinationDetailsProperty;
    destinationType: LogDestinationType;
}
export declare class LogDestination {
    static cloudwatch(logGroup: ILogGroup): LogDestination;
    static firehose(deliveryStream: IDeliveryStream): LogDestination;
    private configuration;
    private constructor();
    bind(_scope: IConstruct): LogDestinationConfiguration;
}
