import { CfnReplicationGroup } from 'aws-cdk-lib/aws-elasticache';
import { IConstruct } from 'constructs';
import { Slot } from './slot';
export interface ShardOptions {
    readonly nodeGroupId?: string;
    readonly primaryAvailabilityZone?: string;
    readonly replicaAvailabilityZones?: string[];
    readonly replicaCount?: number;
    readonly slots?: Slot[];
}
export declare class Shard {
    private readonly _replicaAvailabilityZones;
    private readonly _slots;
    readonly nodeGroupId?: string;
    readonly primaryAvailabilityZone?: string;
    readonly replicaCount?: number;
    get collapsible(): boolean;
    get replicaAvailabilityZones(): string[] | undefined;
    get slots(): Slot[] | undefined;
    constructor(options: ShardOptions);
    addReplicaAvailabilityZone(zone: string): Shard;
    addSlot(slot: Slot): Shard;
    bind(_scope: IConstruct): CfnReplicationGroup.NodeGroupConfigurationProperty;
}
