"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Slot = void 0;
class Slot {
    constructor(start, end) {
        this.end = end;
        this.start = start;
    }
    static keyspace(keyspace) {
        return new Slot(keyspace, keyspace);
    }
    static range(start, end) {
        return new Slot(start, end);
    }
    toString() {
        return this.start === this.end ? `${this.start}` : `${this.start}-${this.end}`;
    }
}
exports.Slot = Slot;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2xvdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9lbGFzdGljYWNoZS9saWIvc2xvdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxNQUFhLElBQUk7SUFhZixZQUFvQixLQUFhLEVBQUUsR0FBVztRQUM1QyxJQUFJLENBQUMsR0FBRyxHQUFHLEdBQUcsQ0FBQztRQUNmLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO0lBQ3JCLENBQUM7SUFmTSxNQUFNLENBQUMsUUFBUSxDQUFDLFFBQWdCO1FBQ3JDLE9BQU8sSUFBSSxJQUFJLENBQUMsUUFBUSxFQUFFLFFBQVEsQ0FBQyxDQUFDO0lBQ3RDLENBQUM7SUFFTSxNQUFNLENBQUMsS0FBSyxDQUFDLEtBQWEsRUFBRSxHQUFXO1FBQzVDLE9BQU8sSUFBSSxJQUFJLENBQUMsS0FBSyxFQUFFLEdBQUcsQ0FBQyxDQUFDO0lBQzlCLENBQUM7SUFXTSxRQUFRO1FBQ2IsT0FBTyxJQUFJLENBQUMsS0FBSyxLQUFLLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLEdBQUcsSUFBSSxDQUFDLEtBQUssRUFBRSxDQUFDLENBQUMsQ0FBQyxHQUFHLElBQUksQ0FBQyxLQUFLLElBQUksSUFBSSxDQUFDLEdBQUcsRUFBRSxDQUFDO0lBQ2pGLENBQUM7Q0FDRjtBQXJCRCxvQkFxQkMiLCJzb3VyY2VzQ29udGVudCI6WyJleHBvcnQgY2xhc3MgU2xvdCB7XG4gIHB1YmxpYyBzdGF0aWMga2V5c3BhY2Uoa2V5c3BhY2U6IG51bWJlcik6IFNsb3Qge1xuICAgIHJldHVybiBuZXcgU2xvdChrZXlzcGFjZSwga2V5c3BhY2UpO1xuICB9XG5cbiAgcHVibGljIHN0YXRpYyByYW5nZShzdGFydDogbnVtYmVyLCBlbmQ6IG51bWJlcik6IFNsb3Qge1xuICAgIHJldHVybiBuZXcgU2xvdChzdGFydCwgZW5kKTtcbiAgfVxuXG5cbiAgcHJpdmF0ZSByZWFkb25seSBlbmQ6IG51bWJlcjtcbiAgcHJpdmF0ZSByZWFkb25seSBzdGFydDogbnVtYmVyO1xuXG4gIHByaXZhdGUgY29uc3RydWN0b3Ioc3RhcnQ6IG51bWJlciwgZW5kOiBudW1iZXIpIHtcbiAgICB0aGlzLmVuZCA9IGVuZDtcbiAgICB0aGlzLnN0YXJ0ID0gc3RhcnQ7XG4gIH1cblxuICBwdWJsaWMgdG9TdHJpbmcoKTogc3RyaW5nIHtcbiAgICByZXR1cm4gdGhpcy5zdGFydCA9PT0gdGhpcy5lbmQgPyBgJHt0aGlzLnN0YXJ0fWAgOiBgJHt0aGlzLnN0YXJ0fS0ke3RoaXMuZW5kfWA7XG4gIH1cbn0iXX0=