"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudfrontLogsTable = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const athena_1 = require("../athena");
const glue_1 = require("../glue");
class CloudfrontLogsTable extends glue_1.Table {
    /**
       * Creates a new instance of the CloudfrontAccessLogsTable class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope, id, props) {
        super(scope, id, {
            columns: [
                new glue_1.BasicColumn({
                    name: 'date',
                    type: 'date',
                }),
                new glue_1.BasicColumn({
                    name: 'time',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'location',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'response_bytes',
                    type: 'bigint',
                }),
                new glue_1.BasicColumn({
                    name: 'request_ip',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'method',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'distribution',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'uri',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'status_code',
                    type: 'int',
                }),
                new glue_1.BasicColumn({
                    name: 'referrer',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'user_agent',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'query_string',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'cookie',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'final_result_type',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'request_id',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'host_header',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'request_protocol',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'request_bytes',
                    type: 'bigint',
                }),
                new glue_1.BasicColumn({
                    name: 'time_taken',
                    type: 'float',
                }),
                new glue_1.BasicColumn({
                    name: 'x_forwarded_for',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'ssl_protocol',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'ssl_cipher',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'initial_result_type',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'http_version',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'fle_status',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'fle_encrypted_fields',
                    type: 'int',
                }),
                new glue_1.BasicColumn({
                    name: 'client_port',
                    type: 'int',
                }),
                new glue_1.BasicColumn({
                    name: 'time_to_first_byte',
                    type: 'float',
                }),
                new glue_1.BasicColumn({
                    name: 'detailed_result_type',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'content_type',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'content_length',
                    type: 'bigint',
                }),
                new glue_1.BasicColumn({
                    name: 'content_range_start',
                    type: 'bigint',
                }),
                new glue_1.BasicColumn({
                    name: 'content_range_end',
                    type: 'bigint',
                }),
            ],
            compressed: false,
            dataFormat: {
                inputFormat: glue_1.InputFormat.TEXT,
                outputFormat: glue_1.OutputFormat.HIVE_IGNORE_KEY_TEXT,
                serializationLibrary: glue_1.SerializationLibrary.LAZY_SIMPLE,
            },
            database: props.database,
            description: 'Table used for querying CloudFront access logs.',
            location: `s3://${props.bucket.bucketName}/${props.s3Prefix ?? ''}`,
            name: props.name,
            owner: 'hadoop',
            parameters: {
                'EXTERNAL': 'TRUE',
                'skip.header.line.count': '2',
            },
            serdeParameters: {
                'field.delim': '\t',
                'serialization.format': '\t',
            },
            storedAsSubDirectories: false,
            tableType: glue_1.TableType.EXTERNAL_TABLE,
        });
        this.createQueries = props.createQueries ?? true;
        this.friendlyQueryNames = props.friendlyQueryNames ?? false;
        if (this.createQueries) {
            this.distributionStatisticsNamedQuery = new athena_1.NamedQuery(this, 'distribution-statistics-named-query', {
                database: this.database,
                description: 'Gets statistics for CloudFront distributions for the last day.',
                name: this.friendlyQueryNames ? 'cloudfront-distribution-statistics' : undefined,
                queryString: [
                    'SELECT distribution,',
                    '    COUNT(*) as requests,',
                    '    SUM(request_bytes) AS bytes_in,',
                    '    SUM(response_bytes) AS bytes_out,',
                    "    (COUNT_IF(initial_result_type = 'Hit') / CAST(COUNT(*) AS double)) * 100 AS hit_rate,",
                    "    (COUNT_IF(final_result_type = 'Error') / CAST(COUNT(*) AS double)) * 100 AS error_rate,",
                    '    COUNT(DISTINCT uri) AS distinct_objects',
                    `FROM ${this.tableName}`,
                    'WHERE FROM_ISO8601_TIMESTAMP(CONCAT(CAST("date" AS varchar), \'T\', time, \'Z\')) >= NOW() - PARSE_DURATION(\'1d\')',
                    'GROUP BY distribution',
                    'ORDER BY distribution ASC LIMIT 100;',
                ].join('\n'),
            });
            this.requestErrorsNamedQuery = new athena_1.NamedQuery(this, 'request-errors-named-query', {
                database: this.database,
                description: 'Gets the 100 most recent requests that resulted in an error from CloudFront.',
                name: this.friendlyQueryNames ? 'cloudfront-request-errors' : undefined,
                queryString: [
                    'SELECT FROM_ISO8601_TIMESTAMP(CONCAT(CAST("date" AS varchar), \'T\', time, \'Z\')) AT TIME ZONE \'UTC\' AS "time",',
                    '    request_ip,',
                    '    status_code,',
                    '    initial_result_type,',
                    '    final_result_type,',
                    '    detailed_result_type AS reason,',
                    '    method,',
                    "    CONCAT(request_protocol, '://', host_header, uri) AS url",
                    `FROM ${this.tableName}`,
                    'WHERE FROM_ISO8601_TIMESTAMP(CONCAT(CAST("date" AS varchar), \'T\', time, \'Z\')) >= NOW() - PARSE_DURATION(\'1d\')',
                    '    AND (',
                    "        initial_result_type IN ('Error', 'LimitExceeded', 'CapacityExceeded')",
                    "        OR final_result_type IN ('Error', 'LimitExceeded', 'CapacityExceeded')",
                    '    )',
                    'ORDER BY "date", time DESC LIMIT 100;',
                ].join('\n'),
            });
            this.topIpsNamedQuery = new athena_1.NamedQuery(this, 'top-ips-named-query', {
                database: this.database,
                description: 'Gets the 100 most active IP addresses by request count.',
                name: this.friendlyQueryNames ? 'cloudfront-top-ips' : undefined,
                queryString: [
                    'SELECT request_ip,',
                    '    COUNT(*) as requests,',
                    "    COUNT_IF(final_result_type = 'Error') AS errors,",
                    "    COUNT_IF(initial_result_type = 'Hit') AS hits,",
                    "    COUNT_IF(initial_result_type = 'Miss') AS misses,",
                    "    COUNT_IF(initial_result_type = 'RefreshHit') AS refreshes,",
                    "    (COUNT_IF(initial_result_type = 'Hit') / CAST(COUNT(*) AS double)) * 100 AS hit_rate,",
                    '    SUM(request_bytes) AS bytes_in,',
                    '    SUM(response_bytes) AS bytes_out,',
                    '    ARBITRARY(user_agent) as user_agent',
                    `FROM ${this.tableName}`,
                    'WHERE FROM_ISO8601_TIMESTAMP(CONCAT(CAST("date" AS varchar), \'T\', time, \'Z\')) >= NOW() - PARSE_DURATION(\'1d\')',
                    'GROUP BY request_ip',
                    'ORDER BY requests DESC LIMIT 100;',
                ].join('\n'),
            });
            this.topObjectsNamedQuery = new athena_1.NamedQuery(this, 'top-objects-named-query', {
                database: this.database,
                description: 'Gets the 100 most requested CloudFront objects.',
                name: this.friendlyQueryNames ? 'cloudfront-top-objects' : undefined,
                queryString: [
                    "SELECT CONCAT(request_protocol, '://', distribution, uri) AS object,",
                    '    COUNT(*) as requests,',
                    "    COUNT_IF(final_result_type = 'Error') AS errors,",
                    "    COUNT_IF(initial_result_type = 'Hit') AS hits,",
                    "    COUNT_IF(initial_result_type = 'Miss') AS misses,",
                    "    COUNT_IF(initial_result_type = 'RefreshHit') AS refreshes,",
                    "    (COUNT_IF(initial_result_type = 'Hit') / CAST(COUNT(*) AS double)) * 100 AS hit_rate,",
                    '    SUM(request_bytes) AS request_bytes,',
                    '    SUM(response_bytes) AS response_bytes,',
                    '    COUNT(DISTINCT request_ip) AS distinct_ips',
                    `FROM ${this.tableName}`,
                    'WHERE FROM_ISO8601_TIMESTAMP(CONCAT(CAST("date" AS varchar), \'T\', time, \'Z\')) >= NOW() - PARSE_DURATION(\'1d\')',
                    "GROUP BY CONCAT(request_protocol, '://', distribution, uri)",
                    'ORDER BY requests DESC LIMIT 100;',
                ].join('\n'),
            });
        }
    }
}
exports.CloudfrontLogsTable = CloudfrontLogsTable;
_a = JSII_RTTI_SYMBOL_1;
CloudfrontLogsTable[_a] = { fqn: "cdk-extensions.glue_tables.CloudfrontLogsTable", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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