"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Crawler = exports.UpdateBehavior = exports.TableUpdateBehavior = exports.TableGroupingPolicy = exports.RecrawlBehavior = exports.PartitionUpdateBehavior = exports.DeleteBehavior = exports.ConfigurationVersion = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_glue_1 = require("aws-cdk-lib/aws-glue");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const formatting_1 = require("../utils/formatting");
var ConfigurationVersion;
(function (ConfigurationVersion) {
    ConfigurationVersion[ConfigurationVersion["V1_0"] = 1] = "V1_0";
})(ConfigurationVersion = exports.ConfigurationVersion || (exports.ConfigurationVersion = {}));
var DeleteBehavior;
(function (DeleteBehavior) {
    DeleteBehavior["DELETE_FROM_DATABASE"] = "DELETE_FROM_DATABASE";
    DeleteBehavior["DEPRECATE_IN_DATABASE"] = "DEPRECATE_IN_DATABASE";
    DeleteBehavior["LOG"] = "LOG";
})(DeleteBehavior = exports.DeleteBehavior || (exports.DeleteBehavior = {}));
var PartitionUpdateBehavior;
(function (PartitionUpdateBehavior) {
    PartitionUpdateBehavior["INHERIT_FROM_TABLE"] = "InheritFromTable";
})(PartitionUpdateBehavior = exports.PartitionUpdateBehavior || (exports.PartitionUpdateBehavior = {}));
var RecrawlBehavior;
(function (RecrawlBehavior) {
    RecrawlBehavior["EVENT_MODE"] = "CRAWL_EVENT_MODE";
    RecrawlBehavior["EVERYTHING"] = "CRAWL_EVERYTHING";
    RecrawlBehavior["NEW_FOLDERS_ONLY"] = "CRAWL_NEW_FOLDERS_ONLY";
})(RecrawlBehavior = exports.RecrawlBehavior || (exports.RecrawlBehavior = {}));
var TableGroupingPolicy;
(function (TableGroupingPolicy) {
    TableGroupingPolicy["COMBINE_COMPATIBLE_SCHEMAS"] = "CombineCompatibleSchemas";
})(TableGroupingPolicy = exports.TableGroupingPolicy || (exports.TableGroupingPolicy = {}));
var TableUpdateBehavior;
(function (TableUpdateBehavior) {
    TableUpdateBehavior["MERGE_NEW_COLUMNS"] = "MergeNewColumns";
})(TableUpdateBehavior = exports.TableUpdateBehavior || (exports.TableUpdateBehavior = {}));
var UpdateBehavior;
(function (UpdateBehavior) {
    UpdateBehavior["UPDATE_IN_DATABASE"] = "UPDATE_IN_DATABASE";
    UpdateBehavior["LOG"] = "LOG";
})(UpdateBehavior = exports.UpdateBehavior || (exports.UpdateBehavior = {}));
class Crawler extends aws_cdk_lib_1.Resource {
    /**
       * Creates a new instance of the Crawler class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope, id, props) {
        super(scope, id, props);
        // Internal properties
        this._classifiers = [];
        this._targets = [];
        this.configuration = props.configuration;
        this.database = props.database;
        this.deleteBehavior = props.deleteBehavior;
        this.description = props.description;
        this.name = props.name;
        this.recrawlBehavior = props.recrawlBehavior;
        this.scheduleExpression = props.scheduleExpression;
        this.securityConfiguration = props.securityConfiguration;
        this.tablePrefix = props.tablePrefix;
        this.updateBehavior = props.updateBehavior;
        props.targets?.forEach((x) => {
            this.addTarget(x);
        });
        this.role = new aws_iam_1.Role(this, 'role', {
            assumedBy: new aws_iam_1.ServicePrincipal('glue.amazonaws.com'),
            managedPolicies: [
                aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSGlueServiceRole'),
            ],
        });
        this.resource = new aws_glue_1.CfnCrawler(this, 'Resource', {
            classifiers: aws_cdk_lib_1.Lazy.uncachedList({
                produce: () => {
                    return this._classifiers;
                },
            }, {
                omitEmpty: true,
            }),
            configuration: this.renderConfiguration(),
            crawlerSecurityConfiguration: this.securityConfiguration?.securityConfigurationName,
            databaseName: this.database?.databaseName,
            description: this.description,
            name: this.name,
            recrawlPolicy: formatting_1.undefinedIfNoKeys({
                recrawlBehavior: this.recrawlBehavior,
            }),
            role: this.role.roleArn,
            schedule: formatting_1.undefinedIfNoKeys({
                scheduleExpression: this.scheduleExpression?.expressionString,
            }),
            schemaChangePolicy: formatting_1.undefinedIfNoKeys({
                deleteBehavior: this.deleteBehavior,
                updateBehavior: this.updateBehavior,
            }),
            tablePrefix: this.tablePrefix,
            targets: aws_cdk_lib_1.Lazy.uncachedAny({
                produce: () => {
                    return this.renderTargets();
                },
            }),
        });
        this.crawlerArn = this.stack.formatArn({
            resource: 'crawler',
            resourceName: this.resource.ref,
            service: 'glue',
        });
        this.crawlerName = this.resource.ref;
    }
    addClassifier(classifier) {
        this._classifiers.push(classifier);
    }
    addTarget(target) {
        this._targets.push(target);
    }
    renderConfiguration() {
        const configuration = formatting_1.definedFieldsOrUndefined({
            CrawlerOutput: formatting_1.definedFieldsOrUndefined({
                Partitions: formatting_1.definedFieldsOrUndefined({
                    AddOrUpdateBehavior: this.configuration?.partitionUpdateBehavior,
                }),
                Tables: formatting_1.definedFieldsOrUndefined({
                    AddOrUpdateBehavior: this.configuration?.tableUpdateBehavior,
                }),
            }),
            Grouping: formatting_1.definedFieldsOrUndefined({
                TableGroupingPolicy: this.configuration?.tableGroupingPolicy,
                TableLevelConfiguration: this.configuration?.tableLevel,
            }),
        });
        return configuration === undefined ? undefined : this.stack.toJsonString({
            Version: this.configuration?.version ?? ConfigurationVersion.V1_0,
            ...configuration,
        });
    }
    renderTargets() {
        const resolved = this._targets.map((x) => {
            return x.bind(this);
        });
        return formatting_1.undefinedIfNoKeys({
            catalogTargets: formatting_1.flattenedOrUndefined(resolved.map((x) => {
                return x.catalogTargets ?? [];
            })),
            dynamoDbTargets: formatting_1.flattenedOrUndefined(resolved.map((x) => {
                return x.dynamoDbTargets ?? [];
            })),
            jdbcTargets: formatting_1.flattenedOrUndefined(resolved.map((x) => {
                return x.jdbcTargets ?? [];
            })),
            s3Targets: formatting_1.flattenedOrUndefined(resolved.map((x) => {
                return x.s3Targets ?? [];
            })),
        });
    }
}
exports.Crawler = Crawler;
_a = JSII_RTTI_SYMBOL_1;
Crawler[_a] = { fqn: "cdk-extensions.glue.Crawler", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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