import { Resource, ResourceProps } from 'aws-cdk-lib';
import { CfnDatabase } from 'aws-cdk-lib/aws-glue';
import { Construct } from 'constructs';
/**
 * Configuration for Database
 */
export interface DatabaseProps extends ResourceProps {
    readonly description?: string;
    readonly locationUri?: string;
    readonly name?: string;
}
export declare class Database extends Resource {
    readonly description?: string;
    readonly locationUri?: string;
    readonly name: string;
    readonly resource: CfnDatabase;
    readonly catalogArn: string;
    readonly catalogId: string;
    readonly databaseArn: string;
    readonly databaseName: string;
    /**
       * Creates a new instance of the Database class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope: Construct, id: string, props?: DatabaseProps);
}
