import { ResourceProps, SecretValue } from 'aws-cdk-lib';
import { ISecurityGroup, IVpc, SubnetSelection } from 'aws-cdk-lib/aws-ec2';
import { Construct } from 'constructs';
import { Connection } from '.';
/**
 * Configuration for the Glue Workflow resource.
 */
export interface JdbcConnectionProps extends ResourceProps {
    readonly description?: string;
    readonly enforceSsl?: boolean;
    readonly name?: string;
    readonly password: SecretValue;
    readonly securityGroups?: ISecurityGroup[];
    readonly subnets?: SubnetSelection;
    readonly url: string;
    readonly username: string;
    readonly vpc: IVpc;
}
export declare class JdbcConnection extends Connection {
    readonly password: SecretValue;
    readonly url: string;
    readonly username: string;
    constructor(scope: Construct, id: string, props: JdbcConnectionProps);
}
