"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JdbcConnection = void 0;
const _1 = require(".");
class JdbcConnection extends _1.Connection {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            connectionType: _1.ConnectionType.JDBC,
            properties: {
                JDBC_CONNECTION_URL: props.url,
                JDBC_ENFORCE_SSL: `${props.enforceSsl ?? false}`,
                PASSWORD: props.password.toString(),
                USERNAME: props.username,
            },
        });
        this.password = props.password;
        this.url = props.url;
        this.username = props.username;
    }
}
exports.JdbcConnection = JdbcConnection;
//# sourceMappingURL=data:application/json;base64,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