import { Duration, Resource, ResourceProps } from 'aws-cdk-lib';
import { CfnJob } from 'aws-cdk-lib/aws-glue';
import { IRole } from 'aws-cdk-lib/aws-iam';
import { ILogGroup } from 'aws-cdk-lib/aws-logs';
import { Construct } from 'constructs';
import { Connection } from './connection';
import { JobExecutable } from './lib/job-executable';
import { WorkerType } from './lib/worker-type';
import { SecurityConfiguration } from './security-configuration';
export interface ContinuousLoggingProps {
    /**
       * Apply the provided conversion pattern.
       *
       * This is a Log4j Conversion Pattern to customize driver and executor logs.
       *
       * @default `%d{yy/MM/dd HH:mm:ss} %p %c{1}: %m%n`
       */
    readonly conversionPattern?: string;
    /**
       * Enable continouous logging.
       */
    readonly enabled: boolean;
    /**
       * Specify a custom CloudWatch log group name.
       *
       * @default - a log group is created with name `/aws-glue/jobs/logs-v2/`.
       */
    readonly logGroup?: ILogGroup;
    /**
       * Specify a custom CloudWatch log stream prefix.
       *
       * @default - the job run ID.
       */
    readonly logStreamPrefix?: string;
    /**
       * Filter out non-useful Apache Spark driver/executor and Apache Hadoop YARN heartbeat log messages.
       *
       * @default true
       */
    readonly quiet?: boolean;
}
/**
 * Configuration for the Glue Job resource.
 */
export interface JobProps extends ResourceProps {
    readonly allocatedCapacity?: number;
    readonly connections?: Connection[];
    readonly continuousLogging?: ContinuousLoggingProps;
    readonly defaultArguments?: {
        [key: string]: string;
    };
    readonly description?: string;
    readonly enableProfilingMetrics?: boolean;
    readonly executable: JobExecutable;
    readonly maxCapacity?: number;
    readonly maxConcurrentRuns?: number;
    readonly maxRetries?: number;
    readonly name?: string;
    readonly notifyDelayAfter?: Duration;
    readonly role?: IRole;
    readonly securityConfiguration?: SecurityConfiguration;
    readonly timeout?: Duration;
    readonly workerCount?: number;
    readonly workerType?: WorkerType;
}
export declare class Job extends Resource {
    private readonly _arguments;
    private readonly _connections;
    readonly allocatedCapacity?: number;
    readonly connections?: Connection[];
    readonly continuousLogging?: ContinuousLoggingProps;
    readonly description?: string;
    readonly executable: JobExecutable;
    readonly maxCapacity?: number;
    readonly maxConcurrentRuns?: number;
    readonly maxRetries?: number;
    readonly name?: string;
    readonly notifyDelayAfter?: Duration;
    readonly securityConfiguration?: SecurityConfiguration;
    readonly timeout?: Duration;
    readonly workerCount?: number;
    readonly workerType?: WorkerType;
    readonly logGroup?: ILogGroup;
    readonly resource: CfnJob;
    readonly role: IRole;
    readonly jobArn: string;
    readonly jobName: string;
    constructor(scope: Construct, id: string, props: JobProps);
    addArgument(key: string, value: string): void;
    addConnection(connection: Connection): void;
    private buildCodeS3ObjectUrl;
    private configureContinuousLogging;
}
