import { CfnTable } from 'aws-cdk-lib/aws-glue';
import { IConstruct } from 'constructs';
export interface ColumnProps {
    readonly comment?: string;
    readonly name?: string;
}
export declare abstract class Column {
    readonly comment?: string;
    readonly name?: string;
    abstract readonly typeString: string;
    constructor(props: ColumnProps);
    bind(scope: IConstruct): CfnTable.ColumnProperty;
}
export interface ArrayColumnProps extends ColumnProps {
    readonly data: Column;
}
export declare class ArrayColumn extends Column {
    readonly typeString: string;
    constructor(props: ArrayColumnProps);
}
export interface BasicColumnProps extends ColumnProps {
    readonly type: string;
}
export declare class BasicColumn extends Column {
    readonly typeString: string;
    constructor(props: BasicColumnProps);
}
export interface StructColumnProps extends ColumnProps {
    readonly data?: Column[];
}
export declare class StructColumn extends Column {
    private readonly _inner;
    readonly typeString: string;
    constructor(props: StructColumnProps);
    addColumn(column: Column): void;
}
