"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StructColumn = exports.BasicColumn = exports.ArrayColumn = exports.Column = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
class Column {
    constructor(props) {
        this.comment = props.comment;
        this.name = props.name;
    }
    bind(scope) {
        if (!this.name) {
            aws_cdk_lib_1.Annotations.of(scope).addError([
                'Names are required for all Glue Table columns that are not',
                'immediately inside an array',
            ].join(' '));
        }
        return {
            comment: this.comment,
            name: this.name ?? '<unknown>',
            type: this.typeString,
        };
    }
}
exports.Column = Column;
_a = JSII_RTTI_SYMBOL_1;
Column[_a] = { fqn: "cdk-extensions.glue.Column", version: "0.0.12" };
class ArrayColumn extends Column {
    constructor(props) {
        super(props);
        this.typeString = `array<${props.data.typeString}>`;
    }
}
exports.ArrayColumn = ArrayColumn;
_b = JSII_RTTI_SYMBOL_1;
ArrayColumn[_b] = { fqn: "cdk-extensions.glue.ArrayColumn", version: "0.0.12" };
class BasicColumn extends Column {
    constructor(props) {
        super(props);
        this.typeString = props.type;
    }
}
exports.BasicColumn = BasicColumn;
_c = JSII_RTTI_SYMBOL_1;
BasicColumn[_c] = { fqn: "cdk-extensions.glue.BasicColumn", version: "0.0.12" };
class StructColumn extends Column {
    constructor(props) {
        super(props);
        this._inner = [];
        this.typeString = aws_cdk_lib_1.Lazy.string({
            produce: () => {
                const innerTypes = this._inner.map((x) => {
                    if (!x.name) {
                        throw new Error([
                            'Names are required for all Glue Table columns',
                            'that are not immediately inside an array',
                        ].join(' '));
                    }
                    return `${x.name}:${x.typeString}`;
                }).join(',');
                return `struct<${innerTypes}>`;
            },
        });
        props.data?.forEach((x) => {
            this.addColumn(x);
        });
    }
    addColumn(column) {
        this._inner.push(column);
    }
}
exports.StructColumn = StructColumn;
_d = JSII_RTTI_SYMBOL_1;
StructColumn[_d] = { fqn: "cdk-extensions.glue.StructColumn", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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