"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataFormat = exports.ClassificationString = exports.SerializationLibrary = exports.OutputFormat = exports.InputFormat = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// This is copied directly from the CDKv1 code.
// Should be removed when the official CDK implementation reaches a stable state.
/**
 * Absolute class name of the Hadoop `InputFormat` to use when reading table files.
 */
class InputFormat {
    constructor(className) {
        this.className = className;
    }
}
exports.InputFormat = InputFormat;
_a = JSII_RTTI_SYMBOL_1;
InputFormat[_a] = { fqn: "cdk-extensions.glue.InputFormat", version: "0.0.12" };
/**
   * InputFormat for Avro files.
   *
   * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/avro/AvroContainerInputFormat.html
   */
InputFormat.AVRO = new InputFormat('org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat');
/**
   * InputFormat for Cloudtrail Logs.
   *
   * @see https://docs.aws.amazon.com/athena/latest/ug/cloudtrail.html
   */
InputFormat.CLOUDTRAIL = new InputFormat('com.amazon.emr.cloudtrail.CloudTrailInputFormat');
/**
   * InputFormat for Orc files.
   *
   * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/orc/OrcInputFormat.html
   */
InputFormat.ORC = new InputFormat('org.apache.hadoop.hive.ql.io.orc.OrcInputFormat');
/**
   * InputFormat for Parquet files.
   *
   * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/parquet/MapredParquetInputFormat.html
   */
InputFormat.PARQUET = new InputFormat('org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat');
/**
   * An InputFormat for plain text files. Files are broken into lines. Either linefeed or
   * carriage-return are used to signal end of line. Keys are the position in the file, and
   * values are the line of text.
   * JSON & CSV files are examples of this InputFormat
   *
   * @see https://hadoop.apache.org/docs/stable/api/org/apache/hadoop/mapred/TextInputFormat.html
   */
InputFormat.TEXT = new InputFormat('org.apache.hadoop.mapred.TextInputFormat');
/**
   * Absolute class name of the Hadoop `OutputFormat` to use when writing table files.
   */
class OutputFormat {
    constructor(className) {
        this.className = className;
    }
}
exports.OutputFormat = OutputFormat;
_b = JSII_RTTI_SYMBOL_1;
OutputFormat[_b] = { fqn: "cdk-extensions.glue.OutputFormat", version: "0.0.12" };
/**
   * Writes text data with a null key (value only).
   *
   * @see https://hive.apache.org/javadocs/r2.2.0/api/org/apache/hadoop/hive/ql/io/HiveIgnoreKeyTextOutputFormat.html
   */
OutputFormat.HIVE_IGNORE_KEY_TEXT = new OutputFormat('org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat');
/**
   * OutputFormat for Avro files.
   *
   * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/avro/AvroContainerOutputFormat.html
   */
OutputFormat.AVRO = new InputFormat('org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat');
/**
   * OutputFormat for Orc files.
   *
   * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/orc/OrcOutputFormat.html
   */
OutputFormat.ORC = new InputFormat('org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat');
/**
   * OutputFormat for Parquet files.
   *
   * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/parquet/MapredParquetOutputFormat.html
   */
OutputFormat.PARQUET = new OutputFormat('org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat');
/**
   * Serialization library to use when serializing/deserializing (SerDe) table records.
   *
   * @see https://cwiki.apache.org/confluence/display/Hive/SerDe
   */
class SerializationLibrary {
    constructor(className) {
        this.className = className;
    }
}
exports.SerializationLibrary = SerializationLibrary;
_c = JSII_RTTI_SYMBOL_1;
SerializationLibrary[_c] = { fqn: "cdk-extensions.glue.SerializationLibrary", version: "0.0.12" };
/**
   * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/serde2/avro/AvroSerDe.html
   */
SerializationLibrary.AVRO = new SerializationLibrary('org.apache.hadoop.hive.serde2.avro.AvroSerDe');
/**
   * @see https://docs.aws.amazon.com/athena/latest/ug/cloudtrail.html
   */
SerializationLibrary.CLOUDTRAIL = new SerializationLibrary('com.amazon.emr.hive.serde.CloudTrailSerde');
/**
   * @see https://docs.aws.amazon.com/athena/latest/ug/grok.html
   */
SerializationLibrary.GROK = new SerializationLibrary('com.amazonaws.glue.serde.GrokSerDe');
/**
   * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hive/hcatalog/data/JsonSerDe.html
   */
SerializationLibrary.HIVE_JSON = new SerializationLibrary('org.apache.hive.hcatalog.data.JsonSerDe');
/**
   * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/serde2/lazy/LazySimpleSerDe.html
   */
SerializationLibrary.LAZY_SIMPLE = new SerializationLibrary('org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe');
/**
   * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/serde2/OpenCSVSerde.html
   */
SerializationLibrary.OPEN_CSV = new SerializationLibrary('org.apache.hadoop.hive.serde2.OpenCSVSerde');
/**
   * @see https://github.com/rcongiu/Hive-JSON-Serde
   */
SerializationLibrary.OPENX_JSON = new SerializationLibrary('org.openx.data.jsonserde.JsonSerDe');
/**
   * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/orc/OrcSerde.html
   */
SerializationLibrary.ORC = new SerializationLibrary('org.apache.hadoop.hive.ql.io.orc.OrcSerde');
/**
   * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/parquet/serde/ParquetHiveSerDe.html
   */
SerializationLibrary.PARQUET = new SerializationLibrary('org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe');
/**
   * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/serde2/RegexSerDe.html
   */
SerializationLibrary.REGEXP = new SerializationLibrary('org.apache.hadoop.hive.serde2.RegexSerDe');
/**
   * Classification string given to tables with this data format.
   *
   * @see https://docs.aws.amazon.com/glue/latest/dg/add-classifier.html#classifier-built-in
   */
class ClassificationString {
    constructor(value) {
        this.value = value;
    }
}
exports.ClassificationString = ClassificationString;
_d = JSII_RTTI_SYMBOL_1;
ClassificationString[_d] = { fqn: "cdk-extensions.glue.ClassificationString", version: "0.0.12" };
/**
   * @see https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-format.html#aws-glue-programming-etl-format-avro
   */
ClassificationString.AVRO = new ClassificationString('avro');
/**
   * @see https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-format.html#aws-glue-programming-etl-format-csv
   */
ClassificationString.CSV = new ClassificationString('csv');
/**
   * @see https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-format.html#aws-glue-programming-etl-format-json
   */
ClassificationString.JSON = new ClassificationString('json');
/**
   * @see https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-format.html#aws-glue-programming-etl-format-xml
   */
ClassificationString.XML = new ClassificationString('xml');
/**
   * @see https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-format.html#aws-glue-programming-etl-format-parquet
   */
ClassificationString.PARQUET = new ClassificationString('parquet');
/**
   * @see https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-format.html#aws-glue-programming-etl-format-orc
   */
ClassificationString.ORC = new ClassificationString('orc');
/**
   * Defines the input/output formats and ser/de for a single DataFormat.
   */
class DataFormat {
    constructor(props) {
        this.inputFormat = props.inputFormat;
        this.outputFormat = props.outputFormat;
        this.serializationLibrary = props.serializationLibrary;
        this.classificationString = props.classificationString;
    }
}
exports.DataFormat = DataFormat;
_e = JSII_RTTI_SYMBOL_1;
DataFormat[_e] = { fqn: "cdk-extensions.glue.DataFormat", version: "0.0.12" };
/**
   * DataFormat for Apache Web Server Logs. Also works for CloudFront logs
   *
   * @see https://docs.aws.amazon.com/athena/latest/ug/apache.html
   */
DataFormat.APACHE_LOGS = new DataFormat({
    inputFormat: InputFormat.TEXT,
    outputFormat: OutputFormat.HIVE_IGNORE_KEY_TEXT,
    serializationLibrary: SerializationLibrary.REGEXP,
});
/**
   * DataFormat for Apache Avro
   *
   * @see https://docs.aws.amazon.com/athena/latest/ug/avro.html
   */
DataFormat.AVRO = new DataFormat({
    inputFormat: InputFormat.AVRO,
    outputFormat: OutputFormat.AVRO,
    serializationLibrary: SerializationLibrary.AVRO,
    classificationString: ClassificationString.AVRO,
});
/**
   * DataFormat for CloudTrail logs stored on S3
   *
   * @see https://docs.aws.amazon.com/athena/latest/ug/cloudtrail.html
   */
DataFormat.CLOUDTRAIL_LOGS = new DataFormat({
    inputFormat: InputFormat.CLOUDTRAIL,
    outputFormat: OutputFormat.HIVE_IGNORE_KEY_TEXT,
    serializationLibrary: SerializationLibrary.CLOUDTRAIL,
});
/**
   * DataFormat for CSV Files
   *
   * @see https://docs.aws.amazon.com/athena/latest/ug/csv.html
   */
DataFormat.CSV = new DataFormat({
    inputFormat: InputFormat.TEXT,
    outputFormat: OutputFormat.HIVE_IGNORE_KEY_TEXT,
    serializationLibrary: SerializationLibrary.OPEN_CSV,
    classificationString: ClassificationString.CSV,
});
/**
   * Stored as plain text files in JSON format.
   * Uses OpenX Json SerDe for serialization and deseralization.
   *
   * @see https://docs.aws.amazon.com/athena/latest/ug/json.html
   */
DataFormat.JSON = new DataFormat({
    inputFormat: InputFormat.TEXT,
    outputFormat: OutputFormat.HIVE_IGNORE_KEY_TEXT,
    serializationLibrary: SerializationLibrary.OPENX_JSON,
    classificationString: ClassificationString.JSON,
});
/**
   * DataFormat for Logstash Logs, using the GROK SerDe
   *
   * @see https://docs.aws.amazon.com/athena/latest/ug/grok.html
   */
DataFormat.LOGSTASH = new DataFormat({
    inputFormat: InputFormat.TEXT,
    outputFormat: OutputFormat.HIVE_IGNORE_KEY_TEXT,
    serializationLibrary: SerializationLibrary.GROK,
});
/**
   * DataFormat for Apache ORC (Optimized Row Columnar)
   *
   * @see https://docs.aws.amazon.com/athena/latest/ug/orc.html
   */
DataFormat.ORC = new DataFormat({
    inputFormat: InputFormat.ORC,
    outputFormat: OutputFormat.ORC,
    serializationLibrary: SerializationLibrary.ORC,
    classificationString: ClassificationString.ORC,
});
/**
   * DataFormat for Apache Parquet
   *
   * @see https://docs.aws.amazon.com/athena/latest/ug/parquet.html
   */
DataFormat.PARQUET = new DataFormat({
    inputFormat: InputFormat.PARQUET,
    outputFormat: OutputFormat.PARQUET,
    serializationLibrary: SerializationLibrary.PARQUET,
    classificationString: ClassificationString.PARQUET,
});
/**
   * DataFormat for TSV (Tab-Separated Values)
   *
   * @see https://docs.aws.amazon.com/athena/latest/ug/lazy-simple-serde.html
   */
DataFormat.TSV = new DataFormat({
    inputFormat: InputFormat.TEXT,
    outputFormat: OutputFormat.HIVE_IGNORE_KEY_TEXT,
    serializationLibrary: SerializationLibrary.LAZY_SIMPLE,
});
//# sourceMappingURL=data:application/json;base64,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