/**
 * The job type.
 *
 * If you need to use a JobType that doesn't exist as a static member, you
 * can instantiate a `JobType` object, e.g: `JobType.of('other name')`.
 */
export declare class JobType {
    /**
       * Command for running a Glue ETL job.
       */
    static readonly ETL: JobType;
    /**
       * Command for running a Glue streaming job.
       */
    static readonly STREAMING: JobType;
    /**
       * Command for running a Glue python shell job.
       */
    static readonly PYTHON_SHELL: JobType;
    /**
       * Custom type name
       * @param name type name
       */
    static of(name: string): JobType;
    /**
       * The name of this JobType, as expected by Job resource.
       */
    readonly name: string;
    private constructor();
}
