"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JdbcTarget = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
class JdbcTarget {
    constructor(connection, options) {
        // Internal properties
        this._exclusions = [];
        this._paths = [];
        this.connection = connection;
        options.exclusions?.forEach((x) => {
            this.addExclusion(x);
        });
        options.paths?.forEach((x) => {
            this.addPath(x);
        });
    }
    addExclusion(exclusion) {
        this._exclusions.push(exclusion);
    }
    addPath(path) {
        this._paths.push(path);
    }
    bind(_crawler) {
        const paths = !!this._paths.length ? this._paths : [undefined];
        return {
            jdbcTargets: paths.map((x) => {
                return {
                    connectionName: this.connection.connectionName,
                    exclusions: aws_cdk_lib_1.Lazy.uncachedList({
                        produce: () => {
                            return this._exclusions;
                        },
                    }, {
                        omitEmpty: true,
                    }),
                    path: x,
                };
            }),
        };
    }
}
exports.JdbcTarget = JdbcTarget;
_a = JSII_RTTI_SYMBOL_1;
JdbcTarget[_a] = { fqn: "cdk-extensions.glue.JdbcTarget", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiamRiYy10YXJnZXQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvZ2x1ZS9saWIvdGFyZ2V0cy9qZGJjLXRhcmdldC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLDZDQUFtQztBQWFuQyxNQUFhLFVBQVU7SUFTckIsWUFBWSxVQUFzQixFQUFFLE9BQTBCO1FBUjlELHNCQUFzQjtRQUNMLGdCQUFXLEdBQWEsRUFBRSxDQUFDO1FBQzNCLFdBQU0sR0FBYSxFQUFFLENBQUM7UUFPckMsSUFBSSxDQUFDLFVBQVUsR0FBRyxVQUFVLENBQUM7UUFFN0IsT0FBTyxDQUFDLFVBQVUsRUFBRSxPQUFPLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRTtZQUNoQyxJQUFJLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBQ3ZCLENBQUMsQ0FBQyxDQUFDO1FBRUgsT0FBTyxDQUFDLEtBQUssRUFBRSxPQUFPLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRTtZQUMzQixJQUFJLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBQ2xCLENBQUMsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUVNLFlBQVksQ0FBQyxTQUFpQjtRQUNuQyxJQUFJLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNuQyxDQUFDO0lBRU0sT0FBTyxDQUFDLElBQVk7UUFDekIsSUFBSSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDekIsQ0FBQztJQUVNLElBQUksQ0FBQyxRQUFpQjtRQUMzQixNQUFNLEtBQUssR0FBMkIsQ0FBQyxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO1FBRXZGLE9BQU87WUFDTCxXQUFXLEVBQUUsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFO2dCQUMzQixPQUFPO29CQUNMLGNBQWMsRUFBRSxJQUFJLENBQUMsVUFBVSxDQUFDLGNBQWM7b0JBQzlDLFVBQVUsRUFBRSxrQkFBSSxDQUFDLFlBQVksQ0FDM0I7d0JBQ0UsT0FBTyxFQUFFLEdBQUcsRUFBRTs0QkFDWixPQUFPLElBQUksQ0FBQyxXQUFXLENBQUM7d0JBQzFCLENBQUM7cUJBQ0YsRUFDRDt3QkFDRSxTQUFTLEVBQUUsSUFBSTtxQkFDaEIsQ0FDRjtvQkFDRCxJQUFJLEVBQUUsQ0FBQztpQkFDUixDQUFDO1lBQ0osQ0FBQyxDQUFDO1NBQ0gsQ0FBQztJQUNKLENBQUM7O0FBbERILGdDQW1EQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IExhenkgfSBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQgeyBDb25uZWN0aW9uIH0gZnJvbSAnLi4vLi4vY29ubmVjdGlvbic7XG5pbXBvcnQgeyBDcmF3bGVyLCBDcmF3bGVyVGFyZ2V0Q29sbGVjdGlvbiwgSUNyYXdsZXJUYXJnZXQgfSBmcm9tICcuLi8uLi9jcmF3bGVyJztcblxuXG4vKipcbiAqIENvbmZpZ3VyYXRpb24gZm9yIENyYXdsZXIgSkRCQyB0YXJnZXRcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBKZGJjVGFyZ2V0T3B0aW9ucyB7XG4gIHJlYWRvbmx5IGV4Y2x1c2lvbnM/OiBzdHJpbmdbXTtcbiAgcmVhZG9ubHkgcGF0aHM/OiBzdHJpbmdbXTtcbn1cblxuZXhwb3J0IGNsYXNzIEpkYmNUYXJnZXQgaW1wbGVtZW50cyBJQ3Jhd2xlclRhcmdldCB7XG4gIC8vIEludGVybmFsIHByb3BlcnRpZXNcbiAgcHJpdmF0ZSByZWFkb25seSBfZXhjbHVzaW9uczogc3RyaW5nW10gPSBbXTtcbiAgcHJpdmF0ZSByZWFkb25seSBfcGF0aHM6IHN0cmluZ1tdID0gW107XG5cbiAgLy8gSW5wdXQgcHJvcGVydGllc1xuICBwdWJsaWMgcmVhZG9ubHkgY29ubmVjdGlvbjogQ29ubmVjdGlvbjtcblxuXG4gIGNvbnN0cnVjdG9yKGNvbm5lY3Rpb246IENvbm5lY3Rpb24sIG9wdGlvbnM6IEpkYmNUYXJnZXRPcHRpb25zKSB7XG4gICAgdGhpcy5jb25uZWN0aW9uID0gY29ubmVjdGlvbjtcblxuICAgIG9wdGlvbnMuZXhjbHVzaW9ucz8uZm9yRWFjaCgoeCkgPT4ge1xuICAgICAgdGhpcy5hZGRFeGNsdXNpb24oeCk7XG4gICAgfSk7XG5cbiAgICBvcHRpb25zLnBhdGhzPy5mb3JFYWNoKCh4KSA9PiB7XG4gICAgICB0aGlzLmFkZFBhdGgoeCk7XG4gICAgfSk7XG4gIH1cblxuICBwdWJsaWMgYWRkRXhjbHVzaW9uKGV4Y2x1c2lvbjogc3RyaW5nKTogdm9pZCB7XG4gICAgdGhpcy5fZXhjbHVzaW9ucy5wdXNoKGV4Y2x1c2lvbik7XG4gIH1cblxuICBwdWJsaWMgYWRkUGF0aChwYXRoOiBzdHJpbmcpOiB2b2lkIHtcbiAgICB0aGlzLl9wYXRocy5wdXNoKHBhdGgpO1xuICB9XG5cbiAgcHVibGljIGJpbmQoX2NyYXdsZXI6IENyYXdsZXIpOiBDcmF3bGVyVGFyZ2V0Q29sbGVjdGlvbiB7XG4gICAgY29uc3QgcGF0aHM6IChzdHJpbmcgfCB1bmRlZmluZWQpW10gPSAhIXRoaXMuX3BhdGhzLmxlbmd0aCA/IHRoaXMuX3BhdGhzIDogW3VuZGVmaW5lZF07XG5cbiAgICByZXR1cm4ge1xuICAgICAgamRiY1RhcmdldHM6IHBhdGhzLm1hcCgoeCkgPT4ge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgIGNvbm5lY3Rpb25OYW1lOiB0aGlzLmNvbm5lY3Rpb24uY29ubmVjdGlvbk5hbWUsXG4gICAgICAgICAgZXhjbHVzaW9uczogTGF6eS51bmNhY2hlZExpc3QoXG4gICAgICAgICAgICB7XG4gICAgICAgICAgICAgIHByb2R1Y2U6ICgpID0+IHtcbiAgICAgICAgICAgICAgICByZXR1cm4gdGhpcy5fZXhjbHVzaW9ucztcbiAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICB7XG4gICAgICAgICAgICAgIG9taXRFbXB0eTogdHJ1ZSxcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgKSxcbiAgICAgICAgICBwYXRoOiB4LFxuICAgICAgICB9O1xuICAgICAgfSksXG4gICAgfTtcbiAgfVxufSJdfQ==