import { IBucket } from 'aws-cdk-lib/aws-s3';
import { Connection } from '../../connection';
import { Crawler, CrawlerTargetCollection, ICrawlerTarget } from '../../crawler';
/**
 * Configuration for Crawler S3 target
 */
export interface S3TargetOptions {
    readonly connection?: Connection;
    readonly exclusions?: string[];
    readonly keyPrefix?: string;
    readonly sampleSize?: string;
}
export declare class S3Target implements ICrawlerTarget {
    private readonly _exclusions;
    readonly bucket: IBucket;
    readonly connection?: Connection;
    readonly exclusions?: string[];
    readonly keyPrefix?: string;
    readonly sampleSize?: string;
    constructor(bucket: IBucket, options?: S3TargetOptions);
    addExclusion(exclusion: string): void;
    bind(crawler: Crawler): CrawlerTargetCollection;
}
