"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3Target = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
class S3Target {
    constructor(bucket, options) {
        // Internal properties
        this._exclusions = [];
        this.bucket = bucket;
        this.connection = options?.connection;
        this.keyPrefix = options?.keyPrefix;
        this.sampleSize = options?.sampleSize;
        options?.exclusions?.forEach((x) => {
            this.addExclusion(x);
        });
    }
    addExclusion(exclusion) {
        this._exclusions.push(exclusion);
    }
    bind(crawler) {
        crawler.role.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            actions: [
                's3:GetObject',
                's3:PutObject',
            ],
            effect: aws_iam_1.Effect.ALLOW,
            resources: [
                this.bucket.arnForObjects(`${this.keyPrefix ?? ''}*`),
            ],
        }));
        return {
            s3Targets: [{
                    connectionName: this.connection?.connectionName,
                    exclusions: aws_cdk_lib_1.Lazy.uncachedList({
                        produce: () => {
                            return this._exclusions;
                        },
                    }, {
                        omitEmpty: true,
                    }),
                    path: `s3://${this.bucket.bucketName}/${this.keyPrefix ?? ''}`,
                }],
        };
    }
}
exports.S3Target = S3Target;
_a = JSII_RTTI_SYMBOL_1;
S3Target[_a] = { fqn: "cdk-extensions.glue.S3Target", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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