"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Table = exports.TableType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_glue_1 = require("aws-cdk-lib/aws-glue");
const formatting_1 = require("../utils/formatting");
var TableType;
(function (TableType) {
    TableType["EXTERNAL_TABLE"] = "EXTERNAL_TABLE";
    TableType["VIRTUAL_VIEW"] = "VIRTUAL_VIEW";
})(TableType = exports.TableType || (exports.TableType = {}));
class Table extends aws_cdk_lib_1.Resource {
    /**
       * Creates a new instance of the Table class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope, id, props) {
        super(scope, id, props);
        // Internal properties
        this._columns = [];
        this._parameters = {};
        this._partitionKeys = [];
        this._serdeParameters = {};
        this._storageParameters = {};
        this.compressed = props.compressed;
        this.database = props.database;
        this.dataFormat = props.dataFormat;
        this.description = props.description;
        this.location = props.location;
        this.name = props.name;
        this.owner = props.owner;
        this.retention = props.retention;
        this.serdeName = props.serdeName;
        this.tableType = props.tableType;
        this.viewExpandedText = props.viewExpandedText;
        this.viewOriginalText = props.viewOriginalText;
        this.storedAsSubDirectories = props.storedAsSubDirectories;
        Object.keys(props.parameters ?? {}).forEach((x) => {
            this.addParameter(x, props.parameters[x]);
        });
        Object.keys(props.serdeParameters ?? {}).forEach((x) => {
            this.addSerdeParameter(x, props.serdeParameters[x]);
        });
        Object.keys(props.storageParameters ?? {}).forEach((x) => {
            this.addStorageParameter(x, props.storageParameters[x]);
        });
        props.columns?.forEach((x) => {
            this.addColumn(x);
        });
        props.partitionKeys?.forEach((x) => {
            this.addPartitionKey(x);
        });
        this.resource = new aws_glue_1.CfnTable(this, 'Resource', {
            catalogId: this.stack.account,
            databaseName: this.database.databaseName,
            tableInput: {
                description: this.description,
                name: this.name,
                owner: this.owner,
                parameters: aws_cdk_lib_1.Lazy.any({
                    produce: () => {
                        return !!Object.keys(this._parameters).length ? this._parameters : [];
                    },
                }, {
                    omitEmptyArray: true,
                }),
                partitionKeys: aws_cdk_lib_1.Lazy.any({
                    produce: () => {
                        return this._partitionKeys.map((x) => {
                            return x.bind(this);
                        });
                    },
                }, {
                    omitEmptyArray: true,
                }),
                retention: this.retention?.toSeconds(),
                storageDescriptor: aws_cdk_lib_1.Lazy.any({
                    produce: () => {
                        return this.renderStorageDescriptor();
                    },
                }),
                tableType: this.tableType,
                targetTable: !!!this.targetTable ? undefined : {
                    catalogId: this.targetTable.database.catalogId,
                    databaseName: this.targetTable.database.databaseName,
                    name: this.targetTable.tableName,
                },
                viewExpandedText: this.viewExpandedText,
                viewOriginalText: this.viewOriginalText,
            },
        });
        this.tableArn = this.stack.formatArn({
            resource: 'table',
            resourceName: `${this.database.databaseName}/${this.resource.ref}`,
            service: 'glue',
        });
        this.tableName = this.resource.ref;
    }
    addColumn(column) {
        this._columns.push(column);
    }
    addParameter(key, value) {
        this._parameters[key] = value;
    }
    addPartitionKey(column) {
        this._partitionKeys.push(column);
    }
    addSerdeParameter(key, value) {
        this._serdeParameters[key] = value;
    }
    addStorageParameter(key, value) {
        this._storageParameters[key] = value;
    }
    renderStorageDescriptor() {
        return formatting_1.undefinedIfNoKeys({
            columns: !!!this._columns.length ? undefined : this._columns.map((x) => {
                return x.bind(this);
            }),
            compressed: this.compressed,
            inputFormat: this.dataFormat?.inputFormat.className,
            location: this.location,
            outputFormat: this.dataFormat?.outputFormat.className,
            parameters: !!!Object.keys(this._storageParameters).length ? undefined : this._storageParameters,
            serdeInfo: formatting_1.undefinedIfNoKeys({
                name: this.serdeName,
                parameters: formatting_1.undefinedIfNoKeys(this._serdeParameters),
                serializationLibrary: this.dataFormat?.serializationLibrary.className,
            }),
            storedAsSubDirectories: this.storedAsSubDirectories,
        });
    }
}
exports.Table = Table;
_a = JSII_RTTI_SYMBOL_1;
Table[_a] = { fqn: "cdk-extensions.glue.Table", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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