import { Resource, ResourceProps } from 'aws-cdk-lib';
import { Schedule } from 'aws-cdk-lib/aws-events';
import { CfnWorkflow } from 'aws-cdk-lib/aws-glue';
import { Construct } from 'constructs';
import { ITriggerAction, ITriggerPredicate, PredicateOperator, Trigger, TriggerType } from './trigger';
export interface TriggerOptions extends ResourceProps {
    readonly actions?: ITriggerAction[];
    readonly description?: string;
    readonly name?: string;
    readonly predicateConditions?: ITriggerPredicate[];
    readonly predicateOperator?: PredicateOperator;
    readonly schedule?: Schedule;
    readonly startOnCreation?: boolean;
    readonly type: TriggerType;
}
/**
 * Configuration for the Glue Workflow resource.
 */
export interface WorkflowProps extends ResourceProps {
    readonly description?: string;
    readonly name?: string;
}
export declare class Workflow extends Resource {
    readonly description?: string;
    readonly name?: string;
    readonly resource: CfnWorkflow;
    readonly workflowArn: string;
    readonly workflowName: string;
    constructor(scope: Construct, id: string, props: WorkflowProps);
    addTrigger(id: string, options: TriggerOptions): Trigger;
}
