"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Workflow = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_glue_1 = require("aws-cdk-lib/aws-glue");
const trigger_1 = require("./trigger");
class Workflow extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.description = props.description;
        this.name = props.name;
        this.resource = new aws_glue_1.CfnWorkflow(this, 'Resource', {
            description: this.description,
            name: this.name,
        });
        this.workflowArn = this.stack.formatArn({
            resource: 'table',
            resourceName: this.resource.ref,
            service: 'glue',
        });
        this.workflowName = this.resource.ref;
    }
    addTrigger(id, options) {
        return new trigger_1.Trigger(this, `trigger-${id}`, {
            ...options,
            workflow: this,
        });
    }
}
exports.Workflow = Workflow;
_a = JSII_RTTI_SYMBOL_1;
Workflow[_a] = { fqn: "cdk-extensions.glue.Workflow", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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