import { IRole } from 'aws-cdk-lib/aws-iam';
import { CfnDeliveryStream } from 'aws-cdk-lib/aws-kinesisfirehose';
import { IConstruct } from 'constructs';
import { Database, Table } from '../../../glue';
import { InputFormat } from './input-formats';
import { OutputFormat } from './output-formats';
export declare class TableVersion {
    static readonly LATEST: TableVersion;
    static fixed(version: number): TableVersion;
    readonly version: string;
    private constructor();
}
export interface DataFormatConversionOptions {
    readonly catalogId?: string;
    readonly database: Database;
    readonly enabled?: boolean;
    readonly inputFormat: InputFormat;
    readonly outputFormat: OutputFormat;
    readonly region?: string;
    readonly role?: IRole;
    readonly table: Table;
    readonly version?: TableVersion;
}
export declare class DataFormatConversion {
    private _role?;
    readonly catalogId?: string;
    readonly database: Database;
    readonly enabled: boolean;
    readonly inputFormat: InputFormat;
    readonly outputFormat: OutputFormat;
    readonly region?: string;
    readonly table: Table;
    readonly version?: TableVersion;
    get role(): IRole | undefined;
    constructor(options: DataFormatConversionOptions);
    bind(scope: IConstruct): CfnDeliveryStream.DataFormatConversionConfigurationProperty;
}
