"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataFormatConversion = exports.TableVersion = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
class TableVersion {
    constructor(version) {
        this.version = version;
    }
    static fixed(version) {
        if (version < 1 || version > 1024) {
            throw new Error(`Table version  must be between 1 and 1024. Got ${version}`);
        }
        return new TableVersion(version.toString());
    }
}
exports.TableVersion = TableVersion;
_a = JSII_RTTI_SYMBOL_1;
TableVersion[_a] = { fqn: "cdk-extensions.kinesis_firehose.TableVersion", version: "0.0.12" };
TableVersion.LATEST = new TableVersion('LATEST');
class DataFormatConversion {
    constructor(options) {
        this.catalogId = options.catalogId;
        this.database = options.database;
        this.enabled = options.enabled ?? true;
        this.inputFormat = options.inputFormat;
        this.outputFormat = options.outputFormat;
        this.region = options.region;
        this._role = options.role;
        this.table = options.table;
        this.version = options.version;
    }
    // Internal accessors
    get role() {
        return this._role;
    }
    bind(scope) {
        const role = this.role ?? new aws_iam_1.Role(scope, 'delivery-stream-data-format-conversion-role', {
            assumedBy: new aws_iam_1.PrincipalWithConditions(new aws_iam_1.ServicePrincipal('firehose.amazonaws.com'), {
                StringEquals: {
                    'sts:ExternalId': aws_cdk_lib_1.Stack.of(scope).account,
                },
            }),
            description: 'Grants permissions to Kinesis Firehose to access Glue.',
        });
        role.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            actions: [
                'glue:GetTableVersions',
            ],
            effect: aws_iam_1.Effect.ALLOW,
            resources: [
                aws_cdk_lib_1.Stack.of(this.database).formatArn({
                    arnFormat: aws_cdk_lib_1.ArnFormat.NO_RESOURCE_NAME,
                    resource: 'catalog',
                    service: 'glue',
                }),
                this.database.databaseArn,
                this.table.tableArn,
            ],
        }));
        this._role = role;
        return {
            enabled: this.enabled,
            inputFormatConfiguration: this.inputFormat.bind(scope),
            outputFormatConfiguration: this.outputFormat.bind(scope),
            schemaConfiguration: {
                catalogId: this.catalogId ?? aws_cdk_lib_1.Stack.of(scope).account,
                databaseName: this.database.databaseName,
                region: this.region,
                roleArn: role.roleArn,
                tableName: this.table.tableName,
                versionId: this.version?.version,
            },
        };
    }
}
exports.DataFormatConversion = DataFormatConversion;
_b = JSII_RTTI_SYMBOL_1;
DataFormatConversion[_b] = { fqn: "cdk-extensions.kinesis_firehose.DataFormatConversion", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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