import { CfnDeliveryStream } from 'aws-cdk-lib/aws-kinesisfirehose';
import { IConstruct } from 'constructs';
export interface HiveJsonInputSerDeOptions {
    readonly timestampFormats?: string[];
}
export interface OpenxJsonInputSerDeOptions {
    readonly caseInsensitive?: boolean;
    readonly columnKeyMappings?: {
        [key: string]: string;
    };
    readonly convertDotsToUnderscores?: boolean;
}
export declare abstract class InputFormat {
    static hiveJson(options: HiveJsonInputSerDeOptions): HiveJsonInputSerDe;
    static openxJson(options: OpenxJsonInputSerDeOptions): OpenxJsonInputSerDe;
    abstract bind(scope: IConstruct): CfnDeliveryStream.InputFormatConfigurationProperty;
}
export declare class HiveJsonInputSerDe extends InputFormat {
    private readonly _timestampFormats;
    constructor(options?: HiveJsonInputSerDeOptions);
    addTimestampFormat(format: string): HiveJsonInputSerDe;
    bind(_scope: IConstruct): CfnDeliveryStream.InputFormatConfigurationProperty;
}
export declare class OpenxJsonInputSerDe extends InputFormat {
    private readonly _columnKeyMappings;
    readonly caseInsensitive?: boolean;
    readonly convertDotsToUnderscores?: boolean;
    constructor(options?: OpenxJsonInputSerDeOptions);
    addColumnKeyMapping(columnName: string, jsonKey: string): OpenxJsonInputSerDe;
    bind(_scope: IConstruct): CfnDeliveryStream.InputFormatConfigurationProperty;
}
