import { CfnDeliveryStream } from 'aws-cdk-lib/aws-kinesisfirehose';
import { IConstruct } from 'constructs';
export declare enum OrcCompressionFormat {
    NONE = "NONE",
    SNAPPY = "SNAPPY",
    ZLIB = "ZLIB"
}
export declare enum OrcFormatVersion {
    V0_11 = "V0_11",
    V0_12 = "V0_12"
}
export declare enum ParquetCompressionFormat {
    GZIP = "GZIP",
    SNAPPY = "SNAPPY",
    UNCOMPRESSED = "UNCOMPRESSED"
}
export declare enum ParquetWriterVersion {
    V1 = "V1",
    V2 = "V2"
}
export interface OrcOutputSerDeOptions {
    readonly blockSizeBytes?: number;
    readonly bloomFilterColumns?: string[];
    readonly bloomFilterFalsePositiveProbability?: number;
    readonly compression?: OrcCompressionFormat;
    readonly dictionaryKeyThreshold?: number;
    readonly enablePadding?: boolean;
    readonly formatVersion?: OrcFormatVersion;
    readonly paddingTolerance?: number;
    readonly rowIndexStride?: number;
    readonly stripeSizeBytes?: number;
}
export interface ParquetOutputSerDeOptions {
    readonly blockSizeBytes?: number;
    readonly compression?: ParquetCompressionFormat;
    readonly enableDictionaryCompression?: boolean;
    readonly maxPaddingBytes?: number;
    readonly pageSizeBytes?: number;
    readonly writerVersion?: ParquetWriterVersion;
}
export declare abstract class OutputFormat {
    static orc(options: OrcOutputSerDeOptions): OrcOutputSerDe;
    static parquet(options: ParquetOutputSerDeOptions): ParquetOutputSerDe;
    abstract bind(scope: IConstruct): CfnDeliveryStream.OutputFormatConfigurationProperty;
}
export declare class OrcOutputSerDe extends OutputFormat {
    private readonly _bloomFilterColumns;
    readonly blockSizeBytes?: number;
    readonly bloomFilterColumns?: string[];
    readonly bloomFilterFalsePositiveProbability?: number;
    readonly compression?: OrcCompressionFormat;
    readonly dictionaryKeyThreshold?: number;
    readonly enablePadding?: boolean;
    readonly formatVersion?: OrcFormatVersion;
    readonly paddingTolerance?: number;
    readonly rowIndexStride?: number;
    readonly stripeSizeBytes?: number;
    constructor(options?: OrcOutputSerDeOptions);
    addBloomFilterColumn(column: string): OrcOutputSerDe;
    bind(_scope: IConstruct): CfnDeliveryStream.OutputFormatConfigurationProperty;
}
export declare class ParquetOutputSerDe extends OutputFormat {
    readonly blockSizeBytes?: number;
    readonly compression?: ParquetCompressionFormat;
    readonly enableDictionaryCompression?: boolean;
    readonly maxPaddingBytes?: number;
    readonly pageSizeBytes?: number;
    readonly writerVersion?: ParquetWriterVersion;
    constructor(options?: ParquetOutputSerDeOptions);
    bind(_scope: IConstruct): CfnDeliveryStream.OutputFormatConfigurationProperty;
}
