import { CfnDeliveryStream } from 'aws-cdk-lib/aws-kinesisfirehose';
import { IBucket } from 'aws-cdk-lib/aws-s3';
import { IConstruct } from 'constructs';
import { BackupConfiguration } from '../backup-configuration';
import { DataFormatConversion } from '../data-format-processing/data-format-conversion';
import { DynamicPartitioning } from '../dynamic-partitioning';
import { ProcessorConfiguration } from '../processor-configuration';
import { DeliveryStreamProcessor } from '../processors/delivery-stream-processor';
import { DeliveryStreamDestinationConfiguration } from './delivery-stream-destination';
import { S3Destination, S3DestinationOptions } from './s3-destination';
export interface ExtendedS3DestinationOptions extends S3DestinationOptions {
    readonly backupConfiguration?: BackupConfiguration;
    readonly dataFormatConversion?: DataFormatConversion;
    readonly dynamicPartitioning?: DynamicPartitioning;
    readonly processorConfiguration?: ProcessorConfiguration;
}
export declare class ExtendedS3Destination extends S3Destination {
    private _processingEnabled?;
    private _processors;
    readonly backupConfiguration?: BackupConfiguration;
    readonly dataFormatConversion?: DataFormatConversion;
    readonly dynamicPartitioning?: DynamicPartitioning;
    readonly processorConfiguration?: ProcessorConfiguration;
    get processingEnabled(): boolean;
    get processors(): DeliveryStreamProcessor[];
    constructor(bucket: IBucket, options?: ExtendedS3DestinationOptions);
    addProcessor(processor: DeliveryStreamProcessor): ExtendedS3Destination;
    bind(scope: IConstruct): DeliveryStreamDestinationConfiguration;
    protected renderProcessorConfiguration(scope: IConstruct): CfnDeliveryStream.ProcessingConfigurationProperty | undefined;
}
