import { Duration, SecretValue } from 'aws-cdk-lib';
import { IRole } from 'aws-cdk-lib/aws-iam';
import { CfnDeliveryStream } from 'aws-cdk-lib/aws-kinesisfirehose';
import { IConstruct } from 'constructs';
import { BackupConfiguration } from '../backup-configuration';
import { BufferingConfiguration } from '../buffering-configuration';
import { CloudWatchLoggingConfiguration } from '../cloudwatch-logging-configuration';
import { ProcessorConfiguration } from '../processor-configuration';
import { DeliveryStreamProcessor } from '../processors/delivery-stream-processor';
import { DeliveryStreamDestination, DeliveryStreamDestinationConfiguration } from './delivery-stream-destination';
export declare enum ContentEncoding {
    GZIP = "GZIP",
    NONE = "NONE"
}
export interface HttpEndpointDestinationOptions {
    readonly accessKey?: SecretValue;
    readonly backupConfiguration?: BackupConfiguration;
    readonly buffering?: BufferingConfiguration;
    readonly cloudwatchLoggingConfiguration?: CloudWatchLoggingConfiguration;
    readonly commonAttributes?: {
        [name: string]: string;
    };
    readonly contentEncoding?: ContentEncoding;
    readonly endpointName?: string;
    readonly processorConfiguration?: ProcessorConfiguration;
    readonly retryDuration?: Duration;
}
export declare class HttpEndpointDestination extends DeliveryStreamDestination {
    private readonly _commonAttributes;
    private _processingEnabled?;
    private _processors;
    private _role?;
    readonly accessKey?: SecretValue;
    readonly backupConfiguration?: BackupConfiguration;
    readonly buffering?: BufferingConfiguration;
    readonly cloudwatchLoggingConfiguration?: CloudWatchLoggingConfiguration;
    readonly commonAttributes?: {
        [name: string]: string;
    };
    readonly contentEncoding?: ContentEncoding;
    readonly endpointName?: string;
    readonly endpointUrl: string;
    readonly processorConfiguration?: ProcessorConfiguration;
    readonly retryDuration?: Duration;
    get processingEnabled(): boolean;
    get role(): IRole | undefined;
    constructor(url: string, options?: HttpEndpointDestinationOptions);
    addCommonAttribute(name: string, value: string): HttpEndpointDestination;
    addProcessor(processor: DeliveryStreamProcessor): HttpEndpointDestination;
    bind(scope: IConstruct): DeliveryStreamDestinationConfiguration;
    protected buildBackupConfiguration(scope: IConstruct): BackupConfiguration;
    protected getOrCreateRole(scope: IConstruct): IRole;
    protected renderProcessorConfiguration(scope: IConstruct): CfnDeliveryStream.ProcessingConfigurationProperty | undefined;
}
